/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.activitydiagram3.Branch;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractConnection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond.FtileSwitchWithDiamonds;
import net.sourceforge.plantuml.graphic.Rainbow;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.VerticalAlignment;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class FtileSwitchWithManyLinks
extends FtileSwitchWithDiamonds {
    private final Rainbow arrowColor;
    private final double margin = 10.0;

    public FtileSwitchWithManyLinks(List<Ftile> tiles, List<Branch> branches, Swimlane in, Ftile diamond1, Ftile diamond2, StringBounder stringBounder, Rainbow arrowColor) {
        super(tiles, branches, in, diamond1, diamond2, stringBounder);
        this.arrowColor = arrowColor;
    }

    @Override
    public double getYdelta1a(StringBounder stringBounder) {
        double max = 10.0;
        for (Branch branch : this.branches) {
            max = Math.max(max, this.getLabelPositive(branch).calculateDimension(stringBounder).getHeight());
        }
        return max + 10.0;
    }

    public Ftile addLinks() {
        ArrayList<Connection> conns = new ArrayList<Connection>();
        conns.add(new ConnectionHorizontalThenVertical((Ftile)this.tiles.get(0), (Branch)this.branches.get(0)));
        conns.add(new ConnectionHorizontalThenVertical((Ftile)this.tiles.get(this.tiles.size() - 1), (Branch)this.branches.get(this.tiles.size() - 1)));
        conns.add(new ConnectionVerticalThenHorizontal((Ftile)this.tiles.get(0)));
        conns.add(new ConnectionVerticalThenHorizontal((Ftile)this.tiles.get(this.tiles.size() - 1)));
        for (int i = 1; i < this.tiles.size() - 1; ++i) {
            conns.add(new ConnectionVerticalTop((Ftile)this.tiles.get(i), (Branch)this.branches.get(i)));
            conns.add(new ConnectionVerticalBottom((Ftile)this.tiles.get(i)));
        }
        return FtileUtils.addConnection((Ftile)this, conns);
    }

    class ConnectionHorizontalThenVertical
    extends AbstractConnection {
        private final Branch branch;

        public ConnectionHorizontalThenVertical(Ftile tile, Branch branch) {
            super(FtileSwitchWithManyLinks.this.diamond1, tile);
            this.branch = branch;
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            Point2D p1 = this.getP1(stringBounder);
            Point2D p2 = this.getP2(stringBounder);
            double x1 = p1.getX();
            double y1 = p1.getY();
            double x2 = p2.getX();
            double y2 = p2.getY();
            Snake snake = Snake.create(null, FtileSwitchWithManyLinks.this.arrowColor, Arrows.asToDown()).withLabel(FtileSwitchWithManyLinks.this.getLabelPositive(this.branch), this.arrowHorizontalAlignment());
            snake.addPoint(x1, y1);
            snake.addPoint(x2, y1);
            snake.addPoint(x2, y2);
            ug.draw(snake);
        }

        private Point2D getP1(StringBounder stringBounder) {
            Point2D pt;
            FtileGeometry dimDiamond1 = FtileSwitchWithManyLinks.this.diamond1.calculateDimension(stringBounder);
            if (this.getFtile2() == FtileSwitchWithManyLinks.this.tiles.get(0)) {
                pt = dimDiamond1.getPointD();
            } else if (this.getFtile2() == FtileSwitchWithManyLinks.this.tiles.get(FtileSwitchWithManyLinks.this.tiles.size() - 1)) {
                pt = dimDiamond1.getPointB();
            } else {
                throw new IllegalStateException();
            }
            return FtileSwitchWithManyLinks.this.getTranslateDiamond1(stringBounder).getTranslated(pt);
        }

        private Point2D getP2(StringBounder stringBounder) {
            return FtileSwitchWithManyLinks.this.getTranslateOf(this.getFtile2(), stringBounder).getTranslated(this.getFtile2().calculateDimension(stringBounder).getPointIn());
        }
    }

    class ConnectionVerticalThenHorizontal
    extends AbstractConnection {
        public ConnectionVerticalThenHorizontal(Ftile tile) {
            super(tile, FtileSwitchWithManyLinks.this.diamond2);
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            FtileGeometry geo = this.getFtile1().calculateDimension(stringBounder);
            if (!geo.hasPointOut()) {
                return;
            }
            Point2D p1 = this.getP1(stringBounder);
            Point2D p2 = this.getP2(stringBounder);
            double x1 = p1.getX();
            double y1 = p1.getY();
            double x2 = p2.getX();
            double y2 = p2.getY();
            UPolygon arrow = x2 > x1 ? Arrows.asToRight() : Arrows.asToLeft();
            Snake snake = Snake.create(FtileSwitchWithManyLinks.this.arrowColor, arrow);
            snake.addPoint(x1, y1);
            snake.addPoint(x1, y2);
            snake.addPoint(x2, y2);
            ug.draw(snake);
        }

        private Point2D getP1(StringBounder stringBounder) {
            return FtileSwitchWithManyLinks.this.getTranslateOf(this.getFtile1(), stringBounder).getTranslated(this.getFtile1().calculateDimension(stringBounder).getPointOut());
        }

        private Point2D getP2(StringBounder stringBounder) {
            Point2D pt;
            FtileGeometry dimDiamond2 = FtileSwitchWithManyLinks.this.diamond2.calculateDimension(stringBounder);
            if (this.getFtile1() == FtileSwitchWithManyLinks.this.tiles.get(0)) {
                pt = dimDiamond2.getPointD();
            } else if (this.getFtile1() == FtileSwitchWithManyLinks.this.tiles.get(FtileSwitchWithManyLinks.this.tiles.size() - 1)) {
                pt = dimDiamond2.getPointB();
            } else {
                throw new IllegalStateException();
            }
            return FtileSwitchWithManyLinks.this.getTranslateDiamond2(stringBounder).getTranslated(pt);
        }
    }

    class ConnectionVerticalTop
    extends AbstractConnection {
        private final Branch branch;

        public ConnectionVerticalTop(Ftile tile, Branch branch) {
            super(FtileSwitchWithManyLinks.this.diamond1, tile);
            this.branch = branch;
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            FtileGeometry dimDiamond1 = FtileSwitchWithManyLinks.this.diamond1.calculateDimension(stringBounder);
            UTranslate translateDiamond1 = FtileSwitchWithManyLinks.this.getTranslateDiamond1(stringBounder);
            Point2D p1b = translateDiamond1.getTranslated(dimDiamond1.getPointB());
            Point2D p1c = translateDiamond1.getTranslated(dimDiamond1.getPointC());
            Point2D p1d = translateDiamond1.getTranslated(dimDiamond1.getPointD());
            Point2D p2 = this.getP2(stringBounder);
            double x2 = p2.getX();
            double y2 = p2.getY();
            Snake snake = Snake.create(null, FtileSwitchWithManyLinks.this.arrowColor, Arrows.asToDown()).withLabel(FtileSwitchWithManyLinks.this.getLabelPositive(this.branch), VerticalAlignment.BOTTOM);
            if (x2 < p1d.getX() - 10.0 || x2 > p1b.getX() + 10.0) {
                snake.addPoint(x2, p1d.getY());
                snake.addPoint(x2, y2);
            } else {
                double x1 = p1c.getX();
                double y1 = p1c.getY();
                double ym = (y1 * 2.0 + y2) / 3.0;
                snake.addPoint(x1, y1);
                snake.addPoint(x1, ym);
                snake.addPoint(x2, ym);
                snake.addPoint(x2, y2);
            }
            ug.draw(snake);
        }

        private Point2D getP2(StringBounder stringBounder) {
            return FtileSwitchWithManyLinks.this.getTranslateOf(this.getFtile2(), stringBounder).getTranslated(this.getFtile2().calculateDimension(stringBounder).getPointIn());
        }
    }

    class ConnectionVerticalBottom
    extends AbstractConnection {
        public ConnectionVerticalBottom(Ftile tile) {
            super(tile, FtileSwitchWithManyLinks.this.diamond2);
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            Point2D p1 = this.getP1(stringBounder);
            FtileGeometry dimDiamond2 = FtileSwitchWithManyLinks.this.diamond2.calculateDimension(stringBounder);
            UTranslate translateDiamond2 = FtileSwitchWithManyLinks.this.getTranslateDiamond2(stringBounder);
            Point2D p2a = translateDiamond2.getTranslated(dimDiamond2.getPointA());
            Point2D p2b = translateDiamond2.getTranslated(dimDiamond2.getPointB());
            Point2D p2d = translateDiamond2.getTranslated(dimDiamond2.getPointD());
            FtileGeometry dimDiamond1 = FtileSwitchWithManyLinks.this.diamond1.calculateDimension(stringBounder);
            UTranslate translateDiamond1 = FtileSwitchWithManyLinks.this.getTranslateDiamond1(stringBounder);
            Point2D p1b = translateDiamond1.getTranslated(dimDiamond1.getPointB());
            Point2D p1c = translateDiamond1.getTranslated(dimDiamond1.getPointC());
            Point2D p1d = translateDiamond1.getTranslated(dimDiamond1.getPointD());
            double x1 = p1.getX();
            double y1 = p1.getY();
            double x2 = p2a.getX();
            double y2 = p2a.getY();
            double ym = (y1 + y2) / 2.0;
            Snake snake = Snake.create(null, FtileSwitchWithManyLinks.this.arrowColor, Arrows.asToDown());
            if (x1 < p1d.getX() - 10.0 || x1 > p1b.getX() + 10.0) {
                snake.addPoint(x1, y1);
                snake.addPoint(x1, p2d.getY());
            } else {
                snake.addPoint(x1, y1);
                snake.addPoint(x1, ym);
                snake.addPoint(x2, ym);
                snake.addPoint(x2, y2);
            }
            ug.draw(snake);
        }

        private Point2D getP1(StringBounder stringBounder) {
            return FtileSwitchWithManyLinks.this.getTranslateOf(this.getFtile1(), stringBounder).getTranslated(this.getFtile1().calculateDimension(stringBounder).getPointOut());
        }
    }
}

