/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah;

import com.googlecode.javaewah.BitmapStorage;
import com.googlecode.javaewah.EWAHCompressedBitmap;
import com.googlecode.javaewah.IntIterator;
import com.googlecode.javaewah.IntIteratorOverIteratingRLW;
import com.googlecode.javaewah.IteratingBufferedRunningLengthWord;
import com.googlecode.javaewah.IteratingRLW;
import java.util.Iterator;

public final class IteratorUtil {
    private IteratorUtil() {
    }

    public static IntIterator toSetBitsIntIterator(IteratingRLW i) {
        return new IntIteratorOverIteratingRLW(i);
    }

    public static Iterator<Integer> toSetBitsIterator(final IteratingRLW i) {
        return new Iterator<Integer>(){
            private final IntIterator under;
            {
                this.under = IteratorUtil.toSetBitsIntIterator(i);
            }

            @Override
            public boolean hasNext() {
                return this.under.hasNext();
            }

            @Override
            public Integer next() {
                return this.under.next();
            }

            @Override
            public void remove() {
            }
        };
    }

    public static void materialize(IteratingRLW i, BitmapStorage c) {
        do {
            if (i.getRunningLength() > 0L) {
                c.addStreamOfEmptyWords(i.getRunningBit(), i.getRunningLength());
            }
            int il = i.getNumberOfLiteralWords();
            for (int k = 0; k < il; ++k) {
                c.addWord(i.getLiteralWordAt(k));
            }
        } while (i.next());
    }

    public static int cardinality(IteratingRLW i) {
        int answer = 0;
        do {
            if (i.getRunningBit()) {
                answer = (int)((long)answer + i.getRunningLength() * 64L);
            }
            int lw = i.getNumberOfLiteralWords();
            for (int k = 0; k < lw; ++k) {
                answer += Long.bitCount(i.getLiteralWordAt(k));
            }
        } while (i.next());
        return answer;
    }

    public static IteratingRLW[] toIterators(EWAHCompressedBitmap ... x) {
        IteratingRLW[] X = new IteratingRLW[x.length];
        for (int k = 0; k < X.length; ++k) {
            X[k] = new IteratingBufferedRunningLengthWord(x[k]);
        }
        return X;
    }

    public static long materialize(IteratingRLW i, BitmapStorage c, long max) {
        long origMax = max;
        do {
            long L;
            if (i.getRunningLength() > 0L) {
                L = i.getRunningLength();
                if (L > max) {
                    L = max;
                }
                c.addStreamOfEmptyWords(i.getRunningBit(), L);
                max -= L;
            }
            L = i.getNumberOfLiteralWords();
            int k = 0;
            while ((long)k < L) {
                c.addWord(i.getLiteralWordAt(k));
                ++k;
            }
        } while (max > 0L && i.next());
        return origMax - max;
    }

    public static EWAHCompressedBitmap materialize(IteratingRLW i) {
        EWAHCompressedBitmap ewah = new EWAHCompressedBitmap();
        IteratorUtil.materialize(i, ewah);
        return ewah;
    }
}

