/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.websocket;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import org.apache.catalina.websocket.WsFrame;
import org.apache.catalina.websocket.WsInputStream;
import org.apache.catalina.websocket.WsOutbound;
import org.apache.coyote.http11.upgrade.UpgradeInbound;
import org.apache.coyote.http11.upgrade.UpgradeOutbound;
import org.apache.coyote.http11.upgrade.UpgradeProcessor;
import org.apache.tomcat.util.buf.Utf8Decoder;
import org.apache.tomcat.util.net.AbstractEndpoint;

@Deprecated
public abstract class StreamInbound
implements UpgradeInbound {
    private final ClassLoader applicationClassLoader = Thread.currentThread().getContextClassLoader();
    private UpgradeProcessor<?> processor = null;
    private WsOutbound outbound;
    private int outboundByteBufferSize = 8192;
    private int outboundCharBufferSize = 8192;

    public int getOutboundByteBufferSize() {
        return this.outboundByteBufferSize;
    }

    public void setOutboundByteBufferSize(int n) {
        this.outboundByteBufferSize = n;
    }

    public int getOutboundCharBufferSize() {
        return this.outboundCharBufferSize;
    }

    public void setOutboundCharBufferSize(int n) {
        this.outboundCharBufferSize = n;
    }

    public final void setUpgradeOutbound(UpgradeOutbound upgradeOutbound) {
        this.outbound = new WsOutbound(upgradeOutbound, this, this.outboundByteBufferSize, this.outboundCharBufferSize);
    }

    public final void setUpgradeProcessor(UpgradeProcessor<?> upgradeProcessor) {
        this.processor = upgradeProcessor;
    }

    public final WsOutbound getWsOutbound() {
        return this.outbound;
    }

    public final AbstractEndpoint.Handler.SocketState onData() throws IOException {
        WsInputStream wsInputStream = new WsInputStream(this.processor, this.getWsOutbound());
        try {
            WsFrame wsFrame = wsInputStream.nextFrame(false);
            while (wsFrame != null) {
                if (wsFrame.getRsv() > 0) {
                    this.closeOutboundConnection(1002, null);
                    return AbstractEndpoint.Handler.SocketState.CLOSED;
                }
                byte by = wsFrame.getOpCode();
                if (by == 2) {
                    this.doOnBinaryData(wsInputStream);
                } else if (by == 1) {
                    InputStreamReader inputStreamReader = new InputStreamReader((InputStream)wsInputStream, (CharsetDecoder)new Utf8Decoder());
                    this.doOnTextData(inputStreamReader);
                } else {
                    if (by == 8) {
                        this.closeOutboundConnection(wsFrame);
                        return AbstractEndpoint.Handler.SocketState.CLOSED;
                    }
                    if (by == 9) {
                        this.getWsOutbound().pong(wsFrame.getPayLoad());
                    } else if (by == 10) {
                        this.doOnPong(wsFrame.getPayLoad());
                    } else {
                        this.closeOutboundConnection(1002, null);
                        return AbstractEndpoint.Handler.SocketState.CLOSED;
                    }
                }
                wsFrame = wsInputStream.nextFrame(false);
            }
        }
        catch (MalformedInputException malformedInputException) {
            this.closeOutboundConnection(1007, null);
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        catch (UnmappableCharacterException unmappableCharacterException) {
            this.closeOutboundConnection(1007, null);
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        catch (IOException iOException) {
            this.closeOutboundConnection(1002, null);
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        return AbstractEndpoint.Handler.SocketState.UPGRADED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOnBinaryData(InputStream inputStream) throws IOException {
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(this.applicationClassLoader);
        try {
            this.onBinaryData(inputStream);
        }
        finally {
            thread.setContextClassLoader(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOnTextData(Reader reader) throws IOException {
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(this.applicationClassLoader);
        try {
            this.onTextData(reader);
        }
        finally {
            thread.setContextClassLoader(classLoader);
        }
    }

    private void closeOutboundConnection(int n, ByteBuffer byteBuffer) throws IOException {
        try {
            this.getWsOutbound().close(n, byteBuffer);
        }
        finally {
            this.doOnClose(n);
        }
    }

    private void closeOutboundConnection(WsFrame wsFrame) throws IOException {
        try {
            this.getWsOutbound().close(wsFrame);
        }
        finally {
            this.doOnClose(1000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doOnClose(int n) {
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(this.applicationClassLoader);
        try {
            this.onClose(n);
        }
        finally {
            thread.setContextClassLoader(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOnPong(ByteBuffer byteBuffer) {
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(this.applicationClassLoader);
        try {
            this.onPong(byteBuffer);
        }
        finally {
            thread.setContextClassLoader(classLoader);
        }
    }

    public final void onUpgradeComplete() {
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(this.applicationClassLoader);
        try {
            this.onOpen(this.outbound);
        }
        finally {
            thread.setContextClassLoader(classLoader);
        }
    }

    protected void onOpen(WsOutbound wsOutbound) {
    }

    protected void onClose(int n) {
    }

    protected void onPong(ByteBuffer byteBuffer) {
    }

    protected abstract void onBinaryData(InputStream var1) throws IOException;

    protected abstract void onTextData(Reader var1) throws IOException;

    public int getReadTimeout() {
        return -1;
    }
}

