/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.intrinsics;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.intrinsics.Ieee754Equals;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IrIntrinsicFunction;
import org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.ir.descriptors.IrBasedDescriptorsKt;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/Ieee754Equals;", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicMethod;", "operandType", "Lorg/jetbrains/org/objectweb/asm/Type;", "(Lorg/jetbrains/org/objectweb/asm/Type;)V", "boxedOperandType", "getOperandType", "()Lorg/jetbrains/org/objectweb/asm/Type;", "toCallable", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IrIntrinsicFunction;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "signature", "Lorg/jetbrains/kotlin/resolve/jvm/jvmSignature/JvmMethodSignature;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "backend.jvm"})
public final class Ieee754Equals
extends IntrinsicMethod {
    @NotNull
    private final Type operandType;
    @NotNull
    private final Type boxedOperandType;

    public Ieee754Equals(@NotNull Type operandType) {
        Intrinsics.checkNotNullParameter(operandType, "operandType");
        this.operandType = operandType;
        Type type2 = AsmUtil.boxType(this.operandType);
        Intrinsics.checkNotNullExpressionValue(type2, "boxType(operandType)");
        this.boxedOperandType = type2;
    }

    @NotNull
    public final Type getOperandType() {
        return this.operandType;
    }

    @Override
    @NotNull
    public IrIntrinsicFunction toCallable(@NotNull IrFunctionAccessExpression expression2, @NotNull JvmMethodSignature signature2, @NotNull JvmBackendContext context2) {
        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\r"}, d2={"org/jetbrains/kotlin/backend/jvm/intrinsics/Ieee754Equals$toCallable$Ieee754AreEqual", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IrIntrinsicFunction;", "left", "Lorg/jetbrains/org/objectweb/asm/Type;", "right", "(Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;Lorg/jetbrains/kotlin/resolve/jvm/jvmSignature/JvmMethodSignature;Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;Lorg/jetbrains/org/objectweb/asm/Type;Lorg/jetbrains/org/objectweb/asm/Type;)V", "getLeft", "()Lorg/jetbrains/org/objectweb/asm/Type;", "getRight", "genInvokeInstruction", "", "v", "Lorg/jetbrains/org/objectweb/asm/commons/InstructionAdapter;", "backend.jvm"})
        public final class Ieee754AreEqual
        extends IrIntrinsicFunction {
            @NotNull
            private final Type left;
            @NotNull
            private final Type right;
            final /* synthetic */ IrFunctionAccessExpression $expression;
            final /* synthetic */ JvmMethodSignature $signature;
            final /* synthetic */ JvmBackendContext $context;

            public Ieee754AreEqual(@NotNull IrFunctionAccessExpression $expression, @NotNull JvmMethodSignature $signature, @NotNull JvmBackendContext $context, @NotNull Type left, @NotNull Type right) {
                Intrinsics.checkNotNullParameter($expression, "$expression");
                Intrinsics.checkNotNullParameter($signature, "$signature");
                Intrinsics.checkNotNullParameter($context, "$context");
                Intrinsics.checkNotNullParameter(left, "left");
                Intrinsics.checkNotNullParameter(right, "right");
                this.$expression = $expression;
                this.$signature = $signature;
                this.$context = $context;
                Type[] typeArray = new Type[]{left, right};
                super($expression, $signature, $context, CollectionsKt.listOf(typeArray));
                this.left = left;
                this.right = right;
            }

            @NotNull
            public final Type getLeft() {
                return this.left;
            }

            @NotNull
            public final Type getRight() {
                return this.right;
            }

            public void genInvokeInstruction(@NotNull InstructionAdapter v) {
                Intrinsics.checkNotNullParameter(v, "v");
                Type[] typeArray = new Type[]{this.left, this.right};
                v.invokestatic("kotlin/jvm/internal/Intrinsics", "areEqual", Type.getMethodDescriptor(Type.BOOLEAN_TYPE, typeArray), false);
            }
        }
        IrIntrinsicFunction irIntrinsicFunction;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(signature2, "signature");
        Intrinsics.checkNotNullParameter(context2, "context");
        IrExpression irExpression = expression2.getValueArgument(0);
        Intrinsics.checkNotNull(irExpression);
        IrExpression arg0 = irExpression;
        IrExpression irExpression2 = expression2.getValueArgument(1);
        Intrinsics.checkNotNull(irExpression2);
        IrExpression arg1 = irExpression2;
        KotlinType arg0Type = IrBasedDescriptorsKt.toIrBasedKotlinType(arg0.getType());
        if (!TypeUtilsKt.isPrimitiveNumberOrNullableType(arg0Type) && !TypeUtilsKt.upperBoundedByPrimitiveNumberOrNullableType(arg0Type)) {
            throw new AssertionError((Object)Intrinsics.stringPlus("Should be primitive or nullable primitive type: ", arg0Type));
        }
        KotlinType arg1Type = IrBasedDescriptorsKt.toIrBasedKotlinType(arg1.getType());
        if (!TypeUtilsKt.isPrimitiveNumberOrNullableType(arg1Type) && !TypeUtilsKt.upperBoundedByPrimitiveNumberOrNullableType(arg1Type)) {
            throw new AssertionError((Object)Intrinsics.stringPlus("Should be primitive or nullable primitive type: ", arg1Type));
        }
        boolean arg0isNullable = KotlinTypeKt.isNullable(arg0Type);
        boolean arg1isNullable = KotlinTypeKt.isNullable(arg1Type);
        boolean useNonIEEE754Comparison = !context2.getState().getLanguageVersionSettings().supportsFeature(LanguageFeature.ProperIeee754Comparisons) && (IrUtilsKt.isSmartcastFromHigherThanNullable(arg0, context2) || IrUtilsKt.isSmartcastFromHigherThanNullable(arg1, context2));
        if (useNonIEEE754Comparison) {
            Type type2 = AsmTypes.OBJECT_TYPE;
            Intrinsics.checkNotNullExpressionValue(type2, "OBJECT_TYPE");
            Type type3 = type2;
            type2 = AsmTypes.OBJECT_TYPE;
            Intrinsics.checkNotNullExpressionValue(type2, "OBJECT_TYPE");
            irIntrinsicFunction = new Ieee754AreEqual(expression2, signature2, context2, type3, type2);
        } else if (!arg0isNullable && !arg1isNullable) {
            Type[] typeArray = new Type[]{this.operandType, this.operandType};
            List<Type> list2 = CollectionsKt.listOf(typeArray);
            irIntrinsicFunction = new IrIntrinsicFunction(this, expression2, signature2, context2, list2){
                final /* synthetic */ Ieee754Equals this$0;
                final /* synthetic */ IrFunctionAccessExpression $expression;
                final /* synthetic */ JvmMethodSignature $signature;
                final /* synthetic */ JvmBackendContext $context;
                {
                    this.this$0 = $receiver;
                    this.$expression = $expression;
                    this.$signature = $signature;
                    this.$context = $context;
                    super($expression, $signature, $context, $super_call_param$1);
                }

                public void genInvokeInstruction(@NotNull InstructionAdapter v) {
                    Intrinsics.checkNotNullParameter(v, "v");
                    StackValue.cmp(KtTokens.EQEQ, this.this$0.getOperandType(), StackValue.onStack(this.this$0.getOperandType()), StackValue.onStack(this.this$0.getOperandType())).put(Type.BOOLEAN_TYPE, v);
                }
            };
        } else {
            irIntrinsicFunction = arg0isNullable && !arg1isNullable ? (IrIntrinsicFunction)new Ieee754AreEqual(expression2, signature2, context2, this.boxedOperandType, this.operandType) : (!arg0isNullable && arg1isNullable ? (IrIntrinsicFunction)new Ieee754AreEqual(expression2, signature2, context2, this.operandType, this.boxedOperandType) : (IrIntrinsicFunction)new Ieee754AreEqual(expression2, signature2, context2, this.boxedOperandType, this.boxedOperandType));
        }
        return irIntrinsicFunction;
    }
}

