/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.Dimension;
import java.awt.event.MouseEvent;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.ScrollThread;
import net.sf.freecol.common.model.Direction;

public class AbstractCanvasListener {
    protected static final int AUTO_SCROLL_SPACE = 1;
    private static final int DRAG_SCROLL_SPACE = 100;
    protected final FreeColClient freeColClient;
    protected final Canvas canvas;
    protected ScrollThread scrollThread = null;

    public AbstractCanvasListener(FreeColClient freeColClient, Canvas canvas) {
        this.freeColClient = freeColClient;
        this.canvas = canvas;
        this.scrollThread = null;
    }

    protected void performAutoScrollIfActive(MouseEvent e) {
        if (e.getComponent().isEnabled() && this.freeColClient.getClientOptions().getBoolean("model.option.autoScroll")) {
            this.scroll(e.getX(), e.getY(), 1);
        } else {
            this.stopScrollIfScrollIsActive();
        }
    }

    protected void performDragScrollIfActive(MouseEvent e) {
        if (e.getComponent().isEnabled() && this.freeColClient.getClientOptions().getBoolean("model.option.mapScrollOnDrag")) {
            this.scroll(e.getX(), e.getY(), 100);
        } else {
            this.stopScrollIfScrollIsActive();
        }
    }

    protected void stopScrollIfScrollIsActive() {
        if (this.scrollThread != null) {
            this.scrollThread.interrupt();
            this.scrollThread = null;
        }
    }

    private void scroll(int x, int y, int scrollSpace) {
        Dimension size = this.canvas.getSize();
        Direction direction = x < scrollSpace && y < scrollSpace ? Direction.NW : (x >= size.width - scrollSpace && y < scrollSpace ? Direction.NE : (x >= size.width - scrollSpace && y >= size.height - scrollSpace ? Direction.SE : (x < scrollSpace && y >= size.height - scrollSpace ? Direction.SW : (y < scrollSpace ? Direction.N : (x >= size.width - scrollSpace ? Direction.E : (y >= size.height - scrollSpace ? Direction.S : (x < scrollSpace ? Direction.W : null)))))));
        if (direction == null) {
            this.stopScrollIfScrollIsActive();
        } else if (this.scrollThread == null || this.scrollThread.isInterrupted()) {
            this.scrollThread = new ScrollThread(this.canvas);
            this.scrollThread.setDirection(direction);
            this.scrollThread.start();
        } else {
            this.scrollThread.setDirection(direction);
        }
    }
}

