/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.charts;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import tim.prune.App;
import tim.prune.ExternalTools;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.config.Config;
import tim.prune.data.DataPoint;
import tim.prune.data.Distance;
import tim.prune.data.Field;
import tim.prune.data.Timestamp;
import tim.prune.data.Track;
import tim.prune.function.charts.ChartSeries;
import tim.prune.gui.profile.SpeedData;
import tim.prune.gui.profile.VerticalSpeedData;
import tim.prune.load.GenericFileFilter;

public class Charter
extends GenericFunction {
    private JDialog _dialog = null;
    private JRadioButton _distanceRadio = null;
    private JRadioButton _timeRadio = null;
    private JCheckBox[] _yAxesBoxes = null;
    private JRadioButton _svgRadio = null;
    private JFileChooser _fileChooser = null;
    private JTextField _svgWidthField = null;
    private JTextField _svgHeightField = null;
    private static final String DEFAULT_SVG_WIDTH = "800";
    private static final String DEFAULT_SVG_HEIGHT = "400";

    public Charter(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.charts";
    }

    @Override
    public void begin() {
        if (!ExternalTools.isToolInstalled(2)) {
            this._app.showErrorMessage(this.getNameKey(), "dialog.charts.gnuplotnotfound");
            return;
        }
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, I18nManager.getText(this.getNameKey()), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        if (this.setupDialog(this._app.getTrackInfo().getTrack())) {
            this._dialog.setVisible(true);
        } else {
            this._app.showErrorMessage(this.getNameKey(), "dialog.charts.needaltitudeortimes");
        }
    }

    private JPanel makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createTitledBorder(I18nManager.getText("dialog.charts.xaxis")));
        this._distanceRadio = new JRadioButton(I18nManager.getText("fieldname.distance"));
        this._distanceRadio.setSelected(true);
        this._timeRadio = new JRadioButton(I18nManager.getText("fieldname.time"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._distanceRadio);
        buttonGroup.add(this._timeRadio);
        jPanel3.add(this._distanceRadio);
        jPanel3.add(this._timeRadio);
        jPanel2.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createTitledBorder(I18nManager.getText("dialog.charts.yaxis")));
        this._yAxesBoxes = new JCheckBox[4];
        this._yAxesBoxes[0] = new JCheckBox(I18nManager.getText("fieldname.distance"));
        this._yAxesBoxes[1] = new JCheckBox(I18nManager.getText("fieldname.altitude"));
        this._yAxesBoxes[1].setSelected(true);
        this._yAxesBoxes[2] = new JCheckBox(I18nManager.getText("fieldname.speed"));
        this._yAxesBoxes[3] = new JCheckBox(I18nManager.getText("fieldname.verticalspeed"));
        int n = 0;
        while (n < 4) {
            jPanel4.add(this._yAxesBoxes[n]);
            ++n;
        }
        jPanel2.add(jPanel4);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Charter.this.enableYbox(0, Charter.this._timeRadio.isSelected());
            }
        };
        this._timeRadio.addActionListener(actionListener);
        this._distanceRadio.addActionListener(actionListener);
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(BorderFactory.createTitledBorder(I18nManager.getText("dialog.charts.output")));
        jPanel5.setLayout(new BorderLayout());
        JPanel jPanel6 = new JPanel();
        JRadioButton jRadioButton = new JRadioButton(I18nManager.getText("dialog.charts.screen"));
        jRadioButton.setSelected(true);
        this._svgRadio = new JRadioButton(I18nManager.getText("dialog.charts.svg"));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(jRadioButton);
        buttonGroup2.add(this._svgRadio);
        jPanel6.add(jRadioButton);
        jPanel6.add(this._svgRadio);
        jPanel5.add((Component)jPanel6, "North");
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridLayout(2, 2, 10, 1));
        JLabel jLabel = new JLabel(I18nManager.getText("dialog.charts.svgwidth"));
        jLabel.setHorizontalAlignment(4);
        jPanel7.add(jLabel);
        this._svgWidthField = new JTextField(DEFAULT_SVG_WIDTH, 5);
        jPanel7.add(this._svgWidthField);
        JLabel jLabel2 = new JLabel(I18nManager.getText("dialog.charts.svgheight"));
        jLabel2.setHorizontalAlignment(4);
        jPanel7.add(jLabel2);
        this._svgHeightField = new JTextField(DEFAULT_SVG_HEIGHT, 5);
        jPanel7.add(this._svgHeightField);
        jPanel5.add((Component)jPanel7, "East");
        jPanel2.add(jPanel5);
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new FlowLayout(2));
        JButton jButton = new JButton(I18nManager.getText("button.ok"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Charter.this.showChart(Charter.this._app.getTrackInfo().getTrack());
                Charter.this._dialog.setVisible(false);
            }
        });
        jPanel8.add(jButton);
        JButton jButton2 = new JButton(I18nManager.getText("button.cancel"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Charter.this._dialog.setVisible(false);
            }
        });
        jPanel8.add(jButton2);
        jPanel.add((Component)jPanel8, "South");
        return jPanel;
    }

    private boolean setupDialog(Track track) {
        boolean bl = track.hasData(Field.TIMESTAMP);
        boolean bl2 = track.hasAltitudeData();
        this._timeRadio.setEnabled(bl);
        if (!bl) {
            this._distanceRadio.setSelected(true);
        }
        this.enableYbox(0, !this._distanceRadio.isSelected());
        this.enableYbox(1, bl2);
        this.enableYbox(2, bl);
        this.enableYbox(3, bl && bl2);
        return bl || bl2;
    }

    private void enableYbox(int n, boolean bl) {
        this._yAxesBoxes[n].setEnabled(bl);
        if (!bl) {
            this._yAxesBoxes[n].setSelected(bl);
        }
    }

    private void showChart(Track track) {
        int n = 0;
        int n2 = 0;
        while (n2 < this._yAxesBoxes.length) {
            if (this._yAxesBoxes[n2].isSelected()) {
                ++n;
            }
            ++n2;
        }
        if (n == 0) {
            this._yAxesBoxes[1].setSelected(true);
            n = 1;
        }
        int[] nArray = Charter.getHeights(n);
        boolean bl = this._svgRadio.isSelected();
        File file = null;
        if (bl && (file = this.selectSvgFile()) == null) {
            bl = false;
        }
        OutputStreamWriter outputStreamWriter = null;
        try {
            try {
                String string = Config.getConfigString("prune.gnuplotpath");
                Process process = Runtime.getRuntime().exec(String.valueOf(string) + " -persist");
                outputStreamWriter = new OutputStreamWriter(process.getOutputStream());
                if (bl) {
                    outputStreamWriter.write("set terminal svg size " + Charter.getSvgValue(this._svgWidthField, DEFAULT_SVG_WIDTH) + " " + Charter.getSvgValue(this._svgHeightField, DEFAULT_SVG_HEIGHT) + "\n");
                    outputStreamWriter.write("set out '" + file.getAbsolutePath() + "'\n");
                }
                if (n > 1) {
                    outputStreamWriter.write("set multiplot layout " + n + ",1\n");
                }
                int n3 = 0;
                int n4 = 0;
                while (n4 < this._yAxesBoxes.length) {
                    if (this._yAxesBoxes[n4].isSelected()) {
                        outputStreamWriter.write("set size 1," + 0.01 * (double)nArray[n3 * 2 + 1] + "\n");
                        outputStreamWriter.write("set origin 0," + 0.01 * (double)nArray[n3 * 2] + "\n");
                        Charter.writeChart(outputStreamWriter, track, this._distanceRadio.isSelected(), n4);
                        ++n3;
                    }
                    ++n4;
                }
                if (n > 1) {
                    outputStreamWriter.write("unset multiplot\n");
                }
            }
            catch (Exception exception) {
                this._app.showErrorMessageNoLookup(this.getNameKey(), exception.getMessage());
                try {
                    if (outputStreamWriter != null) {
                        outputStreamWriter.close();
                    }
                }
                catch (Exception exception2) {}
            }
        }
        finally {
            try {
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static String getSvgValue(JTextField jTextField, String string) {
        int n = 0;
        try {
            n = Integer.parseInt(jTextField.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n > 0) {
            return "" + n;
        }
        return string;
    }

    private static void writeChart(OutputStreamWriter outputStreamWriter, Track track, boolean bl, int n) throws IOException {
        ChartSeries chartSeries = null;
        ChartSeries chartSeries2 = null;
        ChartSeries chartSeries3 = Charter.getDistanceValues(track);
        chartSeries = bl ? chartSeries3 : Charter.getTimeValues(track);
        switch (n) {
            case 0: {
                chartSeries2 = chartSeries3;
                break;
            }
            case 1: {
                chartSeries2 = Charter.getAltitudeValues(track);
                break;
            }
            case 2: {
                chartSeries2 = Charter.getSpeedValues(track);
                break;
            }
            case 3: {
                chartSeries2 = Charter.getVertSpeedValues(track);
            }
        }
        File file = File.createTempFile("gpsprunedata", null);
        file.deleteOnExit();
        OutputStreamWriter outputStreamWriter2 = null;
        try {
            outputStreamWriter2 = new FileWriter(file);
            outputStreamWriter2.write("# Temporary data file for GpsPrune charts\n\n");
            int n2 = 0;
            while (n2 < track.getNumPoints()) {
                if (chartSeries.hasData(n2) && chartSeries2.hasData(n2)) {
                    outputStreamWriter2.write(chartSeries.getData(n2) + ", " + chartSeries2.getData(n2) + "\n");
                }
                ++n2;
            }
        }
        finally {
            try {
                outputStreamWriter2.close();
            }
            catch (Exception exception) {}
        }
        String string = I18nManager.getText(Config.getUnitSet().getDistanceUnit().getShortnameKey());
        String string2 = I18nManager.getText(Config.getUnitSet().getAltitudeUnit().getShortnameKey());
        String string3 = I18nManager.getText(Config.getUnitSet().getSpeedUnit().getShortnameKey());
        String string4 = I18nManager.getText(Config.getUnitSet().getVerticalSpeedUnit().getShortnameKey());
        if (bl) {
            outputStreamWriter.write("set xlabel '" + I18nManager.getText("fieldname.distance") + " (" + string + ")'\n");
        } else {
            outputStreamWriter.write("set xlabel '" + I18nManager.getText("fieldname.time") + " (" + I18nManager.getText("units.hours") + ")'\n");
        }
        String string5 = null;
        switch (n) {
            case 0: {
                outputStreamWriter.write("set ylabel '" + I18nManager.getText("fieldname.distance") + " (" + string + ")'\n");
                string5 = I18nManager.getText("fieldname.distance");
                break;
            }
            case 1: {
                outputStreamWriter.write("set ylabel '" + I18nManager.getText("fieldname.altitude") + " (" + string2 + ")'\n");
                string5 = I18nManager.getText("fieldname.altitude");
                break;
            }
            case 2: {
                outputStreamWriter.write("set ylabel '" + I18nManager.getText("fieldname.speed") + " (" + string3 + ")'\n");
                string5 = I18nManager.getText("fieldname.speed");
                break;
            }
            case 3: {
                outputStreamWriter.write("set ylabel '" + I18nManager.getText("fieldname.verticalspeed") + " (" + string4 + ")'\n");
                string5 = I18nManager.getText("fieldname.verticalspeed");
            }
        }
        outputStreamWriter.write("set style fill solid 0.5 border -1\n");
        outputStreamWriter.write("plot '" + file.getAbsolutePath() + "' title '" + string5 + "' with filledcurve y1=0 lt rgb \"#009000\"\n");
    }

    private static ChartSeries getDistanceValues(Track track) {
        ChartSeries chartSeries = new ChartSeries(track.getNumPoints());
        double d = 0.0;
        DataPoint dataPoint = null;
        DataPoint dataPoint2 = null;
        int n = 0;
        while (n < track.getNumPoints()) {
            dataPoint2 = track.getPoint(n);
            if (dataPoint != null && !dataPoint2.isWaypoint() && !dataPoint2.getSegmentStart()) {
                d += DataPoint.calculateRadiansBetween(dataPoint, dataPoint2);
            }
            chartSeries.setData(n, Distance.convertRadiansToDistance(d));
            dataPoint = dataPoint2;
            ++n;
        }
        return chartSeries;
    }

    private static ChartSeries getTimeValues(Track track) {
        ChartSeries chartSeries = new ChartSeries(track.getNumPoints());
        double d = 0.0;
        Timestamp timestamp = null;
        DataPoint dataPoint = null;
        int n = 0;
        while (n < track.getNumPoints()) {
            dataPoint = track.getPoint(n);
            if (dataPoint.hasTimestamp()) {
                if (!dataPoint.getSegmentStart() && timestamp != null) {
                    d += (double)dataPoint.getTimestamp().getMillisecondsSince(timestamp) / 1000.0;
                }
                chartSeries.setData(n, d / 60.0 / 60.0);
                timestamp = dataPoint.getTimestamp();
            }
            ++n;
        }
        return chartSeries;
    }

    private static ChartSeries getAltitudeValues(Track track) {
        ChartSeries chartSeries = new ChartSeries(track.getNumPoints());
        double d = Config.getUnitSet().getAltitudeUnit().getMultFactorFromStd();
        int n = 0;
        while (n < track.getNumPoints()) {
            if (track.getPoint(n).hasAltitude()) {
                chartSeries.setData(n, track.getPoint(n).getAltitude().getMetricValue() * d);
            }
            ++n;
        }
        return chartSeries;
    }

    private static ChartSeries getSpeedValues(Track track) {
        SpeedData speedData = new SpeedData(track);
        speedData.init(Config.getUnitSet());
        int n = track.getNumPoints();
        ChartSeries chartSeries = new ChartSeries(n);
        int n2 = 0;
        while (n2 < n) {
            if (speedData.hasData(n2)) {
                chartSeries.setData(n2, speedData.getData(n2));
            }
            ++n2;
        }
        return chartSeries;
    }

    private static ChartSeries getVertSpeedValues(Track track) {
        VerticalSpeedData verticalSpeedData = new VerticalSpeedData(track);
        verticalSpeedData.init(Config.getUnitSet());
        int n = track.getNumPoints();
        ChartSeries chartSeries = new ChartSeries(n);
        int n2 = 0;
        while (n2 < n) {
            if (verticalSpeedData.hasData(n2)) {
                chartSeries.setData(n2, verticalSpeedData.getData(n2));
            }
            ++n2;
        }
        return chartSeries;
    }

    private File selectSvgFile() {
        if (this._fileChooser == null) {
            this._fileChooser = new JFileChooser();
            this._fileChooser.setDialogType(1);
            this._fileChooser.setFileFilter(new GenericFileFilter("filetype.svg", new String[]{"svg"}));
            this._fileChooser.setAcceptAllFileFilterUsed(false);
            String string = Config.getConfigString("prune.trackdirectory");
            if (string != null) {
                this._fileChooser.setCurrentDirectory(new File(string));
            }
        }
        boolean bl = true;
        while (bl) {
            bl = false;
            if (this._fileChooser.showSaveDialog(this._parentFrame) != 0) continue;
            File file = this._fileChooser.getSelectedFile();
            if (!file.getName().toLowerCase().endsWith(".svg")) {
                file = new File(String.valueOf(file.getAbsolutePath()) + ".svg");
            }
            Object[] objectArray = new Object[]{I18nManager.getText("button.overwrite"), I18nManager.getText("button.cancel")};
            if (!file.exists() || file.canWrite() && JOptionPane.showOptionDialog(this._parentFrame, I18nManager.getText("dialog.save.overwrite.text"), I18nManager.getText("dialog.save.overwrite.title"), 0, 2, null, objectArray, objectArray[1]) == 0) {
                return file;
            }
            bl = true;
        }
        return null;
    }

    private static int[] getHeights(int n) {
        if (n <= 1) {
            int[] nArray = new int[2];
            nArray[1] = 100;
            return nArray;
        }
        if (n == 2) {
            int[] nArray = new int[4];
            nArray[0] = 25;
            nArray[1] = 75;
            nArray[3] = 25;
            return nArray;
        }
        if (n == 3) {
            int[] nArray = new int[6];
            nArray[0] = 40;
            nArray[1] = 60;
            nArray[2] = 20;
            nArray[3] = 20;
            nArray[5] = 20;
            return nArray;
        }
        int[] nArray = new int[8];
        nArray[0] = 54;
        nArray[1] = 46;
        nArray[2] = 36;
        nArray[3] = 18;
        nArray[4] = 18;
        nArray[5] = 18;
        nArray[7] = 18;
        return nArray;
    }
}

