/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.edit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.config.Config;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.data.FieldList;
import tim.prune.data.Track;
import tim.prune.data.Unit;
import tim.prune.function.edit.EditFieldsTableModel;
import tim.prune.function.edit.FieldEdit;
import tim.prune.function.edit.FieldEditList;

public class PointEditor {
    private App _app = null;
    private JFrame _parentFrame = null;
    private JDialog _dialog = null;
    private JTable _table = null;
    private JLabel _fieldnameLabel = null;
    private JTextField _valueField = null;
    private JTextArea _valueArea = null;
    private JScrollPane _valueAreaPane = null;
    private Track _track = null;
    private DataPoint _point = null;
    private EditFieldsTableModel _model = null;
    private JButton _cancelButton = null;
    private int _prevRowIndex = -1;

    public PointEditor(App app, JFrame jFrame) {
        this._app = app;
        this._parentFrame = jFrame;
    }

    public void showDialog(Track track, DataPoint dataPoint) {
        this._track = track;
        this._point = dataPoint;
        this._dialog = new JDialog(this._parentFrame, I18nManager.getText("dialog.pointedit.title"), true);
        this._dialog.setLocationRelativeTo(this._parentFrame);
        FieldList fieldList = this._track.getFieldList();
        int n = fieldList.getNumFields();
        this._model = new EditFieldsTableModel(n);
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldList.getField(n2);
            this._model.addFieldInfo(field.getName(), this._point.getFieldValue(field), n2);
            ++n2;
        }
        this._dialog.getContentPane().add(this.makeDialogComponents());
        this._dialog.pack();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PointEditor.this._valueField.setVisible(false);
                PointEditor.this._valueAreaPane.setVisible(false);
                PointEditor.this._cancelButton.requestFocus();
            }
        });
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(20, 10));
        this._table = new JTable(this._model){

            @Override
            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                boolean bl = ((EditFieldsTableModel)this.getModel()).getChanged(n);
                component.setBackground(bl ? Color.orange : this.getBackground());
                return component;
            }
        };
        this._table.setSelectionMode(0);
        this._table.getSelectionModel().clearSelection();
        this._table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                PointEditor.this.fieldSelected();
            }
        });
        this._table.setPreferredScrollableViewportSize(new Dimension(this._table.getWidth() * 2, this._table.getRowHeight() * 6));
        JScrollPane jScrollPane = new JScrollPane(this._table);
        jScrollPane.setPreferredSize(new Dimension(150, 100));
        JLabel jLabel = new JLabel(I18nManager.getText("dialog.pointedit.intro"));
        jLabel.setBorder(BorderFactory.createEmptyBorder(8, 6, 3, 6));
        jPanel.add((Component)jLabel, "North");
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PointEditor.this.confirmEdit();
                PointEditor.this._dialog.dispose();
            }
        };
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        this._fieldnameLabel = new JLabel(I18nManager.getText("dialog.pointedit.nofield"));
        jPanel3.add(this._fieldnameLabel);
        this._valueField = new JTextField(11);
        this._valueField.addActionListener(actionListener);
        jPanel3.add(this._valueField);
        jPanel2.add((Component)jPanel3, "North");
        this._valueArea = new JTextArea(5, 15);
        this._valueArea.setLineWrap(true);
        this._valueArea.setWrapStyleWord(true);
        this._valueAreaPane = new JScrollPane(this._valueArea);
        jPanel2.add((Component)this._valueAreaPane, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(0, 2, 10, 10));
        jPanel4.add(jScrollPane);
        jPanel4.add(jPanel2);
        jPanel.add((Component)jPanel4, "Center");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(2));
        this._cancelButton = new JButton(I18nManager.getText("button.cancel"));
        this._cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PointEditor.this._dialog.dispose();
            }
        });
        this._cancelButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    PointEditor.this._dialog.dispose();
                }
            }
        });
        jPanel5.add(this._cancelButton);
        JButton jButton = new JButton(I18nManager.getText("button.ok"));
        jButton.addActionListener(actionListener);
        jPanel5.add(jButton);
        jPanel.add((Component)jPanel5, "South");
        return jPanel;
    }

    private void fieldSelected() {
        Object object;
        int n = this._table.getSelectedRow();
        if (n == this._prevRowIndex) {
            return;
        }
        if (this._prevRowIndex >= 0) {
            object = this._track.getFieldList().getField(this._prevRowIndex);
            boolean bl = ((Field)object).isBuiltIn() && object != Field.DESCRIPTION;
            String string = bl ? this._valueField.getText() : this._valueArea.getText();
            this._model.updateValue(this._prevRowIndex, string);
        }
        if (n < 0) {
            this._fieldnameLabel.setText("");
        } else {
            boolean bl;
            object = this._model.getValue(n);
            Field field = this._track.getFieldList().getField(n);
            this._fieldnameLabel.setText(PointEditor.makeFieldLabel(field, this._point));
            this._fieldnameLabel.setVisible(true);
            boolean bl2 = bl = field.isBuiltIn() && field != Field.DESCRIPTION;
            if (bl) {
                this._valueField.setText((String)object);
            } else {
                this._valueArea.setText((String)object);
            }
            this._valueField.setVisible(bl);
            this._valueAreaPane.setVisible(!bl);
            if (bl) {
                this._valueField.requestFocus();
            } else {
                this._valueArea.requestFocus();
            }
        }
        this._prevRowIndex = n;
    }

    private static String makeFieldLabel(Field field, DataPoint dataPoint) {
        String string = String.valueOf(I18nManager.getText("dialog.pointedit.table.field")) + ": " + field.getName();
        if (field == Field.ALTITUDE) {
            string = String.valueOf(string) + PointEditor.makeUnitsLabel(dataPoint.hasAltitude() ? dataPoint.getAltitude().getUnit() : Config.getUnitSet().getAltitudeUnit());
        } else if (field == Field.SPEED) {
            string = String.valueOf(string) + PointEditor.makeUnitsLabel(dataPoint.hasHSpeed() ? dataPoint.getHSpeed().getUnit() : Config.getUnitSet().getSpeedUnit());
        } else if (field == Field.VERTICAL_SPEED) {
            string = String.valueOf(string) + PointEditor.makeUnitsLabel(dataPoint.hasVSpeed() ? dataPoint.getVSpeed().getUnit() : Config.getUnitSet().getVerticalSpeedUnit());
        }
        return string;
    }

    private static String makeUnitsLabel(Unit unit) {
        if (unit == null) {
            return "";
        }
        return " (" + I18nManager.getText(unit.getShortnameKey()) + ")";
    }

    private void confirmEdit() {
        Object object;
        int n;
        Object object2;
        int n2 = this._table.getSelectedRow();
        if (n2 >= 0) {
            object2 = this._track.getFieldList().getField(n2);
            n = ((Field)object2).isBuiltIn() && object2 != Field.DESCRIPTION ? 1 : 0;
            object = n != 0 ? this._valueField.getText() : this._valueArea.getText();
            this._model.updateValue(this._prevRowIndex, (String)object);
        }
        object2 = this._track.getFieldList();
        n = ((FieldList)object2).getNumFields();
        object = new FieldEditList();
        FieldEditList fieldEditList = new FieldEditList();
        int n3 = 0;
        while (n3 < n) {
            if (this._model.getChanged(n3)) {
                Field field = ((FieldList)object2).getField(n3);
                ((FieldEditList)object).addEdit(new FieldEdit(field, this._model.getValue(n3)));
                fieldEditList.addEdit(new FieldEdit(field, this._point.getFieldValue(field)));
            }
            ++n3;
        }
        this._app.completePointEdit((FieldEditList)object, fieldEditList);
    }
}

