/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.MalformedInputException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.io.AutoDetection;
import org.gjt.sp.jedit.io.EncodingServer;
import org.gjt.sp.jedit.io.FileVFS;
import org.gjt.sp.jedit.io.UrlVFS;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.syntax.ModeProvider;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;
import org.gjt.sp.util.StringList;

public class MiscUtilities {
    static final String varPatternString = "(\\$([a-zA-Z0-9_]+))";
    static final String varPatternString2 = "(\\$\\{([^}]+)\\})";
    static final String winPatternString = "(%([^%]+)%)";
    static final Pattern varPattern = Pattern.compile("(\\$([a-zA-Z0-9_]+))");
    static final Pattern varPattern2 = Pattern.compile("(\\$\\{([^}]+)\\})");
    static final Pattern winPattern = Pattern.compile("(%([^%]+)%)");
    @Nullable
    static VarCompressor svc;

    @Nonnull
    public static String canonPath(@Nonnull String string) {
        if (string.isEmpty()) {
            return string;
        }
        if (string.startsWith("file://")) {
            string = string.substring("file://".length());
        } else if (string.startsWith("file:")) {
            string = string.substring("file:".length());
        } else if (MiscUtilities.isURL(string)) {
            return string;
        }
        if (File.separatorChar == '\\') {
            string = string.replace('/', '\\');
            int n = string.length();
            while (string.charAt(n - 1) == ' ') {
                --n;
            }
            if (string.charAt(n - 1) == '\\') {
                while (n > 1 && string.charAt(n - 2) == '\\') {
                    --n;
                }
            }
            string = string.substring(0, n);
        }
        if (string.startsWith("~" + File.separator)) {
            string = string.substring(2);
            String string2 = System.getProperty("user.home");
            if (string2.endsWith(File.separator)) {
                return string2 + string;
            }
            return string2 + File.separator + string;
        }
        if ("~".equals(string)) {
            return System.getProperty("user.home");
        }
        if ("-".equals(string)) {
            return MiscUtilities.getParentOfPath(jEdit.getActiveView().getBuffer().getPath());
        }
        return string;
    }

    private static String win2unix(String string) {
        String string2;
        String string3;
        String string4 = string.replace('\\', '/');
        Matcher matcher = winPattern.matcher(string4);
        if (matcher.find() && (string3 = System.getenv(string2 = matcher.group(2))) != null) {
            return matcher.replaceFirst(string3);
        }
        return string4;
    }

    public static String expandVariables(String string) {
        if (string.startsWith("~/") || string.startsWith("~\\")) {
            return System.getProperty("user.home") + string.substring(1);
        }
        Matcher matcher = winPattern.matcher(string);
        if (!OperatingSystem.isWindows() && matcher.find()) {
            return MiscUtilities.win2unix(string);
        }
        Pattern pattern = varPattern;
        matcher = pattern.matcher(string);
        if (!matcher.find() && !(matcher = (pattern = OperatingSystem.isWindows() ? winPattern : varPattern2).matcher(string)).find()) {
            return string;
        }
        String string2 = matcher.group(2);
        String string3 = System.getenv(string2);
        if (string3 == null) {
            if (string2.equalsIgnoreCase("jedit_settings") && jEdit.getSettingsDirectory() != null) {
                string3 = jEdit.getSettingsDirectory();
            } else {
                string2 = string2.toUpperCase();
                String string4 = string.toUpperCase();
                matcher = pattern.matcher(string4);
                string3 = System.getenv(string2);
            }
        }
        if (string3 != null) {
            string3 = string3.replace("\\", "\\\\");
            return matcher.replaceFirst(string3);
        }
        return string;
    }

    public static String abbreviate(String string) {
        if (svc == null) {
            svc = new VarCompressor();
        }
        return svc.compress(string);
    }

    public static String abbreviateView(String string) {
        if (!jEdit.getBooleanProperty("view.abbreviatePaths")) {
            return string;
        }
        return MiscUtilities.abbreviate(string);
    }

    public static String resolveSymlinks(@Nonnull String string) {
        if (MiscUtilities.isURL(string)) {
            return string;
        }
        if (OperatingSystem.isOS2()) {
            return string;
        }
        if (OperatingSystem.isWindows() && (string.length() == 2 || string.length() == 3) && string.charAt(1) == ':') {
            return string;
        }
        try {
            return new File(string).getCanonicalPath();
        }
        catch (IOException iOException) {
            return string;
        }
    }

    public static boolean isAbsolutePath(@Nonnull String string) {
        if (MiscUtilities.isURL(string)) {
            return true;
        }
        if (string.startsWith("~/") || string.startsWith("~" + File.separator) || "~".equals(string)) {
            return true;
        }
        if ("-".equals(string)) {
            return true;
        }
        if (OperatingSystem.isWindows()) {
            if (string.length() == 2 && string.charAt(1) == ':') {
                return true;
            }
            if (string.length() > 2 && string.charAt(1) == ':' && (string.charAt(2) == '\\' || string.charAt(2) == '/')) {
                return true;
            }
            if (string.startsWith("\\\\") || string.startsWith("//")) {
                return true;
            }
        } else if ((OperatingSystem.isUnix() || OperatingSystem.isVMS()) && !string.isEmpty() && string.charAt(0) == '/') {
            return true;
        }
        return false;
    }

    public static String constructPath(@Nullable String string, @Nonnull String object) {
        if (MiscUtilities.isAbsolutePath((String)object)) {
            return MiscUtilities.canonPath((String)object);
        }
        if (string == null) {
            string = System.getProperty("user.dir");
        }
        if (((String)object).isEmpty()) {
            return string;
        }
        if (OperatingSystem.isWindows()) {
            if (((String)object).length() == 2 && ((String)object).charAt(1) == ':') {
                return object;
            }
            if (((String)object).length() > 2 && ((String)object).charAt(1) == ':' && ((String)object).charAt(2) != '\\') {
                object = ((String)object).substring(0, 2) + "\\" + ((String)object).substring(2);
                return MiscUtilities.canonPath((String)object);
            }
        }
        String string2 = ".." + File.separator;
        String string3 = "." + File.separator;
        while (true) {
            if (".".equals(object)) {
                return string;
            }
            if ("..".equals(object)) {
                return MiscUtilities.getParentOfPath(string);
            }
            if (((String)object).startsWith(string2) || ((String)object).startsWith("../")) {
                string = MiscUtilities.getParentOfPath(string);
                object = ((String)object).substring(3);
                continue;
            }
            if (!((String)object).startsWith(string3) && !((String)object).startsWith("./")) break;
            object = ((String)object).substring(2);
        }
        if (((String)object).isEmpty()) {
            return string;
        }
        if (OperatingSystem.isWindows() && !MiscUtilities.isURL(string) && ((String)object).charAt(0) == '\\') {
            string = string.substring(0, 2);
        }
        VFS vFS = VFSManager.getVFSForPath(string);
        return MiscUtilities.canonPath(vFS.constructPath(string, (String)object));
    }

    public static String constructPath(String string, String string2, String string3) {
        return MiscUtilities.constructPath(MiscUtilities.constructPath(string, string2), string3);
    }

    public static String concatPath(@Nonnull String string, @Nonnull String string2) {
        string = MiscUtilities.canonPath(string);
        if ((string2 = MiscUtilities.canonPath(string2)).startsWith(File.separator)) {
            string2 = string2.substring(1);
        } else if (string2.length() >= 3 && string2.charAt(1) == ':') {
            string2 = string2.replace(':', File.separatorChar);
        }
        if (string.endsWith(File.separator)) {
            return string + string2;
        }
        return string + File.separator + string2;
    }

    public static int getFirstSeparatorIndex(String string) {
        int n = MiscUtilities.getPathStart(string);
        int n2 = string.indexOf(47, n);
        if (n2 == -1) {
            n2 = string.indexOf(File.separatorChar, n);
        }
        return n2;
    }

    public static int getLastSeparatorIndex(@Nonnull String string) {
        int n;
        int n2 = MiscUtilities.getPathStart(string);
        if (n2 != 0) {
            string = string.substring(n2);
        }
        if ((n = Math.max(string.lastIndexOf(47), string.lastIndexOf(File.separatorChar))) == -1) {
            return n;
        }
        return n + n2;
    }

    @Nonnull
    public static String getFileExtension(String string) {
        int n = MiscUtilities.getLastSeparatorIndex(string);
        int n2 = string.lastIndexOf(46);
        if (n2 == -1 || n2 < n) {
            return "";
        }
        return string.substring(n2);
    }

    public static String getFileName(String string) {
        return VFSManager.getVFSForPath(string).getFileName(string);
    }

    public static String getCompleteBaseName(String string) {
        String string2 = MiscUtilities.getFileName(string);
        int n = string2.lastIndexOf(46);
        if (n == -1) {
            return string2;
        }
        return string2.substring(0, n);
    }

    public static String getBaseName(String string) {
        String string2 = MiscUtilities.getFileName(string);
        int n = string2.indexOf(46);
        if (n == -1) {
            return string2;
        }
        return string2.substring(0, n);
    }

    @Deprecated
    public static String getFileNameNoExtension(String string) {
        return MiscUtilities.getBaseName(string);
    }

    public static String getParentOfPath(String string) {
        return VFSManager.getVFSForPath(string).getParentOfPath(string);
    }

    public static String getProtocolOfURL(String string) {
        return string.substring(0, string.indexOf(58));
    }

    public static boolean isURL(@Nonnull String string) {
        int n = MiscUtilities.getLastSeparatorIndex(string);
        if (n == 0) {
            return false;
        }
        if (n == 2) {
            return false;
        }
        int n2 = string.indexOf(58);
        if (n2 <= 1) {
            return false;
        }
        String string2 = string.substring(0, n2);
        VFS vFS = VFSManager.getVFSForProtocol(string2);
        if (!(vFS instanceof UrlVFS)) {
            return true;
        }
        try {
            new URL(string);
            return true;
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    public static File getNthBackupFile(String string, int n, int n2, String string2, String string3, String string4) {
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        File file = n2 <= 1 ? new File(string4, string2 + string + string3) : new File(string4, string2 + string + string3 + n + string3);
        return file;
    }

    public static void openInDesktop(String string) {
        StringList stringList = new StringList();
        if (OperatingSystem.isWindows()) {
            if (MiscUtilities.isURL(string)) {
                try {
                    URI uRI = new URI(string);
                    Desktop.getDesktop().browse(uRI);
                    return;
                }
                catch (IOException iOException) {
                    Log.log(9, string, "Can't open URI", iOException);
                }
                catch (URISyntaxException uRISyntaxException) {
                    Log.log(9, string, "Bad URI syntax:", uRISyntaxException);
                }
            } else {
                stringList.add("rundll32");
                stringList.add("SHELL32.DLL,ShellExec_RunDLL");
            }
        } else if (OperatingSystem.isMacOS()) {
            stringList.add("open");
        } else if (OperatingSystem.isX11()) {
            stringList.add("xdg-open");
        }
        try {
            if (stringList.isEmpty()) {
                Desktop.getDesktop().open(new File(string));
            } else {
                stringList.add(string);
                Log.log(1, MiscUtilities.class, "openInDesktop: " + stringList.join(" "));
                Runtime.getRuntime().exec(stringList.toArray());
            }
        }
        catch (IOException iOException) {
            Log.log(9, MiscUtilities.class, "openInDesktop failed: " + string, iOException);
        }
    }

    public static File prepareAutosaveDirectory(String string) {
        String string2;
        boolean bl = VFSManager.getVFSForPath(string) instanceof FileVFS;
        File file = bl ? new File(string) : new File(MiscUtilities.replaceNonPathChars(string, "_"));
        File file2 = file;
        if (!file2.isDirectory()) {
            file2 = file2.getParentFile();
        }
        if ((string2 = jEdit.getProperty("autosave.directory")) != null) {
            if (string.startsWith(string2 = MiscUtilities.expandVariables(string2))) {
                return file2;
            }
            if (!(file2 = new File(string2 = MiscUtilities.concatPath(string2, file2.getAbsolutePath()))).exists()) {
                file2.mkdirs();
            }
        } else if (!bl) {
            return null;
        }
        return file2;
    }

    public static String getBackupDirectory() {
        String string = jEdit.getProperty("backup.directory");
        if (string == null || string.isEmpty()) {
            return null;
        }
        return MiscUtilities.expandVariables(string);
    }

    public static File prepareBackupDirectory(String string) {
        String string2;
        boolean bl = VFSManager.getVFSForPath(string) instanceof FileVFS;
        File file = bl ? new File(string) : new File(MiscUtilities.replaceNonPathChars(string, "_"));
        File file2 = file;
        if (!file2.isDirectory()) {
            file2 = file2.getParentFile();
        }
        if ((string2 = MiscUtilities.getBackupDirectory()) == null) {
            if (!bl) {
                return null;
            }
        } else {
            if (string.startsWith(string2)) {
                return file2;
            }
            if (!(file2 = new File(string2 = MiscUtilities.concatPath(string2, file2.getAbsolutePath()))).exists()) {
                file2.mkdirs();
            }
        }
        return file2;
    }

    public static File prepareBackupFile(String string, File file) {
        int n = jEdit.getIntegerProperty("backups", 1);
        String string2 = jEdit.getProperty("backup.prefix");
        String string3 = jEdit.getProperty("backup.suffix");
        int n2 = jEdit.getIntegerProperty("backup.minTime", 0);
        return MiscUtilities.prepareBackupFile(string, n, string2, string3, file.getPath(), n2);
    }

    public static File prepareBackupFile(String string, int n, String string2, String string3, String string4, int n2) {
        boolean bl = VFSManager.getVFSForPath(string) instanceof FileVFS;
        File file = bl ? new File(string) : new File(MiscUtilities.replaceNonPathChars(string, "_"));
        String string5 = file.getName();
        File file2 = MiscUtilities.getNthBackupFile(string5, 1, n, string2, string3, string4);
        if (file2.equals(file)) {
            Log.log(7, MiscUtilities.class, jEdit.getProperty("ioerror.backup-same-name") + " " + jEdit.getProperty("ioerror.backup-failed"));
            return null;
        }
        long l = file2.lastModified();
        if (System.currentTimeMillis() - l < (long)n2) {
            Log.log(1, MiscUtilities.class, "Backup not done because of backup.minTime");
            return null;
        }
        File file3 = MiscUtilities.getNthBackupFile(string5, n, n, string2, string3, string4);
        if (!file3.equals(file)) {
            file3.delete();
        }
        if (n > 1) {
            for (int i = n - 1; i > 0; --i) {
                File file4 = MiscUtilities.getNthBackupFile(string5, i, n, string2, string3, string4);
                File file5 = MiscUtilities.getNthBackupFile(string5, i + 1, n, string2, string3, string4);
                file4.renameTo(file5);
            }
        }
        return file2;
    }

    public static void saveBackup(File file) {
        File file2 = MiscUtilities.prepareBackupDirectory(file.toString());
        File file3 = MiscUtilities.prepareBackupFile(file.toString(), file2);
        if (file3 != null) {
            MiscUtilities.saveBackup(file, file3);
        }
    }

    public static void saveBackup(File file, int n, String string, String string2, String string3) {
        MiscUtilities.saveBackup(file, n, string, string2, string3, 0);
    }

    public static void saveBackup(File file, int n, String string, String string2, String string3, int n2) {
        File file2 = MiscUtilities.prepareBackupFile(file.toString(), n, string, string2, string3, n2);
        if (file2 == null) {
            return;
        }
        MiscUtilities.saveBackup(file, file2);
    }

    public static void saveBackup(File file, File file2) {
        Log.log(1, MiscUtilities.class, "Saving backup of file \"" + file.getAbsolutePath() + "\" to \"" + file2.getAbsolutePath() + "\"");
        if (!file.renameTo(file2)) {
            IOUtilities.moveFile(file, file2);
        }
    }

    public static boolean isBinary(InputStream inputStream) throws IOException {
        AutoDetection.Result result = new AutoDetection.Result(inputStream);
        if (result.getDetectedEncoding() != null) {
            return false;
        }
        try {
            return MiscUtilities.containsNullCharacter(new InputStreamReader(result.getRewindedStream()));
        }
        catch (MalformedInputException malformedInputException) {
            return true;
        }
    }

    public static boolean isBackup(String string) {
        if (string == null) {
            return false;
        }
        if (jEdit.getIntegerProperty("backups") <= 0) {
            return false;
        }
        if ((string = MiscUtilities.getFileName(string)).matches("Untitled-\\d+")) {
            return false;
        }
        if (string.matches("[#]Untitled-\\d+[#]") || string.matches("[#].*?[#]save[#]")) {
            return true;
        }
        String string2 = jEdit.getProperty("backup.prefix");
        String string3 = jEdit.getProperty("backup.suffix");
        if (string2 != null && !string2.isEmpty() && string3 != null && !string3.isEmpty()) {
            return string.startsWith(string2) && string.endsWith(string3);
        }
        if (string2 != null && !string2.isEmpty() && string.startsWith(string2)) {
            return true;
        }
        if (string3 != null && !string3.isEmpty() && string.endsWith(string3)) {
            return true;
        }
        if ((string2 == null || string2.isEmpty()) && (string3 == null || string3.isEmpty()) && string.matches(".*?\\d+")) {
            Mode[] modeArray;
            for (Mode mode : modeArray = ModeProvider.instance.getModes()) {
                if (!mode.acceptFile(null, string)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static Reader autodetect(InputStream inputStream, Buffer buffer) throws IOException {
        Object object;
        String string = buffer == null ? System.getProperty("file.encoding") : buffer.getStringProperty("encoding");
        boolean bl = false;
        if (buffer == null || buffer.getBooleanProperty("encodingAutodetect")) {
            String string2;
            object = new AutoDetection.Result(inputStream);
            bl = ((AutoDetection.Result)object).streamIsGzipped();
            if (bl) {
                Log.log(1, MiscUtilities.class, "Stream is Gzipped");
            }
            if ((string2 = ((AutoDetection.Result)object).getDetectedEncoding()) != null) {
                string = string2;
                Log.log(1, MiscUtilities.class, "Stream encoding detected is " + string2);
            }
            inputStream = ((AutoDetection.Result)object).getRewindedStream();
        } else {
            inputStream = AutoDetection.getMarkedStream(inputStream);
        }
        object = EncodingServer.getTextReader(inputStream, string);
        if (buffer != null) {
            if (bl) {
                buffer.setBooleanProperty("gzipped", true);
            }
            buffer.setProperty("encoding", string);
        }
        return object;
    }

    public static String fileToClass(String string) {
        char[] cArray = string.toCharArray();
        for (int i = cArray.length - 6; i >= 0; --i) {
            if (cArray[i] != '/') continue;
            cArray[i] = 46;
        }
        return new String(cArray, 0, cArray.length - 6);
    }

    public static String classToFile(String string) {
        return string.replace('.', '/').concat(".class");
    }

    public static boolean pathsEqual(String string, String string2) {
        VFS vFS;
        VFS vFS2 = VFSManager.getVFSForPath(string);
        if (vFS2 != (vFS = VFSManager.getVFSForPath(string2))) {
            return false;
        }
        if (string.endsWith("/") || string.endsWith(File.separator)) {
            string = string.substring(0, string.length() - 1);
        }
        if (string2.endsWith("/") || string2.endsWith(File.separator)) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if ((vFS2.getCapabilities() & 0x80) != 0) {
            return string.equalsIgnoreCase(string2);
        }
        return string.equals(string2);
    }

    public static String escapesToChars(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\\': {
                    if (i == string.length() - 1) {
                        stringBuilder.append('\\');
                        continue block7;
                    }
                    c = string.charAt(++i);
                    switch (c) {
                        case 'n': {
                            stringBuilder.append('\n');
                            continue block7;
                        }
                        case 't': {
                            stringBuilder.append('\t');
                            continue block7;
                        }
                    }
                    stringBuilder.append(c);
                    continue block7;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String getLongestPrefix(List<String> list, boolean bl) {
        String string;
        int n;
        if (list.isEmpty()) {
            return "";
        }
        block0: for (n = 0; n < (string = list.get(0)).length(); ++n) {
            char c = string.charAt(n);
            for (int i = 1; i < list.size(); ++i) {
                string = list.get(i);
                if (n >= string.length() || !MiscUtilities.compareChars(string.charAt(n), c, bl)) break block0;
            }
        }
        return list.get(0).substring(0, n);
    }

    public static String getLongestPrefix(String[] stringArray, boolean bl) {
        return MiscUtilities.getLongestPrefix((Object[])stringArray, bl);
    }

    public static String getLongestPrefix(Object[] objectArray, boolean bl) {
        int n;
        if (objectArray.length == 0) {
            return "";
        }
        String string = objectArray[0].toString();
        block0: for (n = 0; n < string.length(); ++n) {
            char c = string.charAt(n);
            for (int i = 1; i < objectArray.length; ++i) {
                String string2 = objectArray[i].toString();
                if (n >= string2.length() || !MiscUtilities.compareChars(string2.charAt(n), c, bl)) break block0;
            }
        }
        return string.substring(0, n);
    }

    public static String buildToVersion(String string) {
        if (string.length() != 11) {
            return "<unknown version: " + string + ">";
        }
        int n = Integer.parseInt(string.substring(0, 2));
        int n2 = Integer.parseInt(string.substring(3, 5));
        int n3 = Integer.parseInt(string.substring(6, 8));
        int n4 = Integer.parseInt(string.substring(9, 11));
        return n + "." + n2 + (n3 != 99 ? "pre" + n3 : "." + n4);
    }

    public static boolean isToolsJarAvailable() {
        Log.log(1, MiscUtilities.class, "Searching for tools.jar...");
        LinkedList<Object> linkedList = new LinkedList<Object>();
        linkedList.add("System classpath: " + System.getProperty("java.class.path"));
        try {
            try {
                Class.forName("sun.tools.javac.Main");
            }
            catch (ClassNotFoundException classNotFoundException) {
                Class.forName("com.sun.tools.javac.Main");
            }
            Log.log(1, MiscUtilities.class, "- is in classpath. Fine.");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string;
            String string2;
            String string3 = jEdit.getSettingsDirectory();
            if (string3 != null) {
                string2 = MiscUtilities.constructPath(string3, "jars", "tools.jar");
                linkedList.add(string2);
                if (new File(string2).exists()) {
                    Log.log(1, MiscUtilities.class, "- is in the user's jars folder. Fine.");
                    return true;
                }
            }
            if ((string2 = jEdit.getJEditHome()) != null) {
                string = MiscUtilities.constructPath(string2, "jars", "tools.jar");
                linkedList.add(string);
                if (new File(string).exists()) {
                    Log.log(1, MiscUtilities.class, "- is in jEdit's system jars folder. Fine.");
                    return true;
                }
            }
            if ((string = System.getProperty("java.home")).toLowerCase().endsWith(File.separator + "jre")) {
                string = string.substring(0, string.length() - 4);
            }
            string = MiscUtilities.constructPath(string, "lib", "tools.jar");
            linkedList.add(string);
            if (!new File(string).exists()) {
                Log.log(7, MiscUtilities.class, "Could not find tools.jar.\nI checked the following locations:\n" + ((Object)linkedList).toString());
                return false;
            }
            PluginJAR pluginJAR = jEdit.getPluginJAR(string);
            if (pluginJAR == null) {
                Log.log(1, MiscUtilities.class, "- adding " + string + " to jEdit plugins.");
                jEdit.addPluginJAR(string);
            } else {
                Log.log(1, MiscUtilities.class, "- has been loaded before.");
            }
            return true;
        }
    }

    public static int parsePermissions(String string) {
        int n = 0;
        if (string.length() == 9) {
            if (string.charAt(0) == 'r') {
                n += 256;
            }
            if (string.charAt(1) == 'w') {
                n += 128;
            }
            if (string.charAt(2) == 'x') {
                n += 64;
            } else if (string.charAt(2) == 's') {
                n += 2112;
            } else if (string.charAt(2) == 'S') {
                n += 2048;
            }
            if (string.charAt(3) == 'r') {
                n += 32;
            }
            if (string.charAt(4) == 'w') {
                n += 16;
            }
            if (string.charAt(5) == 'x') {
                n += 8;
            } else if (string.charAt(5) == 's') {
                n += 1032;
            } else if (string.charAt(5) == 'S') {
                n += 1024;
            }
            if (string.charAt(6) == 'r') {
                n += 4;
            }
            if (string.charAt(7) == 'w') {
                n += 2;
            }
            if (string.charAt(8) == 'x') {
                ++n;
            } else if (string.charAt(8) == 't') {
                n += 513;
            } else if (string.charAt(8) == 'T') {
                n += 512;
            }
        }
        return n;
    }

    public static String[] getEncodings(boolean bl) {
        Set<String> set = bl ? EncodingServer.getSelectedNames() : EncodingServer.getAvailableNames();
        return set.toArray(StandardUtilities.EMPTY_STRING_ARRAY);
    }

    public static String throwableToString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    private MiscUtilities() {
    }

    private static boolean compareChars(char c, char c2, boolean bl) {
        if (bl) {
            return Character.toUpperCase(c) == Character.toUpperCase(c2);
        }
        return c == c2;
    }

    private static int getPathStart(@Nonnull String string) {
        if (string.startsWith("/")) {
            return 0;
        }
        if (OperatingSystem.isWindows() && string.length() >= 3 && string.charAt(1) == ':' && (string.charAt(2) == '/' || string.charAt(2) == '\\')) {
            return 3;
        }
        return 0;
    }

    private static boolean containsNullCharacter(Reader reader) throws IOException {
        int n = jEdit.getIntegerProperty("vfs.binaryCheck.length", 100);
        int n2 = jEdit.getIntegerProperty("vfs.binaryCheck.count", 1);
        for (long i = 0L; i < (long)n; ++i) {
            int n3 = reader.read();
            if (n3 == -1) {
                return false;
            }
            if (n3 != 0 || --n2 != 0) continue;
            return true;
        }
        return false;
    }

    private static String replaceNonPathChars(String string, String string2) {
        if (string == null) {
            return null;
        }
        String string3 = ":*?\"<>|";
        StringBuilder stringBuilder = new StringBuilder(20);
        for (int i = 0; i < string3.length(); ++i) {
            stringBuilder.append("\\");
            stringBuilder.append(string3.charAt(i));
        }
        return string.replaceAll("[" + stringBuilder + "]", string2);
    }

    public static void storeProperties(final Properties properties, OutputStream outputStream, String string) throws IOException {
        Properties properties2 = new Properties(){

            @Override
            public synchronized Enumeration<Object> keys() {
                return Collections.enumeration(new TreeSet<Object>(properties.keySet()));
            }

            @Override
            public synchronized Set<Map.Entry<Object, Object>> entrySet() {
                return new TreeMap<Object, Object>(properties).entrySet();
            }
        };
        properties2.putAll((Map<?, ?>)properties);
        properties2.store(outputStream, string);
    }

    static class VarCompressor {
        final Map<String, String> prefixMap = new HashMap<String, String>();
        final Map<String, String> previous = new HashMap<String, String>();

        VarCompressor() {
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            Map<String, String> map = processBuilder.environment();
            if (OperatingSystem.isUnix()) {
                this.prefixMap.put(System.getProperty("user.home"), "~");
            }
            if (jEdit.getSettingsDirectory() != null) {
                this.prefixMap.put(jEdit.getSettingsDirectory(), "JEDIT_SETTINGS");
            }
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String string;
                String string2;
                String string3 = entry.getKey();
                if (string3.equalsIgnoreCase("pwd") || string3.equalsIgnoreCase("oldpwd") || !Character.isLetter(string3.charAt(0)) || !VarCompressor.canBePathPrefix(string2 = entry.getValue())) continue;
                if (string2.endsWith(File.separator)) {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                if (OperatingSystem.isWindows() && (string3.length() + 2 > string2.length() || string3.length() + 1 > string2.length())) continue;
                if (OperatingSystem.isWindows()) {
                    string2 = string2.toLowerCase();
                    string3 = string3.toLowerCase();
                }
                if (this.prefixMap.containsKey(string2) && (string = this.prefixMap.get(string2)).length() < string3.length()) continue;
                this.prefixMap.put(string2, string3);
            }
        }

        String compress(String object) {
            String string;
            String string2 = object;
            if (this.previous.containsKey(object)) {
                return this.previous.get(object);
            }
            String string3 = string = "/";
            for (String string4 : this.prefixMap.keySet()) {
                if (string4.length() < string.length()) continue;
                if (OperatingSystem.isWindows() && ((String)object).toLowerCase().startsWith(string4)) {
                    string = string4;
                } else if (((String)object).startsWith(string4)) {
                    string = string4;
                }
                if (string.equals(string3)) continue;
                String string5 = string2.substring(string.length());
                if (string5.length() < 1 || string5.startsWith(File.separator)) {
                    string3 = string;
                    continue;
                }
                string = string3;
            }
            if (string.length() > 1) {
                String string4;
                String string6 = string2.substring(string.length());
                string4 = this.prefixMap.get(string);
                object = string4.equals("~") ? string4 + (String)string6 : (OperatingSystem.isWindows() ? "%" + string4.toUpperCase() + "%" + (String)string6 : "$" + string4 + (String)string6);
            }
            this.previous.put(string2, (String)object);
            return object;
        }

        private static boolean canBePathPrefix(String string) {
            return !string.contains(File.pathSeparator) && new File(string).isAbsolute();
        }
    }
}

