/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.ajp;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import org.apache.coyote.ActionCode;
import org.apache.coyote.ErrorState;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.ajp.AbstractAjpProcessor;
import org.apache.coyote.ajp.AjpMessage;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.jni.Socket;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.AprEndpoint;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;

public class AjpAprProcessor
extends AbstractAjpProcessor<Long> {
    private static final Log log = LogFactory.getLog(AjpAprProcessor.class);
    protected ByteBuffer inputBuffer = null;
    protected ByteBuffer outputBuffer = null;

    @Override
    protected Log getLog() {
        return log;
    }

    public AjpAprProcessor(int n, AprEndpoint aprEndpoint) {
        super(n, aprEndpoint);
        this.response.setOutputBuffer(new AbstractAjpProcessor.SocketOutputBuffer());
        this.inputBuffer = ByteBuffer.allocateDirect(n * 2);
        this.inputBuffer.limit(0);
        this.outputBuffer = ByteBuffer.allocateDirect(n * 2);
    }

    @Override
    public AbstractEndpoint.Handler.SocketState process(SocketWrapper<Long> socketWrapper) throws IOException {
        RequestInfo requestInfo = this.request.getRequestProcessor();
        requestInfo.setStage(1);
        this.socketWrapper = socketWrapper;
        long l = socketWrapper.getSocket();
        Socket.setrbb(l, this.inputBuffer);
        Socket.setsbb(l, this.outputBuffer);
        boolean bl = false;
        boolean bl2 = false;
        while (!this.getErrorState().isError() && !this.endpoint.isPaused()) {
            try {
                if (!this.readMessage(this.requestHeaderMessage, true, bl2)) break;
                byte by = this.requestHeaderMessage.getByte();
                if (by == 10) {
                    if (this.endpoint.isPaused()) {
                        this.recycle(true);
                        break;
                    }
                    bl = true;
                    if (Socket.send(l, pongMessageArray, 0, pongMessageArray.length) >= 0) continue;
                    this.setErrorState(ErrorState.CLOSE_NOW, null);
                    continue;
                }
                if (by != 2) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Unexpected message: " + by));
                    }
                    this.setErrorState(ErrorState.CLOSE_NOW, null);
                    break;
                }
                bl2 = true;
                this.request.setStartTime(System.currentTimeMillis());
            }
            catch (IOException iOException) {
                this.setErrorState(ErrorState.CLOSE_NOW, iOException);
                break;
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable(throwable);
                log.debug((Object)sm.getString("ajpprocessor.header.error"), throwable);
                this.response.setStatus(400);
                this.setErrorState(ErrorState.CLOSE_CLEAN, throwable);
                this.getAdapter().log(this.request, this.response, 0L);
            }
            if (!this.getErrorState().isError()) {
                requestInfo.setStage(2);
                try {
                    this.prepareRequest();
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable(throwable);
                    log.debug((Object)sm.getString("ajpprocessor.request.prepare"), throwable);
                    this.response.setStatus(500);
                    this.setErrorState(ErrorState.CLOSE_CLEAN, throwable);
                    this.getAdapter().log(this.request, this.response, 0L);
                }
            }
            if (!this.getErrorState().isError() && !bl && this.endpoint.isPaused()) {
                this.response.setStatus(503);
                this.setErrorState(ErrorState.CLOSE_CLEAN, null);
                this.getAdapter().log(this.request, this.response, 0L);
            }
            bl = false;
            if (!this.getErrorState().isError()) {
                try {
                    requestInfo.setStage(3);
                    this.adapter.service(this.request, this.response);
                }
                catch (InterruptedIOException interruptedIOException) {
                    this.setErrorState(ErrorState.CLOSE_NOW, interruptedIOException);
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable(throwable);
                    log.error((Object)sm.getString("ajpprocessor.request.process"), throwable);
                    this.response.setStatus(500);
                    this.setErrorState(ErrorState.CLOSE_CLEAN, throwable);
                    this.getAdapter().log(this.request, this.response, 0L);
                }
            }
            if (this.isAsync() && !this.getErrorState().isError()) break;
            if (!this.finished && this.getErrorState().isIoAllowed()) {
                try {
                    this.finish();
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable(throwable);
                    this.setErrorState(ErrorState.CLOSE_NOW, throwable);
                }
            }
            if (this.getErrorState().isError()) {
                this.response.setStatus(500);
            }
            this.request.updateCounters();
            requestInfo.setStage(6);
            this.recycle(false);
        }
        requestInfo.setStage(7);
        if (!this.getErrorState().isError() && !this.endpoint.isPaused()) {
            if (this.isAsync()) {
                return AbstractEndpoint.Handler.SocketState.LONG;
            }
            return AbstractEndpoint.Handler.SocketState.OPEN;
        }
        return AbstractEndpoint.Handler.SocketState.CLOSED;
    }

    @Override
    protected void actionInternal(ActionCode actionCode, Object object) {
        switch (actionCode) {
            case ASYNC_COMPLETE: {
                if (!this.asyncStateMachine.asyncComplete()) break;
                ((AprEndpoint)this.endpoint).processSocketAsync(this.socketWrapper, SocketStatus.OPEN_READ);
                break;
            }
            case ASYNC_SETTIMEOUT: {
                if (object == null) {
                    return;
                }
                long l = (Long)object;
                this.socketWrapper.setTimeout(l);
                break;
            }
            case ASYNC_DISPATCH: {
                if (!this.asyncStateMachine.asyncDispatch()) break;
                ((AprEndpoint)this.endpoint).processSocketAsync(this.socketWrapper, SocketStatus.OPEN_READ);
            }
        }
    }

    @Override
    protected void resetTimeouts() {
    }

    @Override
    protected void output(byte[] byArray, int n, int n2) throws IOException {
        this.outputBuffer.put(byArray, n, n2);
        long l = (Long)this.socketWrapper.getSocket();
        if (this.outputBuffer.position() > 0) {
            if (l != 0L && Socket.sendbb(l, 0, this.outputBuffer.position()) < 0) {
                this.outputBuffer.clear();
                throw new IOException(sm.getString("ajpprocessor.failedsend"));
            }
            this.outputBuffer.clear();
        }
    }

    protected boolean read(int n) throws IOException {
        if (this.inputBuffer.capacity() - this.inputBuffer.limit() <= n - this.inputBuffer.remaining()) {
            this.inputBuffer.compact();
            this.inputBuffer.limit(this.inputBuffer.position());
            this.inputBuffer.position(0);
        }
        while (this.inputBuffer.remaining() < n) {
            int n2 = Socket.recvbb((Long)this.socketWrapper.getSocket(), this.inputBuffer.limit(), this.inputBuffer.capacity() - this.inputBuffer.limit());
            if (n2 > 0) {
                this.inputBuffer.limit(this.inputBuffer.limit() + n2);
                continue;
            }
            throw new IOException(sm.getString("ajpprocessor.failedread"));
        }
        return true;
    }

    protected boolean readt(int n, boolean bl) throws IOException {
        if (bl && this.inputBuffer.remaining() == 0) {
            return false;
        }
        if (this.inputBuffer.capacity() - this.inputBuffer.limit() <= n - this.inputBuffer.remaining()) {
            this.inputBuffer.compact();
            this.inputBuffer.limit(this.inputBuffer.position());
            this.inputBuffer.position(0);
        }
        while (this.inputBuffer.remaining() < n) {
            int n2 = Socket.recvbb((Long)this.socketWrapper.getSocket(), this.inputBuffer.limit(), this.inputBuffer.capacity() - this.inputBuffer.limit());
            if (n2 > 0) {
                this.inputBuffer.limit(this.inputBuffer.limit() + n2);
                continue;
            }
            if (-n2 == 120005 || -n2 == 120001) {
                return false;
            }
            throw new IOException(sm.getString("ajpprocessor.failedread"));
        }
        return true;
    }

    @Override
    public boolean receive() throws IOException {
        this.first = false;
        this.bodyMessage.reset();
        if (!this.readMessage(this.bodyMessage, false, false)) {
            return false;
        }
        if (this.bodyMessage.getLen() == 0) {
            return false;
        }
        int n = this.bodyMessage.peekInt();
        if (n == 0) {
            return false;
        }
        this.bodyMessage.getBodyBytes(this.bodyBytes);
        this.empty = false;
        return true;
    }

    protected boolean readMessage(AjpMessage ajpMessage, boolean bl, boolean bl2) throws IOException {
        int n = ajpMessage.getHeaderLength();
        if (bl) {
            if (!this.readt(n, bl2)) {
                return false;
            }
        } else {
            this.read(n);
        }
        this.inputBuffer.get(ajpMessage.getBuffer(), 0, n);
        int n2 = ajpMessage.processHeader(true);
        if (n2 < 0) {
            return false;
        }
        if (n2 == 0) {
            return true;
        }
        if (n2 > ajpMessage.getBuffer().length) {
            String string = sm.getString("ajpprocessor.header.tooLong", new Object[]{n2, ajpMessage.getBuffer().length});
            this.getLog().error((Object)string);
            throw new IllegalArgumentException(string);
        }
        this.read(n2);
        this.inputBuffer.get(ajpMessage.getBuffer(), n, n2);
        return true;
    }

    @Override
    public void recycle(boolean bl) {
        super.recycle(bl);
        this.inputBuffer.clear();
        this.inputBuffer.limit(0);
        this.outputBuffer.clear();
    }
}

