/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.vncviewer;

import com.tigervnc.vncviewer.VncViewer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.PlainDocument;

class Dialog
extends JDialog
implements ActionListener,
ItemListener,
KeyListener {
    static double HEAVY = 1.0;
    static double LIGHT = 0.0;
    private Window fullScreenWindow;

    public Dialog(boolean bl) {
        this.setIconImage(VncViewer.frameIcon);
        if (bl) {
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        } else {
            this.setModalityType(Dialog.ModalityType.MODELESS);
        }
    }

    public void showDialog(Component component) {
        this.initDialog();
        if (component != null) {
            this.setLocationRelativeTo(component);
        } else {
            Dimension dimension = this.getToolkit().getScreenSize();
            Dimension dimension2 = this.getSize();
            int n = (dimension.width - dimension2.width) / 2;
            int n2 = (dimension.height - dimension2.height) / 2;
            this.setLocation(n, n2);
        }
        if (this.getModalityType() == Dialog.ModalityType.APPLICATION_MODAL) {
            this.setAlwaysOnTop(true);
        }
        this.setVisible(true);
    }

    public void showDialog() {
        this.showDialog(null);
    }

    public void endDialog() {
        this.setVisible(false);
        this.setAlwaysOnTop(false);
    }

    public void initDialog() {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    protected void addListeners(Container container) {
        for (Component component : container.getComponents()) {
            if (component instanceof JCheckBox) {
                ((JCheckBox)component).addItemListener(this);
                continue;
            }
            if (component instanceof JRadioButton) {
                ((JRadioButton)component).addActionListener(this);
                continue;
            }
            if (component instanceof JButton) {
                ((JButton)component).addActionListener(this);
                continue;
            }
            if (component instanceof JComboBox) {
                ((JComboBox)component).addActionListener(this);
                continue;
            }
            if (component instanceof JTextField) {
                ((JTextField)component).addKeyListener(this);
                continue;
            }
            if (!(component instanceof Container)) continue;
            this.addListeners((Container)component);
        }
    }

    public int getButtonLabelInset(AbstractButton abstractButton) {
        int n = 18;
        int n2 = 4;
        Icon icon = abstractButton.getIcon();
        if (icon == null) {
            if (abstractButton instanceof JCheckBox) {
                icon = (Icon)UIManager.get("CheckBox.icon");
            } else if (abstractButton instanceof JRadioButton) {
                icon = (Icon)UIManager.get("RadioButton.icon");
            }
        }
        if (icon != null) {
            n = Math.max(n, icon.getIconWidth());
        }
        if (abstractButton != null) {
            n2 = Math.max(n2, abstractButton.getIconTextGap());
        }
        return n + n2;
    }

    public static File showChooser(String string, File file, Container container, FileNameExtensionFilter fileNameExtensionFilter) {
        JFileChooser jFileChooser = new JFileChooser(file);
        jFileChooser.setDialogTitle(string);
        jFileChooser.setApproveButtonText("OK  \u21b5");
        jFileChooser.setFileHidingEnabled(false);
        if (fileNameExtensionFilter != null) {
            jFileChooser.setFileFilter(fileNameExtensionFilter);
        }
        if (jFileChooser.showOpenDialog(container) == 0) {
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    public static File showChooser(String string, File file, Container container) {
        return Dialog.showChooser(string, file, container, null);
    }

    protected File showChooser(String string, File file, FileNameExtensionFilter fileNameExtensionFilter) {
        return Dialog.showChooser(string, file, this, fileNameExtensionFilter);
    }

    protected File showChooser(String string, File file) {
        return Dialog.showChooser(string, file, this);
    }

    protected class MyJComboBox
    extends JComboBox {
        public MyJComboBox(Object[] objectArray) {
            super(objectArray);
            if (UIManager.getLookAndFeel().getID().equals("Windows")) {
                this.setBorder(BorderFactory.createCompoundBorder(this.getBorder(), BorderFactory.createEmptyBorder(0, 1, 0, 0)));
            } else if (UIManager.getLookAndFeel().getID().equals("Metal")) {
                ComboBoxEditor comboBoxEditor = this.getEditor();
                JTextField jTextField = (JTextField)comboBoxEditor.getEditorComponent();
                jTextField.setBorder(new CompoundBorder(jTextField.getBorder(), new EmptyBorder(0, 2, 0, 0)));
            }
        }

        public MyJComboBox() {
            new MyJComboBox(null);
        }

        public void setPrototypeDisplayValue(Object object) {
            super.setPrototypeDisplayValue(object);
            boolean bl = this.isEditable();
            this.setEditable(false);
            Dimension dimension = this.getPreferredSize();
            this.setPreferredSize(dimension);
            this.setEditable(bl);
        }

        public void setDocument(PlainDocument plainDocument) {
            ComboBoxEditor comboBoxEditor = this.getEditor();
            JTextField jTextField = (JTextField)comboBoxEditor.getEditorComponent();
            jTextField.setDocument(plainDocument);
        }
    }

    protected class GroupedJRadioButton
    extends JRadioButton {
        public GroupedJRadioButton(String string, ButtonGroup buttonGroup, JComponent jComponent) {
            super(string);
            jComponent.add(this);
            if (buttonGroup != null) {
                buttonGroup.add(this);
            }
        }
    }
}

