/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.xdevapi;

import com.mysql.cj.api.x.core.Warning;
import com.mysql.cj.api.xdevapi.AddStatement;
import com.mysql.cj.api.xdevapi.JsonValue;
import com.mysql.cj.api.xdevapi.Result;
import com.mysql.cj.core.exceptions.AssertionFailedException;
import com.mysql.cj.x.core.MysqlxSession;
import com.mysql.cj.x.core.StatementExecuteOk;
import com.mysql.cj.xdevapi.DbDoc;
import com.mysql.cj.xdevapi.DocumentID;
import com.mysql.cj.xdevapi.JsonParser;
import com.mysql.cj.xdevapi.JsonString;
import com.mysql.cj.xdevapi.UpdateResult;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class AddStatementImpl
implements AddStatement {
    private MysqlxSession mysqlxSession;
    private String schemaName;
    private String collectionName;
    private List<DbDoc> newDocs;

    AddStatementImpl(MysqlxSession mysqlxSession, String schema, String collection, DbDoc newDoc) {
        this.mysqlxSession = mysqlxSession;
        this.schemaName = schema;
        this.collectionName = collection;
        this.newDocs = new ArrayList<DbDoc>();
        this.newDocs.add(newDoc);
    }

    AddStatementImpl(MysqlxSession mysqlxSession, String schema, String collection, DbDoc[] newDocs) {
        this.mysqlxSession = mysqlxSession;
        this.schemaName = schema;
        this.collectionName = collection;
        this.newDocs = new ArrayList<DbDoc>();
        this.newDocs.addAll(Arrays.asList(newDocs));
    }

    @Override
    public AddStatement add(String jsonString) {
        try {
            DbDoc doc = JsonParser.parseDoc(new StringReader(jsonString));
            return this.add(doc);
        }
        catch (IOException ex) {
            throw AssertionFailedException.shouldNotHappen(ex);
        }
    }

    @Override
    public AddStatement add(DbDoc ... docs) {
        this.newDocs.addAll(Arrays.asList(docs));
        return this;
    }

    private List<String> assignIds() {
        return this.newDocs.stream().map(d -> {
            JsonValue id = (JsonValue)d.get("_id");
            if (id != null) {
                return id instanceof JsonString ? ((JsonString)id).getString() : id.toString();
            }
            String newId = DocumentID.generate();
            d.put("_id", new JsonString().setValue(newId));
            return newId;
        }).collect(Collectors.toList());
    }

    private List<String> serializeDocs() {
        return this.newDocs.stream().map(DbDoc::toPackedString).collect(Collectors.toList());
    }

    @Override
    public Result execute() {
        if (this.newDocs.size() == 0) {
            StatementExecuteOk ok = new StatementExecuteOk(0L, null, new ArrayList<Warning>());
            return new UpdateResult(ok, new ArrayList<String>());
        }
        List<String> newIds = this.assignIds();
        StatementExecuteOk ok = this.mysqlxSession.addDocs(this.schemaName, this.collectionName, this.serializeDocs());
        return new UpdateResult(ok, newIds);
    }

    @Override
    public CompletableFuture<Result> executeAsync() {
        List<String> newIds = this.assignIds();
        CompletableFuture<StatementExecuteOk> okF = this.mysqlxSession.asyncAddDocs(this.schemaName, this.collectionName, this.serializeDocs());
        return okF.thenApply(ok -> new UpdateResult((StatementExecuteOk)ok, newIds));
    }
}

