/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.Collections;
import java.util.List;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Table;
import org.gephi.graph.api.TableDiff;
import org.gephi.graph.api.TableObserver;
import org.gephi.graph.impl.ColumnImpl;
import org.gephi.graph.impl.TableImpl;

public class TableObserverImpl
implements TableObserver {
    protected final TableImpl table;
    protected boolean destroyed;
    protected final boolean withDiff;
    protected int tableHash;
    protected TableDiffImpl tableDiff;
    protected Column[] columnCache;
    protected int[] columnHashCache;

    public TableObserverImpl(TableImpl table) {
        this(table, false);
    }

    public TableObserverImpl(TableImpl table, boolean withDiff) {
        this.table = table;
        this.withDiff = withDiff;
        this.columnCache = table.toArray();
        this.refreshColumnsHash();
        this.tableHash = table.deepHashCode();
    }

    @Override
    public synchronized boolean hasTableChanged() {
        int newHash = this.table.deepHashCode();
        boolean changed = newHash != this.tableHash;
        this.tableHash = newHash;
        if (changed && this.withDiff) {
            this.refreshDiff();
        }
        return changed;
    }

    @Override
    public synchronized TableDiff getDiff() {
        if (!this.withDiff) {
            throw new RuntimeException("This observer doesn't compute diffs, set diff setting to true");
        }
        if (this.tableDiff == null) {
            throw new IllegalStateException("The hasGraphChanged() method should be called first and getDiff() only once then");
        }
        TableDiffImpl diff = this.tableDiff;
        this.tableDiff = null;
        return diff;
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    @Override
    public void destroy() {
        this.table.destroyTableObserver(this);
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    protected void destroyObserver() {
        this.tableHash = 0;
        this.columnCache = null;
        this.columnHashCache = null;
        this.tableDiff = null;
        this.destroyed = true;
    }

    protected void refreshDiff() {
        Column[] currentColumns = this.table.toArray();
        this.tableDiff = new TableDiffImpl(currentColumns, this.columnCache, this.columnHashCache);
        this.columnCache = currentColumns;
        this.refreshColumnsHash();
    }

    private void refreshColumnsHash() {
        this.columnHashCache = new int[this.columnCache.length];
        for (int i = 0; i < this.columnCache.length; ++i) {
            this.columnHashCache[i] = ((ColumnImpl)this.columnCache[i]).deepHashCode();
        }
    }

    protected static final class TableDiffImpl
    implements TableDiff {
        protected final ObjectList<Column> addedColumns = new ObjectArrayList();
        protected final ObjectList<Column> removedColumns = new ObjectArrayList();
        protected final ObjectList<Column> modifiedColumns = new ObjectArrayList();

        public TableDiffImpl(Column[] currentColumns, Column[] columnCache, int[] columnHashCache) {
            for (Column currentColumn : currentColumns) {
                if (this.isContained(currentColumn, columnCache)) continue;
                this.addedColumns.add((Object)currentColumn);
            }
            for (int i = 0; i < columnCache.length; ++i) {
                Column cachedColumn = columnCache[i];
                if (!this.isContained(cachedColumn, currentColumns)) {
                    this.removedColumns.add((Object)cachedColumn);
                    continue;
                }
                if (((ColumnImpl)cachedColumn).deepHashCode() == columnHashCache[i]) continue;
                this.modifiedColumns.add((Object)cachedColumn);
            }
        }

        private boolean isContained(Column searchedColumn, Column[] columns) {
            for (Column column : columns) {
                if (!searchedColumn.equals(column)) continue;
                return true;
            }
            return false;
        }

        @Override
        public List<Column> getAddedColumns() {
            if (!this.addedColumns.isEmpty()) {
                return Collections.unmodifiableList(this.addedColumns);
            }
            return Collections.emptyList();
        }

        @Override
        public List<Column> getRemovedColumns() {
            if (!this.removedColumns.isEmpty()) {
                return Collections.unmodifiableList(this.removedColumns);
            }
            return Collections.emptyList();
        }

        @Override
        public List<Column> getModifiedColumns() {
            if (!this.modifiedColumns.isEmpty()) {
                return Collections.unmodifiableList(this.modifiedColumns);
            }
            return Collections.emptyList();
        }
    }
}

