/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.io.File;
import java.util.NoSuchElementException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import mediathek.config.StandardLocations;
import mediathek.tool.CustomConversionHandler;
import mediathek.tool.TimerPool;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.event.ConfigurationEvent;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.sync.ReadWriteSynchronizer;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ApplicationConfiguration {
    public static final String APPLICATION_USER_AGENT = "application.user_agent";
    public static final String APPLICATION_INSTALL_TAB_SWITCH_LISTENER = "application.ui.install_tab_listeners";
    public static final String APPLICATION_UI_TAB_POSITION_TOP = "application.ui.tab_position.top";
    public static final String APPLICATION_UI_MAINWINDOW_MAXIMIZED = "application.ui.mainwindow.maximized";
    public static final String APPLICATION_UI_MAINWINDOW_WIDTH = "application.ui.mainwindow.width";
    public static final String APPLICATION_UI_MAINWINDOW_HEIGHT = "application.ui.mainwindow.height";
    public static final String APPLICATION_UI_MAINWINDOW_LOCATION_X = "application.ui.mainwindow.location.x";
    public static final String APPLICATION_UI_MAINWINDOW_LOCATION_Y = "application.ui.mainwindow.location.y";
    public static final String APPLICATION_UI_MAINWINDOW_TAB_ICONS = "application.ui.mainwindow.tab_icons";
    public static final String APPLICATION_UI_BANDWIDTH_MONITOR_VISIBLE = "application.ui.bandwidth_monitor.visible";
    public static final String APPLICATION_UI_USE_TRAY = "application.ui.tray.use";
    public static final String APPLICATION_UI_FONT_SIZE = "application.ui.font_size";
    public static final String APPLICATION_UI_DOWNLOAD_TAB_DIVIDER_LOCATION = "application.ui.download.tab.divider.location";
    public static final String APPLICATION_UI_BOOKMARKLIST = "application.ui.bookmarklist";
    public static final String APPLICATION_SHOW_NOTIFICATIONS = "application.notifications.show";
    public static final String APPLICATION_SHOW_NATIVE_NOTIFICATIONS = "application.notifications.show_native";
    public static final String APPLICATION_NATIVE_NOTIFICATIONS_SUPPORT = "application.notifications.native_support";
    public static final String APPLICATION_SHOW_ORF_CONFIG_HELP = "application.orf.show_config_help";
    public static final String APPLICATION_DEBUG_HTTP_TRAFFIC_TRACE_LEVEL = "application.debug.http_traffic_trace_level";
    public static final String APPLICATION_NETWORKING_DNS_MODE = "application.networking.dns.ip_mode";
    public static final String APPLICATION_BUTTONS_PANEL_VISIBLE = "application.buttons_panel.visible";
    public static final String GEO_REPORT = "geo.report";
    public static final String GEO_LOCATION = "geo.location";
    public static final String BLACKLIST_DO_NOT_SHOW_GEOBLOCKED_FILMS = "blacklist.show_geoblocked";
    public static final String DATABASE_USE_CLEANER_INTERFACE = "database.cleanup.use_cleaner";
    public static final String DOWNLOAD_RATE_LIMIT = "download.rate.limit";
    public static final String DOWNLOAD_SHOW_LAST_USED_PATH = "download.path.last_used.show";
    public static final String DOWNLOAD_SOUND_BEEP = "download.sound.beep";
    public static final String DOWNLOAD_SHOW_DESCRIPTION = "download.show_description";
    public static final String DOWNLOAD_MAX_SIMULTANEOUS_NUM = "download.max_simultaneous.number";
    public static final String SEARCH_USE_FILM_DESCRIPTIONS = "searchfield.film.search_through_description";
    public static final String FILM_SHOW_DESCRIPTION = "film.show_description";
    public static final String CONFIG_AUTOMATIC_UPDATE_CHECK = "application.automatic_update_check";
    public static final String TAB_FILM_FONT_SIZE = "tab.film.font_size";
    public static final String CLI_CLIENT_DOWNLOAD_LIST_FORMAT = "cli.client.download_list_format";
    private static final Logger logger = LogManager.getLogger();
    private XMLConfiguration config;
    private FileHandler handler;
    private ScheduledFuture<?> future;

    private ApplicationConfiguration() {
        this.setupXmlConfiguration();
        this.createFileHandler();
        this.loadOrCreateConfiguration();
        this.initializeTimedEventWriting();
    }

    public static ApplicationConfiguration getInstance() {
        return ConfigHolder.INSTANCE;
    }

    public static Configuration getConfiguration() {
        return ApplicationConfiguration.getInstance().config;
    }

    private void initializeTimedEventWriting() {
        this.config.addEventListener(ConfigurationEvent.ANY, new TimerTaskListener());
    }

    private void setupXmlConfiguration() {
        this.config = new XMLConfiguration();
        this.config.setConversionHandler(new CustomConversionHandler());
        this.config.setSynchronizer(new ReadWriteSynchronizer());
        this.config.setRootElementName("settings");
        this.config.setThrowExceptionOnMissing(true);
    }

    private void createFileHandler() {
        this.handler = new FileHandler(this.config);
        this.handler.setEncoding("UTF-8");
        String path = StandardLocations.getSettingsDirectory().toString() + File.separatorChar;
        this.handler.setPath(path + "settings.xml");
    }

    private void loadOrCreateConfiguration() {
        try {
            this.handler.load();
            this.updateNewerDefaults();
        }
        catch (ConfigurationException cex) {
            this.createDefaultConfigSettings();
        }
    }

    public void writeConfiguration() {
        try {
            if (this.future != null) {
                this.future.cancel(false);
            }
            this.handler.save();
        }
        catch (ConfigurationException configurationException) {
            logger.debug("Something went wrong while saving the config.", (Throwable)configurationException);
        }
    }

    private void createDefaultConfigSettings() {
        try {
            this.config.setProperty(APPLICATION_USER_AGENT, "MediathekView");
            this.config.setProperty(GEO_REPORT, true);
            this.config.setProperty(GEO_LOCATION, "DE");
            this.handler.save();
        }
        catch (ConfigurationException configurationException) {
            logger.error("Something went wrong while creating the default config.", (Throwable)configurationException);
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.error("A config element is missing.", (Throwable)noSuchElementException);
            System.exit(2);
        }
    }

    private void updateNewerDefaults() {
        if (!this.config.containsKey(GEO_REPORT)) {
            this.config.setProperty(GEO_REPORT, true);
        }
        if (!this.config.containsKey(GEO_LOCATION)) {
            this.config.setProperty(GEO_LOCATION, "DE");
        }
        if (!this.config.containsKey(APPLICATION_INSTALL_TAB_SWITCH_LISTENER)) {
            this.config.setProperty(APPLICATION_INSTALL_TAB_SWITCH_LISTENER, !SystemUtils.IS_OS_MAC_OSX);
        }
    }

    private static class ConfigHolder {
        private static final ApplicationConfiguration INSTANCE = new ApplicationConfiguration();

        private ConfigHolder() {
        }
    }

    private final class TimerTaskListener
    implements EventListener<ConfigurationEvent> {
        private TimerTaskListener() {
        }

        private void launchWriterTask() {
            ApplicationConfiguration.this.future = TimerPool.getTimerPool().schedule(() -> {
                try {
                    logger.trace("Writing app configuration file");
                    ApplicationConfiguration.this.handler.save();
                }
                catch (ConfigurationException e) {
                    logger.error("writing app config file:", (Throwable)e);
                }
                ApplicationConfiguration.this.future = null;
            }, 5L, TimeUnit.SECONDS);
        }

        @Override
        public void onEvent(ConfigurationEvent configurationEvent) {
            if (!configurationEvent.isBeforeUpdate()) {
                if (ApplicationConfiguration.this.future != null) {
                    ApplicationConfiguration.this.future.cancel(false);
                }
                this.launchWriterTask();
            }
        }
    }

    public static class FilmInfoDialog {
        public static final String FILM_INFO_VISIBLE = "film.information.visible";
        public static final String FILM_INFO_LOCATION_X = "film.information.location.x";
        public static final String FILM_INFO_LOCATION_Y = "film.information.location.y";
    }

    public static class FilterDialog {
        public static final String WIDTH = "application.ui.filter_dialog.width";
        public static final String HEIGHT = "application.ui.filter_dialog.height";
        public static final String X = "application.ui.filter_dialog.location.x";
        public static final String Y = "application.ui.filter_dialog.location.y";
        public static final String VISIBLE = "application.ui.filter_dialog.visible";
    }

    public static class LoadFilmListDialog {
        public static final String X = "dialog.load_filmlist.x";
        public static final String Y = "dialog.load_filmlist.y";
        public static final String WIDTH = "dialog.load_filmlist.width";
        public static final String HEIGHT = "dialog.load_filmlist.height";
    }

    public static class HttpProxy {
        public static final String HOST = "http.proxy.hostname";
        public static final String PORT = "http.proxy.port";
        public static final String USER = "http.proxy.user";
        public static final String PASSWORD = "http.proxy.password";
    }

    public static class FilmList {
        public static final String LOAD_TRAILER = "filmlist.load.trailer";
        public static final String LOAD_AUDIO_DESCRIPTION = "filmlist.load.audio_description";
        public static final String LOAD_SIGN_LANGUAGE = "filmlist.load.sign_language";
        public static final String LOAD_NUM_DAYS = "filmlist.load.days";
        public static final String LOAD_LIVESTREAMS = "filmlist.load.livestreams";
        public static final String EXTEND_OLD_FILMLIST = "filmlist.extend_old_filmlist";
    }
}

