/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.rbp;

import ca.odell.glazedlists.impl.ctp.CTPConnectionManager;
import ca.odell.glazedlists.impl.ctp.CTPHandler;
import ca.odell.glazedlists.impl.ctp.CTPHandlerFactory;
import ca.odell.glazedlists.impl.rbp.PeerConnection;
import ca.odell.glazedlists.impl.rbp.PeerResource;
import ca.odell.glazedlists.impl.rbp.Resource;
import ca.odell.glazedlists.impl.rbp.ResourceStatus;
import ca.odell.glazedlists.impl.rbp.ResourceUri;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;

public class Peer
implements CTPHandlerFactory {
    private static Logger logger = Logger.getLogger(Peer.class.toString());
    Map subscribed = new TreeMap();
    Map published = new TreeMap();
    List connections = new ArrayList();
    private CTPConnectionManager connectionManager;

    public Peer(int listenPort) {
        this.connectionManager = new CTPConnectionManager(this, listenPort);
    }

    @Override
    public CTPHandler constructHandler() {
        PeerConnection incoming = new PeerConnection(this);
        this.connections.add(incoming);
        return incoming;
    }

    public void start() throws IOException {
        this.connectionManager.start();
    }

    public void stop() {
        this.connectionManager.getNIODaemon().invokeAndWait(new StopRunnable());
    }

    public void print() {
        System.out.println(" --------  --------  --------  --------  --------  --------  --------  -------- ");
        System.out.println("Subscribed Resources:");
        for (PeerResource resource : this.subscribed.values()) {
            resource.print();
        }
        System.out.println("");
        System.out.println("Published Resources:");
        for (PeerResource resource : this.published.values()) {
            resource.print();
        }
        System.out.println("");
        System.out.println("Connections:");
        for (PeerConnection connection : this.connections) {
            connection.print();
        }
        System.out.println("");
    }

    public ResourceStatus subscribe(Resource resource, String host, int port, String path) {
        PeerResource peerResource = new PeerResource(this, resource, ResourceUri.remote(host, port, path));
        return peerResource.status();
    }

    public ResourceStatus publish(Resource resource, String path) {
        PeerResource peerResource = new PeerResource(this, resource, ResourceUri.local(path));
        return peerResource.status();
    }

    PeerResource getPublishedResource(ResourceUri resourceUri) {
        return (PeerResource)this.published.get(resourceUri);
    }

    PeerConnection getConnection(String host, int port) {
        PeerConnection peerConnection = new PeerConnection(this);
        this.connectionManager.connect(peerConnection, host, port);
        this.connections.add(peerConnection);
        return peerConnection;
    }

    void invokeLater(Runnable runnable2) {
        this.connectionManager.getNIODaemon().invokeLater(runnable2);
    }

    private class StopRunnable
    implements Runnable {
        private StopRunnable() {
        }

        @Override
        public void run() {
            for (PeerResource resource : Peer.this.subscribed.values()) {
                resource.status().disconnect();
            }
            Peer.this.subscribed.clear();
            logger.warning("Closing with published entries");
            ArrayList connectionsToClose = new ArrayList();
            connectionsToClose.addAll(Peer.this.connections);
            for (PeerConnection connection : connectionsToClose) {
                connection.close();
            }
            Peer.this.connectionManager.stop();
        }
    }
}

