/*
 * Decompiled with CFR 0.152.
 */
package net.posick.mDNS.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import net.posick.mDNS.net.NetworkProcessor;
import net.posick.mDNS.net.Packet;
import net.posick.mDNS.net.PacketListener;

public class UnicastProcessor
extends NetworkProcessor {
    protected ServerSocketChannel server;
    protected Selector selector;
    protected Map clients = new HashMap();
    protected Map readBuffers = new HashMap();

    public UnicastProcessor(InetAddress ifaceAddress, InetAddress address, int port, PacketListener listener) throws IOException {
        super(ifaceAddress, address, port, listener);
        this.server = ServerSocketChannel.open();
        this.server.socket().setReuseAddress(true);
        this.server.socket().bind(new InetSocketAddress(address, port));
        this.server.configureBlocking(false);
        this.selector = Selector.open();
        this.server.register(this.selector, 16);
    }

    public void close() throws IOException {
        this.selector.close();
        this.server.socket().close();
        this.server.close();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        data = new byte[this.mtu];
        try {
            block5: while (true) {
                if (this.exit != false) return;
                if (this.selector.select(500L) <= 0) continue;
                i = this.selector.selectedKeys().iterator();
                while (true) {
                    if (i.hasNext()) ** break;
                    continue block5;
                    key = i.next();
                    i.remove();
                    if (key.isValid()) {
                        try {
                            if (key.isConnectable()) {
                                ((SocketChannel)key.channel()).finishConnect();
                            }
                            if (key.isAcceptable()) {
                                client = this.server.accept();
                                client.configureBlocking(false);
                                client.socket().setTcpNoDelay(true);
                                client.socket().setKeepAlive(true);
                                client.register(this.selector, 1);
                                this.clients.put(key, client);
                            }
                            if (key.isReadable()) {
                                channel = (SocketChannel)key.channel();
                                readBuffer = (ByteBuffer)this.readBuffers.get(key);
                                if (readBuffer == null) {
                                    readBuffer = ByteBuffer.allocateDirect(this.mtu);
                                    this.readBuffers.put(key, readBuffer);
                                }
                                if (channel.read(readBuffer) == -1) {
                                    throw new IOException("Read on closed key");
                                }
                                UnicastProcessor.logger.logp(Level.FINE, this.getClass().getName(), "run", "Received message from " + channel.socket().getRemoteSocketAddress());
                                socket = channel.socket();
                                length = readBuffer.limit() - readBuffer.position() - readBuffer.remaining();
                                this.executors.executeNetworkTask(new NetworkProcessor.PacketRunner(this.listener, new Packet[]{new Packet(socket.getLocalAddress(), socket.getPort(), data, 0, length)}));
                            }
                            if (key.isWritable()) continue;
                        }
                        catch (CancelledKeyException e) {
                            this.readBuffers.remove(key);
                        }
                        continue;
                    }
                    this.readBuffers.remove(key);
                }
                break;
            }
        }
        catch (SecurityException e) {
            UnicastProcessor.logger.log(Level.WARNING, "Security issue receiving data from \"" + this.address + "\" - " + e.getMessage(), e);
            return;
        }
        catch (Exception e) {
            if (this.server.isOpen() == false) return;
            if (this.exit != false) return;
            if (UnicastProcessor.logger.isLoggable(Level.FINE) == false) return;
            UnicastProcessor.logger.log(Level.WARNING, "Error receiving data from \"" + this.address + "\" - " + e.getMessage(), e);
        }
    }

    public void send(byte[] data) throws IOException {
    }

    protected static abstract class UnicastRunner
    implements Runnable {
        SocketChannel channel;

        UnicastRunner(SocketChannel channel) {
            this.channel = channel;
        }
    }

    protected static interface SocketListener {
        public void dataReceived();
    }
}

