/*
 * Decompiled with CFR 0.152.
 */
package sun.net.util;

import java.net.URL;
import java.util.Arrays;

public class IPAddressUtil {
    private static final int INADDR4SZ = 4;
    private static final int INADDR16SZ = 16;
    private static final int INT16SZ = 2;
    private static final long L_IPV6_DELIMS = 0L;
    private static final long H_IPV6_DELIMS = 0x28000000L;
    private static final long L_GEN_DELIMS = -8935000888854970368L;
    private static final long H_GEN_DELIMS = 671088641L;
    private static final long L_AUTH_DELIMS = 0x400000000000000L;
    private static final long H_AUTH_DELIMS = 671088641L;
    private static final long L_COLON = 0x400000000000000L;
    private static final long H_COLON = 0L;
    private static final long L_SLASH = 0x800000000000L;
    private static final long H_SLASH = 0L;
    private static final long L_BACKSLASH = 0L;
    private static final long H_BACKSLASH = 0x10000000L;
    private static final long L_NON_PRINTABLE = 0xFFFFFFFFL;
    private static final long H_NON_PRINTABLE = Long.MIN_VALUE;
    private static final long L_EXCLUDE = -8935000884560003073L;
    private static final long H_EXCLUDE = -9223372035915251711L;
    private static final char[] OTHERS = new char[]{'\u2047', '\u2048', '\u2049', '\u2100', '\u2101', '\u2105', '\u2106', '\u2a74', '\ufe55', '\ufe56', '\ufe5f', '\ufe6b', '\uff03', '\uff0f', '\uff1a', '\uff1f', '\uff20'};

    public static byte[] textToNumericFormatV4(String src) {
        if (src.length() == 0) {
            return null;
        }
        byte[] res = new byte[4];
        String[] s = src.split("\\.", -1);
        try {
            switch (s.length) {
                case 1: {
                    long val = Long.parseLong(s[0]);
                    if (val < 0L || val > 0xFFFFFFFFL) {
                        return null;
                    }
                    res[0] = (byte)(val >> 24 & 0xFFL);
                    res[1] = (byte)((val & 0xFFFFFFL) >> 16 & 0xFFL);
                    res[2] = (byte)((val & 0xFFFFL) >> 8 & 0xFFL);
                    res[3] = (byte)(val & 0xFFL);
                    break;
                }
                case 2: {
                    long val = Integer.parseInt(s[0]);
                    if (val < 0L || val > 255L) {
                        return null;
                    }
                    res[0] = (byte)(val & 0xFFL);
                    val = Integer.parseInt(s[1]);
                    if (val < 0L || val > 0xFFFFFFL) {
                        return null;
                    }
                    res[1] = (byte)(val >> 16 & 0xFFL);
                    res[2] = (byte)((val & 0xFFFFL) >> 8 & 0xFFL);
                    res[3] = (byte)(val & 0xFFL);
                    break;
                }
                case 3: {
                    long val;
                    for (int i = 0; i < 2; ++i) {
                        val = Integer.parseInt(s[i]);
                        if (val < 0L || val > 255L) {
                            return null;
                        }
                        res[i] = (byte)(val & 0xFFL);
                    }
                    val = Integer.parseInt(s[2]);
                    if (val < 0L || val > 65535L) {
                        return null;
                    }
                    res[2] = (byte)(val >> 8 & 0xFFL);
                    res[3] = (byte)(val & 0xFFL);
                    break;
                }
                case 4: {
                    for (int i = 0; i < 4; ++i) {
                        long val = Integer.parseInt(s[i]);
                        if (val < 0L || val > 255L) {
                            return null;
                        }
                        res[i] = (byte)(val & 0xFFL);
                    }
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        return res;
    }

    public static byte[] textToNumericFormatV6(String src) {
        if (src.length() < 2) {
            return null;
        }
        char[] srcb = src.toCharArray();
        byte[] dst = new byte[16];
        int srcb_length = srcb.length;
        int pc = src.indexOf("%");
        if (pc == srcb_length - 1) {
            return null;
        }
        if (pc != -1) {
            srcb_length = pc;
        }
        int colonp = -1;
        int i = 0;
        int j = 0;
        if (srcb[i] == ':' && srcb[++i] != ':') {
            return null;
        }
        int curtok = i;
        boolean saw_xdigit = false;
        int val = 0;
        while (i < srcb_length) {
            char ch;
            int chval;
            if ((chval = Character.digit(ch = srcb[i++], 16)) != -1) {
                val <<= 4;
                if ((val |= chval) > 65535) {
                    return null;
                }
                saw_xdigit = true;
                continue;
            }
            if (ch == ':') {
                curtok = i;
                if (!saw_xdigit) {
                    if (colonp != -1) {
                        return null;
                    }
                    colonp = j;
                    continue;
                }
                if (i == srcb_length) {
                    return null;
                }
                if (j + 2 > 16) {
                    return null;
                }
                dst[j++] = (byte)(val >> 8 & 0xFF);
                dst[j++] = (byte)(val & 0xFF);
                saw_xdigit = false;
                val = 0;
                continue;
            }
            if (ch == '.' && j + 4 <= 16) {
                String ia4 = src.substring(curtok, srcb_length);
                int dot_count = 0;
                int index = 0;
                while ((index = ia4.indexOf(46, index)) != -1) {
                    ++dot_count;
                    ++index;
                }
                if (dot_count != 3) {
                    return null;
                }
                byte[] v4addr = IPAddressUtil.textToNumericFormatV4(ia4);
                if (v4addr == null) {
                    return null;
                }
                for (int k = 0; k < 4; ++k) {
                    dst[j++] = v4addr[k];
                }
                saw_xdigit = false;
                break;
            }
            return null;
        }
        if (saw_xdigit) {
            if (j + 2 > 16) {
                return null;
            }
            dst[j++] = (byte)(val >> 8 & 0xFF);
            dst[j++] = (byte)(val & 0xFF);
        }
        if (colonp != -1) {
            int n = j - colonp;
            if (j == 16) {
                return null;
            }
            for (i = 1; i <= n; ++i) {
                dst[16 - i] = dst[colonp + n - i];
                dst[colonp + n - i] = 0;
            }
            j = 16;
        }
        if (j != 16) {
            return null;
        }
        byte[] newdst = IPAddressUtil.convertFromIPv4MappedAddress(dst);
        if (newdst != null) {
            return newdst;
        }
        return dst;
    }

    public static boolean isIPv4LiteralAddress(String src) {
        return IPAddressUtil.textToNumericFormatV4(src) != null;
    }

    public static boolean isIPv6LiteralAddress(String src) {
        return IPAddressUtil.textToNumericFormatV6(src) != null;
    }

    public static byte[] convertFromIPv4MappedAddress(byte[] addr) {
        if (IPAddressUtil.isIPv4MappedAddress(addr)) {
            byte[] newAddr = new byte[4];
            System.arraycopy(addr, 12, newAddr, 0, 4);
            return newAddr;
        }
        return null;
    }

    private static boolean isIPv4MappedAddress(byte[] addr) {
        if (addr.length < 16) {
            return false;
        }
        return addr[0] == 0 && addr[1] == 0 && addr[2] == 0 && addr[3] == 0 && addr[4] == 0 && addr[5] == 0 && addr[6] == 0 && addr[7] == 0 && addr[8] == 0 && addr[9] == 0 && addr[10] == -1 && addr[11] == -1;
    }

    public static boolean match(char c, long lowMask, long highMask) {
        if (c < '@') {
            return (1L << c & lowMask) != 0L;
        }
        if (c < '\u0080') {
            return (1L << c - 64 & highMask) != 0L;
        }
        return false;
    }

    public static int scan(String s, long lowMask, long highMask) {
        int len;
        int i = -1;
        if (s == null || (len = s.length()) == 0) {
            return -1;
        }
        boolean match = false;
        while (++i < len && !(match = IPAddressUtil.match(s.charAt(i), lowMask, highMask))) {
        }
        if (match) {
            return i;
        }
        return -1;
    }

    public static int scan(String s, long lowMask, long highMask, char[] others) {
        char c;
        int len;
        int i = -1;
        if (s == null || (len = s.length()) == 0) {
            return -1;
        }
        boolean match = false;
        char c0 = others[0];
        while (++i < len && !(match = IPAddressUtil.match(c = s.charAt(i), lowMask, highMask))) {
            if (c < c0 || Arrays.binarySearch(others, c) <= -1) continue;
            match = true;
            break;
        }
        if (match) {
            return i;
        }
        return -1;
    }

    private static String describeChar(char c) {
        if (c < ' ' || c == '\u007f') {
            if (c == '\n') {
                return "LF";
            }
            if (c == '\r') {
                return "CR";
            }
            return "control char (code=" + c + ")";
        }
        if (c == '\\') {
            return "'\\'";
        }
        return "'" + c + "'";
    }

    private static String checkUserInfo(String str) {
        int index = IPAddressUtil.scan(str, -9223231260711714817L, -9223372035915251711L);
        if (index >= 0) {
            return "Illegal character found in user-info: " + IPAddressUtil.describeChar(str.charAt(index));
        }
        return null;
    }

    private static String checkHost(String str) {
        if (str.startsWith("[") && str.endsWith("]")) {
            if (IPAddressUtil.isIPv6LiteralAddress(str = str.substring(1, str.length() - 1))) {
                int index = str.indexOf(37);
                if (index >= 0 && (index = IPAddressUtil.scan(str = str.substring(index), 0xFFFFFFFFL, -9223372036183687168L)) >= 0) {
                    return "Illegal character found in IPv6 scoped address: " + IPAddressUtil.describeChar(str.charAt(index));
                }
                return null;
            }
            return "Unrecognized IPv6 address format";
        }
        int index = IPAddressUtil.scan(str, -8935000884560003073L, -9223372035915251711L);
        if (index >= 0) {
            return "Illegal character found in host: " + IPAddressUtil.describeChar(str.charAt(index));
        }
        return null;
    }

    private static String checkAuth(String str) {
        int index = IPAddressUtil.scan(str, -9223231260711714817L, -9223372036586340352L);
        if (index >= 0) {
            return "Illegal character found in authority: " + IPAddressUtil.describeChar(str.charAt(index));
        }
        return null;
    }

    public static String checkAuthority(URL url) {
        if (url == null) {
            return null;
        }
        String u = url.getUserInfo();
        String s = IPAddressUtil.checkUserInfo(u);
        if (s != null) {
            return s;
        }
        String h = url.getHost();
        s = IPAddressUtil.checkHost(h);
        if (s != null) {
            return s;
        }
        if (h == null && u == null) {
            return IPAddressUtil.checkAuth(url.getAuthority());
        }
        return null;
    }

    public static String checkExternalForm(URL url) {
        if (url == null) {
            return null;
        }
        String s = url.getUserInfo();
        int index = IPAddressUtil.scan(s, 0x8000FFFFFFFFL, Long.MIN_VALUE);
        if (index >= 0) {
            return "Illegal character found in authority: " + IPAddressUtil.describeChar(s.charAt(index));
        }
        s = IPAddressUtil.checkHostString(url.getHost());
        if (s != null) {
            return s;
        }
        return null;
    }

    public static String checkHostString(String host) {
        if (host == null) {
            return null;
        }
        int index = IPAddressUtil.scan(host, 0x8000FFFFFFFFL, Long.MIN_VALUE, OTHERS);
        if (index >= 0) {
            return "Illegal character found in host: " + IPAddressUtil.describeChar(host.charAt(index));
        }
        return null;
    }
}

