/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.arara.configuration;

import java.io.File;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.time.ExperimentalTime;
import org.islandoftex.arara.Arara;
import org.islandoftex.arara.configuration.AraraSpec;
import org.islandoftex.arara.configuration.ConfigurationUtils;
import org.islandoftex.arara.configuration.LocalConfiguration;
import org.islandoftex.arara.filehandling.FileHandlingUtils;
import org.islandoftex.arara.localization.Language;
import org.islandoftex.arara.localization.LanguageController;
import org.islandoftex.arara.localization.Messages;
import org.islandoftex.arara.model.AraraException;
import org.islandoftex.arara.model.FileType;
import org.islandoftex.arara.utils.LoggingUtils;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/islandoftex/arara/configuration/Configuration;", "", "()V", "messages", "Lorg/islandoftex/arara/localization/LanguageController;", "load", "", "update", "resource", "Lorg/islandoftex/arara/configuration/LocalConfiguration;", "application"})
public final class Configuration {
    private static final LanguageController messages;
    public static final Configuration INSTANCE;

    @ExperimentalTime
    public final void load() throws AraraException {
        File file2 = ConfigurationUtils.INSTANCE.getConfigFile();
        if (file2 != null) {
            Arara.INSTANCE.getConfig().set(AraraSpec.Execution.INSTANCE.getConfigurationName(), FileHandlingUtils.INSTANCE.getCanonicalPath(file2));
            LocalConfiguration resource2 = ConfigurationUtils.INSTANCE.loadLocalConfiguration(file2);
            this.update(resource2);
        }
        Locale locale = ((Language)Arara.INSTANCE.getConfig().get(AraraSpec.Execution.INSTANCE.getLanguage())).getLocale();
        LanguageController.INSTANCE.setLocale(locale);
    }

    private final void update(LocalConfiguration resource2) throws AraraException {
        Collection collection = resource2.getPaths();
        boolean bl = false;
        if (!collection.isEmpty()) {
            Arara.INSTANCE.getConfig().set(AraraSpec.Execution.INSTANCE.getRulePaths(), ConfigurationUtils.INSTANCE.normalizePaths((Iterable<String>)resource2.getPaths()));
        }
        collection = resource2.getFiletypes();
        bl = false;
        if (!collection.isEmpty()) {
            Arara.INSTANCE.getConfig().set(AraraSpec.Execution.INSTANCE.getFileTypes(), ConfigurationUtils.INSTANCE.normalizeFileTypes((Iterable<FileType>)resource2.getFiletypes()));
        }
        Arara.INSTANCE.getConfig().set(AraraSpec.Execution.INSTANCE.getVerbose(), Boolean.valueOf(resource2.isVerbose()));
        Arara.INSTANCE.getConfig().set(AraraSpec.Execution.INSTANCE.getOnlyHeader(), Boolean.valueOf(resource2.isHeader()));
        Arara.INSTANCE.getConfig().set(AraraSpec.Execution.INSTANCE.getLanguage(), new Language(resource2.getLanguage()));
        Arara.INSTANCE.getConfig().set(AraraSpec.UserInteraction.INSTANCE.getLookAndFeel(), resource2.getLaf());
        Arara.INSTANCE.getConfig().set(AraraSpec.Execution.INSTANCE.getDatabaseName(), ConfigurationUtils.INSTANCE.cleanFileName(resource2.getDbname()));
        Arara.INSTANCE.getConfig().set(AraraSpec.Execution.INSTANCE.getLogName(), ConfigurationUtils.INSTANCE.cleanFileName(resource2.getLogname()));
        Arara.INSTANCE.getConfig().set(AraraSpec.Execution.INSTANCE.getLogging(), Boolean.valueOf(resource2.isLogging()));
        LoggingUtils.INSTANCE.enableLogging(resource2.isLogging());
        int loops = resource2.getLoops();
        if (loops <= 0) {
            throw (Throwable)new AraraException(messages.getMessage((Enum)Messages.ERROR_CONFIGURATION_LOOPS_INVALID_RANGE));
        }
        Arara.INSTANCE.getConfig().set(AraraSpec.Execution.INSTANCE.getMaxLoops(), Integer.valueOf(loops));
        Map<String, String> map2 = resource2.getPreambles();
        boolean bl2 = false;
        if (!map2.isEmpty()) {
            Arara.INSTANCE.getConfig().set(AraraSpec.Execution.INSTANCE.getPreambles(), resource2.getPreambles());
        }
    }

    private Configuration() {
    }

    static {
        Configuration configuration;
        INSTANCE = configuration = new Configuration();
        messages = LanguageController.INSTANCE;
    }
}

