/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import jakarta.servlet.jsp.tagext.FunctionInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jasper.JasperException;

abstract class ELNode {
    ELNode() {
    }

    public abstract void accept(Visitor var1) throws JasperException;

    public static class Visitor {
        public void visit(Root root) throws JasperException {
            root.getExpression().visit(this);
        }

        public void visit(Function function) throws JasperException {
        }

        public void visit(Text text) throws JasperException {
        }

        public void visit(ELText eLText) throws JasperException {
        }
    }

    public static class Nodes {
        private String mapName = null;
        private final List<ELNode> list = new ArrayList<ELNode>();

        public void add(ELNode eLNode) {
            this.list.add(eLNode);
        }

        public void visit(Visitor visitor) throws JasperException {
            for (ELNode eLNode : this.list) {
                eLNode.accept(visitor);
            }
        }

        public Iterator<ELNode> iterator() {
            return this.list.iterator();
        }

        public boolean isEmpty() {
            return this.list.size() == 0;
        }

        public boolean containsEL() {
            for (ELNode eLNode : this.list) {
                if (!(eLNode instanceof Root)) continue;
                return true;
            }
            return false;
        }

        public void setMapName(String string) {
            this.mapName = string;
        }

        public String getMapName() {
            return this.mapName;
        }
    }

    public static class Function
    extends ELNode {
        private final String prefix;
        private final String name;
        private final String originalText;
        private String uri;
        private FunctionInfo functionInfo;
        private String methodName;
        private String[] parameters;

        Function(String string, String string2, String string3) {
            this.prefix = string;
            this.name = string2;
            this.originalText = string3;
        }

        @Override
        public void accept(Visitor visitor) throws JasperException {
            visitor.visit(this);
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getName() {
            return this.name;
        }

        public String getOriginalText() {
            return this.originalText;
        }

        public void setUri(String string) {
            this.uri = string;
        }

        public String getUri() {
            return this.uri;
        }

        public void setFunctionInfo(FunctionInfo functionInfo) {
            this.functionInfo = functionInfo;
        }

        public FunctionInfo getFunctionInfo() {
            return this.functionInfo;
        }

        public void setMethodName(String string) {
            this.methodName = string;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public void setParameters(String[] stringArray) {
            this.parameters = stringArray;
        }

        public String[] getParameters() {
            return this.parameters;
        }
    }

    public static class ELText
    extends ELNode {
        private final String text;

        ELText(String string) {
            this.text = string;
        }

        @Override
        public void accept(Visitor visitor) throws JasperException {
            visitor.visit(this);
        }

        public String getText() {
            return this.text;
        }
    }

    public static class Text
    extends ELNode {
        private final String text;

        Text(String string) {
            this.text = string;
        }

        @Override
        public void accept(Visitor visitor) throws JasperException {
            visitor.visit(this);
        }

        public String getText() {
            return this.text;
        }
    }

    public static class Root
    extends ELNode {
        private final Nodes expr;
        private final char type;

        Root(Nodes nodes, char c) {
            this.expr = nodes;
            this.type = c;
        }

        @Override
        public void accept(Visitor visitor) throws JasperException {
            visitor.visit(this);
        }

        public Nodes getExpression() {
            return this.expr;
        }

        public char getType() {
            return this.type;
        }
    }
}

