/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.filters;

import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.catalina.filters.FilterBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class AddDefaultCharsetFilter
extends FilterBase {
    private final Log log = LogFactory.getLog(AddDefaultCharsetFilter.class);
    private static final String DEFAULT_ENCODING = "ISO-8859-1";
    private String encoding;

    public void setEncoding(String string) {
        this.encoding = string;
    }

    @Override
    protected Log getLogger() {
        return this.log;
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        if (this.encoding == null || this.encoding.length() == 0 || this.encoding.equalsIgnoreCase("default")) {
            this.encoding = DEFAULT_ENCODING;
        } else if (this.encoding.equalsIgnoreCase("system")) {
            this.encoding = Charset.defaultCharset().name();
        } else if (!Charset.isSupported(this.encoding)) {
            throw new IllegalArgumentException(sm.getString("addDefaultCharset.unsupportedCharset", new Object[]{this.encoding}));
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (servletResponse instanceof HttpServletResponse) {
            ResponseWrapper responseWrapper = new ResponseWrapper((HttpServletResponse)servletResponse, this.encoding);
            filterChain.doFilter(servletRequest, (ServletResponse)responseWrapper);
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    public static class ResponseWrapper
    extends HttpServletResponseWrapper {
        private String encoding;

        public ResponseWrapper(HttpServletResponse httpServletResponse, String string) {
            super(httpServletResponse);
            this.encoding = string;
        }

        public void setContentType(String string) {
            if (string != null && string.startsWith("text/")) {
                if (!string.contains("charset=")) {
                    super.setContentType(string + ";charset=" + this.encoding);
                } else {
                    super.setContentType(string);
                    this.encoding = this.getCharacterEncoding();
                }
            } else {
                super.setContentType(string);
            }
        }

        public void setHeader(String string, String string2) {
            if (string.trim().equalsIgnoreCase("content-type")) {
                this.setContentType(string2);
            } else {
                super.setHeader(string, string2);
            }
        }

        public void addHeader(String string, String string2) {
            if (string.trim().equalsIgnoreCase("content-type")) {
                this.setContentType(string2);
            } else {
                super.addHeader(string, string2);
            }
        }

        public void setCharacterEncoding(String string) {
            super.setCharacterEncoding(string);
            this.encoding = string;
        }
    }
}

