/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.jsse;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPathParameters;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.compat.JreVendor;
import org.apache.tomcat.util.file.ConfigFileLoader;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SSLUtil;
import org.apache.tomcat.util.net.ServerSocketFactory;
import org.apache.tomcat.util.net.jsse.JSSEKeyManager;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.security.KeyStoreUtil;

public class JSSESocketFactory
implements ServerSocketFactory,
SSLUtil {
    private static final Log log = LogFactory.getLog(JSSESocketFactory.class);
    private static final StringManager sm = StringManager.getManager((String)"org.apache.tomcat.util.net.jsse.res");
    private static final String defaultProtocol = "TLS";
    private static final String defaultKeystoreType = "JKS";
    private static final String defaultKeystoreFile = System.getProperty("user.home") + "/.keystore";
    private static final int defaultSessionCacheSize = -1;
    private static final int defaultSessionTimeout = 86400;
    private static final String ALLOW_ALL_SUPPORTED_CIPHERS = "ALL";
    public static final String DEFAULT_KEY_PASS = "changeit";
    private AbstractEndpoint<?> endpoint;
    private final boolean rfc5746Supported;
    private final String[] defaultServerProtocols;
    private final String[] defaultServerCipherSuites;
    protected SSLServerSocketFactory sslProxy = null;
    protected String[] enabledCiphers;
    protected String[] enabledProtocols;
    protected boolean allowUnsafeLegacyRenegotiation = false;
    protected boolean requireClientAuth = false;
    protected boolean wantClientAuth = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSSESocketFactory(AbstractEndpoint<?> abstractEndpoint) {
        SSLServerSocket sSLServerSocket;
        SSLContext sSLContext;
        this.endpoint = abstractEndpoint;
        String string = abstractEndpoint.getSslProtocol();
        if (string == null) {
            string = defaultProtocol;
        }
        try {
            sSLContext = SSLContext.getInstance(string);
            sSLContext.init(null, null, null);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalArgumentException(noSuchAlgorithmException);
        }
        catch (KeyManagementException keyManagementException) {
            throw new IllegalArgumentException(keyManagementException);
        }
        SSLServerSocketFactory sSLServerSocketFactory = sSLContext.getServerSocketFactory();
        String[] stringArray = sSLServerSocketFactory.getSupportedCipherSuites();
        boolean bl = false;
        for (String string2 : stringArray) {
            if (!"TLS_EMPTY_RENEGOTIATION_INFO_SCSV".equals(string2)) continue;
            bl = true;
            break;
        }
        this.rfc5746Supported = bl;
        try {
            sSLServerSocket = (SSLServerSocket)sSLServerSocketFactory.createServerSocket();
        }
        catch (IOException iOException) {
            this.defaultServerCipherSuites = new String[0];
            this.defaultServerProtocols = new String[0];
            log.warn((Object)sm.getString("jsse.noDefaultCiphers", new Object[]{abstractEndpoint.getName()}));
            log.warn((Object)sm.getString("jsse.noDefaultProtocols", new Object[]{abstractEndpoint.getName()}));
            return;
        }
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string3 : sSLServerSocket.getEnabledCipherSuites()) {
                if (string3.toUpperCase(Locale.ENGLISH).contains("EXP")) {
                    log.debug((Object)sm.getString("jsse.excludeDefaultCipher", new Object[]{string3}));
                    continue;
                }
                if (string3.toUpperCase(Locale.ENGLISH).contains("_DES_")) {
                    log.debug((Object)sm.getString("jsse.excludeDefaultCipher", new Object[]{string3}));
                    continue;
                }
                if (string3.toUpperCase(Locale.ENGLISH).contains("_RC4_")) {
                    log.debug((Object)sm.getString("jsse.excludeDefaultCipher", new Object[]{string3}));
                    continue;
                }
                if (!JreCompat.isJre8Available() && string3.toUpperCase(Locale.ENGLISH).contains("_DHE_")) {
                    log.debug((Object)sm.getString("jsse.excludeDefaultCipher", new Object[]{string3}));
                    continue;
                }
                if (JreCompat.isJre7Available() && (string3.toUpperCase(Locale.ENGLISH).startsWith("TLS_RSA_") || string3.toUpperCase(Locale.ENGLISH).startsWith("SSL_RSA_"))) {
                    log.debug((Object)sm.getString("jsse.excludeDefaultCipher", new Object[]{string3}));
                    continue;
                }
                arrayList.add(string3);
            }
            this.defaultServerCipherSuites = arrayList.toArray(new String[arrayList.size()]);
            if (this.defaultServerCipherSuites.length == 0) {
                log.warn((Object)sm.getString("jsse.noDefaultCiphers", new Object[]{abstractEndpoint.getName()}));
            }
            ArrayList arrayList2 = new ArrayList();
            for (String string4 : sSLServerSocket.getEnabledProtocols()) {
                if (string4.toUpperCase(Locale.ENGLISH).contains("SSL")) {
                    log.debug((Object)sm.getString("jsse.excludeDefaultProtocol", new Object[]{string4}));
                    continue;
                }
                arrayList2.add(string4);
            }
            this.defaultServerProtocols = arrayList2.toArray(new String[arrayList2.size()]);
            if (this.defaultServerProtocols.length == 0) {
                log.warn((Object)sm.getString("jsse.noDefaultProtocols", new Object[]{abstractEndpoint.getName()}));
            }
        }
        finally {
            try {
                sSLServerSocket.close();
            }
            catch (IOException iOException) {
                log.warn((Object)sm.getString("jsse.exceptionOnClose"), (Throwable)iOException);
            }
        }
    }

    @Override
    public ServerSocket createSocket(int n) throws IOException {
        this.init();
        ServerSocket serverSocket = this.sslProxy.createServerSocket(n);
        this.initServerSocket(serverSocket);
        return serverSocket;
    }

    @Override
    public ServerSocket createSocket(int n, int n2) throws IOException {
        this.init();
        ServerSocket serverSocket = this.sslProxy.createServerSocket(n, n2);
        this.initServerSocket(serverSocket);
        return serverSocket;
    }

    @Override
    public ServerSocket createSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        this.init();
        ServerSocket serverSocket = this.sslProxy.createServerSocket(n, n2, inetAddress);
        this.initServerSocket(serverSocket);
        return serverSocket;
    }

    @Override
    public Socket acceptSocket(ServerSocket serverSocket) throws IOException {
        SSLSocket sSLSocket = null;
        try {
            sSLSocket = (SSLSocket)serverSocket.accept();
        }
        catch (SSLException sSLException) {
            throw new SocketException("SSL handshake error" + sSLException.toString());
        }
        return sSLSocket;
    }

    @Override
    public void handshake(Socket socket) throws IOException {
        SSLSession sSLSession = ((SSLSocket)socket).getSession();
        if (sSLSession.getCipherSuite().equals("SSL_NULL_WITH_NULL_NULL")) {
            throw new IOException("SSL handshake failed. Ciper suite in SSL Session is SSL_NULL_WITH_NULL_NULL");
        }
        if (!this.allowUnsafeLegacyRenegotiation && !this.rfc5746Supported) {
            ((SSLSocket)socket).setEnabledCipherSuites(new String[0]);
        }
    }

    @Override
    public String[] getEnableableCiphers(SSLContext sSLContext) {
        List<String> list;
        String string = this.endpoint.getCiphers();
        if (ALLOW_ALL_SUPPORTED_CIPHERS.equals(string)) {
            return sSLContext.getSupportedSSLParameters().getCipherSuites();
        }
        if (string == null || string.trim().length() == 0) {
            return this.defaultServerCipherSuites;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String object : string.split(",")) {
            String string2 = object.trim();
            if (string2.length() <= 0) continue;
            arrayList.add(string2);
        }
        if (arrayList.isEmpty()) {
            return this.defaultServerCipherSuites;
        }
        ArrayList arrayList2 = new ArrayList(arrayList);
        String[] stringArray = sSLContext.getSupportedSSLParameters().getCipherSuites();
        if (JreVendor.IS_IBM_JVM) {
            list = new ArrayList<String>(stringArray.length * 2);
            for (String string3 : stringArray) {
                list.add(string3);
                if (!string3.startsWith("SSL")) continue;
                list.add(defaultProtocol + string3.substring(3));
            }
        } else {
            list = Arrays.asList(stringArray);
        }
        arrayList2.retainAll(list);
        if (arrayList2.isEmpty()) {
            log.warn((Object)sm.getString("jsse.requested_ciphers_not_supported", new Object[]{string}));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("jsse.enableable_ciphers", new Object[]{arrayList2}));
            if (arrayList2.size() != arrayList.size()) {
                ArrayList arrayList3 = new ArrayList(arrayList);
                arrayList3.removeAll(arrayList2);
                log.debug((Object)sm.getString("jsse.unsupported_ciphers", new Object[]{arrayList3}));
            }
        }
        return arrayList2.toArray(new String[arrayList2.size()]);
    }

    protected String getKeystorePassword() {
        String string = this.endpoint.getKeystorePass();
        if (string == null) {
            string = this.endpoint.getKeyPass();
        }
        if (string == null) {
            string = DEFAULT_KEY_PASS;
        }
        return string;
    }

    protected KeyStore getKeystore(String string, String string2, String string3) throws IOException {
        String string4 = this.endpoint.getKeystoreFile();
        if (string4 == null) {
            string4 = defaultKeystoreFile;
        }
        return this.getStore(string, string2, string4, string3);
    }

    protected KeyStore getTrustStore(String string, String string2) throws IOException {
        String string3;
        String string4;
        String string5;
        KeyStore keyStore = null;
        String string6 = this.endpoint.getTruststoreFile();
        if (string6 == null) {
            string6 = System.getProperty("javax.net.ssl.trustStore");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Truststore = " + string6));
        }
        if ((string5 = this.endpoint.getTruststorePass()) == null) {
            string5 = System.getProperty("javax.net.ssl.trustStorePassword");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("TrustPass = " + string5));
        }
        if ((string4 = this.endpoint.getTruststoreType()) == null) {
            string4 = System.getProperty("javax.net.ssl.trustStoreType");
        }
        if (string4 == null) {
            string4 = string;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("trustType = " + string4));
        }
        if ((string3 = this.endpoint.getTruststoreProvider()) == null) {
            string3 = System.getProperty("javax.net.ssl.trustStoreProvider");
        }
        if (string3 == null) {
            string3 = string2;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("trustProvider = " + string3));
        }
        if (string6 != null) {
            try {
                keyStore = this.getStore(string4, string3, string6, string5);
            }
            catch (IOException iOException) {
                Throwable throwable = iOException.getCause();
                if (throwable instanceof UnrecoverableKeyException) {
                    log.warn((Object)sm.getString("jsse.invalid_truststore_password"), throwable);
                    keyStore = this.getStore(string4, string3, string6, null);
                }
                throw iOException;
            }
        }
        return keyStore;
    }

    private KeyStore getStore(String string, String string2, String string3, String string4) throws IOException {
        KeyStore keyStore = null;
        InputStream inputStream = null;
        try {
            keyStore = string2 == null ? KeyStore.getInstance(string) : KeyStore.getInstance(string, string2);
            if (!"PKCS11".equalsIgnoreCase(string) && !"".equalsIgnoreCase(string3)) {
                inputStream = ConfigFileLoader.getInputStream((String)string3);
            }
            if ("PKCS12".equalsIgnoreCase(string) && string4 != null && string4.length() == 0 && !JreCompat.isJre7Available()) {
                log.error((Object)sm.getString("jsse.java6.emptyPass"));
            }
            char[] cArray = null;
            if (string4 != null && (!"".equals(string4) || defaultKeystoreType.equalsIgnoreCase(string) || "PKCS12".equalsIgnoreCase(string))) {
                cArray = string4.toCharArray();
            }
            KeyStoreUtil.load((KeyStore)keyStore, (InputStream)inputStream, cArray);
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.error((Object)sm.getString("jsse.keystore_load_failed", new Object[]{string, string3, fileNotFoundException.getMessage()}), (Throwable)fileNotFoundException);
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            String string5 = sm.getString("jsse.keystore_load_failed", new Object[]{string, string3, exception.getMessage()});
            log.error((Object)string5, (Throwable)exception);
            throw new IOException(string5);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return keyStore;
    }

    void init() throws IOException {
        try {
            String string = this.endpoint.getClientAuth();
            if ("true".equalsIgnoreCase(string) || "yes".equalsIgnoreCase(string)) {
                this.requireClientAuth = true;
            } else if ("want".equalsIgnoreCase(string)) {
                this.wantClientAuth = true;
            }
            SSLContext sSLContext = this.createSSLContext();
            sSLContext.init(this.getKeyManagers(), this.getTrustManagers(), null);
            SSLSessionContext sSLSessionContext = sSLContext.getServerSessionContext();
            if (sSLSessionContext != null) {
                this.configureSessionContext(sSLSessionContext);
            }
            this.sslProxy = sSLContext.getServerSocketFactory();
            this.enabledCiphers = this.getEnableableCiphers(sSLContext);
            this.enabledProtocols = this.getEnableableProtocols(sSLContext);
            this.allowUnsafeLegacyRenegotiation = "true".equals(this.endpoint.getAllowUnsafeLegacyRenegotiation());
            this.checkConfig();
        }
        catch (Exception exception) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new IOException(exception.getMessage(), exception);
        }
    }

    @Override
    public SSLContext createSSLContext() throws Exception {
        String string = this.endpoint.getSslProtocol();
        if (string == null) {
            string = defaultProtocol;
        }
        SSLContext sSLContext = SSLContext.getInstance(string);
        return sSLContext;
    }

    @Override
    public KeyManager[] getKeyManagers() throws Exception {
        String string;
        String string2 = this.endpoint.getKeystoreType();
        if (string2 == null) {
            string2 = defaultKeystoreType;
        }
        if ((string = this.endpoint.getAlgorithm()) == null) {
            string = KeyManagerFactory.getDefaultAlgorithm();
        }
        return this.getKeyManagers(string2, this.endpoint.getKeystoreProvider(), string, this.endpoint.getKeyAlias());
    }

    @Override
    public TrustManager[] getTrustManagers() throws Exception {
        String string;
        String string2 = this.endpoint.getTruststoreType();
        if (string2 == null) {
            string2 = System.getProperty("javax.net.ssl.trustStoreType");
        }
        if (string2 == null) {
            string2 = this.endpoint.getKeystoreType();
        }
        if (string2 == null) {
            string2 = defaultKeystoreType;
        }
        if ((string = this.endpoint.getTruststoreAlgorithm()) == null) {
            string = TrustManagerFactory.getDefaultAlgorithm();
        }
        return this.getTrustManagers(string2, this.endpoint.getKeystoreProvider(), string);
    }

    @Override
    public void configureSessionContext(SSLSessionContext sSLSessionContext) {
        int n;
        int n2 = this.endpoint.getSessionCacheSize() != null ? Integer.parseInt(this.endpoint.getSessionCacheSize()) : -1;
        if (n2 >= 0) {
            sSLSessionContext.setSessionCacheSize(n2);
        }
        if ((n = this.endpoint.getSessionTimeout() != null ? Integer.parseInt(this.endpoint.getSessionTimeout()) : 86400) >= 0) {
            sSLSessionContext.setSessionTimeout(n);
        }
    }

    protected KeyManager[] getKeyManagers(String string, String string2, String string3, String string4) throws Exception {
        KeyManager[] keyManagerArray = null;
        String string5 = this.getKeystorePassword();
        KeyStore keyStore = this.getKeystore(string, string2, string5);
        if (string4 != null && !keyStore.isKeyEntry(string4)) {
            throw new IOException(sm.getString("jsse.alias_no_key_entry", new Object[]{string4}));
        }
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(string3);
        String string6 = this.endpoint.getKeyPass();
        if (string6 == null) {
            string6 = string5;
        }
        keyManagerFactory.init(keyStore, string6.toCharArray());
        keyManagerArray = keyManagerFactory.getKeyManagers();
        if (string4 != null) {
            String string7 = string4;
            if (defaultKeystoreType.equals(string)) {
                string7 = string7.toLowerCase(Locale.ENGLISH);
            }
            for (int i = 0; i < keyManagerArray.length; ++i) {
                keyManagerArray[i] = new JSSEKeyManager((X509KeyManager)keyManagerArray[i], string7);
            }
        }
        return keyManagerArray;
    }

    protected TrustManager[] getTrustManagers(String string, String string2, String string3) throws Exception {
        String string4 = this.endpoint.getCrlFile();
        String string5 = this.endpoint.getTrustManagerClassName();
        if (string5 != null && string5.length() > 0) {
            ClassLoader classLoader = this.getClass().getClassLoader();
            Class<?> clazz = classLoader.loadClass(string5);
            if (!TrustManager.class.isAssignableFrom(clazz)) {
                throw new InstantiationException(sm.getString("jsse.invalidTrustManagerClassName", new Object[]{string5}));
            }
            Object obj = clazz.newInstance();
            TrustManager trustManager = (TrustManager)obj;
            return new TrustManager[]{trustManager};
        }
        TrustManager[] trustManagerArray = null;
        KeyStore keyStore = this.getTrustStore(string, string2);
        if (keyStore != null || this.endpoint.getTrustManagerClassName() != null) {
            if (string4 == null) {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(string3);
                trustManagerFactory.init(keyStore);
                trustManagerArray = trustManagerFactory.getTrustManagers();
            } else {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(string3);
                CertPathParameters certPathParameters = this.getParameters(string3, string4, keyStore);
                CertPathTrustManagerParameters certPathTrustManagerParameters = new CertPathTrustManagerParameters(certPathParameters);
                trustManagerFactory.init(certPathTrustManagerParameters);
                trustManagerArray = trustManagerFactory.getTrustManagers();
            }
        }
        return trustManagerArray;
    }

    protected CertPathParameters getParameters(String string, String string2, KeyStore keyStore) throws Exception {
        PKIXBuilderParameters pKIXBuilderParameters;
        PKIXBuilderParameters pKIXBuilderParameters2 = null;
        if ("PKIX".equalsIgnoreCase(string)) {
            pKIXBuilderParameters = new PKIXBuilderParameters(keyStore, (CertSelector)new X509CertSelector());
            Collection<? extends CRL> collection = this.getCRLs(string2);
            CollectionCertStoreParameters collectionCertStoreParameters = new CollectionCertStoreParameters(collection);
            CertStore certStore = CertStore.getInstance("Collection", collectionCertStoreParameters);
            pKIXBuilderParameters.addCertStore(certStore);
            pKIXBuilderParameters.setRevocationEnabled(true);
            String string3 = this.endpoint.getTrustMaxCertLength();
            if (string3 != null) {
                try {
                    pKIXBuilderParameters.setMaxPathLength(Integer.parseInt(string3));
                }
                catch (Exception exception) {
                    log.warn((Object)("Bad maxCertLength: " + string3));
                }
            }
        } else {
            throw new CRLException("CRLs not supported for type: " + string);
        }
        pKIXBuilderParameters2 = pKIXBuilderParameters;
        return pKIXBuilderParameters2;
    }

    protected Collection<? extends CRL> getCRLs(String string) throws IOException, CRLException, CertificateException {
        Collection<? extends CRL> collection = null;
        InputStream inputStream = null;
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            inputStream = ConfigFileLoader.getInputStream((String)string);
            collection = certificateFactory.generateCRLs(inputStream);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (CRLException cRLException) {
            throw cRLException;
        }
        catch (CertificateException certificateException) {
            throw certificateException;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return collection;
    }

    @Override
    public String[] getEnableableProtocols(SSLContext sSLContext) {
        String[] stringArray = this.endpoint.getSslEnabledProtocolsArray();
        if (stringArray == null || stringArray.length == 0) {
            return this.defaultServerProtocols;
        }
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        arrayList.retainAll(Arrays.asList(sSLContext.getSupportedSSLParameters().getProtocols()));
        if (arrayList.isEmpty()) {
            log.warn((Object)sm.getString("jsse.requested_protocols_not_supported", new Object[]{Arrays.asList(stringArray)}));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("jsse.enableable_protocols", new Object[]{arrayList}));
            if (arrayList.size() != stringArray.length) {
                ArrayList<String> arrayList2 = new ArrayList<String>(Arrays.asList(stringArray));
                arrayList2.removeAll(arrayList);
                log.debug((Object)sm.getString("jsse.unsupported_protocols", new Object[]{arrayList2}));
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected void configureClientAuth(SSLServerSocket sSLServerSocket) {
        if (this.wantClientAuth) {
            sSLServerSocket.setWantClientAuth(this.wantClientAuth);
        } else {
            sSLServerSocket.setNeedClientAuth(this.requireClientAuth);
        }
    }

    protected void configureUseServerCipherSuitesOrder(SSLServerSocket sSLServerSocket) {
        String string = this.endpoint.getUseServerCipherSuitesOrder().trim();
        if (!"".equals(string)) {
            boolean bl = "true".equalsIgnoreCase(string) || "yes".equalsIgnoreCase(string);
            JreCompat jreCompat = JreCompat.getInstance();
            jreCompat.setUseServerCipherSuitesOrder(sSLServerSocket, bl);
        }
    }

    private void initServerSocket(ServerSocket serverSocket) {
        SSLServerSocket sSLServerSocket = (SSLServerSocket)serverSocket;
        sSLServerSocket.setEnabledCipherSuites(this.enabledCiphers);
        sSLServerSocket.setEnabledProtocols(this.enabledProtocols);
        this.configureClientAuth(sSLServerSocket);
        this.configureUseServerCipherSuitesOrder(sSLServerSocket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkConfig() throws IOException {
        ServerSocket serverSocket = this.sslProxy.createServerSocket();
        this.initServerSocket(serverSocket);
        try {
            serverSocket.setSoTimeout(1);
            serverSocket.accept();
        }
        catch (SSLException sSLException) {
            IOException iOException = new IOException(sm.getString("jsse.invalid_ssl_conf", new Object[]{sSLException.getMessage()}));
            iOException.initCause(sSLException);
            throw iOException;
        }
        catch (Exception exception) {
        }
        finally {
            if (!serverSocket.isClosed()) {
                serverSocket.close();
            }
        }
    }
}

