/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ant.jmx;

import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.apache.catalina.ant.jmx.Arg;
import org.apache.catalina.ant.jmx.JMXAccessorTask;
import org.apache.tools.ant.BuildException;

public class JMXAccessorInvokeTask
extends JMXAccessorTask {
    private String operation;
    private List<Arg> args = new ArrayList<Arg>();
    private static final String info = "org.apache.catalina.ant.JMXAccessorInvokeTask/1.0";

    @Override
    public String getInfo() {
        return info;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String string) {
        this.operation = string;
    }

    public void addArg(Arg arg) {
        this.args.add(arg);
    }

    public List<Arg> getArgs() {
        return this.args;
    }

    public void setArgs(List<Arg> list) {
        this.args = list;
    }

    @Override
    public String jmxExecute(MBeanServerConnection mBeanServerConnection) throws Exception {
        if (this.getName() == null) {
            throw new BuildException("Must specify a 'name'");
        }
        if (this.operation == null) {
            throw new BuildException("Must specify a 'operation' for call");
        }
        return this.jmxInvoke(mBeanServerConnection, this.getName());
    }

    protected String jmxInvoke(MBeanServerConnection mBeanServerConnection, String string) throws Exception {
        Object object;
        if (this.args == null) {
            object = mBeanServerConnection.invoke(new ObjectName(string), this.operation, null, null);
        } else {
            Object[] objectArray = new Object[this.args.size()];
            String[] stringArray = new String[this.args.size()];
            for (int i = 0; i < this.args.size(); ++i) {
                Arg arg = this.args.get(i);
                if (arg.getType() == null) {
                    arg.setType("java.lang.String");
                    stringArray[i] = arg.getType();
                    objectArray[i] = arg.getValue();
                    continue;
                }
                stringArray[i] = arg.getType();
                objectArray[i] = this.convertStringToType(arg.getValue(), arg.getType());
            }
            object = mBeanServerConnection.invoke(new ObjectName(string), this.operation, objectArray, stringArray);
        }
        if (object != null) {
            this.echoResult(this.operation, object);
            this.createProperty(object);
        }
        return null;
    }
}

