/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.fileupload.impl;

import java.io.IOException;
import java.io.InputStream;
import org.apache.tomcat.util.http.fileupload.FileItemHeaders;
import org.apache.tomcat.util.http.fileupload.FileItemStream;
import org.apache.tomcat.util.http.fileupload.FileUploadException;
import org.apache.tomcat.util.http.fileupload.MultipartStream;
import org.apache.tomcat.util.http.fileupload.impl.FileItemIteratorImpl;
import org.apache.tomcat.util.http.fileupload.impl.FileSizeLimitExceededException;
import org.apache.tomcat.util.http.fileupload.impl.FileUploadIOException;
import org.apache.tomcat.util.http.fileupload.util.Closeable;
import org.apache.tomcat.util.http.fileupload.util.LimitedInputStream;
import org.apache.tomcat.util.http.fileupload.util.Streams;

public class FileItemStreamImpl
implements FileItemStream {
    private final FileItemIteratorImpl fileItemIteratorImpl;
    private final String contentType;
    private final String fieldName;
    final String name;
    private final boolean formField;
    private final InputStream stream;
    private FileItemHeaders headers;

    public FileItemStreamImpl(FileItemIteratorImpl fileItemIteratorImpl, String string, String string2, String string3, boolean bl, long l) throws FileUploadException, IOException {
        MultipartStream.ItemInputStream itemInputStream;
        this.fileItemIteratorImpl = fileItemIteratorImpl;
        this.name = string;
        this.fieldName = string2;
        this.contentType = string3;
        this.formField = bl;
        long l2 = this.fileItemIteratorImpl.getFileSizeMax();
        if (l2 != -1L && l != -1L && l > l2) {
            FileSizeLimitExceededException fileSizeLimitExceededException = new FileSizeLimitExceededException(String.format("The field %s exceeds its maximum permitted size of %s bytes.", this.fieldName, l2), l, l2);
            fileSizeLimitExceededException.setFileName(string);
            fileSizeLimitExceededException.setFieldName(string2);
            throw new FileUploadIOException(fileSizeLimitExceededException);
        }
        InputStream inputStream = itemInputStream = this.fileItemIteratorImpl.getMultiPartStream().newInputStream();
        if (l2 != -1L) {
            inputStream = new LimitedInputStream(inputStream, l2){

                @Override
                protected void raiseError(long l, long l2) throws IOException {
                    itemInputStream.close(true);
                    FileSizeLimitExceededException fileSizeLimitExceededException = new FileSizeLimitExceededException(String.format("The field %s exceeds its maximum permitted size of %s bytes.", FileItemStreamImpl.this.fieldName, l), l2, l);
                    fileSizeLimitExceededException.setFieldName(FileItemStreamImpl.this.fieldName);
                    fileSizeLimitExceededException.setFileName(FileItemStreamImpl.this.name);
                    throw new FileUploadIOException(fileSizeLimitExceededException);
                }
            };
        }
        this.stream = inputStream;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public String getName() {
        return Streams.checkFileName(this.name);
    }

    @Override
    public boolean isFormField() {
        return this.formField;
    }

    @Override
    public InputStream openStream() throws IOException {
        if (((Closeable)((Object)this.stream)).isClosed()) {
            throw new FileItemStream.ItemSkippedException();
        }
        return this.stream;
    }

    public void close() throws IOException {
        this.stream.close();
    }

    @Override
    public FileItemHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public void setHeaders(FileItemHeaders fileItemHeaders) {
        this.headers = fileItemHeaders;
    }
}

