/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.threads;

import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.threads.ThreadPoolExecutor;

public class TaskQueue
extends LinkedBlockingQueue<Runnable> {
    private static final long serialVersionUID = 1L;
    protected static final StringManager sm = StringManager.getManager("org.apache.tomcat.util.threads.res");
    private static final int DEFAULT_FORCED_REMAINING_CAPACITY = -1;
    private volatile transient ThreadPoolExecutor parent = null;
    private int forcedRemainingCapacity = -1;

    public TaskQueue() {
    }

    public TaskQueue(int n) {
        super(n);
    }

    public TaskQueue(Collection<? extends Runnable> collection) {
        super(collection);
    }

    public void setParent(ThreadPoolExecutor threadPoolExecutor) {
        this.parent = threadPoolExecutor;
    }

    public boolean force(Runnable runnable) {
        if (this.parent == null || this.parent.isShutdown()) {
            throw new RejectedExecutionException(sm.getString("taskQueue.notRunning"));
        }
        return super.offer(runnable);
    }

    public boolean force(Runnable runnable, long l, TimeUnit timeUnit) throws InterruptedException {
        if (this.parent == null || this.parent.isShutdown()) {
            throw new RejectedExecutionException(sm.getString("taskQueue.notRunning"));
        }
        return super.offer(runnable, l, timeUnit);
    }

    @Override
    public boolean offer(Runnable runnable) {
        if (this.parent == null) {
            return super.offer(runnable);
        }
        if (this.parent.getPoolSize() == this.parent.getMaximumPoolSize()) {
            return super.offer(runnable);
        }
        if (this.parent.getSubmittedCount() <= this.parent.getPoolSize()) {
            return super.offer(runnable);
        }
        if (this.parent.getPoolSize() < this.parent.getMaximumPoolSize()) {
            return false;
        }
        return super.offer(runnable);
    }

    @Override
    public Runnable poll(long l, TimeUnit timeUnit) throws InterruptedException {
        Runnable runnable = (Runnable)super.poll(l, timeUnit);
        if (runnable == null && this.parent != null) {
            this.parent.stopCurrentThreadIfNeeded();
        }
        return runnable;
    }

    @Override
    public Runnable take() throws InterruptedException {
        if (this.parent != null && this.parent.currentThreadShouldBeStopped()) {
            return this.poll(this.parent.getKeepAliveTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
        }
        return (Runnable)super.take();
    }

    @Override
    public int remainingCapacity() {
        if (this.forcedRemainingCapacity > -1) {
            return this.forcedRemainingCapacity;
        }
        return super.remainingCapacity();
    }

    public void setForcedRemainingCapacity(int n) {
        this.forcedRemainingCapacity = n;
    }

    void resetForcedRemainingCapacity() {
        this.forcedRemainingCapacity = -1;
    }
}

