/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.extension;

import java.io.File;
import java.util.Vector;
import java.util.jar.Manifest;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.extension.Extension;
import org.apache.tools.ant.taskdefs.optional.extension.ExtensionAdapter;
import org.apache.tools.ant.taskdefs.optional.extension.ExtensionSet;
import org.apache.tools.ant.taskdefs.optional.extension.ExtensionUtil;

public class JarLibAvailableTask
extends Task {
    private File libraryFile;
    private final Vector extensionFileSets = new Vector();
    private String propertyName;
    private ExtensionAdapter requiredExtension;

    public void setProperty(String property) {
        this.propertyName = property;
    }

    public void setFile(File file) {
        this.libraryFile = file;
    }

    public void addConfiguredExtension(ExtensionAdapter extension) {
        if (null != this.requiredExtension) {
            String message = "Can not specify extension to search for multiple times.";
            throw new BuildException("Can not specify extension to search for multiple times.");
        }
        this.requiredExtension = extension;
    }

    public void addConfiguredExtensionSet(ExtensionSet extensionSet) {
        this.extensionFileSets.addElement(extensionSet);
    }

    public void execute() throws BuildException {
        this.validate();
        Extension test = this.requiredExtension.toExtension();
        if (!this.extensionFileSets.isEmpty()) {
            for (ExtensionSet extensionSet : this.extensionFileSets) {
                Extension[] extensions = extensionSet.toExtensions(this.getProject());
                for (int i = 0; i < extensions.length; ++i) {
                    Extension extension = extensions[i];
                    if (!extension.isCompatibleWith(test)) continue;
                    this.getProject().setNewProperty(this.propertyName, "true");
                }
            }
        } else {
            Manifest manifest = ExtensionUtil.getManifest(this.libraryFile);
            Extension[] extensions = Extension.getAvailable(manifest);
            for (int i = 0; i < extensions.length; ++i) {
                Extension extension = extensions[i];
                if (!extension.isCompatibleWith(test)) continue;
                this.getProject().setNewProperty(this.propertyName, "true");
            }
        }
    }

    private void validate() throws BuildException {
        if (null == this.requiredExtension) {
            String message = "Extension element must be specified.";
            throw new BuildException("Extension element must be specified.");
        }
        if (null == this.libraryFile && this.extensionFileSets.isEmpty()) {
            String message = "File attribute not specified.";
            throw new BuildException("File attribute not specified.");
        }
        if (null != this.libraryFile && !this.libraryFile.exists()) {
            String message = "File '" + this.libraryFile + "' does not exist.";
            throw new BuildException(message);
        }
        if (null != this.libraryFile && !this.libraryFile.isFile()) {
            String message = "'" + this.libraryFile + "' is not a file.";
            throw new BuildException(message);
        }
    }
}

