/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.ontology.wizard.create;

import com.google.common.base.Optional;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.protege.editor.core.ui.util.AugmentedJTextField;
import org.protege.editor.core.ui.wizard.AbstractWizardPanel;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.ontology.OntologyPreferences;
import org.protege.editor.owl.ui.ontology.OntologyPreferencesPanel;
import org.protege.editor.owl.ui.ontology.wizard.create.PhysicalLocationPanel;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyID;

public class OntologyIDPanel
extends AbstractWizardPanel {
    public static final String INSTRUCTIONS = "Please specify the ontology IRI.  \n\nThe ontology IRI is used to identify the ontology in the context of the world wide web. It is recommended that you  set the ontology IRI to be the URL where the latest version of the ontology will be published.  If you use a version IRI, then it is recommended that you set the version IRI to be the URL where this version of the ontology will be published.";
    public static final String ID = "ONTOLOGY_ID_PANEL";
    private AugmentedJTextField ontologyIRIField;
    private AugmentedJTextField versionIRIField;

    public OntologyIDPanel(OWLEditorKit editorKit) {
        super((Object)ID, "Ontology ID", null);
    }

    private void updateState() {
        this.getWizard().setNextFinishButtonEnabled(this.isValidData());
    }

    private boolean isValidData() {
        String ontTxt = this.getOntologyIRIString();
        String versionTxt = this.getOntologyVersionIRIString();
        if (ontTxt.isEmpty()) {
            return versionTxt.isEmpty();
        }
        try {
            URI ontologyURI = new URI(ontTxt);
            this.ontologyIRIField.clearErrorMessage();
            this.ontologyIRIField.clearErrorLocation();
            try {
                if (!versionTxt.isEmpty()) {
                    URI versionURI = new URI(versionTxt);
                    this.versionIRIField.clearErrorMessage();
                    this.versionIRIField.clearErrorLocation();
                    return ontologyURI.isAbsolute() && versionURI.isAbsolute();
                }
            }
            catch (URISyntaxException e) {
                this.versionIRIField.setErrorMessage(e.getMessage());
                this.versionIRIField.setErrorLocation(e.getIndex());
                this.versionIRIField.setToolTipText(e.getMessage());
                return false;
            }
            return ontologyURI.isAbsolute();
        }
        catch (URISyntaxException e) {
            this.ontologyIRIField.setErrorLocation(e.getIndex());
            this.ontologyIRIField.setErrorMessage(e.getMessage());
            this.ontologyIRIField.setToolTipText(e.getMessage());
            return false;
        }
    }

    private String getOntologyVersionIRIString() {
        return this.versionIRIField.getText().trim();
    }

    private String getOntologyIRIString() {
        return this.ontologyIRIField.getText().trim();
    }

    protected void createUI(JComponent parent) {
        this.setInstructions(INSTRUCTIONS);
        this.ontologyIRIField = new AugmentedJTextField(OntologyPreferences.getInstance().generateURI().toString(), "Enter ontology IRI");
        this.ontologyIRIField.setSelectionStart(this.getOntologyIRIString().lastIndexOf("/") + 1);
        this.ontologyIRIField.setSelectionEnd(this.getOntologyIRIString().lastIndexOf(".owl"));
        this.ontologyIRIField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                OntologyIDPanel.this.updateState();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                OntologyIDPanel.this.updateState();
            }
        });
        this.versionIRIField = new AugmentedJTextField("Enter version IRI e.g. " + this.getOntologyIRIString());
        this.versionIRIField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                OntologyIDPanel.this.updateState();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                OntologyIDPanel.this.updateState();
            }
        });
        JButton but = new JButton("Default base...");
        but.addActionListener(e -> {
            OntologyPreferencesPanel.showDialog((Component)((Object)this));
            this.ontologyIRIField.setText(OntologyPreferences.getInstance().generateURI().toString());
        });
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.add((Component)but, "East");
        JPanel holderPanel = new JPanel(new GridBagLayout());
        Insets insets = new Insets(0, 0, 0, 0);
        holderPanel.add((Component)this.createLabel("Ontology IRI"), new GridBagConstraints(0, 0, 1, 1, 100.0, 100.0, 17, 0, insets, 0, 0));
        holderPanel.add((Component)this.ontologyIRIField, new GridBagConstraints(0, 1, 1, 1, 100.0, 100.0, 17, 2, insets, 0, 0));
        holderPanel.add(Box.createVerticalStrut(12), new GridBagConstraints(0, 2, 1, 1, 100.0, 100.0, 17, 2, insets, 0, 0));
        Insets versionIRIInsets = new Insets(0, 0, 0, 0);
        holderPanel.add((Component)this.createLabel("Ontology Version IRI (Optional)"), new GridBagConstraints(0, 4, 1, 1, 100.0, 100.0, 17, 0, versionIRIInsets, 0, 5));
        holderPanel.add((Component)this.versionIRIField, new GridBagConstraints(0, 5, 1, 1, 100.0, 100.0, 17, 2, versionIRIInsets, 0, 0));
        parent.setLayout(new BorderLayout());
        parent.add((Component)holderPanel, "North");
        parent.add((Component)buttonPanel, "South");
    }

    private JLabel createLabel(String text) {
        JLabel label = new JLabel(text);
        label.setFont(label.getFont().deriveFont(1));
        return label;
    }

    public OWLOntologyID getOntologyID() {
        try {
            URI ontologyURI = new URI(this.getOntologyIRIString());
            IRI ontologyIRI = IRI.create((URI)ontologyURI);
            String ontologyVersionIRIString = this.getOntologyVersionIRIString();
            if (ontologyVersionIRIString.isEmpty()) {
                return new OWLOntologyID(Optional.of((Object)ontologyIRI), Optional.absent());
            }
            URI versionURI = new URI(ontologyVersionIRIString);
            IRI versionIRI = IRI.create((URI)versionURI);
            return new OWLOntologyID(Optional.of((Object)ontologyIRI), Optional.of((Object)versionIRI));
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public Object getNextPanelDescriptor() {
        return PhysicalLocationPanel.ID;
    }

    public void displayingPanel() {
        this.ontologyIRIField.requestFocus();
        this.updateState();
    }
}

