/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.workspace.tabs;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.protege.editor.core.ui.action.ProtegeAction;
import org.protege.editor.core.ui.util.UIUtil;
import org.protege.editor.core.ui.workspace.TabbedWorkspace;
import org.protege.editor.core.ui.workspace.WorkspaceViewsTab;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportTabAction
extends ProtegeAction {
    private static final long serialVersionUID = 7371237404306047078L;
    private final Logger logger = LoggerFactory.getLogger(ExportTabAction.class);

    @Override
    public void initialise() throws Exception {
    }

    @Override
    public void dispose() throws Exception {
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        TabbedWorkspace workspace = (TabbedWorkspace)this.getWorkspace();
        HashSet<String> extensions = new HashSet<String>();
        extensions.add("xml");
        String fileName = workspace.getSelectedTab().getLabel().replace(' ', '_') + ".layout.xml";
        File f = UIUtil.saveFile((Window)SwingUtilities.getAncestorOfClass(Window.class, workspace), "Save layout to", "XML Layout", extensions, fileName);
        if (f == null) {
            return;
        }
        try {
            f.getParentFile().mkdirs();
            FileWriter writer = new FileWriter(f);
            ((WorkspaceViewsTab)workspace.getSelectedTab()).getViewsPane().saveViews(writer);
            writer.close();
            JOptionPane.showMessageDialog(workspace, "Layout saved to: " + f);
        }
        catch (IOException e) {
            this.logger.error("An error occurred when saving a tab layout to {}.", (Object)f, (Object)e);
            JOptionPane.showMessageDialog(workspace, "There was a problem saving the layout", "Error", 0);
        }
    }
}

