/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.time;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class TimeFormatting {
    private static final int MILLIS_PER_SECOND = 1000;
    private static final int MILLIS_PER_MINUTE = 60000;
    private static final int MILLIS_PER_HOUR = 3600000;
    private static final int MILLIS_PER_DAY = 86400000;

    private TimeFormatting() {
    }

    public static String formatDurationVerbose(long durationMillis) {
        StringBuilder result = new StringBuilder();
        if (durationMillis > 3600000L) {
            result.append(durationMillis / 3600000L).append(" hrs ");
        }
        if (durationMillis > 60000L) {
            result.append(durationMillis % 3600000L / 60000L).append(" mins ");
        }
        result.append((double)(durationMillis % 60000L) / 1000.0).append(" secs");
        return result.toString();
    }

    public static String formatDurationTerse(long elapsedTimeInMs) {
        StringBuilder result = new StringBuilder();
        if (elapsedTimeInMs > 3600000L) {
            result.append(elapsedTimeInMs / 3600000L).append("h ");
        }
        if (elapsedTimeInMs > 60000L) {
            result.append(elapsedTimeInMs % 3600000L / 60000L).append("m ");
        }
        result.append(elapsedTimeInMs % 60000L / 1000L).append("s");
        return result.toString();
    }

    public static String formatDurationVeryTerse(long duration) {
        if (duration == 0L) {
            return "0s";
        }
        StringBuilder result = new StringBuilder();
        long days = duration / 86400000L;
        duration %= 86400000L;
        if (days > 0L) {
            result.append(days);
            result.append("d");
        }
        long hours = duration / 3600000L;
        duration %= 3600000L;
        if (hours > 0L || result.length() > 0) {
            result.append(hours);
            result.append("h");
        }
        long minutes = duration / 60000L;
        duration %= 60000L;
        if (minutes > 0L || result.length() > 0) {
            result.append(minutes);
            result.append("m");
        }
        int secondsScale = result.length() > 0 ? 2 : 3;
        result.append(BigDecimal.valueOf(duration).divide(BigDecimal.valueOf(1000L)).setScale(secondsScale, RoundingMode.HALF_UP));
        result.append("s");
        return result.toString();
    }
}

