/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.awt.EventQueue;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nonnull;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.ActionSet;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBPlugin;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.JARClassLoader;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.buffer.DummyFoldHandler;
import org.gjt.sp.jedit.buffer.FoldHandler;
import org.gjt.sp.jedit.gui.DockableWindowFactory;
import org.gjt.sp.jedit.io.CharsetEncoding;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.manager.BufferManager;
import org.gjt.sp.jedit.msg.PluginUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

public class PluginJAR {
    private final String path;
    private String cachePath;
    private final File file;
    private final JARClassLoader classLoader;
    private ZipFile zipFile;
    private Properties properties;
    private Map<String, Properties> localizationProperties;
    private String[] classes;
    private String[] resources;
    private ActionSet actions;
    private ActionSet browserActions;
    private EditPlugin plugin;
    private URL dockablesURI;
    private URL servicesURI;
    private boolean activated;
    private final Set<String> theseRequireMe = new LinkedHashSet<String>();
    private final Set<String> theseUseMe = new LinkedHashSet<String>();
    private final Set<String> weRequireThese = new LinkedHashSet<String>();
    private final Set<String> weUseThese = new LinkedHashSet<String>();

    public static PluginJAR load(String string, boolean bl) {
        Object object;
        Collection<String> collection;
        PluginJAR pluginJAR = jEdit.getPluginJAR(string);
        if (pluginJAR != null && pluginJAR.getPlugin() != null) {
            return pluginJAR;
        }
        jEdit.addPluginJAR(string);
        pluginJAR = jEdit.getPluginJAR(string);
        if (pluginJAR == null) {
            return null;
        }
        EditPlugin editPlugin = pluginJAR.getPlugin();
        if (editPlugin == null) {
            return pluginJAR;
        }
        String string2 = editPlugin.getClassName();
        if (bl) {
            collection = PluginJAR.getDependencySet(string2);
            for (String string3 : collection) {
                object = PluginJAR.findPlugin(string3);
                if (object == null) {
                    Log.log(7, PluginJAR.class, "Unable to load dependency " + string3 + " the plugin is not installed");
                    continue;
                }
                PluginJAR.load((String)object, true);
            }
        }
        collection = pluginJAR.getJars();
        Iterator<Object> iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string4 = (String)iterator.next();
            object = jEdit.getPluginJAR(string4);
            if (object != null) continue;
            jEdit.addPluginJAR(string4);
        }
        pluginJAR.checkDependencies();
        pluginJAR.activatePluginIfNecessary();
        jEdit.propertiesChanged();
        for (Iterator<Object> iterator2 : iterator = jEdit.getPluginJARs()) {
            PluginDepends[] pluginDependsArray;
            EditPlugin editPlugin2;
            if (iterator2 == null || iterator2.equals(pluginJAR) || (editPlugin2 = ((PluginJAR)((Object)iterator2)).getPlugin()) == null) continue;
            String string5 = editPlugin2.getClassName();
            for (PluginDepends pluginDepends : pluginDependsArray = PluginJAR.getPluginDepends(string5)) {
                if (!"plugin".equals(pluginDepends.what) || !string2.equals(pluginDepends.name)) continue;
                String string6 = editPlugin2.getPluginJAR().getPath();
                jEdit.removePluginJAR(editPlugin2.getPluginJAR(), false);
                PluginJAR.load(string6, true);
            }
        }
        return pluginJAR;
    }

    public static Collection<String> parseJarsFilesString(String string, String string2) {
        String string3 = MiscUtilities.getParentOfPath(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        LinkedList<String> linkedList = new LinkedList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = MiscUtilities.constructPath(string3, stringTokenizer.nextToken());
            linkedList.add(string4);
        }
        return linkedList;
    }

    public static Collection<String> parseJarsFilesStringNames(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        LinkedList<String> linkedList = new LinkedList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            linkedList.add(stringTokenizer.nextToken());
        }
        return linkedList;
    }

    public Collection<String> getJars() {
        String string;
        if (this.plugin != null && (string = jEdit.getProperty("plugin." + this.plugin.getClassName() + ".jars")) != null) {
            return PluginJAR.parseJarsFilesString(this.path, string);
        }
        return Collections.emptyList();
    }

    public Collection<String> getFiles() {
        String string;
        if (this.plugin != null && (string = jEdit.getProperty("plugin." + this.plugin.getClassName() + ".files")) != null) {
            return PluginJAR.parseJarsFilesString(this.path, string);
        }
        return Collections.emptyList();
    }

    public String getPath() {
        return this.path;
    }

    public static String findPlugin(String string) {
        EditPlugin editPlugin = jEdit.getPlugin(string);
        if (editPlugin != null) {
            return editPlugin.getPluginJAR().getPath();
        }
        for (String string2 : jEdit.getNotLoadedPluginJARs()) {
            PluginJAR pluginJAR = new PluginJAR(new File(string2));
            if (!pluginJAR.containsClass(string)) continue;
            return string2;
        }
        return null;
    }

    boolean containsClass(String string) {
        try {
            this.getZipFile();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        Enumeration<? extends ZipEntry> enumeration = this.zipFile.entries();
        while (enumeration.hasMoreElements()) {
            String string2;
            String string3 = enumeration.nextElement().toString();
            if (!string3.endsWith(".class") || !(string2 = string3.substring(0, string3.length() - 6).replace('/', '.')).equals(string)) continue;
            return true;
        }
        return false;
    }

    public String getCachePath() {
        return this.cachePath;
    }

    public static Set<String> getDependencySet(String string) {
        PluginDepends[] pluginDependsArray;
        Set<String> set = new LinkedHashSet<String>();
        for (PluginDepends pluginDepends : pluginDependsArray = PluginJAR.getPluginDepends(string)) {
            if (pluginDepends.optional || !"plugin".equals(pluginDepends.what)) continue;
            int n = pluginDepends.arg.indexOf(32);
            if (n == -1) {
                Log.log(9, PluginJAR.class, string + " has an invalid dependency: " + pluginDepends.dep + " (version is missing)");
                continue;
            }
            String string2 = pluginDepends.arg.substring(0, n);
            String string3 = pluginDepends.arg.substring(n + 1);
            Set<String> set2 = PluginJAR.getDependencySet(string2);
            set2.add(string2);
            set2.addAll(set);
            set = set2;
        }
        return set;
    }

    public File getFile() {
        return this.file;
    }

    public JARClassLoader getClassLoader() {
        return this.classLoader;
    }

    public synchronized ZipFile getZipFile() throws IOException {
        if (this.zipFile == null) {
            Log.log(1, this, "Opening " + this.path);
            this.zipFile = new ZipFile(this.path);
        }
        return this.zipFile;
    }

    public ActionSet getActionSet() {
        return this.actions;
    }

    public ActionSet getBrowserActionSet() {
        return this.browserActions;
    }

    public boolean checkDependencies() {
        if (this.plugin == null) {
            return true;
        }
        boolean bl = true;
        String string = this.plugin.getClassName();
        PluginDepends[] pluginDependsArray = PluginJAR.getPluginDepends(string);
        for (PluginDepends object : pluginDependsArray) {
            Object[] objectArray;
            if ("jdk".equals(object.what)) {
                if (object.optional || StandardUtilities.compareStrings(System.getProperty("java.version"), object.arg, false) >= 0) continue;
                Object[] n = new String[]{object.arg, System.getProperty("java.version")};
                jEdit.pluginError(this.path, "plugin-error.dep-jdk", n);
                bl = false;
                continue;
            }
            if ("jedit".equals(object.what)) {
                if (object.arg.length() != 11) {
                    Log.log(9, this, "Invalid jEdit version number: " + object.arg);
                    bl = false;
                }
                if (object.optional || StandardUtilities.compareStrings(jEdit.getBuild(), object.arg, false) >= 0) continue;
                String exception = MiscUtilities.buildToVersion(object.arg);
                objectArray = new String[]{exception, jEdit.getVersion()};
                jEdit.pluginError(this.path, "plugin-error.dep-jedit", objectArray);
                bl = false;
                continue;
            }
            if ("plugin".equals(object.what)) {
                Object[] objectArray2;
                int objectArray3 = object.arg.indexOf(32);
                if (objectArray3 == -1) {
                    Log.log(9, this, string + " has an invalid dependency: " + object.dep + " (version is missing)");
                    bl = false;
                    continue;
                }
                objectArray = object.arg.substring(0, objectArray3);
                String string2 = object.arg.substring(objectArray3 + 1);
                String string3 = jEdit.getProperty("plugin." + (String)objectArray + ".version");
                EditPlugin editPlugin = jEdit.getPlugin((String)objectArray, false);
                if (editPlugin == null) {
                    if (object.optional) continue;
                    objectArray2 = new String[]{string2, objectArray};
                    jEdit.pluginError(this.path, "plugin-error.dep-plugin.no-version", objectArray2);
                    bl = false;
                    continue;
                }
                if (StandardUtilities.compareStrings(string3, string2, false) < 0) {
                    if (object.optional) continue;
                    objectArray2 = new String[]{string2, objectArray, string3};
                    jEdit.pluginError(this.path, "plugin-error.dep-plugin", objectArray2);
                    bl = false;
                    continue;
                }
                if (editPlugin instanceof EditPlugin.Broken) {
                    if (object.optional) continue;
                    objectArray2 = new String[]{objectArray};
                    jEdit.pluginError(this.path, "plugin-error.dep-plugin.broken", objectArray2);
                    bl = false;
                    continue;
                }
                objectArray2 = editPlugin.getPluginJAR();
                if (object.optional) {
                    objectArray2.theseUseMe.add(this.path);
                    this.weUseThese.add(objectArray2.getPath());
                    continue;
                }
                objectArray2.theseRequireMe.add(this.path);
                this.weRequireThese.add(objectArray2.getPath());
                continue;
            }
            if ("class".equals(object.what)) {
                if (object.optional) continue;
                try {
                    this.classLoader.loadClass(object.arg, false);
                }
                catch (Exception exception) {
                    objectArray = new String[]{object.arg};
                    jEdit.pluginError(this.path, "plugin-error.dep-class", objectArray);
                    bl = false;
                }
                continue;
            }
            Log.log(9, this, string + " has unknown dependency: " + object.dep);
            bl = false;
        }
        Collection<String> collection = this.getJars();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string5 = (String)iterator.next();
            PluginJAR pluginJAR = jEdit.getPluginJAR(string5);
            if (pluginJAR == null) {
                Object[] objectArray = new String[]{string5};
                jEdit.pluginError(this.path, "plugin-error.missing-jar", objectArray);
                bl = false;
                continue;
            }
            this.weRequireThese.add(string5);
            pluginJAR.theseRequireMe.add(this.path);
        }
        if (!bl) {
            this.breakPlugin();
        }
        return bl;
    }

    public Set<String> getRequiredJars() {
        return this.weRequireThese;
    }

    private static PluginDepends[] getPluginDepends(String string) throws IllegalArgumentException {
        String string2;
        ArrayList<PluginDepends> arrayList = new ArrayList<PluginDepends>();
        int n = 0;
        while ((string2 = jEdit.getProperty("plugin." + string + ".depend." + n++)) != null) {
            boolean bl;
            if (string2.startsWith("optional ")) {
                bl = true;
                string2 = string2.substring("optional ".length());
            } else {
                bl = false;
            }
            int n2 = string2.indexOf(32);
            if (n2 == -1) {
                throw new IllegalArgumentException("wrong dependency");
            }
            String string3 = string2.substring(0, n2);
            String string4 = string2.substring(n2 + 1);
            PluginDepends pluginDepends = new PluginDepends();
            pluginDepends.what = string3;
            pluginDepends.arg = string4;
            pluginDepends.optional = bl;
            pluginDepends.dep = string2;
            if ("plugin".equals(string3)) {
                pluginDepends.name = string4.indexOf(32) > 0 ? string4.substring(0, string4.indexOf(32)) : string4;
            }
            arrayList.add(pluginDepends);
        }
        return arrayList.toArray(new PluginDepends[arrayList.size()]);
    }

    @Nonnull
    public static Set<String> getDependencies(String string) throws IllegalArgumentException {
        String string2;
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        while ((string2 = jEdit.getProperty("plugin." + string + ".depend." + n++)) != null) {
            int n2 = string2.indexOf(32);
            String string3 = string2.substring(0, n2);
            String string4 = string2.substring(n2 + 1);
            if (!"plugin".equals(string3)) continue;
            hashSet.add(string4.indexOf(32) > 0 ? string4.substring(0, string4.indexOf(32)) : string4);
        }
        return hashSet;
    }

    public static Set<String> getOptionalDependencies(String string) throws IllegalArgumentException {
        String string2;
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        while ((string2 = jEdit.getProperty("plugin." + string + ".depend." + n++)) != null) {
            int n2 = string2.indexOf(32);
            String string3 = string2.substring(0, n2);
            String string4 = string2.substring(n2 + 1);
            if (!"optional".equals(string3)) continue;
            n2 = string4.indexOf(32);
            string3 = string4.substring(0, n2);
            string4 = string4.substring(n2 + 1);
            if (!"plugin".equals(string3)) continue;
            hashSet.add(string4.indexOf(32) > 0 ? string4.substring(0, string4.indexOf(32)) : string4);
        }
        return hashSet;
    }

    public static void transitiveClosure(String[] stringArray, List<String> list) {
        for (String string : stringArray) {
            if (list.contains(string)) continue;
            list.add(string);
            PluginJAR pluginJAR = jEdit.getPluginJAR(string);
            if (pluginJAR == null) {
                Log.log(7, PluginJAR.class, "The jar file " + string + " doesn't exist, the plugin may have been partially removed");
                continue;
            }
            PluginJAR.transitiveClosure(pluginJAR.getDependentPlugins(), list);
        }
    }

    public String[] getDependentPlugins() {
        return this.theseRequireMe.toArray(StandardUtilities.EMPTY_STRING_ARRAY);
    }

    public String[] getOptionallyDependentPlugins() {
        return this.theseUseMe.toArray(StandardUtilities.EMPTY_STRING_ARRAY);
    }

    public String[] getAllDependentPlugins() {
        String[] stringArray = new String[this.theseRequireMe.size() + this.theseUseMe.size()];
        System.arraycopy(this.theseRequireMe.toArray(), 0, stringArray, 0, this.theseRequireMe.size());
        System.arraycopy(this.theseUseMe.toArray(), 0, stringArray, this.theseRequireMe.size(), this.theseUseMe.size());
        return stringArray;
    }

    public EditPlugin getPlugin() {
        return this.plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activatePlugin() {
        Object object = this;
        synchronized (object) {
            if (this.activated) {
                return;
            }
            this.activated = true;
        }
        if (!(this.plugin instanceof EditPlugin.Deferred)) {
            return;
        }
        object = this.plugin.getClassName();
        try {
            Class clazz = this.classLoader.loadClass((String)object, false);
            int n = clazz.getModifiers();
            if (Modifier.isInterface(n) || Modifier.isAbstract(n) || !EditPlugin.class.isAssignableFrom(clazz)) {
                Log.log(9, this, "Plugin has properties but does not extend EditPlugin: " + (String)object);
                this.breakPlugin();
                return;
            }
            this.plugin = (EditPlugin)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.plugin.jar = this;
        }
        catch (Throwable throwable) {
            this.breakPlugin();
            Log.log(9, this, "Error while starting plugin " + (String)object);
            Log.log(9, this, throwable);
            Object[] objectArray = new String[]{throwable.toString()};
            jEdit.pluginError(this.path, "plugin-error.start-error", objectArray);
            return;
        }
        if (jEdit.isMainThread() || SwingUtilities.isEventDispatchThread()) {
            this.startPlugin();
        } else {
            this.startPluginLater();
        }
        EditBus.sendAsync(new PluginUpdate(this, PluginUpdate.ACTIVATED, false));
    }

    public void activatePluginIfNecessary() {
        String string = MiscUtilities.getFileName(this.getPath());
        jEdit.unsetProperty("plugin-blacklist." + string);
        if (!(this.plugin instanceof EditPlugin.Deferred)) {
            return;
        }
        String string2 = this.plugin.getClassName();
        String string3 = jEdit.getProperty("plugin." + string2 + ".activate");
        if (string3 == null) {
            if (!jEdit.isMainThread()) {
                this.breakPlugin();
                jEdit.pluginError(this.path, "plugin-error.not-42", null);
            } else {
                this.activatePlugin();
            }
        } else {
            boolean bl = false;
            StringTokenizer stringTokenizer = new StringTokenizer(string3);
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                boolean bl2 = jEdit.getBooleanProperty(string4);
                if (!bl2) continue;
                Log.log(1, this, "Activating " + string2 + " because of " + string4);
                bl = true;
                break;
            }
            if (bl) {
                this.activatePlugin();
            }
        }
    }

    public void deactivatePlugin(boolean bl) {
        Object object;
        if (!this.activated) {
            return;
        }
        if (!bl) {
            object = jEdit.getBufferManager();
            object.getBuffers().stream().filter(buffer -> buffer.getFoldHandler().getClass().getClassLoader() == this.classLoader).forEach(buffer -> buffer.setFoldHandler(new DummyFoldHandler()));
        }
        if (this.plugin != null && !(this.plugin instanceof EditPlugin.Broken)) {
            if (this.plugin instanceof EBPlugin || this.plugin.getClass().getAnnotation(EditBus.EBHandler.class) != null) {
                EditBus.removeFromBus(this.plugin);
            }
            try {
                this.plugin.stop();
            }
            catch (Throwable throwable) {
                Log.log(9, this, "Error while stopping plugin:");
                Log.log(9, this, throwable);
            }
            this.plugin = new EditPlugin.Deferred(this, this.plugin.getClassName());
            EditBus.send(new PluginUpdate(this, PluginUpdate.DEACTIVATED, bl));
            if (!bl && (object = jEdit.getProperty("plugin." + this.plugin.getClassName() + ".activate")) == null) {
                this.breakPlugin();
                jEdit.pluginError(this.path, "plugin-error.not-42", null);
            }
        }
        this.activated = false;
    }

    public URL getDockablesURI() {
        return this.dockablesURI;
    }

    public URL getServicesURI() {
        return this.servicesURI;
    }

    public String toString() {
        if (this.plugin == null) {
            return this.path;
        }
        return this.path + ",class=" + this.plugin.getClassName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static PluginCacheEntry getPluginCache(PluginJAR pluginJAR) {
        PluginCacheEntry pluginCacheEntry;
        String string = pluginJAR.getCachePath();
        if (string == null) {
            return null;
        }
        DataInputStream dataInputStream = null;
        try {
            PluginCacheEntry pluginCacheEntry2 = new PluginCacheEntry();
            pluginCacheEntry2.plugin = pluginJAR;
            pluginCacheEntry2.modTime = pluginJAR.getFile().lastModified();
            dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(string)));
            if (pluginCacheEntry2.read(dataInputStream)) {
                PluginCacheEntry pluginCacheEntry3 = pluginCacheEntry2;
                IOUtilities.closeQuietly(dataInputStream);
                return pluginCacheEntry3;
            }
            pluginCacheEntry = null;
            IOUtilities.closeQuietly(dataInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            PluginCacheEntry pluginCacheEntry4 = null;
            return pluginCacheEntry4;
        }
        catch (IOException iOException) {
            Log.log(9, PluginJAR.class, iOException);
            PluginCacheEntry pluginCacheEntry5 = null;
            return pluginCacheEntry5;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            IOUtilities.closeQuietly(dataInputStream);
        }
        return pluginCacheEntry;
    }

    static void setPluginCache(PluginJAR pluginJAR, PluginCacheEntry pluginCacheEntry) {
        String string = pluginJAR.getCachePath();
        if (string == null) {
            return;
        }
        Log.log(1, PluginJAR.class, "Writing " + string);
        DataOutputStream dataOutputStream = null;
        try {
            dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string)));
            pluginCacheEntry.write(dataOutputStream);
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            Log.log(9, PluginJAR.class, iOException);
            IOUtilities.closeQuietly(dataOutputStream);
            new File(string).delete();
        }
    }

    public static PluginCacheEntry getPluginCacheEntry(String string) throws IOException {
        PluginJAR pluginJAR = new PluginJAR(new File(string));
        PluginCacheEntry pluginCacheEntry = PluginJAR.getPluginCache(pluginJAR);
        if (pluginCacheEntry == null) {
            try {
                pluginCacheEntry = pluginJAR.generateCache();
            }
            finally {
                IOUtilities.closeQuietly(pluginJAR.getZipFile());
            }
        }
        if (pluginCacheEntry == null) {
            Log.log(7, PluginJAR.class, "couldn't load plugin " + pluginJAR.getPath() + " (most likely other version exists)");
        }
        return pluginCacheEntry;
    }

    public PluginJAR(File file) {
        this.path = file.getPath();
        String string = jEdit.getJARCacheDirectory();
        if (string != null) {
            this.cachePath = MiscUtilities.constructPath(string, file.getName() + ".summary");
        }
        this.file = file;
        this.classLoader = new JARClassLoader(this);
        this.actions = new ActionSet();
    }

    public boolean init() {
        PluginCacheEntry pluginCacheEntry = PluginJAR.getPluginCache(this);
        if (pluginCacheEntry != null) {
            if (!this.loadCache(pluginCacheEntry)) {
                return false;
            }
            this.classLoader.activate();
        } else {
            try {
                pluginCacheEntry = this.generateCache();
                if (pluginCacheEntry == null) {
                    return false;
                }
                PluginJAR.setPluginCache(this, pluginCacheEntry);
                this.classLoader.activate();
            }
            catch (IOException iOException) {
                Log.log(9, this, "Cannot load plugin " + this.path);
                Log.log(9, this, iOException);
                Object[] objectArray = new String[]{iOException.toString()};
                jEdit.pluginError(this.path, "plugin-error.load-error", objectArray);
                this.uninit(false);
            }
        }
        return true;
    }

    public void uninit(boolean bl) {
        this.deactivatePlugin(bl);
        if (!bl) {
            Object object;
            for (String object2 : this.weRequireThese) {
                object = jEdit.getPluginJAR(object2);
                if (object == null) continue;
                ((PluginJAR)object).theseRequireMe.remove(this.path);
            }
            for (String string : this.weUseThese) {
                object = jEdit.getPluginJAR(string);
                if (object == null) continue;
                ((PluginJAR)object).theseUseMe.remove(this.path);
            }
            this.classLoader.deactivate();
            BeanShell.resetClassManager();
            if (this.actions != null) {
                jEdit.removeActionSet(this.actions);
            }
            if (this.browserActions != null) {
                VFSBrowser.getActionContext().removeActionSet(this.browserActions);
            }
            DockableWindowFactory.getInstance().unloadDockableWindows(this);
            ServiceManager.unloadServices(this);
            jEdit.removePluginProps(this.properties);
            if (this.localizationProperties != null) {
                Collection<Properties> collection = this.localizationProperties.values();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    object = (Properties)iterator.next();
                    jEdit.removePluginLocalizationProps((Properties)object);
                }
            }
            try {
                if (this.zipFile != null) {
                    this.zipFile.close();
                    this.zipFile = null;
                }
            }
            catch (IOException iOException) {
                Log.log(9, this, iOException);
            }
            this.removePluginCache();
        }
    }

    String[] getClasses() {
        return this.classes;
    }

    public String[] getResources() {
        return this.resources;
    }

    private void actionsPresentButNotCoreClass() {
        Log.log(7, this, this.getPath() + " has an actions.xml but no plugin core class");
        this.actions.setLabel("MISSING PLUGIN CORE CLASS");
    }

    private boolean loadCache(PluginCacheEntry pluginCacheEntry) {
        Object object;
        Object object2;
        if (pluginCacheEntry.pluginClass != null) {
            if (!PluginJAR.continueLoading(pluginCacheEntry.pluginClass, pluginCacheEntry.cachedProperties)) {
                return false;
            }
            object2 = jEdit.getPlugin(pluginCacheEntry.pluginClass);
            if (object2 != null) {
                jEdit.removePluginJAR(((EditPlugin)object2).getPluginJAR(), false);
            }
        }
        this.classes = pluginCacheEntry.classes;
        this.resources = pluginCacheEntry.resources;
        if (pluginCacheEntry.localizationProperties != null) {
            this.localizationProperties = pluginCacheEntry.localizationProperties;
            object2 = jEdit.getCurrentLanguage();
            object = this.localizationProperties.get(object2);
            if (object != null) {
                jEdit.addPluginLocalizationProps((Properties)object);
            }
        }
        if (pluginCacheEntry.cachedProperties != null) {
            this.properties = pluginCacheEntry.cachedProperties;
            jEdit.addPluginProps(pluginCacheEntry.cachedProperties);
        }
        if (pluginCacheEntry.actionsURI != null && pluginCacheEntry.cachedActionNames != null) {
            this.actions = new ActionSet(this, pluginCacheEntry.cachedActionNames, pluginCacheEntry.cachedActionToggleFlags, pluginCacheEntry.actionsURI);
        }
        if (pluginCacheEntry.browserActionsURI != null && pluginCacheEntry.cachedBrowserActionNames != null) {
            this.browserActions = new ActionSet(this, pluginCacheEntry.cachedBrowserActionNames, pluginCacheEntry.cachedBrowserActionToggleFlags, pluginCacheEntry.browserActionsURI);
            object2 = jEdit.getProperty("plugin." + pluginCacheEntry.pluginClass + ".name");
            this.browserActions.setLabel(jEdit.getProperty("action-set.plugin", new String[]{object2}));
            VFSBrowser.getActionContext().addActionSet(this.browserActions);
        }
        if (pluginCacheEntry.dockablesURI != null && pluginCacheEntry.cachedDockableNames != null && pluginCacheEntry.cachedDockableActionFlags != null && pluginCacheEntry.cachedDockableMovableFlags != null) {
            this.dockablesURI = pluginCacheEntry.dockablesURI;
            DockableWindowFactory.getInstance().cacheDockableWindows(this, pluginCacheEntry.cachedDockableNames, pluginCacheEntry.cachedDockableActionFlags, pluginCacheEntry.cachedDockableMovableFlags);
        }
        if (this.actions.size() != 0) {
            jEdit.addActionSet(this.actions);
        }
        if (pluginCacheEntry.servicesURI != null && pluginCacheEntry.cachedServices != null) {
            this.servicesURI = pluginCacheEntry.servicesURI;
            for (int i = 0; i < pluginCacheEntry.cachedServices.length; ++i) {
                object = pluginCacheEntry.cachedServices[i];
                ServiceManager.registerService((ServiceManager.Descriptor)object);
            }
        }
        if (pluginCacheEntry.pluginClass != null) {
            String string = jEdit.getProperty("plugin." + pluginCacheEntry.pluginClass + ".name");
            this.actions.setLabel(jEdit.getProperty("action-set.plugin", new String[]{string}));
            this.plugin = new EditPlugin.Deferred(this, pluginCacheEntry.pluginClass);
        } else if (this.actions.size() != 0) {
            this.actionsPresentButNotCoreClass();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public PluginCacheEntry generateCache() throws IOException {
        boolean bl;
        Object object;
        String string;
        Object object2;
        Object object3;
        Object object4;
        this.properties = new Properties();
        this.localizationProperties = new HashMap<String, Properties>();
        LinkedList<Object> linkedList = new LinkedList<Object>();
        LinkedList linkedList2 = new LinkedList();
        ZipFile zipFile = this.getZipFile();
        LinkedList<Object> linkedList3 = new LinkedList<Object>();
        PluginCacheEntry pluginCacheEntry = new PluginCacheEntry();
        pluginCacheEntry.modTime = this.file.lastModified();
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        Pattern pattern = Pattern.compile("lang_(\\w+).properties");
        while (enumeration.hasMoreElements()) {
            object4 = enumeration.nextElement();
            object3 = ((ZipEntry)object4).getName();
            String string2 = ((String)object3).toLowerCase();
            if ("actions.xml".equals(string2)) {
                pluginCacheEntry.actionsURI = this.classLoader.getResource((String)object3);
                continue;
            }
            if ("browser.actions.xml".equals(string2)) {
                pluginCacheEntry.browserActionsURI = this.classLoader.getResource((String)object3);
                continue;
            }
            if ("dockables.xml".equals(string2)) {
                pluginCacheEntry.dockablesURI = this.dockablesURI = this.classLoader.getResource((String)object3);
                continue;
            }
            if ("services.xml".equals(string2)) {
                pluginCacheEntry.servicesURI = this.servicesURI = this.classLoader.getResource((String)object3);
                continue;
            }
            if (string2.endsWith(".props")) {
                object2 = null;
                try {
                    object2 = this.classLoader.getResourceAsStream((String)object3);
                    this.properties.load((InputStream)object2);
                }
                catch (Throwable throwable) {
                    IOUtilities.closeQuietly(object2);
                    throw throwable;
                }
                IOUtilities.closeQuietly((Closeable)object2);
                continue;
            }
            if (((String)object3).endsWith(".class")) {
                object2 = MiscUtilities.fileToClass((String)object3);
                if (((String)object2).endsWith("Plugin")) {
                    linkedList3.add(object2);
                }
                linkedList.add(object2);
                continue;
            }
            object2 = pattern.matcher(string2);
            if (((Matcher)object2).matches()) {
                string = ((Matcher)object2).group(1);
                object = new Properties();
                InputStream inputStream = null;
                try {
                    inputStream = this.classLoader.getResourceAsStream((String)object3);
                    CharsetEncoding charsetEncoding = new CharsetEncoding(StandardCharsets.UTF_8);
                    Reader reader = charsetEncoding.getTextReader(inputStream);
                    ((Properties)object).load(reader);
                    this.localizationProperties.put(string, (Properties)object);
                }
                catch (Throwable throwable) {
                    IOUtilities.closeQuietly(inputStream);
                    throw throwable;
                }
                IOUtilities.closeQuietly(inputStream);
                continue;
            }
            linkedList2.add(object3);
        }
        pluginCacheEntry.cachedProperties = this.properties;
        pluginCacheEntry.localizationProperties = this.localizationProperties;
        if (pluginCacheEntry.localizationProperties != null) {
            this.localizationProperties = pluginCacheEntry.localizationProperties;
            object4 = jEdit.getCurrentLanguage();
            object3 = this.localizationProperties.get(object4);
            if (object3 != null) {
                jEdit.addPluginLocalizationProps((Properties)object3);
            }
        }
        jEdit.addPluginProps(this.properties);
        pluginCacheEntry.classes = linkedList.toArray(StandardUtilities.EMPTY_STRING_ARRAY);
        this.classes = pluginCacheEntry.classes;
        pluginCacheEntry.resources = linkedList2.toArray(StandardUtilities.EMPTY_STRING_ARRAY);
        this.resources = pluginCacheEntry.resources;
        object4 = null;
        for (String i : linkedList3) {
            object2 = jEdit.getProperty("plugin." + i + ".name");
            string = jEdit.getProperty("plugin." + i + ".version");
            if (object2 == null || string == null) {
                Log.log(7, this, "Ignoring: " + i);
                continue;
            }
            pluginCacheEntry.pluginClass = i;
            if (!PluginJAR.continueLoading(i, pluginCacheEntry.cachedProperties)) {
                return null;
            }
            object = jEdit.getPlugin(i);
            if (object != null) {
                jEdit.removePluginJAR(((EditPlugin)object).getPluginJAR(), false);
            }
            this.plugin = new EditPlugin.Deferred(this, i);
            object4 = object2;
            break;
        }
        boolean bl2 = bl = jEdit.getPluginJAR(this.getPath()) != null;
        if (!bl) {
            Log.log(1, PluginJAR.class, "not loading actions, dockables, services because the plugin is not really being loaded");
            return pluginCacheEntry;
        }
        if (pluginCacheEntry.actionsURI != null) {
            void var10_15;
            this.actions = new ActionSet(this, null, null, pluginCacheEntry.actionsURI);
            this.actions.load();
            pluginCacheEntry.cachedActionNames = this.actions.getCacheableActionNames();
            pluginCacheEntry.cachedActionToggleFlags = new boolean[pluginCacheEntry.cachedActionNames.length];
            boolean bl3 = false;
            while (var10_15 < pluginCacheEntry.cachedActionNames.length) {
                pluginCacheEntry.cachedActionToggleFlags[var10_15] = jEdit.getBooleanProperty(pluginCacheEntry.cachedActionNames[var10_15] + ".toggle");
                ++var10_15;
            }
        }
        if (pluginCacheEntry.browserActionsURI != null) {
            void var10_17;
            this.browserActions = new ActionSet(this, null, null, pluginCacheEntry.browserActionsURI);
            this.browserActions.load();
            VFSBrowser.getActionContext().addActionSet(this.browserActions);
            pluginCacheEntry.cachedBrowserActionNames = this.browserActions.getCacheableActionNames();
            pluginCacheEntry.cachedBrowserActionToggleFlags = new boolean[pluginCacheEntry.cachedBrowserActionNames.length];
            boolean bl4 = false;
            while (var10_17 < pluginCacheEntry.cachedBrowserActionNames.length) {
                pluginCacheEntry.cachedBrowserActionToggleFlags[var10_17] = jEdit.getBooleanProperty(pluginCacheEntry.cachedBrowserActionNames[var10_17] + ".toggle");
                ++var10_17;
            }
        }
        if (this.dockablesURI != null) {
            DockableWindowFactory.getInstance().loadDockableWindows(this, this.dockablesURI, pluginCacheEntry);
        }
        if (this.actions.size() != 0) {
            if (object4 != null) {
                this.actions.setLabel(jEdit.getProperty("action-set.plugin", new String[]{object4}));
            } else {
                this.actionsPresentButNotCoreClass();
            }
            jEdit.addActionSet(this.actions);
        }
        if (this.servicesURI != null) {
            ServiceManager.loadServices(this, this.servicesURI, pluginCacheEntry);
        }
        return pluginCacheEntry;
    }

    private static boolean continueLoading(String string, Properties properties) {
        String string2;
        String string3;
        return jEdit.getPlugin(string) == null || (string3 = jEdit.getProperty("plugin." + string + ".version")).compareTo(string2 = properties.getProperty("plugin." + string + ".version")) <= 0;
    }

    private void startPlugin() {
        try {
            this.plugin.start();
        }
        catch (Throwable throwable) {
            this.breakPlugin();
            Log.log(9, this, "Error while starting plugin " + this.plugin.getClassName());
            Log.log(9, this, throwable);
            Object[] objectArray = new String[]{throwable.toString()};
            jEdit.pluginError(this.path, "plugin-error.start-error", objectArray);
        }
        if (this.plugin instanceof EBPlugin || this.plugin.getClass().getAnnotation(EditBus.EBHandler.class) != null) {
            if (jEdit.getProperty("plugin." + this.plugin.getClassName() + ".activate") == null) {
                ((EBComponent)((Object)this.plugin)).handleMessage(new PropertiesChanged(null));
            }
            EditBus.addToBus(this.plugin);
        }
        BufferManager bufferManager = jEdit.getBufferManager();
        bufferManager.getBuffers().forEach(buffer -> {
            FoldHandler foldHandler = FoldHandler.getFoldHandler(buffer.getStringProperty("folding"));
            if (foldHandler != null && foldHandler != buffer.getFoldHandler()) {
                buffer.setFoldHandler(foldHandler);
            }
        });
    }

    private void startPluginLater() {
        EventQueue.invokeLater(() -> {
            if (!this.activated) {
                return;
            }
            this.startPlugin();
        });
    }

    private void breakPlugin() {
        this.plugin = new EditPlugin.Broken(this, this.plugin.getClassName());
        this.uninit(false);
        jEdit.addPluginProps(this.properties);
    }

    private void removePluginCache() {
        if (this.cachePath != null) {
            new File(this.cachePath).delete();
        }
    }

    public static class PluginCacheEntry {
        public static final int MAGIC = -1214061532;
        public PluginJAR plugin;
        public long modTime;
        public String[] classes;
        public String[] resources;
        public URL actionsURI;
        public String[] cachedActionNames;
        public boolean[] cachedActionToggleFlags;
        public URL browserActionsURI;
        public String[] cachedBrowserActionNames;
        public boolean[] cachedBrowserActionToggleFlags;
        public URL dockablesURI;
        public String[] cachedDockableNames;
        public boolean[] cachedDockableActionFlags;
        public boolean[] cachedDockableMovableFlags;
        public URL servicesURI;
        ServiceManager.Descriptor[] cachedServices;
        public Properties cachedProperties;
        public Map<String, Properties> localizationProperties;
        public String pluginClass;

        public boolean read(DataInputStream dataInputStream) throws IOException {
            int n = dataInputStream.readInt();
            if (n != -1214061532) {
                return false;
            }
            String string = PluginCacheEntry.readString(dataInputStream);
            if (!string.equals(jEdit.getBuild())) {
                return false;
            }
            long l = dataInputStream.readLong();
            if (l != this.modTime) {
                return false;
            }
            this.actionsURI = PluginCacheEntry.readURI(dataInputStream);
            this.cachedActionNames = PluginCacheEntry.readStringArray(dataInputStream);
            this.cachedActionToggleFlags = PluginCacheEntry.readBooleanArray(dataInputStream);
            this.browserActionsURI = PluginCacheEntry.readURI(dataInputStream);
            this.cachedBrowserActionNames = PluginCacheEntry.readStringArray(dataInputStream);
            this.cachedBrowserActionToggleFlags = PluginCacheEntry.readBooleanArray(dataInputStream);
            this.dockablesURI = PluginCacheEntry.readURI(dataInputStream);
            this.cachedDockableNames = PluginCacheEntry.readStringArray(dataInputStream);
            this.cachedDockableActionFlags = PluginCacheEntry.readBooleanArray(dataInputStream);
            this.cachedDockableMovableFlags = PluginCacheEntry.readBooleanArray(dataInputStream);
            this.servicesURI = PluginCacheEntry.readURI(dataInputStream);
            int n2 = dataInputStream.readInt();
            if (n2 == 0) {
                this.cachedServices = null;
            } else {
                this.cachedServices = new ServiceManager.Descriptor[n2];
                for (int i = 0; i < n2; ++i) {
                    ServiceManager.Descriptor descriptor;
                    this.cachedServices[i] = descriptor = new ServiceManager.Descriptor(PluginCacheEntry.readString(dataInputStream), PluginCacheEntry.readString(dataInputStream), null, this.plugin);
                }
            }
            this.classes = PluginCacheEntry.readStringArray(dataInputStream);
            this.resources = PluginCacheEntry.readStringArray(dataInputStream);
            this.cachedProperties = PluginCacheEntry.readMap(dataInputStream);
            this.localizationProperties = PluginCacheEntry.readLanguagesMap(dataInputStream);
            this.pluginClass = PluginCacheEntry.readString(dataInputStream);
            return true;
        }

        public void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeInt(-1214061532);
            PluginCacheEntry.writeString(dataOutputStream, jEdit.getBuild());
            dataOutputStream.writeLong(this.modTime);
            PluginCacheEntry.writeString(dataOutputStream, this.actionsURI);
            PluginCacheEntry.writeStringArray(dataOutputStream, this.cachedActionNames);
            PluginCacheEntry.writeBooleanArray(dataOutputStream, this.cachedActionToggleFlags);
            PluginCacheEntry.writeString(dataOutputStream, this.browserActionsURI);
            PluginCacheEntry.writeStringArray(dataOutputStream, this.cachedBrowserActionNames);
            PluginCacheEntry.writeBooleanArray(dataOutputStream, this.cachedBrowserActionToggleFlags);
            PluginCacheEntry.writeString(dataOutputStream, this.dockablesURI);
            PluginCacheEntry.writeStringArray(dataOutputStream, this.cachedDockableNames);
            PluginCacheEntry.writeBooleanArray(dataOutputStream, this.cachedDockableActionFlags);
            PluginCacheEntry.writeBooleanArray(dataOutputStream, this.cachedDockableMovableFlags);
            PluginCacheEntry.writeString(dataOutputStream, this.servicesURI);
            if (this.cachedServices == null) {
                dataOutputStream.writeInt(0);
            } else {
                dataOutputStream.writeInt(this.cachedServices.length);
                for (ServiceManager.Descriptor descriptor : this.cachedServices) {
                    PluginCacheEntry.writeString(dataOutputStream, descriptor.clazz);
                    PluginCacheEntry.writeString(dataOutputStream, descriptor.name);
                }
            }
            PluginCacheEntry.writeStringArray(dataOutputStream, this.classes);
            PluginCacheEntry.writeStringArray(dataOutputStream, this.resources);
            PluginCacheEntry.writeMap(dataOutputStream, this.cachedProperties);
            PluginCacheEntry.writeLanguages(dataOutputStream, this.localizationProperties);
            PluginCacheEntry.writeString(dataOutputStream, this.pluginClass);
        }

        private static String readString(DataInputStream dataInputStream) throws IOException {
            int n = dataInputStream.readInt();
            if (n == 0) {
                return null;
            }
            char[] cArray = new char[n];
            for (int i = 0; i < n; ++i) {
                cArray[i] = dataInputStream.readChar();
            }
            return new String(cArray);
        }

        private static URL readURI(DataInputStream dataInputStream) throws IOException {
            String string = PluginCacheEntry.readString(dataInputStream);
            if (string == null) {
                return null;
            }
            return new URL(string);
        }

        private static String[] readStringArray(DataInputStream dataInputStream) throws IOException {
            int n = dataInputStream.readInt();
            if (n == 0) {
                return null;
            }
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = PluginCacheEntry.readString(dataInputStream);
            }
            return stringArray;
        }

        private static boolean[] readBooleanArray(DataInputStream dataInputStream) throws IOException {
            int n = dataInputStream.readInt();
            if (n == 0) {
                return null;
            }
            boolean[] blArray = new boolean[n];
            for (int i = 0; i < n; ++i) {
                blArray[i] = dataInputStream.readBoolean();
            }
            return blArray;
        }

        private static Properties readMap(DataInputStream dataInputStream) throws IOException {
            Properties properties = new Properties();
            int n = dataInputStream.readInt();
            for (int i = 0; i < n; ++i) {
                String string = PluginCacheEntry.readString(dataInputStream);
                String string2 = PluginCacheEntry.readString(dataInputStream);
                if (string2 == null) {
                    string2 = "";
                }
                properties.setProperty(string, string2);
            }
            return properties;
        }

        private static Map<String, Properties> readLanguagesMap(DataInputStream dataInputStream) throws IOException {
            int n = dataInputStream.readInt();
            if (n == 0) {
                return Collections.emptyMap();
            }
            HashMap<String, Properties> hashMap = new HashMap<String, Properties>(n);
            for (int i = 0; i < n; ++i) {
                String string = PluginCacheEntry.readString(dataInputStream);
                Properties properties = PluginCacheEntry.readMap(dataInputStream);
                hashMap.put(string, properties);
            }
            return hashMap;
        }

        private static void writeString(DataOutputStream dataOutputStream, Object object) throws IOException {
            if (object == null) {
                dataOutputStream.writeInt(0);
            } else {
                String string = object.toString();
                dataOutputStream.writeInt(string.length());
                dataOutputStream.writeChars(string);
            }
        }

        private static void writeStringArray(DataOutputStream dataOutputStream, String[] stringArray) throws IOException {
            if (stringArray == null) {
                dataOutputStream.writeInt(0);
            } else {
                dataOutputStream.writeInt(stringArray.length);
                for (String string : stringArray) {
                    PluginCacheEntry.writeString(dataOutputStream, string);
                }
            }
        }

        private static void writeBooleanArray(DataOutputStream dataOutputStream, boolean[] blArray) throws IOException {
            if (blArray == null) {
                dataOutputStream.writeInt(0);
            } else {
                dataOutputStream.writeInt(blArray.length);
                for (boolean bl : blArray) {
                    dataOutputStream.writeBoolean(bl);
                }
            }
        }

        private static void writeMap(DataOutputStream dataOutputStream, Properties properties) throws IOException {
            dataOutputStream.writeInt(properties.size());
            Set<Map.Entry<Object, Object>> set = properties.entrySet();
            for (Map.Entry<Object, Object> entry : set) {
                PluginCacheEntry.writeString(dataOutputStream, entry.getKey());
                PluginCacheEntry.writeString(dataOutputStream, entry.getValue());
            }
        }

        private static void writeLanguages(DataOutputStream dataOutputStream, Map<String, Properties> map) throws IOException {
            dataOutputStream.writeInt(map.size());
            for (Map.Entry<String, Properties> entry : map.entrySet()) {
                PluginCacheEntry.writeString(dataOutputStream, entry.getKey());
                PluginCacheEntry.writeMap(dataOutputStream, entry.getValue());
            }
        }
    }

    private static class PluginDepends {
        String dep;
        String what;
        String arg;
        String name;
        boolean optional;

        private PluginDepends() {
        }
    }
}

