/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.pluginmgr;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nonnull;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.ProgressObserver;
import org.jedit.io.HttpException;

public class RemotePluginList {
    public static final int GZIP_MAGIC_1 = 31;
    public static final int GZIP_MAGIC_2 = 139;
    private final ProgressObserver progressObserver;
    private final String id;

    public RemotePluginList(ProgressObserver progressObserver, String string) {
        this.progressObserver = progressObserver;
        this.id = string;
    }

    @Nonnull
    String getPluginList() throws IOException, MalformedURLException, HttpException {
        this.progressObserver.setStatus(jEdit.getProperty("plugin-manager.list-download"));
        String string = jEdit.getProperty("plugin-manager.export-url") + "?mirror=" + RemotePluginList.buildMirror(this.id) + "&new_url_scheme";
        URL uRL = new URL(string);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        int n = httpURLConnection.getResponseCode();
        if (n == 200) {
            long l = System.currentTimeMillis();
            try (InputStream inputStream = RemotePluginList.openPluginListStream(httpURLConnection.getInputStream());){
                String string2 = IOUtilities.toString(inputStream);
                jEdit.setProperty("plugin-manager.mirror.cached-id", this.id);
                Log.log(3, this, "Updated cached pluginlist " + (System.currentTimeMillis() - l));
                String string3 = string2;
                return string3;
            }
        }
        throw new HttpException(n, httpURLConnection.getResponseMessage());
    }

    static InputStream openPluginListStream(InputStream inputStream) throws IOException {
        FilterInputStream filterInputStream = new BufferedInputStream(inputStream);
        if (((InputStream)filterInputStream).markSupported()) {
            ((InputStream)filterInputStream).mark(2);
            int n = ((InputStream)filterInputStream).read();
            int n2 = ((InputStream)filterInputStream).read();
            ((InputStream)filterInputStream).reset();
            if (n == 31 && n2 == 139) {
                filterInputStream = new GZIPInputStream(filterInputStream);
            }
        }
        return filterInputStream;
    }

    @Nonnull
    private static String buildMirror(String string) {
        return string != null && !"NONE".equals(string) ? string : "default";
    }
}

