/*
 * Decompiled with CFR 0.152.
 */
package mediathek.javafx.filterpanel;

import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mediathek.javafx.filterpanel.FXSearchControl$WhenMappings;
import mediathek.javafx.filterpanel.FXSearchControlFieldMode;
import mediathek.tool.Filter;
import org.controlsfx.control.textfield.CustomTextField;
import org.controlsfx.glyphfont.FontAwesome;
import org.controlsfx.glyphfont.GlyphFont;
import org.controlsfx.glyphfont.GlyphFontRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lmediathek/javafx/filterpanel/FXSearchControl;", "Lorg/controlsfx/control/textfield/CustomTextField;", "()V", "irgendwoTooltip", "Ljavafx/scene/control/Tooltip;", "themaTitelTooltip", "checkPatternValidity", "", "text", "", "setMode", "mode", "Lmediathek/javafx/filterpanel/FXSearchControlFieldMode;", "Companion", "MediathekView"})
public final class FXSearchControl
extends CustomTextField {
    private final Tooltip themaTitelTooltip = new Tooltip("Thema/Titel durchsuchen");
    private final Tooltip irgendwoTooltip = new Tooltip("Thema/Titel/Beschreibung durchsuchen");
    private static final String PROMPT_THEMA_TITEL = "Thema/Titel";
    private static final String PROMPT_IRGENDWO = "Thema/Titel/Beschreibung";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final void setMode(@NotNull FXSearchControlFieldMode mode) {
        Intrinsics.checkNotNullParameter((Object)mode, "mode");
        switch (FXSearchControl$WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
            case 1: {
                this.setTooltip(this.themaTitelTooltip);
                this.setPromptText(PROMPT_THEMA_TITEL);
                break;
            }
            case 2: {
                this.setTooltip(this.irgendwoTooltip);
                this.setPromptText(PROMPT_IRGENDWO);
                break;
            }
        }
    }

    private final void checkPatternValidity(String text) {
        this.setStyle(Filter.isPattern(text) ? (Filter.makePatternNoCache(text) == null ? "-fx-text-fill: red" : "-fx-text-fill: blue") : null);
    }

    public FXSearchControl() {
        Node rightNode;
        GlyphFont fontAwesome = GlyphFontRegistry.font("FontAwesome");
        this.setLeft(fontAwesome.create(FontAwesome.Glyph.SEARCH));
        this.setRight(fontAwesome.create(FontAwesome.Glyph.REMOVE));
        this.setOnKeyPressed((EventHandler<? super KeyEvent>)new EventHandler<KeyEvent>(){

            @Override
            public final void handle(@NotNull KeyEvent event) {
                Intrinsics.checkNotNullParameter(event, "event");
                if (event.getCode() == KeyCode.ESCAPE) {
                    String string = this.getText();
                    Intrinsics.checkNotNullExpressionValue(string, "text");
                    CharSequence charSequence = string;
                    boolean bl = false;
                    if (charSequence.length() > 0) {
                        this.setText("");
                    }
                    event.consume();
                }
            }
        });
        Node node = rightNode = this.getRight();
        Intrinsics.checkNotNullExpressionValue(node, "rightNode");
        node.setOnMouseClicked((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

            @Override
            public final void handle(MouseEvent it) {
                this.setText("");
            }
        });
        rightNode.setCursor(Cursor.DEFAULT);
        rightNode.setVisible(false);
        StringProperty textProperty = this.textProperty();
        textProperty.addListener((ChangeListener)new ChangeListener<String>(){

            @Override
            public final void changed(@Nullable ObservableValue<? extends String> $noName_0, @Nullable String $noName_1, @NotNull String newValue) {
                Intrinsics.checkNotNullParameter(newValue, "newValue");
                Node node = rightNode;
                Intrinsics.checkNotNullExpressionValue(node, "rightNode");
                CharSequence charSequence = newValue;
                boolean bl = false;
                node.setVisible(charSequence.length() > 0);
            }
        });
        this.setPrefWidth(350.0);
        this.setMinWidth(350.0);
        this.setMaxWidth(350.0);
        textProperty.addListener((ChangeListener)new ChangeListener<String>(){

            @Override
            public final void changed(ObservableValue<? extends String> $noName_0, String $noName_1, String newValue) {
                String string = newValue;
                Intrinsics.checkNotNullExpressionValue(string, "newValue");
                this.checkPatternValidity(string);
            }
        });
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lmediathek/javafx/filterpanel/FXSearchControl$Companion;", "", "()V", "PROMPT_IRGENDWO", "", "PROMPT_THEMA_TITEL", "MediathekView"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

