package PDF::Builder::Resource::Font::CoreFont::helvetica;

use strict;
use warnings;

our $VERSION = '3.019'; # VERSION
my $LAST_UPDATE = '3.019'; # manually update whenever code is changed

=head1 NAME

PDF::Builder::Resource::Font::CoreFont::helvetica - font-specific information for regular Helvetica font. Metrics and glyph list from Arial typeface.

=cut

sub data { return {
    'fontname' => 'Helvetica',
    'type' => 'Type1',
    'apiname' => 'Helv',
    'ascender' => '718',
    'capheight' => '718',
    'descender' => '-207',
    'iscore' => '1',
    'isfixedpitch' => '0',
    'italicangle' => '0',
    'missingwidth' => '278',
    'stdhw' => '76',
    'stdvw' => '88',
    'underlineposition' => '-100',
    'underlinethickness' => '50',
    'xheight' => '523',
    'firstchar' => '32',
    'lastchar' => '255',
    'char' => [ # DEF. ENCODING GLYPH TABLE
        '.notdef',                               # C+0x00 # U+0x0000
        '.notdef',                               # C+0x01 # U+0x0000
        '.notdef',                               # C+0x02 # U+0x0000
        '.notdef',                               # C+0x03 # U+0x0000
        '.notdef',                               # C+0x04 # U+0x0000
        '.notdef',                               # C+0x05 # U+0x0000
        '.notdef',                               # C+0x06 # U+0x0000
        '.notdef',                               # C+0x07 # U+0x0000
        '.notdef',                               # C+0x08 # U+0x0000
        '.notdef',                               # C+0x09 # U+0x0000
        '.notdef',                               # C+0x0A # U+0x0000
        '.notdef',                               # C+0x0B # U+0x0000
        '.notdef',                               # C+0x0C # U+0x0000
        '.notdef',                               # C+0x0D # U+0x0000
        '.notdef',                               # C+0x0E # U+0x0000
        '.notdef',                               # C+0x0F # U+0x0000
        '.notdef',                               # C+0x10 # U+0x0000
        '.notdef',                               # C+0x11 # U+0x0000
        '.notdef',                               # C+0x12 # U+0x0000
        '.notdef',                               # C+0x13 # U+0x0000
        '.notdef',                               # C+0x14 # U+0x0000
        '.notdef',                               # C+0x15 # U+0x0000
        '.notdef',                               # C+0x16 # U+0x0000
        '.notdef',                               # C+0x17 # U+0x0000
        '.notdef',                               # C+0x18 # U+0x0000
        '.notdef',                               # C+0x19 # U+0x0000
        '.notdef',                               # C+0x1A # U+0x0000
        '.notdef',                               # C+0x1B # U+0x0000
        '.notdef',                               # C+0x1C # U+0x0000
        '.notdef',                               # C+0x1D # U+0x0000
        '.notdef',                               # C+0x1E # U+0x0000
        '.notdef',                               # C+0x1F # U+0x0000
        'space',                                 # C+0x20 # U+0x0020
        'exclam',                                # C+0x21 # U+0x0021
        'quotedbl',                              # C+0x22 # U+0x0022
        'numbersign',                            # C+0x23 # U+0x0023
        'dollar',                                # C+0x24 # U+0x0024
        'percent',                               # C+0x25 # U+0x0025
        'ampersand',                             # C+0x26 # U+0x0026
        'quotesingle',                           # C+0x27 # U+0x0027
        'parenleft',                             # C+0x28 # U+0x0028
        'parenright',                            # C+0x29 # U+0x0029
        'asterisk',                              # C+0x2A # U+0x002A
        'plus',                                  # C+0x2B # U+0x002B
        'comma',                                 # C+0x2C # U+0x002C
        'hyphen',                                # C+0x2D # U+0x002D
        'period',                                # C+0x2E # U+0x002E
        'slash',                                 # C+0x2F # U+0x002F
        'zero',                                  # C+0x30 # U+0x0030
        'one',                                   # C+0x31 # U+0x0031
        'two',                                   # C+0x32 # U+0x0032
        'three',                                 # C+0x33 # U+0x0033
        'four',                                  # C+0x34 # U+0x0034
        'five',                                  # C+0x35 # U+0x0035
        'six',                                   # C+0x36 # U+0x0036
        'seven',                                 # C+0x37 # U+0x0037
        'eight',                                 # C+0x38 # U+0x0038
        'nine',                                  # C+0x39 # U+0x0039
        'colon',                                 # C+0x3A # U+0x003A
        'semicolon',                             # C+0x3B # U+0x003B
        'less',                                  # C+0x3C # U+0x003C
        'equal',                                 # C+0x3D # U+0x003D
        'greater',                               # C+0x3E # U+0x003E
        'question',                              # C+0x3F # U+0x003F
        'at',                                    # C+0x40 # U+0x0040
        'A',                                     # C+0x41 # U+0x0041
        'B',                                     # C+0x42 # U+0x0042
        'C',                                     # C+0x43 # U+0x0043
        'D',                                     # C+0x44 # U+0x0044
        'E',                                     # C+0x45 # U+0x0045
        'F',                                     # C+0x46 # U+0x0046
        'G',                                     # C+0x47 # U+0x0047
        'H',                                     # C+0x48 # U+0x0048
        'I',                                     # C+0x49 # U+0x0049
        'J',                                     # C+0x4A # U+0x004A
        'K',                                     # C+0x4B # U+0x004B
        'L',                                     # C+0x4C # U+0x004C
        'M',                                     # C+0x4D # U+0x004D
        'N',                                     # C+0x4E # U+0x004E
        'O',                                     # C+0x4F # U+0x004F
        'P',                                     # C+0x50 # U+0x0050
        'Q',                                     # C+0x51 # U+0x0051
        'R',                                     # C+0x52 # U+0x0052
        'S',                                     # C+0x53 # U+0x0053
        'T',                                     # C+0x54 # U+0x0054
        'U',                                     # C+0x55 # U+0x0055
        'V',                                     # C+0x56 # U+0x0056
        'W',                                     # C+0x57 # U+0x0057
        'X',                                     # C+0x58 # U+0x0058
        'Y',                                     # C+0x59 # U+0x0059
        'Z',                                     # C+0x5A # U+0x005A
        'bracketleft',                           # C+0x5B # U+0x005B
        'backslash',                             # C+0x5C # U+0x005C
        'bracketright',                          # C+0x5D # U+0x005D
        'asciicircum',                           # C+0x5E # U+0x005E
        'underscore',                            # C+0x5F # U+0x005F
        'grave',                                 # C+0x60 # U+0x0060
        'a',                                     # C+0x61 # U+0x0061
        'b',                                     # C+0x62 # U+0x0062
        'c',                                     # C+0x63 # U+0x0063
        'd',                                     # C+0x64 # U+0x0064
        'e',                                     # C+0x65 # U+0x0065
        'f',                                     # C+0x66 # U+0x0066
        'g',                                     # C+0x67 # U+0x0067
        'h',                                     # C+0x68 # U+0x0068
        'i',                                     # C+0x69 # U+0x0069
        'j',                                     # C+0x6A # U+0x006A
        'k',                                     # C+0x6B # U+0x006B
        'l',                                     # C+0x6C # U+0x006C
        'm',                                     # C+0x6D # U+0x006D
        'n',                                     # C+0x6E # U+0x006E
        'o',                                     # C+0x6F # U+0x006F
        'p',                                     # C+0x70 # U+0x0070
        'q',                                     # C+0x71 # U+0x0071
        'r',                                     # C+0x72 # U+0x0072
        's',                                     # C+0x73 # U+0x0073
        't',                                     # C+0x74 # U+0x0074
        'u',                                     # C+0x75 # U+0x0075
        'v',                                     # C+0x76 # U+0x0076
        'w',                                     # C+0x77 # U+0x0077
        'x',                                     # C+0x78 # U+0x0078
        'y',                                     # C+0x79 # U+0x0079
        'z',                                     # C+0x7A # U+0x007A
        'braceleft',                             # C+0x7B # U+0x007B
        'bar',                                   # C+0x7C # U+0x007C
        'braceright',                            # C+0x7D # U+0x007D
        'asciitilde',                            # C+0x7E # U+0x007E
        'bullet',                                # C+0x7F # U+0x2022
        'Euro',                                  # C+0x80 # U+0x20AC
        'bullet',                                # C+0x81 # U+0x2022
        'quotesinglbase',                        # C+0x82 # U+0x201A
        'florin',                                # C+0x83 # U+0x0192
        'quotedblbase',                          # C+0x84 # U+0x201E
        'ellipsis',                              # C+0x85 # U+0x2026
        'dagger',                                # C+0x86 # U+0x2020
        'daggerdbl',                             # C+0x87 # U+0x2021
        'circumflex',                            # C+0x88 # U+0x02C6
        'perthousand',                           # C+0x89 # U+0x2030
        'Scaron',                                # C+0x8A # U+0x0160
        'guilsinglleft',                         # C+0x8B # U+0x2039
        'OE',                                    # C+0x8C # U+0x0152
        'bullet',                                # C+0x8D # U+0x2022
        'Zcaron',                                # C+0x8E # U+0x017D
        'bullet',                                # C+0x8F # U+0x2022
        'bullet',                                # C+0x90 # U+0x2022
        'quoteleft',                             # C+0x91 # U+0x2018
        'quoteright',                            # C+0x92 # U+0x2019
        'quotedblleft',                          # C+0x93 # U+0x201C
        'quotedblright',                         # C+0x94 # U+0x201D
        'bullet',                                # C+0x95 # U+0x2022
        'endash',                                # C+0x96 # U+0x2013
        'emdash',                                # C+0x97 # U+0x2014
        'tilde',                                 # C+0x98 # U+0x02DC
        'trademark',                             # C+0x99 # U+0x2122
        'scaron',                                # C+0x9A # U+0x0161
        'guilsinglright',                        # C+0x9B # U+0x203A
        'oe',                                    # C+0x9C # U+0x0153
        'bullet',                                # C+0x9D # U+0x2022
        'zcaron',                                # C+0x9E # U+0x017E
        'Ydieresis',                             # C+0x9F # U+0x0178
        'space',                                 # C+0xA0 # U+0x0020
        'exclamdown',                            # C+0xA1 # U+0x00A1
        'cent',                                  # C+0xA2 # U+0x00A2
        'sterling',                              # C+0xA3 # U+0x00A3
        'currency',                              # C+0xA4 # U+0x00A4
        'yen',                                   # C+0xA5 # U+0x00A5
        'brokenbar',                             # C+0xA6 # U+0x00A6
        'section',                               # C+0xA7 # U+0x00A7
        'dieresis',                              # C+0xA8 # U+0x00A8
        'copyright',                             # C+0xA9 # U+0x00A9
        'ordfeminine',                           # C+0xAA # U+0x00AA
        'guillemotleft',                         # C+0xAB # U+0x00AB
        'logicalnot',                            # C+0xAC # U+0x00AC
        'hyphen',                                # C+0xAD # U+0x002D
        'registered',                            # C+0xAE # U+0x00AE
        'macron',                                # C+0xAF # U+0x00AF
        'degree',                                # C+0xB0 # U+0x00B0
        'plusminus',                             # C+0xB1 # U+0x00B1
        'twosuperior',                           # C+0xB2 # U+0x00B2
        'threesuperior',                         # C+0xB3 # U+0x00B3
        'acute',                                 # C+0xB4 # U+0x00B4
        'mu',                                    # C+0xB5 # U+0x00B5
        'paragraph',                             # C+0xB6 # U+0x00B6
        'periodcentered',                        # C+0xB7 # U+0x00B7
        'cedilla',                               # C+0xB8 # U+0x00B8
        'onesuperior',                           # C+0xB9 # U+0x00B9
        'ordmasculine',                          # C+0xBA # U+0x00BA
        'guillemotright',                        # C+0xBB # U+0x00BB
        'onequarter',                            # C+0xBC # U+0x00BC
        'onehalf',                               # C+0xBD # U+0x00BD
        'threequarters',                         # C+0xBE # U+0x00BE
        'questiondown',                          # C+0xBF # U+0x00BF
        'Agrave',                                # C+0xC0 # U+0x00C0
        'Aacute',                                # C+0xC1 # U+0x00C1
        'Acircumflex',                           # C+0xC2 # U+0x00C2
        'Atilde',                                # C+0xC3 # U+0x00C3
        'Adieresis',                             # C+0xC4 # U+0x00C4
        'Aring',                                 # C+0xC5 # U+0x00C5
        'AE',                                    # C+0xC6 # U+0x00C6
        'Ccedilla',                              # C+0xC7 # U+0x00C7
        'Egrave',                                # C+0xC8 # U+0x00C8
        'Eacute',                                # C+0xC9 # U+0x00C9
        'Ecircumflex',                           # C+0xCA # U+0x00CA
        'Edieresis',                             # C+0xCB # U+0x00CB
        'Igrave',                                # C+0xCC # U+0x00CC
        'Iacute',                                # C+0xCD # U+0x00CD
        'Icircumflex',                           # C+0xCE # U+0x00CE
        'Idieresis',                             # C+0xCF # U+0x00CF
        'Eth',                                   # C+0xD0 # U+0x00D0
        'Ntilde',                                # C+0xD1 # U+0x00D1
        'Ograve',                                # C+0xD2 # U+0x00D2
        'Oacute',                                # C+0xD3 # U+0x00D3
        'Ocircumflex',                           # C+0xD4 # U+0x00D4
        'Otilde',                                # C+0xD5 # U+0x00D5
        'Odieresis',                             # C+0xD6 # U+0x00D6
        'multiply',                              # C+0xD7 # U+0x00D7
        'Oslash',                                # C+0xD8 # U+0x00D8
        'Ugrave',                                # C+0xD9 # U+0x00D9
        'Uacute',                                # C+0xDA # U+0x00DA
        'Ucircumflex',                           # C+0xDB # U+0x00DB
        'Udieresis',                             # C+0xDC # U+0x00DC
        'Yacute',                                # C+0xDD # U+0x00DD
        'Thorn',                                 # C+0xDE # U+0x00DE
        'germandbls',                            # C+0xDF # U+0x00DF
        'agrave',                                # C+0xE0 # U+0x00E0
        'aacute',                                # C+0xE1 # U+0x00E1
        'acircumflex',                           # C+0xE2 # U+0x00E2
        'atilde',                                # C+0xE3 # U+0x00E3
        'adieresis',                             # C+0xE4 # U+0x00E4
        'aring',                                 # C+0xE5 # U+0x00E5
        'ae',                                    # C+0xE6 # U+0x00E6
        'ccedilla',                              # C+0xE7 # U+0x00E7
        'egrave',                                # C+0xE8 # U+0x00E8
        'eacute',                                # C+0xE9 # U+0x00E9
        'ecircumflex',                           # C+0xEA # U+0x00EA
        'edieresis',                             # C+0xEB # U+0x00EB
        'igrave',                                # C+0xEC # U+0x00EC
        'iacute',                                # C+0xED # U+0x00ED
        'icircumflex',                           # C+0xEE # U+0x00EE
        'idieresis',                             # C+0xEF # U+0x00EF
        'eth',                                   # C+0xF0 # U+0x00F0
        'ntilde',                                # C+0xF1 # U+0x00F1
        'ograve',                                # C+0xF2 # U+0x00F2
        'oacute',                                # C+0xF3 # U+0x00F3
        'ocircumflex',                           # C+0xF4 # U+0x00F4
        'otilde',                                # C+0xF5 # U+0x00F5
        'odieresis',                             # C+0xF6 # U+0x00F6
        'divide',                                # C+0xF7 # U+0x00F7
        'oslash',                                # C+0xF8 # U+0x00F8
        'ugrave',                                # C+0xF9 # U+0x00F9
        'uacute',                                # C+0xFA # U+0x00FA
        'ucircumflex',                           # C+0xFB # U+0x00FB
        'udieresis',                             # C+0xFC # U+0x00FC
        'yacute',                                # C+0xFD # U+0x00FD
        'thorn',                                 # C+0xFE # U+0x00FE
        'ydieresis',                             # C+0xFF # U+0x00FF
    ], # DEF. ENCODING GLYPH TABLE
    'fontbbox' => [ -166, -225, 1000, 931 ],
# source: \Windows\Fonts\arial.ttf
# font underline position = -217
# CIDs 0 .. 4502 to be output
# fontbbox = (-664 -324 2000 1039)
    'wx' => { # HORIZ. WIDTH TABLE
	# +1  official .afm spec one larger than what TTF reports
	# (+1)  not in .afm spec, but increased (by 1) per base letter
	# -1  official .afm spec one smaller than what TTF reports
	# others as noted (.afm spec or original .pm plus some %)
        'A'       => 667,                                         # +1
        'AE'       => 1000,
        'AEacute'       => 1000,
        'AEmacron'       => 1000,
        'Aacute'       => 667,                                    # +1
        'Abreve'       => 667,                                    # +1
        'Abreveacute'       => 667,                               # (+1)
        'Abrevecyrillic'       => 666,
        'Abrevedotbelow'       => 667,                            # (+1)
        'Abrevegrave'       => 667,                               # (+1)
        'Abrevehookabove'       => 667,                           # (+1)
        'Abrevetilde'       => 667,                               # (+1)
        'Acaron'       => 667,                                    # (+1)
        'Acircumflex'       => 667,                               # +1
        'Acircumflexacute'       => 667,                          # (+1)
        'Acircumflexdotbelow'       => 667,                       # (+1)
        'Acircumflexgrave'       => 667,                          # (+1)
        'Acircumflexhookabove'       => 667,                      # (+1)
        'Acircumflextilde'       => 667,                          # (+1)
        'Adblgrave'       => 667,                                 # (+1)
        'Adieresis'       => 667,                                 # +1
        'Adieresiscyrillic'       => 666,
        'Adieresismacron'       => 667,                           # (+1)
        'Adotbelow'       => 667,                                 # (+1)
        'Adotmacron'       => 667,                                # (+1)
        'Agrave'       => 667,                                    # +1
        'Ahookabove'       => 667,                                # (+1)
        'Aiecyrillic'       => 1000,
        'Ainvertedbreve'       => 667,                            # (+1)
        'Alpha'       => 667,                                     # (+1)
        'Alphatonos'       => 667,
        'Amacron'       => 667,                                   # +1
        'Aogonek'       => 667,                                   # +1
        'Aring'       => 667,                                     # +1
        'Aringacute'       => 667,                                # (+1)
        'Aringbelow'       => 667,                                # (+1)
        'Atilde'       => 667,                                    # +1
        'Aybarmenian'       => 739,
        'B'       => 667,                                         # +1
        'Bdotaccent'       => 667,                                # (+1)
        'Bdotbelow'       => 667,                                 # (+1)
        'Benarmenian'       => 724,
        'Beta'       => 667,                                      # (+1)
        'Bhook'       => 758,
        'Blinebelow'       => 667,                                # (+1)
        'Btopbar'       => 656,
        'C'       => 722,
        'Caarmenian'       => 766,
        'Cacute'       => 722,
        'Ccaron'       => 722,
        'Ccedilla'       => 722,
        'Ccedillaacute'       => 722,
        'Ccircumflex'       => 722,
        'Cdotaccent'       => 722,
        'Chaarmenian'       => 699,
        'Cheabkhasiancyrillic'       => 861,
        'Chedescenderabkhasiancyrillic'       => 861,
        'Chedescendercyrillic'       => 666,
        'Chedieresiscyrillic'       => 666,
        'Cheharmenian'       => 700,
        'Chekhakassiancyrillic'       => 666,
        'Cheverticalstrokecyrillic'       => 666,
        'Chi'       => 666,
        'Chook'       => 722,
        'Coarmenian'       => 677,
        'D'       => 722,
        'DZ'       => 1333,
        'DZcaron'       => 1333,
        'Daarmenian'       => 717,
        'Dafrican'       => 722,
        'Dcaron'       => 722,
        'Dcedilla'       => 722,
        'Dcircumflexbelow'       => 722,
        'Dcroat'       => 722,
        'Ddotaccent'       => 722,
        'Ddotbelow'       => 722,
        'Deicoptic'       => 463,
        'Delta'       => 667,                           # afm 612 too narrow
        'Dhook'       => 809,
        'Digammagreek'       => 610,
        'Dlinebelow'       => 722,
        'Dtopbar'       => 656,
        'Dz'       => 1222,
        'Dzcaron'       => 1222,
        'Dzeabkhasiancyrillic'       => 604,
        'E'       => 667,                                         # +1
        'Eacute'       => 667,                                    # +1
        'Ebreve'       => 667,                                    # (+1)
        'Ecaron'       => 667,                                    # +1
        'Ecedillabreve'       => 667,                             # (+1)
        'Echarmenian'       => 724,
        'Ecircumflex'       => 667,                               # +1
        'Ecircumflexacute'       => 667,                          # (+1)
        'Ecircumflexbelow'       => 667,                          # (+1)
        'Ecircumflexdotbelow'       => 667,                       # (+1)
        'Ecircumflexgrave'       => 667,                          # (+1)
        'Ecircumflexhookabove'       => 667,                      # (+1)
        'Ecircumflextilde'       => 667,                          # (+1)
        'Edblgrave'       => 667,                                 # (+1)
        'Edieresis'       => 667,                                 # +1
        'Edotaccent'       => 667,                                # +1
        'Edotbelow'       => 667,                                 # (+1)
        'Egrave'       => 667,                                    # +1
        'Eharmenian'       => 597,
        'Ehookabove'       => 667,                                # (+1)
        'Einvertedbreve'       => 667,                            # (+1)
        'Eiotifiedcyrillic'       => 949,
        'Emacron'       => 667,                                   # +1
        'Emacronacute'       => 667,                              # (+1)
        'Emacrongrave'       => 667,                              # (+1)
        'Endescendercyrillic'       => 722,
        'Eng'       => 723,
        'Enghecyrillic'       => 879,
        'Enhookcyrillic'       => 722,
        'Eogonek'       => 667,                                   # +1
        'Eopen'       => 604,
        'Epsilon'       => 667,                                   # (+1)
        'Epsilontonos'       => 784,
        'Ereversed'       => 667,                                 # (+1)
        'Esdescendercyrillic'       => 722,
        'Esh'       => 618,
        'Eta'       => 722,
        'Etarmenian'       => 723,
        'Etatonos'       => 837,
        'Eth'       => 722,
        'Etilde'       => 667,                                    # (+1)
        'Etildebelow'       => 667,                               # (+1)
        'Euro'       => 556,
        'Ezh'       => 610,
        'Ezhcaron'       => 610,
        'Ezhreversed'       => 610,
        'F'       => 611,                                         # +1
        'Fdotaccent'       => 611,                                # (+1)
        'Feharmenian'       => 762,
        'Feicoptic'       => 674,
        'Fhook'       => 611,                                     # (+1)
        'G'       => 778,                                         # +1
        'Gacute'       => 778,                                    # (+1)
        'Gamma'       => 550,
        'Gammaafrican'       => 624,
        'Gangiacoptic'       => 609,
        'Gbreve'       => 778,                                    # +1
        'Gcaron'       => 778,                                    # (+1)
        'Gcircumflex'       => 778,                               # (+1)
        'Gcommaaccent'       => 778,                              # +1
        'Gdotaccent'       => 778,                                # (+1)
        'Ghadarmenian'       => 717,
        'Ghemiddlehookcyrillic'       => 670,
        'Ghestrokecyrillic'       => 541,
        'Ghook'       => 778,                                     # (+1)
        'Gimarmenian'       => 715,
        'Gmacron'       => 778,                                   # (+1)
        'Gsmallhook'       => 558,
        'Gstroke'       => 778,                                   # (+1)
        'H'       => 722,
        'H18533'       => 604,
        'H18543'       => 354,
        'H18551'       => 354,
        'H22073'       => 604,
        'Haabkhasiancyrillic'       => 752,
        'Hadescendercyrillic'       => 666,
        'Hbar'       => 722,
        'Hbrevebelow'       => 722,
        'Hcedilla'       => 722,
        'Hcircumflex'       => 722,
        'Hdieresis'       => 722,
        'Hdotaccent'       => 722,
        'Hdotbelow'       => 722,
        'Hoarmenian'       => 615,
        'Horicoptic'       => 666,
        'I'       => 278,                                         # +1
        'IJ'       => 734,
        'Iacute'       => 278,                                    # +1
        'Ibreve'       => 278,                                    # (+1)
        'Icaron'       => 278,                                    # (+1)
        'Icircumflex'       => 278,                               # +1
        'Idblgrave'       => 278,                                 # (+1)
        'Idieresis'       => 278,                                 # +1
        'Idieresisacute'       => 278,                            # (+1)
        'Idieresiscyrillic'       => 718,
        'Idotaccent'       => 278,                                # +1
        'Idotbelow'       => 278,                                 # (+1)
        'Iebrevecyrillic'       => 666,
        'Igrave'       => 278,                                    # +1
        'Ihookabove'       => 278,                                # (+1)
        'Iinvertedbreve'       => 278,                            # (+1)
        'Imacron'       => 278,                                   # (+1)
        'Imacroncyrillic'       => 718,
        'Iniarmenian'       => 658,
        'Iogonek'       => 278,                                   # +1
        'Iota'       => 278,                                      # (+1)
        'Iotaafrican'       => 222,
        'Iotadieresis'       => 278,                              # (+1)
        'Iotatonos'       => 383,
        'Istroke'       => 278,                                   # (+1)
        'Itilde'       => 278,                                    # (+1)
        'Itildebelow'       => 278,                               # (+1)
        'Izhitsadblgravecyrillic'       => 803,
        'J'       => 500,
        'Jaarmenian'       => 706,
        'Jcircumflex'       => 500,
        'Jheharmenian'       => 738,
        'K'       => 667,                                         # +1
        'Kabashkircyrillic'       => 741,
        'Kacute'       => 667,                                    # (+1)
        'Kadescendercyrillic'       => 582,
        'Kahookcyrillic'       => 667,
        'Kappa'       => 667,                                     # (+1)
        'Kastrokecyrillic'       => 582,
        'Kaverticalstrokecyrillic'       => 582,
        'Kcaron'       => 667,                                    # (+1)
        'Kcommaaccent'       => 667,                              # +1
        'Kdotbelow'       => 667,                                 # (+1)
        'Keharmenian'       => 686,
        'Kenarmenian'       => 695,
        'Kheicoptic'       => 673,
        'Khook'       => 667,                                     # (+1)
        'Klinebelow'       => 667,                                # (+1)
        'Koppacyrillic'       => 722,
        'Koppagreek'       => 624,
        'Ksicyrillic'       => 604,
        'L'       => 556,
        'LJ'       => 1062,
        'Lacute'       => 556,
        'Lambda'       => 667,
        'Lcaron'       => 556,
        'Lcircumflexbelow'       => 556,
        'Lcommaaccent'       => 556,
        'Ldot'       => 556,
        'Ldotbelow'       => 556,
        'Ldotbelowmacron'       => 556,
        'Liwnarmenian'       => 527,
        'Lj'       => 833,
        'Llinebelow'       => 556,
        'Lslash'       => 556,
        'M'       => 833,
        'Macute'       => 833,
        'Mdotaccent'       => 833,
        'Mdotbelow'       => 833,
        'Menarmenian'       => 754,
        'Mturned'       => 890,
        'Mu'       => 833,
        'N'       => 722,
        'NJ'       => 1222,
        'Nacute'       => 722,
        'Ncaron'       => 722,
        'Ncircumflexbelow'       => 722,
        'Ncommaaccent'       => 722,
        'Ndotaccent'       => 722,
        'Ndotbelow'       => 722,
        'Nhookleft'       => 722,
        'Nj'       => 944,
        'Nlinebelow'       => 722,
        'Nowarmenian'       => 708,
        'Ntilde'       => 722,
        'Nu'       => 722,
        'O'       => 778,                                         # +1
        'OE'       => 1000,
        'Oacute'       => 778,                                    # +1
        'Obarredcyrillic'       => 777,
        'Obarreddieresiscyrillic'       => 777,
        'Obreve'       => 778,                                    # (+1)
        'Ocaron'       => 778,                                    # (+1)
        'Ocenteredtilde'       => 778,                            # (+1)
        'Ocircumflex'       => 778,                               # +1
        'Ocircumflexacute'       => 778,                          # (+1)
        'Ocircumflexdotbelow'       => 778,                       # (+1)
        'Ocircumflexgrave'       => 778,                          # (+1)
        'Ocircumflexhookabove'       => 778,                      # (+1)
        'Ocircumflextilde'       => 778,                          # (+1)
        'Odblgrave'       => 778,                                 # (+1)
        'Odieresis'       => 778,                                 # +1
        'Odieresiscyrillic'       => 777,
        'Odotbelow'       => 778,                                 # (+1)
        'Ograve'       => 778,                                    # +1
        'Oharmenian'       => 782,
        'Ohookabove'       => 778,                                # (+1)
        'Ohorn'       => 857,
        'Ohornacute'       => 857,
        'Ohorndotbelow'       => 857,
        'Ohorngrave'       => 857,
        'Ohornhookabove'       => 857,
        'Ohorntilde'       => 857,
        'Ohungarumlaut'       => 778,                             # +1
        'Oi'       => 868,
        'Oinvertedbreve'       => 778,                            # (+1)
        'Omacron'       => 778,                                   # +1
        'Omacronacute'       => 778,                              # (+1)
        'Omacrongrave'       => 778,                              # (+1)
        'Omega'       => 747,
        'Omegacyrillic'       => 1337,
        'Omegaroundcyrillic'       => 833,
        'Omegatitlocyrillic'       => 1190,
        'Omegatonos'       => 752,
        'Omicron'       => 778,                                   # (+1)
        'Omicrontonos'       => 774,
        'Oogonek'       => 778,                                   # (+1)
        'Oogonekmacron'       => 778,                             # (+1)
        'Oopen'       => 722,
        'Oslash'       => 778,                                    # +1
        'Oslashacute'       => 778,                               # (+1)
        'Otcyrillic'       => 1337,
        'Otilde'       => 778,                                    # +1
        'Otildeacute'       => 778,                               # (+1)
        'Otildedieresis'       => 778,                            # (+1)
        'P'       => 667,                                         # +1
        'Pacute'       => 667,                                    # (+1)
        'Pdotaccent'       => 667,                                # (+1)
        'Peharmenian'       => 792,
        'Pemiddlehookcyrillic'       => 1136,
        'Phi'       => 797,
        'Phook'       => 754,
        'Pi'       => 722,
        'Piwrarmenian'       => 761,
        'Psi'       => 835,
        'Psicyrillic'       => 796,
        'Q'       => 778,                                         # +1
        'R'       => 722,
        'Raarmenian'       => 764,
        'Racute'       => 722,
        'Rcaron'       => 722,
        'Rcommaaccent'       => 722,
        'Rdblgrave'       => 722,
        'Rdotaccent'       => 722,
        'Rdotbelow'       => 722,
        'Rdotbelowmacron'       => 722,
        'Reharmenian'       => 678,
        'Rho'       => 666,
        'Rinvertedbreve'       => 722,
        'Rlinebelow'       => 722,
        'Rsmallinverted'       => 541,
        'Rsmallinvertedsuperior'       => 364,
        'S'       => 667,                                         # +1
        'SF010000'       => 708,
        'SF020000'       => 708,
        'SF030000'       => 708,
        'SF040000'       => 708,
        'SF050000'       => 708,
        'SF060000'       => 708,
        'SF070000'       => 708,
        'SF080000'       => 708,
        'SF090000'       => 708,
        'SF100000'       => 708,
        'SF110000'       => 625,
        'SF190000'       => 708,
        'SF200000'       => 708,
        'SF210000'       => 708,
        'SF220000'       => 708,
        'SF230000'       => 708,
        'SF240000'       => 708,
        'SF250000'       => 708,
        'SF260000'       => 708,
        'SF270000'       => 708,
        'SF280000'       => 708,
        'SF360000'       => 708,
        'SF370000'       => 708,
        'SF380000'       => 708,
        'SF390000'       => 708,
        'SF400000'       => 708,
        'SF410000'       => 708,
        'SF420000'       => 708,
        'SF430000'       => 708,
        'SF440000'       => 708,
        'SF450000'       => 708,
        'SF460000'       => 708,
        'SF470000'       => 708,
        'SF480000'       => 708,
        'SF490000'       => 708,
        'SF500000'       => 708,
        'SF510000'       => 708,
        'SF520000'       => 708,
        'SF530000'       => 708,
        'SF540000'       => 708,
        'Sacute'       => 667,                                    # +1
        'Sacutedotaccent'       => 667,                           # (+1)
        'Sampigreek'       => 756,
        'Scaron'       => 667,                                    # +1
        'Scarondotaccent'       => 667,                           # (+1)
        'Scedilla'       => 667,                                  # +1
        'Schwacyrillic'       => 752,
        'Schwadieresiscyrillic'       => 752,
        'Scircumflex'       => 667,                               # (+1)
        'Scommaaccent'       => 667,                              # +1
        'Sdotaccent'       => 667,                                # (+1)
        'Sdotbelow'       => 667,                                 # (+1)
        'Sdotbelowdotaccent'       => 667,                        # (+1)
        'Seharmenian'       => 724,
        'Shaarmenian'       => 699,
        'Sheicoptic'       => 890,
        'Shhacyrillic'       => 666,
        'Shimacoptic'       => 736,
        'Sigma'       => 618,
        'Stigmagreek'       => 722,
        'T'       => 611,                                         # +1
        'Tau'       => 611,                                       # (+1)
        'Tbar'       => 611,                                      # (+1)
        'Tcaron'       => 611,                                    # +1
        'Tcedilla'       => 611,                                  # (+1)
        'Tcircumflexbelow'       => 611,                          # (+1)
        'Tcommaaccent'       => 611,                              # +1 
        'Tdotaccent'       => 611,                                # (+1)
        'Tdotbelow'       => 611,                                 # (+1)
        'Tedescendercyrillic'       => 610,
        'Tetsecyrillic'       => 925,
        'Theta'       => 777,
        'Thook'       => 611,                                     # (+1)
        'Thorn'       => 667,                                     # +1
        'Tiwnarmenian'       => 659,
        'Tlinebelow'       => 610,
        'Toarmenian'       => 806,
        'Tonefive'       => 556,
        'Tonesix'       => 656,
        'Tonetwo'       => 666,
        'Tretroflexhook'       => 610,
        'U'       => 722,
        'Uacute'       => 722,
        'Ubreve'       => 722,
        'Ucaron'       => 722,
        'Ucircumflex'       => 722,
        'Ucircumflexbelow'       => 722,
        'Udblgrave'       => 722,
        'Udieresis'       => 722,
        'Udieresisacute'       => 722,
        'Udieresisbelow'       => 722,
        'Udieresiscaron'       => 722,
        'Udieresiscyrillic'       => 635,
        'Udieresisgrave'       => 722,
        'Udieresismacron'       => 722,
        'Udotbelow'       => 722,
        'Ugrave'       => 722,
        'Uhookabove'       => 722,
        'Uhorn'       => 854,
        'Uhornacute'       => 854,
        'Uhorndotbelow'       => 854,
        'Uhorngrave'       => 854,
        'Uhornhookabove'       => 854,
        'Uhorntilde'       => 854,
        'Uhungarumlaut'       => 722,
        'Uhungarumlautcyrillic'       => 635,
        'Uinvertedbreve'       => 722,
        'Ukcyrillic'       => 1074,
        'Umacron'       => 722,
        'Umacroncyrillic'       => 635,
        'Umacrondieresis'       => 722,
        'Uogonek'       => 722,
        'Upsilon'       => 666,
        'Upsilon1'       => 772,
        'Upsilonacutehooksymbolgreek'       => 958,
        'Upsilonafrican'       => 747,
        'Upsilondieresis'       => 666,
        'Upsilondieresishooksymbolgreek'       => 772,
        'Upsilontonos'       => 855,
        'Uring'       => 722,
        'Ustraightcyrillic'       => 556,
        'Ustraightstrokecyrillic'       => 556,
        'Utilde'       => 722,
        'Utildeacute'       => 722,
        'Utildebelow'       => 722,
        'V'       => 667,                                         # +1
        'Vdotbelow'       => 667,                                 # (+1)
        'Vewarmenian'       => 698,
        'Vhook'       => 722,
        'Voarmenian'       => 724,
        'Vtilde'       => 667,                                    # (+1)
        'W'       => 944,                                         # +1
        'Wacute'       => 944,                                    # (+1)
        'Wcircumflex'       => 944,                               # (+1)
        'Wdieresis'       => 944,                                 # (+1)
        'Wdotaccent'       => 944,                                # (+1)
        'Wdotbelow'       => 944,                                 # (+1)
        'Wgrave'       => 944,                                    # (+1)
        'X'       => 667,                                         # +1
        'Xdieresis'       => 667,                                 # (+1)
        'Xdotaccent'       => 667,                                # (+1)
        'Xeharmenian'       => 924,
        'Xi'       => 649,
        'Y'       => 667,                                         # +1
        'Yacute'       => 667,                                    # +1
        'Ycircumflex'       => 667,                               # (+1)
        'Ydieresis'       => 667,                                 # +1
        'Ydotaccent'       => 667,                                # (+1)
        'Ydotbelow'       => 667,                                 # (+1)
        'Yerudieresiscyrillic'       => 885,
        'Ygrave'       => 667,                                    # (+1)
        'Yhook'       => 772,
        'Yhookabove'       => 667,                                # (+1)
        'Yiarmenian'       => 716,
        'Yiwnarmenian'       => 515,
        'Ytilde'       => 667,                                    # (+1)
        'Yusbigcyrillic'       => 828,
        'Yusbigiotifiedcyrillic'       => 1053,
        'Yuslittlecyrillic'       => 667,
        'Yuslittleiotifiedcyrillic'       => 897,
        'Z'       => 611,                                         # +1
        'Zaarmenian'       => 708,
        'Zacute'       => 611,                                    # +1
        'Zcaron'       => 611,                                    # +1
        'Zcircumflex'       => 611,                               # (+1)
        'Zdotaccent'       => 611,                                # +1
        'Zdotbelow'       => 611,                                 # (+1)
        'Zedescendercyrillic'       => 604,
        'Zedieresiscyrillic'       => 604,
        'Zeta'       => 610,
        'Zhearmenian'       => 715,
        'Zhebrevecyrillic'       => 923,
        'Zhedescendercyrillic'       => 923,
        'Zhedieresiscyrillic'       => 923,
        'Zlinebelow'       => 611,                                # (+1)
        'Zstroke'       => 611,                                   # (+1)
        'a'       => 556,
        'aacute'       => 556,
        'abbreviationmarkarmenian'       => 513,
        'abreve'       => 556,
        'abreveacute'       => 556,
        'abrevecyrillic'       => 556,
        'abrevedotbelow'       => 556,
        'abrevegrave'       => 556,
        'abrevehookabove'       => 556,
        'abrevetilde'       => 556,
        'acaron'       => 556,
        'acircumflex'       => 556,
        'acircumflexacute'       => 556,
        'acircumflexdotbelow'       => 556,
        'acircumflexgrave'       => 556,
        'acircumflexhookabove'       => 556,
        'acircumflextilde'       => 556,
        'acute'       => 333,
        'acutebelowcmb'       => 0,
        'acutecomb'       => 0,
        'acutelowmod'       => 333,
        'acutetonecmb'       => 0,
        'adblgrave'       => 556,
        'adieresis'       => 556,
        'adieresiscyrillic'       => 556,
        'adieresismacron'       => 556,
        'adotbelow'       => 556,
        'adotmacron'       => 556,
        'ae'       => 889,
        'aeacute'       => 889,
        'aemacron'       => 889,
        'afii00208'       => 1000,
        'afii10017'       => 666,
        'afii10018'       => 656,
        'afii10019'       => 666,
        'afii10020'       => 541,
        'afii10021'       => 677,
        'afii10022'       => 666,
        'afii10023'       => 667,
        'afii10024'       => 923,
        'afii10025'       => 604,
        'afii10026'       => 718,
        'afii10027'       => 718,
        'afii10028'       => 582,
        'afii10029'       => 656,
        'afii10030'       => 833,
        'afii10031'       => 722,
        'afii10032'       => 777,
        'afii10033'       => 718,
        'afii10034'       => 666,
        'afii10035'       => 722,
        'afii10036'       => 610,
        'afii10037'       => 635,
        'afii10038'       => 760,
        'afii10039'       => 666,
        'afii10040'       => 739,
        'afii10041'       => 666,
        'afii10042'       => 916,
        'afii10043'       => 937,
        'afii10044'       => 791,
        'afii10045'       => 885,
        'afii10046'       => 656,
        'afii10047'       => 718,
        'afii10048'       => 1010,
        'afii10049'       => 722,
        'afii10050'       => 488,
        'afii10051'       => 864,
        'afii10052'       => 541,
        'afii10053'       => 718,
        'afii10054'       => 666,
        'afii10055'       => 277,
        'afii10056'       => 277,
        'afii10057'       => 500,
        'afii10058'       => 1057,
        'afii10059'       => 1010,
        'afii10060'       => 854,
        'afii10061'       => 582,
        'afii10062'       => 635,
        'afii10065'       => 556,
        'afii10066'       => 572,
        'afii10067'       => 531,
        'afii10068'       => 364,
        'afii10069'       => 583,
        'afii10070'       => 556,
        'afii10071'       => 556,
        'afii10072'       => 668,
        'afii10073'       => 458,
        'afii10074'       => 558,
        'afii10075'       => 558,
        'afii10076'       => 437,
        'afii10077'       => 583,
        'afii10078'       => 687,
        'afii10079'       => 552,
        'afii10080'       => 556,
        'afii10081'       => 541,
        'afii10082'       => 556,
        'afii10083'       => 500,
        'afii10084'       => 458,
        'afii10085'       => 500,
        'afii10086'       => 822,
        'afii10087'       => 500,
        'afii10088'       => 572,
        'afii10089'       => 520,
        'afii10090'       => 802,
        'afii10091'       => 822,
        'afii10092'       => 625,
        'afii10093'       => 718,
        'afii10094'       => 520,
        'afii10095'       => 510,
        'afii10096'       => 750,
        'afii10097'       => 541,
        'afii10098'       => 411,
        'afii10099'       => 556,
        'afii10100'       => 364,
        'afii10101'       => 510,
        'afii10102'       => 500,
        'afii10103'       => 222,
        'afii10104'       => 277,
        'afii10105'       => 222,
        'afii10106'       => 906,
        'afii10107'       => 812,
        'afii10108'       => 556,
        'afii10109'       => 437,
        'afii10110'       => 500,
        'afii10145'       => 718,
        'afii10146'       => 777,
        'afii10147'       => 777,
        'afii10148'       => 803,
        'afii10193'       => 552,
        'afii10194'       => 612,
        'afii10195'       => 556,
        'afii10196'       => 630,
        'afii10846'       => 556,
        'afii299'       => 0,
        'afii300'       => 0,
        'afii301'       => 0,
        'afii57381'       => 525,
        'afii57388'       => 318,
        'afii57396'       => 525,
        'afii57397'       => 525,
        'afii57398'       => 525,
        'afii57403'       => 318,
        'afii57407'       => 356,
        'afii57409'       => 412,
        'afii57440'       => 207,
        'afii57451'       => 0,
        'afii57452'       => 0,
        'afii57453'       => 0,
        'afii57454'       => 0,
        'afii57455'       => 0,
        'afii57456'       => 0,
        'afii57457'       => 0,
        'afii57458'       => 0,
        'afii57534'       => 282,
        'afii57636'       => 815,
        'afii57645'       => 382,
        'afii57658'       => 277,
        'afii57664'       => 562,
        'afii57665'       => 541,
        'afii57666'       => 398,
        'afii57667'       => 508,
        'afii57668'       => 602,
        'afii57669'       => 246,
        'afii57670'       => 382,
        'afii57671'       => 598,
        'afii57672'       => 589,
        'afii57673'       => 246,
        'afii57674'       => 509,
        'afii57675'       => 460,
        'afii57676'       => 462,
        'afii57677'       => 598,
        'afii57678'       => 601,
        'afii57679'       => 246,
        'afii57680'       => 352,
        'afii57681'       => 574,
        'afii57682'       => 529,
        'afii57683'       => 566,
        'afii57684'       => 546,
        'afii57685'       => 461,
        'afii57686'       => 478,
        'afii57687'       => 549,
        'afii57688'       => 509,
        'afii57689'       => 694,
        'afii57690'       => 642,
        'afii57694'       => 694,
        'afii57695'       => 694,
        'afii57700'       => 246,
        'afii57705'       => 493,
        'afii57716'       => 493,
        'afii57717'       => 493,
        'afii57718'       => 493,
        'afii57723'       => 286,
        'afii57793'       => 0,
        'afii57794'       => 0,
        'afii57795'       => 0,
        'afii57796'       => 0,
        'afii57797'       => 0,
        'afii57798'       => 0,
        'afii57799'       => 0,
        'afii57800'       => 0,
        'afii57801'       => 0,
        'afii57802'       => 0,
        'afii57803'       => 0,
        'afii57804'       => 0,
        'afii57806'       => 0,
        'afii57807'       => 0,
        'afii57839'       => 0,
        'afii57841'       => 0,
        'afii57842'       => 274,
        'afii57929'       => 222,
        'afii61248'       => 885,
        'afii61289'       => 323,
        'afii61352'       => 1072,
        'afii61573'       => 0,
        'afii61574'       => 0,
        'afii61575'       => 0,
        'afii61664'       => 0,
        'afii63167'       => 525,
        'afii64937'       => 222,
        'agrave'       => 556,
        'ahookabove'       => 556,
        'aiecyrillic'       => 889,
        'ainfinalarabic'       => 450,
        'aininitialarabic'       => 525,
        'ainmedialarabic'       => 394,
        'ainvertedbreve'       => 556,
        'alefdageshhebrew'       => 562,
        'aleffinalarabic'       => 229,
        'alefhamzaabovefinalarabic'       => 229,
        'alefhamzabelowfinalarabic'       => 229,
        'aleflamedhebrew'       => 575,
        'alefmaddaabovefinalarabic'       => 229,
        'alefmaksurafinalarabic'       => 588,
        'alefmaksurainitialarabic'       => 244,
        'alefmaksuramedialarabic'       => 244,
        'alefpatahhebrew'       => 562,
        'alefqamatshebrew'       => 562,
        'alpha'       => 578,
        'alphatonos'       => 578,
        'amacron'       => 556,
        'ampersand'       => 667,                                 # +1
        'anoteleia'       => 277,
        'aogonek'       => 556,
        'apostrophearmenian'       => 222,
        'approxequal'       => 548,
        'arighthalfring'       => 556,
        'aring'       => 556,
        'aringacute'       => 556,
        'aringbelow'       => 556,
        'arrowboth'       => 1000,
        'arrowdown'       => 500,
        'arrowheaddownmod'       => 583,
        'arrowheadleftmod'       => 583,
        'arrowheadrightmod'       => 583,
        'arrowheadupmod'       => 583,
        'arrowleft'       => 1000,
        'arrowright'       => 1000,
        'arrowup'       => 500,
        'arrowupdn'       => 500,
        'arrowupdnbse'       => 500,
        'asciicircum'       => 469,
        'asciitilde'       => 584,                                # +1
        'ascript'       => 556,
        'ascriptturned'       => 556,
        'asterisk'       => 389,
        'at'       => 1015,
        'atilde'       => 556,
        'aturned'       => 556,
        'aybarmenian'       => 832,
        'ayinaltonehebrew'       => 535,
        'b'       => 556,
        'backslash'       => 278,                                 # +1
        'bar'       => 260,                                       # +1
        'bdotaccent'       => 556,
        'bdotbelow'       => 556,
        'behfinalarabic'       => 713,
        'behinitialarabic'       => 244,
        'behmedialarabic'       => 244,
        'benarmenian'       => 550,
        'beta'       => 575,
        'betasymbolgreek'       => 575,
        'betdagesh'       => 541,
        'betrafehebrew'       => 541,
        'bhook'       => 556,
        'bilabialclick'       => 777,
        'blinebelow'       => 556,
        'block'       => 708,
        'braceleft'       => 334,                                 # +1
        'braceright'       => 334,                                # +1
        'bracketleft'       => 278,                               # +1
        'bracketright'       => 278,                              # +1
        'breve'       => 333,
        'brevebelowcmb'       => 0,
        'brevecmb'       => 0,
        'breveinvertedbelowcmb'       => 0,
        'breveinvertedcmb'       => 0,
        'breveinverteddoublecmb'       => 0,
        'bridgebelowcmb'       => 0,
        'bridgeinvertedbelowcmb'       => 0,
        'brokenbar'       => 260,                                 # +1
        'bstroke'       => 556,
        'btopbar'       => 556,
        'bullet'       => 350,
        'c'       => 500,
        'caarmenian'       => 542,
        'cacute'       => 500,
        'candrabinducmb'       => 0,
        'caron'       => 333,
        'caronbelowcmb'       => 0,
        'caroncmb'       => 0,
        'ccaron'       => 500,
        'ccedilla'       => 500,
        'ccedillaacute'       => 500,
        'ccircumflex'       => 500,
        'ccurl'       => 500,
        'cdotaccent'       => 500,
        'cedilla'       => 333,
        'cedillacmb'       => 0,
        'cent'       => 556,
        'chaarmenian'       => 346,
        'cheabkhasiancyrillic'       => 666,
        'chedescenderabkhasiancyrillic'       => 666,
        'chedescendercyrillic'       => 520,
        'chedieresiscyrillic'       => 520,
        'cheharmenian'       => 558,
        'chekhakassiancyrillic'       => 520,
        'cheverticalstrokecyrillic'       => 520,
        'chi'       => 524,
        'chook'       => 500,
        'circle'       => 604,
        'circumflex'       => 333,
        'circumflexbelowcmb'       => 0,
        'circumflexcmb'       => 0,
        'clickalveolar'       => 583,
        'clickdental'       => 259,
        'clickretroflex'       => 277,
        'club'       => 656,
        'coarmenian'       => 555,
        'colon'       => 278,                                     # +1
        'colonmonetary'       => 722,
        'colontriangularhalfmod'       => 277,
        'colontriangularmod'       => 277,
        'comma'       => 278,                                     # +1
        'commaabovecmb'       => 0,
        'commaaboverightcmb'       => 0,
        'commaarmenian'       => 265,
        'commaaccent'       => 250,
        'commareversedabovecmb'       => 0,
        'commaturnedabovecmb'       => 0,
        'commaturnedmod'       => 222,
        'copyright'       => 737,                                 # +1
        'copysr'       => 736,
        'cruzeiro'       => 722,
        'cstretched'       => 500,
        'currency'       => 556,
        'd'       => 556,
        'daarmenian'       => 582,
        'dadfinalarabic'       => 1098,
        'dadinitialarabic'       => 846,
        'dadmedialarabic'       => 846,
        'dagger'       => 556,
        'daggerdbl'       => 556,
        'daletdagesh'       => 508,
        'dalfinalarabic'       => 337,
        'dargahebrew'       => 0,
        'dasiapneumatacyrilliccmb'       => 0,
        'dblarchinvertedbelowcmb'       => 0,
        'dblgravecmb'       => 0,
        'dbllowlinecmb'       => 0,
        'dbloverlinecmb'       => 0,
        'dblprimemod'       => 354,
        'dblverticalbar'       => 413,
        'dblverticallineabovecmb'       => 0,
        'dcaron'       => 643,                          # was 614 use afm
        'dcedilla'       => 556,
        'dcircumflexbelow'       => 556,
        'dcroat'       => 556,
        'ddalfinalarabic'       => 337,
        'ddotaccent'       => 556,
        'ddotbelow'       => 556,
        'decimalseparatorarabic'       => 318,
        'degree'       => 400,                                    # +1
        'dehihebrew'       => 0,
        'deicoptic'       => 409,
        'delta'       => 556,
        'deltaturned'       => 556,
        'dezh'       => 906,
        'dhook'       => 556,
        'dialytikatonoscmb'       => 0,
        'diamond'       => 510,
        'dieresis'       => 333,
        'dieresisbelowcmb'       => 0,
        'dieresiscmb'       => 0,
        'dieresistonos'       => 333,
        'divide'       => 548,                          # afm 584 too wide
        'dkshade'       => 729,
        'dlinebelow'       => 556,
        'dnblock'       => 708,
        'dollar'       => 556,
        'dong'       => 513,
        'dotaccent'       => 333,
        'dotaccentcmb'       => 0,
        'dotbelowcomb'       => 0,
        'dotlessi'       => 278,                                  # +1
        'dotlessj'       => 222,
        'dotlessjstrokehook'       => 259,
        'dottedcircle'       => 594,
        'downtackbelowcmb'       => 0,
        'downtackmod'       => 333,
        'dtail'       => 556,
        'dtopbar'       => 556,
        'dz'       => 1048,
        'dzaltone'       => 964,
        'dzcaron'       => 1048,
        'dzcurl'       => 1005,
        'dzeabkhasiancyrillic'       => 544,
        'e'       => 556,
        'eacute'       => 556,
        'ebreve'       => 556,
        'ecaron'       => 556,
        'ecedillabreve'       => 556,
        'echarmenian'       => 553,
        'echyiwnarmenian'       => 712,
        'ecircumflex'       => 556,
        'ecircumflexacute'       => 556,
        'ecircumflexbelow'       => 556,
        'ecircumflexdotbelow'       => 556,
        'ecircumflexgrave'       => 556,
        'ecircumflexhookabove'       => 556,
        'ecircumflextilde'       => 556,
        'edblgrave'       => 556,
        'edieresis'       => 556,
        'edotaccent'       => 556,
        'edotbelow'       => 556,
        'egrave'       => 556,
        'eharmenian'       => 491,
        'ehookabove'       => 556,
        'eight'       => 556,
        'eightpersian'       => 525,
        'eightsuperior'       => 333,
        'einvertedbreve'       => 556,
        'eiotifiedcyrillic'       => 713,
        'ellipsis'       => 1000,
        'emacron'       => 556,
        'emacronacute'       => 556,
        'emacrongrave'       => 556,
        'emdash'       => 1000,
        'emphasismarkarmenian'       => 169,
        'emsp'       => 1000,
        'emsp13'       => 333,
        'emsp14'       => 250,
        'endash'       => 556,
        'endescendercyrillic'       => 552,
        'eng'       => 556,
        'enghecyrillic'       => 647,
        'enhookcyrillic'       => 552,
        'enspace'       => 500,
        'eogonek'       => 556,
        'eopen'       => 458,
        'eopenclosed'       => 507,
        'eopenreversed'       => 458,
        'eopenreversedclosed'       => 507,
        'eopenreversedhook'       => 631,
        'epsilon'       => 445,
        'epsilontonos'       => 445,
        'equal'       => 584,                                     # +1
        'equivalence'       => 583,
        'ereversed'       => 556,
        'esdescendercyrillic'       => 500,
        'esh'       => 222,
        'eshcurl'       => 349,
        'eshreversedloop'       => 380,
        'eshsquatreversed'       => 222,
        'estimated'       => 600,
        'eta'       => 556,
        'etarmenian'       => 550,
        'etatonos'       => 556,
        'eth'       => 556,
        'etilde'       => 556,
        'etildebelow'       => 556,
        'etnahtafoukhhebrew'       => 0,
        'eturned'       => 556,
        'exclam'       => 278,                                    # +1
        'exclamarmenian'       => 200,
        'exclamdbl'       => 500,
        'exclamdown'       => 333,
        'ezh'       => 544,
        'ezhcaron'       => 544,
        'ezhcurl'       => 544,
        'ezhreversed'       => 544,
        'ezhtail'       => 544,
        'f'       => 278,                                         # +1
        'fdotaccent'       => 277,
        'feharmenian'       => 743,
        'fehfinalarabic'       => 788,
        'fehinitialarabic'       => 267,
        'fehmedialarabic'       => 262,
        'feicoptic'       => 556,
        'female'       => 750,
        'ff'       => 534,
        'ffi'       => 752,
        'ffl'       => 752,
        'fi'       => 500,
        'figuredash'       => 556,
        'filledbox'       => 604,
        'filledrect'       => 1000,
        'finalkafdagesh'       => 509,
        'five'       => 556,
        'fiveeighths'       => 833,
        'fivepersian'       => 525,
        'fivesuperior'       => 333,
        'fl'       => 500,
        'florin'       => 556,
        'four'       => 556,
        'fourpersian'       => 525,
        'foursuperior'       => 333,
        'fourthtonechinese'       => 333,
        'fraction'       => 167,                                  # +1
        'franc'       => 556,
        'g'       => 556,
        'gacute'       => 556,
        'gaffinalarabic'       => 932,
        'gafinitialarabic'       => 394,
        'gafmedialarabic'       => 514,
        'gamma'       => 500,
        'gammad'       => 403,
        'gammalatinsmall'       => 500,
        'gammasuperior'       => 322,
        'gangiacoptic'       => 596,
        'gbreve'       => 556,
        'gcaron'       => 556,
        'gcircumflex'       => 556,
        'gcommaaccent'       => 556,
        'gdotaccent'       => 556,
        'gereshaccenthebrew'       => 0,
        'gereshhebrew'       => 235,
        'gereshmuqdamhebrew'       => 0,
        'germandbls'       => 611,                                # +1
        'gershayimaccenthebrew'       => 0,
        'gershayimhebrew'       => 416,
        'ghadarmenian'       => 553,
        'ghainfinalarabic'       => 450,
        'ghaininitialarabic'       => 525,
        'ghainmedialarabic'       => 394,
        'ghemiddlehookcyrillic'       => 548,
        'ghestrokecyrillic'       => 364,
        'ghook'       => 556,
        'gimarmenian'       => 579,
        'gimeldagesh'       => 398,
        'glottalinvertedstroke'       => 486,
        'glottalstop'       => 500,
        'glottalstopinverted'       => 500,
        'glottalstopmod'       => 348,
        'glottalstopreversed'       => 500,
        'glottalstopreversedmod'       => 348,
        'glottalstopreversedsuperior'       => 348,
        'glottalstopstroke'       => 500,
        'glottalstopstrokereversed'       => 500,
        'gmacron'       => 556,
        'grave'       => 333,
        'gravebelowcmb'       => 0,
        'gravecomb'       => 0,
        'gravelowmod'       => 333,
        'gravetonecmb'       => 0,
        'greater'       => 584,                                   # +1
        'greaterequal'       => 549,                              # +1
        'gscript'       => 556,
        'gstroke'       => 556,
        'guillemotleft'       => 556,
        'guillemotright'       => 556,
        'guilsinglleft'       => 333,
        'guilsinglright'       => 333,
        'h'       => 556,
        'haabkhasiancyrillic'       => 520,
        'hadescendercyrillic'       => 500,
        'hahfinalarabic'       => 525,
        'hahinitialarabic'       => 529,
        'hahmedialarabic'       => 529,
        'hairsp'       => 83,
        'hbar'       => 556,
        'hbrevebelow'       => 556,
        'hcedilla'       => 556,
        'hcircumflex'       => 556,
        'hdieresis'       => 556,
        'hdotaccent'       => 556,
        'hdotbelow'       => 556,
        'heart'       => 593,
        'hedagesh'       => 602,
        'hehfinalaltonearabic'       => 387,
        'hehfinalalttwoarabic'       => 375,
        'hehhamzaabovefinalarabic'       => 375,
        'hehhamzaaboveisolatedarabic'       => 282,
        'hehinitialaltonearabic'       => 244,
        'hehinitialarabic'       => 450,
        'hehmedialaltonearabic'       => 320,
        'hehmedialarabic'       => 394,
        'henghook'       => 556,
        'hhook'       => 556,
        'hhooksuperior'       => 383,
        'hlinebelow'       => 556,
        'hoarmenian'       => 550,
        'hookabovecomb'       => 0,
        'hookpalatalizedbelowcmb'       => 0,
        'hookretroflexbelowcmb'       => 0,
        'horicoptic'       => 666,
        'horncmb'       => 0,
        'house'       => 604,
        'hsuperior'       => 383,
        'hturned'       => 556,
        'hungarumlaut'       => 333,
        'hungarumlautcmb'       => 0,
        'hv'       => 880,
        'hyphen'       => 333,
        'i'       => 222,
        'iacute'       => 278,                                    # +1
        'ibreve'       => 278,                                    # (+1)
        'icaron'       => 222,
        'icircumflex'       => 278,                               # +1
        'idblgrave'       => 278,                                 # (+1)
        'idieresis'       => 278,                                 # +1
        'idieresisacute'       => 278,                            # (+1)
        'idieresiscyrillic'       => 558,
        'idotbelow'       => 222,
        'iebrevecyrillic'       => 556,
        'igrave'       => 278,                                    # +1
        'ihookabove'       => 222,
        'iinvertedbreve'       => 278,                            # (+1)
        'ij'       => 443,
        'iluyhebrew'       => 0,
        'imacron'       => 278,                                   # +1
        'imacroncyrillic'       => 558,
        'infinity'       => 712,
        'iniarmenian'       => 550,
        'integral'       => 273,
        'integralbt'       => 604,
        'integraltp'       => 604,
        'intersection'       => 718,
        'invbullet'       => 604,
        'invcircle'       => 604,
        'invsmileface'       => 1052,
        'iogonek'       => 222,
        'iota'       => 222,
        'iotadieresis'       => 222,
        'iotadieresistonos'       => 222,
        'iotalatin'       => 222,
        'iotatonos'       => 222,
        'istroke'       => 222,
        'itilde'       => 278,                                    # (+1)
        'itildebelow'       => 222,
        'izhitsadblgravecyrillic'       => 630,
        'j'       => 222,
        'jaarmenian'       => 522,
        'jcaron'       => 222,
        'jcircumflex'       => 222,
        'jcrossedtail'       => 397,
        'jdotlessstroke'       => 277,
        'jeemfinalarabic'       => 525,
        'jeeminitialarabic'       => 529,
        'jeemmedialarabic'       => 529,
        'jehfinalarabic'       => 488,
        'jheharmenian'       => 517,
        'jsuperior'       => 159,
        'k'       => 500,
        'kabashkircyrillic'       => 535,
        'kacute'       => 500,
        'kadescendercyrillic'       => 437,
        'kafdagesh'       => 460,
        'kaffinalarabic'       => 601,
        'kafinitialarabic'       => 394,
        'kafmedialarabic'       => 394,
        'kafrafehebrew'       => 460,
        'kahookcyrillic'       => 550,
        'kappa'       => 500,
        'kappasymbolgreek'       => 601,
        'kastrokecyrillic'       => 437,
        'kaverticalstrokecyrillic'       => 437,
        'kcaron'       => 500,
        'kcommaaccent'       => 500,
        'kdotbelow'       => 500,
        'keharmenian'       => 550,
        'kenarmenian'       => 553,
        'kgreenlandic'       => 500,
        'khahfinalarabic'       => 525,
        'khahinitialarabic'       => 529,
        'khahmedialarabic'       => 529,
        'kheicoptic'       => 500,
        'khook'       => 500,
        'klinebelow'       => 500,
        'koppacyrillic'       => 500,
        'koroniscmb'       => 0,
        'ksicyrillic'       => 458,
        'kturned'       => 500,
        'l'       => 222,
        'lacute'       => 222,
        'lamaleffinalarabic'       => 600,
        'lamalefhamzaabovefinalarabic'       => 600,
        'lamalefhamzaaboveisolatedarabic'       => 543,
        'lamalefhamzabelowfinalarabic'       => 600,
        'lamalefhamzabelowisolatedarabic'       => 543,
        'lamalefisolatedarabic'       => 543,
        'lamalefmaddaabovefinalarabic'       => 600,
        'lamalefmaddaaboveisolatedarabic'       => 543,
        'lambda'       => 500,
        'lambdastroke'       => 500,
        'lameddagesh'       => 462,
        'lamfinalarabic'       => 506,
        'laminitialarabic'       => 207,
        'lamlamhehisolatedarabic'       => 792,
        'lammedialarabic'       => 207,
        'lbar'       => 222,
        'lbelt'       => 303,
        'lcaron'       => 344,                          # was 291 use afm+15%
        'lcircumflexbelow'       => 222,
        'lcommaaccent'       => 222,
        'ldot'       => 333,
        'ldotbelow'       => 222,
        'ldotbelowmacron'       => 222,
        'leftangleabovecmb'       => 0,
        'lefttackbelowcmb'       => 0,
        'less'       => 584,                                      # +1
        'lessequal'       => 549,                                 # +1
        'lezh'       => 571,
        'lfblock'       => 708,
        'lhookretroflex'       => 222,
        'lira'       => 556,
        'liwnarmenian'       => 219,
        'lj'       => 451,
        'llinebelow'       => 222,
        'lmiddletilde'       => 327,
        'logicalnot'       => 584,                                # +1
        'longs'       => 222,
        'lowlinecmb'       => 0,
        'lozenge'       => 494,                         # afm 471 too narrow
        'lslash'       => 222,
        'ltshade'       => 708,
        'm'       => 833,
        'macron'       => 552,                          # afm 333 too narrow
        'macronbelowcmb'       => 0,
        'macroncmb'       => 0,
        'macronlowmod'       => 333,
        'macute'       => 833,
        'mahapakhhebrew'       => 0,
        'male'       => 750,
        'masoracirclehebrew'       => 0,
        'mdotaccent'       => 833,
        'mdotbelow'       => 833,
        'meemfinalarabic'       => 337,
        'meeminitialarabic'       => 394,
        'meemmedialarabic'       => 394,
        'memdagesh'       => 601,
        'menarmenian'       => 550,
        'merkhahebrew'       => 0,
        'merkhakefulahebrew'       => 0,
        'mhook'       => 833,
        'minus'       => 584,                                     # +1
        'minusbelowcmb'       => 0,
        'minusmod'       => 333,
        'minute'       => 187,
        'mlonglegturned'       => 833,
        'mturned'       => 833,
        'mu'       => 576,                              # afm 556 too narrow
        'multiply'       => 584,                                  # +1
        'munahhebrew'       => 0,
        'musicalnote'       => 500,
        'musicalnotedbl'       => 750,
        'musicsharpsign'       => 500,
        'n'       => 556,
        'nacute'       => 556,
        'napostrophe'       => 604,
        'ncaron'       => 556,
        'ncircumflexbelow'       => 556,
        'ncommaaccent'       => 556,
        'ndotaccent'       => 556,
        'ndotbelow'       => 556,
        'nhookleft'       => 556,
        'nhookretroflex'       => 556,
        'nine'       => 556,
        'ninepersian'       => 525,
        'ninesuperior'       => 333,
        'nj'       => 770,
        'nlegrightlong'       => 556,
        'nlinebelow'       => 556,
        'noonfinalarabic'       => 525,
        'noonghunnafinalarabic'       => 525,
        'noonhehinitialarabic'       => 244,
        'noonmedialarabic'       => 244,
        'notequal'       => 549,                                  # +1
        'nowarmenian'       => 553,
        'nsuperior'       => 364,
        'ntilde'       => 556,
        'nu'       => 500,
        'numbersign'       => 556,
        'numeralsigngreek'       => 333,
        'numeralsignlowergreek'       => 333,
        'numsp'       => 556,
        'nundagesh'       => 352,
        'o'       => 556,
        'oacute'       => 556,
        'obarred'       => 556,
        'obarredcyrillic'       => 556,
        'obarreddieresiscyrillic'       => 556,
        'obreve'       => 556,
        'ocaron'       => 556,
        'ocircumflex'       => 556,
        'ocircumflexacute'       => 556,
        'ocircumflexdotbelow'       => 556,
        'ocircumflexgrave'       => 556,
        'ocircumflexhookabove'       => 556,
        'ocircumflextilde'       => 556,
        'odblgrave'       => 556,
        'odieresis'       => 556,
        'odieresiscyrillic'       => 556,
        'odotbelow'       => 556,
        'oe'       => 944,                                        # +1
        'ogonek'       => 333,
        'ogonekcmb'       => 0,
        'ograve'       => 556,
        'oharmenian'       => 554,
        'ohookabove'       => 556,
        'ohorn'       => 655,
        'ohornacute'       => 655,
        'ohorndotbelow'       => 655,
        'ohorngrave'       => 655,
        'ohornhookabove'       => 655,
        'ohorntilde'       => 655,
        'ohungarumlaut'       => 556,
        'oi'       => 667,
        'oinvertedbreve'       => 556,
        'olehebrew'       => 0,
        'omacron'       => 556,
        'omacronacute'       => 556,
        'omacrongrave'       => 556,
        'omega'       => 780,
        'omega1'       => 780,
        'omegacyrillic'       => 624,
        'omegalatinclosed'       => 780,
        'omegaroundcyrillic'       => 612,
        'omegatitlocyrillic'       => 851,
        'omegatonos'       => 780,
        'omicron'       => 556,
        'omicrontonos'       => 556,
        'one'       => 556,
        'oneeighth'       => 833,
        'onehalf'       => 834,                                   # -1
        'onepersian'       => 525,
        'onequarter'       => 834,                                # +1
        'onesuperior'       => 333,
        'onethird'       => 833,
        'oogonek'       => 556,
        'oogonekmacron'       => 556,
        'oopen'       => 500,
        'openbullet'       => 354,
        'ordfeminine'       => 370,
        'ordmasculine'       => 365,
        'orthogonal'       => 979,
        'oslash'       => 611,                                    # +1
        'oslashacute'       => 610,
        'otcyrillic'       => 624,
        'otilde'       => 556,
        'otildeacute'       => 556,
        'otildedieresis'       => 556,
        'overline'       => 333,
        'overlinecmb'       => 0,
        'p'       => 556,
        'pacute'       => 556,
        'palatalizationcyrilliccmb'       => 0,
        'palochkacyrillic'       => 277,
        'paragraph'       => 537,
        'parenleft'       => 333,
        'parenleftaltonearabic'       => 318,
        'parenright'       => 333,
        'parenrightaltonearabic'       => 318,
        'partialdiff'       => 494,                     # afm 476 too narrow
        'pashtahebrew'       => 0,
        'pazerhebrew'       => 0,
        'pdotaccent'       => 556,
        'pedagesh'       => 546,
        'pefinaldageshhebrew'       => 566,
        'peharmenian'       => 832,
        'pehfinalarabic'       => 713,
        'pehinitialarabic'       => 244,
        'pehmedialarabic'       => 244,
        'pemiddlehookcyrillic'       => 870,
        'perafehebrew'       => 546,
        'percent'       => 889,
        'period'       => 278,                                    # +1
        'periodarmenian'       => 277,
        'periodcentered'       => 278,                            # +1
        'perispomenigreekcmb'       => 0,
        'perthousand'       => 1000,
        'peseta'       => 1093,
        'phi'       => 648,
        'phi1'       => 560,
        'philatin'       => 549,
        'phook'       => 556,
        'pi'       => 689,
        'piwrarmenian'       => 831,
        'plus'       => 584,                                      # +1
        'plusbelowcmb'       => 0,
        'plusminus'       => 548,                       # afm 584 too wide
        'plusmod'       => 333,
        'primemod'       => 190,
        'product'       => 823,
        'psi'       => 712,
        'psicyrillic'       => 688,
        'psilipneumatacyrilliccmb'       => 0,
        'puncsp'       => 277,
        'q'       => 556,
        'qadmahebrew'       => 0,
        'qaffinalarabic'       => 581,
        'qafinitialarabic'       => 267,
        'qafmedialarabic'       => 262,
        'qarneyparahebrew'       => 0,
        'qhook'       => 556,
        'qofdagesh'       => 549,
        'question'       => 556,
        'questionarmenian'       => 231,
        'questiondown'       => 611,                              # +1
        'questiongreek'       => 277,
        'quotedbl'       => 355,                                  # +1
        'quotedblbase'       => 333,
        'quotedblleft'       => 333,
        'quotedblright'       => 333,
        'quoteleft'       => 222,
        'quotereversed'       => 222,
        'quoteright'       => 222,
        'quotesinglbase'       => 222,
        'quotesingle'       => 191,                               # +1
        'r'       => 333,
        'raarmenian'       => 563,
        'racute'       => 333,
        'radical'       => 575,                         # was 548 use pm+5%
        'ramshorn'       => 616,
        'rcaron'       => 333,
        'rcommaaccent'       => 333,
        'rdblgrave'       => 333,
        'rdotaccent'       => 333,
        'rdotbelow'       => 333,
        'rdotbelowmacron'       => 333,
        'registered'       => 737,                                # +1
        'reharmenian'       => 550,
        'rehfinalarabic'       => 488,
        'reshdageshhebrew'       => 509,
        'reviahebrew'       => 0,
        'revlogicalnot'       => 583,
        'rfishhook'       => 333,
        'rfishhookreversed'       => 333,
        'rho'       => 568,
        'rhook'       => 333,
        'rhookturned'       => 333,
        'rhookturnedsuperior'       => 239,
        'rhosymbolgreek'       => 572,
        'rhotichookmod'       => 333,
        'righttackbelowcmb'       => 0,
        'ring'       => 333,
        'ringbelowcmb'       => 0,
        'ringcmb'       => 0,
        'ringhalfleft'       => 333,
        'ringhalfleftarmenian'       => 273,
        'ringhalfleftbelowcmb'       => 0,
        'ringhalfleftcentered'       => 333,
        'ringhalfright'       => 333,
        'ringhalfrightbelowcmb'       => 0,
        'ringhalfrightcentered'       => 333,
        'rinvertedbreve'       => 333,
        'rlinebelow'       => 333,
        'rlongleg'       => 333,
        'rlonglegturned'       => 333,
        'rrehfinalarabic'       => 488,
        'rtblock'       => 708,
        'rturned'       => 333,
        'rturnedsuperior'       => 239,
        's'       => 500,
        'sacute'       => 500,
        'sacutedotaccent'       => 500,
        'sadfinalarabic'       => 1098,
        'sadinitialarabic'       => 846,
        'sadmedialarabic'       => 846,
        'sallallahoualayhewasallamarabic'       => 731,
        'samekhdagesh'       => 574,
        'scaron'       => 500,
        'scarondotaccent'       => 500,
        'scedilla'       => 500,
        'schwadieresiscyrillic'       => 556,
        'schwahook'       => 738,
        'scircumflex'       => 500,
        'scommaaccent'       => 500,
        'sdotaccent'       => 500,
        'sdotbelow'       => 500,
        'sdotbelowdotaccent'       => 500,
        'seagullbelowcmb'       => 0,
        'second'       => 354,
        'secondtonechinese'       => 333,
        'section'       => 556,
        'seenfinalarabic'       => 821,
        'seeninitialarabic'       => 530,
        'seenmedialarabic'       => 530,
        'segoltahebrew'       => 0,
        'seharmenian'       => 550,
        'semicolon'       => 278,
        'seven'       => 556,
        'seveneighths'       => 833,
        'sevenpersian'       => 525,
        'sevensuperior'       => 333,
        'shaarmenian'       => 456,
        'shaddadammaarabic'       => 0,
        'shaddadammatanarabic'       => 0,
        'shaddafathaarabic'       => 0,
        'shaddakasraarabic'       => 0,
        'shaddakasratanarabic'       => 0,
        'shade'       => 708,
        'shalshelethebrew'       => 0,
        'sheenfinalarabic'       => 821,
        'sheeninitialarabic'       => 530,
        'sheenmedialarabic'       => 530,
        'sheicoptic'       => 833,
        'shhacyrillic'       => 556,
        'shimacoptic'       => 553,
        'shindagesh'       => 694,
        'shindageshshindot'       => 694,
        'shindageshsindot'       => 694,
        'shook'       => 500,
        'sigma'       => 617,
        'sigma1'       => 481,
        'sigmalunatesymbolgreek'       => 500,
        'six'       => 556,
        'sixpersian'       => 525,
        'sixsuperior'       => 333,
        'slash'       => 278,                                     # +1
        'slongdotaccent'       => 222,
        'smileface'       => 1020,
        'soliduslongoverlaycmb'       => 0,
        'solidusshortoverlaycmb'       => 0,
        'space'       => 278,                                     # +1
        'spade'       => 531,
        'squarebelowcmb'       => 0,
        'sterling'       => 556,
        'strokelongoverlaycmb'       => 0,
        'strokeshortoverlaycmb'       => 0,
        'summation'       => 748,                       # was 712 use pm+5%
        'sun'       => 916,
        't'       => 278,                                         # +1
        'tahfinalarabic'       => 581,
        'tahinitialarabic'       => 581,
        'tahmedialarabic'       => 581,
        'tau'       => 395,
        'tavdages'       => 642,
        'tbar'       => 278,                                      # (+1)
        'tcaron'       => 394,                          # was 375 use pm+5%
        'tccurl'       => 718,
        'tcedilla'       => 278,                                  # (+1)
        'tchehfinalarabic'       => 525,
        'tchehinitialarabic'       => 529,
        'tchehmedialarabic'       => 529,
        'tcircumflexbelow'       => 278,                          # (+1)
        'tcommaaccent'       => 278,                              # +1
        'tdieresis'       => 278,                                 # (+1)
        'tdotaccent'       => 278,                                # (+1)
        'tdotbelow'       => 278,                                 # (+1)
        'tedescendercyrillic'       => 458,
        'tehfinalarabic'       => 713,
        'tehinitialarabic'       => 244,
        'tehmarbutafinalarabic'       => 375,
        'tehmedialarabic'       => 244,
        'telishagedolahebrew'       => 0,
        'telishaqetanahebrew'       => 0,
        'tesh'       => 429,
        'tetdagesh'       => 589,
        'tetsecyrillic'       => 690,
        'tevirhebrew'       => 0,
        'thalfinalarabic'       => 337,
        'thehfinalarabic'       => 713,
        'thehinitialarabic'       => 244,
        'thehmedialarabic'       => 244,
        'theta'       => 556,
        'theta1'       => 546,
        'thook'       => 278,                                     # (+1)
        'thorn'       => 556,
        'thousandcyrillic'       => 503,
        'thousandsseparatorarabic'       => 318,
        'three'       => 556,
        'threeeighths'       => 833,
        'threepersian'       => 525,
        'threequarters'       => 834,                             # +1
        'threesuperior'       => 333,
        'tilde'       => 333,
        'tildebelowcmb'       => 0,
        'tildecomb'       => 0,
        'tildedoublecmb'       => 0,
        'tildeoverlaycmb'       => 0,
        'tildeverticalcmb'       => 0,
        'tipehahebrew'       => 0,
        'titlocyrilliccmb'       => 0,
        'tiwnarmenian'       => 831,
        'tlinebelow'       => 278,                                # (+1)
        'toarmenian'       => 667,
        'tonebarextrahighmod'       => 382,
        'tonebarextralowmod'       => 382,
        'tonebarhighmod'       => 382,
        'tonebarlowmod'       => 382,
        'tonebarmidmod'       => 382,
        'tonefive'       => 458,
        'tonesix'       => 556,
        'tonetwo'       => 500,
        'tonos'       => 333,
        'tpalatalhook'       => 278,                              # (+1)
        'tprime'       => 354,
        'trademark'       => 1000,
        'tretroflexhook'       => 278,                            # (+1)
        'triagdn'       => 989,
        'triaglf'       => 989,
        'triagrt'       => 989,
        'triagup'       => 989,
        'ts'       => 712,
        'tsadidagesh'       => 478,
        'ttehfinalarabic'       => 713,
        'tturned'       => 278,                                   # (+1)
        'two'       => 556,
        'twopersian'       => 525,
        'twostroke'       => 556,
        'twosuperior'       => 333,
        'twothirds'       => 833,
        'u'       => 556,
        'uacute'       => 556,
        'ubar'       => 556,
        'ubreve'       => 556,
        'ucaron'       => 556,
        'ucircumflex'       => 556,
        'ucircumflexbelow'       => 556,
        'udblgrave'       => 556,
        'udieresis'       => 556,
        'udieresisacute'       => 556,
        'udieresisbelow'       => 556,
        'udieresiscaron'       => 556,
        'udieresiscyrillic'       => 500,
        'udieresisgrave'       => 556,
        'udieresismacron'       => 556,
        'udotbelow'       => 556,
        'ugrave'       => 556,
        'uhookabove'       => 556,
        'uhorn'       => 669,
        'uhornacute'       => 669,
        'uhorndotbelow'       => 669,
        'uhorngrave'       => 669,
        'uhornhookabove'       => 669,
        'uhorntilde'       => 669,
        'uhungarumlaut'       => 556,
        'uhungarumlautcyrillic'       => 500,
        'uinvertedbreve'       => 556,
        'ukcyrillic'       => 896,
        'umacron'       => 556,
        'umacroncyrillic'       => 500,
        'umacrondieresis'       => 556,
        'underscore'       => 556,
        'underscoredbl'       => 552,
        'uni01F6'       => 1034,
        'uni01F7'       => 618,
        'uni01F8'       => 722,
        'uni01F9'       => 556,
        'uni021C'       => 544,
        'uni021D'       => 436,
        'uni021E'       => 722,
        'uni021F'       => 556,
        'uni0220'       => 706,
        'uni0221'       => 681,
        'uni0222'       => 604,
        'uni0223'       => 565,
        'uni0224'       => 610,
        'uni0225'       => 500,
        'uni0226'       => 666,
        'uni0227'       => 556,
        'uni0228'       => 666,
        'uni0229'       => 556,
        'uni022A'       => 777,
        'uni022B'       => 556,
        'uni022C'       => 777,
        'uni022D'       => 556,
        'uni022E'       => 777,
        'uni022F'       => 556,
        'uni0230'       => 777,
        'uni0231'       => 556,
        'uni0232'       => 666,
        'uni0233'       => 500,
        'uni0234'       => 349,
        'uni0235'       => 684,
        'uni0236'       => 367,
        'uni0238'       => 886,
        'uni0239'       => 886,
        'uni023A'       => 666,
        'uni023B'       => 722,
        'uni023C'       => 500,
        'uni023D'       => 556,
        'uni023E'       => 610,
        'uni023F'       => 500,
        'uni0240'       => 500,
        'uni0241'       => 580,
        'uni0242'       => 453,
        'uni0243'       => 666,
        'uni0244'       => 722,
        'uni0245'       => 667,
        'uni0246'       => 666,
        'uni0247'       => 556,
        'uni0248'       => 500,
        'uni0249'       => 222,
        'uni024A'       => 737,
        'uni024B'       => 556,
        'uni024C'       => 722,
        'uni024D'       => 333,
        'uni024E'       => 666,
        'uni024F'       => 500,
        'uni0262'       => 558,
        'uni026A'       => 355,
        'uni0274'       => 552,
        'uni0276'       => 790,
        'uni0280'       => 541,
        'uni028F'       => 519,
        'uni0299'       => 531,
        'uni029C'       => 552,
        'uni029F'       => 403,
        'uni02A9'       => 763,
        'uni02AA'       => 661,
        'uni02AB'       => 632,
        'uni02AC'       => 485,
        'uni02AD'       => 527,
        'uni02AE'       => 687,
        'uni02AF'       => 687,
        'uni02B3'       => 239,
        'uni02DF'       => 333,
        'uni02E1'       => 157,
        'uni02E2'       => 339,
        'uni02EA'       => 333,
        'uni02EB'       => 333,
        'uni02EC'       => 333,
        'uni02ED'       => 333,
        'uni02EE'       => 333,
        'uni02EF'       => 333,
        'uni02F0'       => 333,
        'uni02F1'       => 333,
        'uni02F2'       => 333,
        'uni02F3'       => 333,
        'uni02F4'       => 333,
        'uni02F5'       => 333,
        'uni02F6'       => 333,
        'uni02F7'       => 333,
        'uni02F8'       => 277,
        'uni02F9'       => 333,
        'uni02FA'       => 333,
        'uni02FB'       => 333,
        'uni02FC'       => 333,
        'uni02FD'       => 397,
        'uni02FE'       => 397,
        'uni02FF'       => 333,
        'uni0326'       => 0,
        'uni0346'       => 0,
        'uni0347'       => 0,
        'uni0348'       => 0,
        'uni0349'       => 0,
        'uni034A'       => 0,
        'uni034B'       => 0,
        'uni034C'       => 0,
        'uni034D'       => 0,
        'uni034E'       => 0,
        'uni034F'       => 0,
        'uni0350'       => 0,
        'uni0351'       => 0,
        'uni0352'       => 0,
        'uni0353'       => 0,
        'uni0354'       => 0,
        'uni0355'       => 0,
        'uni0356'       => 0,
        'uni0357'       => 0,
        'uni0358'       => 0,
        'uni0359'       => 0,
        'uni035A'       => 0,
        'uni035B'       => 0,
        'uni035C'       => 0,
        'uni035D'       => 0,
        'uni035E'       => 0,
        'uni035F'       => 0,
        'uni0362'       => 0,
        'uni0363'       => 0,
        'uni0364'       => 0,
        'uni0365'       => 0,
        'uni0366'       => 0,
        'uni0367'       => 0,
        'uni0368'       => 0,
        'uni0369'       => 0,
        'uni036A'       => 0,
        'uni036B'       => 0,
        'uni036C'       => 0,
        'uni036D'       => 0,
        'uni036E'       => 0,
        'uni036F'       => 0,
        'uni0370'       => 577,
        'uni0371'       => 475,
        'uni0372'       => 610,
        'uni0373'       => 458,
        'uni0376'       => 718,
        'uni0377'       => 583,
        'uni037B'       => 500,
        'uni037C'       => 500,
        'uni037D'       => 500,
        'uni037F'       => 500,
        'uni03CF'       => 666,
        'uni03D7'       => 601,
        'uni03D8'       => 777,
        'uni03D9'       => 556,
        'uni03DB'       => 500,
        'uni03DF'       => 529,
        'uni03E1'       => 576,
        'uni03F4'       => 777,
        'uni03F5'       => 441,
        'uni03F6'       => 441,
        'uni03F7'       => 666,
        'uni03F8'       => 556,
        'uni03F9'       => 722,
        'uni03FA'       => 833,
        'uni03FB'       => 687,
        'uni03FC'       => 568,
        'uni03FD'       => 722,
        'uni03FE'       => 722,
        'uni03FF'       => 722,
        'uni0400'       => 666,
        'uni040D'       => 718,
        'uni0450'       => 556,
        'uni045D'       => 558,
        'uni0487'       => 0,
        'uni0488'       => 0,
        'uni0489'       => 0,
        'uni048A'       => 718,
        'uni048B'       => 558,
        'uni048C'       => 656,
        'uni048D'       => 520,
        'uni048E'       => 666,
        'uni048F'       => 556,
        'uni04C5'       => 656,
        'uni04C6'       => 583,
        'uni04C9'       => 722,
        'uni04CA'       => 552,
        'uni04CD'       => 833,
        'uni04CE'       => 687,
        'uni04CF'       => 222,
        'uni04EC'       => 718,
        'uni04ED'       => 510,
        'uni04F6'       => 541,
        'uni04F7'       => 364,
        'uni04FA'       => 541,
        'uni04FB'       => 364,
        'uni04FC'       => 666,
        'uni04FD'       => 500,
        'uni04FE'       => 666,
        'uni04FF'       => 500,
        'uni0500'       => 656,
        'uni0501'       => 556,
        'uni0502'       => 968,
        'uni0503'       => 876,
        'uni0504'       => 956,
        'uni0505'       => 815,
        'uni0506'       => 662,
        'uni0507'       => 509,
        'uni0508'       => 970,
        'uni0509'       => 909,
        'uni050A'       => 1034,
        'uni050B'       => 878,
        'uni050C'       => 777,
        'uni050D'       => 558,
        'uni050E'       => 746,
        'uni050F'       => 665,
        'uni0510'       => 604,
        'uni0511'       => 458,
        'uni0512'       => 656,
        'uni0513'       => 583,
        'uni0514'       => 959,
        'uni0515'       => 760,
        'uni0516'       => 788,
        'uni0517'       => 717,
        'uni0518'       => 957,
        'uni0519'       => 856,
        'uni051A'       => 777,
        'uni051B'       => 556,
        'uni051C'       => 943,
        'uni051D'       => 722,
        'uni051E'       => 666,
        'uni051F'       => 500,
        'uni0520'       => 1068,
        'uni0521'       => 884,
        'uni0522'       => 1131,
        'uni0523'       => 850,
        'uni0524'       => 722,
        'uni0525'       => 541,
        'uni0526'       => 704,
        'uni0527'       => 554,
        'uni0528'       => 722,
        'uni0529'       => 552,
        'uni052A'       => 1329,
        'uni052B'       => 1069,
        'uni052C'       => 666,
        'uni052D'       => 564,
        'uni052E'       => 656,
        'uni052F'       => 583,
        'uni058A'       => 324,
        'uni058D'       => 1000,
        'uni058E'       => 1000,
        'uni058F'       => 726,
        'uni05A2'       => 0,
        'uni05BA'       => 0,
        'uni05C5'       => 0,
        'uni05C6'       => 352,
        'uni05C7'       => 0,
        'uni0600'       => 936,
        'uni0601'       => 1299,
        'uni0602'       => 438,
        'uni0603'       => 1272,
        'uni0604'       => 1299,
        'uni0605'       => 0,
        'uni0606'       => 615,
        'uni0607'       => 615,
        'uni0608'       => 755,
        'uni0609'       => 604,
        'uni060A'       => 735,
        'uni060B'       => 262,
        'uni060D'       => 238,
        'uni060E'       => 656,
        'uni060F'       => 543,
        'uni0610'       => 0,
        'uni0611'       => 0,
        'uni0612'       => 0,
        'uni0613'       => 0,
        'uni0614'       => 0,
        'uni0615'       => 269,
        'uni0616'       => 0,
        'uni0617'       => 0,
        'uni0618'       => 0,
        'uni0619'       => 0,
        'uni061A'       => 0,
        'uni061C'       => 1000,
        'uni061E'       => 289,
        'uni0620'       => 638,
        'uni063B'       => 812,
        'uni063C'       => 812,
        'uni063D'       => 638,
        'uni063E'       => 638,
        'uni063F'       => 638,
        'uni0653'       => 0,
        'uni0655'       => 0,
        'uni0656'       => 0,
        'uni0657'       => 0,
        'uni0658'       => 0,
        'uni0659'       => 0,
        'uni065A'       => 0,
        'uni065B'       => 0,
        'uni065C'       => 0,
        'uni065D'       => 0,
        'uni065E'       => 0,
        'uni065F'       => 0,
        'uni066E'       => 713,
        'uni066F'       => 581,
        'uni0670'       => 0,
        'uni0672'       => 207,
        'uni0673'       => 207,
        'uni0674'       => 0,
        'uni0675'       => 207,
        'uni0676'       => 432,
        'uni0678'       => 638,
        'uni067C'       => 713,
        'uni067D'       => 713,
        'uni0681'       => 562,
        'uni0682'       => 562,
        'uni0685'       => 562,
        'uni0689'       => 337,
        'uni068A'       => 337,
        'uni068B'       => 337,
        'uni068F'       => 337,
        'uni0690'       => 337,
        'uni0692'       => 488,
        'uni0693'       => 488,
        'uni0694'       => 488,
        'uni0695'       => 488,
        'uni0696'       => 488,
        'uni0697'       => 488,
        'uni0699'       => 488,
        'uni069A'       => 821,
        'uni069B'       => 821,
        'uni069C'       => 821,
        'uni069D'       => 1098,
        'uni069E'       => 1098,
        'uni069F'       => 581,
        'uni06A0'       => 543,
        'uni06A1'       => 788,
        'uni06A2'       => 788,
        'uni06A3'       => 788,
        'uni06A5'       => 788,
        'uni06A7'       => 581,
        'uni06A8'       => 581,
        'uni06AA'       => 1155,
        'uni06AB'       => 812,
        'uni06AC'       => 601,
        'uni06AE'       => 601,
        'uni06B0'       => 812,
        'uni06B2'       => 812,
        'uni06B4'       => 812,
        'uni06B5'       => 506,
        'uni06B6'       => 506,
        'uni06B7'       => 506,
        'uni06B8'       => 506,
        'uni06B9'       => 525,
        'uni06BC'       => 525,
        'uni06BD'       => 525,
        'uni06BF'       => 562,
        'uni06C2'       => 387,
        'uni06C3'       => 387,
        'uni06C4'       => 432,
        'uni06CA'       => 432,
        'uni06CD'       => 638,
        'uni06CE'       => 638,
        'uni06CF'       => 432,
        'uni06D4'       => 207,
        'uni06D6'       => 0,
        'uni06D7'       => 0,
        'uni06D8'       => 0,
        'uni06D9'       => 0,
        'uni06DA'       => 0,
        'uni06DB'       => 0,
        'uni06DC'       => 0,
        'uni06DD'       => 1123,
        'uni06DE'       => 1084,
        'uni06DF'       => 0,
        'uni06E0'       => 0,
        'uni06E1'       => 0,
        'uni06E2'       => 0,
        'uni06E3'       => 0,
        'uni06E4'       => 0,
        'uni06E5'       => 193,
        'uni06E6'       => 370,
        'uni06E7'       => 0,
        'uni06E8'       => 0,
        'uni06E9'       => 600,
        'uni06EA'       => 0,
        'uni06EB'       => 0,
        'uni06EC'       => 0,
        'uni06ED'       => 0,
        'uni06EE'       => 337,
        'uni06EF'       => 488,
        'uni06FA'       => 821,
        'uni06FB'       => 1098,
        'uni06FC'       => 543,
        'uni06FD'       => 412,
        'uni06FE'       => 337,
        'uni06FF'       => 450,
        'uni0750'       => 713,
        'uni0751'       => 713,
        'uni0752'       => 713,
        'uni0753'       => 713,
        'uni0754'       => 713,
        'uni0755'       => 713,
        'uni0756'       => 713,
        'uni0757'       => 562,
        'uni0758'       => 562,
        'uni0759'       => 337,
        'uni075A'       => 337,
        'uni075B'       => 488,
        'uni075C'       => 821,
        'uni075D'       => 543,
        'uni075E'       => 543,
        'uni075F'       => 543,
        'uni0760'       => 788,
        'uni0761'       => 788,
        'uni0762'       => 812,
        'uni0763'       => 812,
        'uni0764'       => 812,
        'uni0765'       => 337,
        'uni0766'       => 337,
        'uni0767'       => 525,
        'uni0768'       => 525,
        'uni0769'       => 525,
        'uni076A'       => 506,
        'uni076B'       => 488,
        'uni076C'       => 488,
        'uni076D'       => 821,
        'uni076E'       => 562,
        'uni076F'       => 562,
        'uni0770'       => 821,
        'uni0771'       => 488,
        'uni0772'       => 562,
        'uni0773'       => 207,
        'uni0774'       => 207,
        'uni0775'       => 638,
        'uni0776'       => 638,
        'uni0777'       => 638,
        'uni0778'       => 432,
        'uni0779'       => 432,
        'uni077A'       => 812,
        'uni077B'       => 812,
        'uni077C'       => 562,
        'uni077D'       => 821,
        'uni077E'       => 821,
        'uni077F'       => 601,
        'uni08A0'       => 713,
        'uni08A1'       => 713,
        'uni08A2'       => 562,
        'uni08A3'       => 581,
        'uni08A4'       => 788,
        'uni08A5'       => 581,
        'uni08A6'       => 506,
        'uni08A7'       => 337,
        'uni08A8'       => 638,
        'uni08A9'       => 638,
        'uni08AA'       => 464,
        'uni08AB'       => 432,
        'uni08AC'       => 427,
        'uni08AD'       => 170,
        'uni08AE'       => 337,
        'uni08AF'       => 1098,
        'uni08B0'       => 812,
        'uni08B1'       => 282,
        'uni08B2'       => 488,
        'uni08B3'       => 543,
        'uni08B4'       => 601,
        'uni08B6'       => 713,
        'uni08B7'       => 713,
        'uni08B8'       => 713,
        'uni08B9'       => 488,
        'uni08BA'       => 638,
        'uni08BB'       => 788,
        'uni08BC'       => 581,
        'uni08BD'       => 525,
        'uni08D4'       => 0,
        'uni08D5'       => 0,
        'uni08D6'       => 0,
        'uni08D7'       => 0,
        'uni08D8'       => 0,
        'uni08D9'       => 0,
        'uni08DA'       => 0,
        'uni08DB'       => 0,
        'uni08DC'       => 0,
        'uni08DD'       => 0,
        'uni08DE'       => 0,
        'uni08DF'       => 0,
        'uni08E0'       => 0,
        'uni08E1'       => 0,
        'uni08E2'       => 483,
        'uni08E3'       => 0,
        'uni08E4'       => 0,
        'uni08E5'       => 0,
        'uni08E6'       => 0,
        'uni08E7'       => 0,
        'uni08E8'       => 0,
        'uni08E9'       => 0,
        'uni08EA'       => 0,
        'uni08EB'       => 0,
        'uni08EC'       => 0,
        'uni08ED'       => 0,
        'uni08EE'       => 0,
        'uni08EF'       => 0,
        'uni08F0'       => 0,
        'uni08F1'       => 0,
        'uni08F2'       => 0,
        'uni08F3'       => 0,
        'uni08F4'       => 0,
        'uni08F5'       => 0,
        'uni08F6'       => 0,
        'uni08F7'       => 0,
        'uni08F8'       => 0,
        'uni08F9'       => 0,
        'uni08FA'       => 0,
        'uni08FB'       => 0,
        'uni08FC'       => 0,
        'uni08FD'       => 0,
        'uni08FE'       => 0,
        'uni08FF'       => 0,
        'uni1D00'       => 496,
        'uni1D01'       => 747,
        'uni1D02'       => 889,
        'uni1D03'       => 531,
        'uni1D04'       => 500,
        'uni1D05'       => 551,
        'uni1D06'       => 551,
        'uni1D07'       => 489,
        'uni1D08'       => 458,
        'uni1D09'       => 222,
        'uni1D0A'       => 422,
        'uni1D0B'       => 500,
        'uni1D0C'       => 401,
        'uni1D0D'       => 687,
        'uni1D0E'       => 558,
        'uni1D0F'       => 556,
        'uni1D10'       => 500,
        'uni1D11'       => 608,
        'uni1D12'       => 608,
        'uni1D13'       => 608,
        'uni1D14'       => 943,
        'uni1D15'       => 457,
        'uni1D16'       => 556,
        'uni1D17'       => 556,
        'uni1D18'       => 520,
        'uni1D19'       => 541,
        'uni1D1A'       => 541,
        'uni1D1B'       => 458,
        'uni1D1C'       => 546,
        'uni1D1D'       => 596,
        'uni1D1E'       => 733,
        'uni1D1F'       => 596,
        'uni1D20'       => 500,
        'uni1D21'       => 722,
        'uni1D22'       => 500,
        'uni1D23'       => 458,
        'uni1D24'       => 427,
        'uni1D25'       => 606,
        'uni1D26'       => 364,
        'uni1D27'       => 500,
        'uni1D28'       => 541,
        'uni1D29'       => 520,
        'uni1D2A'       => 712,
        'uni1D2B'       => 583,
        'uni1D2C'       => 453,
        'uni1D2D'       => 663,
        'uni1D2E'       => 414,
        'uni1D2F'       => 414,
        'uni1D30'       => 449,
        'uni1D31'       => 410,
        'uni1D32'       => 410,
        'uni1D33'       => 496,
        'uni1D34'       => 428,
        'uni1D35'       => 166,
        'uni1D36'       => 314,
        'uni1D37'       => 424,
        'uni1D38'       => 351,
        'uni1D39'       => 510,
        'uni1D3A'       => 430,
        'uni1D3B'       => 429,
        'uni1D3C'       => 511,
        'uni1D3D'       => 382,
        'uni1D3E'       => 418,
        'uni1D3F'       => 451,
        'uni1D40'       => 432,
        'uni1D41'       => 429,
        'uni1D42'       => 622,
        'uni1D43'       => 372,
        'uni1D44'       => 372,
        'uni1D45'       => 376,
        'uni1D46'       => 599,
        'uni1D47'       => 377,
        'uni1D48'       => 377,
        'uni1D49'       => 371,
        'uni1D4A'       => 371,
        'uni1D4B'       => 318,
        'uni1D4C'       => 318,
        'uni1D4D'       => 376,
        'uni1D4E'       => 157,
        'uni1D4F'       => 338,
        'uni1D50'       => 572,
        'uni1D51'       => 382,
        'uni1D52'       => 377,
        'uni1D53'       => 354,
        'uni1D54'       => 377,
        'uni1D55'       => 377,
        'uni1D56'       => 377,
        'uni1D57'       => 219,
        'uni1D58'       => 382,
        'uni1D59'       => 407,
        'uni1D5A'       => 572,
        'uni1D5B'       => 321,
        'uni1D5C'       => 390,
        'uni1D5D'       => 385,
        'uni1D5E'       => 321,
        'uni1D5F'       => 377,
        'uni1D60'       => 439,
        'uni1D61'       => 343,
        'uni1D62'       => 157,
        'uni1D63'       => 239,
        'uni1D64'       => 382,
        'uni1D65'       => 321,
        'uni1D66'       => 385,
        'uni1D67'       => 321,
        'uni1D68'       => 379,
        'uni1D69'       => 439,
        'uni1D6A'       => 343,
        'uni1D6B'       => 908,
        'uni1D6C'       => 556,
        'uni1D6D'       => 556,
        'uni1D6E'       => 277,
        'uni1D6F'       => 833,
        'uni1D70'       => 556,
        'uni1D71'       => 556,
        'uni1D72'       => 333,
        'uni1D73'       => 333,
        'uni1D74'       => 500,
        'uni1D75'       => 277,
        'uni1D76'       => 500,
        'uni1D77'       => 556,
        'uni1D78'       => 380,
        'uni1D79'       => 556,
        'uni1D7A'       => 785,
        'uni1D7B'       => 222,
        'uni1D7C'       => 222,
        'uni1D7D'       => 556,
        'uni1D7E'       => 546,
        'uni1D7F'       => 568,
        'uni1D80'       => 556,
        'uni1D81'       => 556,
        'uni1D82'       => 277,
        'uni1D83'       => 712,
        'uni1D84'       => 500,
        'uni1D85'       => 222,
        'uni1D86'       => 833,
        'uni1D87'       => 556,
        'uni1D88'       => 556,
        'uni1D89'       => 333,
        'uni1D8A'       => 500,
        'uni1D8B'       => 386,
        'uni1D8C'       => 500,
        'uni1D8D'       => 500,
        'uni1D8E'       => 500,
        'uni1D8F'       => 556,
        'uni1D90'       => 556,
        'uni1D91'       => 556,
        'uni1D92'       => 556,
        'uni1D93'       => 458,
        'uni1D94'       => 458,
        'uni1D95'       => 650,
        'uni1D96'       => 222,
        'uni1D97'       => 500,
        'uni1D98'       => 222,
        'uni1D99'       => 556,
        'uni1D9A'       => 544,
        'uni1D9B'       => 376,
        'uni1D9C'       => 354,
        'uni1D9D'       => 348,
        'uni1D9E'       => 373,
        'uni1D9F'       => 318,
        'uni1DA0'       => 229,
        'uni1DA1'       => 229,
        'uni1DA2'       => 376,
        'uni1DA3'       => 383,
        'uni1DA4'       => 157,
        'uni1DA5'       => 157,
        'uni1DA6'       => 157,
        'uni1DA7'       => 157,
        'uni1DA8'       => 270,
        'uni1DA9'       => 157,
        'uni1DAA'       => 157,
        'uni1DAB'       => 274,
        'uni1DAC'       => 571,
        'uni1DAD'       => 571,
        'uni1DAE'       => 382,
        'uni1DAF'       => 382,
        'uni1DB0'       => 381,
        'uni1DB1'       => 377,
        'uni1DB2'       => 375,
        'uni1DB3'       => 339,
        'uni1DB4'       => 157,
        'uni1DB5'       => 219,
        'uni1DB6'       => 382,
        'uni1DB7'       => 387,
        'uni1DB8'       => 377,
        'uni1DB9'       => 353,
        'uni1DBA'       => 321,
        'uni1DBB'       => 358,
        'uni1DBC'       => 358,
        'uni1DBD'       => 358,
        'uni1DBE'       => 369,
        'uni1DBF'       => 364,
        'uni1DC0'       => 0,
        'uni1DC1'       => 0,
        'uni1DC2'       => 0,
        'uni1DC3'       => 0,
        'uni1DC4'       => 0,
        'uni1DC5'       => 0,
        'uni1DC6'       => 0,
        'uni1DC7'       => 0,
        'uni1DC8'       => 0,
        'uni1DC9'       => 0,
        'uni1DCA'       => 0,
        'uni1DFE'       => 0,
        'uni1DFF'       => 0,
        'uni1E9C'       => 277,
        'uni1E9D'       => 277,
        'uni1E9E'       => 702,
        'uni1E9F'       => 556,
        'uni1EFA'       => 766,
        'uni1EFB'       => 397,
        'uni1EFC'       => 590,
        'uni1EFD'       => 556,
        'uni1EFE'       => 668,
        'uni1EFF'       => 575,
        'uni1F00'       => 578,
        'uni1F01'       => 578,
        'uni1F02'       => 578,
        'uni1F03'       => 578,
        'uni1F04'       => 578,
        'uni1F05'       => 578,
        'uni1F06'       => 578,
        'uni1F07'       => 578,
        'uni1F08'       => 666,
        'uni1F09'       => 666,
        'uni1F0A'       => 813,
        'uni1F0B'       => 813,
        'uni1F0C'       => 813,
        'uni1F0D'       => 813,
        'uni1F0E'       => 813,
        'uni1F0F'       => 813,
        'uni1F10'       => 445,
        'uni1F11'       => 445,
        'uni1F12'       => 445,
        'uni1F13'       => 445,
        'uni1F14'       => 445,
        'uni1F15'       => 445,
        'uni1F18'       => 764,
        'uni1F19'       => 764,
        'uni1F1A'       => 927,
        'uni1F1B'       => 927,
        'uni1F1C'       => 927,
        'uni1F1D'       => 927,
        'uni1F20'       => 556,
        'uni1F21'       => 556,
        'uni1F22'       => 556,
        'uni1F23'       => 556,
        'uni1F24'       => 556,
        'uni1F25'       => 556,
        'uni1F26'       => 556,
        'uni1F27'       => 556,
        'uni1F28'       => 819,
        'uni1F29'       => 819,
        'uni1F2A'       => 1015,
        'uni1F2B'       => 1015,
        'uni1F2C'       => 1015,
        'uni1F2D'       => 1015,
        'uni1F2E'       => 1015,
        'uni1F2F'       => 1015,
        'uni1F30'       => 222,
        'uni1F31'       => 222,
        'uni1F32'       => 222,
        'uni1F33'       => 222,
        'uni1F34'       => 222,
        'uni1F35'       => 222,
        'uni1F36'       => 222,
        'uni1F37'       => 222,
        'uni1F38'       => 375,
        'uni1F39'       => 375,
        'uni1F3A'       => 570,
        'uni1F3B'       => 570,
        'uni1F3C'       => 570,
        'uni1F3D'       => 570,
        'uni1F3E'       => 570,
        'uni1F3F'       => 570,
        'uni1F40'       => 556,
        'uni1F41'       => 556,
        'uni1F42'       => 556,
        'uni1F43'       => 556,
        'uni1F44'       => 556,
        'uni1F45'       => 556,
        'uni1F48'       => 826,
        'uni1F49'       => 826,
        'uni1F4A'       => 1021,
        'uni1F4B'       => 1021,
        'uni1F4C'       => 973,
        'uni1F4D'       => 973,
        'uni1F50'       => 546,
        'uni1F51'       => 546,
        'uni1F52'       => 546,
        'uni1F53'       => 546,
        'uni1F54'       => 546,
        'uni1F55'       => 546,
        'uni1F56'       => 546,
        'uni1F57'       => 546,
        'uni1F59'       => 813,
        'uni1F5B'       => 959,
        'uni1F5D'       => 1008,
        'uni1F5F'       => 959,
        'uni1F60'       => 780,
        'uni1F61'       => 780,
        'uni1F62'       => 780,
        'uni1F63'       => 780,
        'uni1F64'       => 780,
        'uni1F65'       => 780,
        'uni1F66'       => 780,
        'uni1F67'       => 780,
        'uni1F68'       => 796,
        'uni1F69'       => 796,
        'uni1F6A'       => 991,
        'uni1F6B'       => 991,
        'uni1F6C'       => 942,
        'uni1F6D'       => 942,
        'uni1F6E'       => 942,
        'uni1F6F'       => 942,
        'uni1F70'       => 578,
        'uni1F71'       => 578,
        'uni1F72'       => 445,
        'uni1F73'       => 445,
        'uni1F74'       => 556,
        'uni1F75'       => 556,
        'uni1F76'       => 222,
        'uni1F77'       => 222,
        'uni1F78'       => 556,
        'uni1F79'       => 556,
        'uni1F7A'       => 546,
        'uni1F7B'       => 546,
        'uni1F7C'       => 780,
        'uni1F7D'       => 780,
        'uni1F80'       => 578,
        'uni1F81'       => 578,
        'uni1F82'       => 578,
        'uni1F83'       => 578,
        'uni1F84'       => 578,
        'uni1F85'       => 578,
        'uni1F86'       => 578,
        'uni1F87'       => 578,
        'uni1F88'       => 666,
        'uni1F89'       => 666,
        'uni1F8A'       => 813,
        'uni1F8B'       => 813,
        'uni1F8C'       => 813,
        'uni1F8D'       => 813,
        'uni1F8E'       => 813,
        'uni1F8F'       => 813,
        'uni1F90'       => 556,
        'uni1F91'       => 556,
        'uni1F92'       => 556,
        'uni1F93'       => 556,
        'uni1F94'       => 556,
        'uni1F95'       => 556,
        'uni1F96'       => 556,
        'uni1F97'       => 556,
        'uni1F98'       => 819,
        'uni1F99'       => 819,
        'uni1F9A'       => 1015,
        'uni1F9B'       => 1015,
        'uni1F9C'       => 1015,
        'uni1F9D'       => 1015,
        'uni1F9E'       => 1015,
        'uni1F9F'       => 1015,
        'uni1FA0'       => 780,
        'uni1FA1'       => 780,
        'uni1FA2'       => 780,
        'uni1FA3'       => 780,
        'uni1FA4'       => 780,
        'uni1FA5'       => 780,
        'uni1FA6'       => 780,
        'uni1FA7'       => 780,
        'uni1FA8'       => 796,
        'uni1FA9'       => 796,
        'uni1FAA'       => 991,
        'uni1FAB'       => 991,
        'uni1FAC'       => 942,
        'uni1FAD'       => 942,
        'uni1FAE'       => 942,
        'uni1FAF'       => 942,
        'uni1FB0'       => 578,
        'uni1FB1'       => 578,
        'uni1FB2'       => 578,
        'uni1FB3'       => 578,
        'uni1FB4'       => 578,
        'uni1FB6'       => 578,
        'uni1FB7'       => 578,
        'uni1FB8'       => 666,
        'uni1FB9'       => 666,
        'uni1FBA'       => 666,
        'uni1FBB'       => 666,
        'uni1FBC'       => 666,
        'uni1FBD'       => 333,
        'uni1FBE'       => 333,
        'uni1FBF'       => 333,
        'uni1FC0'       => 333,
        'uni1FC1'       => 333,
        'uni1FC2'       => 556,
        'uni1FC3'       => 556,
        'uni1FC4'       => 556,
        'uni1FC6'       => 556,
        'uni1FC7'       => 556,
        'uni1FC8'       => 813,
        'uni1FC9'       => 813,
        'uni1FCA'       => 868,
        'uni1FCB'       => 868,
        'uni1FCC'       => 722,
        'uni1FCD'       => 333,
        'uni1FCE'       => 333,
        'uni1FCF'       => 333,
        'uni1FD0'       => 222,
        'uni1FD1'       => 222,
        'uni1FD2'       => 222,
        'uni1FD3'       => 222,
        'uni1FD6'       => 222,
        'uni1FD7'       => 222,
        'uni1FD8'       => 277,
        'uni1FD9'       => 277,
        'uni1FDA'       => 424,
        'uni1FDB'       => 424,
        'uni1FDD'       => 333,
        'uni1FDE'       => 333,
        'uni1FDF'       => 333,
        'uni1FE0'       => 546,
        'uni1FE1'       => 546,
        'uni1FE2'       => 546,
        'uni1FE3'       => 546,
        'uni1FE4'       => 568,
        'uni1FE5'       => 568,
        'uni1FE6'       => 546,
        'uni1FE7'       => 546,
        'uni1FE8'       => 666,
        'uni1FE9'       => 666,
        'uni1FEA'       => 862,
        'uni1FEB'       => 886,
        'uni1FEC'       => 764,
        'uni1FED'       => 333,
        'uni1FEE'       => 333,
        'uni1FEF'       => 333,
        'uni1FF2'       => 780,
        'uni1FF3'       => 780,
        'uni1FF4'       => 780,
        'uni1FF6'       => 780,
        'uni1FF7'       => 780,
        'uni1FF8'       => 924,
        'uni1FF9'       => 826,
        'uni1FFA'       => 894,
        'uni1FFB'       => 796,
        'uni1FFC'       => 747,
        'uni1FFD'       => 333,
        'uni1FFE'       => 333,
        'uni2000'       => 500,
        'uni2001'       => 1000,
        'uni2006'       => 166,
        'uni201F'       => 333,
        'uni202A'       => 0,
        'uni202B'       => 0,
        'uni202F'       => 200,
        'uni203D'       => 556,
        'uni205E'       => 277,
        'uni206A'       => 0,
        'uni206B'       => 0,
        'uni206C'       => 0,
        'uni206D'       => 0,
        'uni206E'       => 0,
        'uni206F'       => 0,
        'uni2090'       => 372,
        'uni2091'       => 371,
        'uni2092'       => 377,
        'uni2093'       => 328,
        'uni2094'       => 371,
        'uni20A0'       => 556,
        'uni20A5'       => 833,
        'uni20A6'       => 722,
        'uni20A8'       => 1164,
        'uni20AD'       => 666,
        'uni20AE'       => 610,
        'uni20AF'       => 1000,
        'uni20B0'       => 520,
        'uni20B1'       => 666,
        'uni20B2'       => 777,
        'uni20B3'       => 666,
        'uni20B4'       => 556,
        'uni20B5'       => 722,
        'uni20B6'       => 556,
        'uni20B7'       => 666,
        'uni20B8'       => 610,
        'uni20B9'       => 556,
        'uni20BA'       => 556,
        'uni20BB'       => 829,
        'uni20BC'       => 786,
        'uni20BD'       => 556,
        'uni20BE'       => 794,
        'uni20BF'       => 666,
        'uni20F0'       => 0,
        'uni214D'       => 942,
        'uni214E'       => 489,
        'uni2184'       => 500,
        'uni2C60'       => 556,
        'uni2C61'       => 222,
        'uni2C62'       => 556,
        'uni2C63'       => 666,
        'uni2C64'       => 722,
        'uni2C65'       => 556,
        'uni2C66'       => 277,
        'uni2C67'       => 722,
        'uni2C68'       => 556,
        'uni2C69'       => 666,
        'uni2C6A'       => 500,
        'uni2C6B'       => 610,
        'uni2C6C'       => 500,
        'uni2C6D'       => 732,
        'uni2C6E'       => 833,
        'uni2C6F'       => 666,
        'uni2C70'       => 732,
        'uni2C71'       => 596,
        'uni2C72'       => 1037,
        'uni2C73'       => 840,
        'uni2C74'       => 500,
        'uni2C75'       => 577,
        'uni2C76'       => 425,
        'uni2C77'       => 648,
        'uni2C78'       => 695,
        'uni2C79'       => 333,
        'uni2C7A'       => 556,
        'uni2C7B'       => 489,
        'uni2C7C'       => 159,
        'uni2C7D'       => 321,
        'uni2C7E'       => 666,
        'uni2C7F'       => 610,
        'uni2E17'       => 333,
        'uniA717'       => 0,
        'uniA718'       => 0,
        'uniA719'       => 0,
        'uniA71A'       => 0,
        'uniA71B'       => 500,
        'uniA71C'       => 500,
        'uniA71D'       => 277,
        'uniA71E'       => 277,
        'uniA71F'       => 277,
        'uniA720'       => 0,
        'uniA721'       => 0,
        'uniA722'       => 277,
        'uniA723'       => 208,
        'uniA724'       => 277,
        'uniA725'       => 208,
        'uniA726'       => 722,
        'uniA727'       => 556,
        'uniA728'       => 829,
        'uniA729'       => 627,
        'uniA72A'       => 552,
        'uniA72B'       => 552,
        'uniA72C'       => 516,
        'uniA72D'       => 516,
        'uniA72E'       => 586,
        'uniA72F'       => 586,
        'uniA730'       => 503,
        'uniA731'       => 553,
        'uniA732'       => 1155,
        'uniA733'       => 912,
        'uniA734'       => 1187,
        'uniA735'       => 918,
        'uniA736'       => 1020,
        'uniA737'       => 890,
        'uniA738'       => 962,
        'uniA739'       => 734,
        'uniA73A'       => 962,
        'uniA73B'       => 734,
        'uniA73C'       => 962,
        'uniA73D'       => 734,
        'uniA73E'       => 722,
        'uniA73F'       => 500,
        'uniA740'       => 666,
        'uniA741'       => 500,
        'uniA742'       => 666,
        'uniA743'       => 500,
        'uniA744'       => 666,
        'uniA745'       => 500,
        'uniA746'       => 650,
        'uniA747'       => 310,
        'uniA748'       => 556,
        'uniA749'       => 222,
        'uniA74A'       => 802,
        'uniA74B'       => 610,
        'uniA74C'       => 877,
        'uniA74D'       => 651,
        'uniA74E'       => 1364,
        'uniA74F'       => 951,
        'uniA750'       => 666,
        'uniA751'       => 556,
        'uniA752'       => 828,
        'uniA753'       => 700,
        'uniA754'       => 933,
        'uniA755'       => 809,
        'uniA756'       => 777,
        'uniA757'       => 556,
        'uniA758'       => 979,
        'uniA759'       => 747,
        'uniA75A'       => 581,
        'uniA75B'       => 410,
        'uniA75C'       => 581,
        'uniA75D'       => 581,
        'uniA75E'       => 666,
        'uniA75F'       => 500,
        'uniA760'       => 943,
        'uniA761'       => 722,
        'uniA762'       => 548,
        'uniA763'       => 493,
        'uniA764'       => 666,
        'uniA765'       => 556,
        'uniA766'       => 666,
        'uniA767'       => 556,
        'uniA768'       => 509,
        'uniA769'       => 408,
        'uniA76A'       => 445,
        'uniA76B'       => 445,
        'uniA76C'       => 501,
        'uniA76D'       => 501,
        'uniA76E'       => 561,
        'uniA76F'       => 561,
        'uniA770'       => 326,
        'uniA771'       => 676,
        'uniA772'       => 344,
        'uniA773'       => 961,
        'uniA774'       => 680,
        'uniA775'       => 333,
        'uniA776'       => 750,
        'uniA777'       => 672,
        'uniA778'       => 475,
        'uniA779'       => 777,
        'uniA77A'       => 556,
        'uniA77B'       => 404,
        'uniA77C'       => 333,
        'uniA77D'       => 589,
        'uniA77E'       => 589,
        'uniA77F'       => 577,
        'uniA780'       => 556,
        'uniA781'       => 222,
        'uniA782'       => 799,
        'uniA783'       => 598,
        'uniA784'       => 404,
        'uniA785'       => 333,
        'uniA786'       => 643,
        'uniA787'       => 500,
        'uniA788'       => 333,
        'uniA789'       => 277,
        'uniA78A'       => 437,
        'uniA78B'       => 190,
        'uniA78C'       => 190,
        'uniA78D'       => 722,
        'uniA78E'       => 444,
        'uniA78F'       => 333,
        'uniA790'       => 767,
        'uniA791'       => 601,
        'uniA792'       => 722,
        'uniA793'       => 500,
        'uniA794'       => 500,
        'uniA795'       => 556,
        'uniA796'       => 800,
        'uniA797'       => 684,
        'uniA798'       => 653,
        'uniA799'       => 277,
        'uniA79A'       => 668,
        'uniA79B'       => 524,
        'uniA79C'       => 714,
        'uniA79D'       => 548,
        'uniA79E'       => 668,
        'uniA79F'       => 524,
        'uniA7A0'       => 777,
        'uniA7A1'       => 556,
        'uniA7A2'       => 666,
        'uniA7A3'       => 500,
        'uniA7A4'       => 722,
        'uniA7A5'       => 556,
        'uniA7A6'       => 722,
        'uniA7A7'       => 333,
        'uniA7A8'       => 666,
        'uniA7A9'       => 500,
        'uniA7AA'       => 806,
        'uniA7AB'       => 604,
        'uniA7AC'       => 732,
        'uniA7AD'       => 684,
        'uniA7AE'       => 610,
        'uniA7B0'       => 666,
        'uniA7B1'       => 610,
        'uniA7B2'       => 523,
        'uniA7B3'       => 735,
        'uniA7B4'       => 666,
        'uniA7B5'       => 575,
        'uniA7B6'       => 1002,
        'uniA7B7'       => 780,
        'uniA7F7'       => 769,
        'uniA7F8'       => 448,
        'uniA7F9'       => 639,
        'uniA7FA'       => 833,
        'uniA7FB'       => 610,
        'uniA7FC'       => 666,
        'uniA7FD'       => 833,
        'uniA7FE'       => 277,
        'uniA7FF'       => 1185,
        'uniAB30'       => 578,
        'uniAB31'       => 900,
        'uniAB32'       => 478,
        'uniAB33'       => 556,
        'uniAB34'       => 666,
        'uniAB35'       => 277,
        'uniAB36'       => 556,
        'uniAB37'       => 368,
        'uniAB38'       => 346,
        'uniAB39'       => 242,
        'uniAB3A'       => 851,
        'uniAB3B'       => 569,
        'uniAB3C'       => 556,
        'uniAB3D'       => 547,
        'uniAB3E'       => 547,
        'uniAB3F'       => 610,
        'uniAB40'       => 943,
        'uniAB41'       => 943,
        'uniAB42'       => 943,
        'uniAB43'       => 951,
        'uniAB44'       => 951,
        'uniAB45'       => 549,
        'uniAB46'       => 606,
        'uniAB47'       => 333,
        'uniAB48'       => 502,
        'uniAB49'       => 457,
        'uniAB4A'       => 627,
        'uniAB4B'       => 474,
        'uniAB4C'       => 699,
        'uniAB4D'       => 222,
        'uniAB4E'       => 556,
        'uniAB4F'       => 556,
        'uniAB50'       => 833,
        'uniAB51'       => 833,
        'uniAB52'       => 612,
        'uniAB53'       => 524,
        'uniAB54'       => 613,
        'uniAB55'       => 593,
        'uniAB56'       => 604,
        'uniAB57'       => 500,
        'uniAB58'       => 604,
        'uniAB59'       => 500,
        'uniAB5A'       => 500,
        'uniAB5B'       => 333,
        'uniAB5C'       => 383,
        'uniAB5D'       => 273,
        'uniAB5E'       => 247,
        'uniAB5F'       => 415,
        'uniAB60'       => 720,
        'uniAB61'       => 765,
        'uniAB62'       => 943,
        'uniAB63'       => 918,
        'uniAB64'       => 556,
        'uniAB65'       => 648,
        'uniF301'       => 0,
        'uniFB05'       => 536,
        'uniFB06'       => 743,
        'uniFB13'       => 1104,
        'uniFB14'       => 1104,
        'uniFB15'       => 1101,
        'uniFB16'       => 1104,
        'uniFB17'       => 1385,
        'uniFB1D'       => 246,
        'uniFB1E'       => 0,
        'uniFB21'       => 709,
        'uniFB22'       => 654,
        'uniFB23'       => 748,
        'uniFB24'       => 607,
        'uniFB25'       => 609,
        'uniFB26'       => 745,
        'uniFB27'       => 655,
        'uniFB28'       => 789,
        'uniFB29'       => 583,
        'uniFB50'       => 207,
        'uniFB51'       => 229,
        'uniFB52'       => 713,
        'uniFB53'       => 713,
        'uniFB54'       => 244,
        'uniFB55'       => 244,
        'uniFB56'       => 713,
        'uniFB5A'       => 713,
        'uniFB5B'       => 713,
        'uniFB5C'       => 244,
        'uniFB5D'       => 244,
        'uniFB5E'       => 713,
        'uniFB5F'       => 713,
        'uniFB60'       => 244,
        'uniFB61'       => 244,
        'uniFB62'       => 713,
        'uniFB63'       => 713,
        'uniFB64'       => 244,
        'uniFB65'       => 244,
        'uniFB66'       => 713,
        'uniFB6A'       => 788,
        'uniFB6E'       => 788,
        'uniFB6F'       => 788,
        'uniFB70'       => 267,
        'uniFB71'       => 262,
        'uniFB72'       => 562,
        'uniFB73'       => 525,
        'uniFB74'       => 529,
        'uniFB75'       => 529,
        'uniFB76'       => 562,
        'uniFB77'       => 525,
        'uniFB78'       => 529,
        'uniFB79'       => 529,
        'uniFB7A'       => 562,
        'uniFB7E'       => 562,
        'uniFB7F'       => 525,
        'uniFB80'       => 529,
        'uniFB81'       => 529,
        'uniFB82'       => 337,
        'uniFB83'       => 337,
        'uniFB84'       => 337,
        'uniFB85'       => 337,
        'uniFB86'       => 337,
        'uniFB87'       => 337,
        'uniFB88'       => 337,
        'uniFB8A'       => 488,
        'uniFB8C'       => 488,
        'uniFB8E'       => 812,
        'uniFB8F'       => 932,
        'uniFB90'       => 394,
        'uniFB91'       => 514,
        'uniFB92'       => 812,
        'uniFB96'       => 812,
        'uniFB97'       => 932,
        'uniFB98'       => 394,
        'uniFB99'       => 514,
        'uniFB9A'       => 812,
        'uniFB9B'       => 932,
        'uniFB9C'       => 394,
        'uniFB9D'       => 514,
        'uniFB9E'       => 525,
        'uniFBA0'       => 525,
        'uniFBA1'       => 525,
        'uniFBA2'       => 244,
        'uniFBA3'       => 244,
        'uniFBA6'       => 282,
        'uniFBAE'       => 812,
        'uniFBB0'       => 812,
        'uniFBB1'       => 812,
        'uniFBB2'       => 244,
        'uniFBB3'       => 244,
        'uniFBB4'       => 244,
        'uniFBB5'       => 244,
        'uniFBB6'       => 244,
        'uniFBB7'       => 244,
        'uniFBB8'       => 244,
        'uniFBB9'       => 244,
        'uniFBBA'       => 244,
        'uniFBBB'       => 244,
        'uniFBBC'       => 272,
        'uniFBBD'       => 244,
        'uniFBBE'       => 244,
        'uniFBBF'       => 199,
        'uniFBC0'       => 343,
        'uniFBC1'       => 343,
        'uniFBD3'       => 601,
        'uniFBD4'       => 601,
        'uniFBD5'       => 394,
        'uniFBD6'       => 394,
        'uniFBD7'       => 432,
        'uniFBD8'       => 432,
        'uniFBD9'       => 432,
        'uniFBDA'       => 432,
        'uniFBDB'       => 432,
        'uniFBDC'       => 432,
        'uniFBDD'       => 432,
        'uniFBDE'       => 432,
        'uniFBDF'       => 432,
        'uniFBE0'       => 432,
        'uniFBE1'       => 432,
        'uniFBE2'       => 432,
        'uniFBE3'       => 432,
        'uniFBE4'       => 638,
        'uniFBE5'       => 588,
        'uniFBE6'       => 244,
        'uniFBE7'       => 244,
        'uniFBE9'       => 244,
        'uniFBEA'       => 364,
        'uniFBEB'       => 364,
        'uniFBEC'       => 519,
        'uniFBED'       => 519,
        'uniFBEE'       => 638,
        'uniFBEF'       => 638,
        'uniFBF0'       => 638,
        'uniFBF1'       => 638,
        'uniFBF2'       => 638,
        'uniFBF3'       => 638,
        'uniFBF4'       => 638,
        'uniFBF5'       => 638,
        'uniFBF6'       => 562,
        'uniFBF7'       => 562,
        'uniFBF8'       => 486,
        'uniFBF9'       => 562,
        'uniFBFA'       => 562,
        'uniFBFB'       => 486,
        'uniFBFC'       => 638,
        'uniFBFD'       => 588,
        'uniFC63'       => 0,
        'uniFCF2'       => 207,
        'uniFCF3'       => 207,
        'uniFCF4'       => 207,
        'uniFD3C'       => 229,
        'uniFD3D'       => 207,
        'uniFDF4'       => 919,
        'uniFDFB'       => 634,
        'uniFDFC'       => 1221,
        'uniFDFD'       => 1464,
        'uniFE20'       => 0,
        'uniFE21'       => 0,
        'uniFE22'       => 0,
        'uniFE23'       => 0,
        'uniFE70'       => 207,
        'uniFE71'       => 207,
        'uniFE72'       => 207,
        'uniFE73'       => 289,
        'uniFE74'       => 207,
        'uniFE76'       => 207,
        'uniFE77'       => 207,
        'uniFE78'       => 207,
        'uniFE79'       => 207,
        'uniFE7A'       => 207,
        'uniFE7B'       => 207,
        'uniFE7C'       => 207,
        'uniFE7D'       => 207,
        'uniFE7E'       => 207,
        'uniFE7F'       => 207,
        'uniFE80'       => 412,
        'uniFE81'       => 207,
        'uniFE83'       => 207,
        'uniFE85'       => 432,
        'uniFE87'       => 207,
        'uniFE89'       => 638,
        'uniFE8D'       => 207,
        'uniFE8F'       => 713,
        'uniFE93'       => 282,
        'uniFE95'       => 713,
        'uniFE99'       => 713,
        'uniFE9D'       => 562,
        'uniFEA1'       => 562,
        'uniFEA5'       => 562,
        'uniFEA9'       => 337,
        'uniFEAB'       => 337,
        'uniFEAD'       => 488,
        'uniFEAF'       => 488,
        'uniFEB1'       => 821,
        'uniFEB5'       => 821,
        'uniFEB9'       => 1098,
        'uniFEBD'       => 1098,
        'uniFEC1'       => 581,
        'uniFEC5'       => 581,
        'uniFEC9'       => 543,
        'uniFECD'       => 543,
        'uniFED1'       => 788,
        'uniFED5'       => 581,
        'uniFED9'       => 601,
        'uniFEDD'       => 506,
        'uniFEE1'       => 337,
        'uniFEE5'       => 525,
        'uniFEE9'       => 282,
        'uniFEED'       => 432,
        'uniFEEF'       => 638,
        'uniFEF1'       => 638,
        'uniFFFC'       => 1000,
        'uogonek'       => 556,
        'upblock'       => 708,
        'upperdothebrew'       => 0,
        'upsilon'       => 546,
        'upsilondieresis'       => 546,
        'upsilondieresistonos'       => 546,
        'upsilonlatin'       => 568,
        'upsilontonos'       => 546,
        'uptackbelowcmb'       => 0,
        'uptackmod'       => 333,
        'uring'       => 556,
        'ustraightcyrillic'       => 500,
        'ustraightstrokecyrillic'       => 500,
        'utilde'       => 556,
        'utildeacute'       => 556,
        'utildebelow'       => 556,
        'v'       => 500,
        'vdotbelow'       => 500,
        'vehfinalarabic'       => 788,
        'vehinitialarabic'       => 267,
        'vehmedialarabic'       => 262,
        'verticallineabovecmb'       => 0,
        'verticallinebelowcmb'       => 0,
        'verticallinelowmod'       => 333,
        'verticallinemod'       => 333,
        'vewarmenian'       => 550,
        'vhook'       => 546,
        'voarmenian'       => 550,
        'vtilde'       => 500,
        'vturned'       => 500,
        'w'       => 722,
        'wacute'       => 722,
        'wawfinalarabic'       => 432,
        'wawhamzaabovefinalarabic'       => 432,
        'wcircumflex'       => 722,
        'wdieresis'       => 722,
        'wdotaccent'       => 722,
        'wdotbelow'       => 722,
        'wgrave'       => 722,
        'won'       => 943,
        'wring'       => 722,
        'wsuperior'       => 480,
        'wturned'       => 722,
        'wynn'       => 556,
        'x'       => 500,
        'xabovecmb'       => 0,
        'xdieresis'       => 500,
        'xdotaccent'       => 500,
        'xeharmenian'       => 834,
        'xi'       => 447,
        'xsuperior'       => 328,
        'y'       => 500,
        'yacute'       => 500,
        'ycircumflex'       => 500,
        'ydieresis'       => 500,
        'ydotaccent'       => 500,
        'ydotbelow'       => 500,
        'yehbarreefinalarabic'       => 812,
        'yehfinalarabic'       => 588,
        'yehhamzaabovefinalarabic'       => 588,
        'yehhamzaaboveinitialarabic'       => 244,
        'yehhamzaabovemedialarabic'       => 244,
        'yehthreedotsbelowarabic'       => 638,
        'yen'       => 556,
        'yerahbenyomohebrew'       => 0,
        'yerudieresiscyrillic'       => 718,
        'yetivhebrew'       => 0,
        'ygrave'       => 500,
        'yhook'       => 500,
        'yhookabove'       => 500,
        'yiarmenian'       => 219,
        'yiwnarmenian'       => 394,
        'yoddagesh'       => 286,
        'yotgreek'       => 222,
        'ypogegrammeni'       => 333,
        'ypogegrammenigreekcmb'       => 0,
        'yr'       => 666,
        'yring'       => 500,
        'ysuperior'       => 320,
        'ytilde'       => 500,
        'yturned'       => 500,
        'yusbigcyrillic'       => 685,
        'yusbigiotifiedcyrillic'       => 867,
        'yuslittlecyrillic'       => 500,
        'yuslittleiotifiedcyrillic'       => 695,
        'z'       => 500,
        'zaarmenian'       => 550,
        'zacute'       => 500,
        'zahfinalarabic'       => 581,
        'zahinitialarabic'       => 581,
        'zahmedialarabic'       => 581,
        'zainfinalarabic'       => 488,
        'zaqefgadolhebrew'       => 0,
        'zaqefqatanhebrew'       => 0,
        'zarqahebrew'       => 0,
        'zayindagesh'       => 411,
        'zcaron'       => 500,
        'zcircumflex'       => 500,
        'zcurl'       => 541,
        'zdotaccent'       => 500,
        'zdotbelow'       => 500,
        'zedescendercyrillic'       => 458,
        'zedieresiscyrillic'       => 458,
        'zero'       => 556,
        'zeropersian'       => 525,
        'zerosuperior'       => 333,
        'zerowidthspace'       => 0,
        'zeta'       => 440,
        'zhearmenian'       => 579,
        'zhebrevecyrillic'       => 668,
        'zhedescendercyrillic'       => 668,
        'zhedieresiscyrillic'       => 668,
        'zinorhebrew'       => 0,
        'zlinebelow'       => 500,
        'zretroflexhook'       => 500,
        'zstroke'       => 500,
    },
    'wxold' => { # HORIZ. WIDTH TABLE
        'space' => '278',                        # C+0x20 # U+0x0020
        'exclam' => '278',                       # C+0x21 # U+0x0021
        'quotedbl' => '355',                     # C+0x22 # U+0x0022
        'numbersign' => '556',                   # C+0x23 # U+0x0023
        'dollar' => '556',                       # C+0x24 # U+0x0024
        'percent' => '889',                      # C+0x25 # U+0x0025
        'ampersand' => '667',                    # C+0x26 # U+0x0026
        'quotesingle' => '191',                  # C+0x27 # U+0x0027
        'parenleft' => '333',                    # C+0x28 # U+0x0028
        'parenright' => '333',                   # C+0x29 # U+0x0029
        'asterisk' => '389',                     # C+0x2A # U+0x002A
        'plus' => '584',                         # C+0x2B # U+0x002B
        'comma' => '278',                        # C+0x2C # U+0x002C
        'hyphen' => '333',                       # C+0x2D # U+0x002D
        'period' => '278',                       # C+0x2E # U+0x002E
        'slash' => '278',                        # C+0x2F # U+0x002F
        'zero' => '556',                         # C+0x30 # U+0x0030
        'one' => '556',                          # C+0x31 # U+0x0031
        'two' => '556',                          # C+0x32 # U+0x0032
        'three' => '556',                        # C+0x33 # U+0x0033
        'four' => '556',                         # C+0x34 # U+0x0034
        'five' => '556',                         # C+0x35 # U+0x0035
        'six' => '556',                          # C+0x36 # U+0x0036
        'seven' => '556',                        # C+0x37 # U+0x0037
        'eight' => '556',                        # C+0x38 # U+0x0038
        'nine' => '556',                         # C+0x39 # U+0x0039
        'colon' => '278',                        # C+0x3A # U+0x003A
        'semicolon' => '278',                    # C+0x3B # U+0x003B
        'less' => '584',                         # C+0x3C # U+0x003C
        'equal' => '584',                        # C+0x3D # U+0x003D
        'greater' => '584',                      # C+0x3E # U+0x003E
        'question' => '556',                     # C+0x3F # U+0x003F
        'at' => '1015',                          # C+0x40 # U+0x0040
        'A' => '667',                            # C+0x41 # U+0x0041
        'B' => '667',                            # C+0x42 # U+0x0042
        'C' => '722',                            # C+0x43 # U+0x0043
        'D' => '722',                            # C+0x44 # U+0x0044
        'E' => '667',                            # C+0x45 # U+0x0045
        'F' => '611',                            # C+0x46 # U+0x0046
        'G' => '778',                            # C+0x47 # U+0x0047
        'H' => '722',                            # C+0x48 # U+0x0048
        'I' => '278',                            # C+0x49 # U+0x0049
        'J' => '500',                            # C+0x4A # U+0x004A
        'K' => '667',                            # C+0x4B # U+0x004B
        'L' => '556',                            # C+0x4C # U+0x004C
        'M' => '833',                            # C+0x4D # U+0x004D
        'N' => '722',                            # C+0x4E # U+0x004E
        'O' => '778',                            # C+0x4F # U+0x004F
        'P' => '667',                            # C+0x50 # U+0x0050
        'Q' => '778',                            # C+0x51 # U+0x0051
        'R' => '722',                            # C+0x52 # U+0x0052
        'S' => '667',                            # C+0x53 # U+0x0053
        'T' => '611',                            # C+0x54 # U+0x0054
        'U' => '722',                            # C+0x55 # U+0x0055
        'V' => '667',                            # C+0x56 # U+0x0056
        'W' => '944',                            # C+0x57 # U+0x0057
        'X' => '667',                            # C+0x58 # U+0x0058
        'Y' => '667',                            # C+0x59 # U+0x0059
        'Z' => '611',                            # C+0x5A # U+0x005A
        'bracketleft' => '278',                  # C+0x5B # U+0x005B
        'backslash' => '278',                    # C+0x5C # U+0x005C
        'bracketright' => '278',                 # C+0x5D # U+0x005D
        'asciicircum' => '469',                  # C+0x5E # U+0x005E
        'underscore' => '556',                   # C+0x5F # U+0x005F
        'grave' => '333',                        # C+0x60 # U+0x0060
        'a' => '556',                            # C+0x61 # U+0x0061
        'b' => '556',                            # C+0x62 # U+0x0062
        'c' => '500',                            # C+0x63 # U+0x0063
        'd' => '556',                            # C+0x64 # U+0x0064
        'e' => '556',                            # C+0x65 # U+0x0065
        'f' => '278',                            # C+0x66 # U+0x0066
        'g' => '556',                            # C+0x67 # U+0x0067
        'h' => '556',                            # C+0x68 # U+0x0068
        'i' => '222',                            # C+0x69 # U+0x0069
        'j' => '222',                            # C+0x6A # U+0x006A
        'k' => '500',                            # C+0x6B # U+0x006B
        'l' => '222',                            # C+0x6C # U+0x006C
        'm' => '833',                            # C+0x6D # U+0x006D
        'n' => '556',                            # C+0x6E # U+0x006E
        'o' => '556',                            # C+0x6F # U+0x006F
        'p' => '556',                            # C+0x70 # U+0x0070
        'q' => '556',                            # C+0x71 # U+0x0071
        'r' => '333',                            # C+0x72 # U+0x0072
        's' => '500',                            # C+0x73 # U+0x0073
        't' => '278',                            # C+0x74 # U+0x0074
        'u' => '556',                            # C+0x75 # U+0x0075
        'v' => '500',                            # C+0x76 # U+0x0076
        'w' => '722',                            # C+0x77 # U+0x0077
        'x' => '500',                            # C+0x78 # U+0x0078
        'y' => '500',                            # C+0x79 # U+0x0079
        'z' => '500',                            # C+0x7A # U+0x007A
        'braceleft' => '334',                    # C+0x7B # U+0x007B
        'bar' => '260',                          # C+0x7C # U+0x007C
        'braceright' => '334',                   # C+0x7D # U+0x007D
        'asciitilde' => '584',                   # C+0x7E # U+0x007E
        'bullet' => '350',                       # C+0x7F # U+0x2022
        'Euro' => '556',                         # C+0x80 # U+0x20AC
        'quotesinglbase' => '222',               # C+0x82 # U+0x201A
        'florin' => '556',                       # C+0x83 # U+0x0192
        'quotedblbase' => '333',                 # C+0x84 # U+0x201E
        'ellipsis' => '1000',                    # C+0x85 # U+0x2026
        'dagger' => '556',                       # C+0x86 # U+0x2020
        'daggerdbl' => '556',                    # C+0x87 # U+0x2021
        'circumflex' => '333',                   # C+0x88 # U+0x02C6
        'perthousand' => '1000',                 # C+0x89 # U+0x2030
        'Scaron' => '667',                       # C+0x8A # U+0x0160
        'guilsinglleft' => '333',                # C+0x8B # U+0x2039
        'OE' => '1000',                          # C+0x8C # U+0x0152
        'Zcaron' => '611',                       # C+0x8E # U+0x017D
        'quoteleft' => '222',                    # C+0x91 # U+0x2018
        'quoteright' => '222',                   # C+0x92 # U+0x2019
        'quotedblleft' => '333',                 # C+0x93 # U+0x201C
        'quotedblright' => '333',                # C+0x94 # U+0x201D
        'endash' => '556',                       # C+0x96 # U+0x2013
        'emdash' => '1000',                      # C+0x97 # U+0x2014
        'tilde' => '333',                        # C+0x98 # U+0x02DC
        'trademark' => '1000',                   # C+0x99 # U+0x2122
        'scaron' => '500',                       # C+0x9A # U+0x0161
        'guilsinglright' => '333',               # C+0x9B # U+0x203A
        'oe' => '944',                           # C+0x9C # U+0x0153
        'zcaron' => '500',                       # C+0x9E # U+0x017E
        'Ydieresis' => '667',                    # C+0x9F # U+0x0178
        'exclamdown' => '333',                   # C+0xA1 # U+0x00A1
        'cent' => '556',                         # C+0xA2 # U+0x00A2
        'sterling' => '556',                     # C+0xA3 # U+0x00A3
        'currency' => '556',                     # C+0xA4 # U+0x00A4
        'yen' => '556',                          # C+0xA5 # U+0x00A5
        'brokenbar' => '260',                    # C+0xA6 # U+0x00A6
        'section' => '556',                      # C+0xA7 # U+0x00A7
        'dieresis' => '333',                     # C+0xA8 # U+0x00A8
        'copyright' => '737',                    # C+0xA9 # U+0x00A9
        'ordfeminine' => '370',                  # C+0xAA # U+0x00AA
        'guillemotleft' => '556',                # C+0xAB # U+0x00AB
        'logicalnot' => '584',                   # C+0xAC # U+0x00AC
        'registered' => '737',                   # C+0xAE # U+0x00AE
        'macron' => '580',                       # C+0xAF # U+0x00AF
        'degree' => '400',                       # C+0xB0 # U+0x00B0
        'plusminus' => '584',                    # C+0xB1 # U+0x00B1
        'twosuperior' => '333',                  # C+0xB2 # U+0x00B2
        'threesuperior' => '333',                # C+0xB3 # U+0x00B3
        'acute' => '333',                        # C+0xB4 # U+0x00B4
        'mu' => '556',                           # C+0xB5 # U+0x00B5
        'paragraph' => '537',                    # C+0xB6 # U+0x00B6
        'periodcentered' => '278',               # C+0xB7 # U+0x00B7
        'cedilla' => '333',                      # C+0xB8 # U+0x00B8
        'onesuperior' => '333',                  # C+0xB9 # U+0x00B9
        'ordmasculine' => '365',                 # C+0xBA # U+0x00BA
        'guillemotright' => '556',               # C+0xBB # U+0x00BB
        'onequarter' => '834',                   # C+0xBC # U+0x00BC
        'onehalf' => '834',                      # C+0xBD # U+0x00BD
        'threequarters' => '834',                # C+0xBE # U+0x00BE
        'questiondown' => '611',                 # C+0xBF # U+0x00BF
        'Agrave' => '667',                       # C+0xC0 # U+0x00C0
        'Aacute' => '667',                       # C+0xC1 # U+0x00C1
        'Acircumflex' => '667',                  # C+0xC2 # U+0x00C2
        'Atilde' => '667',                       # C+0xC3 # U+0x00C3
        'Adieresis' => '667',                    # C+0xC4 # U+0x00C4
        'Aring' => '667',                        # C+0xC5 # U+0x00C5
        'AE' => '1000',                          # C+0xC6 # U+0x00C6
        'Ccedilla' => '722',                     # C+0xC7 # U+0x00C7
        'Egrave' => '667',                       # C+0xC8 # U+0x00C8
        'Eacute' => '667',                       # C+0xC9 # U+0x00C9
        'Ecircumflex' => '667',                  # C+0xCA # U+0x00CA
        'Edieresis' => '667',                    # C+0xCB # U+0x00CB
        'Igrave' => '278',                       # C+0xCC # U+0x00CC
        'Iacute' => '278',                       # C+0xCD # U+0x00CD
        'Icircumflex' => '278',                  # C+0xCE # U+0x00CE
        'Idieresis' => '278',                    # C+0xCF # U+0x00CF
        'Eth' => '722',                          # C+0xD0 # U+0x00D0
        'Ntilde' => '722',                       # C+0xD1 # U+0x00D1
        'Ograve' => '778',                       # C+0xD2 # U+0x00D2
        'Oacute' => '778',                       # C+0xD3 # U+0x00D3
        'Ocircumflex' => '778',                  # C+0xD4 # U+0x00D4
        'Otilde' => '778',                       # C+0xD5 # U+0x00D5
        'Odieresis' => '778',                    # C+0xD6 # U+0x00D6
        'multiply' => '584',                     # C+0xD7 # U+0x00D7
        'Oslash' => '778',                       # C+0xD8 # U+0x00D8
        'Ugrave' => '722',                       # C+0xD9 # U+0x00D9
        'Uacute' => '722',                       # C+0xDA # U+0x00DA
        'Ucircumflex' => '722',                  # C+0xDB # U+0x00DB
        'Udieresis' => '722',                    # C+0xDC # U+0x00DC
        'Yacute' => '667',                       # C+0xDD # U+0x00DD
        'Thorn' => '667',                        # C+0xDE # U+0x00DE
        'germandbls' => '611',                   # C+0xDF # U+0x00DF
        'agrave' => '556',                       # C+0xE0 # U+0x00E0
        'aacute' => '556',                       # C+0xE1 # U+0x00E1
        'acircumflex' => '556',                  # C+0xE2 # U+0x00E2
        'atilde' => '556',                       # C+0xE3 # U+0x00E3
        'adieresis' => '556',                    # C+0xE4 # U+0x00E4
        'aring' => '556',                        # C+0xE5 # U+0x00E5
        'ae' => '889',                           # C+0xE6 # U+0x00E6
        'ccedilla' => '500',                     # C+0xE7 # U+0x00E7
        'egrave' => '556',                       # C+0xE8 # U+0x00E8
        'eacute' => '556',                       # C+0xE9 # U+0x00E9
        'ecircumflex' => '556',                  # C+0xEA # U+0x00EA
        'edieresis' => '556',                    # C+0xEB # U+0x00EB
        'igrave' => '278',                       # C+0xEC # U+0x00EC
        'iacute' => '278',                       # C+0xED # U+0x00ED
        'icircumflex' => '278',                  # C+0xEE # U+0x00EE
        'idieresis' => '278',                    # C+0xEF # U+0x00EF
        'eth' => '556',                          # C+0xF0 # U+0x00F0
        'ntilde' => '556',                       # C+0xF1 # U+0x00F1
        'ograve' => '556',                       # C+0xF2 # U+0x00F2
        'oacute' => '556',                       # C+0xF3 # U+0x00F3
        'ocircumflex' => '556',                  # C+0xF4 # U+0x00F4
        'otilde' => '556',                       # C+0xF5 # U+0x00F5
        'odieresis' => '556',                    # C+0xF6 # U+0x00F6
        'divide' => '584',                       # C+0xF7 # U+0x00F7
        'oslash' => '611',                       # C+0xF8 # U+0x00F8
        'ugrave' => '556',                       # C+0xF9 # U+0x00F9
        'uacute' => '556',                       # C+0xFA # U+0x00FA
        'ucircumflex' => '556',                  # C+0xFB # U+0x00FB
        'udieresis' => '556',                    # C+0xFC # U+0x00FC
        'yacute' => '500',                       # C+0xFD # U+0x00FD
        'thorn' => '556',                        # C+0xFE # U+0x00FE
        'ydieresis' => '500',                    # C+0xFF # U+0x00FF
        'dotlessi' => '278',                     # U+0x0131
        'Lslash' => '556',                       # U+0x0141
        'lslash' => '222',                       # U+0x0142
        'caron' => '333',                        # U+0x02C7
        'breve' => '333',                        # U+0x02D8
        'dotaccent' => '333',                    # U+0x02D9
        'ring' => '333',                         # U+0x02DA
        'ogonek' => '333',                       # U+0x02DB
        'hungarumlaut' => '333',                 # U+0x02DD
        'dblgravecmb' => '333',                  # U+0x030F
        'fraction' => '167',                     # U+0x2044
        'minus' => '584',                        # U+0x2212
        'fi' => '500',                           # U+0xFB01
        'fl' => '500',                           # U+0xFB02
    }, # HORIZ. WIDTH TABLE
} };

1;
