// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from stm32g041.svd, see https://github.com/tinygo-org/stm32-svd

// +build stm32,stm32g041

// STM32G041
//

package stm32

import (
	"runtime/interrupt"
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	DEVICE = "STM32G041"
)

// Interrupt numbers.
const (
	// System window watchdog
	IRQ_WWDG = 0

	// External interrupt/event controller
	IRQ_PVD = 1

	// Real-time clock
	IRQ_RTC_TAMP = 2

	// Flash
	IRQ_FLASH = 3

	// Reset and clock control
	IRQ_RCC = 4

	// External interrupt/event controller
	IRQ_EXTI0_1 = 5

	// External interrupt/event controller
	IRQ_EXTI2_3 = 6

	// External interrupt/event controller
	IRQ_EXTI4_15 = 7

	// DMA controller
	IRQ_DMA_Channel1 = 9

	// DMA controller
	IRQ_DMA_Channel2_3 = 10

	// DMAMUX
	IRQ_DMA_Channel4_5_6_7 = 11

	// Analog to Digital Converter instance 1
	IRQ_ADC_COMP = 12

	// Advanced-timers
	IRQ_TIM1_BRK_UP_TRG_COM = 13

	// Advanced-timers
	IRQ_TIM1_CC = 14

	// General-purpose-timers
	IRQ_TIM2 = 15

	// General-purpose-timers
	IRQ_TIM3 = 16

	// General purpose timers
	IRQ_TIM14 = 19

	// General purpose timers
	IRQ_TIM16 = 21

	IRQ_TIM17 = 22

	// Inter-integrated circuit
	IRQ_I2C1 = 23

	IRQ_I2C2 = 24

	// Serial peripheral interface/Inter-IC sound
	IRQ_SPI1 = 25

	IRQ_SPI2 = 26

	// Universal synchronous asynchronous receiver transmitter
	IRQ_USART1 = 27

	IRQ_USART2 = 28

	// Universal synchronous asynchronous receiver transmitter
	IRQ_USART3_USART4_LPUART1 = 29

	// Cyclic redundancy check calculation unit
	IRQ_CEC = 30

	// Advanced encryption standard hardware accelerator 1
	IRQ_AES_RNG = 31

	// Highest interrupt number on this device.
	IRQ_max = 31
)

// Map interrupt numbers to function names.
// These aren't real calls, they're removed by the compiler.
var (
	_ = interrupt.Register(IRQ_WWDG, "WWDG_IRQHandler")
	_ = interrupt.Register(IRQ_PVD, "PVD_IRQHandler")
	_ = interrupt.Register(IRQ_RTC_TAMP, "RTC_TAMP_IRQHandler")
	_ = interrupt.Register(IRQ_FLASH, "FLASH_IRQHandler")
	_ = interrupt.Register(IRQ_RCC, "RCC_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI0_1, "EXTI0_1_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI2_3, "EXTI2_3_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI4_15, "EXTI4_15_IRQHandler")
	_ = interrupt.Register(IRQ_DMA_Channel1, "DMA_Channel1_IRQHandler")
	_ = interrupt.Register(IRQ_DMA_Channel2_3, "DMA_Channel2_3_IRQHandler")
	_ = interrupt.Register(IRQ_DMA_Channel4_5_6_7, "DMA_Channel4_5_6_7_IRQHandler")
	_ = interrupt.Register(IRQ_ADC_COMP, "ADC_COMP_IRQHandler")
	_ = interrupt.Register(IRQ_TIM1_BRK_UP_TRG_COM, "TIM1_BRK_UP_TRG_COM_IRQHandler")
	_ = interrupt.Register(IRQ_TIM1_CC, "TIM1_CC_IRQHandler")
	_ = interrupt.Register(IRQ_TIM2, "TIM2_IRQHandler")
	_ = interrupt.Register(IRQ_TIM3, "TIM3_IRQHandler")
	_ = interrupt.Register(IRQ_TIM14, "TIM14_IRQHandler")
	_ = interrupt.Register(IRQ_TIM16, "TIM16_IRQHandler")
	_ = interrupt.Register(IRQ_TIM17, "TIM17_IRQHandler")
	_ = interrupt.Register(IRQ_I2C1, "I2C1_IRQHandler")
	_ = interrupt.Register(IRQ_I2C2, "I2C2_IRQHandler")
	_ = interrupt.Register(IRQ_SPI1, "SPI1_IRQHandler")
	_ = interrupt.Register(IRQ_SPI2, "SPI2_IRQHandler")
	_ = interrupt.Register(IRQ_USART1, "USART1_IRQHandler")
	_ = interrupt.Register(IRQ_USART2, "USART2_IRQHandler")
	_ = interrupt.Register(IRQ_USART3_USART4_LPUART1, "USART3_USART4_LPUART1_IRQHandler")
	_ = interrupt.Register(IRQ_CEC, "CEC_IRQHandler")
	_ = interrupt.Register(IRQ_AES_RNG, "AES_RNG_IRQHandler")
)

// Peripherals.
var (
	// Independent watchdog
	IWDG = (*IWDG_Type)(unsafe.Pointer(uintptr(0x40003000)))

	// System window watchdog
	WWDG = (*WWDG_Type)(unsafe.Pointer(uintptr(0x40002c00)))

	// Flash
	FLASH = (*Flash_Type)(unsafe.Pointer(uintptr(0x40022000)))

	// Reset and clock control
	RCC = (*RCC_Type)(unsafe.Pointer(uintptr(0x40021000)))

	// Power control
	PWR = (*PWR_Type)(unsafe.Pointer(uintptr(0x40007000)))

	// DMA controller
	DMA = (*DMA_Type)(unsafe.Pointer(uintptr(0x40020000)))

	// DMAMUX
	DMAMUX = (*DMAMUX_Type)(unsafe.Pointer(uintptr(0x40020800)))

	// General-purpose I/Os
	GPIOA = (*GPIO_Type)(unsafe.Pointer(uintptr(0x50000000)))

	// General-purpose I/Os
	GPIOB = (*GPIO_Type)(unsafe.Pointer(uintptr(0x50000400)))

	// Advanced encryption standard hardware accelerator 1
	AES = (*AES_Type)(unsafe.Pointer(uintptr(0x40026000)))

	// Random number generator
	RNG = (*RNG_Type)(unsafe.Pointer(uintptr(0x40025000)))

	// Cyclic redundancy check calculation unit
	CRC = (*CRC_Type)(unsafe.Pointer(uintptr(0x40023000)))

	// External interrupt/event controller
	EXTI = (*EXTI_Type)(unsafe.Pointer(uintptr(0x40021800)))

	// General purpose timers
	TIM16 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014400)))

	// Universal synchronous asynchronous receiver transmitter
	USART1 = (*USART_Type)(unsafe.Pointer(uintptr(0x40013800)))

	// Serial peripheral interface/Inter-IC sound
	SPI1 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40013000)))

	// Advanced-timers
	TIM1 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40012c00)))

	// Analog to Digital Converter instance 1
	ADC = (*ADC_Type)(unsafe.Pointer(uintptr(0x40012400)))

	// System configuration controller
	SYSCFG = (*SYSCFG_Type)(unsafe.Pointer(uintptr(0x40010000)))

	// Tamper and backup registers
	TAMP = (*TAMP_Type)(unsafe.Pointer(uintptr(0x4000b000)))

	// Low power timer
	LPTIM1 = (*LPTIM_Type)(unsafe.Pointer(uintptr(0x40007c00)))

	// Universal synchronous asynchronous receiver transmitter
	LPUART = (*USART_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// Inter-integrated circuit
	I2C1 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005400)))

	// Real-time clock
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x40002800)))

	// General purpose timers
	TIM14 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40002000)))

	// General-purpose-timers
	TIM2 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// Nested Vectored Interrupt Controller
	NVIC = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000e100)))

	// Memory protection unit
	MPU = (*MPU_Type)(unsafe.Pointer(uintptr(0xe000ed90)))

	// SysTick timer
	STK = (*STK_Type)(unsafe.Pointer(uintptr(0xe000e010)))

	// System control block
	SCB = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000ed00)))

	// System configuration controller
	VREFBUF = (*VREFBUF_Type)(unsafe.Pointer(uintptr(0x40010030)))

	// MCU debug component
	DBG = (*DBG_Type)(unsafe.Pointer(uintptr(0x40015800)))

	// Nested vectored interrupt controller
	NVIC_STIR = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000ef00)))

	// System control block ACTLR
	SCB_ACTRL = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000e008)))

	// Floating point unit CPACR
	FPU_CPACR = (*FPU_Type)(unsafe.Pointer(uintptr(0xe000ed88)))

	// Floting point unit
	FPU = (*FPU_Type)(unsafe.Pointer(uintptr(0xe000ef34)))

	// System configuration controller
	SYSCFG_ITLINE = (*SYSCFG_Type)(unsafe.Pointer(uintptr(0x40010080)))

	// General-purpose I/Os
	GPIOC = (*GPIO_Type)(unsafe.Pointer(uintptr(0x50000800)))

	// General-purpose I/Os
	GPIOD = (*GPIO_Type)(unsafe.Pointer(uintptr(0x50000c00)))

	// General-purpose I/Os
	GPIOF = (*GPIO_Type)(unsafe.Pointer(uintptr(0x50001400)))

	// General purpose timers
	TIM17 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014800)))

	// Universal synchronous asynchronous receiver transmitter
	USART2 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004400)))

	// Serial peripheral interface/Inter-IC sound
	SPI2 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003800)))

	// Low power timer
	LPTIM2 = (*LPTIM_Type)(unsafe.Pointer(uintptr(0x40009400)))

	// Inter-integrated circuit
	I2C2 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005800)))

	// General-purpose-timers
	TIM3 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000400)))
)

// Independent watchdog
type IWDG_Type struct {
	KR   volatile.Register32 // 0x0
	PR   volatile.Register32 // 0x4
	RLR  volatile.Register32 // 0x8
	SR   volatile.Register32 // 0xC
	WINR volatile.Register32 // 0x10
}

// System window watchdog
type WWDG_Type struct {
	CR  volatile.Register32 // 0x0
	CFR volatile.Register32 // 0x4
	SR  volatile.Register32 // 0x8
}

// Flash
type Flash_Type struct {
	ACR       volatile.Register32 // 0x0
	_         [4]byte
	KEYR      volatile.Register32 // 0x8
	OPTKEYR   volatile.Register32 // 0xC
	SR        volatile.Register32 // 0x10
	CR        volatile.Register32 // 0x14
	ECCR      volatile.Register32 // 0x18
	_         [4]byte
	OPTR      volatile.Register32 // 0x20
	PCROP1ASR volatile.Register32 // 0x24
	PCROP1AER volatile.Register32 // 0x28
	WRP1AR    volatile.Register32 // 0x2C
	WRP1BR    volatile.Register32 // 0x30
	PCROP1BSR volatile.Register32 // 0x34
	PCROP1BER volatile.Register32 // 0x38
	_         [68]byte
	SECR      volatile.Register32 // 0x80
}

// Reset and clock control
type RCC_Type struct {
	CR         volatile.Register32 // 0x0
	ICSCR      volatile.Register32 // 0x4
	CFGR       volatile.Register32 // 0x8
	PLLSYSCFGR volatile.Register32 // 0xC
	_          [8]byte
	CIER       volatile.Register32 // 0x18
	CIFR       volatile.Register32 // 0x1C
	CICR       volatile.Register32 // 0x20
	IOPRSTR    volatile.Register32 // 0x24
	AHBRSTR    volatile.Register32 // 0x28
	APBRSTR1   volatile.Register32 // 0x2C
	APBRSTR2   volatile.Register32 // 0x30
	IOPENR     volatile.Register32 // 0x34
	AHBENR     volatile.Register32 // 0x38
	APBENR1    volatile.Register32 // 0x3C
	APBENR2    volatile.Register32 // 0x40
	IOPSMENR   volatile.Register32 // 0x44
	AHBSMENR   volatile.Register32 // 0x48
	APBSMENR1  volatile.Register32 // 0x4C
	APBSMENR2  volatile.Register32 // 0x50
	CCIPR      volatile.Register32 // 0x54
	_          [4]byte
	BDCR       volatile.Register32 // 0x5C
	CSR        volatile.Register32 // 0x60
}

// Power control
type PWR_Type struct {
	CR1   volatile.Register32 // 0x0
	CR2   volatile.Register32 // 0x4
	CR3   volatile.Register32 // 0x8
	CR4   volatile.Register32 // 0xC
	SR1   volatile.Register32 // 0x10
	SR2   volatile.Register32 // 0x14
	SCR   volatile.Register32 // 0x18
	_     [4]byte
	PUCRA volatile.Register32 // 0x20
	PDCRA volatile.Register32 // 0x24
	PUCRB volatile.Register32 // 0x28
	PDCRB volatile.Register32 // 0x2C
	PUCRC volatile.Register32 // 0x30
	PDCRC volatile.Register32 // 0x34
	PUCRD volatile.Register32 // 0x38
	PDCRD volatile.Register32 // 0x3C
	_     [8]byte
	PUCRF volatile.Register32 // 0x48
	PDCRF volatile.Register32 // 0x4C
}

// DMA controller
type DMA_Type struct {
	ISR  volatile.Register32 // 0x0
	IFCR volatile.Register32 // 0x4
	CH   [5]struct {
		CR   volatile.Register32
		NDTR volatile.Register32
		PAR  volatile.Register32
		MAR  volatile.Register32
		_    [4]byte
	} // 0x8
}

// DMAMUX
type DMAMUX_Type struct {
	C0CR  volatile.Register32 // 0x0
	C1CR  volatile.Register32 // 0x4
	C2CR  volatile.Register32 // 0x8
	C3CR  volatile.Register32 // 0xC
	C4CR  volatile.Register32 // 0x10
	C5CR  volatile.Register32 // 0x14
	C6CR  volatile.Register32 // 0x18
	_     [228]byte
	RG0CR volatile.Register32 // 0x100
	RG1CR volatile.Register32 // 0x104
	RG2CR volatile.Register32 // 0x108
	RG3CR volatile.Register32 // 0x10C
	_     [48]byte
	RGSR  volatile.Register32 // 0x140
	RGCFR volatile.Register32 // 0x144
}

// General-purpose I/Os
type GPIO_Type struct {
	MODER   volatile.Register32 // 0x0
	OTYPER  volatile.Register32 // 0x4
	OSPEEDR volatile.Register32 // 0x8
	PUPDR   volatile.Register32 // 0xC
	IDR     volatile.Register32 // 0x10
	ODR     volatile.Register32 // 0x14
	BSRR    volatile.Register32 // 0x18
	LCKR    volatile.Register32 // 0x1C
	AFRL    volatile.Register32 // 0x20
	AFRH    volatile.Register32 // 0x24
	BRR     volatile.Register32 // 0x28
}

// Advanced encryption standard hardware accelerator 1
type AES_Type struct {
	CR     volatile.Register32 // 0x0
	SR     volatile.Register32 // 0x4
	DINR   volatile.Register32 // 0x8
	DOUTR  volatile.Register32 // 0xC
	KEYR0  volatile.Register32 // 0x10
	KEYR1  volatile.Register32 // 0x14
	KEYR2  volatile.Register32 // 0x18
	KEYR3  volatile.Register32 // 0x1C
	IVR0   volatile.Register32 // 0x20
	IVR1   volatile.Register32 // 0x24
	IVR2   volatile.Register32 // 0x28
	IVR3   volatile.Register32 // 0x2C
	KEYR4  volatile.Register32 // 0x30
	KEYR5  volatile.Register32 // 0x34
	KEYR6  volatile.Register32 // 0x38
	KEYR7  volatile.Register32 // 0x3C
	SUSP0R volatile.Register32 // 0x40
	SUSP1R volatile.Register32 // 0x44
	SUSP2R volatile.Register32 // 0x48
	SUSP3R volatile.Register32 // 0x4C
	SUSP4R volatile.Register32 // 0x50
	SUSP5R volatile.Register32 // 0x54
	SUSP6R volatile.Register32 // 0x58
	SUSP7R volatile.Register32 // 0x5C
}

// Random number generator
type RNG_Type struct {
	CR volatile.Register32 // 0x0
	SR volatile.Register32 // 0x4
	DR volatile.Register32 // 0x8
}

// Cyclic redundancy check calculation unit
type CRC_Type struct {
	DR   volatile.Register32 // 0x0
	IDR  volatile.Register32 // 0x4
	CR   volatile.Register32 // 0x8
	_    [4]byte
	INIT volatile.Register32 // 0x10
	POL  volatile.Register32 // 0x14
}

// External interrupt/event controller
type EXTI_Type struct {
	RTSR1   volatile.Register32 // 0x0
	FTSR1   volatile.Register32 // 0x4
	SWIER1  volatile.Register32 // 0x8
	RPR1    volatile.Register32 // 0xC
	FPR1    volatile.Register32 // 0x10
	_       [76]byte
	EXTICR1 volatile.Register32 // 0x60
	EXTICR2 volatile.Register32 // 0x64
	EXTICR3 volatile.Register32 // 0x68
	EXTICR4 volatile.Register32 // 0x6C
	_       [16]byte
	IMR1    volatile.Register32 // 0x80
	EMR1    volatile.Register32 // 0x84
}

// General purpose timers
type TIM_Type struct {
	CR1          volatile.Register32 // 0x0
	CR2          volatile.Register32 // 0x4
	_            [4]byte
	DIER         volatile.Register32 // 0xC
	SR           volatile.Register32 // 0x10
	EGR          volatile.Register32 // 0x14
	CCMR1_Output volatile.Register32 // 0x18
	_            [4]byte
	CCER         volatile.Register32 // 0x20
	CNT          volatile.Register32 // 0x24
	PSC          volatile.Register32 // 0x28
	ARR          volatile.Register32 // 0x2C
	RCR          volatile.Register32 // 0x30
	CCR1         volatile.Register32 // 0x34
	_            [12]byte
	BDTR         volatile.Register32 // 0x44
	DCR          volatile.Register32 // 0x48
	DMAR         volatile.Register32 // 0x4C
	_            [16]byte
	AF1          volatile.Register32 // 0x60
	_            [4]byte
	TISEL        volatile.Register32 // 0x68
}

// Universal synchronous asynchronous receiver transmitter
type USART_Type struct {
	CR1   volatile.Register32 // 0x0
	CR2   volatile.Register32 // 0x4
	CR3   volatile.Register32 // 0x8
	BRR   volatile.Register32 // 0xC
	GTPR  volatile.Register32 // 0x10
	RTOR  volatile.Register32 // 0x14
	RQR   volatile.Register32 // 0x18
	ISR   volatile.Register32 // 0x1C
	ICR   volatile.Register32 // 0x20
	RDR   volatile.Register32 // 0x24
	TDR   volatile.Register32 // 0x28
	PRESC volatile.Register32 // 0x2C
}

// Serial peripheral interface/Inter-IC sound
type SPI_Type struct {
	CR1     volatile.Register32 // 0x0
	CR2     volatile.Register32 // 0x4
	SR      volatile.Register32 // 0x8
	DR      volatile.Register32 // 0xC
	CRCPR   volatile.Register32 // 0x10
	RXCRCR  volatile.Register32 // 0x14
	TXCRCR  volatile.Register32 // 0x18
	I2SCFGR volatile.Register32 // 0x1C
	I2SPR   volatile.Register32 // 0x20
}

// Analog to Digital Converter instance 1
type ADC_Type struct {
	ISR     volatile.Register32 // 0x0
	IER     volatile.Register32 // 0x4
	CR      volatile.Register32 // 0x8
	CFGR1   volatile.Register32 // 0xC
	CFGR2   volatile.Register32 // 0x10
	SMPR    volatile.Register32 // 0x14
	_       [8]byte
	AWD1TR  volatile.Register32 // 0x20
	AWD2TR  volatile.Register32 // 0x24
	CHSELR  volatile.Register32 // 0x28
	AWD3TR  volatile.Register32 // 0x2C
	_       [16]byte
	DR      volatile.Register32 // 0x40
	_       [92]byte
	AWD2CR  volatile.Register32 // 0xA0
	AWD3CR  volatile.Register32 // 0xA4
	_       [12]byte
	CALFACT volatile.Register32 // 0xB4
	_       [592]byte
	CCR     volatile.Register32 // 0x308
}

// System configuration controller
type SYSCFG_Type struct {
	CFGR1 volatile.Register32 // 0x0
	_     [20]byte
	CFGR2 volatile.Register32 // 0x18
}

// Tamper and backup registers
type TAMP_Type struct {
	CR1   volatile.Register32 // 0x0
	CR2   volatile.Register32 // 0x4
	_     [4]byte
	FLTCR volatile.Register32 // 0xC
	_     [28]byte
	IER   volatile.Register32 // 0x2C
	SR    volatile.Register32 // 0x30
	MISR  volatile.Register32 // 0x34
	_     [4]byte
	SCR   volatile.Register32 // 0x3C
	_     [192]byte
	BKP0R volatile.Register32 // 0x100
	BKP1R volatile.Register32 // 0x104
	BKP2R volatile.Register32 // 0x108
	BKP3R volatile.Register32 // 0x10C
	BKP4R volatile.Register32 // 0x110
}

// Low power timer
type LPTIM_Type struct {
	ISR   volatile.Register32 // 0x0
	ICR   volatile.Register32 // 0x4
	IER   volatile.Register32 // 0x8
	CFGR  volatile.Register32 // 0xC
	CR    volatile.Register32 // 0x10
	CMP   volatile.Register32 // 0x14
	ARR   volatile.Register32 // 0x18
	CNT   volatile.Register32 // 0x1C
	_     [4]byte
	CFGR2 volatile.Register32 // 0x24
}

// Inter-integrated circuit
type I2C_Type struct {
	CR1      volatile.Register32 // 0x0
	CR2      volatile.Register32 // 0x4
	OAR1     volatile.Register32 // 0x8
	OAR2     volatile.Register32 // 0xC
	TIMINGR  volatile.Register32 // 0x10
	TIMEOUTR volatile.Register32 // 0x14
	ISR      volatile.Register32 // 0x18
	ICR      volatile.Register32 // 0x1C
	PECR     volatile.Register32 // 0x20
	RXDR     volatile.Register32 // 0x24
	TXDR     volatile.Register32 // 0x28
}

// Real-time clock
type RTC_Type struct {
	TR       volatile.Register32 // 0x0
	DR       volatile.Register32 // 0x4
	SSR      volatile.Register32 // 0x8
	ICSR     volatile.Register32 // 0xC
	PRER     volatile.Register32 // 0x10
	WUTR     volatile.Register32 // 0x14
	CR       volatile.Register32 // 0x18
	_        [8]byte
	WPR      volatile.Register32 // 0x24
	CALR     volatile.Register32 // 0x28
	SHIFTR   volatile.Register32 // 0x2C
	TSTR     volatile.Register32 // 0x30
	TSDR     volatile.Register32 // 0x34
	TSSSR    volatile.Register32 // 0x38
	_        [4]byte
	ALRMAR   volatile.Register32 // 0x40
	ALRMASSR volatile.Register32 // 0x44
	ALRMBR   volatile.Register32 // 0x48
	ALRMBSSR volatile.Register32 // 0x4C
	SR       volatile.Register32 // 0x50
	MISR     volatile.Register32 // 0x54
	_        [4]byte
	SCR      volatile.Register32 // 0x5C
}

// Nested Vectored Interrupt Controller
type NVIC_Type struct {
	ISER volatile.Register32 // 0x0
	_    [124]byte
	ICER volatile.Register32 // 0x80
	_    [124]byte
	ISPR volatile.Register32 // 0x100
	_    [124]byte
	ICPR volatile.Register32 // 0x180
	_    [380]byte
	IPR0 volatile.Register32 // 0x300
	IPR1 volatile.Register32 // 0x304
	IPR2 volatile.Register32 // 0x308
	IPR3 volatile.Register32 // 0x30C
	IPR4 volatile.Register32 // 0x310
	IPR5 volatile.Register32 // 0x314
	IPR6 volatile.Register32 // 0x318
	IPR7 volatile.Register32 // 0x31C
	IPR8 volatile.Register32 // 0x320
}

// Memory protection unit
type MPU_Type struct {
	MPU_TYPER volatile.Register32 // 0x0
	MPU_CTRL  volatile.Register32 // 0x4
	MPU_RNR   volatile.Register32 // 0x8
	MPU_RBAR  volatile.Register32 // 0xC
	MPU_RASR  volatile.Register32 // 0x10
}

// SysTick timer
type STK_Type struct {
	CSR   volatile.Register32 // 0x0
	RVR   volatile.Register32 // 0x4
	CVR   volatile.Register32 // 0x8
	CALIB volatile.Register32 // 0xC
}

// System control block
type SCB_Type struct {
	CPUID volatile.Register32 // 0x0
	ICSR  volatile.Register32 // 0x4
	VTOR  volatile.Register32 // 0x8
	AIRCR volatile.Register32 // 0xC
	SCR   volatile.Register32 // 0x10
	CCR   volatile.Register32 // 0x14
	_     [4]byte
	SHPR2 volatile.Register32 // 0x1C
	SHPR3 volatile.Register32 // 0x20
}

// System configuration controller
type VREFBUF_Type struct {
	CSR volatile.Register32 // 0x0
	CCR volatile.Register32 // 0x4
}

// MCU debug component
type DBG_Type struct {
	IDCODE  volatile.Register32 // 0x0
	CR      volatile.Register32 // 0x4
	APB_FZ1 volatile.Register32 // 0x8
	APB_FZ2 volatile.Register32 // 0xC
}

// Floating point unit CPACR
type FPU_Type struct {
	CPACR volatile.Register32 // 0x0
}

// Bitfields for IWDG: Independent watchdog
const (
	// KR: Key register
	// Position of KEY field.
	IWDG_KR_KEY_Pos = 0x0
	// Bit mask of KEY field.
	IWDG_KR_KEY_Msk = 0xffff

	// PR: Prescaler register
	// Position of PR field.
	IWDG_PR_PR_Pos = 0x0
	// Bit mask of PR field.
	IWDG_PR_PR_Msk = 0x7

	// RLR: Reload register
	// Position of RL field.
	IWDG_RLR_RL_Pos = 0x0
	// Bit mask of RL field.
	IWDG_RLR_RL_Msk = 0xfff

	// SR: Status register
	// Position of WVU field.
	IWDG_SR_WVU_Pos = 0x2
	// Bit mask of WVU field.
	IWDG_SR_WVU_Msk = 0x4
	// Bit WVU.
	IWDG_SR_WVU = 0x4
	// Position of RVU field.
	IWDG_SR_RVU_Pos = 0x1
	// Bit mask of RVU field.
	IWDG_SR_RVU_Msk = 0x2
	// Bit RVU.
	IWDG_SR_RVU = 0x2
	// Position of PVU field.
	IWDG_SR_PVU_Pos = 0x0
	// Bit mask of PVU field.
	IWDG_SR_PVU_Msk = 0x1
	// Bit PVU.
	IWDG_SR_PVU = 0x1

	// WINR: Window register
	// Position of WIN field.
	IWDG_WINR_WIN_Pos = 0x0
	// Bit mask of WIN field.
	IWDG_WINR_WIN_Msk = 0xfff
)

// Bitfields for WWDG: System window watchdog
const (
	// CR: Control register
	// Position of WDGA field.
	WWDG_CR_WDGA_Pos = 0x7
	// Bit mask of WDGA field.
	WWDG_CR_WDGA_Msk = 0x80
	// Bit WDGA.
	WWDG_CR_WDGA = 0x80
	// Position of T field.
	WWDG_CR_T_Pos = 0x0
	// Bit mask of T field.
	WWDG_CR_T_Msk = 0x7f

	// CFR: Configuration register
	// Position of WDGTB field.
	WWDG_CFR_WDGTB_Pos = 0xb
	// Bit mask of WDGTB field.
	WWDG_CFR_WDGTB_Msk = 0x3800
	// Position of EWI field.
	WWDG_CFR_EWI_Pos = 0x9
	// Bit mask of EWI field.
	WWDG_CFR_EWI_Msk = 0x200
	// Bit EWI.
	WWDG_CFR_EWI = 0x200
	// Position of W field.
	WWDG_CFR_W_Pos = 0x0
	// Bit mask of W field.
	WWDG_CFR_W_Msk = 0x7f

	// SR: Status register
	// Position of EWIF field.
	WWDG_SR_EWIF_Pos = 0x0
	// Bit mask of EWIF field.
	WWDG_SR_EWIF_Msk = 0x1
	// Bit EWIF.
	WWDG_SR_EWIF = 0x1
)

// Bitfields for FLASH: Flash
const (
	// ACR: Access control register
	// Position of LATENCY field.
	Flash_ACR_LATENCY_Pos = 0x0
	// Bit mask of LATENCY field.
	Flash_ACR_LATENCY_Msk = 0x7
	// Position of PRFTEN field.
	Flash_ACR_PRFTEN_Pos = 0x8
	// Bit mask of PRFTEN field.
	Flash_ACR_PRFTEN_Msk = 0x100
	// Bit PRFTEN.
	Flash_ACR_PRFTEN = 0x100
	// Position of ICEN field.
	Flash_ACR_ICEN_Pos = 0x9
	// Bit mask of ICEN field.
	Flash_ACR_ICEN_Msk = 0x200
	// Bit ICEN.
	Flash_ACR_ICEN = 0x200
	// Position of ICRST field.
	Flash_ACR_ICRST_Pos = 0xb
	// Bit mask of ICRST field.
	Flash_ACR_ICRST_Msk = 0x800
	// Bit ICRST.
	Flash_ACR_ICRST = 0x800
	// Position of EMPTY field.
	Flash_ACR_EMPTY_Pos = 0x10
	// Bit mask of EMPTY field.
	Flash_ACR_EMPTY_Msk = 0x10000
	// Bit EMPTY.
	Flash_ACR_EMPTY = 0x10000
	// Position of DBG_SWEN field.
	Flash_ACR_DBG_SWEN_Pos = 0x12
	// Bit mask of DBG_SWEN field.
	Flash_ACR_DBG_SWEN_Msk = 0x40000
	// Bit DBG_SWEN.
	Flash_ACR_DBG_SWEN = 0x40000

	// KEYR: Flash key register
	// Position of KEYR field.
	Flash_KEYR_KEYR_Pos = 0x0
	// Bit mask of KEYR field.
	Flash_KEYR_KEYR_Msk = 0xffffffff

	// OPTKEYR: Option byte key register
	// Position of OPTKEYR field.
	Flash_OPTKEYR_OPTKEYR_Pos = 0x0
	// Bit mask of OPTKEYR field.
	Flash_OPTKEYR_OPTKEYR_Msk = 0xffffffff

	// SR: Status register
	// Position of EOP field.
	Flash_SR_EOP_Pos = 0x0
	// Bit mask of EOP field.
	Flash_SR_EOP_Msk = 0x1
	// Bit EOP.
	Flash_SR_EOP = 0x1
	// Position of OPERR field.
	Flash_SR_OPERR_Pos = 0x1
	// Bit mask of OPERR field.
	Flash_SR_OPERR_Msk = 0x2
	// Bit OPERR.
	Flash_SR_OPERR = 0x2
	// Position of PROGERR field.
	Flash_SR_PROGERR_Pos = 0x3
	// Bit mask of PROGERR field.
	Flash_SR_PROGERR_Msk = 0x8
	// Bit PROGERR.
	Flash_SR_PROGERR = 0x8
	// Position of WRPERR field.
	Flash_SR_WRPERR_Pos = 0x4
	// Bit mask of WRPERR field.
	Flash_SR_WRPERR_Msk = 0x10
	// Bit WRPERR.
	Flash_SR_WRPERR = 0x10
	// Position of PGAERR field.
	Flash_SR_PGAERR_Pos = 0x5
	// Bit mask of PGAERR field.
	Flash_SR_PGAERR_Msk = 0x20
	// Bit PGAERR.
	Flash_SR_PGAERR = 0x20
	// Position of SIZERR field.
	Flash_SR_SIZERR_Pos = 0x6
	// Bit mask of SIZERR field.
	Flash_SR_SIZERR_Msk = 0x40
	// Bit SIZERR.
	Flash_SR_SIZERR = 0x40
	// Position of PGSERR field.
	Flash_SR_PGSERR_Pos = 0x7
	// Bit mask of PGSERR field.
	Flash_SR_PGSERR_Msk = 0x80
	// Bit PGSERR.
	Flash_SR_PGSERR = 0x80
	// Position of MISERR field.
	Flash_SR_MISERR_Pos = 0x8
	// Bit mask of MISERR field.
	Flash_SR_MISERR_Msk = 0x100
	// Bit MISERR.
	Flash_SR_MISERR = 0x100
	// Position of FASTERR field.
	Flash_SR_FASTERR_Pos = 0x9
	// Bit mask of FASTERR field.
	Flash_SR_FASTERR_Msk = 0x200
	// Bit FASTERR.
	Flash_SR_FASTERR = 0x200
	// Position of RDERR field.
	Flash_SR_RDERR_Pos = 0xe
	// Bit mask of RDERR field.
	Flash_SR_RDERR_Msk = 0x4000
	// Bit RDERR.
	Flash_SR_RDERR = 0x4000
	// Position of OPTVERR field.
	Flash_SR_OPTVERR_Pos = 0xf
	// Bit mask of OPTVERR field.
	Flash_SR_OPTVERR_Msk = 0x8000
	// Bit OPTVERR.
	Flash_SR_OPTVERR = 0x8000
	// Position of BSY field.
	Flash_SR_BSY_Pos = 0x10
	// Bit mask of BSY field.
	Flash_SR_BSY_Msk = 0x10000
	// Bit BSY.
	Flash_SR_BSY = 0x10000
	// Position of CFGBSY field.
	Flash_SR_CFGBSY_Pos = 0x12
	// Bit mask of CFGBSY field.
	Flash_SR_CFGBSY_Msk = 0x40000
	// Bit CFGBSY.
	Flash_SR_CFGBSY = 0x40000

	// CR: Flash control register
	// Position of PG field.
	Flash_CR_PG_Pos = 0x0
	// Bit mask of PG field.
	Flash_CR_PG_Msk = 0x1
	// Bit PG.
	Flash_CR_PG = 0x1
	// Position of PER field.
	Flash_CR_PER_Pos = 0x1
	// Bit mask of PER field.
	Flash_CR_PER_Msk = 0x2
	// Bit PER.
	Flash_CR_PER = 0x2
	// Position of MER field.
	Flash_CR_MER_Pos = 0x2
	// Bit mask of MER field.
	Flash_CR_MER_Msk = 0x4
	// Bit MER.
	Flash_CR_MER = 0x4
	// Position of PNB field.
	Flash_CR_PNB_Pos = 0x3
	// Bit mask of PNB field.
	Flash_CR_PNB_Msk = 0x1f8
	// Position of STRT field.
	Flash_CR_STRT_Pos = 0x10
	// Bit mask of STRT field.
	Flash_CR_STRT_Msk = 0x10000
	// Bit STRT.
	Flash_CR_STRT = 0x10000
	// Position of OPTSTRT field.
	Flash_CR_OPTSTRT_Pos = 0x11
	// Bit mask of OPTSTRT field.
	Flash_CR_OPTSTRT_Msk = 0x20000
	// Bit OPTSTRT.
	Flash_CR_OPTSTRT = 0x20000
	// Position of FSTPG field.
	Flash_CR_FSTPG_Pos = 0x12
	// Bit mask of FSTPG field.
	Flash_CR_FSTPG_Msk = 0x40000
	// Bit FSTPG.
	Flash_CR_FSTPG = 0x40000
	// Position of EOPIE field.
	Flash_CR_EOPIE_Pos = 0x18
	// Bit mask of EOPIE field.
	Flash_CR_EOPIE_Msk = 0x1000000
	// Bit EOPIE.
	Flash_CR_EOPIE = 0x1000000
	// Position of ERRIE field.
	Flash_CR_ERRIE_Pos = 0x19
	// Bit mask of ERRIE field.
	Flash_CR_ERRIE_Msk = 0x2000000
	// Bit ERRIE.
	Flash_CR_ERRIE = 0x2000000
	// Position of RDERRIE field.
	Flash_CR_RDERRIE_Pos = 0x1a
	// Bit mask of RDERRIE field.
	Flash_CR_RDERRIE_Msk = 0x4000000
	// Bit RDERRIE.
	Flash_CR_RDERRIE = 0x4000000
	// Position of OBL_LAUNCH field.
	Flash_CR_OBL_LAUNCH_Pos = 0x1b
	// Bit mask of OBL_LAUNCH field.
	Flash_CR_OBL_LAUNCH_Msk = 0x8000000
	// Bit OBL_LAUNCH.
	Flash_CR_OBL_LAUNCH = 0x8000000
	// Position of SEC_PROT field.
	Flash_CR_SEC_PROT_Pos = 0x1c
	// Bit mask of SEC_PROT field.
	Flash_CR_SEC_PROT_Msk = 0x10000000
	// Bit SEC_PROT.
	Flash_CR_SEC_PROT = 0x10000000
	// Position of OPTLOCK field.
	Flash_CR_OPTLOCK_Pos = 0x1e
	// Bit mask of OPTLOCK field.
	Flash_CR_OPTLOCK_Msk = 0x40000000
	// Bit OPTLOCK.
	Flash_CR_OPTLOCK = 0x40000000
	// Position of LOCK field.
	Flash_CR_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Flash_CR_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Flash_CR_LOCK = 0x80000000

	// ECCR: Flash ECC register
	// Position of ADDR_ECC field.
	Flash_ECCR_ADDR_ECC_Pos = 0x0
	// Bit mask of ADDR_ECC field.
	Flash_ECCR_ADDR_ECC_Msk = 0x3fff
	// Position of SYSF_ECC field.
	Flash_ECCR_SYSF_ECC_Pos = 0x14
	// Bit mask of SYSF_ECC field.
	Flash_ECCR_SYSF_ECC_Msk = 0x100000
	// Bit SYSF_ECC.
	Flash_ECCR_SYSF_ECC = 0x100000
	// Position of ECCIE field.
	Flash_ECCR_ECCIE_Pos = 0x18
	// Bit mask of ECCIE field.
	Flash_ECCR_ECCIE_Msk = 0x1000000
	// Bit ECCIE.
	Flash_ECCR_ECCIE = 0x1000000
	// Position of ECCC field.
	Flash_ECCR_ECCC_Pos = 0x1e
	// Bit mask of ECCC field.
	Flash_ECCR_ECCC_Msk = 0x40000000
	// Bit ECCC.
	Flash_ECCR_ECCC = 0x40000000
	// Position of ECCD field.
	Flash_ECCR_ECCD_Pos = 0x1f
	// Bit mask of ECCD field.
	Flash_ECCR_ECCD_Msk = 0x80000000
	// Bit ECCD.
	Flash_ECCR_ECCD = 0x80000000

	// OPTR: Flash option register
	// Position of RDP field.
	Flash_OPTR_RDP_Pos = 0x0
	// Bit mask of RDP field.
	Flash_OPTR_RDP_Msk = 0xff
	// Position of BOREN field.
	Flash_OPTR_BOREN_Pos = 0x8
	// Bit mask of BOREN field.
	Flash_OPTR_BOREN_Msk = 0x100
	// Bit BOREN.
	Flash_OPTR_BOREN = 0x100
	// Position of BORF_LEV field.
	Flash_OPTR_BORF_LEV_Pos = 0x9
	// Bit mask of BORF_LEV field.
	Flash_OPTR_BORF_LEV_Msk = 0x600
	// Position of BORR_LEV field.
	Flash_OPTR_BORR_LEV_Pos = 0xb
	// Bit mask of BORR_LEV field.
	Flash_OPTR_BORR_LEV_Msk = 0x1800
	// Position of NRST_STOP field.
	Flash_OPTR_NRST_STOP_Pos = 0xd
	// Bit mask of NRST_STOP field.
	Flash_OPTR_NRST_STOP_Msk = 0x2000
	// Bit NRST_STOP.
	Flash_OPTR_NRST_STOP = 0x2000
	// Position of NRST_STDBY field.
	Flash_OPTR_NRST_STDBY_Pos = 0xe
	// Bit mask of NRST_STDBY field.
	Flash_OPTR_NRST_STDBY_Msk = 0x4000
	// Bit NRST_STDBY.
	Flash_OPTR_NRST_STDBY = 0x4000
	// Position of NRSTS_HDW field.
	Flash_OPTR_NRSTS_HDW_Pos = 0xf
	// Bit mask of NRSTS_HDW field.
	Flash_OPTR_NRSTS_HDW_Msk = 0x8000
	// Bit NRSTS_HDW.
	Flash_OPTR_NRSTS_HDW = 0x8000
	// Position of IDWG_SW field.
	Flash_OPTR_IDWG_SW_Pos = 0x10
	// Bit mask of IDWG_SW field.
	Flash_OPTR_IDWG_SW_Msk = 0x10000
	// Bit IDWG_SW.
	Flash_OPTR_IDWG_SW = 0x10000
	// Position of IWDG_STOP field.
	Flash_OPTR_IWDG_STOP_Pos = 0x11
	// Bit mask of IWDG_STOP field.
	Flash_OPTR_IWDG_STOP_Msk = 0x20000
	// Bit IWDG_STOP.
	Flash_OPTR_IWDG_STOP = 0x20000
	// Position of IWDG_STDBY field.
	Flash_OPTR_IWDG_STDBY_Pos = 0x12
	// Bit mask of IWDG_STDBY field.
	Flash_OPTR_IWDG_STDBY_Msk = 0x40000
	// Bit IWDG_STDBY.
	Flash_OPTR_IWDG_STDBY = 0x40000
	// Position of WWDG_SW field.
	Flash_OPTR_WWDG_SW_Pos = 0x13
	// Bit mask of WWDG_SW field.
	Flash_OPTR_WWDG_SW_Msk = 0x80000
	// Bit WWDG_SW.
	Flash_OPTR_WWDG_SW = 0x80000
	// Position of RAM_PARITY_CHECK field.
	Flash_OPTR_RAM_PARITY_CHECK_Pos = 0x16
	// Bit mask of RAM_PARITY_CHECK field.
	Flash_OPTR_RAM_PARITY_CHECK_Msk = 0x400000
	// Bit RAM_PARITY_CHECK.
	Flash_OPTR_RAM_PARITY_CHECK = 0x400000
	// Position of NBOOT_SEL field.
	Flash_OPTR_NBOOT_SEL_Pos = 0x18
	// Bit mask of NBOOT_SEL field.
	Flash_OPTR_NBOOT_SEL_Msk = 0x1000000
	// Bit NBOOT_SEL.
	Flash_OPTR_NBOOT_SEL = 0x1000000
	// Position of NBOOT1 field.
	Flash_OPTR_NBOOT1_Pos = 0x19
	// Bit mask of NBOOT1 field.
	Flash_OPTR_NBOOT1_Msk = 0x2000000
	// Bit NBOOT1.
	Flash_OPTR_NBOOT1 = 0x2000000
	// Position of NBOOT0 field.
	Flash_OPTR_NBOOT0_Pos = 0x1a
	// Bit mask of NBOOT0 field.
	Flash_OPTR_NBOOT0_Msk = 0x4000000
	// Bit NBOOT0.
	Flash_OPTR_NBOOT0 = 0x4000000
	// Position of NRST_MODE field.
	Flash_OPTR_NRST_MODE_Pos = 0x1b
	// Bit mask of NRST_MODE field.
	Flash_OPTR_NRST_MODE_Msk = 0x18000000
	// Position of IRHEN field.
	Flash_OPTR_IRHEN_Pos = 0x1d
	// Bit mask of IRHEN field.
	Flash_OPTR_IRHEN_Msk = 0x20000000
	// Bit IRHEN.
	Flash_OPTR_IRHEN = 0x20000000

	// PCROP1ASR: Flash PCROP zone A Start address register
	// Position of PCROP1A_STRT field.
	Flash_PCROP1ASR_PCROP1A_STRT_Pos = 0x0
	// Bit mask of PCROP1A_STRT field.
	Flash_PCROP1ASR_PCROP1A_STRT_Msk = 0xff

	// PCROP1AER: Flash PCROP zone A End address register
	// Position of PCROP1A_END field.
	Flash_PCROP1AER_PCROP1A_END_Pos = 0x0
	// Bit mask of PCROP1A_END field.
	Flash_PCROP1AER_PCROP1A_END_Msk = 0xff
	// Position of PCROP_RDP field.
	Flash_PCROP1AER_PCROP_RDP_Pos = 0x1f
	// Bit mask of PCROP_RDP field.
	Flash_PCROP1AER_PCROP_RDP_Msk = 0x80000000
	// Bit PCROP_RDP.
	Flash_PCROP1AER_PCROP_RDP = 0x80000000

	// WRP1AR: Flash WRP area A address register
	// Position of WRP1A_STRT field.
	Flash_WRP1AR_WRP1A_STRT_Pos = 0x0
	// Bit mask of WRP1A_STRT field.
	Flash_WRP1AR_WRP1A_STRT_Msk = 0x3f
	// Position of WRP1A_END field.
	Flash_WRP1AR_WRP1A_END_Pos = 0x10
	// Bit mask of WRP1A_END field.
	Flash_WRP1AR_WRP1A_END_Msk = 0x3f0000

	// WRP1BR: Flash WRP area B address register
	// Position of WRP1B_STRT field.
	Flash_WRP1BR_WRP1B_STRT_Pos = 0x0
	// Bit mask of WRP1B_STRT field.
	Flash_WRP1BR_WRP1B_STRT_Msk = 0x3f
	// Position of WRP1B_END field.
	Flash_WRP1BR_WRP1B_END_Pos = 0x10
	// Bit mask of WRP1B_END field.
	Flash_WRP1BR_WRP1B_END_Msk = 0x3f0000

	// PCROP1BSR: Flash PCROP zone B Start address register
	// Position of PCROP1B_STRT field.
	Flash_PCROP1BSR_PCROP1B_STRT_Pos = 0x0
	// Bit mask of PCROP1B_STRT field.
	Flash_PCROP1BSR_PCROP1B_STRT_Msk = 0xff

	// PCROP1BER: Flash PCROP zone B End address register
	// Position of PCROP1B_END field.
	Flash_PCROP1BER_PCROP1B_END_Pos = 0x0
	// Bit mask of PCROP1B_END field.
	Flash_PCROP1BER_PCROP1B_END_Msk = 0xff

	// SECR: Flash Security register
	// Position of SEC_SIZE field.
	Flash_SECR_SEC_SIZE_Pos = 0x0
	// Bit mask of SEC_SIZE field.
	Flash_SECR_SEC_SIZE_Msk = 0x7f
	// Position of BOOT_LOCK field.
	Flash_SECR_BOOT_LOCK_Pos = 0x10
	// Bit mask of BOOT_LOCK field.
	Flash_SECR_BOOT_LOCK_Msk = 0x10000
	// Bit BOOT_LOCK.
	Flash_SECR_BOOT_LOCK = 0x10000
)

// Bitfields for RCC: Reset and clock control
const (
	// CR: Clock control register
	// Position of HSION field.
	RCC_CR_HSION_Pos = 0x8
	// Bit mask of HSION field.
	RCC_CR_HSION_Msk = 0x100
	// Bit HSION.
	RCC_CR_HSION = 0x100
	// Position of HSIKERON field.
	RCC_CR_HSIKERON_Pos = 0x9
	// Bit mask of HSIKERON field.
	RCC_CR_HSIKERON_Msk = 0x200
	// Bit HSIKERON.
	RCC_CR_HSIKERON = 0x200
	// Position of HSIRDY field.
	RCC_CR_HSIRDY_Pos = 0xa
	// Bit mask of HSIRDY field.
	RCC_CR_HSIRDY_Msk = 0x400
	// Bit HSIRDY.
	RCC_CR_HSIRDY = 0x400
	// Position of HSIDIV field.
	RCC_CR_HSIDIV_Pos = 0xb
	// Bit mask of HSIDIV field.
	RCC_CR_HSIDIV_Msk = 0x3800
	// Position of HSEON field.
	RCC_CR_HSEON_Pos = 0x10
	// Bit mask of HSEON field.
	RCC_CR_HSEON_Msk = 0x10000
	// Bit HSEON.
	RCC_CR_HSEON = 0x10000
	// Position of HSERDY field.
	RCC_CR_HSERDY_Pos = 0x11
	// Bit mask of HSERDY field.
	RCC_CR_HSERDY_Msk = 0x20000
	// Bit HSERDY.
	RCC_CR_HSERDY = 0x20000
	// Position of HSEBYP field.
	RCC_CR_HSEBYP_Pos = 0x12
	// Bit mask of HSEBYP field.
	RCC_CR_HSEBYP_Msk = 0x40000
	// Bit HSEBYP.
	RCC_CR_HSEBYP = 0x40000
	// Position of CSSON field.
	RCC_CR_CSSON_Pos = 0x13
	// Bit mask of CSSON field.
	RCC_CR_CSSON_Msk = 0x80000
	// Bit CSSON.
	RCC_CR_CSSON = 0x80000
	// Position of PLLON field.
	RCC_CR_PLLON_Pos = 0x18
	// Bit mask of PLLON field.
	RCC_CR_PLLON_Msk = 0x1000000
	// Bit PLLON.
	RCC_CR_PLLON = 0x1000000
	// Position of PLLRDY field.
	RCC_CR_PLLRDY_Pos = 0x19
	// Bit mask of PLLRDY field.
	RCC_CR_PLLRDY_Msk = 0x2000000
	// Bit PLLRDY.
	RCC_CR_PLLRDY = 0x2000000

	// ICSCR: Internal clock sources calibration register
	// Position of HSICAL field.
	RCC_ICSCR_HSICAL_Pos = 0x0
	// Bit mask of HSICAL field.
	RCC_ICSCR_HSICAL_Msk = 0xff
	// Position of HSITRIM field.
	RCC_ICSCR_HSITRIM_Pos = 0x8
	// Bit mask of HSITRIM field.
	RCC_ICSCR_HSITRIM_Msk = 0x7f00

	// CFGR: Clock configuration register
	// Position of MCOPRE field.
	RCC_CFGR_MCOPRE_Pos = 0x1c
	// Bit mask of MCOPRE field.
	RCC_CFGR_MCOPRE_Msk = 0x70000000
	// Position of MCOSEL field.
	RCC_CFGR_MCOSEL_Pos = 0x18
	// Bit mask of MCOSEL field.
	RCC_CFGR_MCOSEL_Msk = 0x7000000
	// Position of PPRE field.
	RCC_CFGR_PPRE_Pos = 0xc
	// Bit mask of PPRE field.
	RCC_CFGR_PPRE_Msk = 0x7000
	// Position of HPRE field.
	RCC_CFGR_HPRE_Pos = 0x8
	// Bit mask of HPRE field.
	RCC_CFGR_HPRE_Msk = 0xf00
	// Position of SWS field.
	RCC_CFGR_SWS_Pos = 0x3
	// Bit mask of SWS field.
	RCC_CFGR_SWS_Msk = 0x38
	// Position of SW field.
	RCC_CFGR_SW_Pos = 0x0
	// Bit mask of SW field.
	RCC_CFGR_SW_Msk = 0x7

	// PLLSYSCFGR: PLL configuration register
	// Position of PLLSRC field.
	RCC_PLLSYSCFGR_PLLSRC_Pos = 0x0
	// Bit mask of PLLSRC field.
	RCC_PLLSYSCFGR_PLLSRC_Msk = 0x3
	// Position of PLLM field.
	RCC_PLLSYSCFGR_PLLM_Pos = 0x4
	// Bit mask of PLLM field.
	RCC_PLLSYSCFGR_PLLM_Msk = 0x70
	// Position of PLLN field.
	RCC_PLLSYSCFGR_PLLN_Pos = 0x8
	// Bit mask of PLLN field.
	RCC_PLLSYSCFGR_PLLN_Msk = 0x7f00
	// Position of PLLPEN field.
	RCC_PLLSYSCFGR_PLLPEN_Pos = 0x10
	// Bit mask of PLLPEN field.
	RCC_PLLSYSCFGR_PLLPEN_Msk = 0x10000
	// Bit PLLPEN.
	RCC_PLLSYSCFGR_PLLPEN = 0x10000
	// Position of PLLP field.
	RCC_PLLSYSCFGR_PLLP_Pos = 0x11
	// Bit mask of PLLP field.
	RCC_PLLSYSCFGR_PLLP_Msk = 0x3e0000
	// Position of PLLQEN field.
	RCC_PLLSYSCFGR_PLLQEN_Pos = 0x18
	// Bit mask of PLLQEN field.
	RCC_PLLSYSCFGR_PLLQEN_Msk = 0x1000000
	// Bit PLLQEN.
	RCC_PLLSYSCFGR_PLLQEN = 0x1000000
	// Position of PLLQ field.
	RCC_PLLSYSCFGR_PLLQ_Pos = 0x19
	// Bit mask of PLLQ field.
	RCC_PLLSYSCFGR_PLLQ_Msk = 0xe000000
	// Position of PLLREN field.
	RCC_PLLSYSCFGR_PLLREN_Pos = 0x1c
	// Bit mask of PLLREN field.
	RCC_PLLSYSCFGR_PLLREN_Msk = 0x10000000
	// Bit PLLREN.
	RCC_PLLSYSCFGR_PLLREN = 0x10000000
	// Position of PLLR field.
	RCC_PLLSYSCFGR_PLLR_Pos = 0x1d
	// Bit mask of PLLR field.
	RCC_PLLSYSCFGR_PLLR_Msk = 0xe0000000

	// CIER: Clock interrupt enable register
	// Position of LSIRDYIE field.
	RCC_CIER_LSIRDYIE_Pos = 0x0
	// Bit mask of LSIRDYIE field.
	RCC_CIER_LSIRDYIE_Msk = 0x1
	// Bit LSIRDYIE.
	RCC_CIER_LSIRDYIE = 0x1
	// Position of LSERDYIE field.
	RCC_CIER_LSERDYIE_Pos = 0x1
	// Bit mask of LSERDYIE field.
	RCC_CIER_LSERDYIE_Msk = 0x2
	// Bit LSERDYIE.
	RCC_CIER_LSERDYIE = 0x2
	// Position of HSIRDYIE field.
	RCC_CIER_HSIRDYIE_Pos = 0x3
	// Bit mask of HSIRDYIE field.
	RCC_CIER_HSIRDYIE_Msk = 0x8
	// Bit HSIRDYIE.
	RCC_CIER_HSIRDYIE = 0x8
	// Position of HSERDYIE field.
	RCC_CIER_HSERDYIE_Pos = 0x4
	// Bit mask of HSERDYIE field.
	RCC_CIER_HSERDYIE_Msk = 0x10
	// Bit HSERDYIE.
	RCC_CIER_HSERDYIE = 0x10
	// Position of PLLSYSRDYIE field.
	RCC_CIER_PLLSYSRDYIE_Pos = 0x5
	// Bit mask of PLLSYSRDYIE field.
	RCC_CIER_PLLSYSRDYIE_Msk = 0x20
	// Bit PLLSYSRDYIE.
	RCC_CIER_PLLSYSRDYIE = 0x20

	// CIFR: Clock interrupt flag register
	// Position of LSIRDYF field.
	RCC_CIFR_LSIRDYF_Pos = 0x0
	// Bit mask of LSIRDYF field.
	RCC_CIFR_LSIRDYF_Msk = 0x1
	// Bit LSIRDYF.
	RCC_CIFR_LSIRDYF = 0x1
	// Position of LSERDYF field.
	RCC_CIFR_LSERDYF_Pos = 0x1
	// Bit mask of LSERDYF field.
	RCC_CIFR_LSERDYF_Msk = 0x2
	// Bit LSERDYF.
	RCC_CIFR_LSERDYF = 0x2
	// Position of HSIRDYF field.
	RCC_CIFR_HSIRDYF_Pos = 0x3
	// Bit mask of HSIRDYF field.
	RCC_CIFR_HSIRDYF_Msk = 0x8
	// Bit HSIRDYF.
	RCC_CIFR_HSIRDYF = 0x8
	// Position of HSERDYF field.
	RCC_CIFR_HSERDYF_Pos = 0x4
	// Bit mask of HSERDYF field.
	RCC_CIFR_HSERDYF_Msk = 0x10
	// Bit HSERDYF.
	RCC_CIFR_HSERDYF = 0x10
	// Position of PLLSYSRDYF field.
	RCC_CIFR_PLLSYSRDYF_Pos = 0x5
	// Bit mask of PLLSYSRDYF field.
	RCC_CIFR_PLLSYSRDYF_Msk = 0x20
	// Bit PLLSYSRDYF.
	RCC_CIFR_PLLSYSRDYF = 0x20
	// Position of CSSF field.
	RCC_CIFR_CSSF_Pos = 0x8
	// Bit mask of CSSF field.
	RCC_CIFR_CSSF_Msk = 0x100
	// Bit CSSF.
	RCC_CIFR_CSSF = 0x100
	// Position of LSECSSF field.
	RCC_CIFR_LSECSSF_Pos = 0x9
	// Bit mask of LSECSSF field.
	RCC_CIFR_LSECSSF_Msk = 0x200
	// Bit LSECSSF.
	RCC_CIFR_LSECSSF = 0x200

	// CICR: Clock interrupt clear register
	// Position of LSIRDYC field.
	RCC_CICR_LSIRDYC_Pos = 0x0
	// Bit mask of LSIRDYC field.
	RCC_CICR_LSIRDYC_Msk = 0x1
	// Bit LSIRDYC.
	RCC_CICR_LSIRDYC = 0x1
	// Position of LSERDYC field.
	RCC_CICR_LSERDYC_Pos = 0x1
	// Bit mask of LSERDYC field.
	RCC_CICR_LSERDYC_Msk = 0x2
	// Bit LSERDYC.
	RCC_CICR_LSERDYC = 0x2
	// Position of HSIRDYC field.
	RCC_CICR_HSIRDYC_Pos = 0x3
	// Bit mask of HSIRDYC field.
	RCC_CICR_HSIRDYC_Msk = 0x8
	// Bit HSIRDYC.
	RCC_CICR_HSIRDYC = 0x8
	// Position of HSERDYC field.
	RCC_CICR_HSERDYC_Pos = 0x4
	// Bit mask of HSERDYC field.
	RCC_CICR_HSERDYC_Msk = 0x10
	// Bit HSERDYC.
	RCC_CICR_HSERDYC = 0x10
	// Position of PLLSYSRDYC field.
	RCC_CICR_PLLSYSRDYC_Pos = 0x5
	// Bit mask of PLLSYSRDYC field.
	RCC_CICR_PLLSYSRDYC_Msk = 0x20
	// Bit PLLSYSRDYC.
	RCC_CICR_PLLSYSRDYC = 0x20
	// Position of CSSC field.
	RCC_CICR_CSSC_Pos = 0x8
	// Bit mask of CSSC field.
	RCC_CICR_CSSC_Msk = 0x100
	// Bit CSSC.
	RCC_CICR_CSSC = 0x100
	// Position of LSECSSC field.
	RCC_CICR_LSECSSC_Pos = 0x9
	// Bit mask of LSECSSC field.
	RCC_CICR_LSECSSC_Msk = 0x200
	// Bit LSECSSC.
	RCC_CICR_LSECSSC = 0x200

	// IOPRSTR: GPIO reset register
	// Position of IOPARST field.
	RCC_IOPRSTR_IOPARST_Pos = 0x0
	// Bit mask of IOPARST field.
	RCC_IOPRSTR_IOPARST_Msk = 0x1
	// Bit IOPARST.
	RCC_IOPRSTR_IOPARST = 0x1
	// Position of IOPBRST field.
	RCC_IOPRSTR_IOPBRST_Pos = 0x1
	// Bit mask of IOPBRST field.
	RCC_IOPRSTR_IOPBRST_Msk = 0x2
	// Bit IOPBRST.
	RCC_IOPRSTR_IOPBRST = 0x2
	// Position of IOPCRST field.
	RCC_IOPRSTR_IOPCRST_Pos = 0x2
	// Bit mask of IOPCRST field.
	RCC_IOPRSTR_IOPCRST_Msk = 0x4
	// Bit IOPCRST.
	RCC_IOPRSTR_IOPCRST = 0x4
	// Position of IOPDRST field.
	RCC_IOPRSTR_IOPDRST_Pos = 0x3
	// Bit mask of IOPDRST field.
	RCC_IOPRSTR_IOPDRST_Msk = 0x8
	// Bit IOPDRST.
	RCC_IOPRSTR_IOPDRST = 0x8
	// Position of IOPFRST field.
	RCC_IOPRSTR_IOPFRST_Pos = 0x5
	// Bit mask of IOPFRST field.
	RCC_IOPRSTR_IOPFRST_Msk = 0x20
	// Bit IOPFRST.
	RCC_IOPRSTR_IOPFRST = 0x20

	// AHBRSTR: AHB peripheral reset register
	// Position of DMARST field.
	RCC_AHBRSTR_DMARST_Pos = 0x0
	// Bit mask of DMARST field.
	RCC_AHBRSTR_DMARST_Msk = 0x1
	// Bit DMARST.
	RCC_AHBRSTR_DMARST = 0x1
	// Position of FLASHRST field.
	RCC_AHBRSTR_FLASHRST_Pos = 0x8
	// Bit mask of FLASHRST field.
	RCC_AHBRSTR_FLASHRST_Msk = 0x100
	// Bit FLASHRST.
	RCC_AHBRSTR_FLASHRST = 0x100
	// Position of CRCRST field.
	RCC_AHBRSTR_CRCRST_Pos = 0xc
	// Bit mask of CRCRST field.
	RCC_AHBRSTR_CRCRST_Msk = 0x1000
	// Bit CRCRST.
	RCC_AHBRSTR_CRCRST = 0x1000
	// Position of AESRST field.
	RCC_AHBRSTR_AESRST_Pos = 0x10
	// Bit mask of AESRST field.
	RCC_AHBRSTR_AESRST_Msk = 0x10000
	// Bit AESRST.
	RCC_AHBRSTR_AESRST = 0x10000
	// Position of RNGRST field.
	RCC_AHBRSTR_RNGRST_Pos = 0x12
	// Bit mask of RNGRST field.
	RCC_AHBRSTR_RNGRST_Msk = 0x40000
	// Bit RNGRST.
	RCC_AHBRSTR_RNGRST = 0x40000

	// APBRSTR1: APB peripheral reset register 1
	// Position of TIM2RST field.
	RCC_APBRSTR1_TIM2RST_Pos = 0x0
	// Bit mask of TIM2RST field.
	RCC_APBRSTR1_TIM2RST_Msk = 0x1
	// Bit TIM2RST.
	RCC_APBRSTR1_TIM2RST = 0x1
	// Position of TIM3RST field.
	RCC_APBRSTR1_TIM3RST_Pos = 0x1
	// Bit mask of TIM3RST field.
	RCC_APBRSTR1_TIM3RST_Msk = 0x2
	// Bit TIM3RST.
	RCC_APBRSTR1_TIM3RST = 0x2
	// Position of SPI2RST field.
	RCC_APBRSTR1_SPI2RST_Pos = 0xe
	// Bit mask of SPI2RST field.
	RCC_APBRSTR1_SPI2RST_Msk = 0x4000
	// Bit SPI2RST.
	RCC_APBRSTR1_SPI2RST = 0x4000
	// Position of USART2RST field.
	RCC_APBRSTR1_USART2RST_Pos = 0x11
	// Bit mask of USART2RST field.
	RCC_APBRSTR1_USART2RST_Msk = 0x20000
	// Bit USART2RST.
	RCC_APBRSTR1_USART2RST = 0x20000
	// Position of LPUART1RST field.
	RCC_APBRSTR1_LPUART1RST_Pos = 0x14
	// Bit mask of LPUART1RST field.
	RCC_APBRSTR1_LPUART1RST_Msk = 0x100000
	// Bit LPUART1RST.
	RCC_APBRSTR1_LPUART1RST = 0x100000
	// Position of I2C1RST field.
	RCC_APBRSTR1_I2C1RST_Pos = 0x15
	// Bit mask of I2C1RST field.
	RCC_APBRSTR1_I2C1RST_Msk = 0x200000
	// Bit I2C1RST.
	RCC_APBRSTR1_I2C1RST = 0x200000
	// Position of I2C2RST field.
	RCC_APBRSTR1_I2C2RST_Pos = 0x16
	// Bit mask of I2C2RST field.
	RCC_APBRSTR1_I2C2RST_Msk = 0x400000
	// Bit I2C2RST.
	RCC_APBRSTR1_I2C2RST = 0x400000
	// Position of DBGRST field.
	RCC_APBRSTR1_DBGRST_Pos = 0x1b
	// Bit mask of DBGRST field.
	RCC_APBRSTR1_DBGRST_Msk = 0x8000000
	// Bit DBGRST.
	RCC_APBRSTR1_DBGRST = 0x8000000
	// Position of PWRRST field.
	RCC_APBRSTR1_PWRRST_Pos = 0x1c
	// Bit mask of PWRRST field.
	RCC_APBRSTR1_PWRRST_Msk = 0x10000000
	// Bit PWRRST.
	RCC_APBRSTR1_PWRRST = 0x10000000
	// Position of LPTIM2RST field.
	RCC_APBRSTR1_LPTIM2RST_Pos = 0x1e
	// Bit mask of LPTIM2RST field.
	RCC_APBRSTR1_LPTIM2RST_Msk = 0x40000000
	// Bit LPTIM2RST.
	RCC_APBRSTR1_LPTIM2RST = 0x40000000
	// Position of LPTIM1RST field.
	RCC_APBRSTR1_LPTIM1RST_Pos = 0x1f
	// Bit mask of LPTIM1RST field.
	RCC_APBRSTR1_LPTIM1RST_Msk = 0x80000000
	// Bit LPTIM1RST.
	RCC_APBRSTR1_LPTIM1RST = 0x80000000

	// APBRSTR2: APB peripheral reset register 2
	// Position of SYSCFGRST field.
	RCC_APBRSTR2_SYSCFGRST_Pos = 0x0
	// Bit mask of SYSCFGRST field.
	RCC_APBRSTR2_SYSCFGRST_Msk = 0x1
	// Bit SYSCFGRST.
	RCC_APBRSTR2_SYSCFGRST = 0x1
	// Position of TIM1RST field.
	RCC_APBRSTR2_TIM1RST_Pos = 0xb
	// Bit mask of TIM1RST field.
	RCC_APBRSTR2_TIM1RST_Msk = 0x800
	// Bit TIM1RST.
	RCC_APBRSTR2_TIM1RST = 0x800
	// Position of SPI1RST field.
	RCC_APBRSTR2_SPI1RST_Pos = 0xc
	// Bit mask of SPI1RST field.
	RCC_APBRSTR2_SPI1RST_Msk = 0x1000
	// Bit SPI1RST.
	RCC_APBRSTR2_SPI1RST = 0x1000
	// Position of USART1RST field.
	RCC_APBRSTR2_USART1RST_Pos = 0xe
	// Bit mask of USART1RST field.
	RCC_APBRSTR2_USART1RST_Msk = 0x4000
	// Bit USART1RST.
	RCC_APBRSTR2_USART1RST = 0x4000
	// Position of TIM14RST field.
	RCC_APBRSTR2_TIM14RST_Pos = 0xf
	// Bit mask of TIM14RST field.
	RCC_APBRSTR2_TIM14RST_Msk = 0x8000
	// Bit TIM14RST.
	RCC_APBRSTR2_TIM14RST = 0x8000
	// Position of TIM16RST field.
	RCC_APBRSTR2_TIM16RST_Pos = 0x11
	// Bit mask of TIM16RST field.
	RCC_APBRSTR2_TIM16RST_Msk = 0x20000
	// Bit TIM16RST.
	RCC_APBRSTR2_TIM16RST = 0x20000
	// Position of TIM17RST field.
	RCC_APBRSTR2_TIM17RST_Pos = 0x12
	// Bit mask of TIM17RST field.
	RCC_APBRSTR2_TIM17RST_Msk = 0x40000
	// Bit TIM17RST.
	RCC_APBRSTR2_TIM17RST = 0x40000
	// Position of ADCRST field.
	RCC_APBRSTR2_ADCRST_Pos = 0x14
	// Bit mask of ADCRST field.
	RCC_APBRSTR2_ADCRST_Msk = 0x100000
	// Bit ADCRST.
	RCC_APBRSTR2_ADCRST = 0x100000

	// IOPENR: GPIO clock enable register
	// Position of IOPAEN field.
	RCC_IOPENR_IOPAEN_Pos = 0x0
	// Bit mask of IOPAEN field.
	RCC_IOPENR_IOPAEN_Msk = 0x1
	// Bit IOPAEN.
	RCC_IOPENR_IOPAEN = 0x1
	// Position of IOPBEN field.
	RCC_IOPENR_IOPBEN_Pos = 0x1
	// Bit mask of IOPBEN field.
	RCC_IOPENR_IOPBEN_Msk = 0x2
	// Bit IOPBEN.
	RCC_IOPENR_IOPBEN = 0x2
	// Position of IOPCEN field.
	RCC_IOPENR_IOPCEN_Pos = 0x2
	// Bit mask of IOPCEN field.
	RCC_IOPENR_IOPCEN_Msk = 0x4
	// Bit IOPCEN.
	RCC_IOPENR_IOPCEN = 0x4
	// Position of IOPDEN field.
	RCC_IOPENR_IOPDEN_Pos = 0x3
	// Bit mask of IOPDEN field.
	RCC_IOPENR_IOPDEN_Msk = 0x8
	// Bit IOPDEN.
	RCC_IOPENR_IOPDEN = 0x8
	// Position of IOPFEN field.
	RCC_IOPENR_IOPFEN_Pos = 0x5
	// Bit mask of IOPFEN field.
	RCC_IOPENR_IOPFEN_Msk = 0x20
	// Bit IOPFEN.
	RCC_IOPENR_IOPFEN = 0x20

	// AHBENR: AHB peripheral clock enable register
	// Position of DMAEN field.
	RCC_AHBENR_DMAEN_Pos = 0x0
	// Bit mask of DMAEN field.
	RCC_AHBENR_DMAEN_Msk = 0x1
	// Bit DMAEN.
	RCC_AHBENR_DMAEN = 0x1
	// Position of FLASHEN field.
	RCC_AHBENR_FLASHEN_Pos = 0x8
	// Bit mask of FLASHEN field.
	RCC_AHBENR_FLASHEN_Msk = 0x100
	// Bit FLASHEN.
	RCC_AHBENR_FLASHEN = 0x100
	// Position of CRCEN field.
	RCC_AHBENR_CRCEN_Pos = 0xc
	// Bit mask of CRCEN field.
	RCC_AHBENR_CRCEN_Msk = 0x1000
	// Bit CRCEN.
	RCC_AHBENR_CRCEN = 0x1000
	// Position of AESEN field.
	RCC_AHBENR_AESEN_Pos = 0x10
	// Bit mask of AESEN field.
	RCC_AHBENR_AESEN_Msk = 0x10000
	// Bit AESEN.
	RCC_AHBENR_AESEN = 0x10000
	// Position of RNGEN field.
	RCC_AHBENR_RNGEN_Pos = 0x12
	// Bit mask of RNGEN field.
	RCC_AHBENR_RNGEN_Msk = 0x40000
	// Bit RNGEN.
	RCC_AHBENR_RNGEN = 0x40000

	// APBENR1: APB peripheral clock enable register 1
	// Position of TIM2EN field.
	RCC_APBENR1_TIM2EN_Pos = 0x0
	// Bit mask of TIM2EN field.
	RCC_APBENR1_TIM2EN_Msk = 0x1
	// Bit TIM2EN.
	RCC_APBENR1_TIM2EN = 0x1
	// Position of TIM3EN field.
	RCC_APBENR1_TIM3EN_Pos = 0x1
	// Bit mask of TIM3EN field.
	RCC_APBENR1_TIM3EN_Msk = 0x2
	// Bit TIM3EN.
	RCC_APBENR1_TIM3EN = 0x2
	// Position of RTCAPBEN field.
	RCC_APBENR1_RTCAPBEN_Pos = 0xa
	// Bit mask of RTCAPBEN field.
	RCC_APBENR1_RTCAPBEN_Msk = 0x400
	// Bit RTCAPBEN.
	RCC_APBENR1_RTCAPBEN = 0x400
	// Position of WWDGEN field.
	RCC_APBENR1_WWDGEN_Pos = 0xb
	// Bit mask of WWDGEN field.
	RCC_APBENR1_WWDGEN_Msk = 0x800
	// Bit WWDGEN.
	RCC_APBENR1_WWDGEN = 0x800
	// Position of SPI2EN field.
	RCC_APBENR1_SPI2EN_Pos = 0xe
	// Bit mask of SPI2EN field.
	RCC_APBENR1_SPI2EN_Msk = 0x4000
	// Bit SPI2EN.
	RCC_APBENR1_SPI2EN = 0x4000
	// Position of USART2EN field.
	RCC_APBENR1_USART2EN_Pos = 0x11
	// Bit mask of USART2EN field.
	RCC_APBENR1_USART2EN_Msk = 0x20000
	// Bit USART2EN.
	RCC_APBENR1_USART2EN = 0x20000
	// Position of LPUART1EN field.
	RCC_APBENR1_LPUART1EN_Pos = 0x14
	// Bit mask of LPUART1EN field.
	RCC_APBENR1_LPUART1EN_Msk = 0x100000
	// Bit LPUART1EN.
	RCC_APBENR1_LPUART1EN = 0x100000
	// Position of I2C1EN field.
	RCC_APBENR1_I2C1EN_Pos = 0x15
	// Bit mask of I2C1EN field.
	RCC_APBENR1_I2C1EN_Msk = 0x200000
	// Bit I2C1EN.
	RCC_APBENR1_I2C1EN = 0x200000
	// Position of I2C2EN field.
	RCC_APBENR1_I2C2EN_Pos = 0x16
	// Bit mask of I2C2EN field.
	RCC_APBENR1_I2C2EN_Msk = 0x400000
	// Bit I2C2EN.
	RCC_APBENR1_I2C2EN = 0x400000
	// Position of DBGEN field.
	RCC_APBENR1_DBGEN_Pos = 0x1b
	// Bit mask of DBGEN field.
	RCC_APBENR1_DBGEN_Msk = 0x8000000
	// Bit DBGEN.
	RCC_APBENR1_DBGEN = 0x8000000
	// Position of PWREN field.
	RCC_APBENR1_PWREN_Pos = 0x1c
	// Bit mask of PWREN field.
	RCC_APBENR1_PWREN_Msk = 0x10000000
	// Bit PWREN.
	RCC_APBENR1_PWREN = 0x10000000
	// Position of LPTIM2EN field.
	RCC_APBENR1_LPTIM2EN_Pos = 0x1e
	// Bit mask of LPTIM2EN field.
	RCC_APBENR1_LPTIM2EN_Msk = 0x40000000
	// Bit LPTIM2EN.
	RCC_APBENR1_LPTIM2EN = 0x40000000
	// Position of LPTIM1EN field.
	RCC_APBENR1_LPTIM1EN_Pos = 0x1f
	// Bit mask of LPTIM1EN field.
	RCC_APBENR1_LPTIM1EN_Msk = 0x80000000
	// Bit LPTIM1EN.
	RCC_APBENR1_LPTIM1EN = 0x80000000

	// APBENR2: APB peripheral clock enable register 2
	// Position of SYSCFGEN field.
	RCC_APBENR2_SYSCFGEN_Pos = 0x0
	// Bit mask of SYSCFGEN field.
	RCC_APBENR2_SYSCFGEN_Msk = 0x1
	// Bit SYSCFGEN.
	RCC_APBENR2_SYSCFGEN = 0x1
	// Position of TIM1EN field.
	RCC_APBENR2_TIM1EN_Pos = 0xb
	// Bit mask of TIM1EN field.
	RCC_APBENR2_TIM1EN_Msk = 0x800
	// Bit TIM1EN.
	RCC_APBENR2_TIM1EN = 0x800
	// Position of SPI1EN field.
	RCC_APBENR2_SPI1EN_Pos = 0xc
	// Bit mask of SPI1EN field.
	RCC_APBENR2_SPI1EN_Msk = 0x1000
	// Bit SPI1EN.
	RCC_APBENR2_SPI1EN = 0x1000
	// Position of USART1EN field.
	RCC_APBENR2_USART1EN_Pos = 0xe
	// Bit mask of USART1EN field.
	RCC_APBENR2_USART1EN_Msk = 0x4000
	// Bit USART1EN.
	RCC_APBENR2_USART1EN = 0x4000
	// Position of TIM14EN field.
	RCC_APBENR2_TIM14EN_Pos = 0xf
	// Bit mask of TIM14EN field.
	RCC_APBENR2_TIM14EN_Msk = 0x8000
	// Bit TIM14EN.
	RCC_APBENR2_TIM14EN = 0x8000
	// Position of TIM16EN field.
	RCC_APBENR2_TIM16EN_Pos = 0x11
	// Bit mask of TIM16EN field.
	RCC_APBENR2_TIM16EN_Msk = 0x20000
	// Bit TIM16EN.
	RCC_APBENR2_TIM16EN = 0x20000
	// Position of TIM17EN field.
	RCC_APBENR2_TIM17EN_Pos = 0x12
	// Bit mask of TIM17EN field.
	RCC_APBENR2_TIM17EN_Msk = 0x40000
	// Bit TIM17EN.
	RCC_APBENR2_TIM17EN = 0x40000
	// Position of ADCEN field.
	RCC_APBENR2_ADCEN_Pos = 0x14
	// Bit mask of ADCEN field.
	RCC_APBENR2_ADCEN_Msk = 0x100000
	// Bit ADCEN.
	RCC_APBENR2_ADCEN = 0x100000

	// IOPSMENR: GPIO in Sleep mode clock enable register
	// Position of IOPASMEN field.
	RCC_IOPSMENR_IOPASMEN_Pos = 0x0
	// Bit mask of IOPASMEN field.
	RCC_IOPSMENR_IOPASMEN_Msk = 0x1
	// Bit IOPASMEN.
	RCC_IOPSMENR_IOPASMEN = 0x1
	// Position of IOPBSMEN field.
	RCC_IOPSMENR_IOPBSMEN_Pos = 0x1
	// Bit mask of IOPBSMEN field.
	RCC_IOPSMENR_IOPBSMEN_Msk = 0x2
	// Bit IOPBSMEN.
	RCC_IOPSMENR_IOPBSMEN = 0x2
	// Position of IOPCSMEN field.
	RCC_IOPSMENR_IOPCSMEN_Pos = 0x2
	// Bit mask of IOPCSMEN field.
	RCC_IOPSMENR_IOPCSMEN_Msk = 0x4
	// Bit IOPCSMEN.
	RCC_IOPSMENR_IOPCSMEN = 0x4
	// Position of IOPDSMEN field.
	RCC_IOPSMENR_IOPDSMEN_Pos = 0x3
	// Bit mask of IOPDSMEN field.
	RCC_IOPSMENR_IOPDSMEN_Msk = 0x8
	// Bit IOPDSMEN.
	RCC_IOPSMENR_IOPDSMEN = 0x8
	// Position of IOPFSMEN field.
	RCC_IOPSMENR_IOPFSMEN_Pos = 0x5
	// Bit mask of IOPFSMEN field.
	RCC_IOPSMENR_IOPFSMEN_Msk = 0x20
	// Bit IOPFSMEN.
	RCC_IOPSMENR_IOPFSMEN = 0x20

	// AHBSMENR: AHB peripheral clock enable in Sleep mode register
	// Position of DMASMEN field.
	RCC_AHBSMENR_DMASMEN_Pos = 0x0
	// Bit mask of DMASMEN field.
	RCC_AHBSMENR_DMASMEN_Msk = 0x1
	// Bit DMASMEN.
	RCC_AHBSMENR_DMASMEN = 0x1
	// Position of FLASHSMEN field.
	RCC_AHBSMENR_FLASHSMEN_Pos = 0x8
	// Bit mask of FLASHSMEN field.
	RCC_AHBSMENR_FLASHSMEN_Msk = 0x100
	// Bit FLASHSMEN.
	RCC_AHBSMENR_FLASHSMEN = 0x100
	// Position of SRAMSMEN field.
	RCC_AHBSMENR_SRAMSMEN_Pos = 0x9
	// Bit mask of SRAMSMEN field.
	RCC_AHBSMENR_SRAMSMEN_Msk = 0x200
	// Bit SRAMSMEN.
	RCC_AHBSMENR_SRAMSMEN = 0x200
	// Position of CRCSMEN field.
	RCC_AHBSMENR_CRCSMEN_Pos = 0xc
	// Bit mask of CRCSMEN field.
	RCC_AHBSMENR_CRCSMEN_Msk = 0x1000
	// Bit CRCSMEN.
	RCC_AHBSMENR_CRCSMEN = 0x1000
	// Position of AESSMEN field.
	RCC_AHBSMENR_AESSMEN_Pos = 0x10
	// Bit mask of AESSMEN field.
	RCC_AHBSMENR_AESSMEN_Msk = 0x10000
	// Bit AESSMEN.
	RCC_AHBSMENR_AESSMEN = 0x10000
	// Position of RNGSMEN field.
	RCC_AHBSMENR_RNGSMEN_Pos = 0x12
	// Bit mask of RNGSMEN field.
	RCC_AHBSMENR_RNGSMEN_Msk = 0x40000
	// Bit RNGSMEN.
	RCC_AHBSMENR_RNGSMEN = 0x40000

	// APBSMENR1: APB peripheral clock enable in Sleep mode register 1
	// Position of TIM2SMEN field.
	RCC_APBSMENR1_TIM2SMEN_Pos = 0x0
	// Bit mask of TIM2SMEN field.
	RCC_APBSMENR1_TIM2SMEN_Msk = 0x1
	// Bit TIM2SMEN.
	RCC_APBSMENR1_TIM2SMEN = 0x1
	// Position of TIM3SMEN field.
	RCC_APBSMENR1_TIM3SMEN_Pos = 0x1
	// Bit mask of TIM3SMEN field.
	RCC_APBSMENR1_TIM3SMEN_Msk = 0x2
	// Bit TIM3SMEN.
	RCC_APBSMENR1_TIM3SMEN = 0x2
	// Position of RTCAPBSMEN field.
	RCC_APBSMENR1_RTCAPBSMEN_Pos = 0xa
	// Bit mask of RTCAPBSMEN field.
	RCC_APBSMENR1_RTCAPBSMEN_Msk = 0x400
	// Bit RTCAPBSMEN.
	RCC_APBSMENR1_RTCAPBSMEN = 0x400
	// Position of WWDGSMEN field.
	RCC_APBSMENR1_WWDGSMEN_Pos = 0xb
	// Bit mask of WWDGSMEN field.
	RCC_APBSMENR1_WWDGSMEN_Msk = 0x800
	// Bit WWDGSMEN.
	RCC_APBSMENR1_WWDGSMEN = 0x800
	// Position of SPI2SMEN field.
	RCC_APBSMENR1_SPI2SMEN_Pos = 0xe
	// Bit mask of SPI2SMEN field.
	RCC_APBSMENR1_SPI2SMEN_Msk = 0x4000
	// Bit SPI2SMEN.
	RCC_APBSMENR1_SPI2SMEN = 0x4000
	// Position of USART2SMEN field.
	RCC_APBSMENR1_USART2SMEN_Pos = 0x11
	// Bit mask of USART2SMEN field.
	RCC_APBSMENR1_USART2SMEN_Msk = 0x20000
	// Bit USART2SMEN.
	RCC_APBSMENR1_USART2SMEN = 0x20000
	// Position of LPUART1SMEN field.
	RCC_APBSMENR1_LPUART1SMEN_Pos = 0x14
	// Bit mask of LPUART1SMEN field.
	RCC_APBSMENR1_LPUART1SMEN_Msk = 0x100000
	// Bit LPUART1SMEN.
	RCC_APBSMENR1_LPUART1SMEN = 0x100000
	// Position of I2C1SMEN field.
	RCC_APBSMENR1_I2C1SMEN_Pos = 0x15
	// Bit mask of I2C1SMEN field.
	RCC_APBSMENR1_I2C1SMEN_Msk = 0x200000
	// Bit I2C1SMEN.
	RCC_APBSMENR1_I2C1SMEN = 0x200000
	// Position of I2C2SMEN field.
	RCC_APBSMENR1_I2C2SMEN_Pos = 0x16
	// Bit mask of I2C2SMEN field.
	RCC_APBSMENR1_I2C2SMEN_Msk = 0x400000
	// Bit I2C2SMEN.
	RCC_APBSMENR1_I2C2SMEN = 0x400000
	// Position of DBGSMEN field.
	RCC_APBSMENR1_DBGSMEN_Pos = 0x1b
	// Bit mask of DBGSMEN field.
	RCC_APBSMENR1_DBGSMEN_Msk = 0x8000000
	// Bit DBGSMEN.
	RCC_APBSMENR1_DBGSMEN = 0x8000000
	// Position of PWRSMEN field.
	RCC_APBSMENR1_PWRSMEN_Pos = 0x1c
	// Bit mask of PWRSMEN field.
	RCC_APBSMENR1_PWRSMEN_Msk = 0x10000000
	// Bit PWRSMEN.
	RCC_APBSMENR1_PWRSMEN = 0x10000000
	// Position of LPTIM2SMEN field.
	RCC_APBSMENR1_LPTIM2SMEN_Pos = 0x1e
	// Bit mask of LPTIM2SMEN field.
	RCC_APBSMENR1_LPTIM2SMEN_Msk = 0x40000000
	// Bit LPTIM2SMEN.
	RCC_APBSMENR1_LPTIM2SMEN = 0x40000000
	// Position of LPTIM1SMEN field.
	RCC_APBSMENR1_LPTIM1SMEN_Pos = 0x1f
	// Bit mask of LPTIM1SMEN field.
	RCC_APBSMENR1_LPTIM1SMEN_Msk = 0x80000000
	// Bit LPTIM1SMEN.
	RCC_APBSMENR1_LPTIM1SMEN = 0x80000000

	// APBSMENR2: APB peripheral clock enable in Sleep mode register 2
	// Position of SYSCFGSMEN field.
	RCC_APBSMENR2_SYSCFGSMEN_Pos = 0x0
	// Bit mask of SYSCFGSMEN field.
	RCC_APBSMENR2_SYSCFGSMEN_Msk = 0x1
	// Bit SYSCFGSMEN.
	RCC_APBSMENR2_SYSCFGSMEN = 0x1
	// Position of TIM1SMEN field.
	RCC_APBSMENR2_TIM1SMEN_Pos = 0xb
	// Bit mask of TIM1SMEN field.
	RCC_APBSMENR2_TIM1SMEN_Msk = 0x800
	// Bit TIM1SMEN.
	RCC_APBSMENR2_TIM1SMEN = 0x800
	// Position of SPI1SMEN field.
	RCC_APBSMENR2_SPI1SMEN_Pos = 0xc
	// Bit mask of SPI1SMEN field.
	RCC_APBSMENR2_SPI1SMEN_Msk = 0x1000
	// Bit SPI1SMEN.
	RCC_APBSMENR2_SPI1SMEN = 0x1000
	// Position of USART1SMEN field.
	RCC_APBSMENR2_USART1SMEN_Pos = 0xe
	// Bit mask of USART1SMEN field.
	RCC_APBSMENR2_USART1SMEN_Msk = 0x4000
	// Bit USART1SMEN.
	RCC_APBSMENR2_USART1SMEN = 0x4000
	// Position of TIM14SMEN field.
	RCC_APBSMENR2_TIM14SMEN_Pos = 0xf
	// Bit mask of TIM14SMEN field.
	RCC_APBSMENR2_TIM14SMEN_Msk = 0x8000
	// Bit TIM14SMEN.
	RCC_APBSMENR2_TIM14SMEN = 0x8000
	// Position of TIM16SMEN field.
	RCC_APBSMENR2_TIM16SMEN_Pos = 0x11
	// Bit mask of TIM16SMEN field.
	RCC_APBSMENR2_TIM16SMEN_Msk = 0x20000
	// Bit TIM16SMEN.
	RCC_APBSMENR2_TIM16SMEN = 0x20000
	// Position of TIM17SMEN field.
	RCC_APBSMENR2_TIM17SMEN_Pos = 0x12
	// Bit mask of TIM17SMEN field.
	RCC_APBSMENR2_TIM17SMEN_Msk = 0x40000
	// Bit TIM17SMEN.
	RCC_APBSMENR2_TIM17SMEN = 0x40000
	// Position of ADCSMEN field.
	RCC_APBSMENR2_ADCSMEN_Pos = 0x14
	// Bit mask of ADCSMEN field.
	RCC_APBSMENR2_ADCSMEN_Msk = 0x100000
	// Bit ADCSMEN.
	RCC_APBSMENR2_ADCSMEN = 0x100000

	// CCIPR: Peripherals independent clock configuration register
	// Position of USART1SEL field.
	RCC_CCIPR_USART1SEL_Pos = 0x0
	// Bit mask of USART1SEL field.
	RCC_CCIPR_USART1SEL_Msk = 0x3
	// Position of LPUART1SEL field.
	RCC_CCIPR_LPUART1SEL_Pos = 0xa
	// Bit mask of LPUART1SEL field.
	RCC_CCIPR_LPUART1SEL_Msk = 0xc00
	// Position of I2C1SEL field.
	RCC_CCIPR_I2C1SEL_Pos = 0xc
	// Bit mask of I2C1SEL field.
	RCC_CCIPR_I2C1SEL_Msk = 0x3000
	// Position of I2S2SEL field.
	RCC_CCIPR_I2S2SEL_Pos = 0xe
	// Bit mask of I2S2SEL field.
	RCC_CCIPR_I2S2SEL_Msk = 0xc000
	// Position of LPTIM1SEL field.
	RCC_CCIPR_LPTIM1SEL_Pos = 0x12
	// Bit mask of LPTIM1SEL field.
	RCC_CCIPR_LPTIM1SEL_Msk = 0xc0000
	// Position of LPTIM2SEL field.
	RCC_CCIPR_LPTIM2SEL_Pos = 0x14
	// Bit mask of LPTIM2SEL field.
	RCC_CCIPR_LPTIM2SEL_Msk = 0x300000
	// Position of TIM1SEL field.
	RCC_CCIPR_TIM1SEL_Pos = 0x16
	// Bit mask of TIM1SEL field.
	RCC_CCIPR_TIM1SEL_Msk = 0x400000
	// Bit TIM1SEL.
	RCC_CCIPR_TIM1SEL = 0x400000
	// Position of RNGSEL field.
	RCC_CCIPR_RNGSEL_Pos = 0x1a
	// Bit mask of RNGSEL field.
	RCC_CCIPR_RNGSEL_Msk = 0xc000000
	// Position of RNGDIV field.
	RCC_CCIPR_RNGDIV_Pos = 0x1c
	// Bit mask of RNGDIV field.
	RCC_CCIPR_RNGDIV_Msk = 0x30000000
	// Position of ADCSEL field.
	RCC_CCIPR_ADCSEL_Pos = 0x1e
	// Bit mask of ADCSEL field.
	RCC_CCIPR_ADCSEL_Msk = 0xc0000000

	// BDCR: RTC domain control register
	// Position of LSEON field.
	RCC_BDCR_LSEON_Pos = 0x0
	// Bit mask of LSEON field.
	RCC_BDCR_LSEON_Msk = 0x1
	// Bit LSEON.
	RCC_BDCR_LSEON = 0x1
	// Position of LSERDY field.
	RCC_BDCR_LSERDY_Pos = 0x1
	// Bit mask of LSERDY field.
	RCC_BDCR_LSERDY_Msk = 0x2
	// Bit LSERDY.
	RCC_BDCR_LSERDY = 0x2
	// Position of LSEBYP field.
	RCC_BDCR_LSEBYP_Pos = 0x2
	// Bit mask of LSEBYP field.
	RCC_BDCR_LSEBYP_Msk = 0x4
	// Bit LSEBYP.
	RCC_BDCR_LSEBYP = 0x4
	// Position of LSEDRV field.
	RCC_BDCR_LSEDRV_Pos = 0x3
	// Bit mask of LSEDRV field.
	RCC_BDCR_LSEDRV_Msk = 0x18
	// Position of LSECSSON field.
	RCC_BDCR_LSECSSON_Pos = 0x5
	// Bit mask of LSECSSON field.
	RCC_BDCR_LSECSSON_Msk = 0x20
	// Bit LSECSSON.
	RCC_BDCR_LSECSSON = 0x20
	// Position of LSECSSD field.
	RCC_BDCR_LSECSSD_Pos = 0x6
	// Bit mask of LSECSSD field.
	RCC_BDCR_LSECSSD_Msk = 0x40
	// Bit LSECSSD.
	RCC_BDCR_LSECSSD = 0x40
	// Position of RTCSEL field.
	RCC_BDCR_RTCSEL_Pos = 0x8
	// Bit mask of RTCSEL field.
	RCC_BDCR_RTCSEL_Msk = 0x300
	// Position of RTCEN field.
	RCC_BDCR_RTCEN_Pos = 0xf
	// Bit mask of RTCEN field.
	RCC_BDCR_RTCEN_Msk = 0x8000
	// Bit RTCEN.
	RCC_BDCR_RTCEN = 0x8000
	// Position of BDRST field.
	RCC_BDCR_BDRST_Pos = 0x10
	// Bit mask of BDRST field.
	RCC_BDCR_BDRST_Msk = 0x10000
	// Bit BDRST.
	RCC_BDCR_BDRST = 0x10000
	// Position of LSCOEN field.
	RCC_BDCR_LSCOEN_Pos = 0x18
	// Bit mask of LSCOEN field.
	RCC_BDCR_LSCOEN_Msk = 0x1000000
	// Bit LSCOEN.
	RCC_BDCR_LSCOEN = 0x1000000
	// Position of LSCOSEL field.
	RCC_BDCR_LSCOSEL_Pos = 0x19
	// Bit mask of LSCOSEL field.
	RCC_BDCR_LSCOSEL_Msk = 0x2000000
	// Bit LSCOSEL.
	RCC_BDCR_LSCOSEL = 0x2000000

	// CSR: Control/status register
	// Position of LSION field.
	RCC_CSR_LSION_Pos = 0x0
	// Bit mask of LSION field.
	RCC_CSR_LSION_Msk = 0x1
	// Bit LSION.
	RCC_CSR_LSION = 0x1
	// Position of LSIRDY field.
	RCC_CSR_LSIRDY_Pos = 0x1
	// Bit mask of LSIRDY field.
	RCC_CSR_LSIRDY_Msk = 0x2
	// Bit LSIRDY.
	RCC_CSR_LSIRDY = 0x2
	// Position of RMVF field.
	RCC_CSR_RMVF_Pos = 0x17
	// Bit mask of RMVF field.
	RCC_CSR_RMVF_Msk = 0x800000
	// Bit RMVF.
	RCC_CSR_RMVF = 0x800000
	// Position of OBLRSTF field.
	RCC_CSR_OBLRSTF_Pos = 0x19
	// Bit mask of OBLRSTF field.
	RCC_CSR_OBLRSTF_Msk = 0x2000000
	// Bit OBLRSTF.
	RCC_CSR_OBLRSTF = 0x2000000
	// Position of PINRSTF field.
	RCC_CSR_PINRSTF_Pos = 0x1a
	// Bit mask of PINRSTF field.
	RCC_CSR_PINRSTF_Msk = 0x4000000
	// Bit PINRSTF.
	RCC_CSR_PINRSTF = 0x4000000
	// Position of PWRRSTF field.
	RCC_CSR_PWRRSTF_Pos = 0x1b
	// Bit mask of PWRRSTF field.
	RCC_CSR_PWRRSTF_Msk = 0x8000000
	// Bit PWRRSTF.
	RCC_CSR_PWRRSTF = 0x8000000
	// Position of SFTRSTF field.
	RCC_CSR_SFTRSTF_Pos = 0x1c
	// Bit mask of SFTRSTF field.
	RCC_CSR_SFTRSTF_Msk = 0x10000000
	// Bit SFTRSTF.
	RCC_CSR_SFTRSTF = 0x10000000
	// Position of IWDGRSTF field.
	RCC_CSR_IWDGRSTF_Pos = 0x1d
	// Bit mask of IWDGRSTF field.
	RCC_CSR_IWDGRSTF_Msk = 0x20000000
	// Bit IWDGRSTF.
	RCC_CSR_IWDGRSTF = 0x20000000
	// Position of WWDGRSTF field.
	RCC_CSR_WWDGRSTF_Pos = 0x1e
	// Bit mask of WWDGRSTF field.
	RCC_CSR_WWDGRSTF_Msk = 0x40000000
	// Bit WWDGRSTF.
	RCC_CSR_WWDGRSTF = 0x40000000
	// Position of LPWRRSTF field.
	RCC_CSR_LPWRRSTF_Pos = 0x1f
	// Bit mask of LPWRRSTF field.
	RCC_CSR_LPWRRSTF_Msk = 0x80000000
	// Bit LPWRRSTF.
	RCC_CSR_LPWRRSTF = 0x80000000
)

// Bitfields for PWR: Power control
const (
	// CR1: Power control register 1
	// Position of LPR field.
	PWR_CR1_LPR_Pos = 0xe
	// Bit mask of LPR field.
	PWR_CR1_LPR_Msk = 0x4000
	// Bit LPR.
	PWR_CR1_LPR = 0x4000
	// Position of VOS field.
	PWR_CR1_VOS_Pos = 0x9
	// Bit mask of VOS field.
	PWR_CR1_VOS_Msk = 0x600
	// Position of DBP field.
	PWR_CR1_DBP_Pos = 0x8
	// Bit mask of DBP field.
	PWR_CR1_DBP_Msk = 0x100
	// Bit DBP.
	PWR_CR1_DBP = 0x100
	// Position of FPD_LPSLP field.
	PWR_CR1_FPD_LPSLP_Pos = 0x5
	// Bit mask of FPD_LPSLP field.
	PWR_CR1_FPD_LPSLP_Msk = 0x20
	// Bit FPD_LPSLP.
	PWR_CR1_FPD_LPSLP = 0x20
	// Position of FPD_LPRUN field.
	PWR_CR1_FPD_LPRUN_Pos = 0x4
	// Bit mask of FPD_LPRUN field.
	PWR_CR1_FPD_LPRUN_Msk = 0x10
	// Bit FPD_LPRUN.
	PWR_CR1_FPD_LPRUN = 0x10
	// Position of FPD_STOP field.
	PWR_CR1_FPD_STOP_Pos = 0x3
	// Bit mask of FPD_STOP field.
	PWR_CR1_FPD_STOP_Msk = 0x8
	// Bit FPD_STOP.
	PWR_CR1_FPD_STOP = 0x8
	// Position of LPMS field.
	PWR_CR1_LPMS_Pos = 0x0
	// Bit mask of LPMS field.
	PWR_CR1_LPMS_Msk = 0x7

	// CR2: Power control register 2
	// Position of PVDE field.
	PWR_CR2_PVDE_Pos = 0x0
	// Bit mask of PVDE field.
	PWR_CR2_PVDE_Msk = 0x1
	// Bit PVDE.
	PWR_CR2_PVDE = 0x1
	// Position of PVDFT field.
	PWR_CR2_PVDFT_Pos = 0x1
	// Bit mask of PVDFT field.
	PWR_CR2_PVDFT_Msk = 0xe
	// Position of PVDRT field.
	PWR_CR2_PVDRT_Pos = 0x4
	// Bit mask of PVDRT field.
	PWR_CR2_PVDRT_Msk = 0x70

	// CR3: Power control register 3
	// Position of EWUP1 field.
	PWR_CR3_EWUP1_Pos = 0x0
	// Bit mask of EWUP1 field.
	PWR_CR3_EWUP1_Msk = 0x1
	// Bit EWUP1.
	PWR_CR3_EWUP1 = 0x1
	// Position of EWUP2 field.
	PWR_CR3_EWUP2_Pos = 0x1
	// Bit mask of EWUP2 field.
	PWR_CR3_EWUP2_Msk = 0x2
	// Bit EWUP2.
	PWR_CR3_EWUP2 = 0x2
	// Position of EWUP4 field.
	PWR_CR3_EWUP4_Pos = 0x3
	// Bit mask of EWUP4 field.
	PWR_CR3_EWUP4_Msk = 0x8
	// Bit EWUP4.
	PWR_CR3_EWUP4 = 0x8
	// Position of EWUP5 field.
	PWR_CR3_EWUP5_Pos = 0x4
	// Bit mask of EWUP5 field.
	PWR_CR3_EWUP5_Msk = 0x10
	// Bit EWUP5.
	PWR_CR3_EWUP5 = 0x10
	// Position of EWUP6 field.
	PWR_CR3_EWUP6_Pos = 0x5
	// Bit mask of EWUP6 field.
	PWR_CR3_EWUP6_Msk = 0x20
	// Bit EWUP6.
	PWR_CR3_EWUP6 = 0x20
	// Position of RRS field.
	PWR_CR3_RRS_Pos = 0x8
	// Bit mask of RRS field.
	PWR_CR3_RRS_Msk = 0x100
	// Bit RRS.
	PWR_CR3_RRS = 0x100
	// Position of ULPEN field.
	PWR_CR3_ULPEN_Pos = 0x9
	// Bit mask of ULPEN field.
	PWR_CR3_ULPEN_Msk = 0x200
	// Bit ULPEN.
	PWR_CR3_ULPEN = 0x200
	// Position of APC field.
	PWR_CR3_APC_Pos = 0xa
	// Bit mask of APC field.
	PWR_CR3_APC_Msk = 0x400
	// Bit APC.
	PWR_CR3_APC = 0x400
	// Position of EIWUL field.
	PWR_CR3_EIWUL_Pos = 0xf
	// Bit mask of EIWUL field.
	PWR_CR3_EIWUL_Msk = 0x8000
	// Bit EIWUL.
	PWR_CR3_EIWUL = 0x8000

	// CR4: Power control register 4
	// Position of WP1 field.
	PWR_CR4_WP1_Pos = 0x0
	// Bit mask of WP1 field.
	PWR_CR4_WP1_Msk = 0x1
	// Bit WP1.
	PWR_CR4_WP1 = 0x1
	// Position of WP2 field.
	PWR_CR4_WP2_Pos = 0x1
	// Bit mask of WP2 field.
	PWR_CR4_WP2_Msk = 0x2
	// Bit WP2.
	PWR_CR4_WP2 = 0x2
	// Position of WP4 field.
	PWR_CR4_WP4_Pos = 0x3
	// Bit mask of WP4 field.
	PWR_CR4_WP4_Msk = 0x8
	// Bit WP4.
	PWR_CR4_WP4 = 0x8
	// Position of WP5 field.
	PWR_CR4_WP5_Pos = 0x4
	// Bit mask of WP5 field.
	PWR_CR4_WP5_Msk = 0x10
	// Bit WP5.
	PWR_CR4_WP5 = 0x10
	// Position of WP6 field.
	PWR_CR4_WP6_Pos = 0x5
	// Bit mask of WP6 field.
	PWR_CR4_WP6_Msk = 0x20
	// Bit WP6.
	PWR_CR4_WP6 = 0x20
	// Position of VBE field.
	PWR_CR4_VBE_Pos = 0x8
	// Bit mask of VBE field.
	PWR_CR4_VBE_Msk = 0x100
	// Bit VBE.
	PWR_CR4_VBE = 0x100
	// Position of VBRS field.
	PWR_CR4_VBRS_Pos = 0x9
	// Bit mask of VBRS field.
	PWR_CR4_VBRS_Msk = 0x200
	// Bit VBRS.
	PWR_CR4_VBRS = 0x200

	// SR1: Power status register 1
	// Position of WUF1 field.
	PWR_SR1_WUF1_Pos = 0x0
	// Bit mask of WUF1 field.
	PWR_SR1_WUF1_Msk = 0x1
	// Bit WUF1.
	PWR_SR1_WUF1 = 0x1
	// Position of WUF2 field.
	PWR_SR1_WUF2_Pos = 0x1
	// Bit mask of WUF2 field.
	PWR_SR1_WUF2_Msk = 0x2
	// Bit WUF2.
	PWR_SR1_WUF2 = 0x2
	// Position of WUF4 field.
	PWR_SR1_WUF4_Pos = 0x3
	// Bit mask of WUF4 field.
	PWR_SR1_WUF4_Msk = 0x8
	// Bit WUF4.
	PWR_SR1_WUF4 = 0x8
	// Position of WUF5 field.
	PWR_SR1_WUF5_Pos = 0x4
	// Bit mask of WUF5 field.
	PWR_SR1_WUF5_Msk = 0x10
	// Bit WUF5.
	PWR_SR1_WUF5 = 0x10
	// Position of WUF6 field.
	PWR_SR1_WUF6_Pos = 0x5
	// Bit mask of WUF6 field.
	PWR_SR1_WUF6_Msk = 0x20
	// Bit WUF6.
	PWR_SR1_WUF6 = 0x20
	// Position of SBF field.
	PWR_SR1_SBF_Pos = 0x8
	// Bit mask of SBF field.
	PWR_SR1_SBF_Msk = 0x100
	// Bit SBF.
	PWR_SR1_SBF = 0x100
	// Position of WUFI field.
	PWR_SR1_WUFI_Pos = 0xf
	// Bit mask of WUFI field.
	PWR_SR1_WUFI_Msk = 0x8000
	// Bit WUFI.
	PWR_SR1_WUFI = 0x8000

	// SR2: Power status register 2
	// Position of PVDO field.
	PWR_SR2_PVDO_Pos = 0xb
	// Bit mask of PVDO field.
	PWR_SR2_PVDO_Msk = 0x800
	// Bit PVDO.
	PWR_SR2_PVDO = 0x800
	// Position of VOSF field.
	PWR_SR2_VOSF_Pos = 0xa
	// Bit mask of VOSF field.
	PWR_SR2_VOSF_Msk = 0x400
	// Bit VOSF.
	PWR_SR2_VOSF = 0x400
	// Position of REGLPF field.
	PWR_SR2_REGLPF_Pos = 0x9
	// Bit mask of REGLPF field.
	PWR_SR2_REGLPF_Msk = 0x200
	// Bit REGLPF.
	PWR_SR2_REGLPF = 0x200
	// Position of REGLPS field.
	PWR_SR2_REGLPS_Pos = 0x8
	// Bit mask of REGLPS field.
	PWR_SR2_REGLPS_Msk = 0x100
	// Bit REGLPS.
	PWR_SR2_REGLPS = 0x100
	// Position of FLASH_RDY field.
	PWR_SR2_FLASH_RDY_Pos = 0x7
	// Bit mask of FLASH_RDY field.
	PWR_SR2_FLASH_RDY_Msk = 0x80
	// Bit FLASH_RDY.
	PWR_SR2_FLASH_RDY = 0x80

	// SCR: Power status clear register
	// Position of CSBF field.
	PWR_SCR_CSBF_Pos = 0x8
	// Bit mask of CSBF field.
	PWR_SCR_CSBF_Msk = 0x100
	// Bit CSBF.
	PWR_SCR_CSBF = 0x100
	// Position of CWUF6 field.
	PWR_SCR_CWUF6_Pos = 0x5
	// Bit mask of CWUF6 field.
	PWR_SCR_CWUF6_Msk = 0x20
	// Bit CWUF6.
	PWR_SCR_CWUF6 = 0x20
	// Position of CWUF5 field.
	PWR_SCR_CWUF5_Pos = 0x4
	// Bit mask of CWUF5 field.
	PWR_SCR_CWUF5_Msk = 0x10
	// Bit CWUF5.
	PWR_SCR_CWUF5 = 0x10
	// Position of CWUF4 field.
	PWR_SCR_CWUF4_Pos = 0x3
	// Bit mask of CWUF4 field.
	PWR_SCR_CWUF4_Msk = 0x8
	// Bit CWUF4.
	PWR_SCR_CWUF4 = 0x8
	// Position of CWUF2 field.
	PWR_SCR_CWUF2_Pos = 0x1
	// Bit mask of CWUF2 field.
	PWR_SCR_CWUF2_Msk = 0x2
	// Bit CWUF2.
	PWR_SCR_CWUF2 = 0x2
	// Position of CWUF1 field.
	PWR_SCR_CWUF1_Pos = 0x0
	// Bit mask of CWUF1 field.
	PWR_SCR_CWUF1_Msk = 0x1
	// Bit CWUF1.
	PWR_SCR_CWUF1 = 0x1

	// PUCRA: Power Port A pull-up control register
	// Position of PU15 field.
	PWR_PUCRA_PU15_Pos = 0xf
	// Bit mask of PU15 field.
	PWR_PUCRA_PU15_Msk = 0x8000
	// Bit PU15.
	PWR_PUCRA_PU15 = 0x8000
	// Position of PU14 field.
	PWR_PUCRA_PU14_Pos = 0xe
	// Bit mask of PU14 field.
	PWR_PUCRA_PU14_Msk = 0x4000
	// Bit PU14.
	PWR_PUCRA_PU14 = 0x4000
	// Position of PU13 field.
	PWR_PUCRA_PU13_Pos = 0xd
	// Bit mask of PU13 field.
	PWR_PUCRA_PU13_Msk = 0x2000
	// Bit PU13.
	PWR_PUCRA_PU13 = 0x2000
	// Position of PU12 field.
	PWR_PUCRA_PU12_Pos = 0xc
	// Bit mask of PU12 field.
	PWR_PUCRA_PU12_Msk = 0x1000
	// Bit PU12.
	PWR_PUCRA_PU12 = 0x1000
	// Position of PU11 field.
	PWR_PUCRA_PU11_Pos = 0xb
	// Bit mask of PU11 field.
	PWR_PUCRA_PU11_Msk = 0x800
	// Bit PU11.
	PWR_PUCRA_PU11 = 0x800
	// Position of PU10 field.
	PWR_PUCRA_PU10_Pos = 0xa
	// Bit mask of PU10 field.
	PWR_PUCRA_PU10_Msk = 0x400
	// Bit PU10.
	PWR_PUCRA_PU10 = 0x400
	// Position of PU9 field.
	PWR_PUCRA_PU9_Pos = 0x9
	// Bit mask of PU9 field.
	PWR_PUCRA_PU9_Msk = 0x200
	// Bit PU9.
	PWR_PUCRA_PU9 = 0x200
	// Position of PU8 field.
	PWR_PUCRA_PU8_Pos = 0x8
	// Bit mask of PU8 field.
	PWR_PUCRA_PU8_Msk = 0x100
	// Bit PU8.
	PWR_PUCRA_PU8 = 0x100
	// Position of PU7 field.
	PWR_PUCRA_PU7_Pos = 0x7
	// Bit mask of PU7 field.
	PWR_PUCRA_PU7_Msk = 0x80
	// Bit PU7.
	PWR_PUCRA_PU7 = 0x80
	// Position of PU6 field.
	PWR_PUCRA_PU6_Pos = 0x6
	// Bit mask of PU6 field.
	PWR_PUCRA_PU6_Msk = 0x40
	// Bit PU6.
	PWR_PUCRA_PU6 = 0x40
	// Position of PU5 field.
	PWR_PUCRA_PU5_Pos = 0x5
	// Bit mask of PU5 field.
	PWR_PUCRA_PU5_Msk = 0x20
	// Bit PU5.
	PWR_PUCRA_PU5 = 0x20
	// Position of PU4 field.
	PWR_PUCRA_PU4_Pos = 0x4
	// Bit mask of PU4 field.
	PWR_PUCRA_PU4_Msk = 0x10
	// Bit PU4.
	PWR_PUCRA_PU4 = 0x10
	// Position of PU3 field.
	PWR_PUCRA_PU3_Pos = 0x3
	// Bit mask of PU3 field.
	PWR_PUCRA_PU3_Msk = 0x8
	// Bit PU3.
	PWR_PUCRA_PU3 = 0x8
	// Position of PU2 field.
	PWR_PUCRA_PU2_Pos = 0x2
	// Bit mask of PU2 field.
	PWR_PUCRA_PU2_Msk = 0x4
	// Bit PU2.
	PWR_PUCRA_PU2 = 0x4
	// Position of PU1 field.
	PWR_PUCRA_PU1_Pos = 0x1
	// Bit mask of PU1 field.
	PWR_PUCRA_PU1_Msk = 0x2
	// Bit PU1.
	PWR_PUCRA_PU1 = 0x2
	// Position of PU0 field.
	PWR_PUCRA_PU0_Pos = 0x0
	// Bit mask of PU0 field.
	PWR_PUCRA_PU0_Msk = 0x1
	// Bit PU0.
	PWR_PUCRA_PU0 = 0x1

	// PDCRA: Power Port A pull-down control register
	// Position of PD15 field.
	PWR_PDCRA_PD15_Pos = 0xf
	// Bit mask of PD15 field.
	PWR_PDCRA_PD15_Msk = 0x8000
	// Bit PD15.
	PWR_PDCRA_PD15 = 0x8000
	// Position of PD14 field.
	PWR_PDCRA_PD14_Pos = 0xe
	// Bit mask of PD14 field.
	PWR_PDCRA_PD14_Msk = 0x4000
	// Bit PD14.
	PWR_PDCRA_PD14 = 0x4000
	// Position of PD13 field.
	PWR_PDCRA_PD13_Pos = 0xd
	// Bit mask of PD13 field.
	PWR_PDCRA_PD13_Msk = 0x2000
	// Bit PD13.
	PWR_PDCRA_PD13 = 0x2000
	// Position of PD12 field.
	PWR_PDCRA_PD12_Pos = 0xc
	// Bit mask of PD12 field.
	PWR_PDCRA_PD12_Msk = 0x1000
	// Bit PD12.
	PWR_PDCRA_PD12 = 0x1000
	// Position of PD11 field.
	PWR_PDCRA_PD11_Pos = 0xb
	// Bit mask of PD11 field.
	PWR_PDCRA_PD11_Msk = 0x800
	// Bit PD11.
	PWR_PDCRA_PD11 = 0x800
	// Position of PD10 field.
	PWR_PDCRA_PD10_Pos = 0xa
	// Bit mask of PD10 field.
	PWR_PDCRA_PD10_Msk = 0x400
	// Bit PD10.
	PWR_PDCRA_PD10 = 0x400
	// Position of PD9 field.
	PWR_PDCRA_PD9_Pos = 0x9
	// Bit mask of PD9 field.
	PWR_PDCRA_PD9_Msk = 0x200
	// Bit PD9.
	PWR_PDCRA_PD9 = 0x200
	// Position of PD8 field.
	PWR_PDCRA_PD8_Pos = 0x8
	// Bit mask of PD8 field.
	PWR_PDCRA_PD8_Msk = 0x100
	// Bit PD8.
	PWR_PDCRA_PD8 = 0x100
	// Position of PD7 field.
	PWR_PDCRA_PD7_Pos = 0x7
	// Bit mask of PD7 field.
	PWR_PDCRA_PD7_Msk = 0x80
	// Bit PD7.
	PWR_PDCRA_PD7 = 0x80
	// Position of PD6 field.
	PWR_PDCRA_PD6_Pos = 0x6
	// Bit mask of PD6 field.
	PWR_PDCRA_PD6_Msk = 0x40
	// Bit PD6.
	PWR_PDCRA_PD6 = 0x40
	// Position of PD5 field.
	PWR_PDCRA_PD5_Pos = 0x5
	// Bit mask of PD5 field.
	PWR_PDCRA_PD5_Msk = 0x20
	// Bit PD5.
	PWR_PDCRA_PD5 = 0x20
	// Position of PD4 field.
	PWR_PDCRA_PD4_Pos = 0x4
	// Bit mask of PD4 field.
	PWR_PDCRA_PD4_Msk = 0x10
	// Bit PD4.
	PWR_PDCRA_PD4 = 0x10
	// Position of PD3 field.
	PWR_PDCRA_PD3_Pos = 0x3
	// Bit mask of PD3 field.
	PWR_PDCRA_PD3_Msk = 0x8
	// Bit PD3.
	PWR_PDCRA_PD3 = 0x8
	// Position of PD2 field.
	PWR_PDCRA_PD2_Pos = 0x2
	// Bit mask of PD2 field.
	PWR_PDCRA_PD2_Msk = 0x4
	// Bit PD2.
	PWR_PDCRA_PD2 = 0x4
	// Position of PD1 field.
	PWR_PDCRA_PD1_Pos = 0x1
	// Bit mask of PD1 field.
	PWR_PDCRA_PD1_Msk = 0x2
	// Bit PD1.
	PWR_PDCRA_PD1 = 0x2
	// Position of PD0 field.
	PWR_PDCRA_PD0_Pos = 0x0
	// Bit mask of PD0 field.
	PWR_PDCRA_PD0_Msk = 0x1
	// Bit PD0.
	PWR_PDCRA_PD0 = 0x1

	// PUCRB: Power Port B pull-up control register
	// Position of PU15 field.
	PWR_PUCRB_PU15_Pos = 0xf
	// Bit mask of PU15 field.
	PWR_PUCRB_PU15_Msk = 0x8000
	// Bit PU15.
	PWR_PUCRB_PU15 = 0x8000
	// Position of PU14 field.
	PWR_PUCRB_PU14_Pos = 0xe
	// Bit mask of PU14 field.
	PWR_PUCRB_PU14_Msk = 0x4000
	// Bit PU14.
	PWR_PUCRB_PU14 = 0x4000
	// Position of PU13 field.
	PWR_PUCRB_PU13_Pos = 0xd
	// Bit mask of PU13 field.
	PWR_PUCRB_PU13_Msk = 0x2000
	// Bit PU13.
	PWR_PUCRB_PU13 = 0x2000
	// Position of PU12 field.
	PWR_PUCRB_PU12_Pos = 0xc
	// Bit mask of PU12 field.
	PWR_PUCRB_PU12_Msk = 0x1000
	// Bit PU12.
	PWR_PUCRB_PU12 = 0x1000
	// Position of PU11 field.
	PWR_PUCRB_PU11_Pos = 0xb
	// Bit mask of PU11 field.
	PWR_PUCRB_PU11_Msk = 0x800
	// Bit PU11.
	PWR_PUCRB_PU11 = 0x800
	// Position of PU10 field.
	PWR_PUCRB_PU10_Pos = 0xa
	// Bit mask of PU10 field.
	PWR_PUCRB_PU10_Msk = 0x400
	// Bit PU10.
	PWR_PUCRB_PU10 = 0x400
	// Position of PU9 field.
	PWR_PUCRB_PU9_Pos = 0x9
	// Bit mask of PU9 field.
	PWR_PUCRB_PU9_Msk = 0x200
	// Bit PU9.
	PWR_PUCRB_PU9 = 0x200
	// Position of PU8 field.
	PWR_PUCRB_PU8_Pos = 0x8
	// Bit mask of PU8 field.
	PWR_PUCRB_PU8_Msk = 0x100
	// Bit PU8.
	PWR_PUCRB_PU8 = 0x100
	// Position of PU7 field.
	PWR_PUCRB_PU7_Pos = 0x7
	// Bit mask of PU7 field.
	PWR_PUCRB_PU7_Msk = 0x80
	// Bit PU7.
	PWR_PUCRB_PU7 = 0x80
	// Position of PU6 field.
	PWR_PUCRB_PU6_Pos = 0x6
	// Bit mask of PU6 field.
	PWR_PUCRB_PU6_Msk = 0x40
	// Bit PU6.
	PWR_PUCRB_PU6 = 0x40
	// Position of PU5 field.
	PWR_PUCRB_PU5_Pos = 0x5
	// Bit mask of PU5 field.
	PWR_PUCRB_PU5_Msk = 0x20
	// Bit PU5.
	PWR_PUCRB_PU5 = 0x20
	// Position of PU4 field.
	PWR_PUCRB_PU4_Pos = 0x4
	// Bit mask of PU4 field.
	PWR_PUCRB_PU4_Msk = 0x10
	// Bit PU4.
	PWR_PUCRB_PU4 = 0x10
	// Position of PU3 field.
	PWR_PUCRB_PU3_Pos = 0x3
	// Bit mask of PU3 field.
	PWR_PUCRB_PU3_Msk = 0x8
	// Bit PU3.
	PWR_PUCRB_PU3 = 0x8
	// Position of PU2 field.
	PWR_PUCRB_PU2_Pos = 0x2
	// Bit mask of PU2 field.
	PWR_PUCRB_PU2_Msk = 0x4
	// Bit PU2.
	PWR_PUCRB_PU2 = 0x4
	// Position of PU1 field.
	PWR_PUCRB_PU1_Pos = 0x1
	// Bit mask of PU1 field.
	PWR_PUCRB_PU1_Msk = 0x2
	// Bit PU1.
	PWR_PUCRB_PU1 = 0x2
	// Position of PU0 field.
	PWR_PUCRB_PU0_Pos = 0x0
	// Bit mask of PU0 field.
	PWR_PUCRB_PU0_Msk = 0x1
	// Bit PU0.
	PWR_PUCRB_PU0 = 0x1

	// PDCRB: Power Port B pull-down control register
	// Position of PD15 field.
	PWR_PDCRB_PD15_Pos = 0xf
	// Bit mask of PD15 field.
	PWR_PDCRB_PD15_Msk = 0x8000
	// Bit PD15.
	PWR_PDCRB_PD15 = 0x8000
	// Position of PD14 field.
	PWR_PDCRB_PD14_Pos = 0xe
	// Bit mask of PD14 field.
	PWR_PDCRB_PD14_Msk = 0x4000
	// Bit PD14.
	PWR_PDCRB_PD14 = 0x4000
	// Position of PD13 field.
	PWR_PDCRB_PD13_Pos = 0xd
	// Bit mask of PD13 field.
	PWR_PDCRB_PD13_Msk = 0x2000
	// Bit PD13.
	PWR_PDCRB_PD13 = 0x2000
	// Position of PD12 field.
	PWR_PDCRB_PD12_Pos = 0xc
	// Bit mask of PD12 field.
	PWR_PDCRB_PD12_Msk = 0x1000
	// Bit PD12.
	PWR_PDCRB_PD12 = 0x1000
	// Position of PD11 field.
	PWR_PDCRB_PD11_Pos = 0xb
	// Bit mask of PD11 field.
	PWR_PDCRB_PD11_Msk = 0x800
	// Bit PD11.
	PWR_PDCRB_PD11 = 0x800
	// Position of PD10 field.
	PWR_PDCRB_PD10_Pos = 0xa
	// Bit mask of PD10 field.
	PWR_PDCRB_PD10_Msk = 0x400
	// Bit PD10.
	PWR_PDCRB_PD10 = 0x400
	// Position of PD9 field.
	PWR_PDCRB_PD9_Pos = 0x9
	// Bit mask of PD9 field.
	PWR_PDCRB_PD9_Msk = 0x200
	// Bit PD9.
	PWR_PDCRB_PD9 = 0x200
	// Position of PD8 field.
	PWR_PDCRB_PD8_Pos = 0x8
	// Bit mask of PD8 field.
	PWR_PDCRB_PD8_Msk = 0x100
	// Bit PD8.
	PWR_PDCRB_PD8 = 0x100
	// Position of PD7 field.
	PWR_PDCRB_PD7_Pos = 0x7
	// Bit mask of PD7 field.
	PWR_PDCRB_PD7_Msk = 0x80
	// Bit PD7.
	PWR_PDCRB_PD7 = 0x80
	// Position of PD6 field.
	PWR_PDCRB_PD6_Pos = 0x6
	// Bit mask of PD6 field.
	PWR_PDCRB_PD6_Msk = 0x40
	// Bit PD6.
	PWR_PDCRB_PD6 = 0x40
	// Position of PD5 field.
	PWR_PDCRB_PD5_Pos = 0x5
	// Bit mask of PD5 field.
	PWR_PDCRB_PD5_Msk = 0x20
	// Bit PD5.
	PWR_PDCRB_PD5 = 0x20
	// Position of PD4 field.
	PWR_PDCRB_PD4_Pos = 0x4
	// Bit mask of PD4 field.
	PWR_PDCRB_PD4_Msk = 0x10
	// Bit PD4.
	PWR_PDCRB_PD4 = 0x10
	// Position of PD3 field.
	PWR_PDCRB_PD3_Pos = 0x3
	// Bit mask of PD3 field.
	PWR_PDCRB_PD3_Msk = 0x8
	// Bit PD3.
	PWR_PDCRB_PD3 = 0x8
	// Position of PD2 field.
	PWR_PDCRB_PD2_Pos = 0x2
	// Bit mask of PD2 field.
	PWR_PDCRB_PD2_Msk = 0x4
	// Bit PD2.
	PWR_PDCRB_PD2 = 0x4
	// Position of PD1 field.
	PWR_PDCRB_PD1_Pos = 0x1
	// Bit mask of PD1 field.
	PWR_PDCRB_PD1_Msk = 0x2
	// Bit PD1.
	PWR_PDCRB_PD1 = 0x2
	// Position of PD0 field.
	PWR_PDCRB_PD0_Pos = 0x0
	// Bit mask of PD0 field.
	PWR_PDCRB_PD0_Msk = 0x1
	// Bit PD0.
	PWR_PDCRB_PD0 = 0x1

	// PUCRC: Power Port C pull-up control register
	// Position of PU15 field.
	PWR_PUCRC_PU15_Pos = 0xf
	// Bit mask of PU15 field.
	PWR_PUCRC_PU15_Msk = 0x8000
	// Bit PU15.
	PWR_PUCRC_PU15 = 0x8000
	// Position of PU14 field.
	PWR_PUCRC_PU14_Pos = 0xe
	// Bit mask of PU14 field.
	PWR_PUCRC_PU14_Msk = 0x4000
	// Bit PU14.
	PWR_PUCRC_PU14 = 0x4000
	// Position of PU13 field.
	PWR_PUCRC_PU13_Pos = 0xd
	// Bit mask of PU13 field.
	PWR_PUCRC_PU13_Msk = 0x2000
	// Bit PU13.
	PWR_PUCRC_PU13 = 0x2000
	// Position of PU7 field.
	PWR_PUCRC_PU7_Pos = 0x7
	// Bit mask of PU7 field.
	PWR_PUCRC_PU7_Msk = 0x80
	// Bit PU7.
	PWR_PUCRC_PU7 = 0x80
	// Position of PU6 field.
	PWR_PUCRC_PU6_Pos = 0x6
	// Bit mask of PU6 field.
	PWR_PUCRC_PU6_Msk = 0x40
	// Bit PU6.
	PWR_PUCRC_PU6 = 0x40

	// PDCRC: Power Port C pull-down control register
	// Position of PD15 field.
	PWR_PDCRC_PD15_Pos = 0xf
	// Bit mask of PD15 field.
	PWR_PDCRC_PD15_Msk = 0x8000
	// Bit PD15.
	PWR_PDCRC_PD15 = 0x8000
	// Position of PD14 field.
	PWR_PDCRC_PD14_Pos = 0xe
	// Bit mask of PD14 field.
	PWR_PDCRC_PD14_Msk = 0x4000
	// Bit PD14.
	PWR_PDCRC_PD14 = 0x4000
	// Position of PD13 field.
	PWR_PDCRC_PD13_Pos = 0xd
	// Bit mask of PD13 field.
	PWR_PDCRC_PD13_Msk = 0x2000
	// Bit PD13.
	PWR_PDCRC_PD13 = 0x2000
	// Position of PD12 field.
	PWR_PDCRC_PD12_Pos = 0xc
	// Bit mask of PD12 field.
	PWR_PDCRC_PD12_Msk = 0x1000
	// Bit PD12.
	PWR_PDCRC_PD12 = 0x1000
	// Position of PD11 field.
	PWR_PDCRC_PD11_Pos = 0xb
	// Bit mask of PD11 field.
	PWR_PDCRC_PD11_Msk = 0x800
	// Bit PD11.
	PWR_PDCRC_PD11 = 0x800
	// Position of PD10 field.
	PWR_PDCRC_PD10_Pos = 0xa
	// Bit mask of PD10 field.
	PWR_PDCRC_PD10_Msk = 0x400
	// Bit PD10.
	PWR_PDCRC_PD10 = 0x400
	// Position of PD9 field.
	PWR_PDCRC_PD9_Pos = 0x9
	// Bit mask of PD9 field.
	PWR_PDCRC_PD9_Msk = 0x200
	// Bit PD9.
	PWR_PDCRC_PD9 = 0x200
	// Position of PD8 field.
	PWR_PDCRC_PD8_Pos = 0x8
	// Bit mask of PD8 field.
	PWR_PDCRC_PD8_Msk = 0x100
	// Bit PD8.
	PWR_PDCRC_PD8 = 0x100
	// Position of PD7 field.
	PWR_PDCRC_PD7_Pos = 0x7
	// Bit mask of PD7 field.
	PWR_PDCRC_PD7_Msk = 0x80
	// Bit PD7.
	PWR_PDCRC_PD7 = 0x80
	// Position of PD6 field.
	PWR_PDCRC_PD6_Pos = 0x6
	// Bit mask of PD6 field.
	PWR_PDCRC_PD6_Msk = 0x40
	// Bit PD6.
	PWR_PDCRC_PD6 = 0x40
	// Position of PD5 field.
	PWR_PDCRC_PD5_Pos = 0x5
	// Bit mask of PD5 field.
	PWR_PDCRC_PD5_Msk = 0x20
	// Bit PD5.
	PWR_PDCRC_PD5 = 0x20
	// Position of PD4 field.
	PWR_PDCRC_PD4_Pos = 0x4
	// Bit mask of PD4 field.
	PWR_PDCRC_PD4_Msk = 0x10
	// Bit PD4.
	PWR_PDCRC_PD4 = 0x10
	// Position of PD3 field.
	PWR_PDCRC_PD3_Pos = 0x3
	// Bit mask of PD3 field.
	PWR_PDCRC_PD3_Msk = 0x8
	// Bit PD3.
	PWR_PDCRC_PD3 = 0x8
	// Position of PD2 field.
	PWR_PDCRC_PD2_Pos = 0x2
	// Bit mask of PD2 field.
	PWR_PDCRC_PD2_Msk = 0x4
	// Bit PD2.
	PWR_PDCRC_PD2 = 0x4
	// Position of PD1 field.
	PWR_PDCRC_PD1_Pos = 0x1
	// Bit mask of PD1 field.
	PWR_PDCRC_PD1_Msk = 0x2
	// Bit PD1.
	PWR_PDCRC_PD1 = 0x2
	// Position of PD0 field.
	PWR_PDCRC_PD0_Pos = 0x0
	// Bit mask of PD0 field.
	PWR_PDCRC_PD0_Msk = 0x1
	// Bit PD0.
	PWR_PDCRC_PD0 = 0x1

	// PUCRD: Power Port D pull-up control register
	// Position of PU3 field.
	PWR_PUCRD_PU3_Pos = 0x3
	// Bit mask of PU3 field.
	PWR_PUCRD_PU3_Msk = 0x8
	// Bit PU3.
	PWR_PUCRD_PU3 = 0x8
	// Position of PU2 field.
	PWR_PUCRD_PU2_Pos = 0x2
	// Bit mask of PU2 field.
	PWR_PUCRD_PU2_Msk = 0x4
	// Bit PU2.
	PWR_PUCRD_PU2 = 0x4
	// Position of PU1 field.
	PWR_PUCRD_PU1_Pos = 0x1
	// Bit mask of PU1 field.
	PWR_PUCRD_PU1_Msk = 0x2
	// Bit PU1.
	PWR_PUCRD_PU1 = 0x2
	// Position of PU0 field.
	PWR_PUCRD_PU0_Pos = 0x0
	// Bit mask of PU0 field.
	PWR_PUCRD_PU0_Msk = 0x1
	// Bit PU0.
	PWR_PUCRD_PU0 = 0x1

	// PDCRD: Power Port D pull-down control register
	// Position of PD9 field.
	PWR_PDCRD_PD9_Pos = 0x9
	// Bit mask of PD9 field.
	PWR_PDCRD_PD9_Msk = 0x200
	// Bit PD9.
	PWR_PDCRD_PD9 = 0x200
	// Position of PD8 field.
	PWR_PDCRD_PD8_Pos = 0x8
	// Bit mask of PD8 field.
	PWR_PDCRD_PD8_Msk = 0x100
	// Bit PD8.
	PWR_PDCRD_PD8 = 0x100
	// Position of PD6 field.
	PWR_PDCRD_PD6_Pos = 0x6
	// Bit mask of PD6 field.
	PWR_PDCRD_PD6_Msk = 0x40
	// Bit PD6.
	PWR_PDCRD_PD6 = 0x40
	// Position of PD5 field.
	PWR_PDCRD_PD5_Pos = 0x5
	// Bit mask of PD5 field.
	PWR_PDCRD_PD5_Msk = 0x20
	// Bit PD5.
	PWR_PDCRD_PD5 = 0x20
	// Position of PD4 field.
	PWR_PDCRD_PD4_Pos = 0x4
	// Bit mask of PD4 field.
	PWR_PDCRD_PD4_Msk = 0x10
	// Bit PD4.
	PWR_PDCRD_PD4 = 0x10
	// Position of PD3 field.
	PWR_PDCRD_PD3_Pos = 0x3
	// Bit mask of PD3 field.
	PWR_PDCRD_PD3_Msk = 0x8
	// Bit PD3.
	PWR_PDCRD_PD3 = 0x8
	// Position of PD2 field.
	PWR_PDCRD_PD2_Pos = 0x2
	// Bit mask of PD2 field.
	PWR_PDCRD_PD2_Msk = 0x4
	// Bit PD2.
	PWR_PDCRD_PD2 = 0x4
	// Position of PD1 field.
	PWR_PDCRD_PD1_Pos = 0x1
	// Bit mask of PD1 field.
	PWR_PDCRD_PD1_Msk = 0x2
	// Bit PD1.
	PWR_PDCRD_PD1 = 0x2
	// Position of PD0 field.
	PWR_PDCRD_PD0_Pos = 0x0
	// Bit mask of PD0 field.
	PWR_PDCRD_PD0_Msk = 0x1
	// Bit PD0.
	PWR_PDCRD_PD0 = 0x1

	// PUCRF: Power Port F pull-up control register
	// Position of PU2 field.
	PWR_PUCRF_PU2_Pos = 0x2
	// Bit mask of PU2 field.
	PWR_PUCRF_PU2_Msk = 0x4
	// Bit PU2.
	PWR_PUCRF_PU2 = 0x4
	// Position of PU1 field.
	PWR_PUCRF_PU1_Pos = 0x1
	// Bit mask of PU1 field.
	PWR_PUCRF_PU1_Msk = 0x2
	// Bit PU1.
	PWR_PUCRF_PU1 = 0x2
	// Position of PU0 field.
	PWR_PUCRF_PU0_Pos = 0x0
	// Bit mask of PU0 field.
	PWR_PUCRF_PU0_Msk = 0x1
	// Bit PU0.
	PWR_PUCRF_PU0 = 0x1

	// PDCRF: Power Port F pull-down control register
	// Position of PD2 field.
	PWR_PDCRF_PD2_Pos = 0x2
	// Bit mask of PD2 field.
	PWR_PDCRF_PD2_Msk = 0x4
	// Bit PD2.
	PWR_PDCRF_PD2 = 0x4
	// Position of PD1 field.
	PWR_PDCRF_PD1_Pos = 0x1
	// Bit mask of PD1 field.
	PWR_PDCRF_PD1_Msk = 0x2
	// Bit PD1.
	PWR_PDCRF_PD1 = 0x2
	// Position of PD0 field.
	PWR_PDCRF_PD0_Pos = 0x0
	// Bit mask of PD0 field.
	PWR_PDCRF_PD0_Msk = 0x1
	// Bit PD0.
	PWR_PDCRF_PD0 = 0x1
)

// Bitfields for DMA: DMA controller
const (
	// ISR: low interrupt status register
	// Position of GIF1 field.
	DMA_ISR_GIF1_Pos = 0x0
	// Bit mask of GIF1 field.
	DMA_ISR_GIF1_Msk = 0x1
	// Bit GIF1.
	DMA_ISR_GIF1 = 0x1
	// Position of TCIF1 field.
	DMA_ISR_TCIF1_Pos = 0x1
	// Bit mask of TCIF1 field.
	DMA_ISR_TCIF1_Msk = 0x2
	// Bit TCIF1.
	DMA_ISR_TCIF1 = 0x2
	// Position of HTIF1 field.
	DMA_ISR_HTIF1_Pos = 0x2
	// Bit mask of HTIF1 field.
	DMA_ISR_HTIF1_Msk = 0x4
	// Bit HTIF1.
	DMA_ISR_HTIF1 = 0x4
	// Position of TEIF1 field.
	DMA_ISR_TEIF1_Pos = 0x3
	// Bit mask of TEIF1 field.
	DMA_ISR_TEIF1_Msk = 0x8
	// Bit TEIF1.
	DMA_ISR_TEIF1 = 0x8
	// Position of GIF2 field.
	DMA_ISR_GIF2_Pos = 0x4
	// Bit mask of GIF2 field.
	DMA_ISR_GIF2_Msk = 0x10
	// Bit GIF2.
	DMA_ISR_GIF2 = 0x10
	// Position of TCIF2 field.
	DMA_ISR_TCIF2_Pos = 0x5
	// Bit mask of TCIF2 field.
	DMA_ISR_TCIF2_Msk = 0x20
	// Bit TCIF2.
	DMA_ISR_TCIF2 = 0x20
	// Position of HTIF2 field.
	DMA_ISR_HTIF2_Pos = 0x6
	// Bit mask of HTIF2 field.
	DMA_ISR_HTIF2_Msk = 0x40
	// Bit HTIF2.
	DMA_ISR_HTIF2 = 0x40
	// Position of TEIF2 field.
	DMA_ISR_TEIF2_Pos = 0x7
	// Bit mask of TEIF2 field.
	DMA_ISR_TEIF2_Msk = 0x80
	// Bit TEIF2.
	DMA_ISR_TEIF2 = 0x80
	// Position of GIF3 field.
	DMA_ISR_GIF3_Pos = 0x8
	// Bit mask of GIF3 field.
	DMA_ISR_GIF3_Msk = 0x100
	// Bit GIF3.
	DMA_ISR_GIF3 = 0x100
	// Position of TCIF3 field.
	DMA_ISR_TCIF3_Pos = 0x9
	// Bit mask of TCIF3 field.
	DMA_ISR_TCIF3_Msk = 0x200
	// Bit TCIF3.
	DMA_ISR_TCIF3 = 0x200
	// Position of HTIF3 field.
	DMA_ISR_HTIF3_Pos = 0xa
	// Bit mask of HTIF3 field.
	DMA_ISR_HTIF3_Msk = 0x400
	// Bit HTIF3.
	DMA_ISR_HTIF3 = 0x400
	// Position of TEIF3 field.
	DMA_ISR_TEIF3_Pos = 0xb
	// Bit mask of TEIF3 field.
	DMA_ISR_TEIF3_Msk = 0x800
	// Bit TEIF3.
	DMA_ISR_TEIF3 = 0x800
	// Position of GIF4 field.
	DMA_ISR_GIF4_Pos = 0xc
	// Bit mask of GIF4 field.
	DMA_ISR_GIF4_Msk = 0x1000
	// Bit GIF4.
	DMA_ISR_GIF4 = 0x1000
	// Position of TCIF4 field.
	DMA_ISR_TCIF4_Pos = 0xd
	// Bit mask of TCIF4 field.
	DMA_ISR_TCIF4_Msk = 0x2000
	// Bit TCIF4.
	DMA_ISR_TCIF4 = 0x2000
	// Position of HTIF4 field.
	DMA_ISR_HTIF4_Pos = 0xe
	// Bit mask of HTIF4 field.
	DMA_ISR_HTIF4_Msk = 0x4000
	// Bit HTIF4.
	DMA_ISR_HTIF4 = 0x4000
	// Position of TEIF4 field.
	DMA_ISR_TEIF4_Pos = 0xf
	// Bit mask of TEIF4 field.
	DMA_ISR_TEIF4_Msk = 0x8000
	// Bit TEIF4.
	DMA_ISR_TEIF4 = 0x8000
	// Position of GIF5 field.
	DMA_ISR_GIF5_Pos = 0x10
	// Bit mask of GIF5 field.
	DMA_ISR_GIF5_Msk = 0x10000
	// Bit GIF5.
	DMA_ISR_GIF5 = 0x10000
	// Position of TCIF5 field.
	DMA_ISR_TCIF5_Pos = 0x11
	// Bit mask of TCIF5 field.
	DMA_ISR_TCIF5_Msk = 0x20000
	// Bit TCIF5.
	DMA_ISR_TCIF5 = 0x20000
	// Position of HTIF5 field.
	DMA_ISR_HTIF5_Pos = 0x12
	// Bit mask of HTIF5 field.
	DMA_ISR_HTIF5_Msk = 0x40000
	// Bit HTIF5.
	DMA_ISR_HTIF5 = 0x40000
	// Position of TEIF5 field.
	DMA_ISR_TEIF5_Pos = 0x13
	// Bit mask of TEIF5 field.
	DMA_ISR_TEIF5_Msk = 0x80000
	// Bit TEIF5.
	DMA_ISR_TEIF5 = 0x80000

	// IFCR: DMA interrupt flag clear register
	// Position of CGIF1 field.
	DMA_IFCR_CGIF1_Pos = 0x0
	// Bit mask of CGIF1 field.
	DMA_IFCR_CGIF1_Msk = 0x1
	// Bit CGIF1.
	DMA_IFCR_CGIF1 = 0x1
	// Position of CTCIF1 field.
	DMA_IFCR_CTCIF1_Pos = 0x1
	// Bit mask of CTCIF1 field.
	DMA_IFCR_CTCIF1_Msk = 0x2
	// Bit CTCIF1.
	DMA_IFCR_CTCIF1 = 0x2
	// Position of CHTIF1 field.
	DMA_IFCR_CHTIF1_Pos = 0x2
	// Bit mask of CHTIF1 field.
	DMA_IFCR_CHTIF1_Msk = 0x4
	// Bit CHTIF1.
	DMA_IFCR_CHTIF1 = 0x4
	// Position of CTEIF1 field.
	DMA_IFCR_CTEIF1_Pos = 0x3
	// Bit mask of CTEIF1 field.
	DMA_IFCR_CTEIF1_Msk = 0x8
	// Bit CTEIF1.
	DMA_IFCR_CTEIF1 = 0x8
	// Position of CGIF2 field.
	DMA_IFCR_CGIF2_Pos = 0x4
	// Bit mask of CGIF2 field.
	DMA_IFCR_CGIF2_Msk = 0x10
	// Bit CGIF2.
	DMA_IFCR_CGIF2 = 0x10
	// Position of CTCIF2 field.
	DMA_IFCR_CTCIF2_Pos = 0x5
	// Bit mask of CTCIF2 field.
	DMA_IFCR_CTCIF2_Msk = 0x20
	// Bit CTCIF2.
	DMA_IFCR_CTCIF2 = 0x20
	// Position of CHTIF2 field.
	DMA_IFCR_CHTIF2_Pos = 0x6
	// Bit mask of CHTIF2 field.
	DMA_IFCR_CHTIF2_Msk = 0x40
	// Bit CHTIF2.
	DMA_IFCR_CHTIF2 = 0x40
	// Position of CTEIF2 field.
	DMA_IFCR_CTEIF2_Pos = 0x7
	// Bit mask of CTEIF2 field.
	DMA_IFCR_CTEIF2_Msk = 0x80
	// Bit CTEIF2.
	DMA_IFCR_CTEIF2 = 0x80
	// Position of CGIF3 field.
	DMA_IFCR_CGIF3_Pos = 0x8
	// Bit mask of CGIF3 field.
	DMA_IFCR_CGIF3_Msk = 0x100
	// Bit CGIF3.
	DMA_IFCR_CGIF3 = 0x100
	// Position of CTCIF3 field.
	DMA_IFCR_CTCIF3_Pos = 0x9
	// Bit mask of CTCIF3 field.
	DMA_IFCR_CTCIF3_Msk = 0x200
	// Bit CTCIF3.
	DMA_IFCR_CTCIF3 = 0x200
	// Position of CHTIF3 field.
	DMA_IFCR_CHTIF3_Pos = 0xa
	// Bit mask of CHTIF3 field.
	DMA_IFCR_CHTIF3_Msk = 0x400
	// Bit CHTIF3.
	DMA_IFCR_CHTIF3 = 0x400
	// Position of CTEIF3 field.
	DMA_IFCR_CTEIF3_Pos = 0xb
	// Bit mask of CTEIF3 field.
	DMA_IFCR_CTEIF3_Msk = 0x800
	// Bit CTEIF3.
	DMA_IFCR_CTEIF3 = 0x800
	// Position of CGIF4 field.
	DMA_IFCR_CGIF4_Pos = 0xc
	// Bit mask of CGIF4 field.
	DMA_IFCR_CGIF4_Msk = 0x1000
	// Bit CGIF4.
	DMA_IFCR_CGIF4 = 0x1000
	// Position of CTCIF4 field.
	DMA_IFCR_CTCIF4_Pos = 0xd
	// Bit mask of CTCIF4 field.
	DMA_IFCR_CTCIF4_Msk = 0x2000
	// Bit CTCIF4.
	DMA_IFCR_CTCIF4 = 0x2000
	// Position of CHTIF4 field.
	DMA_IFCR_CHTIF4_Pos = 0xe
	// Bit mask of CHTIF4 field.
	DMA_IFCR_CHTIF4_Msk = 0x4000
	// Bit CHTIF4.
	DMA_IFCR_CHTIF4 = 0x4000
	// Position of CTEIF4 field.
	DMA_IFCR_CTEIF4_Pos = 0xf
	// Bit mask of CTEIF4 field.
	DMA_IFCR_CTEIF4_Msk = 0x8000
	// Bit CTEIF4.
	DMA_IFCR_CTEIF4 = 0x8000
	// Position of CGIF5 field.
	DMA_IFCR_CGIF5_Pos = 0x10
	// Bit mask of CGIF5 field.
	DMA_IFCR_CGIF5_Msk = 0x10000
	// Bit CGIF5.
	DMA_IFCR_CGIF5 = 0x10000
	// Position of CTCIF5 field.
	DMA_IFCR_CTCIF5_Pos = 0x11
	// Bit mask of CTCIF5 field.
	DMA_IFCR_CTCIF5_Msk = 0x20000
	// Bit CTCIF5.
	DMA_IFCR_CTCIF5 = 0x20000
	// Position of CHTIF5 field.
	DMA_IFCR_CHTIF5_Pos = 0x12
	// Bit mask of CHTIF5 field.
	DMA_IFCR_CHTIF5_Msk = 0x40000
	// Bit CHTIF5.
	DMA_IFCR_CHTIF5 = 0x40000
	// Position of CTEIF5 field.
	DMA_IFCR_CTEIF5_Pos = 0x13
	// Bit mask of CTEIF5 field.
	DMA_IFCR_CTEIF5_Msk = 0x80000
	// Bit CTEIF5.
	DMA_IFCR_CTEIF5 = 0x80000

	// CH.CR: DMA channel x configuration register
	// Position of EN field.
	DMA_CH_CR_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CH_CR_EN_Msk = 0x1
	// Bit EN.
	DMA_CH_CR_EN = 0x1
	// Position of TCIE field.
	DMA_CH_CR_TCIE_Pos = 0x1
	// Bit mask of TCIE field.
	DMA_CH_CR_TCIE_Msk = 0x2
	// Bit TCIE.
	DMA_CH_CR_TCIE = 0x2
	// Position of HTIE field.
	DMA_CH_CR_HTIE_Pos = 0x2
	// Bit mask of HTIE field.
	DMA_CH_CR_HTIE_Msk = 0x4
	// Bit HTIE.
	DMA_CH_CR_HTIE = 0x4
	// Position of TEIE field.
	DMA_CH_CR_TEIE_Pos = 0x3
	// Bit mask of TEIE field.
	DMA_CH_CR_TEIE_Msk = 0x8
	// Bit TEIE.
	DMA_CH_CR_TEIE = 0x8
	// Position of DIR field.
	DMA_CH_CR_DIR_Pos = 0x4
	// Bit mask of DIR field.
	DMA_CH_CR_DIR_Msk = 0x10
	// Bit DIR.
	DMA_CH_CR_DIR = 0x10
	// Position of CIRC field.
	DMA_CH_CR_CIRC_Pos = 0x5
	// Bit mask of CIRC field.
	DMA_CH_CR_CIRC_Msk = 0x20
	// Bit CIRC.
	DMA_CH_CR_CIRC = 0x20
	// Position of PINC field.
	DMA_CH_CR_PINC_Pos = 0x6
	// Bit mask of PINC field.
	DMA_CH_CR_PINC_Msk = 0x40
	// Bit PINC.
	DMA_CH_CR_PINC = 0x40
	// Position of MINC field.
	DMA_CH_CR_MINC_Pos = 0x7
	// Bit mask of MINC field.
	DMA_CH_CR_MINC_Msk = 0x80
	// Bit MINC.
	DMA_CH_CR_MINC = 0x80
	// Position of PSIZE field.
	DMA_CH_CR_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	DMA_CH_CR_PSIZE_Msk = 0x300
	// Position of MSIZE field.
	DMA_CH_CR_MSIZE_Pos = 0xa
	// Bit mask of MSIZE field.
	DMA_CH_CR_MSIZE_Msk = 0xc00
	// Position of PL field.
	DMA_CH_CR_PL_Pos = 0xc
	// Bit mask of PL field.
	DMA_CH_CR_PL_Msk = 0x3000
	// Position of MEM2MEM field.
	DMA_CH_CR_MEM2MEM_Pos = 0xe
	// Bit mask of MEM2MEM field.
	DMA_CH_CR_MEM2MEM_Msk = 0x4000
	// Bit MEM2MEM.
	DMA_CH_CR_MEM2MEM = 0x4000

	// CH.NDTR: DMA channel x number of data register
	// Position of NDT field.
	DMA_CH_NDTR_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_CH_NDTR_NDT_Msk = 0xffff

	// CH.PAR: DMA channel x peripheral address register
	// Position of PA field.
	DMA_CH_PAR_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_CH_PAR_PA_Msk = 0xffffffff

	// CH.MAR: DMA channel x memory address register
	// Position of MA field.
	DMA_CH_MAR_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA_CH_MAR_MA_Msk = 0xffffffff
)

// Bitfields for DMAMUX: DMAMUX
const (
	// C0CR: DMAMux - DMA request line multiplexer channel x control register
	// Position of DMAREQ_ID field.
	DMAMUX_C0CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C0CR_DMAREQ_ID_Msk = 0xff
	// Position of SOIE field.
	DMAMUX_C0CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C0CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C0CR_SOIE = 0x100
	// Position of EGE field.
	DMAMUX_C0CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C0CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C0CR_EGE = 0x200
	// Position of SE field.
	DMAMUX_C0CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C0CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C0CR_SE = 0x10000
	// Position of SPOL field.
	DMAMUX_C0CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C0CR_SPOL_Msk = 0x60000
	// Position of NBREQ field.
	DMAMUX_C0CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C0CR_NBREQ_Msk = 0xf80000
	// Position of SYNC_ID field.
	DMAMUX_C0CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C0CR_SYNC_ID_Msk = 0x1f000000

	// C1CR: DMAMux - DMA request line multiplexer channel x control register
	// Position of DMAREQ_ID field.
	DMAMUX_C1CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C1CR_DMAREQ_ID_Msk = 0xff
	// Position of SOIE field.
	DMAMUX_C1CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C1CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C1CR_SOIE = 0x100
	// Position of EGE field.
	DMAMUX_C1CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C1CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C1CR_EGE = 0x200
	// Position of SE field.
	DMAMUX_C1CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C1CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C1CR_SE = 0x10000
	// Position of SPOL field.
	DMAMUX_C1CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C1CR_SPOL_Msk = 0x60000
	// Position of NBREQ field.
	DMAMUX_C1CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C1CR_NBREQ_Msk = 0xf80000
	// Position of SYNC_ID field.
	DMAMUX_C1CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C1CR_SYNC_ID_Msk = 0x1f000000

	// C2CR: DMAMux - DMA request line multiplexer channel x control register
	// Position of DMAREQ_ID field.
	DMAMUX_C2CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C2CR_DMAREQ_ID_Msk = 0xff
	// Position of SOIE field.
	DMAMUX_C2CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C2CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C2CR_SOIE = 0x100
	// Position of EGE field.
	DMAMUX_C2CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C2CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C2CR_EGE = 0x200
	// Position of SE field.
	DMAMUX_C2CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C2CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C2CR_SE = 0x10000
	// Position of SPOL field.
	DMAMUX_C2CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C2CR_SPOL_Msk = 0x60000
	// Position of NBREQ field.
	DMAMUX_C2CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C2CR_NBREQ_Msk = 0xf80000
	// Position of SYNC_ID field.
	DMAMUX_C2CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C2CR_SYNC_ID_Msk = 0x1f000000

	// C3CR: DMAMux - DMA request line multiplexer channel x control register
	// Position of DMAREQ_ID field.
	DMAMUX_C3CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C3CR_DMAREQ_ID_Msk = 0xff
	// Position of SOIE field.
	DMAMUX_C3CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C3CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C3CR_SOIE = 0x100
	// Position of EGE field.
	DMAMUX_C3CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C3CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C3CR_EGE = 0x200
	// Position of SE field.
	DMAMUX_C3CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C3CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C3CR_SE = 0x10000
	// Position of SPOL field.
	DMAMUX_C3CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C3CR_SPOL_Msk = 0x60000
	// Position of NBREQ field.
	DMAMUX_C3CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C3CR_NBREQ_Msk = 0xf80000
	// Position of SYNC_ID field.
	DMAMUX_C3CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C3CR_SYNC_ID_Msk = 0x1f000000

	// C4CR: DMAMux - DMA request line multiplexer channel x control register
	// Position of DMAREQ_ID field.
	DMAMUX_C4CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C4CR_DMAREQ_ID_Msk = 0xff
	// Position of SOIE field.
	DMAMUX_C4CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C4CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C4CR_SOIE = 0x100
	// Position of EGE field.
	DMAMUX_C4CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C4CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C4CR_EGE = 0x200
	// Position of SE field.
	DMAMUX_C4CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C4CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C4CR_SE = 0x10000
	// Position of SPOL field.
	DMAMUX_C4CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C4CR_SPOL_Msk = 0x60000
	// Position of NBREQ field.
	DMAMUX_C4CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C4CR_NBREQ_Msk = 0xf80000
	// Position of SYNC_ID field.
	DMAMUX_C4CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C4CR_SYNC_ID_Msk = 0x1f000000

	// C5CR: DMAMux - DMA request line multiplexer channel x control register
	// Position of DMAREQ_ID field.
	DMAMUX_C5CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C5CR_DMAREQ_ID_Msk = 0xff
	// Position of SOIE field.
	DMAMUX_C5CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C5CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C5CR_SOIE = 0x100
	// Position of EGE field.
	DMAMUX_C5CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C5CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C5CR_EGE = 0x200
	// Position of SE field.
	DMAMUX_C5CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C5CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C5CR_SE = 0x10000
	// Position of SPOL field.
	DMAMUX_C5CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C5CR_SPOL_Msk = 0x60000
	// Position of NBREQ field.
	DMAMUX_C5CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C5CR_NBREQ_Msk = 0xf80000
	// Position of SYNC_ID field.
	DMAMUX_C5CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C5CR_SYNC_ID_Msk = 0x1f000000

	// C6CR: DMAMux - DMA request line multiplexer channel x control register
	// Position of DMAREQ_ID field.
	DMAMUX_C6CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C6CR_DMAREQ_ID_Msk = 0xff
	// Position of SOIE field.
	DMAMUX_C6CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C6CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C6CR_SOIE = 0x100
	// Position of EGE field.
	DMAMUX_C6CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C6CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C6CR_EGE = 0x200
	// Position of SE field.
	DMAMUX_C6CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C6CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C6CR_SE = 0x10000
	// Position of SPOL field.
	DMAMUX_C6CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C6CR_SPOL_Msk = 0x60000
	// Position of NBREQ field.
	DMAMUX_C6CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C6CR_NBREQ_Msk = 0xf80000
	// Position of SYNC_ID field.
	DMAMUX_C6CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C6CR_SYNC_ID_Msk = 0x1f000000

	// RG0CR: DMAMux - DMA request generator channel x control register
	// Position of SIG_ID field.
	DMAMUX_RG0CR_SIG_ID_Pos = 0x0
	// Bit mask of SIG_ID field.
	DMAMUX_RG0CR_SIG_ID_Msk = 0x1f
	// Position of OIE field.
	DMAMUX_RG0CR_OIE_Pos = 0x8
	// Bit mask of OIE field.
	DMAMUX_RG0CR_OIE_Msk = 0x100
	// Bit OIE.
	DMAMUX_RG0CR_OIE = 0x100
	// Position of GE field.
	DMAMUX_RG0CR_GE_Pos = 0x10
	// Bit mask of GE field.
	DMAMUX_RG0CR_GE_Msk = 0x10000
	// Bit GE.
	DMAMUX_RG0CR_GE = 0x10000
	// Position of GPOL field.
	DMAMUX_RG0CR_GPOL_Pos = 0x11
	// Bit mask of GPOL field.
	DMAMUX_RG0CR_GPOL_Msk = 0x60000
	// Position of GNBREQ field.
	DMAMUX_RG0CR_GNBREQ_Pos = 0x13
	// Bit mask of GNBREQ field.
	DMAMUX_RG0CR_GNBREQ_Msk = 0xf80000

	// RG1CR: DMAMux - DMA request generator channel x control register
	// Position of SIG_ID field.
	DMAMUX_RG1CR_SIG_ID_Pos = 0x0
	// Bit mask of SIG_ID field.
	DMAMUX_RG1CR_SIG_ID_Msk = 0x1f
	// Position of OIE field.
	DMAMUX_RG1CR_OIE_Pos = 0x8
	// Bit mask of OIE field.
	DMAMUX_RG1CR_OIE_Msk = 0x100
	// Bit OIE.
	DMAMUX_RG1CR_OIE = 0x100
	// Position of GE field.
	DMAMUX_RG1CR_GE_Pos = 0x10
	// Bit mask of GE field.
	DMAMUX_RG1CR_GE_Msk = 0x10000
	// Bit GE.
	DMAMUX_RG1CR_GE = 0x10000
	// Position of GPOL field.
	DMAMUX_RG1CR_GPOL_Pos = 0x11
	// Bit mask of GPOL field.
	DMAMUX_RG1CR_GPOL_Msk = 0x60000
	// Position of GNBREQ field.
	DMAMUX_RG1CR_GNBREQ_Pos = 0x13
	// Bit mask of GNBREQ field.
	DMAMUX_RG1CR_GNBREQ_Msk = 0xf80000

	// RG2CR: DMAMux - DMA request generator channel x control register
	// Position of SIG_ID field.
	DMAMUX_RG2CR_SIG_ID_Pos = 0x0
	// Bit mask of SIG_ID field.
	DMAMUX_RG2CR_SIG_ID_Msk = 0x1f
	// Position of OIE field.
	DMAMUX_RG2CR_OIE_Pos = 0x8
	// Bit mask of OIE field.
	DMAMUX_RG2CR_OIE_Msk = 0x100
	// Bit OIE.
	DMAMUX_RG2CR_OIE = 0x100
	// Position of GE field.
	DMAMUX_RG2CR_GE_Pos = 0x10
	// Bit mask of GE field.
	DMAMUX_RG2CR_GE_Msk = 0x10000
	// Bit GE.
	DMAMUX_RG2CR_GE = 0x10000
	// Position of GPOL field.
	DMAMUX_RG2CR_GPOL_Pos = 0x11
	// Bit mask of GPOL field.
	DMAMUX_RG2CR_GPOL_Msk = 0x60000
	// Position of GNBREQ field.
	DMAMUX_RG2CR_GNBREQ_Pos = 0x13
	// Bit mask of GNBREQ field.
	DMAMUX_RG2CR_GNBREQ_Msk = 0xf80000

	// RG3CR: DMAMux - DMA request generator channel x control register
	// Position of SIG_ID field.
	DMAMUX_RG3CR_SIG_ID_Pos = 0x0
	// Bit mask of SIG_ID field.
	DMAMUX_RG3CR_SIG_ID_Msk = 0x1f
	// Position of OIE field.
	DMAMUX_RG3CR_OIE_Pos = 0x8
	// Bit mask of OIE field.
	DMAMUX_RG3CR_OIE_Msk = 0x100
	// Bit OIE.
	DMAMUX_RG3CR_OIE = 0x100
	// Position of GE field.
	DMAMUX_RG3CR_GE_Pos = 0x10
	// Bit mask of GE field.
	DMAMUX_RG3CR_GE_Msk = 0x10000
	// Bit GE.
	DMAMUX_RG3CR_GE = 0x10000
	// Position of GPOL field.
	DMAMUX_RG3CR_GPOL_Pos = 0x11
	// Bit mask of GPOL field.
	DMAMUX_RG3CR_GPOL_Msk = 0x60000
	// Position of GNBREQ field.
	DMAMUX_RG3CR_GNBREQ_Pos = 0x13
	// Bit mask of GNBREQ field.
	DMAMUX_RG3CR_GNBREQ_Msk = 0xf80000

	// RGSR: DMAMux - DMA request generator status register
	// Position of OF field.
	DMAMUX_RGSR_OF_Pos = 0x0
	// Bit mask of OF field.
	DMAMUX_RGSR_OF_Msk = 0xf

	// RGCFR: DMAMux - DMA request generator clear flag register
	// Position of COF field.
	DMAMUX_RGCFR_COF_Pos = 0x0
	// Bit mask of COF field.
	DMAMUX_RGCFR_COF_Msk = 0xf
)

// Bitfields for GPIOA: General-purpose I/Os
const (
	// MODER: GPIO port mode register
	// Position of MODER15 field.
	GPIO_MODER_MODER15_Pos = 0x1e
	// Bit mask of MODER15 field.
	GPIO_MODER_MODER15_Msk = 0xc0000000
	// Position of MODER14 field.
	GPIO_MODER_MODER14_Pos = 0x1c
	// Bit mask of MODER14 field.
	GPIO_MODER_MODER14_Msk = 0x30000000
	// Position of MODER13 field.
	GPIO_MODER_MODER13_Pos = 0x1a
	// Bit mask of MODER13 field.
	GPIO_MODER_MODER13_Msk = 0xc000000
	// Position of MODER12 field.
	GPIO_MODER_MODER12_Pos = 0x18
	// Bit mask of MODER12 field.
	GPIO_MODER_MODER12_Msk = 0x3000000
	// Position of MODER11 field.
	GPIO_MODER_MODER11_Pos = 0x16
	// Bit mask of MODER11 field.
	GPIO_MODER_MODER11_Msk = 0xc00000
	// Position of MODER10 field.
	GPIO_MODER_MODER10_Pos = 0x14
	// Bit mask of MODER10 field.
	GPIO_MODER_MODER10_Msk = 0x300000
	// Position of MODER9 field.
	GPIO_MODER_MODER9_Pos = 0x12
	// Bit mask of MODER9 field.
	GPIO_MODER_MODER9_Msk = 0xc0000
	// Position of MODER8 field.
	GPIO_MODER_MODER8_Pos = 0x10
	// Bit mask of MODER8 field.
	GPIO_MODER_MODER8_Msk = 0x30000
	// Position of MODER7 field.
	GPIO_MODER_MODER7_Pos = 0xe
	// Bit mask of MODER7 field.
	GPIO_MODER_MODER7_Msk = 0xc000
	// Position of MODER6 field.
	GPIO_MODER_MODER6_Pos = 0xc
	// Bit mask of MODER6 field.
	GPIO_MODER_MODER6_Msk = 0x3000
	// Position of MODER5 field.
	GPIO_MODER_MODER5_Pos = 0xa
	// Bit mask of MODER5 field.
	GPIO_MODER_MODER5_Msk = 0xc00
	// Position of MODER4 field.
	GPIO_MODER_MODER4_Pos = 0x8
	// Bit mask of MODER4 field.
	GPIO_MODER_MODER4_Msk = 0x300
	// Position of MODER3 field.
	GPIO_MODER_MODER3_Pos = 0x6
	// Bit mask of MODER3 field.
	GPIO_MODER_MODER3_Msk = 0xc0
	// Position of MODER2 field.
	GPIO_MODER_MODER2_Pos = 0x4
	// Bit mask of MODER2 field.
	GPIO_MODER_MODER2_Msk = 0x30
	// Position of MODER1 field.
	GPIO_MODER_MODER1_Pos = 0x2
	// Bit mask of MODER1 field.
	GPIO_MODER_MODER1_Msk = 0xc
	// Position of MODER0 field.
	GPIO_MODER_MODER0_Pos = 0x0
	// Bit mask of MODER0 field.
	GPIO_MODER_MODER0_Msk = 0x3

	// OTYPER: GPIO port output type register
	// Position of OT15 field.
	GPIO_OTYPER_OT15_Pos = 0xf
	// Bit mask of OT15 field.
	GPIO_OTYPER_OT15_Msk = 0x8000
	// Bit OT15.
	GPIO_OTYPER_OT15 = 0x8000
	// Position of OT14 field.
	GPIO_OTYPER_OT14_Pos = 0xe
	// Bit mask of OT14 field.
	GPIO_OTYPER_OT14_Msk = 0x4000
	// Bit OT14.
	GPIO_OTYPER_OT14 = 0x4000
	// Position of OT13 field.
	GPIO_OTYPER_OT13_Pos = 0xd
	// Bit mask of OT13 field.
	GPIO_OTYPER_OT13_Msk = 0x2000
	// Bit OT13.
	GPIO_OTYPER_OT13 = 0x2000
	// Position of OT12 field.
	GPIO_OTYPER_OT12_Pos = 0xc
	// Bit mask of OT12 field.
	GPIO_OTYPER_OT12_Msk = 0x1000
	// Bit OT12.
	GPIO_OTYPER_OT12 = 0x1000
	// Position of OT11 field.
	GPIO_OTYPER_OT11_Pos = 0xb
	// Bit mask of OT11 field.
	GPIO_OTYPER_OT11_Msk = 0x800
	// Bit OT11.
	GPIO_OTYPER_OT11 = 0x800
	// Position of OT10 field.
	GPIO_OTYPER_OT10_Pos = 0xa
	// Bit mask of OT10 field.
	GPIO_OTYPER_OT10_Msk = 0x400
	// Bit OT10.
	GPIO_OTYPER_OT10 = 0x400
	// Position of OT9 field.
	GPIO_OTYPER_OT9_Pos = 0x9
	// Bit mask of OT9 field.
	GPIO_OTYPER_OT9_Msk = 0x200
	// Bit OT9.
	GPIO_OTYPER_OT9 = 0x200
	// Position of OT8 field.
	GPIO_OTYPER_OT8_Pos = 0x8
	// Bit mask of OT8 field.
	GPIO_OTYPER_OT8_Msk = 0x100
	// Bit OT8.
	GPIO_OTYPER_OT8 = 0x100
	// Position of OT7 field.
	GPIO_OTYPER_OT7_Pos = 0x7
	// Bit mask of OT7 field.
	GPIO_OTYPER_OT7_Msk = 0x80
	// Bit OT7.
	GPIO_OTYPER_OT7 = 0x80
	// Position of OT6 field.
	GPIO_OTYPER_OT6_Pos = 0x6
	// Bit mask of OT6 field.
	GPIO_OTYPER_OT6_Msk = 0x40
	// Bit OT6.
	GPIO_OTYPER_OT6 = 0x40
	// Position of OT5 field.
	GPIO_OTYPER_OT5_Pos = 0x5
	// Bit mask of OT5 field.
	GPIO_OTYPER_OT5_Msk = 0x20
	// Bit OT5.
	GPIO_OTYPER_OT5 = 0x20
	// Position of OT4 field.
	GPIO_OTYPER_OT4_Pos = 0x4
	// Bit mask of OT4 field.
	GPIO_OTYPER_OT4_Msk = 0x10
	// Bit OT4.
	GPIO_OTYPER_OT4 = 0x10
	// Position of OT3 field.
	GPIO_OTYPER_OT3_Pos = 0x3
	// Bit mask of OT3 field.
	GPIO_OTYPER_OT3_Msk = 0x8
	// Bit OT3.
	GPIO_OTYPER_OT3 = 0x8
	// Position of OT2 field.
	GPIO_OTYPER_OT2_Pos = 0x2
	// Bit mask of OT2 field.
	GPIO_OTYPER_OT2_Msk = 0x4
	// Bit OT2.
	GPIO_OTYPER_OT2 = 0x4
	// Position of OT1 field.
	GPIO_OTYPER_OT1_Pos = 0x1
	// Bit mask of OT1 field.
	GPIO_OTYPER_OT1_Msk = 0x2
	// Bit OT1.
	GPIO_OTYPER_OT1 = 0x2
	// Position of OT0 field.
	GPIO_OTYPER_OT0_Pos = 0x0
	// Bit mask of OT0 field.
	GPIO_OTYPER_OT0_Msk = 0x1
	// Bit OT0.
	GPIO_OTYPER_OT0 = 0x1

	// OSPEEDR: GPIO port output speed register
	// Position of OSPEEDR15 field.
	GPIO_OSPEEDR_OSPEEDR15_Pos = 0x1e
	// Bit mask of OSPEEDR15 field.
	GPIO_OSPEEDR_OSPEEDR15_Msk = 0xc0000000
	// Position of OSPEEDR14 field.
	GPIO_OSPEEDR_OSPEEDR14_Pos = 0x1c
	// Bit mask of OSPEEDR14 field.
	GPIO_OSPEEDR_OSPEEDR14_Msk = 0x30000000
	// Position of OSPEEDR13 field.
	GPIO_OSPEEDR_OSPEEDR13_Pos = 0x1a
	// Bit mask of OSPEEDR13 field.
	GPIO_OSPEEDR_OSPEEDR13_Msk = 0xc000000
	// Position of OSPEEDR12 field.
	GPIO_OSPEEDR_OSPEEDR12_Pos = 0x18
	// Bit mask of OSPEEDR12 field.
	GPIO_OSPEEDR_OSPEEDR12_Msk = 0x3000000
	// Position of OSPEEDR11 field.
	GPIO_OSPEEDR_OSPEEDR11_Pos = 0x16
	// Bit mask of OSPEEDR11 field.
	GPIO_OSPEEDR_OSPEEDR11_Msk = 0xc00000
	// Position of OSPEEDR10 field.
	GPIO_OSPEEDR_OSPEEDR10_Pos = 0x14
	// Bit mask of OSPEEDR10 field.
	GPIO_OSPEEDR_OSPEEDR10_Msk = 0x300000
	// Position of OSPEEDR9 field.
	GPIO_OSPEEDR_OSPEEDR9_Pos = 0x12
	// Bit mask of OSPEEDR9 field.
	GPIO_OSPEEDR_OSPEEDR9_Msk = 0xc0000
	// Position of OSPEEDR8 field.
	GPIO_OSPEEDR_OSPEEDR8_Pos = 0x10
	// Bit mask of OSPEEDR8 field.
	GPIO_OSPEEDR_OSPEEDR8_Msk = 0x30000
	// Position of OSPEEDR7 field.
	GPIO_OSPEEDR_OSPEEDR7_Pos = 0xe
	// Bit mask of OSPEEDR7 field.
	GPIO_OSPEEDR_OSPEEDR7_Msk = 0xc000
	// Position of OSPEEDR6 field.
	GPIO_OSPEEDR_OSPEEDR6_Pos = 0xc
	// Bit mask of OSPEEDR6 field.
	GPIO_OSPEEDR_OSPEEDR6_Msk = 0x3000
	// Position of OSPEEDR5 field.
	GPIO_OSPEEDR_OSPEEDR5_Pos = 0xa
	// Bit mask of OSPEEDR5 field.
	GPIO_OSPEEDR_OSPEEDR5_Msk = 0xc00
	// Position of OSPEEDR4 field.
	GPIO_OSPEEDR_OSPEEDR4_Pos = 0x8
	// Bit mask of OSPEEDR4 field.
	GPIO_OSPEEDR_OSPEEDR4_Msk = 0x300
	// Position of OSPEEDR3 field.
	GPIO_OSPEEDR_OSPEEDR3_Pos = 0x6
	// Bit mask of OSPEEDR3 field.
	GPIO_OSPEEDR_OSPEEDR3_Msk = 0xc0
	// Position of OSPEEDR2 field.
	GPIO_OSPEEDR_OSPEEDR2_Pos = 0x4
	// Bit mask of OSPEEDR2 field.
	GPIO_OSPEEDR_OSPEEDR2_Msk = 0x30
	// Position of OSPEEDR1 field.
	GPIO_OSPEEDR_OSPEEDR1_Pos = 0x2
	// Bit mask of OSPEEDR1 field.
	GPIO_OSPEEDR_OSPEEDR1_Msk = 0xc
	// Position of OSPEEDR0 field.
	GPIO_OSPEEDR_OSPEEDR0_Pos = 0x0
	// Bit mask of OSPEEDR0 field.
	GPIO_OSPEEDR_OSPEEDR0_Msk = 0x3

	// PUPDR: GPIO port pull-up/pull-down register
	// Position of PUPDR15 field.
	GPIO_PUPDR_PUPDR15_Pos = 0x1e
	// Bit mask of PUPDR15 field.
	GPIO_PUPDR_PUPDR15_Msk = 0xc0000000
	// Position of PUPDR14 field.
	GPIO_PUPDR_PUPDR14_Pos = 0x1c
	// Bit mask of PUPDR14 field.
	GPIO_PUPDR_PUPDR14_Msk = 0x30000000
	// Position of PUPDR13 field.
	GPIO_PUPDR_PUPDR13_Pos = 0x1a
	// Bit mask of PUPDR13 field.
	GPIO_PUPDR_PUPDR13_Msk = 0xc000000
	// Position of PUPDR12 field.
	GPIO_PUPDR_PUPDR12_Pos = 0x18
	// Bit mask of PUPDR12 field.
	GPIO_PUPDR_PUPDR12_Msk = 0x3000000
	// Position of PUPDR11 field.
	GPIO_PUPDR_PUPDR11_Pos = 0x16
	// Bit mask of PUPDR11 field.
	GPIO_PUPDR_PUPDR11_Msk = 0xc00000
	// Position of PUPDR10 field.
	GPIO_PUPDR_PUPDR10_Pos = 0x14
	// Bit mask of PUPDR10 field.
	GPIO_PUPDR_PUPDR10_Msk = 0x300000
	// Position of PUPDR9 field.
	GPIO_PUPDR_PUPDR9_Pos = 0x12
	// Bit mask of PUPDR9 field.
	GPIO_PUPDR_PUPDR9_Msk = 0xc0000
	// Position of PUPDR8 field.
	GPIO_PUPDR_PUPDR8_Pos = 0x10
	// Bit mask of PUPDR8 field.
	GPIO_PUPDR_PUPDR8_Msk = 0x30000
	// Position of PUPDR7 field.
	GPIO_PUPDR_PUPDR7_Pos = 0xe
	// Bit mask of PUPDR7 field.
	GPIO_PUPDR_PUPDR7_Msk = 0xc000
	// Position of PUPDR6 field.
	GPIO_PUPDR_PUPDR6_Pos = 0xc
	// Bit mask of PUPDR6 field.
	GPIO_PUPDR_PUPDR6_Msk = 0x3000
	// Position of PUPDR5 field.
	GPIO_PUPDR_PUPDR5_Pos = 0xa
	// Bit mask of PUPDR5 field.
	GPIO_PUPDR_PUPDR5_Msk = 0xc00
	// Position of PUPDR4 field.
	GPIO_PUPDR_PUPDR4_Pos = 0x8
	// Bit mask of PUPDR4 field.
	GPIO_PUPDR_PUPDR4_Msk = 0x300
	// Position of PUPDR3 field.
	GPIO_PUPDR_PUPDR3_Pos = 0x6
	// Bit mask of PUPDR3 field.
	GPIO_PUPDR_PUPDR3_Msk = 0xc0
	// Position of PUPDR2 field.
	GPIO_PUPDR_PUPDR2_Pos = 0x4
	// Bit mask of PUPDR2 field.
	GPIO_PUPDR_PUPDR2_Msk = 0x30
	// Position of PUPDR1 field.
	GPIO_PUPDR_PUPDR1_Pos = 0x2
	// Bit mask of PUPDR1 field.
	GPIO_PUPDR_PUPDR1_Msk = 0xc
	// Position of PUPDR0 field.
	GPIO_PUPDR_PUPDR0_Pos = 0x0
	// Bit mask of PUPDR0 field.
	GPIO_PUPDR_PUPDR0_Msk = 0x3

	// IDR: GPIO port input data register
	// Position of IDR15 field.
	GPIO_IDR_IDR15_Pos = 0xf
	// Bit mask of IDR15 field.
	GPIO_IDR_IDR15_Msk = 0x8000
	// Bit IDR15.
	GPIO_IDR_IDR15 = 0x8000
	// Position of IDR14 field.
	GPIO_IDR_IDR14_Pos = 0xe
	// Bit mask of IDR14 field.
	GPIO_IDR_IDR14_Msk = 0x4000
	// Bit IDR14.
	GPIO_IDR_IDR14 = 0x4000
	// Position of IDR13 field.
	GPIO_IDR_IDR13_Pos = 0xd
	// Bit mask of IDR13 field.
	GPIO_IDR_IDR13_Msk = 0x2000
	// Bit IDR13.
	GPIO_IDR_IDR13 = 0x2000
	// Position of IDR12 field.
	GPIO_IDR_IDR12_Pos = 0xc
	// Bit mask of IDR12 field.
	GPIO_IDR_IDR12_Msk = 0x1000
	// Bit IDR12.
	GPIO_IDR_IDR12 = 0x1000
	// Position of IDR11 field.
	GPIO_IDR_IDR11_Pos = 0xb
	// Bit mask of IDR11 field.
	GPIO_IDR_IDR11_Msk = 0x800
	// Bit IDR11.
	GPIO_IDR_IDR11 = 0x800
	// Position of IDR10 field.
	GPIO_IDR_IDR10_Pos = 0xa
	// Bit mask of IDR10 field.
	GPIO_IDR_IDR10_Msk = 0x400
	// Bit IDR10.
	GPIO_IDR_IDR10 = 0x400
	// Position of IDR9 field.
	GPIO_IDR_IDR9_Pos = 0x9
	// Bit mask of IDR9 field.
	GPIO_IDR_IDR9_Msk = 0x200
	// Bit IDR9.
	GPIO_IDR_IDR9 = 0x200
	// Position of IDR8 field.
	GPIO_IDR_IDR8_Pos = 0x8
	// Bit mask of IDR8 field.
	GPIO_IDR_IDR8_Msk = 0x100
	// Bit IDR8.
	GPIO_IDR_IDR8 = 0x100
	// Position of IDR7 field.
	GPIO_IDR_IDR7_Pos = 0x7
	// Bit mask of IDR7 field.
	GPIO_IDR_IDR7_Msk = 0x80
	// Bit IDR7.
	GPIO_IDR_IDR7 = 0x80
	// Position of IDR6 field.
	GPIO_IDR_IDR6_Pos = 0x6
	// Bit mask of IDR6 field.
	GPIO_IDR_IDR6_Msk = 0x40
	// Bit IDR6.
	GPIO_IDR_IDR6 = 0x40
	// Position of IDR5 field.
	GPIO_IDR_IDR5_Pos = 0x5
	// Bit mask of IDR5 field.
	GPIO_IDR_IDR5_Msk = 0x20
	// Bit IDR5.
	GPIO_IDR_IDR5 = 0x20
	// Position of IDR4 field.
	GPIO_IDR_IDR4_Pos = 0x4
	// Bit mask of IDR4 field.
	GPIO_IDR_IDR4_Msk = 0x10
	// Bit IDR4.
	GPIO_IDR_IDR4 = 0x10
	// Position of IDR3 field.
	GPIO_IDR_IDR3_Pos = 0x3
	// Bit mask of IDR3 field.
	GPIO_IDR_IDR3_Msk = 0x8
	// Bit IDR3.
	GPIO_IDR_IDR3 = 0x8
	// Position of IDR2 field.
	GPIO_IDR_IDR2_Pos = 0x2
	// Bit mask of IDR2 field.
	GPIO_IDR_IDR2_Msk = 0x4
	// Bit IDR2.
	GPIO_IDR_IDR2 = 0x4
	// Position of IDR1 field.
	GPIO_IDR_IDR1_Pos = 0x1
	// Bit mask of IDR1 field.
	GPIO_IDR_IDR1_Msk = 0x2
	// Bit IDR1.
	GPIO_IDR_IDR1 = 0x2
	// Position of IDR0 field.
	GPIO_IDR_IDR0_Pos = 0x0
	// Bit mask of IDR0 field.
	GPIO_IDR_IDR0_Msk = 0x1
	// Bit IDR0.
	GPIO_IDR_IDR0 = 0x1

	// ODR: GPIO port output data register
	// Position of ODR15 field.
	GPIO_ODR_ODR15_Pos = 0xf
	// Bit mask of ODR15 field.
	GPIO_ODR_ODR15_Msk = 0x8000
	// Bit ODR15.
	GPIO_ODR_ODR15 = 0x8000
	// Position of ODR14 field.
	GPIO_ODR_ODR14_Pos = 0xe
	// Bit mask of ODR14 field.
	GPIO_ODR_ODR14_Msk = 0x4000
	// Bit ODR14.
	GPIO_ODR_ODR14 = 0x4000
	// Position of ODR13 field.
	GPIO_ODR_ODR13_Pos = 0xd
	// Bit mask of ODR13 field.
	GPIO_ODR_ODR13_Msk = 0x2000
	// Bit ODR13.
	GPIO_ODR_ODR13 = 0x2000
	// Position of ODR12 field.
	GPIO_ODR_ODR12_Pos = 0xc
	// Bit mask of ODR12 field.
	GPIO_ODR_ODR12_Msk = 0x1000
	// Bit ODR12.
	GPIO_ODR_ODR12 = 0x1000
	// Position of ODR11 field.
	GPIO_ODR_ODR11_Pos = 0xb
	// Bit mask of ODR11 field.
	GPIO_ODR_ODR11_Msk = 0x800
	// Bit ODR11.
	GPIO_ODR_ODR11 = 0x800
	// Position of ODR10 field.
	GPIO_ODR_ODR10_Pos = 0xa
	// Bit mask of ODR10 field.
	GPIO_ODR_ODR10_Msk = 0x400
	// Bit ODR10.
	GPIO_ODR_ODR10 = 0x400
	// Position of ODR9 field.
	GPIO_ODR_ODR9_Pos = 0x9
	// Bit mask of ODR9 field.
	GPIO_ODR_ODR9_Msk = 0x200
	// Bit ODR9.
	GPIO_ODR_ODR9 = 0x200
	// Position of ODR8 field.
	GPIO_ODR_ODR8_Pos = 0x8
	// Bit mask of ODR8 field.
	GPIO_ODR_ODR8_Msk = 0x100
	// Bit ODR8.
	GPIO_ODR_ODR8 = 0x100
	// Position of ODR7 field.
	GPIO_ODR_ODR7_Pos = 0x7
	// Bit mask of ODR7 field.
	GPIO_ODR_ODR7_Msk = 0x80
	// Bit ODR7.
	GPIO_ODR_ODR7 = 0x80
	// Position of ODR6 field.
	GPIO_ODR_ODR6_Pos = 0x6
	// Bit mask of ODR6 field.
	GPIO_ODR_ODR6_Msk = 0x40
	// Bit ODR6.
	GPIO_ODR_ODR6 = 0x40
	// Position of ODR5 field.
	GPIO_ODR_ODR5_Pos = 0x5
	// Bit mask of ODR5 field.
	GPIO_ODR_ODR5_Msk = 0x20
	// Bit ODR5.
	GPIO_ODR_ODR5 = 0x20
	// Position of ODR4 field.
	GPIO_ODR_ODR4_Pos = 0x4
	// Bit mask of ODR4 field.
	GPIO_ODR_ODR4_Msk = 0x10
	// Bit ODR4.
	GPIO_ODR_ODR4 = 0x10
	// Position of ODR3 field.
	GPIO_ODR_ODR3_Pos = 0x3
	// Bit mask of ODR3 field.
	GPIO_ODR_ODR3_Msk = 0x8
	// Bit ODR3.
	GPIO_ODR_ODR3 = 0x8
	// Position of ODR2 field.
	GPIO_ODR_ODR2_Pos = 0x2
	// Bit mask of ODR2 field.
	GPIO_ODR_ODR2_Msk = 0x4
	// Bit ODR2.
	GPIO_ODR_ODR2 = 0x4
	// Position of ODR1 field.
	GPIO_ODR_ODR1_Pos = 0x1
	// Bit mask of ODR1 field.
	GPIO_ODR_ODR1_Msk = 0x2
	// Bit ODR1.
	GPIO_ODR_ODR1 = 0x2
	// Position of ODR0 field.
	GPIO_ODR_ODR0_Pos = 0x0
	// Bit mask of ODR0 field.
	GPIO_ODR_ODR0_Msk = 0x1
	// Bit ODR0.
	GPIO_ODR_ODR0 = 0x1

	// BSRR: GPIO port bit set/reset register
	// Position of BR15 field.
	GPIO_BSRR_BR15_Pos = 0x1f
	// Bit mask of BR15 field.
	GPIO_BSRR_BR15_Msk = 0x80000000
	// Bit BR15.
	GPIO_BSRR_BR15 = 0x80000000
	// Position of BR14 field.
	GPIO_BSRR_BR14_Pos = 0x1e
	// Bit mask of BR14 field.
	GPIO_BSRR_BR14_Msk = 0x40000000
	// Bit BR14.
	GPIO_BSRR_BR14 = 0x40000000
	// Position of BR13 field.
	GPIO_BSRR_BR13_Pos = 0x1d
	// Bit mask of BR13 field.
	GPIO_BSRR_BR13_Msk = 0x20000000
	// Bit BR13.
	GPIO_BSRR_BR13 = 0x20000000
	// Position of BR12 field.
	GPIO_BSRR_BR12_Pos = 0x1c
	// Bit mask of BR12 field.
	GPIO_BSRR_BR12_Msk = 0x10000000
	// Bit BR12.
	GPIO_BSRR_BR12 = 0x10000000
	// Position of BR11 field.
	GPIO_BSRR_BR11_Pos = 0x1b
	// Bit mask of BR11 field.
	GPIO_BSRR_BR11_Msk = 0x8000000
	// Bit BR11.
	GPIO_BSRR_BR11 = 0x8000000
	// Position of BR10 field.
	GPIO_BSRR_BR10_Pos = 0x1a
	// Bit mask of BR10 field.
	GPIO_BSRR_BR10_Msk = 0x4000000
	// Bit BR10.
	GPIO_BSRR_BR10 = 0x4000000
	// Position of BR9 field.
	GPIO_BSRR_BR9_Pos = 0x19
	// Bit mask of BR9 field.
	GPIO_BSRR_BR9_Msk = 0x2000000
	// Bit BR9.
	GPIO_BSRR_BR9 = 0x2000000
	// Position of BR8 field.
	GPIO_BSRR_BR8_Pos = 0x18
	// Bit mask of BR8 field.
	GPIO_BSRR_BR8_Msk = 0x1000000
	// Bit BR8.
	GPIO_BSRR_BR8 = 0x1000000
	// Position of BR7 field.
	GPIO_BSRR_BR7_Pos = 0x17
	// Bit mask of BR7 field.
	GPIO_BSRR_BR7_Msk = 0x800000
	// Bit BR7.
	GPIO_BSRR_BR7 = 0x800000
	// Position of BR6 field.
	GPIO_BSRR_BR6_Pos = 0x16
	// Bit mask of BR6 field.
	GPIO_BSRR_BR6_Msk = 0x400000
	// Bit BR6.
	GPIO_BSRR_BR6 = 0x400000
	// Position of BR5 field.
	GPIO_BSRR_BR5_Pos = 0x15
	// Bit mask of BR5 field.
	GPIO_BSRR_BR5_Msk = 0x200000
	// Bit BR5.
	GPIO_BSRR_BR5 = 0x200000
	// Position of BR4 field.
	GPIO_BSRR_BR4_Pos = 0x14
	// Bit mask of BR4 field.
	GPIO_BSRR_BR4_Msk = 0x100000
	// Bit BR4.
	GPIO_BSRR_BR4 = 0x100000
	// Position of BR3 field.
	GPIO_BSRR_BR3_Pos = 0x13
	// Bit mask of BR3 field.
	GPIO_BSRR_BR3_Msk = 0x80000
	// Bit BR3.
	GPIO_BSRR_BR3 = 0x80000
	// Position of BR2 field.
	GPIO_BSRR_BR2_Pos = 0x12
	// Bit mask of BR2 field.
	GPIO_BSRR_BR2_Msk = 0x40000
	// Bit BR2.
	GPIO_BSRR_BR2 = 0x40000
	// Position of BR1 field.
	GPIO_BSRR_BR1_Pos = 0x11
	// Bit mask of BR1 field.
	GPIO_BSRR_BR1_Msk = 0x20000
	// Bit BR1.
	GPIO_BSRR_BR1 = 0x20000
	// Position of BR0 field.
	GPIO_BSRR_BR0_Pos = 0x10
	// Bit mask of BR0 field.
	GPIO_BSRR_BR0_Msk = 0x10000
	// Bit BR0.
	GPIO_BSRR_BR0 = 0x10000
	// Position of BS15 field.
	GPIO_BSRR_BS15_Pos = 0xf
	// Bit mask of BS15 field.
	GPIO_BSRR_BS15_Msk = 0x8000
	// Bit BS15.
	GPIO_BSRR_BS15 = 0x8000
	// Position of BS14 field.
	GPIO_BSRR_BS14_Pos = 0xe
	// Bit mask of BS14 field.
	GPIO_BSRR_BS14_Msk = 0x4000
	// Bit BS14.
	GPIO_BSRR_BS14 = 0x4000
	// Position of BS13 field.
	GPIO_BSRR_BS13_Pos = 0xd
	// Bit mask of BS13 field.
	GPIO_BSRR_BS13_Msk = 0x2000
	// Bit BS13.
	GPIO_BSRR_BS13 = 0x2000
	// Position of BS12 field.
	GPIO_BSRR_BS12_Pos = 0xc
	// Bit mask of BS12 field.
	GPIO_BSRR_BS12_Msk = 0x1000
	// Bit BS12.
	GPIO_BSRR_BS12 = 0x1000
	// Position of BS11 field.
	GPIO_BSRR_BS11_Pos = 0xb
	// Bit mask of BS11 field.
	GPIO_BSRR_BS11_Msk = 0x800
	// Bit BS11.
	GPIO_BSRR_BS11 = 0x800
	// Position of BS10 field.
	GPIO_BSRR_BS10_Pos = 0xa
	// Bit mask of BS10 field.
	GPIO_BSRR_BS10_Msk = 0x400
	// Bit BS10.
	GPIO_BSRR_BS10 = 0x400
	// Position of BS9 field.
	GPIO_BSRR_BS9_Pos = 0x9
	// Bit mask of BS9 field.
	GPIO_BSRR_BS9_Msk = 0x200
	// Bit BS9.
	GPIO_BSRR_BS9 = 0x200
	// Position of BS8 field.
	GPIO_BSRR_BS8_Pos = 0x8
	// Bit mask of BS8 field.
	GPIO_BSRR_BS8_Msk = 0x100
	// Bit BS8.
	GPIO_BSRR_BS8 = 0x100
	// Position of BS7 field.
	GPIO_BSRR_BS7_Pos = 0x7
	// Bit mask of BS7 field.
	GPIO_BSRR_BS7_Msk = 0x80
	// Bit BS7.
	GPIO_BSRR_BS7 = 0x80
	// Position of BS6 field.
	GPIO_BSRR_BS6_Pos = 0x6
	// Bit mask of BS6 field.
	GPIO_BSRR_BS6_Msk = 0x40
	// Bit BS6.
	GPIO_BSRR_BS6 = 0x40
	// Position of BS5 field.
	GPIO_BSRR_BS5_Pos = 0x5
	// Bit mask of BS5 field.
	GPIO_BSRR_BS5_Msk = 0x20
	// Bit BS5.
	GPIO_BSRR_BS5 = 0x20
	// Position of BS4 field.
	GPIO_BSRR_BS4_Pos = 0x4
	// Bit mask of BS4 field.
	GPIO_BSRR_BS4_Msk = 0x10
	// Bit BS4.
	GPIO_BSRR_BS4 = 0x10
	// Position of BS3 field.
	GPIO_BSRR_BS3_Pos = 0x3
	// Bit mask of BS3 field.
	GPIO_BSRR_BS3_Msk = 0x8
	// Bit BS3.
	GPIO_BSRR_BS3 = 0x8
	// Position of BS2 field.
	GPIO_BSRR_BS2_Pos = 0x2
	// Bit mask of BS2 field.
	GPIO_BSRR_BS2_Msk = 0x4
	// Bit BS2.
	GPIO_BSRR_BS2 = 0x4
	// Position of BS1 field.
	GPIO_BSRR_BS1_Pos = 0x1
	// Bit mask of BS1 field.
	GPIO_BSRR_BS1_Msk = 0x2
	// Bit BS1.
	GPIO_BSRR_BS1 = 0x2
	// Position of BS0 field.
	GPIO_BSRR_BS0_Pos = 0x0
	// Bit mask of BS0 field.
	GPIO_BSRR_BS0_Msk = 0x1
	// Bit BS0.
	GPIO_BSRR_BS0 = 0x1

	// LCKR: GPIO port configuration lock register
	// Position of LCKK field.
	GPIO_LCKR_LCKK_Pos = 0x10
	// Bit mask of LCKK field.
	GPIO_LCKR_LCKK_Msk = 0x10000
	// Bit LCKK.
	GPIO_LCKR_LCKK = 0x10000
	// Position of LCK15 field.
	GPIO_LCKR_LCK15_Pos = 0xf
	// Bit mask of LCK15 field.
	GPIO_LCKR_LCK15_Msk = 0x8000
	// Bit LCK15.
	GPIO_LCKR_LCK15 = 0x8000
	// Position of LCK14 field.
	GPIO_LCKR_LCK14_Pos = 0xe
	// Bit mask of LCK14 field.
	GPIO_LCKR_LCK14_Msk = 0x4000
	// Bit LCK14.
	GPIO_LCKR_LCK14 = 0x4000
	// Position of LCK13 field.
	GPIO_LCKR_LCK13_Pos = 0xd
	// Bit mask of LCK13 field.
	GPIO_LCKR_LCK13_Msk = 0x2000
	// Bit LCK13.
	GPIO_LCKR_LCK13 = 0x2000
	// Position of LCK12 field.
	GPIO_LCKR_LCK12_Pos = 0xc
	// Bit mask of LCK12 field.
	GPIO_LCKR_LCK12_Msk = 0x1000
	// Bit LCK12.
	GPIO_LCKR_LCK12 = 0x1000
	// Position of LCK11 field.
	GPIO_LCKR_LCK11_Pos = 0xb
	// Bit mask of LCK11 field.
	GPIO_LCKR_LCK11_Msk = 0x800
	// Bit LCK11.
	GPIO_LCKR_LCK11 = 0x800
	// Position of LCK10 field.
	GPIO_LCKR_LCK10_Pos = 0xa
	// Bit mask of LCK10 field.
	GPIO_LCKR_LCK10_Msk = 0x400
	// Bit LCK10.
	GPIO_LCKR_LCK10 = 0x400
	// Position of LCK9 field.
	GPIO_LCKR_LCK9_Pos = 0x9
	// Bit mask of LCK9 field.
	GPIO_LCKR_LCK9_Msk = 0x200
	// Bit LCK9.
	GPIO_LCKR_LCK9 = 0x200
	// Position of LCK8 field.
	GPIO_LCKR_LCK8_Pos = 0x8
	// Bit mask of LCK8 field.
	GPIO_LCKR_LCK8_Msk = 0x100
	// Bit LCK8.
	GPIO_LCKR_LCK8 = 0x100
	// Position of LCK7 field.
	GPIO_LCKR_LCK7_Pos = 0x7
	// Bit mask of LCK7 field.
	GPIO_LCKR_LCK7_Msk = 0x80
	// Bit LCK7.
	GPIO_LCKR_LCK7 = 0x80
	// Position of LCK6 field.
	GPIO_LCKR_LCK6_Pos = 0x6
	// Bit mask of LCK6 field.
	GPIO_LCKR_LCK6_Msk = 0x40
	// Bit LCK6.
	GPIO_LCKR_LCK6 = 0x40
	// Position of LCK5 field.
	GPIO_LCKR_LCK5_Pos = 0x5
	// Bit mask of LCK5 field.
	GPIO_LCKR_LCK5_Msk = 0x20
	// Bit LCK5.
	GPIO_LCKR_LCK5 = 0x20
	// Position of LCK4 field.
	GPIO_LCKR_LCK4_Pos = 0x4
	// Bit mask of LCK4 field.
	GPIO_LCKR_LCK4_Msk = 0x10
	// Bit LCK4.
	GPIO_LCKR_LCK4 = 0x10
	// Position of LCK3 field.
	GPIO_LCKR_LCK3_Pos = 0x3
	// Bit mask of LCK3 field.
	GPIO_LCKR_LCK3_Msk = 0x8
	// Bit LCK3.
	GPIO_LCKR_LCK3 = 0x8
	// Position of LCK2 field.
	GPIO_LCKR_LCK2_Pos = 0x2
	// Bit mask of LCK2 field.
	GPIO_LCKR_LCK2_Msk = 0x4
	// Bit LCK2.
	GPIO_LCKR_LCK2 = 0x4
	// Position of LCK1 field.
	GPIO_LCKR_LCK1_Pos = 0x1
	// Bit mask of LCK1 field.
	GPIO_LCKR_LCK1_Msk = 0x2
	// Bit LCK1.
	GPIO_LCKR_LCK1 = 0x2
	// Position of LCK0 field.
	GPIO_LCKR_LCK0_Pos = 0x0
	// Bit mask of LCK0 field.
	GPIO_LCKR_LCK0_Msk = 0x1
	// Bit LCK0.
	GPIO_LCKR_LCK0 = 0x1

	// AFRL: GPIO alternate function low register
	// Position of AFSEL7 field.
	GPIO_AFRL_AFSEL7_Pos = 0x1c
	// Bit mask of AFSEL7 field.
	GPIO_AFRL_AFSEL7_Msk = 0xf0000000
	// Position of AFSEL6 field.
	GPIO_AFRL_AFSEL6_Pos = 0x18
	// Bit mask of AFSEL6 field.
	GPIO_AFRL_AFSEL6_Msk = 0xf000000
	// Position of AFSEL5 field.
	GPIO_AFRL_AFSEL5_Pos = 0x14
	// Bit mask of AFSEL5 field.
	GPIO_AFRL_AFSEL5_Msk = 0xf00000
	// Position of AFSEL4 field.
	GPIO_AFRL_AFSEL4_Pos = 0x10
	// Bit mask of AFSEL4 field.
	GPIO_AFRL_AFSEL4_Msk = 0xf0000
	// Position of AFSEL3 field.
	GPIO_AFRL_AFSEL3_Pos = 0xc
	// Bit mask of AFSEL3 field.
	GPIO_AFRL_AFSEL3_Msk = 0xf000
	// Position of AFSEL2 field.
	GPIO_AFRL_AFSEL2_Pos = 0x8
	// Bit mask of AFSEL2 field.
	GPIO_AFRL_AFSEL2_Msk = 0xf00
	// Position of AFSEL1 field.
	GPIO_AFRL_AFSEL1_Pos = 0x4
	// Bit mask of AFSEL1 field.
	GPIO_AFRL_AFSEL1_Msk = 0xf0
	// Position of AFSEL0 field.
	GPIO_AFRL_AFSEL0_Pos = 0x0
	// Bit mask of AFSEL0 field.
	GPIO_AFRL_AFSEL0_Msk = 0xf

	// AFRH: GPIO alternate function high register
	// Position of AFSEL15 field.
	GPIO_AFRH_AFSEL15_Pos = 0x1c
	// Bit mask of AFSEL15 field.
	GPIO_AFRH_AFSEL15_Msk = 0xf0000000
	// Position of AFSEL14 field.
	GPIO_AFRH_AFSEL14_Pos = 0x18
	// Bit mask of AFSEL14 field.
	GPIO_AFRH_AFSEL14_Msk = 0xf000000
	// Position of AFSEL13 field.
	GPIO_AFRH_AFSEL13_Pos = 0x14
	// Bit mask of AFSEL13 field.
	GPIO_AFRH_AFSEL13_Msk = 0xf00000
	// Position of AFSEL12 field.
	GPIO_AFRH_AFSEL12_Pos = 0x10
	// Bit mask of AFSEL12 field.
	GPIO_AFRH_AFSEL12_Msk = 0xf0000
	// Position of AFSEL11 field.
	GPIO_AFRH_AFSEL11_Pos = 0xc
	// Bit mask of AFSEL11 field.
	GPIO_AFRH_AFSEL11_Msk = 0xf000
	// Position of AFSEL10 field.
	GPIO_AFRH_AFSEL10_Pos = 0x8
	// Bit mask of AFSEL10 field.
	GPIO_AFRH_AFSEL10_Msk = 0xf00
	// Position of AFSEL9 field.
	GPIO_AFRH_AFSEL9_Pos = 0x4
	// Bit mask of AFSEL9 field.
	GPIO_AFRH_AFSEL9_Msk = 0xf0
	// Position of AFSEL8 field.
	GPIO_AFRH_AFSEL8_Pos = 0x0
	// Bit mask of AFSEL8 field.
	GPIO_AFRH_AFSEL8_Msk = 0xf

	// BRR: port bit reset register
	// Position of BR0 field.
	GPIO_BRR_BR0_Pos = 0x0
	// Bit mask of BR0 field.
	GPIO_BRR_BR0_Msk = 0x1
	// Bit BR0.
	GPIO_BRR_BR0 = 0x1
	// Position of BR1 field.
	GPIO_BRR_BR1_Pos = 0x1
	// Bit mask of BR1 field.
	GPIO_BRR_BR1_Msk = 0x2
	// Bit BR1.
	GPIO_BRR_BR1 = 0x2
	// Position of BR2 field.
	GPIO_BRR_BR2_Pos = 0x2
	// Bit mask of BR2 field.
	GPIO_BRR_BR2_Msk = 0x4
	// Bit BR2.
	GPIO_BRR_BR2 = 0x4
	// Position of BR3 field.
	GPIO_BRR_BR3_Pos = 0x3
	// Bit mask of BR3 field.
	GPIO_BRR_BR3_Msk = 0x8
	// Bit BR3.
	GPIO_BRR_BR3 = 0x8
	// Position of BR4 field.
	GPIO_BRR_BR4_Pos = 0x4
	// Bit mask of BR4 field.
	GPIO_BRR_BR4_Msk = 0x10
	// Bit BR4.
	GPIO_BRR_BR4 = 0x10
	// Position of BR5 field.
	GPIO_BRR_BR5_Pos = 0x5
	// Bit mask of BR5 field.
	GPIO_BRR_BR5_Msk = 0x20
	// Bit BR5.
	GPIO_BRR_BR5 = 0x20
	// Position of BR6 field.
	GPIO_BRR_BR6_Pos = 0x6
	// Bit mask of BR6 field.
	GPIO_BRR_BR6_Msk = 0x40
	// Bit BR6.
	GPIO_BRR_BR6 = 0x40
	// Position of BR7 field.
	GPIO_BRR_BR7_Pos = 0x7
	// Bit mask of BR7 field.
	GPIO_BRR_BR7_Msk = 0x80
	// Bit BR7.
	GPIO_BRR_BR7 = 0x80
	// Position of BR8 field.
	GPIO_BRR_BR8_Pos = 0x8
	// Bit mask of BR8 field.
	GPIO_BRR_BR8_Msk = 0x100
	// Bit BR8.
	GPIO_BRR_BR8 = 0x100
	// Position of BR9 field.
	GPIO_BRR_BR9_Pos = 0x9
	// Bit mask of BR9 field.
	GPIO_BRR_BR9_Msk = 0x200
	// Bit BR9.
	GPIO_BRR_BR9 = 0x200
	// Position of BR10 field.
	GPIO_BRR_BR10_Pos = 0xa
	// Bit mask of BR10 field.
	GPIO_BRR_BR10_Msk = 0x400
	// Bit BR10.
	GPIO_BRR_BR10 = 0x400
	// Position of BR11 field.
	GPIO_BRR_BR11_Pos = 0xb
	// Bit mask of BR11 field.
	GPIO_BRR_BR11_Msk = 0x800
	// Bit BR11.
	GPIO_BRR_BR11 = 0x800
	// Position of BR12 field.
	GPIO_BRR_BR12_Pos = 0xc
	// Bit mask of BR12 field.
	GPIO_BRR_BR12_Msk = 0x1000
	// Bit BR12.
	GPIO_BRR_BR12 = 0x1000
	// Position of BR13 field.
	GPIO_BRR_BR13_Pos = 0xd
	// Bit mask of BR13 field.
	GPIO_BRR_BR13_Msk = 0x2000
	// Bit BR13.
	GPIO_BRR_BR13 = 0x2000
	// Position of BR14 field.
	GPIO_BRR_BR14_Pos = 0xe
	// Bit mask of BR14 field.
	GPIO_BRR_BR14_Msk = 0x4000
	// Bit BR14.
	GPIO_BRR_BR14 = 0x4000
	// Position of BR15 field.
	GPIO_BRR_BR15_Pos = 0xf
	// Bit mask of BR15 field.
	GPIO_BRR_BR15_Msk = 0x8000
	// Bit BR15.
	GPIO_BRR_BR15 = 0x8000
)

// Bitfields for AES: Advanced encryption standard hardware accelerator 1
const (
	// CR: control register
	// Position of NPBLB field.
	AES_CR_NPBLB_Pos = 0x14
	// Bit mask of NPBLB field.
	AES_CR_NPBLB_Msk = 0xf00000
	// Position of KEYSIZE field.
	AES_CR_KEYSIZE_Pos = 0x12
	// Bit mask of KEYSIZE field.
	AES_CR_KEYSIZE_Msk = 0x40000
	// Bit KEYSIZE.
	AES_CR_KEYSIZE = 0x40000
	// Position of CHMOD2 field.
	AES_CR_CHMOD2_Pos = 0x10
	// Bit mask of CHMOD2 field.
	AES_CR_CHMOD2_Msk = 0x10000
	// Bit CHMOD2.
	AES_CR_CHMOD2 = 0x10000
	// Position of GCMPH field.
	AES_CR_GCMPH_Pos = 0xd
	// Bit mask of GCMPH field.
	AES_CR_GCMPH_Msk = 0x6000
	// Position of DMAOUTEN field.
	AES_CR_DMAOUTEN_Pos = 0xc
	// Bit mask of DMAOUTEN field.
	AES_CR_DMAOUTEN_Msk = 0x1000
	// Bit DMAOUTEN.
	AES_CR_DMAOUTEN = 0x1000
	// Position of DMAINEN field.
	AES_CR_DMAINEN_Pos = 0xb
	// Bit mask of DMAINEN field.
	AES_CR_DMAINEN_Msk = 0x800
	// Bit DMAINEN.
	AES_CR_DMAINEN = 0x800
	// Position of ERRIE field.
	AES_CR_ERRIE_Pos = 0xa
	// Bit mask of ERRIE field.
	AES_CR_ERRIE_Msk = 0x400
	// Bit ERRIE.
	AES_CR_ERRIE = 0x400
	// Position of CCFIE field.
	AES_CR_CCFIE_Pos = 0x9
	// Bit mask of CCFIE field.
	AES_CR_CCFIE_Msk = 0x200
	// Bit CCFIE.
	AES_CR_CCFIE = 0x200
	// Position of ERRC field.
	AES_CR_ERRC_Pos = 0x8
	// Bit mask of ERRC field.
	AES_CR_ERRC_Msk = 0x100
	// Bit ERRC.
	AES_CR_ERRC = 0x100
	// Position of CCFC field.
	AES_CR_CCFC_Pos = 0x7
	// Bit mask of CCFC field.
	AES_CR_CCFC_Msk = 0x80
	// Bit CCFC.
	AES_CR_CCFC = 0x80
	// Position of CHMOD10 field.
	AES_CR_CHMOD10_Pos = 0x5
	// Bit mask of CHMOD10 field.
	AES_CR_CHMOD10_Msk = 0x60
	// Position of MODE field.
	AES_CR_MODE_Pos = 0x3
	// Bit mask of MODE field.
	AES_CR_MODE_Msk = 0x18
	// Position of DATATYPE field.
	AES_CR_DATATYPE_Pos = 0x1
	// Bit mask of DATATYPE field.
	AES_CR_DATATYPE_Msk = 0x6
	// Position of EN field.
	AES_CR_EN_Pos = 0x0
	// Bit mask of EN field.
	AES_CR_EN_Msk = 0x1
	// Bit EN.
	AES_CR_EN = 0x1

	// SR: status register
	// Position of BUSY field.
	AES_SR_BUSY_Pos = 0x3
	// Bit mask of BUSY field.
	AES_SR_BUSY_Msk = 0x8
	// Bit BUSY.
	AES_SR_BUSY = 0x8
	// Position of WRERR field.
	AES_SR_WRERR_Pos = 0x2
	// Bit mask of WRERR field.
	AES_SR_WRERR_Msk = 0x4
	// Bit WRERR.
	AES_SR_WRERR = 0x4
	// Position of RDERR field.
	AES_SR_RDERR_Pos = 0x1
	// Bit mask of RDERR field.
	AES_SR_RDERR_Msk = 0x2
	// Bit RDERR.
	AES_SR_RDERR = 0x2
	// Position of CCF field.
	AES_SR_CCF_Pos = 0x0
	// Bit mask of CCF field.
	AES_SR_CCF_Msk = 0x1
	// Bit CCF.
	AES_SR_CCF = 0x1

	// DINR: data input register
	// Position of AES_DINR field.
	AES_DINR_AES_DINR_Pos = 0x0
	// Bit mask of AES_DINR field.
	AES_DINR_AES_DINR_Msk = 0xffffffff

	// DOUTR: data output register
	// Position of AES_DOUTR field.
	AES_DOUTR_AES_DOUTR_Pos = 0x0
	// Bit mask of AES_DOUTR field.
	AES_DOUTR_AES_DOUTR_Msk = 0xffffffff

	// KEYR0: key register 0
	// Position of AES_KEYR0 field.
	AES_KEYR0_AES_KEYR0_Pos = 0x0
	// Bit mask of AES_KEYR0 field.
	AES_KEYR0_AES_KEYR0_Msk = 0xffffffff

	// KEYR1: key register 1
	// Position of AES_KEYR1 field.
	AES_KEYR1_AES_KEYR1_Pos = 0x0
	// Bit mask of AES_KEYR1 field.
	AES_KEYR1_AES_KEYR1_Msk = 0xffffffff

	// KEYR2: key register 2
	// Position of AES_KEYR2 field.
	AES_KEYR2_AES_KEYR2_Pos = 0x0
	// Bit mask of AES_KEYR2 field.
	AES_KEYR2_AES_KEYR2_Msk = 0xffffffff

	// KEYR3: key register 3
	// Position of AES_KEYR3 field.
	AES_KEYR3_AES_KEYR3_Pos = 0x0
	// Bit mask of AES_KEYR3 field.
	AES_KEYR3_AES_KEYR3_Msk = 0xffffffff

	// IVR0: initialization vector register 0
	// Position of AES_IVR0 field.
	AES_IVR0_AES_IVR0_Pos = 0x0
	// Bit mask of AES_IVR0 field.
	AES_IVR0_AES_IVR0_Msk = 0xffffffff

	// IVR1: initialization vector register 1
	// Position of AES_IVR1 field.
	AES_IVR1_AES_IVR1_Pos = 0x0
	// Bit mask of AES_IVR1 field.
	AES_IVR1_AES_IVR1_Msk = 0xffffffff

	// IVR2: initialization vector register 2
	// Position of AES_IVR2 field.
	AES_IVR2_AES_IVR2_Pos = 0x0
	// Bit mask of AES_IVR2 field.
	AES_IVR2_AES_IVR2_Msk = 0xffffffff

	// IVR3: initialization vector register 3
	// Position of AES_IVR3 field.
	AES_IVR3_AES_IVR3_Pos = 0x0
	// Bit mask of AES_IVR3 field.
	AES_IVR3_AES_IVR3_Msk = 0xffffffff

	// KEYR4: key register 4
	// Position of AES_KEYR4 field.
	AES_KEYR4_AES_KEYR4_Pos = 0x0
	// Bit mask of AES_KEYR4 field.
	AES_KEYR4_AES_KEYR4_Msk = 0xffffffff

	// KEYR5: key register 5
	// Position of AES_KEYR5 field.
	AES_KEYR5_AES_KEYR5_Pos = 0x0
	// Bit mask of AES_KEYR5 field.
	AES_KEYR5_AES_KEYR5_Msk = 0xffffffff

	// KEYR6: key register 6
	// Position of AES_KEYR6 field.
	AES_KEYR6_AES_KEYR6_Pos = 0x0
	// Bit mask of AES_KEYR6 field.
	AES_KEYR6_AES_KEYR6_Msk = 0xffffffff

	// KEYR7: key register 7
	// Position of AES_KEYR7 field.
	AES_KEYR7_AES_KEYR7_Pos = 0x0
	// Bit mask of AES_KEYR7 field.
	AES_KEYR7_AES_KEYR7_Msk = 0xffffffff

	// SUSP0R: AES suspend register 0
	// Position of AES_SUSP0R field.
	AES_SUSP0R_AES_SUSP0R_Pos = 0x0
	// Bit mask of AES_SUSP0R field.
	AES_SUSP0R_AES_SUSP0R_Msk = 0xffffffff

	// SUSP1R: AES suspend register 1
	// Position of AES_SUSP1R field.
	AES_SUSP1R_AES_SUSP1R_Pos = 0x0
	// Bit mask of AES_SUSP1R field.
	AES_SUSP1R_AES_SUSP1R_Msk = 0xffffffff

	// SUSP2R: AES suspend register 2
	// Position of AES_SUSP2R field.
	AES_SUSP2R_AES_SUSP2R_Pos = 0x0
	// Bit mask of AES_SUSP2R field.
	AES_SUSP2R_AES_SUSP2R_Msk = 0xffffffff

	// SUSP3R: AES suspend register 3
	// Position of AES_SUSP3R field.
	AES_SUSP3R_AES_SUSP3R_Pos = 0x0
	// Bit mask of AES_SUSP3R field.
	AES_SUSP3R_AES_SUSP3R_Msk = 0xffffffff

	// SUSP4R: AES suspend register 4
	// Position of AES_SUSP4R field.
	AES_SUSP4R_AES_SUSP4R_Pos = 0x0
	// Bit mask of AES_SUSP4R field.
	AES_SUSP4R_AES_SUSP4R_Msk = 0xffffffff

	// SUSP5R: AES suspend register 5
	// Position of AES_SUSP5R field.
	AES_SUSP5R_AES_SUSP5R_Pos = 0x0
	// Bit mask of AES_SUSP5R field.
	AES_SUSP5R_AES_SUSP5R_Msk = 0xffffffff

	// SUSP6R: AES suspend register 6
	// Position of AES_SUSP6R field.
	AES_SUSP6R_AES_SUSP6R_Pos = 0x0
	// Bit mask of AES_SUSP6R field.
	AES_SUSP6R_AES_SUSP6R_Msk = 0xffffffff

	// SUSP7R: AES suspend register 7
	// Position of AES_SUSP7R field.
	AES_SUSP7R_AES_SUSP7R_Pos = 0x0
	// Bit mask of AES_SUSP7R field.
	AES_SUSP7R_AES_SUSP7R_Msk = 0xffffffff
)

// Bitfields for RNG: Random number generator
const (
	// CR: control register
	// Position of RNGEN field.
	RNG_CR_RNGEN_Pos = 0x2
	// Bit mask of RNGEN field.
	RNG_CR_RNGEN_Msk = 0x4
	// Bit RNGEN.
	RNG_CR_RNGEN = 0x4
	// Position of IE field.
	RNG_CR_IE_Pos = 0x3
	// Bit mask of IE field.
	RNG_CR_IE_Msk = 0x8
	// Bit IE.
	RNG_CR_IE = 0x8
	// Position of CED field.
	RNG_CR_CED_Pos = 0x5
	// Bit mask of CED field.
	RNG_CR_CED_Msk = 0x20
	// Bit CED.
	RNG_CR_CED = 0x20
	// Position of BYP field.
	RNG_CR_BYP_Pos = 0x6
	// Bit mask of BYP field.
	RNG_CR_BYP_Msk = 0x40
	// Bit BYP.
	RNG_CR_BYP = 0x40

	// SR: status register
	// Position of SEIS field.
	RNG_SR_SEIS_Pos = 0x6
	// Bit mask of SEIS field.
	RNG_SR_SEIS_Msk = 0x40
	// Bit SEIS.
	RNG_SR_SEIS = 0x40
	// Position of CEIS field.
	RNG_SR_CEIS_Pos = 0x5
	// Bit mask of CEIS field.
	RNG_SR_CEIS_Msk = 0x20
	// Bit CEIS.
	RNG_SR_CEIS = 0x20
	// Position of SECS field.
	RNG_SR_SECS_Pos = 0x2
	// Bit mask of SECS field.
	RNG_SR_SECS_Msk = 0x4
	// Bit SECS.
	RNG_SR_SECS = 0x4
	// Position of CECS field.
	RNG_SR_CECS_Pos = 0x1
	// Bit mask of CECS field.
	RNG_SR_CECS_Msk = 0x2
	// Bit CECS.
	RNG_SR_CECS = 0x2
	// Position of DRDY field.
	RNG_SR_DRDY_Pos = 0x0
	// Bit mask of DRDY field.
	RNG_SR_DRDY_Msk = 0x1
	// Bit DRDY.
	RNG_SR_DRDY = 0x1

	// DR: data register
	// Position of RNDATA field.
	RNG_DR_RNDATA_Pos = 0x0
	// Bit mask of RNDATA field.
	RNG_DR_RNDATA_Msk = 0xffffffff
)

// Bitfields for CRC: Cyclic redundancy check calculation unit
const (
	// DR: Data register
	// Position of DR field.
	CRC_DR_DR_Pos = 0x0
	// Bit mask of DR field.
	CRC_DR_DR_Msk = 0xffffffff

	// IDR: Independent data register
	// Position of IDR field.
	CRC_IDR_IDR_Pos = 0x0
	// Bit mask of IDR field.
	CRC_IDR_IDR_Msk = 0xffffffff

	// CR: Control register
	// Position of REV_OUT field.
	CRC_CR_REV_OUT_Pos = 0x7
	// Bit mask of REV_OUT field.
	CRC_CR_REV_OUT_Msk = 0x80
	// Bit REV_OUT.
	CRC_CR_REV_OUT = 0x80
	// Position of REV_IN field.
	CRC_CR_REV_IN_Pos = 0x5
	// Bit mask of REV_IN field.
	CRC_CR_REV_IN_Msk = 0x60
	// Position of POLYSIZE field.
	CRC_CR_POLYSIZE_Pos = 0x3
	// Bit mask of POLYSIZE field.
	CRC_CR_POLYSIZE_Msk = 0x18
	// Position of RESET field.
	CRC_CR_RESET_Pos = 0x0
	// Bit mask of RESET field.
	CRC_CR_RESET_Msk = 0x1
	// Bit RESET.
	CRC_CR_RESET = 0x1

	// INIT: Initial CRC value
	// Position of CRC_INIT field.
	CRC_INIT_CRC_INIT_Pos = 0x0
	// Bit mask of CRC_INIT field.
	CRC_INIT_CRC_INIT_Msk = 0xffffffff

	// POL: polynomial
	// Position of POL field.
	CRC_POL_POL_Pos = 0x0
	// Bit mask of POL field.
	CRC_POL_POL_Msk = 0xffffffff
)

// Bitfields for EXTI: External interrupt/event controller
const (
	// RTSR1: EXTI rising trigger selection register
	// Position of TR0 field.
	EXTI_RTSR1_TR0_Pos = 0x0
	// Bit mask of TR0 field.
	EXTI_RTSR1_TR0_Msk = 0x1
	// Bit TR0.
	EXTI_RTSR1_TR0 = 0x1
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR0_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR0_Enabled = 0x1
	// Position of TR1 field.
	EXTI_RTSR1_TR1_Pos = 0x1
	// Bit mask of TR1 field.
	EXTI_RTSR1_TR1_Msk = 0x2
	// Bit TR1.
	EXTI_RTSR1_TR1 = 0x2
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR1_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR1_Enabled = 0x1
	// Position of TR2 field.
	EXTI_RTSR1_TR2_Pos = 0x2
	// Bit mask of TR2 field.
	EXTI_RTSR1_TR2_Msk = 0x4
	// Bit TR2.
	EXTI_RTSR1_TR2 = 0x4
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR2_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR2_Enabled = 0x1
	// Position of TR3 field.
	EXTI_RTSR1_TR3_Pos = 0x3
	// Bit mask of TR3 field.
	EXTI_RTSR1_TR3_Msk = 0x8
	// Bit TR3.
	EXTI_RTSR1_TR3 = 0x8
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR3_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR3_Enabled = 0x1
	// Position of TR4 field.
	EXTI_RTSR1_TR4_Pos = 0x4
	// Bit mask of TR4 field.
	EXTI_RTSR1_TR4_Msk = 0x10
	// Bit TR4.
	EXTI_RTSR1_TR4 = 0x10
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR4_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR4_Enabled = 0x1
	// Position of TR5 field.
	EXTI_RTSR1_TR5_Pos = 0x5
	// Bit mask of TR5 field.
	EXTI_RTSR1_TR5_Msk = 0x20
	// Bit TR5.
	EXTI_RTSR1_TR5 = 0x20
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR5_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR5_Enabled = 0x1
	// Position of TR6 field.
	EXTI_RTSR1_TR6_Pos = 0x6
	// Bit mask of TR6 field.
	EXTI_RTSR1_TR6_Msk = 0x40
	// Bit TR6.
	EXTI_RTSR1_TR6 = 0x40
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR6_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR6_Enabled = 0x1
	// Position of TR7 field.
	EXTI_RTSR1_TR7_Pos = 0x7
	// Bit mask of TR7 field.
	EXTI_RTSR1_TR7_Msk = 0x80
	// Bit TR7.
	EXTI_RTSR1_TR7 = 0x80
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR7_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR7_Enabled = 0x1
	// Position of TR8 field.
	EXTI_RTSR1_TR8_Pos = 0x8
	// Bit mask of TR8 field.
	EXTI_RTSR1_TR8_Msk = 0x100
	// Bit TR8.
	EXTI_RTSR1_TR8 = 0x100
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR8_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR8_Enabled = 0x1
	// Position of TR9 field.
	EXTI_RTSR1_TR9_Pos = 0x9
	// Bit mask of TR9 field.
	EXTI_RTSR1_TR9_Msk = 0x200
	// Bit TR9.
	EXTI_RTSR1_TR9 = 0x200
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR9_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR9_Enabled = 0x1
	// Position of TR10 field.
	EXTI_RTSR1_TR10_Pos = 0xa
	// Bit mask of TR10 field.
	EXTI_RTSR1_TR10_Msk = 0x400
	// Bit TR10.
	EXTI_RTSR1_TR10 = 0x400
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR10_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR10_Enabled = 0x1
	// Position of TR11 field.
	EXTI_RTSR1_TR11_Pos = 0xb
	// Bit mask of TR11 field.
	EXTI_RTSR1_TR11_Msk = 0x800
	// Bit TR11.
	EXTI_RTSR1_TR11 = 0x800
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR11_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR11_Enabled = 0x1
	// Position of TR12 field.
	EXTI_RTSR1_TR12_Pos = 0xc
	// Bit mask of TR12 field.
	EXTI_RTSR1_TR12_Msk = 0x1000
	// Bit TR12.
	EXTI_RTSR1_TR12 = 0x1000
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR12_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR12_Enabled = 0x1
	// Position of TR13 field.
	EXTI_RTSR1_TR13_Pos = 0xd
	// Bit mask of TR13 field.
	EXTI_RTSR1_TR13_Msk = 0x2000
	// Bit TR13.
	EXTI_RTSR1_TR13 = 0x2000
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR13_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR13_Enabled = 0x1
	// Position of TR14 field.
	EXTI_RTSR1_TR14_Pos = 0xe
	// Bit mask of TR14 field.
	EXTI_RTSR1_TR14_Msk = 0x4000
	// Bit TR14.
	EXTI_RTSR1_TR14 = 0x4000
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR14_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR14_Enabled = 0x1
	// Position of TR15 field.
	EXTI_RTSR1_TR15_Pos = 0xf
	// Bit mask of TR15 field.
	EXTI_RTSR1_TR15_Msk = 0x8000
	// Bit TR15.
	EXTI_RTSR1_TR15 = 0x8000
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR15_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR15_Enabled = 0x1
	// Position of TR16 field.
	EXTI_RTSR1_TR16_Pos = 0x10
	// Bit mask of TR16 field.
	EXTI_RTSR1_TR16_Msk = 0x10000
	// Bit TR16.
	EXTI_RTSR1_TR16 = 0x10000
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR16_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR16_Enabled = 0x1

	// FTSR1: EXTI falling trigger selection register
	// Position of TR0 field.
	EXTI_FTSR1_TR0_Pos = 0x0
	// Bit mask of TR0 field.
	EXTI_FTSR1_TR0_Msk = 0x1
	// Bit TR0.
	EXTI_FTSR1_TR0 = 0x1
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR0_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR0_Enabled = 0x1
	// Position of TR1 field.
	EXTI_FTSR1_TR1_Pos = 0x1
	// Bit mask of TR1 field.
	EXTI_FTSR1_TR1_Msk = 0x2
	// Bit TR1.
	EXTI_FTSR1_TR1 = 0x2
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR1_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR1_Enabled = 0x1
	// Position of TR2 field.
	EXTI_FTSR1_TR2_Pos = 0x2
	// Bit mask of TR2 field.
	EXTI_FTSR1_TR2_Msk = 0x4
	// Bit TR2.
	EXTI_FTSR1_TR2 = 0x4
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR2_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR2_Enabled = 0x1
	// Position of TR3 field.
	EXTI_FTSR1_TR3_Pos = 0x3
	// Bit mask of TR3 field.
	EXTI_FTSR1_TR3_Msk = 0x8
	// Bit TR3.
	EXTI_FTSR1_TR3 = 0x8
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR3_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR3_Enabled = 0x1
	// Position of TR4 field.
	EXTI_FTSR1_TR4_Pos = 0x4
	// Bit mask of TR4 field.
	EXTI_FTSR1_TR4_Msk = 0x10
	// Bit TR4.
	EXTI_FTSR1_TR4 = 0x10
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR4_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR4_Enabled = 0x1
	// Position of TR5 field.
	EXTI_FTSR1_TR5_Pos = 0x5
	// Bit mask of TR5 field.
	EXTI_FTSR1_TR5_Msk = 0x20
	// Bit TR5.
	EXTI_FTSR1_TR5 = 0x20
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR5_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR5_Enabled = 0x1
	// Position of TR6 field.
	EXTI_FTSR1_TR6_Pos = 0x6
	// Bit mask of TR6 field.
	EXTI_FTSR1_TR6_Msk = 0x40
	// Bit TR6.
	EXTI_FTSR1_TR6 = 0x40
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR6_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR6_Enabled = 0x1
	// Position of TR7 field.
	EXTI_FTSR1_TR7_Pos = 0x7
	// Bit mask of TR7 field.
	EXTI_FTSR1_TR7_Msk = 0x80
	// Bit TR7.
	EXTI_FTSR1_TR7 = 0x80
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR7_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR7_Enabled = 0x1
	// Position of TR8 field.
	EXTI_FTSR1_TR8_Pos = 0x8
	// Bit mask of TR8 field.
	EXTI_FTSR1_TR8_Msk = 0x100
	// Bit TR8.
	EXTI_FTSR1_TR8 = 0x100
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR8_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR8_Enabled = 0x1
	// Position of TR9 field.
	EXTI_FTSR1_TR9_Pos = 0x9
	// Bit mask of TR9 field.
	EXTI_FTSR1_TR9_Msk = 0x200
	// Bit TR9.
	EXTI_FTSR1_TR9 = 0x200
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR9_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR9_Enabled = 0x1
	// Position of TR10 field.
	EXTI_FTSR1_TR10_Pos = 0xa
	// Bit mask of TR10 field.
	EXTI_FTSR1_TR10_Msk = 0x400
	// Bit TR10.
	EXTI_FTSR1_TR10 = 0x400
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR10_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR10_Enabled = 0x1
	// Position of TR11 field.
	EXTI_FTSR1_TR11_Pos = 0xb
	// Bit mask of TR11 field.
	EXTI_FTSR1_TR11_Msk = 0x800
	// Bit TR11.
	EXTI_FTSR1_TR11 = 0x800
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR11_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR11_Enabled = 0x1
	// Position of TR12 field.
	EXTI_FTSR1_TR12_Pos = 0xc
	// Bit mask of TR12 field.
	EXTI_FTSR1_TR12_Msk = 0x1000
	// Bit TR12.
	EXTI_FTSR1_TR12 = 0x1000
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR12_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR12_Enabled = 0x1
	// Position of TR13 field.
	EXTI_FTSR1_TR13_Pos = 0xd
	// Bit mask of TR13 field.
	EXTI_FTSR1_TR13_Msk = 0x2000
	// Bit TR13.
	EXTI_FTSR1_TR13 = 0x2000
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR13_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR13_Enabled = 0x1
	// Position of TR14 field.
	EXTI_FTSR1_TR14_Pos = 0xe
	// Bit mask of TR14 field.
	EXTI_FTSR1_TR14_Msk = 0x4000
	// Bit TR14.
	EXTI_FTSR1_TR14 = 0x4000
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR14_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR14_Enabled = 0x1
	// Position of TR15 field.
	EXTI_FTSR1_TR15_Pos = 0xf
	// Bit mask of TR15 field.
	EXTI_FTSR1_TR15_Msk = 0x8000
	// Bit TR15.
	EXTI_FTSR1_TR15 = 0x8000
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR15_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR15_Enabled = 0x1
	// Position of TR16 field.
	EXTI_FTSR1_TR16_Pos = 0x10
	// Bit mask of TR16 field.
	EXTI_FTSR1_TR16_Msk = 0x10000
	// Bit TR16.
	EXTI_FTSR1_TR16 = 0x10000
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR16_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR16_Enabled = 0x1

	// SWIER1: EXTI software interrupt event register
	// Position of SWIER0 field.
	EXTI_SWIER1_SWIER0_Pos = 0x0
	// Bit mask of SWIER0 field.
	EXTI_SWIER1_SWIER0_Msk = 0x1
	// Bit SWIER0.
	EXTI_SWIER1_SWIER0 = 0x1
	// Generates an interrupt request
	EXTI_SWIER1_SWIER0_Pend = 0x1
	// Position of SWIER1 field.
	EXTI_SWIER1_SWIER1_Pos = 0x1
	// Bit mask of SWIER1 field.
	EXTI_SWIER1_SWIER1_Msk = 0x2
	// Bit SWIER1.
	EXTI_SWIER1_SWIER1 = 0x2
	// Generates an interrupt request
	EXTI_SWIER1_SWIER1_Pend = 0x1
	// Position of SWIER2 field.
	EXTI_SWIER1_SWIER2_Pos = 0x2
	// Bit mask of SWIER2 field.
	EXTI_SWIER1_SWIER2_Msk = 0x4
	// Bit SWIER2.
	EXTI_SWIER1_SWIER2 = 0x4
	// Generates an interrupt request
	EXTI_SWIER1_SWIER2_Pend = 0x1
	// Position of SWIER3 field.
	EXTI_SWIER1_SWIER3_Pos = 0x3
	// Bit mask of SWIER3 field.
	EXTI_SWIER1_SWIER3_Msk = 0x8
	// Bit SWIER3.
	EXTI_SWIER1_SWIER3 = 0x8
	// Generates an interrupt request
	EXTI_SWIER1_SWIER3_Pend = 0x1
	// Position of SWIER4 field.
	EXTI_SWIER1_SWIER4_Pos = 0x4
	// Bit mask of SWIER4 field.
	EXTI_SWIER1_SWIER4_Msk = 0x10
	// Bit SWIER4.
	EXTI_SWIER1_SWIER4 = 0x10
	// Generates an interrupt request
	EXTI_SWIER1_SWIER4_Pend = 0x1
	// Position of SWIER5 field.
	EXTI_SWIER1_SWIER5_Pos = 0x5
	// Bit mask of SWIER5 field.
	EXTI_SWIER1_SWIER5_Msk = 0x20
	// Bit SWIER5.
	EXTI_SWIER1_SWIER5 = 0x20
	// Generates an interrupt request
	EXTI_SWIER1_SWIER5_Pend = 0x1
	// Position of SWIER6 field.
	EXTI_SWIER1_SWIER6_Pos = 0x6
	// Bit mask of SWIER6 field.
	EXTI_SWIER1_SWIER6_Msk = 0x40
	// Bit SWIER6.
	EXTI_SWIER1_SWIER6 = 0x40
	// Generates an interrupt request
	EXTI_SWIER1_SWIER6_Pend = 0x1
	// Position of SWIER7 field.
	EXTI_SWIER1_SWIER7_Pos = 0x7
	// Bit mask of SWIER7 field.
	EXTI_SWIER1_SWIER7_Msk = 0x80
	// Bit SWIER7.
	EXTI_SWIER1_SWIER7 = 0x80
	// Generates an interrupt request
	EXTI_SWIER1_SWIER7_Pend = 0x1
	// Position of SWIER8 field.
	EXTI_SWIER1_SWIER8_Pos = 0x8
	// Bit mask of SWIER8 field.
	EXTI_SWIER1_SWIER8_Msk = 0x100
	// Bit SWIER8.
	EXTI_SWIER1_SWIER8 = 0x100
	// Generates an interrupt request
	EXTI_SWIER1_SWIER8_Pend = 0x1
	// Position of SWIER9 field.
	EXTI_SWIER1_SWIER9_Pos = 0x9
	// Bit mask of SWIER9 field.
	EXTI_SWIER1_SWIER9_Msk = 0x200
	// Bit SWIER9.
	EXTI_SWIER1_SWIER9 = 0x200
	// Generates an interrupt request
	EXTI_SWIER1_SWIER9_Pend = 0x1
	// Position of SWIER10 field.
	EXTI_SWIER1_SWIER10_Pos = 0xa
	// Bit mask of SWIER10 field.
	EXTI_SWIER1_SWIER10_Msk = 0x400
	// Bit SWIER10.
	EXTI_SWIER1_SWIER10 = 0x400
	// Generates an interrupt request
	EXTI_SWIER1_SWIER10_Pend = 0x1
	// Position of SWIER11 field.
	EXTI_SWIER1_SWIER11_Pos = 0xb
	// Bit mask of SWIER11 field.
	EXTI_SWIER1_SWIER11_Msk = 0x800
	// Bit SWIER11.
	EXTI_SWIER1_SWIER11 = 0x800
	// Generates an interrupt request
	EXTI_SWIER1_SWIER11_Pend = 0x1
	// Position of SWIER12 field.
	EXTI_SWIER1_SWIER12_Pos = 0xc
	// Bit mask of SWIER12 field.
	EXTI_SWIER1_SWIER12_Msk = 0x1000
	// Bit SWIER12.
	EXTI_SWIER1_SWIER12 = 0x1000
	// Generates an interrupt request
	EXTI_SWIER1_SWIER12_Pend = 0x1
	// Position of SWIER13 field.
	EXTI_SWIER1_SWIER13_Pos = 0xd
	// Bit mask of SWIER13 field.
	EXTI_SWIER1_SWIER13_Msk = 0x2000
	// Bit SWIER13.
	EXTI_SWIER1_SWIER13 = 0x2000
	// Generates an interrupt request
	EXTI_SWIER1_SWIER13_Pend = 0x1
	// Position of SWIER14 field.
	EXTI_SWIER1_SWIER14_Pos = 0xe
	// Bit mask of SWIER14 field.
	EXTI_SWIER1_SWIER14_Msk = 0x4000
	// Bit SWIER14.
	EXTI_SWIER1_SWIER14 = 0x4000
	// Generates an interrupt request
	EXTI_SWIER1_SWIER14_Pend = 0x1
	// Position of SWIER15 field.
	EXTI_SWIER1_SWIER15_Pos = 0xf
	// Bit mask of SWIER15 field.
	EXTI_SWIER1_SWIER15_Msk = 0x8000
	// Bit SWIER15.
	EXTI_SWIER1_SWIER15 = 0x8000
	// Generates an interrupt request
	EXTI_SWIER1_SWIER15_Pend = 0x1
	// Position of SWIER16 field.
	EXTI_SWIER1_SWIER16_Pos = 0x10
	// Bit mask of SWIER16 field.
	EXTI_SWIER1_SWIER16_Msk = 0x10000
	// Bit SWIER16.
	EXTI_SWIER1_SWIER16 = 0x10000
	// Generates an interrupt request
	EXTI_SWIER1_SWIER16_Pend = 0x1

	// RPR1: EXTI rising edge pending register
	// Position of RPIF0 field.
	EXTI_RPR1_RPIF0_Pos = 0x0
	// Bit mask of RPIF0 field.
	EXTI_RPR1_RPIF0_Msk = 0x1
	// Bit RPIF0.
	EXTI_RPR1_RPIF0 = 0x1
	// No trigger request occurred
	EXTI_RPR1_RPIF0_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_RPR1_RPIF0_Pending = 0x1
	// Clears pending bit
	EXTI_RPR1_RPIF0_Clear = 0x1
	// Position of RPIF1 field.
	EXTI_RPR1_RPIF1_Pos = 0x1
	// Bit mask of RPIF1 field.
	EXTI_RPR1_RPIF1_Msk = 0x2
	// Bit RPIF1.
	EXTI_RPR1_RPIF1 = 0x2
	// No trigger request occurred
	EXTI_RPR1_RPIF1_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_RPR1_RPIF1_Pending = 0x1
	// Clears pending bit
	EXTI_RPR1_RPIF1_Clear = 0x1
	// Position of RPIF2 field.
	EXTI_RPR1_RPIF2_Pos = 0x2
	// Bit mask of RPIF2 field.
	EXTI_RPR1_RPIF2_Msk = 0x4
	// Bit RPIF2.
	EXTI_RPR1_RPIF2 = 0x4
	// No trigger request occurred
	EXTI_RPR1_RPIF2_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_RPR1_RPIF2_Pending = 0x1
	// Clears pending bit
	EXTI_RPR1_RPIF2_Clear = 0x1
	// Position of RPIF3 field.
	EXTI_RPR1_RPIF3_Pos = 0x3
	// Bit mask of RPIF3 field.
	EXTI_RPR1_RPIF3_Msk = 0x8
	// Bit RPIF3.
	EXTI_RPR1_RPIF3 = 0x8
	// No trigger request occurred
	EXTI_RPR1_RPIF3_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_RPR1_RPIF3_Pending = 0x1
	// Clears pending bit
	EXTI_RPR1_RPIF3_Clear = 0x1
	// Position of RPIF4 field.
	EXTI_RPR1_RPIF4_Pos = 0x4
	// Bit mask of RPIF4 field.
	EXTI_RPR1_RPIF4_Msk = 0x10
	// Bit RPIF4.
	EXTI_RPR1_RPIF4 = 0x10
	// No trigger request occurred
	EXTI_RPR1_RPIF4_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_RPR1_RPIF4_Pending = 0x1
	// Clears pending bit
	EXTI_RPR1_RPIF4_Clear = 0x1
	// Position of RPIF5 field.
	EXTI_RPR1_RPIF5_Pos = 0x5
	// Bit mask of RPIF5 field.
	EXTI_RPR1_RPIF5_Msk = 0x20
	// Bit RPIF5.
	EXTI_RPR1_RPIF5 = 0x20
	// No trigger request occurred
	EXTI_RPR1_RPIF5_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_RPR1_RPIF5_Pending = 0x1
	// Clears pending bit
	EXTI_RPR1_RPIF5_Clear = 0x1
	// Position of RPIF6 field.
	EXTI_RPR1_RPIF6_Pos = 0x6
	// Bit mask of RPIF6 field.
	EXTI_RPR1_RPIF6_Msk = 0x40
	// Bit RPIF6.
	EXTI_RPR1_RPIF6 = 0x40
	// No trigger request occurred
	EXTI_RPR1_RPIF6_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_RPR1_RPIF6_Pending = 0x1
	// Clears pending bit
	EXTI_RPR1_RPIF6_Clear = 0x1
	// Position of RPIF7 field.
	EXTI_RPR1_RPIF7_Pos = 0x7
	// Bit mask of RPIF7 field.
	EXTI_RPR1_RPIF7_Msk = 0x80
	// Bit RPIF7.
	EXTI_RPR1_RPIF7 = 0x80
	// No trigger request occurred
	EXTI_RPR1_RPIF7_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_RPR1_RPIF7_Pending = 0x1
	// Clears pending bit
	EXTI_RPR1_RPIF7_Clear = 0x1
	// Position of RPIF8 field.
	EXTI_RPR1_RPIF8_Pos = 0x8
	// Bit mask of RPIF8 field.
	EXTI_RPR1_RPIF8_Msk = 0x100
	// Bit RPIF8.
	EXTI_RPR1_RPIF8 = 0x100
	// No trigger request occurred
	EXTI_RPR1_RPIF8_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_RPR1_RPIF8_Pending = 0x1
	// Clears pending bit
	EXTI_RPR1_RPIF8_Clear = 0x1
	// Position of RPIF9 field.
	EXTI_RPR1_RPIF9_Pos = 0x9
	// Bit mask of RPIF9 field.
	EXTI_RPR1_RPIF9_Msk = 0x200
	// Bit RPIF9.
	EXTI_RPR1_RPIF9 = 0x200
	// No trigger request occurred
	EXTI_RPR1_RPIF9_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_RPR1_RPIF9_Pending = 0x1
	// Clears pending bit
	EXTI_RPR1_RPIF9_Clear = 0x1
	// Position of RPIF10 field.
	EXTI_RPR1_RPIF10_Pos = 0xa
	// Bit mask of RPIF10 field.
	EXTI_RPR1_RPIF10_Msk = 0x400
	// Bit RPIF10.
	EXTI_RPR1_RPIF10 = 0x400
	// No trigger request occurred
	EXTI_RPR1_RPIF10_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_RPR1_RPIF10_Pending = 0x1
	// Clears pending bit
	EXTI_RPR1_RPIF10_Clear = 0x1
	// Position of RPIF11 field.
	EXTI_RPR1_RPIF11_Pos = 0xb
	// Bit mask of RPIF11 field.
	EXTI_RPR1_RPIF11_Msk = 0x800
	// Bit RPIF11.
	EXTI_RPR1_RPIF11 = 0x800
	// No trigger request occurred
	EXTI_RPR1_RPIF11_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_RPR1_RPIF11_Pending = 0x1
	// Clears pending bit
	EXTI_RPR1_RPIF11_Clear = 0x1
	// Position of RPIF12 field.
	EXTI_RPR1_RPIF12_Pos = 0xc
	// Bit mask of RPIF12 field.
	EXTI_RPR1_RPIF12_Msk = 0x1000
	// Bit RPIF12.
	EXTI_RPR1_RPIF12 = 0x1000
	// No trigger request occurred
	EXTI_RPR1_RPIF12_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_RPR1_RPIF12_Pending = 0x1
	// Clears pending bit
	EXTI_RPR1_RPIF12_Clear = 0x1
	// Position of RPIF13 field.
	EXTI_RPR1_RPIF13_Pos = 0xd
	// Bit mask of RPIF13 field.
	EXTI_RPR1_RPIF13_Msk = 0x2000
	// Bit RPIF13.
	EXTI_RPR1_RPIF13 = 0x2000
	// No trigger request occurred
	EXTI_RPR1_RPIF13_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_RPR1_RPIF13_Pending = 0x1
	// Clears pending bit
	EXTI_RPR1_RPIF13_Clear = 0x1
	// Position of RPIF14 field.
	EXTI_RPR1_RPIF14_Pos = 0xe
	// Bit mask of RPIF14 field.
	EXTI_RPR1_RPIF14_Msk = 0x4000
	// Bit RPIF14.
	EXTI_RPR1_RPIF14 = 0x4000
	// No trigger request occurred
	EXTI_RPR1_RPIF14_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_RPR1_RPIF14_Pending = 0x1
	// Clears pending bit
	EXTI_RPR1_RPIF14_Clear = 0x1
	// Position of RPIF15 field.
	EXTI_RPR1_RPIF15_Pos = 0xf
	// Bit mask of RPIF15 field.
	EXTI_RPR1_RPIF15_Msk = 0x8000
	// Bit RPIF15.
	EXTI_RPR1_RPIF15 = 0x8000
	// No trigger request occurred
	EXTI_RPR1_RPIF15_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_RPR1_RPIF15_Pending = 0x1
	// Clears pending bit
	EXTI_RPR1_RPIF15_Clear = 0x1
	// Position of RPIF16 field.
	EXTI_RPR1_RPIF16_Pos = 0x10
	// Bit mask of RPIF16 field.
	EXTI_RPR1_RPIF16_Msk = 0x10000
	// Bit RPIF16.
	EXTI_RPR1_RPIF16 = 0x10000
	// No trigger request occurred
	EXTI_RPR1_RPIF16_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_RPR1_RPIF16_Pending = 0x1
	// Clears pending bit
	EXTI_RPR1_RPIF16_Clear = 0x1

	// FPR1: EXTI falling edge pending register
	// Position of FPIF0 field.
	EXTI_FPR1_FPIF0_Pos = 0x0
	// Bit mask of FPIF0 field.
	EXTI_FPR1_FPIF0_Msk = 0x1
	// Bit FPIF0.
	EXTI_FPR1_FPIF0 = 0x1
	// No trigger request occurred
	EXTI_FPR1_FPIF0_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_FPR1_FPIF0_Pending = 0x1
	// Clears pending bit
	EXTI_FPR1_FPIF0_Clear = 0x1
	// Position of FPIF1 field.
	EXTI_FPR1_FPIF1_Pos = 0x1
	// Bit mask of FPIF1 field.
	EXTI_FPR1_FPIF1_Msk = 0x2
	// Bit FPIF1.
	EXTI_FPR1_FPIF1 = 0x2
	// No trigger request occurred
	EXTI_FPR1_FPIF1_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_FPR1_FPIF1_Pending = 0x1
	// Clears pending bit
	EXTI_FPR1_FPIF1_Clear = 0x1
	// Position of FPIF2 field.
	EXTI_FPR1_FPIF2_Pos = 0x2
	// Bit mask of FPIF2 field.
	EXTI_FPR1_FPIF2_Msk = 0x4
	// Bit FPIF2.
	EXTI_FPR1_FPIF2 = 0x4
	// No trigger request occurred
	EXTI_FPR1_FPIF2_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_FPR1_FPIF2_Pending = 0x1
	// Clears pending bit
	EXTI_FPR1_FPIF2_Clear = 0x1
	// Position of FPIF3 field.
	EXTI_FPR1_FPIF3_Pos = 0x3
	// Bit mask of FPIF3 field.
	EXTI_FPR1_FPIF3_Msk = 0x8
	// Bit FPIF3.
	EXTI_FPR1_FPIF3 = 0x8
	// No trigger request occurred
	EXTI_FPR1_FPIF3_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_FPR1_FPIF3_Pending = 0x1
	// Clears pending bit
	EXTI_FPR1_FPIF3_Clear = 0x1
	// Position of FPIF4 field.
	EXTI_FPR1_FPIF4_Pos = 0x4
	// Bit mask of FPIF4 field.
	EXTI_FPR1_FPIF4_Msk = 0x10
	// Bit FPIF4.
	EXTI_FPR1_FPIF4 = 0x10
	// No trigger request occurred
	EXTI_FPR1_FPIF4_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_FPR1_FPIF4_Pending = 0x1
	// Clears pending bit
	EXTI_FPR1_FPIF4_Clear = 0x1
	// Position of FPIF5 field.
	EXTI_FPR1_FPIF5_Pos = 0x5
	// Bit mask of FPIF5 field.
	EXTI_FPR1_FPIF5_Msk = 0x20
	// Bit FPIF5.
	EXTI_FPR1_FPIF5 = 0x20
	// No trigger request occurred
	EXTI_FPR1_FPIF5_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_FPR1_FPIF5_Pending = 0x1
	// Clears pending bit
	EXTI_FPR1_FPIF5_Clear = 0x1
	// Position of FPIF6 field.
	EXTI_FPR1_FPIF6_Pos = 0x6
	// Bit mask of FPIF6 field.
	EXTI_FPR1_FPIF6_Msk = 0x40
	// Bit FPIF6.
	EXTI_FPR1_FPIF6 = 0x40
	// No trigger request occurred
	EXTI_FPR1_FPIF6_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_FPR1_FPIF6_Pending = 0x1
	// Clears pending bit
	EXTI_FPR1_FPIF6_Clear = 0x1
	// Position of FPIF7 field.
	EXTI_FPR1_FPIF7_Pos = 0x7
	// Bit mask of FPIF7 field.
	EXTI_FPR1_FPIF7_Msk = 0x80
	// Bit FPIF7.
	EXTI_FPR1_FPIF7 = 0x80
	// No trigger request occurred
	EXTI_FPR1_FPIF7_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_FPR1_FPIF7_Pending = 0x1
	// Clears pending bit
	EXTI_FPR1_FPIF7_Clear = 0x1
	// Position of FPIF8 field.
	EXTI_FPR1_FPIF8_Pos = 0x8
	// Bit mask of FPIF8 field.
	EXTI_FPR1_FPIF8_Msk = 0x100
	// Bit FPIF8.
	EXTI_FPR1_FPIF8 = 0x100
	// No trigger request occurred
	EXTI_FPR1_FPIF8_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_FPR1_FPIF8_Pending = 0x1
	// Clears pending bit
	EXTI_FPR1_FPIF8_Clear = 0x1
	// Position of FPIF9 field.
	EXTI_FPR1_FPIF9_Pos = 0x9
	// Bit mask of FPIF9 field.
	EXTI_FPR1_FPIF9_Msk = 0x200
	// Bit FPIF9.
	EXTI_FPR1_FPIF9 = 0x200
	// No trigger request occurred
	EXTI_FPR1_FPIF9_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_FPR1_FPIF9_Pending = 0x1
	// Clears pending bit
	EXTI_FPR1_FPIF9_Clear = 0x1
	// Position of FPIF10 field.
	EXTI_FPR1_FPIF10_Pos = 0xa
	// Bit mask of FPIF10 field.
	EXTI_FPR1_FPIF10_Msk = 0x400
	// Bit FPIF10.
	EXTI_FPR1_FPIF10 = 0x400
	// No trigger request occurred
	EXTI_FPR1_FPIF10_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_FPR1_FPIF10_Pending = 0x1
	// Clears pending bit
	EXTI_FPR1_FPIF10_Clear = 0x1
	// Position of FPIF11 field.
	EXTI_FPR1_FPIF11_Pos = 0xb
	// Bit mask of FPIF11 field.
	EXTI_FPR1_FPIF11_Msk = 0x800
	// Bit FPIF11.
	EXTI_FPR1_FPIF11 = 0x800
	// No trigger request occurred
	EXTI_FPR1_FPIF11_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_FPR1_FPIF11_Pending = 0x1
	// Clears pending bit
	EXTI_FPR1_FPIF11_Clear = 0x1
	// Position of FPIF12 field.
	EXTI_FPR1_FPIF12_Pos = 0xc
	// Bit mask of FPIF12 field.
	EXTI_FPR1_FPIF12_Msk = 0x1000
	// Bit FPIF12.
	EXTI_FPR1_FPIF12 = 0x1000
	// No trigger request occurred
	EXTI_FPR1_FPIF12_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_FPR1_FPIF12_Pending = 0x1
	// Clears pending bit
	EXTI_FPR1_FPIF12_Clear = 0x1
	// Position of FPIF13 field.
	EXTI_FPR1_FPIF13_Pos = 0xd
	// Bit mask of FPIF13 field.
	EXTI_FPR1_FPIF13_Msk = 0x2000
	// Bit FPIF13.
	EXTI_FPR1_FPIF13 = 0x2000
	// No trigger request occurred
	EXTI_FPR1_FPIF13_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_FPR1_FPIF13_Pending = 0x1
	// Clears pending bit
	EXTI_FPR1_FPIF13_Clear = 0x1
	// Position of FPIF14 field.
	EXTI_FPR1_FPIF14_Pos = 0xe
	// Bit mask of FPIF14 field.
	EXTI_FPR1_FPIF14_Msk = 0x4000
	// Bit FPIF14.
	EXTI_FPR1_FPIF14 = 0x4000
	// No trigger request occurred
	EXTI_FPR1_FPIF14_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_FPR1_FPIF14_Pending = 0x1
	// Clears pending bit
	EXTI_FPR1_FPIF14_Clear = 0x1
	// Position of FPIF15 field.
	EXTI_FPR1_FPIF15_Pos = 0xf
	// Bit mask of FPIF15 field.
	EXTI_FPR1_FPIF15_Msk = 0x8000
	// Bit FPIF15.
	EXTI_FPR1_FPIF15 = 0x8000
	// No trigger request occurred
	EXTI_FPR1_FPIF15_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_FPR1_FPIF15_Pending = 0x1
	// Clears pending bit
	EXTI_FPR1_FPIF15_Clear = 0x1
	// Position of FPIF16 field.
	EXTI_FPR1_FPIF16_Pos = 0x10
	// Bit mask of FPIF16 field.
	EXTI_FPR1_FPIF16_Msk = 0x10000
	// Bit FPIF16.
	EXTI_FPR1_FPIF16 = 0x10000
	// No trigger request occurred
	EXTI_FPR1_FPIF16_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_FPR1_FPIF16_Pending = 0x1
	// Clears pending bit
	EXTI_FPR1_FPIF16_Clear = 0x1

	// EXTICR1: EXTI external interrupt selection register
	// Position of EXTI0_7 field.
	EXTI_EXTICR1_EXTI0_7_Pos = 0x0
	// Bit mask of EXTI0_7 field.
	EXTI_EXTICR1_EXTI0_7_Msk = 0xff
	// GPIO port A selected
	EXTI_EXTICR1_EXTI0_7_PA = 0x0
	// GPIO port B selected
	EXTI_EXTICR1_EXTI0_7_PB = 0x1
	// GPIO port C selected
	EXTI_EXTICR1_EXTI0_7_PC = 0x2
	// GPIO port D selected
	EXTI_EXTICR1_EXTI0_7_PD = 0x3
	// GPIO port F selected
	EXTI_EXTICR1_EXTI0_7_PF = 0x5
	// Position of EXTI8_15 field.
	EXTI_EXTICR1_EXTI8_15_Pos = 0x8
	// Bit mask of EXTI8_15 field.
	EXTI_EXTICR1_EXTI8_15_Msk = 0xff00
	// GPIO port A selected
	EXTI_EXTICR1_EXTI8_15_PA = 0x0
	// GPIO port B selected
	EXTI_EXTICR1_EXTI8_15_PB = 0x1
	// GPIO port C selected
	EXTI_EXTICR1_EXTI8_15_PC = 0x2
	// GPIO port D selected
	EXTI_EXTICR1_EXTI8_15_PD = 0x3
	// GPIO port F selected
	EXTI_EXTICR1_EXTI8_15_PF = 0x5
	// Position of EXTI16_23 field.
	EXTI_EXTICR1_EXTI16_23_Pos = 0x10
	// Bit mask of EXTI16_23 field.
	EXTI_EXTICR1_EXTI16_23_Msk = 0xff0000
	// GPIO port A selected
	EXTI_EXTICR1_EXTI16_23_PA = 0x0
	// GPIO port B selected
	EXTI_EXTICR1_EXTI16_23_PB = 0x1
	// GPIO port C selected
	EXTI_EXTICR1_EXTI16_23_PC = 0x2
	// GPIO port D selected
	EXTI_EXTICR1_EXTI16_23_PD = 0x3
	// GPIO port F selected
	EXTI_EXTICR1_EXTI16_23_PF = 0x5
	// Position of EXTI24_31 field.
	EXTI_EXTICR1_EXTI24_31_Pos = 0x18
	// Bit mask of EXTI24_31 field.
	EXTI_EXTICR1_EXTI24_31_Msk = 0xff000000
	// GPIO port A selected
	EXTI_EXTICR1_EXTI24_31_PA = 0x0
	// GPIO port B selected
	EXTI_EXTICR1_EXTI24_31_PB = 0x1
	// GPIO port C selected
	EXTI_EXTICR1_EXTI24_31_PC = 0x2
	// GPIO port D selected
	EXTI_EXTICR1_EXTI24_31_PD = 0x3
	// GPIO port F selected
	EXTI_EXTICR1_EXTI24_31_PF = 0x5

	// EXTICR2: EXTI external interrupt selection register
	// Position of EXTI0_7 field.
	EXTI_EXTICR2_EXTI0_7_Pos = 0x0
	// Bit mask of EXTI0_7 field.
	EXTI_EXTICR2_EXTI0_7_Msk = 0xff
	// GPIO port A selected
	EXTI_EXTICR2_EXTI0_7_PA = 0x0
	// GPIO port B selected
	EXTI_EXTICR2_EXTI0_7_PB = 0x1
	// GPIO port C selected
	EXTI_EXTICR2_EXTI0_7_PC = 0x2
	// GPIO port D selected
	EXTI_EXTICR2_EXTI0_7_PD = 0x3
	// GPIO port F selected
	EXTI_EXTICR2_EXTI0_7_PF = 0x5
	// Position of EXTI8_15 field.
	EXTI_EXTICR2_EXTI8_15_Pos = 0x8
	// Bit mask of EXTI8_15 field.
	EXTI_EXTICR2_EXTI8_15_Msk = 0xff00
	// GPIO port A selected
	EXTI_EXTICR2_EXTI8_15_PA = 0x0
	// GPIO port B selected
	EXTI_EXTICR2_EXTI8_15_PB = 0x1
	// GPIO port C selected
	EXTI_EXTICR2_EXTI8_15_PC = 0x2
	// GPIO port D selected
	EXTI_EXTICR2_EXTI8_15_PD = 0x3
	// GPIO port F selected
	EXTI_EXTICR2_EXTI8_15_PF = 0x5
	// Position of EXTI16_23 field.
	EXTI_EXTICR2_EXTI16_23_Pos = 0x10
	// Bit mask of EXTI16_23 field.
	EXTI_EXTICR2_EXTI16_23_Msk = 0xff0000
	// GPIO port A selected
	EXTI_EXTICR2_EXTI16_23_PA = 0x0
	// GPIO port B selected
	EXTI_EXTICR2_EXTI16_23_PB = 0x1
	// GPIO port C selected
	EXTI_EXTICR2_EXTI16_23_PC = 0x2
	// GPIO port D selected
	EXTI_EXTICR2_EXTI16_23_PD = 0x3
	// GPIO port F selected
	EXTI_EXTICR2_EXTI16_23_PF = 0x5
	// Position of EXTI24_31 field.
	EXTI_EXTICR2_EXTI24_31_Pos = 0x18
	// Bit mask of EXTI24_31 field.
	EXTI_EXTICR2_EXTI24_31_Msk = 0xff000000
	// GPIO port A selected
	EXTI_EXTICR2_EXTI24_31_PA = 0x0
	// GPIO port B selected
	EXTI_EXTICR2_EXTI24_31_PB = 0x1
	// GPIO port C selected
	EXTI_EXTICR2_EXTI24_31_PC = 0x2
	// GPIO port D selected
	EXTI_EXTICR2_EXTI24_31_PD = 0x3
	// GPIO port F selected
	EXTI_EXTICR2_EXTI24_31_PF = 0x5

	// EXTICR3: EXTI external interrupt selection register
	// Position of EXTI0_7 field.
	EXTI_EXTICR3_EXTI0_7_Pos = 0x0
	// Bit mask of EXTI0_7 field.
	EXTI_EXTICR3_EXTI0_7_Msk = 0xff
	// GPIO port A selected
	EXTI_EXTICR3_EXTI0_7_PA = 0x0
	// GPIO port B selected
	EXTI_EXTICR3_EXTI0_7_PB = 0x1
	// GPIO port C selected
	EXTI_EXTICR3_EXTI0_7_PC = 0x2
	// GPIO port D selected
	EXTI_EXTICR3_EXTI0_7_PD = 0x3
	// GPIO port F selected
	EXTI_EXTICR3_EXTI0_7_PF = 0x5
	// Position of EXTI8_15 field.
	EXTI_EXTICR3_EXTI8_15_Pos = 0x8
	// Bit mask of EXTI8_15 field.
	EXTI_EXTICR3_EXTI8_15_Msk = 0xff00
	// GPIO port A selected
	EXTI_EXTICR3_EXTI8_15_PA = 0x0
	// GPIO port B selected
	EXTI_EXTICR3_EXTI8_15_PB = 0x1
	// GPIO port C selected
	EXTI_EXTICR3_EXTI8_15_PC = 0x2
	// GPIO port D selected
	EXTI_EXTICR3_EXTI8_15_PD = 0x3
	// GPIO port F selected
	EXTI_EXTICR3_EXTI8_15_PF = 0x5
	// Position of EXTI16_23 field.
	EXTI_EXTICR3_EXTI16_23_Pos = 0x10
	// Bit mask of EXTI16_23 field.
	EXTI_EXTICR3_EXTI16_23_Msk = 0xff0000
	// GPIO port A selected
	EXTI_EXTICR3_EXTI16_23_PA = 0x0
	// GPIO port B selected
	EXTI_EXTICR3_EXTI16_23_PB = 0x1
	// GPIO port C selected
	EXTI_EXTICR3_EXTI16_23_PC = 0x2
	// GPIO port D selected
	EXTI_EXTICR3_EXTI16_23_PD = 0x3
	// GPIO port F selected
	EXTI_EXTICR3_EXTI16_23_PF = 0x5
	// Position of EXTI24_31 field.
	EXTI_EXTICR3_EXTI24_31_Pos = 0x18
	// Bit mask of EXTI24_31 field.
	EXTI_EXTICR3_EXTI24_31_Msk = 0xff000000
	// GPIO port A selected
	EXTI_EXTICR3_EXTI24_31_PA = 0x0
	// GPIO port B selected
	EXTI_EXTICR3_EXTI24_31_PB = 0x1
	// GPIO port C selected
	EXTI_EXTICR3_EXTI24_31_PC = 0x2
	// GPIO port D selected
	EXTI_EXTICR3_EXTI24_31_PD = 0x3
	// GPIO port F selected
	EXTI_EXTICR3_EXTI24_31_PF = 0x5

	// EXTICR4: EXTI external interrupt selection register
	// Position of EXTI0_7 field.
	EXTI_EXTICR4_EXTI0_7_Pos = 0x0
	// Bit mask of EXTI0_7 field.
	EXTI_EXTICR4_EXTI0_7_Msk = 0xff
	// GPIO port A selected
	EXTI_EXTICR4_EXTI0_7_PA = 0x0
	// GPIO port B selected
	EXTI_EXTICR4_EXTI0_7_PB = 0x1
	// GPIO port C selected
	EXTI_EXTICR4_EXTI0_7_PC = 0x2
	// GPIO port D selected
	EXTI_EXTICR4_EXTI0_7_PD = 0x3
	// GPIO port F selected
	EXTI_EXTICR4_EXTI0_7_PF = 0x5
	// Position of EXTI8_15 field.
	EXTI_EXTICR4_EXTI8_15_Pos = 0x8
	// Bit mask of EXTI8_15 field.
	EXTI_EXTICR4_EXTI8_15_Msk = 0xff00
	// GPIO port A selected
	EXTI_EXTICR4_EXTI8_15_PA = 0x0
	// GPIO port B selected
	EXTI_EXTICR4_EXTI8_15_PB = 0x1
	// GPIO port C selected
	EXTI_EXTICR4_EXTI8_15_PC = 0x2
	// GPIO port D selected
	EXTI_EXTICR4_EXTI8_15_PD = 0x3
	// GPIO port F selected
	EXTI_EXTICR4_EXTI8_15_PF = 0x5
	// Position of EXTI16_23 field.
	EXTI_EXTICR4_EXTI16_23_Pos = 0x10
	// Bit mask of EXTI16_23 field.
	EXTI_EXTICR4_EXTI16_23_Msk = 0xff0000
	// GPIO port A selected
	EXTI_EXTICR4_EXTI16_23_PA = 0x0
	// GPIO port B selected
	EXTI_EXTICR4_EXTI16_23_PB = 0x1
	// GPIO port C selected
	EXTI_EXTICR4_EXTI16_23_PC = 0x2
	// GPIO port D selected
	EXTI_EXTICR4_EXTI16_23_PD = 0x3
	// GPIO port F selected
	EXTI_EXTICR4_EXTI16_23_PF = 0x5
	// Position of EXTI24_31 field.
	EXTI_EXTICR4_EXTI24_31_Pos = 0x18
	// Bit mask of EXTI24_31 field.
	EXTI_EXTICR4_EXTI24_31_Msk = 0xff000000
	// GPIO port A selected
	EXTI_EXTICR4_EXTI24_31_PA = 0x0
	// GPIO port B selected
	EXTI_EXTICR4_EXTI24_31_PB = 0x1
	// GPIO port C selected
	EXTI_EXTICR4_EXTI24_31_PC = 0x2
	// GPIO port D selected
	EXTI_EXTICR4_EXTI24_31_PD = 0x3
	// GPIO port F selected
	EXTI_EXTICR4_EXTI24_31_PF = 0x5

	// IMR1: EXTI CPU wakeup with interrupt mask register
	// Position of IM0 field.
	EXTI_IMR1_IM0_Pos = 0x0
	// Bit mask of IM0 field.
	EXTI_IMR1_IM0_Msk = 0x1
	// Bit IM0.
	EXTI_IMR1_IM0 = 0x1
	// Interrupt request line is masked
	EXTI_IMR1_IM0_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM0_Unmasked = 0x1
	// Position of IM1 field.
	EXTI_IMR1_IM1_Pos = 0x1
	// Bit mask of IM1 field.
	EXTI_IMR1_IM1_Msk = 0x2
	// Bit IM1.
	EXTI_IMR1_IM1 = 0x2
	// Interrupt request line is masked
	EXTI_IMR1_IM1_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM1_Unmasked = 0x1
	// Position of IM2 field.
	EXTI_IMR1_IM2_Pos = 0x2
	// Bit mask of IM2 field.
	EXTI_IMR1_IM2_Msk = 0x4
	// Bit IM2.
	EXTI_IMR1_IM2 = 0x4
	// Interrupt request line is masked
	EXTI_IMR1_IM2_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM2_Unmasked = 0x1
	// Position of IM3 field.
	EXTI_IMR1_IM3_Pos = 0x3
	// Bit mask of IM3 field.
	EXTI_IMR1_IM3_Msk = 0x8
	// Bit IM3.
	EXTI_IMR1_IM3 = 0x8
	// Interrupt request line is masked
	EXTI_IMR1_IM3_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM3_Unmasked = 0x1
	// Position of IM4 field.
	EXTI_IMR1_IM4_Pos = 0x4
	// Bit mask of IM4 field.
	EXTI_IMR1_IM4_Msk = 0x10
	// Bit IM4.
	EXTI_IMR1_IM4 = 0x10
	// Interrupt request line is masked
	EXTI_IMR1_IM4_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM4_Unmasked = 0x1
	// Position of IM5 field.
	EXTI_IMR1_IM5_Pos = 0x5
	// Bit mask of IM5 field.
	EXTI_IMR1_IM5_Msk = 0x20
	// Bit IM5.
	EXTI_IMR1_IM5 = 0x20
	// Interrupt request line is masked
	EXTI_IMR1_IM5_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM5_Unmasked = 0x1
	// Position of IM6 field.
	EXTI_IMR1_IM6_Pos = 0x6
	// Bit mask of IM6 field.
	EXTI_IMR1_IM6_Msk = 0x40
	// Bit IM6.
	EXTI_IMR1_IM6 = 0x40
	// Interrupt request line is masked
	EXTI_IMR1_IM6_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM6_Unmasked = 0x1
	// Position of IM7 field.
	EXTI_IMR1_IM7_Pos = 0x7
	// Bit mask of IM7 field.
	EXTI_IMR1_IM7_Msk = 0x80
	// Bit IM7.
	EXTI_IMR1_IM7 = 0x80
	// Interrupt request line is masked
	EXTI_IMR1_IM7_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM7_Unmasked = 0x1
	// Position of IM8 field.
	EXTI_IMR1_IM8_Pos = 0x8
	// Bit mask of IM8 field.
	EXTI_IMR1_IM8_Msk = 0x100
	// Bit IM8.
	EXTI_IMR1_IM8 = 0x100
	// Interrupt request line is masked
	EXTI_IMR1_IM8_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM8_Unmasked = 0x1
	// Position of IM9 field.
	EXTI_IMR1_IM9_Pos = 0x9
	// Bit mask of IM9 field.
	EXTI_IMR1_IM9_Msk = 0x200
	// Bit IM9.
	EXTI_IMR1_IM9 = 0x200
	// Interrupt request line is masked
	EXTI_IMR1_IM9_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM9_Unmasked = 0x1
	// Position of IM10 field.
	EXTI_IMR1_IM10_Pos = 0xa
	// Bit mask of IM10 field.
	EXTI_IMR1_IM10_Msk = 0x400
	// Bit IM10.
	EXTI_IMR1_IM10 = 0x400
	// Interrupt request line is masked
	EXTI_IMR1_IM10_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM10_Unmasked = 0x1
	// Position of IM11 field.
	EXTI_IMR1_IM11_Pos = 0xb
	// Bit mask of IM11 field.
	EXTI_IMR1_IM11_Msk = 0x800
	// Bit IM11.
	EXTI_IMR1_IM11 = 0x800
	// Interrupt request line is masked
	EXTI_IMR1_IM11_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM11_Unmasked = 0x1
	// Position of IM12 field.
	EXTI_IMR1_IM12_Pos = 0xc
	// Bit mask of IM12 field.
	EXTI_IMR1_IM12_Msk = 0x1000
	// Bit IM12.
	EXTI_IMR1_IM12 = 0x1000
	// Interrupt request line is masked
	EXTI_IMR1_IM12_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM12_Unmasked = 0x1
	// Position of IM13 field.
	EXTI_IMR1_IM13_Pos = 0xd
	// Bit mask of IM13 field.
	EXTI_IMR1_IM13_Msk = 0x2000
	// Bit IM13.
	EXTI_IMR1_IM13 = 0x2000
	// Interrupt request line is masked
	EXTI_IMR1_IM13_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM13_Unmasked = 0x1
	// Position of IM14 field.
	EXTI_IMR1_IM14_Pos = 0xe
	// Bit mask of IM14 field.
	EXTI_IMR1_IM14_Msk = 0x4000
	// Bit IM14.
	EXTI_IMR1_IM14 = 0x4000
	// Interrupt request line is masked
	EXTI_IMR1_IM14_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM14_Unmasked = 0x1
	// Position of IM15 field.
	EXTI_IMR1_IM15_Pos = 0xf
	// Bit mask of IM15 field.
	EXTI_IMR1_IM15_Msk = 0x8000
	// Bit IM15.
	EXTI_IMR1_IM15 = 0x8000
	// Interrupt request line is masked
	EXTI_IMR1_IM15_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM15_Unmasked = 0x1
	// Position of IM16 field.
	EXTI_IMR1_IM16_Pos = 0x10
	// Bit mask of IM16 field.
	EXTI_IMR1_IM16_Msk = 0x10000
	// Bit IM16.
	EXTI_IMR1_IM16 = 0x10000
	// Interrupt request line is masked
	EXTI_IMR1_IM16_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM16_Unmasked = 0x1
	// Position of IM19 field.
	EXTI_IMR1_IM19_Pos = 0x13
	// Bit mask of IM19 field.
	EXTI_IMR1_IM19_Msk = 0x80000
	// Bit IM19.
	EXTI_IMR1_IM19 = 0x80000
	// Interrupt request line is masked
	EXTI_IMR1_IM19_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM19_Unmasked = 0x1
	// Position of IM20 field.
	EXTI_IMR1_IM20_Pos = 0x14
	// Bit mask of IM20 field.
	EXTI_IMR1_IM20_Msk = 0x100000
	// Bit IM20.
	EXTI_IMR1_IM20 = 0x100000
	// Interrupt request line is masked
	EXTI_IMR1_IM20_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM20_Unmasked = 0x1
	// Position of IM21 field.
	EXTI_IMR1_IM21_Pos = 0x15
	// Bit mask of IM21 field.
	EXTI_IMR1_IM21_Msk = 0x200000
	// Bit IM21.
	EXTI_IMR1_IM21 = 0x200000
	// Interrupt request line is masked
	EXTI_IMR1_IM21_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM21_Unmasked = 0x1
	// Position of IM22 field.
	EXTI_IMR1_IM22_Pos = 0x16
	// Bit mask of IM22 field.
	EXTI_IMR1_IM22_Msk = 0x400000
	// Bit IM22.
	EXTI_IMR1_IM22 = 0x400000
	// Interrupt request line is masked
	EXTI_IMR1_IM22_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM22_Unmasked = 0x1
	// Position of IM23 field.
	EXTI_IMR1_IM23_Pos = 0x17
	// Bit mask of IM23 field.
	EXTI_IMR1_IM23_Msk = 0x800000
	// Bit IM23.
	EXTI_IMR1_IM23 = 0x800000
	// Interrupt request line is masked
	EXTI_IMR1_IM23_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM23_Unmasked = 0x1
	// Position of IM24 field.
	EXTI_IMR1_IM24_Pos = 0x18
	// Bit mask of IM24 field.
	EXTI_IMR1_IM24_Msk = 0x1000000
	// Bit IM24.
	EXTI_IMR1_IM24 = 0x1000000
	// Interrupt request line is masked
	EXTI_IMR1_IM24_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM24_Unmasked = 0x1
	// Position of IM25 field.
	EXTI_IMR1_IM25_Pos = 0x19
	// Bit mask of IM25 field.
	EXTI_IMR1_IM25_Msk = 0x2000000
	// Bit IM25.
	EXTI_IMR1_IM25 = 0x2000000
	// Interrupt request line is masked
	EXTI_IMR1_IM25_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM25_Unmasked = 0x1
	// Position of IM26 field.
	EXTI_IMR1_IM26_Pos = 0x1a
	// Bit mask of IM26 field.
	EXTI_IMR1_IM26_Msk = 0x4000000
	// Bit IM26.
	EXTI_IMR1_IM26 = 0x4000000
	// Interrupt request line is masked
	EXTI_IMR1_IM26_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM26_Unmasked = 0x1
	// Position of IM28 field.
	EXTI_IMR1_IM28_Pos = 0x1c
	// Bit mask of IM28 field.
	EXTI_IMR1_IM28_Msk = 0x10000000
	// Bit IM28.
	EXTI_IMR1_IM28 = 0x10000000
	// Interrupt request line is masked
	EXTI_IMR1_IM28_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM28_Unmasked = 0x1
	// Position of IM29 field.
	EXTI_IMR1_IM29_Pos = 0x1d
	// Bit mask of IM29 field.
	EXTI_IMR1_IM29_Msk = 0x20000000
	// Bit IM29.
	EXTI_IMR1_IM29 = 0x20000000
	// Interrupt request line is masked
	EXTI_IMR1_IM29_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM29_Unmasked = 0x1
	// Position of IM30 field.
	EXTI_IMR1_IM30_Pos = 0x1e
	// Bit mask of IM30 field.
	EXTI_IMR1_IM30_Msk = 0x40000000
	// Bit IM30.
	EXTI_IMR1_IM30 = 0x40000000
	// Interrupt request line is masked
	EXTI_IMR1_IM30_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM30_Unmasked = 0x1
	// Position of IM31 field.
	EXTI_IMR1_IM31_Pos = 0x1f
	// Bit mask of IM31 field.
	EXTI_IMR1_IM31_Msk = 0x80000000
	// Bit IM31.
	EXTI_IMR1_IM31 = 0x80000000
	// Interrupt request line is masked
	EXTI_IMR1_IM31_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM31_Unmasked = 0x1

	// EMR1: EXTI CPU wakeup with event mask register
	// Position of EM0 field.
	EXTI_EMR1_EM0_Pos = 0x0
	// Bit mask of EM0 field.
	EXTI_EMR1_EM0_Msk = 0x1
	// Bit EM0.
	EXTI_EMR1_EM0 = 0x1
	// Interrupt request line is masked
	EXTI_EMR1_EM0_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM0_Unmasked = 0x1
	// Position of EM1 field.
	EXTI_EMR1_EM1_Pos = 0x1
	// Bit mask of EM1 field.
	EXTI_EMR1_EM1_Msk = 0x2
	// Bit EM1.
	EXTI_EMR1_EM1 = 0x2
	// Interrupt request line is masked
	EXTI_EMR1_EM1_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM1_Unmasked = 0x1
	// Position of EM2 field.
	EXTI_EMR1_EM2_Pos = 0x2
	// Bit mask of EM2 field.
	EXTI_EMR1_EM2_Msk = 0x4
	// Bit EM2.
	EXTI_EMR1_EM2 = 0x4
	// Interrupt request line is masked
	EXTI_EMR1_EM2_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM2_Unmasked = 0x1
	// Position of EM3 field.
	EXTI_EMR1_EM3_Pos = 0x3
	// Bit mask of EM3 field.
	EXTI_EMR1_EM3_Msk = 0x8
	// Bit EM3.
	EXTI_EMR1_EM3 = 0x8
	// Interrupt request line is masked
	EXTI_EMR1_EM3_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM3_Unmasked = 0x1
	// Position of EM4 field.
	EXTI_EMR1_EM4_Pos = 0x4
	// Bit mask of EM4 field.
	EXTI_EMR1_EM4_Msk = 0x10
	// Bit EM4.
	EXTI_EMR1_EM4 = 0x10
	// Interrupt request line is masked
	EXTI_EMR1_EM4_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM4_Unmasked = 0x1
	// Position of EM5 field.
	EXTI_EMR1_EM5_Pos = 0x5
	// Bit mask of EM5 field.
	EXTI_EMR1_EM5_Msk = 0x20
	// Bit EM5.
	EXTI_EMR1_EM5 = 0x20
	// Interrupt request line is masked
	EXTI_EMR1_EM5_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM5_Unmasked = 0x1
	// Position of EM6 field.
	EXTI_EMR1_EM6_Pos = 0x6
	// Bit mask of EM6 field.
	EXTI_EMR1_EM6_Msk = 0x40
	// Bit EM6.
	EXTI_EMR1_EM6 = 0x40
	// Interrupt request line is masked
	EXTI_EMR1_EM6_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM6_Unmasked = 0x1
	// Position of EM7 field.
	EXTI_EMR1_EM7_Pos = 0x7
	// Bit mask of EM7 field.
	EXTI_EMR1_EM7_Msk = 0x80
	// Bit EM7.
	EXTI_EMR1_EM7 = 0x80
	// Interrupt request line is masked
	EXTI_EMR1_EM7_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM7_Unmasked = 0x1
	// Position of EM8 field.
	EXTI_EMR1_EM8_Pos = 0x8
	// Bit mask of EM8 field.
	EXTI_EMR1_EM8_Msk = 0x100
	// Bit EM8.
	EXTI_EMR1_EM8 = 0x100
	// Interrupt request line is masked
	EXTI_EMR1_EM8_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM8_Unmasked = 0x1
	// Position of EM9 field.
	EXTI_EMR1_EM9_Pos = 0x9
	// Bit mask of EM9 field.
	EXTI_EMR1_EM9_Msk = 0x200
	// Bit EM9.
	EXTI_EMR1_EM9 = 0x200
	// Interrupt request line is masked
	EXTI_EMR1_EM9_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM9_Unmasked = 0x1
	// Position of EM10 field.
	EXTI_EMR1_EM10_Pos = 0xa
	// Bit mask of EM10 field.
	EXTI_EMR1_EM10_Msk = 0x400
	// Bit EM10.
	EXTI_EMR1_EM10 = 0x400
	// Interrupt request line is masked
	EXTI_EMR1_EM10_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM10_Unmasked = 0x1
	// Position of EM11 field.
	EXTI_EMR1_EM11_Pos = 0xb
	// Bit mask of EM11 field.
	EXTI_EMR1_EM11_Msk = 0x800
	// Bit EM11.
	EXTI_EMR1_EM11 = 0x800
	// Interrupt request line is masked
	EXTI_EMR1_EM11_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM11_Unmasked = 0x1
	// Position of EM12 field.
	EXTI_EMR1_EM12_Pos = 0xc
	// Bit mask of EM12 field.
	EXTI_EMR1_EM12_Msk = 0x1000
	// Bit EM12.
	EXTI_EMR1_EM12 = 0x1000
	// Interrupt request line is masked
	EXTI_EMR1_EM12_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM12_Unmasked = 0x1
	// Position of EM13 field.
	EXTI_EMR1_EM13_Pos = 0xd
	// Bit mask of EM13 field.
	EXTI_EMR1_EM13_Msk = 0x2000
	// Bit EM13.
	EXTI_EMR1_EM13 = 0x2000
	// Interrupt request line is masked
	EXTI_EMR1_EM13_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM13_Unmasked = 0x1
	// Position of EM14 field.
	EXTI_EMR1_EM14_Pos = 0xe
	// Bit mask of EM14 field.
	EXTI_EMR1_EM14_Msk = 0x4000
	// Bit EM14.
	EXTI_EMR1_EM14 = 0x4000
	// Interrupt request line is masked
	EXTI_EMR1_EM14_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM14_Unmasked = 0x1
	// Position of EM15 field.
	EXTI_EMR1_EM15_Pos = 0xf
	// Bit mask of EM15 field.
	EXTI_EMR1_EM15_Msk = 0x8000
	// Bit EM15.
	EXTI_EMR1_EM15 = 0x8000
	// Interrupt request line is masked
	EXTI_EMR1_EM15_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM15_Unmasked = 0x1
	// Position of EM16 field.
	EXTI_EMR1_EM16_Pos = 0x10
	// Bit mask of EM16 field.
	EXTI_EMR1_EM16_Msk = 0x10000
	// Bit EM16.
	EXTI_EMR1_EM16 = 0x10000
	// Interrupt request line is masked
	EXTI_EMR1_EM16_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM16_Unmasked = 0x1
	// Position of EM19 field.
	EXTI_EMR1_EM19_Pos = 0x13
	// Bit mask of EM19 field.
	EXTI_EMR1_EM19_Msk = 0x80000
	// Bit EM19.
	EXTI_EMR1_EM19 = 0x80000
	// Interrupt request line is masked
	EXTI_EMR1_EM19_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM19_Unmasked = 0x1
	// Position of EM21 field.
	EXTI_EMR1_EM21_Pos = 0x15
	// Bit mask of EM21 field.
	EXTI_EMR1_EM21_Msk = 0x200000
	// Bit EM21.
	EXTI_EMR1_EM21 = 0x200000
	// Interrupt request line is masked
	EXTI_EMR1_EM21_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM21_Unmasked = 0x1
	// Position of EM23 field.
	EXTI_EMR1_EM23_Pos = 0x17
	// Bit mask of EM23 field.
	EXTI_EMR1_EM23_Msk = 0x800000
	// Bit EM23.
	EXTI_EMR1_EM23 = 0x800000
	// Interrupt request line is masked
	EXTI_EMR1_EM23_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM23_Unmasked = 0x1
	// Position of EM25 field.
	EXTI_EMR1_EM25_Pos = 0x19
	// Bit mask of EM25 field.
	EXTI_EMR1_EM25_Msk = 0x2000000
	// Bit EM25.
	EXTI_EMR1_EM25 = 0x2000000
	// Interrupt request line is masked
	EXTI_EMR1_EM25_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM25_Unmasked = 0x1
	// Position of EM26 field.
	EXTI_EMR1_EM26_Pos = 0x1a
	// Bit mask of EM26 field.
	EXTI_EMR1_EM26_Msk = 0x4000000
	// Bit EM26.
	EXTI_EMR1_EM26 = 0x4000000
	// Interrupt request line is masked
	EXTI_EMR1_EM26_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM26_Unmasked = 0x1
	// Position of EM28 field.
	EXTI_EMR1_EM28_Pos = 0x1c
	// Bit mask of EM28 field.
	EXTI_EMR1_EM28_Msk = 0x10000000
	// Bit EM28.
	EXTI_EMR1_EM28 = 0x10000000
	// Interrupt request line is masked
	EXTI_EMR1_EM28_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM28_Unmasked = 0x1
	// Position of EM29 field.
	EXTI_EMR1_EM29_Pos = 0x1d
	// Bit mask of EM29 field.
	EXTI_EMR1_EM29_Msk = 0x20000000
	// Bit EM29.
	EXTI_EMR1_EM29 = 0x20000000
	// Interrupt request line is masked
	EXTI_EMR1_EM29_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM29_Unmasked = 0x1
	// Position of EM30 field.
	EXTI_EMR1_EM30_Pos = 0x1e
	// Bit mask of EM30 field.
	EXTI_EMR1_EM30_Msk = 0x40000000
	// Bit EM30.
	EXTI_EMR1_EM30 = 0x40000000
	// Interrupt request line is masked
	EXTI_EMR1_EM30_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM30_Unmasked = 0x1
	// Position of EM31 field.
	EXTI_EMR1_EM31_Pos = 0x1f
	// Bit mask of EM31 field.
	EXTI_EMR1_EM31_Msk = 0x80000000
	// Bit EM31.
	EXTI_EMR1_EM31 = 0x80000000
	// Interrupt request line is masked
	EXTI_EMR1_EM31_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM31_Unmasked = 0x1
)

// Bitfields for TIM16: General purpose timers
const (
	// CR1: control register 1
	// Position of CEN field.
	TIM_CR1_CEN_Pos = 0x0
	// Bit mask of CEN field.
	TIM_CR1_CEN_Msk = 0x1
	// Bit CEN.
	TIM_CR1_CEN = 0x1
	// Position of UDIS field.
	TIM_CR1_UDIS_Pos = 0x1
	// Bit mask of UDIS field.
	TIM_CR1_UDIS_Msk = 0x2
	// Bit UDIS.
	TIM_CR1_UDIS = 0x2
	// Position of URS field.
	TIM_CR1_URS_Pos = 0x2
	// Bit mask of URS field.
	TIM_CR1_URS_Msk = 0x4
	// Bit URS.
	TIM_CR1_URS = 0x4
	// Position of OPM field.
	TIM_CR1_OPM_Pos = 0x3
	// Bit mask of OPM field.
	TIM_CR1_OPM_Msk = 0x8
	// Bit OPM.
	TIM_CR1_OPM = 0x8
	// Position of ARPE field.
	TIM_CR1_ARPE_Pos = 0x7
	// Bit mask of ARPE field.
	TIM_CR1_ARPE_Msk = 0x80
	// Bit ARPE.
	TIM_CR1_ARPE = 0x80
	// Position of CKD field.
	TIM_CR1_CKD_Pos = 0x8
	// Bit mask of CKD field.
	TIM_CR1_CKD_Msk = 0x300
	// Position of UIFREMAP field.
	TIM_CR1_UIFREMAP_Pos = 0xb
	// Bit mask of UIFREMAP field.
	TIM_CR1_UIFREMAP_Msk = 0x800
	// Bit UIFREMAP.
	TIM_CR1_UIFREMAP = 0x800

	// CR2: control register 2
	// Position of OIS1N field.
	TIM_CR2_OIS1N_Pos = 0x9
	// Bit mask of OIS1N field.
	TIM_CR2_OIS1N_Msk = 0x200
	// Bit OIS1N.
	TIM_CR2_OIS1N = 0x200
	// Position of OIS1 field.
	TIM_CR2_OIS1_Pos = 0x8
	// Bit mask of OIS1 field.
	TIM_CR2_OIS1_Msk = 0x100
	// Bit OIS1.
	TIM_CR2_OIS1 = 0x100
	// Position of CCDS field.
	TIM_CR2_CCDS_Pos = 0x3
	// Bit mask of CCDS field.
	TIM_CR2_CCDS_Msk = 0x8
	// Bit CCDS.
	TIM_CR2_CCDS = 0x8
	// Position of CCUS field.
	TIM_CR2_CCUS_Pos = 0x2
	// Bit mask of CCUS field.
	TIM_CR2_CCUS_Msk = 0x4
	// Bit CCUS.
	TIM_CR2_CCUS = 0x4
	// Position of CCPC field.
	TIM_CR2_CCPC_Pos = 0x0
	// Bit mask of CCPC field.
	TIM_CR2_CCPC_Msk = 0x1
	// Bit CCPC.
	TIM_CR2_CCPC = 0x1

	// DIER: DMA/Interrupt enable register
	// Position of COMDE field.
	TIM_DIER_COMDE_Pos = 0xd
	// Bit mask of COMDE field.
	TIM_DIER_COMDE_Msk = 0x2000
	// Bit COMDE.
	TIM_DIER_COMDE = 0x2000
	// Position of CC1DE field.
	TIM_DIER_CC1DE_Pos = 0x9
	// Bit mask of CC1DE field.
	TIM_DIER_CC1DE_Msk = 0x200
	// Bit CC1DE.
	TIM_DIER_CC1DE = 0x200
	// Position of UDE field.
	TIM_DIER_UDE_Pos = 0x8
	// Bit mask of UDE field.
	TIM_DIER_UDE_Msk = 0x100
	// Bit UDE.
	TIM_DIER_UDE = 0x100
	// Position of BIE field.
	TIM_DIER_BIE_Pos = 0x7
	// Bit mask of BIE field.
	TIM_DIER_BIE_Msk = 0x80
	// Bit BIE.
	TIM_DIER_BIE = 0x80
	// Position of COMIE field.
	TIM_DIER_COMIE_Pos = 0x5
	// Bit mask of COMIE field.
	TIM_DIER_COMIE_Msk = 0x20
	// Bit COMIE.
	TIM_DIER_COMIE = 0x20
	// Position of CC1IE field.
	TIM_DIER_CC1IE_Pos = 0x1
	// Bit mask of CC1IE field.
	TIM_DIER_CC1IE_Msk = 0x2
	// Bit CC1IE.
	TIM_DIER_CC1IE = 0x2
	// Position of UIE field.
	TIM_DIER_UIE_Pos = 0x0
	// Bit mask of UIE field.
	TIM_DIER_UIE_Msk = 0x1
	// Bit UIE.
	TIM_DIER_UIE = 0x1

	// SR: status register
	// Position of CC1OF field.
	TIM_SR_CC1OF_Pos = 0x9
	// Bit mask of CC1OF field.
	TIM_SR_CC1OF_Msk = 0x200
	// Bit CC1OF.
	TIM_SR_CC1OF = 0x200
	// Position of BIF field.
	TIM_SR_BIF_Pos = 0x7
	// Bit mask of BIF field.
	TIM_SR_BIF_Msk = 0x80
	// Bit BIF.
	TIM_SR_BIF = 0x80
	// Position of COMIF field.
	TIM_SR_COMIF_Pos = 0x5
	// Bit mask of COMIF field.
	TIM_SR_COMIF_Msk = 0x20
	// Bit COMIF.
	TIM_SR_COMIF = 0x20
	// Position of CC1IF field.
	TIM_SR_CC1IF_Pos = 0x1
	// Bit mask of CC1IF field.
	TIM_SR_CC1IF_Msk = 0x2
	// Bit CC1IF.
	TIM_SR_CC1IF = 0x2
	// Position of UIF field.
	TIM_SR_UIF_Pos = 0x0
	// Bit mask of UIF field.
	TIM_SR_UIF_Msk = 0x1
	// Bit UIF.
	TIM_SR_UIF = 0x1

	// EGR: event generation register
	// Position of BG field.
	TIM_EGR_BG_Pos = 0x7
	// Bit mask of BG field.
	TIM_EGR_BG_Msk = 0x80
	// Bit BG.
	TIM_EGR_BG = 0x80
	// Position of COMG field.
	TIM_EGR_COMG_Pos = 0x5
	// Bit mask of COMG field.
	TIM_EGR_COMG_Msk = 0x20
	// Bit COMG.
	TIM_EGR_COMG = 0x20
	// Position of CC1G field.
	TIM_EGR_CC1G_Pos = 0x1
	// Bit mask of CC1G field.
	TIM_EGR_CC1G_Msk = 0x2
	// Bit CC1G.
	TIM_EGR_CC1G = 0x2
	// Position of UG field.
	TIM_EGR_UG_Pos = 0x0
	// Bit mask of UG field.
	TIM_EGR_UG_Msk = 0x1
	// Bit UG.
	TIM_EGR_UG = 0x1

	// CCMR1_Output: capture/compare mode register (output mode)
	// Position of OC1M_2 field.
	TIM_CCMR1_Output_OC1M_2_Pos = 0x10
	// Bit mask of OC1M_2 field.
	TIM_CCMR1_Output_OC1M_2_Msk = 0x10000
	// Bit OC1M_2.
	TIM_CCMR1_Output_OC1M_2 = 0x10000
	// Position of OC1M field.
	TIM_CCMR1_Output_OC1M_Pos = 0x4
	// Bit mask of OC1M field.
	TIM_CCMR1_Output_OC1M_Msk = 0x70
	// Position of OC1PE field.
	TIM_CCMR1_Output_OC1PE_Pos = 0x3
	// Bit mask of OC1PE field.
	TIM_CCMR1_Output_OC1PE_Msk = 0x8
	// Bit OC1PE.
	TIM_CCMR1_Output_OC1PE = 0x8
	// Position of OC1FE field.
	TIM_CCMR1_Output_OC1FE_Pos = 0x2
	// Bit mask of OC1FE field.
	TIM_CCMR1_Output_OC1FE_Msk = 0x4
	// Bit OC1FE.
	TIM_CCMR1_Output_OC1FE = 0x4
	// Position of CC1S field.
	TIM_CCMR1_Output_CC1S_Pos = 0x0
	// Bit mask of CC1S field.
	TIM_CCMR1_Output_CC1S_Msk = 0x3

	// CCMR1_Input: capture/compare mode register 1 (input mode)
	// Position of IC1F field.
	TIM_CCMR1_Input_IC1F_Pos = 0x4
	// Bit mask of IC1F field.
	TIM_CCMR1_Input_IC1F_Msk = 0xf0
	// Position of IC1PSC field.
	TIM_CCMR1_Input_IC1PSC_Pos = 0x2
	// Bit mask of IC1PSC field.
	TIM_CCMR1_Input_IC1PSC_Msk = 0xc
	// Position of CC1S field.
	TIM_CCMR1_Input_CC1S_Pos = 0x0
	// Bit mask of CC1S field.
	TIM_CCMR1_Input_CC1S_Msk = 0x3

	// CCER: capture/compare enable register
	// Position of CC1NP field.
	TIM_CCER_CC1NP_Pos = 0x3
	// Bit mask of CC1NP field.
	TIM_CCER_CC1NP_Msk = 0x8
	// Bit CC1NP.
	TIM_CCER_CC1NP = 0x8
	// Position of CC1NE field.
	TIM_CCER_CC1NE_Pos = 0x2
	// Bit mask of CC1NE field.
	TIM_CCER_CC1NE_Msk = 0x4
	// Bit CC1NE.
	TIM_CCER_CC1NE = 0x4
	// Position of CC1P field.
	TIM_CCER_CC1P_Pos = 0x1
	// Bit mask of CC1P field.
	TIM_CCER_CC1P_Msk = 0x2
	// Bit CC1P.
	TIM_CCER_CC1P = 0x2
	// Position of CC1E field.
	TIM_CCER_CC1E_Pos = 0x0
	// Bit mask of CC1E field.
	TIM_CCER_CC1E_Msk = 0x1
	// Bit CC1E.
	TIM_CCER_CC1E = 0x1

	// CNT: counter
	// Position of CNT field.
	TIM_CNT_CNT_Pos = 0x0
	// Bit mask of CNT field.
	TIM_CNT_CNT_Msk = 0xffff
	// Position of UIFCPY field.
	TIM_CNT_UIFCPY_Pos = 0x1f
	// Bit mask of UIFCPY field.
	TIM_CNT_UIFCPY_Msk = 0x80000000
	// Bit UIFCPY.
	TIM_CNT_UIFCPY = 0x80000000

	// PSC: prescaler
	// Position of PSC field.
	TIM_PSC_PSC_Pos = 0x0
	// Bit mask of PSC field.
	TIM_PSC_PSC_Msk = 0xffff

	// ARR: auto-reload register
	// Position of ARR field.
	TIM_ARR_ARR_Pos = 0x0
	// Bit mask of ARR field.
	TIM_ARR_ARR_Msk = 0xffff

	// RCR: repetition counter register
	// Position of REP field.
	TIM_RCR_REP_Pos = 0x0
	// Bit mask of REP field.
	TIM_RCR_REP_Msk = 0xff

	// CCR1: capture/compare register 1
	// Position of CCR1 field.
	TIM_CCR1_CCR1_Pos = 0x0
	// Bit mask of CCR1 field.
	TIM_CCR1_CCR1_Msk = 0xffff

	// BDTR: break and dead-time register
	// Position of DTG field.
	TIM_BDTR_DTG_Pos = 0x0
	// Bit mask of DTG field.
	TIM_BDTR_DTG_Msk = 0xff
	// Position of LOCK field.
	TIM_BDTR_LOCK_Pos = 0x8
	// Bit mask of LOCK field.
	TIM_BDTR_LOCK_Msk = 0x300
	// Position of OSSI field.
	TIM_BDTR_OSSI_Pos = 0xa
	// Bit mask of OSSI field.
	TIM_BDTR_OSSI_Msk = 0x400
	// Bit OSSI.
	TIM_BDTR_OSSI = 0x400
	// Position of OSSR field.
	TIM_BDTR_OSSR_Pos = 0xb
	// Bit mask of OSSR field.
	TIM_BDTR_OSSR_Msk = 0x800
	// Bit OSSR.
	TIM_BDTR_OSSR = 0x800
	// Position of BKE field.
	TIM_BDTR_BKE_Pos = 0xc
	// Bit mask of BKE field.
	TIM_BDTR_BKE_Msk = 0x1000
	// Bit BKE.
	TIM_BDTR_BKE = 0x1000
	// Position of BKP field.
	TIM_BDTR_BKP_Pos = 0xd
	// Bit mask of BKP field.
	TIM_BDTR_BKP_Msk = 0x2000
	// Bit BKP.
	TIM_BDTR_BKP = 0x2000
	// Position of AOE field.
	TIM_BDTR_AOE_Pos = 0xe
	// Bit mask of AOE field.
	TIM_BDTR_AOE_Msk = 0x4000
	// Bit AOE.
	TIM_BDTR_AOE = 0x4000
	// Position of MOE field.
	TIM_BDTR_MOE_Pos = 0xf
	// Bit mask of MOE field.
	TIM_BDTR_MOE_Msk = 0x8000
	// Bit MOE.
	TIM_BDTR_MOE = 0x8000
	// Position of BKF field.
	TIM_BDTR_BKF_Pos = 0x10
	// Bit mask of BKF field.
	TIM_BDTR_BKF_Msk = 0xf0000
	// Position of BKDSRM field.
	TIM_BDTR_BKDSRM_Pos = 0x1a
	// Bit mask of BKDSRM field.
	TIM_BDTR_BKDSRM_Msk = 0x4000000
	// Bit BKDSRM.
	TIM_BDTR_BKDSRM = 0x4000000
	// Position of BKBID field.
	TIM_BDTR_BKBID_Pos = 0x1c
	// Bit mask of BKBID field.
	TIM_BDTR_BKBID_Msk = 0x10000000
	// Bit BKBID.
	TIM_BDTR_BKBID = 0x10000000

	// DCR: DMA control register
	// Position of DBL field.
	TIM_DCR_DBL_Pos = 0x8
	// Bit mask of DBL field.
	TIM_DCR_DBL_Msk = 0x1f00
	// Position of DBA field.
	TIM_DCR_DBA_Pos = 0x0
	// Bit mask of DBA field.
	TIM_DCR_DBA_Msk = 0x1f

	// DMAR: DMA address for full transfer
	// Position of DMAB field.
	TIM_DMAR_DMAB_Pos = 0x0
	// Bit mask of DMAB field.
	TIM_DMAR_DMAB_Msk = 0xffff

	// AF1: TIM17 option register 1
	// Position of BKINE field.
	TIM_AF1_BKINE_Pos = 0x0
	// Bit mask of BKINE field.
	TIM_AF1_BKINE_Msk = 0x1
	// Bit BKINE.
	TIM_AF1_BKINE = 0x1
	// Position of BKCMP1E field.
	TIM_AF1_BKCMP1E_Pos = 0x1
	// Bit mask of BKCMP1E field.
	TIM_AF1_BKCMP1E_Msk = 0x2
	// Bit BKCMP1E.
	TIM_AF1_BKCMP1E = 0x2
	// Position of BKCMP2E field.
	TIM_AF1_BKCMP2E_Pos = 0x2
	// Bit mask of BKCMP2E field.
	TIM_AF1_BKCMP2E_Msk = 0x4
	// Bit BKCMP2E.
	TIM_AF1_BKCMP2E = 0x4
	// Position of BKDFBK1E field.
	TIM_AF1_BKDFBK1E_Pos = 0x8
	// Bit mask of BKDFBK1E field.
	TIM_AF1_BKDFBK1E_Msk = 0x100
	// Bit BKDFBK1E.
	TIM_AF1_BKDFBK1E = 0x100
	// Position of BKINP field.
	TIM_AF1_BKINP_Pos = 0x9
	// Bit mask of BKINP field.
	TIM_AF1_BKINP_Msk = 0x200
	// Bit BKINP.
	TIM_AF1_BKINP = 0x200
	// Position of BKCMP1P field.
	TIM_AF1_BKCMP1P_Pos = 0xa
	// Bit mask of BKCMP1P field.
	TIM_AF1_BKCMP1P_Msk = 0x400
	// Bit BKCMP1P.
	TIM_AF1_BKCMP1P = 0x400
	// Position of BKCMP2P field.
	TIM_AF1_BKCMP2P_Pos = 0xb
	// Bit mask of BKCMP2P field.
	TIM_AF1_BKCMP2P_Msk = 0x800
	// Bit BKCMP2P.
	TIM_AF1_BKCMP2P = 0x800

	// TISEL: input selection register
	// Position of TI1SEL field.
	TIM_TISEL_TI1SEL_Pos = 0x0
	// Bit mask of TI1SEL field.
	TIM_TISEL_TI1SEL_Msk = 0xf
)

// Bitfields for USART1: Universal synchronous asynchronous receiver transmitter
const (
	// CR1: Control register 1
	// Position of RXFFIE field.
	USART_CR1_RXFFIE_Pos = 0x1f
	// Bit mask of RXFFIE field.
	USART_CR1_RXFFIE_Msk = 0x80000000
	// Bit RXFFIE.
	USART_CR1_RXFFIE = 0x80000000
	// Position of TXFEIE field.
	USART_CR1_TXFEIE_Pos = 0x1e
	// Bit mask of TXFEIE field.
	USART_CR1_TXFEIE_Msk = 0x40000000
	// Bit TXFEIE.
	USART_CR1_TXFEIE = 0x40000000
	// Position of FIFOEN field.
	USART_CR1_FIFOEN_Pos = 0x1d
	// Bit mask of FIFOEN field.
	USART_CR1_FIFOEN_Msk = 0x20000000
	// Bit FIFOEN.
	USART_CR1_FIFOEN = 0x20000000
	// Position of M1 field.
	USART_CR1_M1_Pos = 0x1c
	// Bit mask of M1 field.
	USART_CR1_M1_Msk = 0x10000000
	// Bit M1.
	USART_CR1_M1 = 0x10000000
	// Position of EOBIE field.
	USART_CR1_EOBIE_Pos = 0x1b
	// Bit mask of EOBIE field.
	USART_CR1_EOBIE_Msk = 0x8000000
	// Bit EOBIE.
	USART_CR1_EOBIE = 0x8000000
	// Position of RTOIE field.
	USART_CR1_RTOIE_Pos = 0x1a
	// Bit mask of RTOIE field.
	USART_CR1_RTOIE_Msk = 0x4000000
	// Bit RTOIE.
	USART_CR1_RTOIE = 0x4000000
	// Position of DEAT field.
	USART_CR1_DEAT_Pos = 0x15
	// Bit mask of DEAT field.
	USART_CR1_DEAT_Msk = 0x3e00000
	// Position of DEDT field.
	USART_CR1_DEDT_Pos = 0x10
	// Bit mask of DEDT field.
	USART_CR1_DEDT_Msk = 0x1f0000
	// Position of OVER8 field.
	USART_CR1_OVER8_Pos = 0xf
	// Bit mask of OVER8 field.
	USART_CR1_OVER8_Msk = 0x8000
	// Bit OVER8.
	USART_CR1_OVER8 = 0x8000
	// Position of CMIE field.
	USART_CR1_CMIE_Pos = 0xe
	// Bit mask of CMIE field.
	USART_CR1_CMIE_Msk = 0x4000
	// Bit CMIE.
	USART_CR1_CMIE = 0x4000
	// Position of MME field.
	USART_CR1_MME_Pos = 0xd
	// Bit mask of MME field.
	USART_CR1_MME_Msk = 0x2000
	// Bit MME.
	USART_CR1_MME = 0x2000
	// Position of M0 field.
	USART_CR1_M0_Pos = 0xc
	// Bit mask of M0 field.
	USART_CR1_M0_Msk = 0x1000
	// Bit M0.
	USART_CR1_M0 = 0x1000
	// Position of WAKE field.
	USART_CR1_WAKE_Pos = 0xb
	// Bit mask of WAKE field.
	USART_CR1_WAKE_Msk = 0x800
	// Bit WAKE.
	USART_CR1_WAKE = 0x800
	// Position of PCE field.
	USART_CR1_PCE_Pos = 0xa
	// Bit mask of PCE field.
	USART_CR1_PCE_Msk = 0x400
	// Bit PCE.
	USART_CR1_PCE = 0x400
	// Position of PS field.
	USART_CR1_PS_Pos = 0x9
	// Bit mask of PS field.
	USART_CR1_PS_Msk = 0x200
	// Bit PS.
	USART_CR1_PS = 0x200
	// Position of PEIE field.
	USART_CR1_PEIE_Pos = 0x8
	// Bit mask of PEIE field.
	USART_CR1_PEIE_Msk = 0x100
	// Bit PEIE.
	USART_CR1_PEIE = 0x100
	// Position of TXEIE field.
	USART_CR1_TXEIE_Pos = 0x7
	// Bit mask of TXEIE field.
	USART_CR1_TXEIE_Msk = 0x80
	// Bit TXEIE.
	USART_CR1_TXEIE = 0x80
	// Position of TCIE field.
	USART_CR1_TCIE_Pos = 0x6
	// Bit mask of TCIE field.
	USART_CR1_TCIE_Msk = 0x40
	// Bit TCIE.
	USART_CR1_TCIE = 0x40
	// Position of RXNEIE field.
	USART_CR1_RXNEIE_Pos = 0x5
	// Bit mask of RXNEIE field.
	USART_CR1_RXNEIE_Msk = 0x20
	// Bit RXNEIE.
	USART_CR1_RXNEIE = 0x20
	// Position of IDLEIE field.
	USART_CR1_IDLEIE_Pos = 0x4
	// Bit mask of IDLEIE field.
	USART_CR1_IDLEIE_Msk = 0x10
	// Bit IDLEIE.
	USART_CR1_IDLEIE = 0x10
	// Position of TE field.
	USART_CR1_TE_Pos = 0x3
	// Bit mask of TE field.
	USART_CR1_TE_Msk = 0x8
	// Bit TE.
	USART_CR1_TE = 0x8
	// Position of RE field.
	USART_CR1_RE_Pos = 0x2
	// Bit mask of RE field.
	USART_CR1_RE_Msk = 0x4
	// Bit RE.
	USART_CR1_RE = 0x4
	// Position of UESM field.
	USART_CR1_UESM_Pos = 0x1
	// Bit mask of UESM field.
	USART_CR1_UESM_Msk = 0x2
	// Bit UESM.
	USART_CR1_UESM = 0x2
	// Position of UE field.
	USART_CR1_UE_Pos = 0x0
	// Bit mask of UE field.
	USART_CR1_UE_Msk = 0x1
	// Bit UE.
	USART_CR1_UE = 0x1

	// CR2: Control register 2
	// Position of ADD4_7 field.
	USART_CR2_ADD4_7_Pos = 0x1c
	// Bit mask of ADD4_7 field.
	USART_CR2_ADD4_7_Msk = 0xf0000000
	// Position of ADD0_3 field.
	USART_CR2_ADD0_3_Pos = 0x18
	// Bit mask of ADD0_3 field.
	USART_CR2_ADD0_3_Msk = 0xf000000
	// Position of RTOEN field.
	USART_CR2_RTOEN_Pos = 0x17
	// Bit mask of RTOEN field.
	USART_CR2_RTOEN_Msk = 0x800000
	// Bit RTOEN.
	USART_CR2_RTOEN = 0x800000
	// Position of ABRMOD field.
	USART_CR2_ABRMOD_Pos = 0x15
	// Bit mask of ABRMOD field.
	USART_CR2_ABRMOD_Msk = 0x600000
	// Position of ABREN field.
	USART_CR2_ABREN_Pos = 0x14
	// Bit mask of ABREN field.
	USART_CR2_ABREN_Msk = 0x100000
	// Bit ABREN.
	USART_CR2_ABREN = 0x100000
	// Position of MSBFIRST field.
	USART_CR2_MSBFIRST_Pos = 0x13
	// Bit mask of MSBFIRST field.
	USART_CR2_MSBFIRST_Msk = 0x80000
	// Bit MSBFIRST.
	USART_CR2_MSBFIRST = 0x80000
	// Position of TAINV field.
	USART_CR2_TAINV_Pos = 0x12
	// Bit mask of TAINV field.
	USART_CR2_TAINV_Msk = 0x40000
	// Bit TAINV.
	USART_CR2_TAINV = 0x40000
	// Position of TXINV field.
	USART_CR2_TXINV_Pos = 0x11
	// Bit mask of TXINV field.
	USART_CR2_TXINV_Msk = 0x20000
	// Bit TXINV.
	USART_CR2_TXINV = 0x20000
	// Position of RXINV field.
	USART_CR2_RXINV_Pos = 0x10
	// Bit mask of RXINV field.
	USART_CR2_RXINV_Msk = 0x10000
	// Bit RXINV.
	USART_CR2_RXINV = 0x10000
	// Position of SWAP field.
	USART_CR2_SWAP_Pos = 0xf
	// Bit mask of SWAP field.
	USART_CR2_SWAP_Msk = 0x8000
	// Bit SWAP.
	USART_CR2_SWAP = 0x8000
	// Position of LINEN field.
	USART_CR2_LINEN_Pos = 0xe
	// Bit mask of LINEN field.
	USART_CR2_LINEN_Msk = 0x4000
	// Bit LINEN.
	USART_CR2_LINEN = 0x4000
	// Position of STOP field.
	USART_CR2_STOP_Pos = 0xc
	// Bit mask of STOP field.
	USART_CR2_STOP_Msk = 0x3000
	// Position of CLKEN field.
	USART_CR2_CLKEN_Pos = 0xb
	// Bit mask of CLKEN field.
	USART_CR2_CLKEN_Msk = 0x800
	// Bit CLKEN.
	USART_CR2_CLKEN = 0x800
	// Position of CPOL field.
	USART_CR2_CPOL_Pos = 0xa
	// Bit mask of CPOL field.
	USART_CR2_CPOL_Msk = 0x400
	// Bit CPOL.
	USART_CR2_CPOL = 0x400
	// Position of CPHA field.
	USART_CR2_CPHA_Pos = 0x9
	// Bit mask of CPHA field.
	USART_CR2_CPHA_Msk = 0x200
	// Bit CPHA.
	USART_CR2_CPHA = 0x200
	// Position of LBCL field.
	USART_CR2_LBCL_Pos = 0x8
	// Bit mask of LBCL field.
	USART_CR2_LBCL_Msk = 0x100
	// Bit LBCL.
	USART_CR2_LBCL = 0x100
	// Position of LBDIE field.
	USART_CR2_LBDIE_Pos = 0x6
	// Bit mask of LBDIE field.
	USART_CR2_LBDIE_Msk = 0x40
	// Bit LBDIE.
	USART_CR2_LBDIE = 0x40
	// Position of LBDL field.
	USART_CR2_LBDL_Pos = 0x5
	// Bit mask of LBDL field.
	USART_CR2_LBDL_Msk = 0x20
	// Bit LBDL.
	USART_CR2_LBDL = 0x20
	// Position of ADDM7 field.
	USART_CR2_ADDM7_Pos = 0x4
	// Bit mask of ADDM7 field.
	USART_CR2_ADDM7_Msk = 0x10
	// Bit ADDM7.
	USART_CR2_ADDM7 = 0x10
	// Position of DIS_NSS field.
	USART_CR2_DIS_NSS_Pos = 0x3
	// Bit mask of DIS_NSS field.
	USART_CR2_DIS_NSS_Msk = 0x8
	// Bit DIS_NSS.
	USART_CR2_DIS_NSS = 0x8
	// Position of SLVEN field.
	USART_CR2_SLVEN_Pos = 0x0
	// Bit mask of SLVEN field.
	USART_CR2_SLVEN_Msk = 0x1
	// Bit SLVEN.
	USART_CR2_SLVEN = 0x1

	// CR3: Control register 3
	// Position of TXFTCFG field.
	USART_CR3_TXFTCFG_Pos = 0x1d
	// Bit mask of TXFTCFG field.
	USART_CR3_TXFTCFG_Msk = 0xe0000000
	// Position of RXFTIE field.
	USART_CR3_RXFTIE_Pos = 0x1c
	// Bit mask of RXFTIE field.
	USART_CR3_RXFTIE_Msk = 0x10000000
	// Bit RXFTIE.
	USART_CR3_RXFTIE = 0x10000000
	// Position of RXFTCFG field.
	USART_CR3_RXFTCFG_Pos = 0x19
	// Bit mask of RXFTCFG field.
	USART_CR3_RXFTCFG_Msk = 0xe000000
	// Position of TCBGTIE field.
	USART_CR3_TCBGTIE_Pos = 0x18
	// Bit mask of TCBGTIE field.
	USART_CR3_TCBGTIE_Msk = 0x1000000
	// Bit TCBGTIE.
	USART_CR3_TCBGTIE = 0x1000000
	// Position of TXFTIE field.
	USART_CR3_TXFTIE_Pos = 0x17
	// Bit mask of TXFTIE field.
	USART_CR3_TXFTIE_Msk = 0x800000
	// Bit TXFTIE.
	USART_CR3_TXFTIE = 0x800000
	// Position of WUFIE field.
	USART_CR3_WUFIE_Pos = 0x16
	// Bit mask of WUFIE field.
	USART_CR3_WUFIE_Msk = 0x400000
	// Bit WUFIE.
	USART_CR3_WUFIE = 0x400000
	// Position of WUS field.
	USART_CR3_WUS_Pos = 0x14
	// Bit mask of WUS field.
	USART_CR3_WUS_Msk = 0x300000
	// Position of SCARCNT field.
	USART_CR3_SCARCNT_Pos = 0x11
	// Bit mask of SCARCNT field.
	USART_CR3_SCARCNT_Msk = 0xe0000
	// Position of DEP field.
	USART_CR3_DEP_Pos = 0xf
	// Bit mask of DEP field.
	USART_CR3_DEP_Msk = 0x8000
	// Bit DEP.
	USART_CR3_DEP = 0x8000
	// Position of DEM field.
	USART_CR3_DEM_Pos = 0xe
	// Bit mask of DEM field.
	USART_CR3_DEM_Msk = 0x4000
	// Bit DEM.
	USART_CR3_DEM = 0x4000
	// Position of DDRE field.
	USART_CR3_DDRE_Pos = 0xd
	// Bit mask of DDRE field.
	USART_CR3_DDRE_Msk = 0x2000
	// Bit DDRE.
	USART_CR3_DDRE = 0x2000
	// Position of OVRDIS field.
	USART_CR3_OVRDIS_Pos = 0xc
	// Bit mask of OVRDIS field.
	USART_CR3_OVRDIS_Msk = 0x1000
	// Bit OVRDIS.
	USART_CR3_OVRDIS = 0x1000
	// Position of ONEBIT field.
	USART_CR3_ONEBIT_Pos = 0xb
	// Bit mask of ONEBIT field.
	USART_CR3_ONEBIT_Msk = 0x800
	// Bit ONEBIT.
	USART_CR3_ONEBIT = 0x800
	// Position of CTSIE field.
	USART_CR3_CTSIE_Pos = 0xa
	// Bit mask of CTSIE field.
	USART_CR3_CTSIE_Msk = 0x400
	// Bit CTSIE.
	USART_CR3_CTSIE = 0x400
	// Position of CTSE field.
	USART_CR3_CTSE_Pos = 0x9
	// Bit mask of CTSE field.
	USART_CR3_CTSE_Msk = 0x200
	// Bit CTSE.
	USART_CR3_CTSE = 0x200
	// Position of RTSE field.
	USART_CR3_RTSE_Pos = 0x8
	// Bit mask of RTSE field.
	USART_CR3_RTSE_Msk = 0x100
	// Bit RTSE.
	USART_CR3_RTSE = 0x100
	// Position of DMAT field.
	USART_CR3_DMAT_Pos = 0x7
	// Bit mask of DMAT field.
	USART_CR3_DMAT_Msk = 0x80
	// Bit DMAT.
	USART_CR3_DMAT = 0x80
	// Position of DMAR field.
	USART_CR3_DMAR_Pos = 0x6
	// Bit mask of DMAR field.
	USART_CR3_DMAR_Msk = 0x40
	// Bit DMAR.
	USART_CR3_DMAR = 0x40
	// Position of SCEN field.
	USART_CR3_SCEN_Pos = 0x5
	// Bit mask of SCEN field.
	USART_CR3_SCEN_Msk = 0x20
	// Bit SCEN.
	USART_CR3_SCEN = 0x20
	// Position of NACK field.
	USART_CR3_NACK_Pos = 0x4
	// Bit mask of NACK field.
	USART_CR3_NACK_Msk = 0x10
	// Bit NACK.
	USART_CR3_NACK = 0x10
	// Position of HDSEL field.
	USART_CR3_HDSEL_Pos = 0x3
	// Bit mask of HDSEL field.
	USART_CR3_HDSEL_Msk = 0x8
	// Bit HDSEL.
	USART_CR3_HDSEL = 0x8
	// Position of IRLP field.
	USART_CR3_IRLP_Pos = 0x2
	// Bit mask of IRLP field.
	USART_CR3_IRLP_Msk = 0x4
	// Bit IRLP.
	USART_CR3_IRLP = 0x4
	// Position of IREN field.
	USART_CR3_IREN_Pos = 0x1
	// Bit mask of IREN field.
	USART_CR3_IREN_Msk = 0x2
	// Bit IREN.
	USART_CR3_IREN = 0x2
	// Position of EIE field.
	USART_CR3_EIE_Pos = 0x0
	// Bit mask of EIE field.
	USART_CR3_EIE_Msk = 0x1
	// Bit EIE.
	USART_CR3_EIE = 0x1

	// BRR: Baud rate register
	// Position of BRR_4_15 field.
	USART_BRR_BRR_4_15_Pos = 0x4
	// Bit mask of BRR_4_15 field.
	USART_BRR_BRR_4_15_Msk = 0xfff0
	// Position of BRR_0_3 field.
	USART_BRR_BRR_0_3_Pos = 0x0
	// Bit mask of BRR_0_3 field.
	USART_BRR_BRR_0_3_Msk = 0xf

	// GTPR: Guard time and prescaler register
	// Position of GT field.
	USART_GTPR_GT_Pos = 0x8
	// Bit mask of GT field.
	USART_GTPR_GT_Msk = 0xff00
	// Position of PSC field.
	USART_GTPR_PSC_Pos = 0x0
	// Bit mask of PSC field.
	USART_GTPR_PSC_Msk = 0xff

	// RTOR: Receiver timeout register
	// Position of BLEN field.
	USART_RTOR_BLEN_Pos = 0x18
	// Bit mask of BLEN field.
	USART_RTOR_BLEN_Msk = 0xff000000
	// Position of RTO field.
	USART_RTOR_RTO_Pos = 0x0
	// Bit mask of RTO field.
	USART_RTOR_RTO_Msk = 0xffffff

	// RQR: Request register
	// Position of TXFRQ field.
	USART_RQR_TXFRQ_Pos = 0x4
	// Bit mask of TXFRQ field.
	USART_RQR_TXFRQ_Msk = 0x10
	// Bit TXFRQ.
	USART_RQR_TXFRQ = 0x10
	// Position of RXFRQ field.
	USART_RQR_RXFRQ_Pos = 0x3
	// Bit mask of RXFRQ field.
	USART_RQR_RXFRQ_Msk = 0x8
	// Bit RXFRQ.
	USART_RQR_RXFRQ = 0x8
	// Position of MMRQ field.
	USART_RQR_MMRQ_Pos = 0x2
	// Bit mask of MMRQ field.
	USART_RQR_MMRQ_Msk = 0x4
	// Bit MMRQ.
	USART_RQR_MMRQ = 0x4
	// Position of SBKRQ field.
	USART_RQR_SBKRQ_Pos = 0x1
	// Bit mask of SBKRQ field.
	USART_RQR_SBKRQ_Msk = 0x2
	// Bit SBKRQ.
	USART_RQR_SBKRQ = 0x2
	// Position of ABRRQ field.
	USART_RQR_ABRRQ_Pos = 0x0
	// Bit mask of ABRRQ field.
	USART_RQR_ABRRQ_Msk = 0x1
	// Bit ABRRQ.
	USART_RQR_ABRRQ = 0x1

	// ISR: Interrupt & status register
	// Position of TXFT field.
	USART_ISR_TXFT_Pos = 0x1b
	// Bit mask of TXFT field.
	USART_ISR_TXFT_Msk = 0x8000000
	// Bit TXFT.
	USART_ISR_TXFT = 0x8000000
	// Position of RXFT field.
	USART_ISR_RXFT_Pos = 0x1a
	// Bit mask of RXFT field.
	USART_ISR_RXFT_Msk = 0x4000000
	// Bit RXFT.
	USART_ISR_RXFT = 0x4000000
	// Position of TCBGT field.
	USART_ISR_TCBGT_Pos = 0x19
	// Bit mask of TCBGT field.
	USART_ISR_TCBGT_Msk = 0x2000000
	// Bit TCBGT.
	USART_ISR_TCBGT = 0x2000000
	// Position of RXFF field.
	USART_ISR_RXFF_Pos = 0x18
	// Bit mask of RXFF field.
	USART_ISR_RXFF_Msk = 0x1000000
	// Bit RXFF.
	USART_ISR_RXFF = 0x1000000
	// Position of TXFE field.
	USART_ISR_TXFE_Pos = 0x17
	// Bit mask of TXFE field.
	USART_ISR_TXFE_Msk = 0x800000
	// Bit TXFE.
	USART_ISR_TXFE = 0x800000
	// Position of REACK field.
	USART_ISR_REACK_Pos = 0x16
	// Bit mask of REACK field.
	USART_ISR_REACK_Msk = 0x400000
	// Bit REACK.
	USART_ISR_REACK = 0x400000
	// Position of TEACK field.
	USART_ISR_TEACK_Pos = 0x15
	// Bit mask of TEACK field.
	USART_ISR_TEACK_Msk = 0x200000
	// Bit TEACK.
	USART_ISR_TEACK = 0x200000
	// Position of WUF field.
	USART_ISR_WUF_Pos = 0x14
	// Bit mask of WUF field.
	USART_ISR_WUF_Msk = 0x100000
	// Bit WUF.
	USART_ISR_WUF = 0x100000
	// Position of RWU field.
	USART_ISR_RWU_Pos = 0x13
	// Bit mask of RWU field.
	USART_ISR_RWU_Msk = 0x80000
	// Bit RWU.
	USART_ISR_RWU = 0x80000
	// Position of SBKF field.
	USART_ISR_SBKF_Pos = 0x12
	// Bit mask of SBKF field.
	USART_ISR_SBKF_Msk = 0x40000
	// Bit SBKF.
	USART_ISR_SBKF = 0x40000
	// Position of CMF field.
	USART_ISR_CMF_Pos = 0x11
	// Bit mask of CMF field.
	USART_ISR_CMF_Msk = 0x20000
	// Bit CMF.
	USART_ISR_CMF = 0x20000
	// Position of BUSY field.
	USART_ISR_BUSY_Pos = 0x10
	// Bit mask of BUSY field.
	USART_ISR_BUSY_Msk = 0x10000
	// Bit BUSY.
	USART_ISR_BUSY = 0x10000
	// Position of ABRF field.
	USART_ISR_ABRF_Pos = 0xf
	// Bit mask of ABRF field.
	USART_ISR_ABRF_Msk = 0x8000
	// Bit ABRF.
	USART_ISR_ABRF = 0x8000
	// Position of ABRE field.
	USART_ISR_ABRE_Pos = 0xe
	// Bit mask of ABRE field.
	USART_ISR_ABRE_Msk = 0x4000
	// Bit ABRE.
	USART_ISR_ABRE = 0x4000
	// Position of UDR field.
	USART_ISR_UDR_Pos = 0xd
	// Bit mask of UDR field.
	USART_ISR_UDR_Msk = 0x2000
	// Bit UDR.
	USART_ISR_UDR = 0x2000
	// Position of EOBF field.
	USART_ISR_EOBF_Pos = 0xc
	// Bit mask of EOBF field.
	USART_ISR_EOBF_Msk = 0x1000
	// Bit EOBF.
	USART_ISR_EOBF = 0x1000
	// Position of RTOF field.
	USART_ISR_RTOF_Pos = 0xb
	// Bit mask of RTOF field.
	USART_ISR_RTOF_Msk = 0x800
	// Bit RTOF.
	USART_ISR_RTOF = 0x800
	// Position of CTS field.
	USART_ISR_CTS_Pos = 0xa
	// Bit mask of CTS field.
	USART_ISR_CTS_Msk = 0x400
	// Bit CTS.
	USART_ISR_CTS = 0x400
	// Position of CTSIF field.
	USART_ISR_CTSIF_Pos = 0x9
	// Bit mask of CTSIF field.
	USART_ISR_CTSIF_Msk = 0x200
	// Bit CTSIF.
	USART_ISR_CTSIF = 0x200
	// Position of LBDF field.
	USART_ISR_LBDF_Pos = 0x8
	// Bit mask of LBDF field.
	USART_ISR_LBDF_Msk = 0x100
	// Bit LBDF.
	USART_ISR_LBDF = 0x100
	// Position of TXE field.
	USART_ISR_TXE_Pos = 0x7
	// Bit mask of TXE field.
	USART_ISR_TXE_Msk = 0x80
	// Bit TXE.
	USART_ISR_TXE = 0x80
	// Position of TC field.
	USART_ISR_TC_Pos = 0x6
	// Bit mask of TC field.
	USART_ISR_TC_Msk = 0x40
	// Bit TC.
	USART_ISR_TC = 0x40
	// Position of RXNE field.
	USART_ISR_RXNE_Pos = 0x5
	// Bit mask of RXNE field.
	USART_ISR_RXNE_Msk = 0x20
	// Bit RXNE.
	USART_ISR_RXNE = 0x20
	// Position of IDLE field.
	USART_ISR_IDLE_Pos = 0x4
	// Bit mask of IDLE field.
	USART_ISR_IDLE_Msk = 0x10
	// Bit IDLE.
	USART_ISR_IDLE = 0x10
	// Position of ORE field.
	USART_ISR_ORE_Pos = 0x3
	// Bit mask of ORE field.
	USART_ISR_ORE_Msk = 0x8
	// Bit ORE.
	USART_ISR_ORE = 0x8
	// Position of NF field.
	USART_ISR_NF_Pos = 0x2
	// Bit mask of NF field.
	USART_ISR_NF_Msk = 0x4
	// Bit NF.
	USART_ISR_NF = 0x4
	// Position of FE field.
	USART_ISR_FE_Pos = 0x1
	// Bit mask of FE field.
	USART_ISR_FE_Msk = 0x2
	// Bit FE.
	USART_ISR_FE = 0x2
	// Position of PE field.
	USART_ISR_PE_Pos = 0x0
	// Bit mask of PE field.
	USART_ISR_PE_Msk = 0x1
	// Bit PE.
	USART_ISR_PE = 0x1

	// ICR: Interrupt flag clear register
	// Position of WUCF field.
	USART_ICR_WUCF_Pos = 0x14
	// Bit mask of WUCF field.
	USART_ICR_WUCF_Msk = 0x100000
	// Bit WUCF.
	USART_ICR_WUCF = 0x100000
	// Position of CMCF field.
	USART_ICR_CMCF_Pos = 0x11
	// Bit mask of CMCF field.
	USART_ICR_CMCF_Msk = 0x20000
	// Bit CMCF.
	USART_ICR_CMCF = 0x20000
	// Position of UDRCF field.
	USART_ICR_UDRCF_Pos = 0xd
	// Bit mask of UDRCF field.
	USART_ICR_UDRCF_Msk = 0x2000
	// Bit UDRCF.
	USART_ICR_UDRCF = 0x2000
	// Position of EOBCF field.
	USART_ICR_EOBCF_Pos = 0xc
	// Bit mask of EOBCF field.
	USART_ICR_EOBCF_Msk = 0x1000
	// Bit EOBCF.
	USART_ICR_EOBCF = 0x1000
	// Position of RTOCF field.
	USART_ICR_RTOCF_Pos = 0xb
	// Bit mask of RTOCF field.
	USART_ICR_RTOCF_Msk = 0x800
	// Bit RTOCF.
	USART_ICR_RTOCF = 0x800
	// Position of CTSCF field.
	USART_ICR_CTSCF_Pos = 0x9
	// Bit mask of CTSCF field.
	USART_ICR_CTSCF_Msk = 0x200
	// Bit CTSCF.
	USART_ICR_CTSCF = 0x200
	// Position of LBDCF field.
	USART_ICR_LBDCF_Pos = 0x8
	// Bit mask of LBDCF field.
	USART_ICR_LBDCF_Msk = 0x100
	// Bit LBDCF.
	USART_ICR_LBDCF = 0x100
	// Position of TCBGTCF field.
	USART_ICR_TCBGTCF_Pos = 0x7
	// Bit mask of TCBGTCF field.
	USART_ICR_TCBGTCF_Msk = 0x80
	// Bit TCBGTCF.
	USART_ICR_TCBGTCF = 0x80
	// Position of TCCF field.
	USART_ICR_TCCF_Pos = 0x6
	// Bit mask of TCCF field.
	USART_ICR_TCCF_Msk = 0x40
	// Bit TCCF.
	USART_ICR_TCCF = 0x40
	// Position of TXFECF field.
	USART_ICR_TXFECF_Pos = 0x5
	// Bit mask of TXFECF field.
	USART_ICR_TXFECF_Msk = 0x20
	// Bit TXFECF.
	USART_ICR_TXFECF = 0x20
	// Position of IDLECF field.
	USART_ICR_IDLECF_Pos = 0x4
	// Bit mask of IDLECF field.
	USART_ICR_IDLECF_Msk = 0x10
	// Bit IDLECF.
	USART_ICR_IDLECF = 0x10
	// Position of ORECF field.
	USART_ICR_ORECF_Pos = 0x3
	// Bit mask of ORECF field.
	USART_ICR_ORECF_Msk = 0x8
	// Bit ORECF.
	USART_ICR_ORECF = 0x8
	// Position of NCF field.
	USART_ICR_NCF_Pos = 0x2
	// Bit mask of NCF field.
	USART_ICR_NCF_Msk = 0x4
	// Bit NCF.
	USART_ICR_NCF = 0x4
	// Position of FECF field.
	USART_ICR_FECF_Pos = 0x1
	// Bit mask of FECF field.
	USART_ICR_FECF_Msk = 0x2
	// Bit FECF.
	USART_ICR_FECF = 0x2
	// Position of PECF field.
	USART_ICR_PECF_Pos = 0x0
	// Bit mask of PECF field.
	USART_ICR_PECF_Msk = 0x1
	// Bit PECF.
	USART_ICR_PECF = 0x1

	// RDR: Receive data register
	// Position of RDR field.
	USART_RDR_RDR_Pos = 0x0
	// Bit mask of RDR field.
	USART_RDR_RDR_Msk = 0x1ff

	// TDR: Transmit data register
	// Position of TDR field.
	USART_TDR_TDR_Pos = 0x0
	// Bit mask of TDR field.
	USART_TDR_TDR_Msk = 0x1ff

	// PRESC: Prescaler register
	// Position of PRESCALER field.
	USART_PRESC_PRESCALER_Pos = 0x0
	// Bit mask of PRESCALER field.
	USART_PRESC_PRESCALER_Msk = 0xf
)

// Bitfields for SPI1: Serial peripheral interface/Inter-IC sound
const (
	// CR1: control register 1
	// Position of BIDIMODE field.
	SPI_CR1_BIDIMODE_Pos = 0xf
	// Bit mask of BIDIMODE field.
	SPI_CR1_BIDIMODE_Msk = 0x8000
	// Bit BIDIMODE.
	SPI_CR1_BIDIMODE = 0x8000
	// Position of BIDIOE field.
	SPI_CR1_BIDIOE_Pos = 0xe
	// Bit mask of BIDIOE field.
	SPI_CR1_BIDIOE_Msk = 0x4000
	// Bit BIDIOE.
	SPI_CR1_BIDIOE = 0x4000
	// Position of CRCEN field.
	SPI_CR1_CRCEN_Pos = 0xd
	// Bit mask of CRCEN field.
	SPI_CR1_CRCEN_Msk = 0x2000
	// Bit CRCEN.
	SPI_CR1_CRCEN = 0x2000
	// Position of CRCNEXT field.
	SPI_CR1_CRCNEXT_Pos = 0xc
	// Bit mask of CRCNEXT field.
	SPI_CR1_CRCNEXT_Msk = 0x1000
	// Bit CRCNEXT.
	SPI_CR1_CRCNEXT = 0x1000
	// Position of DFF field.
	SPI_CR1_DFF_Pos = 0xb
	// Bit mask of DFF field.
	SPI_CR1_DFF_Msk = 0x800
	// Bit DFF.
	SPI_CR1_DFF = 0x800
	// Position of RXONLY field.
	SPI_CR1_RXONLY_Pos = 0xa
	// Bit mask of RXONLY field.
	SPI_CR1_RXONLY_Msk = 0x400
	// Bit RXONLY.
	SPI_CR1_RXONLY = 0x400
	// Position of SSM field.
	SPI_CR1_SSM_Pos = 0x9
	// Bit mask of SSM field.
	SPI_CR1_SSM_Msk = 0x200
	// Bit SSM.
	SPI_CR1_SSM = 0x200
	// Position of SSI field.
	SPI_CR1_SSI_Pos = 0x8
	// Bit mask of SSI field.
	SPI_CR1_SSI_Msk = 0x100
	// Bit SSI.
	SPI_CR1_SSI = 0x100
	// Position of LSBFIRST field.
	SPI_CR1_LSBFIRST_Pos = 0x7
	// Bit mask of LSBFIRST field.
	SPI_CR1_LSBFIRST_Msk = 0x80
	// Bit LSBFIRST.
	SPI_CR1_LSBFIRST = 0x80
	// Position of SPE field.
	SPI_CR1_SPE_Pos = 0x6
	// Bit mask of SPE field.
	SPI_CR1_SPE_Msk = 0x40
	// Bit SPE.
	SPI_CR1_SPE = 0x40
	// Position of BR field.
	SPI_CR1_BR_Pos = 0x3
	// Bit mask of BR field.
	SPI_CR1_BR_Msk = 0x38
	// Position of MSTR field.
	SPI_CR1_MSTR_Pos = 0x2
	// Bit mask of MSTR field.
	SPI_CR1_MSTR_Msk = 0x4
	// Bit MSTR.
	SPI_CR1_MSTR = 0x4
	// Position of CPOL field.
	SPI_CR1_CPOL_Pos = 0x1
	// Bit mask of CPOL field.
	SPI_CR1_CPOL_Msk = 0x2
	// Bit CPOL.
	SPI_CR1_CPOL = 0x2
	// Position of CPHA field.
	SPI_CR1_CPHA_Pos = 0x0
	// Bit mask of CPHA field.
	SPI_CR1_CPHA_Msk = 0x1
	// Bit CPHA.
	SPI_CR1_CPHA = 0x1

	// CR2: control register 2
	// Position of RXDMAEN field.
	SPI_CR2_RXDMAEN_Pos = 0x0
	// Bit mask of RXDMAEN field.
	SPI_CR2_RXDMAEN_Msk = 0x1
	// Bit RXDMAEN.
	SPI_CR2_RXDMAEN = 0x1
	// Position of TXDMAEN field.
	SPI_CR2_TXDMAEN_Pos = 0x1
	// Bit mask of TXDMAEN field.
	SPI_CR2_TXDMAEN_Msk = 0x2
	// Bit TXDMAEN.
	SPI_CR2_TXDMAEN = 0x2
	// Position of SSOE field.
	SPI_CR2_SSOE_Pos = 0x2
	// Bit mask of SSOE field.
	SPI_CR2_SSOE_Msk = 0x4
	// Bit SSOE.
	SPI_CR2_SSOE = 0x4
	// Position of NSSP field.
	SPI_CR2_NSSP_Pos = 0x3
	// Bit mask of NSSP field.
	SPI_CR2_NSSP_Msk = 0x8
	// Bit NSSP.
	SPI_CR2_NSSP = 0x8
	// Position of FRF field.
	SPI_CR2_FRF_Pos = 0x4
	// Bit mask of FRF field.
	SPI_CR2_FRF_Msk = 0x10
	// Bit FRF.
	SPI_CR2_FRF = 0x10
	// Position of ERRIE field.
	SPI_CR2_ERRIE_Pos = 0x5
	// Bit mask of ERRIE field.
	SPI_CR2_ERRIE_Msk = 0x20
	// Bit ERRIE.
	SPI_CR2_ERRIE = 0x20
	// Position of RXNEIE field.
	SPI_CR2_RXNEIE_Pos = 0x6
	// Bit mask of RXNEIE field.
	SPI_CR2_RXNEIE_Msk = 0x40
	// Bit RXNEIE.
	SPI_CR2_RXNEIE = 0x40
	// Position of TXEIE field.
	SPI_CR2_TXEIE_Pos = 0x7
	// Bit mask of TXEIE field.
	SPI_CR2_TXEIE_Msk = 0x80
	// Bit TXEIE.
	SPI_CR2_TXEIE = 0x80
	// Position of DS field.
	SPI_CR2_DS_Pos = 0x8
	// Bit mask of DS field.
	SPI_CR2_DS_Msk = 0xf00
	// Position of FRXTH field.
	SPI_CR2_FRXTH_Pos = 0xc
	// Bit mask of FRXTH field.
	SPI_CR2_FRXTH_Msk = 0x1000
	// Bit FRXTH.
	SPI_CR2_FRXTH = 0x1000
	// Position of LDMA_RX field.
	SPI_CR2_LDMA_RX_Pos = 0xd
	// Bit mask of LDMA_RX field.
	SPI_CR2_LDMA_RX_Msk = 0x2000
	// Bit LDMA_RX.
	SPI_CR2_LDMA_RX = 0x2000
	// Position of LDMA_TX field.
	SPI_CR2_LDMA_TX_Pos = 0xe
	// Bit mask of LDMA_TX field.
	SPI_CR2_LDMA_TX_Msk = 0x4000
	// Bit LDMA_TX.
	SPI_CR2_LDMA_TX = 0x4000

	// SR: status register
	// Position of RXNE field.
	SPI_SR_RXNE_Pos = 0x0
	// Bit mask of RXNE field.
	SPI_SR_RXNE_Msk = 0x1
	// Bit RXNE.
	SPI_SR_RXNE = 0x1
	// Position of TXE field.
	SPI_SR_TXE_Pos = 0x1
	// Bit mask of TXE field.
	SPI_SR_TXE_Msk = 0x2
	// Bit TXE.
	SPI_SR_TXE = 0x2
	// Position of CHSIDE field.
	SPI_SR_CHSIDE_Pos = 0x2
	// Bit mask of CHSIDE field.
	SPI_SR_CHSIDE_Msk = 0x4
	// Bit CHSIDE.
	SPI_SR_CHSIDE = 0x4
	// Position of UDR field.
	SPI_SR_UDR_Pos = 0x3
	// Bit mask of UDR field.
	SPI_SR_UDR_Msk = 0x8
	// Bit UDR.
	SPI_SR_UDR = 0x8
	// Position of CRCERR field.
	SPI_SR_CRCERR_Pos = 0x4
	// Bit mask of CRCERR field.
	SPI_SR_CRCERR_Msk = 0x10
	// Bit CRCERR.
	SPI_SR_CRCERR = 0x10
	// Position of MODF field.
	SPI_SR_MODF_Pos = 0x5
	// Bit mask of MODF field.
	SPI_SR_MODF_Msk = 0x20
	// Bit MODF.
	SPI_SR_MODF = 0x20
	// Position of OVR field.
	SPI_SR_OVR_Pos = 0x6
	// Bit mask of OVR field.
	SPI_SR_OVR_Msk = 0x40
	// Bit OVR.
	SPI_SR_OVR = 0x40
	// Position of BSY field.
	SPI_SR_BSY_Pos = 0x7
	// Bit mask of BSY field.
	SPI_SR_BSY_Msk = 0x80
	// Bit BSY.
	SPI_SR_BSY = 0x80
	// Position of TIFRFE field.
	SPI_SR_TIFRFE_Pos = 0x8
	// Bit mask of TIFRFE field.
	SPI_SR_TIFRFE_Msk = 0x100
	// Bit TIFRFE.
	SPI_SR_TIFRFE = 0x100
	// Position of FRLVL field.
	SPI_SR_FRLVL_Pos = 0x9
	// Bit mask of FRLVL field.
	SPI_SR_FRLVL_Msk = 0x600
	// Position of FTLVL field.
	SPI_SR_FTLVL_Pos = 0xb
	// Bit mask of FTLVL field.
	SPI_SR_FTLVL_Msk = 0x1800

	// DR: data register
	// Position of DR field.
	SPI_DR_DR_Pos = 0x0
	// Bit mask of DR field.
	SPI_DR_DR_Msk = 0xffff

	// CRCPR: CRC polynomial register
	// Position of CRCPOLY field.
	SPI_CRCPR_CRCPOLY_Pos = 0x0
	// Bit mask of CRCPOLY field.
	SPI_CRCPR_CRCPOLY_Msk = 0xffff

	// RXCRCR: RX CRC register
	// Position of RxCRC field.
	SPI_RXCRCR_RxCRC_Pos = 0x0
	// Bit mask of RxCRC field.
	SPI_RXCRCR_RxCRC_Msk = 0xffff

	// TXCRCR: TX CRC register
	// Position of TxCRC field.
	SPI_TXCRCR_TxCRC_Pos = 0x0
	// Bit mask of TxCRC field.
	SPI_TXCRCR_TxCRC_Msk = 0xffff

	// I2SCFGR: configuration register
	// Position of CHLEN field.
	SPI_I2SCFGR_CHLEN_Pos = 0x0
	// Bit mask of CHLEN field.
	SPI_I2SCFGR_CHLEN_Msk = 0x1
	// Bit CHLEN.
	SPI_I2SCFGR_CHLEN = 0x1
	// Position of DATLEN field.
	SPI_I2SCFGR_DATLEN_Pos = 0x1
	// Bit mask of DATLEN field.
	SPI_I2SCFGR_DATLEN_Msk = 0x6
	// Position of CKPOL field.
	SPI_I2SCFGR_CKPOL_Pos = 0x3
	// Bit mask of CKPOL field.
	SPI_I2SCFGR_CKPOL_Msk = 0x8
	// Bit CKPOL.
	SPI_I2SCFGR_CKPOL = 0x8
	// Position of I2SSTD field.
	SPI_I2SCFGR_I2SSTD_Pos = 0x4
	// Bit mask of I2SSTD field.
	SPI_I2SCFGR_I2SSTD_Msk = 0x30
	// Position of PCMSYNC field.
	SPI_I2SCFGR_PCMSYNC_Pos = 0x7
	// Bit mask of PCMSYNC field.
	SPI_I2SCFGR_PCMSYNC_Msk = 0x80
	// Bit PCMSYNC.
	SPI_I2SCFGR_PCMSYNC = 0x80
	// Position of I2SCFG field.
	SPI_I2SCFGR_I2SCFG_Pos = 0x8
	// Bit mask of I2SCFG field.
	SPI_I2SCFGR_I2SCFG_Msk = 0x300
	// Position of SE2 field.
	SPI_I2SCFGR_SE2_Pos = 0xa
	// Bit mask of SE2 field.
	SPI_I2SCFGR_SE2_Msk = 0x400
	// Bit SE2.
	SPI_I2SCFGR_SE2 = 0x400
	// Position of I2SMOD field.
	SPI_I2SCFGR_I2SMOD_Pos = 0xb
	// Bit mask of I2SMOD field.
	SPI_I2SCFGR_I2SMOD_Msk = 0x800
	// Bit I2SMOD.
	SPI_I2SCFGR_I2SMOD = 0x800

	// I2SPR: prescaler register
	// Position of I2SDIV field.
	SPI_I2SPR_I2SDIV_Pos = 0x0
	// Bit mask of I2SDIV field.
	SPI_I2SPR_I2SDIV_Msk = 0xff
	// Position of ODD field.
	SPI_I2SPR_ODD_Pos = 0x8
	// Bit mask of ODD field.
	SPI_I2SPR_ODD_Msk = 0x100
	// Bit ODD.
	SPI_I2SPR_ODD = 0x100
	// Position of MCKOE field.
	SPI_I2SPR_MCKOE_Pos = 0x9
	// Bit mask of MCKOE field.
	SPI_I2SPR_MCKOE_Msk = 0x200
	// Bit MCKOE.
	SPI_I2SPR_MCKOE = 0x200
)

// Bitfields for ADC: Analog to Digital Converter instance 1
const (
	// ISR: ADC interrupt and status register
	// Position of CCRDY field.
	ADC_ISR_CCRDY_Pos = 0xd
	// Bit mask of CCRDY field.
	ADC_ISR_CCRDY_Msk = 0x2000
	// Bit CCRDY.
	ADC_ISR_CCRDY = 0x2000
	// Position of EOCAL field.
	ADC_ISR_EOCAL_Pos = 0xb
	// Bit mask of EOCAL field.
	ADC_ISR_EOCAL_Msk = 0x800
	// Bit EOCAL.
	ADC_ISR_EOCAL = 0x800
	// Position of AWD3 field.
	ADC_ISR_AWD3_Pos = 0x9
	// Bit mask of AWD3 field.
	ADC_ISR_AWD3_Msk = 0x200
	// Bit AWD3.
	ADC_ISR_AWD3 = 0x200
	// Position of AWD2 field.
	ADC_ISR_AWD2_Pos = 0x8
	// Bit mask of AWD2 field.
	ADC_ISR_AWD2_Msk = 0x100
	// Bit AWD2.
	ADC_ISR_AWD2 = 0x100
	// Position of AWD1 field.
	ADC_ISR_AWD1_Pos = 0x7
	// Bit mask of AWD1 field.
	ADC_ISR_AWD1_Msk = 0x80
	// Bit AWD1.
	ADC_ISR_AWD1 = 0x80
	// Position of OVR field.
	ADC_ISR_OVR_Pos = 0x4
	// Bit mask of OVR field.
	ADC_ISR_OVR_Msk = 0x10
	// Bit OVR.
	ADC_ISR_OVR = 0x10
	// Position of EOS field.
	ADC_ISR_EOS_Pos = 0x3
	// Bit mask of EOS field.
	ADC_ISR_EOS_Msk = 0x8
	// Bit EOS.
	ADC_ISR_EOS = 0x8
	// Position of EOC field.
	ADC_ISR_EOC_Pos = 0x2
	// Bit mask of EOC field.
	ADC_ISR_EOC_Msk = 0x4
	// Bit EOC.
	ADC_ISR_EOC = 0x4
	// Position of EOSMP field.
	ADC_ISR_EOSMP_Pos = 0x1
	// Bit mask of EOSMP field.
	ADC_ISR_EOSMP_Msk = 0x2
	// Bit EOSMP.
	ADC_ISR_EOSMP = 0x2
	// Position of ADRDY field.
	ADC_ISR_ADRDY_Pos = 0x0
	// Bit mask of ADRDY field.
	ADC_ISR_ADRDY_Msk = 0x1
	// Bit ADRDY.
	ADC_ISR_ADRDY = 0x1

	// IER: ADC interrupt enable register
	// Position of CCRDYIE field.
	ADC_IER_CCRDYIE_Pos = 0xd
	// Bit mask of CCRDYIE field.
	ADC_IER_CCRDYIE_Msk = 0x2000
	// Bit CCRDYIE.
	ADC_IER_CCRDYIE = 0x2000
	// Position of EOCALIE field.
	ADC_IER_EOCALIE_Pos = 0xb
	// Bit mask of EOCALIE field.
	ADC_IER_EOCALIE_Msk = 0x800
	// Bit EOCALIE.
	ADC_IER_EOCALIE = 0x800
	// Position of AWD3IE field.
	ADC_IER_AWD3IE_Pos = 0x9
	// Bit mask of AWD3IE field.
	ADC_IER_AWD3IE_Msk = 0x200
	// Bit AWD3IE.
	ADC_IER_AWD3IE = 0x200
	// Position of AWD2IE field.
	ADC_IER_AWD2IE_Pos = 0x8
	// Bit mask of AWD2IE field.
	ADC_IER_AWD2IE_Msk = 0x100
	// Bit AWD2IE.
	ADC_IER_AWD2IE = 0x100
	// Position of AWD1IE field.
	ADC_IER_AWD1IE_Pos = 0x7
	// Bit mask of AWD1IE field.
	ADC_IER_AWD1IE_Msk = 0x80
	// Bit AWD1IE.
	ADC_IER_AWD1IE = 0x80
	// Position of OVRIE field.
	ADC_IER_OVRIE_Pos = 0x4
	// Bit mask of OVRIE field.
	ADC_IER_OVRIE_Msk = 0x10
	// Bit OVRIE.
	ADC_IER_OVRIE = 0x10
	// Position of EOSIE field.
	ADC_IER_EOSIE_Pos = 0x3
	// Bit mask of EOSIE field.
	ADC_IER_EOSIE_Msk = 0x8
	// Bit EOSIE.
	ADC_IER_EOSIE = 0x8
	// Position of EOCIE field.
	ADC_IER_EOCIE_Pos = 0x2
	// Bit mask of EOCIE field.
	ADC_IER_EOCIE_Msk = 0x4
	// Bit EOCIE.
	ADC_IER_EOCIE = 0x4
	// Position of EOSMPIE field.
	ADC_IER_EOSMPIE_Pos = 0x1
	// Bit mask of EOSMPIE field.
	ADC_IER_EOSMPIE_Msk = 0x2
	// Bit EOSMPIE.
	ADC_IER_EOSMPIE = 0x2
	// Position of ADRDYIE field.
	ADC_IER_ADRDYIE_Pos = 0x0
	// Bit mask of ADRDYIE field.
	ADC_IER_ADRDYIE_Msk = 0x1
	// Bit ADRDYIE.
	ADC_IER_ADRDYIE = 0x1

	// CR: ADC control register
	// Position of ADCAL field.
	ADC_CR_ADCAL_Pos = 0x1f
	// Bit mask of ADCAL field.
	ADC_CR_ADCAL_Msk = 0x80000000
	// Bit ADCAL.
	ADC_CR_ADCAL = 0x80000000
	// Position of ADVREGEN field.
	ADC_CR_ADVREGEN_Pos = 0x1c
	// Bit mask of ADVREGEN field.
	ADC_CR_ADVREGEN_Msk = 0x10000000
	// Bit ADVREGEN.
	ADC_CR_ADVREGEN = 0x10000000
	// Position of ADSTP field.
	ADC_CR_ADSTP_Pos = 0x4
	// Bit mask of ADSTP field.
	ADC_CR_ADSTP_Msk = 0x10
	// Bit ADSTP.
	ADC_CR_ADSTP = 0x10
	// Position of ADSTART field.
	ADC_CR_ADSTART_Pos = 0x2
	// Bit mask of ADSTART field.
	ADC_CR_ADSTART_Msk = 0x4
	// Bit ADSTART.
	ADC_CR_ADSTART = 0x4
	// Position of ADDIS field.
	ADC_CR_ADDIS_Pos = 0x1
	// Bit mask of ADDIS field.
	ADC_CR_ADDIS_Msk = 0x2
	// Bit ADDIS.
	ADC_CR_ADDIS = 0x2
	// Position of ADEN field.
	ADC_CR_ADEN_Pos = 0x0
	// Bit mask of ADEN field.
	ADC_CR_ADEN_Msk = 0x1
	// Bit ADEN.
	ADC_CR_ADEN = 0x1

	// CFGR1: ADC configuration register 1
	// Position of AWDCH1CH field.
	ADC_CFGR1_AWDCH1CH_Pos = 0x1a
	// Bit mask of AWDCH1CH field.
	ADC_CFGR1_AWDCH1CH_Msk = 0x7c000000
	// Position of AWD1EN field.
	ADC_CFGR1_AWD1EN_Pos = 0x17
	// Bit mask of AWD1EN field.
	ADC_CFGR1_AWD1EN_Msk = 0x800000
	// Bit AWD1EN.
	ADC_CFGR1_AWD1EN = 0x800000
	// Position of AWD1SGL field.
	ADC_CFGR1_AWD1SGL_Pos = 0x16
	// Bit mask of AWD1SGL field.
	ADC_CFGR1_AWD1SGL_Msk = 0x400000
	// Bit AWD1SGL.
	ADC_CFGR1_AWD1SGL = 0x400000
	// Position of CHSELRMOD field.
	ADC_CFGR1_CHSELRMOD_Pos = 0x15
	// Bit mask of CHSELRMOD field.
	ADC_CFGR1_CHSELRMOD_Msk = 0x200000
	// Bit CHSELRMOD.
	ADC_CFGR1_CHSELRMOD = 0x200000
	// Position of DISCEN field.
	ADC_CFGR1_DISCEN_Pos = 0x10
	// Bit mask of DISCEN field.
	ADC_CFGR1_DISCEN_Msk = 0x10000
	// Bit DISCEN.
	ADC_CFGR1_DISCEN = 0x10000
	// Position of AUTOFF field.
	ADC_CFGR1_AUTOFF_Pos = 0xf
	// Bit mask of AUTOFF field.
	ADC_CFGR1_AUTOFF_Msk = 0x8000
	// Bit AUTOFF.
	ADC_CFGR1_AUTOFF = 0x8000
	// Position of WAIT field.
	ADC_CFGR1_WAIT_Pos = 0xe
	// Bit mask of WAIT field.
	ADC_CFGR1_WAIT_Msk = 0x4000
	// Bit WAIT.
	ADC_CFGR1_WAIT = 0x4000
	// Position of CONT field.
	ADC_CFGR1_CONT_Pos = 0xd
	// Bit mask of CONT field.
	ADC_CFGR1_CONT_Msk = 0x2000
	// Bit CONT.
	ADC_CFGR1_CONT = 0x2000
	// Position of OVRMOD field.
	ADC_CFGR1_OVRMOD_Pos = 0xc
	// Bit mask of OVRMOD field.
	ADC_CFGR1_OVRMOD_Msk = 0x1000
	// Bit OVRMOD.
	ADC_CFGR1_OVRMOD = 0x1000
	// Position of EXTEN field.
	ADC_CFGR1_EXTEN_Pos = 0xa
	// Bit mask of EXTEN field.
	ADC_CFGR1_EXTEN_Msk = 0xc00
	// Position of EXTSEL field.
	ADC_CFGR1_EXTSEL_Pos = 0x6
	// Bit mask of EXTSEL field.
	ADC_CFGR1_EXTSEL_Msk = 0x1c0
	// Position of ALIGN field.
	ADC_CFGR1_ALIGN_Pos = 0x5
	// Bit mask of ALIGN field.
	ADC_CFGR1_ALIGN_Msk = 0x20
	// Bit ALIGN.
	ADC_CFGR1_ALIGN = 0x20
	// Position of RES field.
	ADC_CFGR1_RES_Pos = 0x3
	// Bit mask of RES field.
	ADC_CFGR1_RES_Msk = 0x18
	// Position of SCANDIR field.
	ADC_CFGR1_SCANDIR_Pos = 0x2
	// Bit mask of SCANDIR field.
	ADC_CFGR1_SCANDIR_Msk = 0x4
	// Bit SCANDIR.
	ADC_CFGR1_SCANDIR = 0x4
	// Position of DMACFG field.
	ADC_CFGR1_DMACFG_Pos = 0x1
	// Bit mask of DMACFG field.
	ADC_CFGR1_DMACFG_Msk = 0x2
	// Bit DMACFG.
	ADC_CFGR1_DMACFG = 0x2
	// Position of DMAEN field.
	ADC_CFGR1_DMAEN_Pos = 0x0
	// Bit mask of DMAEN field.
	ADC_CFGR1_DMAEN_Msk = 0x1
	// Bit DMAEN.
	ADC_CFGR1_DMAEN = 0x1

	// CFGR2: ADC configuration register 2
	// Position of CKMODE field.
	ADC_CFGR2_CKMODE_Pos = 0x1e
	// Bit mask of CKMODE field.
	ADC_CFGR2_CKMODE_Msk = 0xc0000000
	// Position of LFTRIG field.
	ADC_CFGR2_LFTRIG_Pos = 0x1d
	// Bit mask of LFTRIG field.
	ADC_CFGR2_LFTRIG_Msk = 0x20000000
	// Bit LFTRIG.
	ADC_CFGR2_LFTRIG = 0x20000000
	// Position of TOVS field.
	ADC_CFGR2_TOVS_Pos = 0x9
	// Bit mask of TOVS field.
	ADC_CFGR2_TOVS_Msk = 0x200
	// Bit TOVS.
	ADC_CFGR2_TOVS = 0x200
	// Position of OVSS field.
	ADC_CFGR2_OVSS_Pos = 0x5
	// Bit mask of OVSS field.
	ADC_CFGR2_OVSS_Msk = 0x1e0
	// Position of OVSR field.
	ADC_CFGR2_OVSR_Pos = 0x2
	// Bit mask of OVSR field.
	ADC_CFGR2_OVSR_Msk = 0x1c
	// Position of OVSE field.
	ADC_CFGR2_OVSE_Pos = 0x0
	// Bit mask of OVSE field.
	ADC_CFGR2_OVSE_Msk = 0x1
	// Bit OVSE.
	ADC_CFGR2_OVSE = 0x1

	// SMPR: ADC sampling time register
	// Position of SMP1 field.
	ADC_SMPR_SMP1_Pos = 0x0
	// Bit mask of SMP1 field.
	ADC_SMPR_SMP1_Msk = 0x7
	// Position of SMP2 field.
	ADC_SMPR_SMP2_Pos = 0x4
	// Bit mask of SMP2 field.
	ADC_SMPR_SMP2_Msk = 0x70
	// Position of SMPSEL field.
	ADC_SMPR_SMPSEL_Pos = 0x8
	// Bit mask of SMPSEL field.
	ADC_SMPR_SMPSEL_Msk = 0x7ffff00

	// AWD1TR: watchdog threshold register
	// Position of HT1 field.
	ADC_AWD1TR_HT1_Pos = 0x10
	// Bit mask of HT1 field.
	ADC_AWD1TR_HT1_Msk = 0xfff0000
	// Position of LT1 field.
	ADC_AWD1TR_LT1_Pos = 0x0
	// Bit mask of LT1 field.
	ADC_AWD1TR_LT1_Msk = 0xfff

	// AWD2TR: watchdog threshold register
	// Position of HT2 field.
	ADC_AWD2TR_HT2_Pos = 0x10
	// Bit mask of HT2 field.
	ADC_AWD2TR_HT2_Msk = 0xfff0000
	// Position of LT2 field.
	ADC_AWD2TR_LT2_Pos = 0x0
	// Bit mask of LT2 field.
	ADC_AWD2TR_LT2_Msk = 0xfff

	// CHSELR: channel selection register
	// Position of CHSEL field.
	ADC_CHSELR_CHSEL_Pos = 0x0
	// Bit mask of CHSEL field.
	ADC_CHSELR_CHSEL_Msk = 0x7ffff

	// CHSELR_1: channel selection register CHSELRMOD = 1 in ADC_CFGR1
	// Position of SQ1 field.
	ADC_CHSELR_1_SQ1_Pos = 0x0
	// Bit mask of SQ1 field.
	ADC_CHSELR_1_SQ1_Msk = 0xf
	// Position of SQ2 field.
	ADC_CHSELR_1_SQ2_Pos = 0x4
	// Bit mask of SQ2 field.
	ADC_CHSELR_1_SQ2_Msk = 0xf0
	// Position of SQ3 field.
	ADC_CHSELR_1_SQ3_Pos = 0x8
	// Bit mask of SQ3 field.
	ADC_CHSELR_1_SQ3_Msk = 0xf00
	// Position of SQ4 field.
	ADC_CHSELR_1_SQ4_Pos = 0xc
	// Bit mask of SQ4 field.
	ADC_CHSELR_1_SQ4_Msk = 0xf000
	// Position of SQ5 field.
	ADC_CHSELR_1_SQ5_Pos = 0x10
	// Bit mask of SQ5 field.
	ADC_CHSELR_1_SQ5_Msk = 0xf0000
	// Position of SQ6 field.
	ADC_CHSELR_1_SQ6_Pos = 0x14
	// Bit mask of SQ6 field.
	ADC_CHSELR_1_SQ6_Msk = 0xf00000
	// Position of SQ7 field.
	ADC_CHSELR_1_SQ7_Pos = 0x18
	// Bit mask of SQ7 field.
	ADC_CHSELR_1_SQ7_Msk = 0xf000000
	// Position of SQ8 field.
	ADC_CHSELR_1_SQ8_Pos = 0x1c
	// Bit mask of SQ8 field.
	ADC_CHSELR_1_SQ8_Msk = 0xf0000000

	// AWD3TR: watchdog threshold register
	// Position of HT3 field.
	ADC_AWD3TR_HT3_Pos = 0x10
	// Bit mask of HT3 field.
	ADC_AWD3TR_HT3_Msk = 0xfff0000
	// Position of LT3 field.
	ADC_AWD3TR_LT3_Pos = 0x0
	// Bit mask of LT3 field.
	ADC_AWD3TR_LT3_Msk = 0xfff

	// DR: ADC group regular conversion data register
	// Position of REGULARDATA field.
	ADC_DR_REGULARDATA_Pos = 0x0
	// Bit mask of REGULARDATA field.
	ADC_DR_REGULARDATA_Msk = 0xffff

	// AWD2CR: ADC analog watchdog 2 configuration register
	// Position of AWD2CH field.
	ADC_AWD2CR_AWD2CH_Pos = 0x0
	// Bit mask of AWD2CH field.
	ADC_AWD2CR_AWD2CH_Msk = 0x7ffff

	// AWD3CR: ADC analog watchdog 3 configuration register
	// Position of AWD3CH field.
	ADC_AWD3CR_AWD3CH_Pos = 0x0
	// Bit mask of AWD3CH field.
	ADC_AWD3CR_AWD3CH_Msk = 0x7ffff

	// CALFACT: ADC calibration factors register
	// Position of CALFACT field.
	ADC_CALFACT_CALFACT_Pos = 0x0
	// Bit mask of CALFACT field.
	ADC_CALFACT_CALFACT_Msk = 0x7f

	// CCR: ADC common control register
	// Position of PRESC field.
	ADC_CCR_PRESC_Pos = 0x12
	// Bit mask of PRESC field.
	ADC_CCR_PRESC_Msk = 0x3c0000
	// Position of VREFEN field.
	ADC_CCR_VREFEN_Pos = 0x16
	// Bit mask of VREFEN field.
	ADC_CCR_VREFEN_Msk = 0x400000
	// Bit VREFEN.
	ADC_CCR_VREFEN = 0x400000
	// Position of TSEN field.
	ADC_CCR_TSEN_Pos = 0x17
	// Bit mask of TSEN field.
	ADC_CCR_TSEN_Msk = 0x800000
	// Bit TSEN.
	ADC_CCR_TSEN = 0x800000
	// Position of VBATEN field.
	ADC_CCR_VBATEN_Pos = 0x18
	// Bit mask of VBATEN field.
	ADC_CCR_VBATEN_Msk = 0x1000000
	// Bit VBATEN.
	ADC_CCR_VBATEN = 0x1000000
)

// Bitfields for SYSCFG: System configuration controller
const (
	// CFGR1: SYSCFG configuration register 1
	// Position of I2C_PAx_FMP field.
	SYSCFG_CFGR1_I2C_PAx_FMP_Pos = 0x16
	// Bit mask of I2C_PAx_FMP field.
	SYSCFG_CFGR1_I2C_PAx_FMP_Msk = 0xc00000
	// Position of I2C2_FMP field.
	SYSCFG_CFGR1_I2C2_FMP_Pos = 0x15
	// Bit mask of I2C2_FMP field.
	SYSCFG_CFGR1_I2C2_FMP_Msk = 0x200000
	// Bit I2C2_FMP.
	SYSCFG_CFGR1_I2C2_FMP = 0x200000
	// Position of I2C1_FMP field.
	SYSCFG_CFGR1_I2C1_FMP_Pos = 0x14
	// Bit mask of I2C1_FMP field.
	SYSCFG_CFGR1_I2C1_FMP_Msk = 0x100000
	// Bit I2C1_FMP.
	SYSCFG_CFGR1_I2C1_FMP = 0x100000
	// Position of I2C_PBx_FMP field.
	SYSCFG_CFGR1_I2C_PBx_FMP_Pos = 0x10
	// Bit mask of I2C_PBx_FMP field.
	SYSCFG_CFGR1_I2C_PBx_FMP_Msk = 0xf0000
	// Position of BOOSTEN field.
	SYSCFG_CFGR1_BOOSTEN_Pos = 0x8
	// Bit mask of BOOSTEN field.
	SYSCFG_CFGR1_BOOSTEN_Msk = 0x100
	// Bit BOOSTEN.
	SYSCFG_CFGR1_BOOSTEN = 0x100
	// Position of IR_MOD field.
	SYSCFG_CFGR1_IR_MOD_Pos = 0x6
	// Bit mask of IR_MOD field.
	SYSCFG_CFGR1_IR_MOD_Msk = 0xc0
	// Position of IR_POL field.
	SYSCFG_CFGR1_IR_POL_Pos = 0x5
	// Bit mask of IR_POL field.
	SYSCFG_CFGR1_IR_POL_Msk = 0x20
	// Bit IR_POL.
	SYSCFG_CFGR1_IR_POL = 0x20
	// Position of PA11_PA12_RMP field.
	SYSCFG_CFGR1_PA11_PA12_RMP_Pos = 0x4
	// Bit mask of PA11_PA12_RMP field.
	SYSCFG_CFGR1_PA11_PA12_RMP_Msk = 0x10
	// Bit PA11_PA12_RMP.
	SYSCFG_CFGR1_PA11_PA12_RMP = 0x10
	// Position of MEM_MODE field.
	SYSCFG_CFGR1_MEM_MODE_Pos = 0x0
	// Bit mask of MEM_MODE field.
	SYSCFG_CFGR1_MEM_MODE_Msk = 0x3

	// CFGR2: SYSCFG configuration register 1
	// Position of LOCKUP_LOCK field.
	SYSCFG_CFGR2_LOCKUP_LOCK_Pos = 0x0
	// Bit mask of LOCKUP_LOCK field.
	SYSCFG_CFGR2_LOCKUP_LOCK_Msk = 0x1
	// Bit LOCKUP_LOCK.
	SYSCFG_CFGR2_LOCKUP_LOCK = 0x1
	// Position of SRAM_PARITY_LOCK field.
	SYSCFG_CFGR2_SRAM_PARITY_LOCK_Pos = 0x1
	// Bit mask of SRAM_PARITY_LOCK field.
	SYSCFG_CFGR2_SRAM_PARITY_LOCK_Msk = 0x2
	// Bit SRAM_PARITY_LOCK.
	SYSCFG_CFGR2_SRAM_PARITY_LOCK = 0x2
	// Position of PVD_LOCK field.
	SYSCFG_CFGR2_PVD_LOCK_Pos = 0x2
	// Bit mask of PVD_LOCK field.
	SYSCFG_CFGR2_PVD_LOCK_Msk = 0x4
	// Bit PVD_LOCK.
	SYSCFG_CFGR2_PVD_LOCK = 0x4
	// Position of ECC_LOCK field.
	SYSCFG_CFGR2_ECC_LOCK_Pos = 0x3
	// Bit mask of ECC_LOCK field.
	SYSCFG_CFGR2_ECC_LOCK_Msk = 0x8
	// Bit ECC_LOCK.
	SYSCFG_CFGR2_ECC_LOCK = 0x8
	// Position of SRAM_PEF field.
	SYSCFG_CFGR2_SRAM_PEF_Pos = 0x8
	// Bit mask of SRAM_PEF field.
	SYSCFG_CFGR2_SRAM_PEF_Msk = 0x100
	// Bit SRAM_PEF.
	SYSCFG_CFGR2_SRAM_PEF = 0x100
	// Position of PA1_CDEN field.
	SYSCFG_CFGR2_PA1_CDEN_Pos = 0x10
	// Bit mask of PA1_CDEN field.
	SYSCFG_CFGR2_PA1_CDEN_Msk = 0x10000
	// Bit PA1_CDEN.
	SYSCFG_CFGR2_PA1_CDEN = 0x10000
	// Position of PA3_CDEN field.
	SYSCFG_CFGR2_PA3_CDEN_Pos = 0x11
	// Bit mask of PA3_CDEN field.
	SYSCFG_CFGR2_PA3_CDEN_Msk = 0x20000
	// Bit PA3_CDEN.
	SYSCFG_CFGR2_PA3_CDEN = 0x20000
	// Position of PA5_CDEN field.
	SYSCFG_CFGR2_PA5_CDEN_Pos = 0x12
	// Bit mask of PA5_CDEN field.
	SYSCFG_CFGR2_PA5_CDEN_Msk = 0x40000
	// Bit PA5_CDEN.
	SYSCFG_CFGR2_PA5_CDEN = 0x40000
	// Position of PA6_CDEN field.
	SYSCFG_CFGR2_PA6_CDEN_Pos = 0x13
	// Bit mask of PA6_CDEN field.
	SYSCFG_CFGR2_PA6_CDEN_Msk = 0x80000
	// Bit PA6_CDEN.
	SYSCFG_CFGR2_PA6_CDEN = 0x80000
	// Position of PA13_CDEN field.
	SYSCFG_CFGR2_PA13_CDEN_Pos = 0x14
	// Bit mask of PA13_CDEN field.
	SYSCFG_CFGR2_PA13_CDEN_Msk = 0x100000
	// Bit PA13_CDEN.
	SYSCFG_CFGR2_PA13_CDEN = 0x100000
	// Position of PB0_CDEN field.
	SYSCFG_CFGR2_PB0_CDEN_Pos = 0x15
	// Bit mask of PB0_CDEN field.
	SYSCFG_CFGR2_PB0_CDEN_Msk = 0x200000
	// Bit PB0_CDEN.
	SYSCFG_CFGR2_PB0_CDEN = 0x200000
	// Position of PB1_CDEN field.
	SYSCFG_CFGR2_PB1_CDEN_Pos = 0x16
	// Bit mask of PB1_CDEN field.
	SYSCFG_CFGR2_PB1_CDEN_Msk = 0x400000
	// Bit PB1_CDEN.
	SYSCFG_CFGR2_PB1_CDEN = 0x400000
	// Position of PB2_CDEN field.
	SYSCFG_CFGR2_PB2_CDEN_Pos = 0x17
	// Bit mask of PB2_CDEN field.
	SYSCFG_CFGR2_PB2_CDEN_Msk = 0x800000
	// Bit PB2_CDEN.
	SYSCFG_CFGR2_PB2_CDEN = 0x800000
)

// Bitfields for TAMP: Tamper and backup registers
const (
	// CR1: control register 1
	// Position of TAMP1E field.
	TAMP_CR1_TAMP1E_Pos = 0x0
	// Bit mask of TAMP1E field.
	TAMP_CR1_TAMP1E_Msk = 0x1
	// Bit TAMP1E.
	TAMP_CR1_TAMP1E = 0x1
	// Position of TAMP2E field.
	TAMP_CR1_TAMP2E_Pos = 0x1
	// Bit mask of TAMP2E field.
	TAMP_CR1_TAMP2E_Msk = 0x2
	// Bit TAMP2E.
	TAMP_CR1_TAMP2E = 0x2
	// Position of ITAMP1E field.
	TAMP_CR1_ITAMP1E_Pos = 0x10
	// Bit mask of ITAMP1E field.
	TAMP_CR1_ITAMP1E_Msk = 0x10000
	// Bit ITAMP1E.
	TAMP_CR1_ITAMP1E = 0x10000
	// Position of ITAMP3E field.
	TAMP_CR1_ITAMP3E_Pos = 0x12
	// Bit mask of ITAMP3E field.
	TAMP_CR1_ITAMP3E_Msk = 0x40000
	// Bit ITAMP3E.
	TAMP_CR1_ITAMP3E = 0x40000
	// Position of ITAMP4E field.
	TAMP_CR1_ITAMP4E_Pos = 0x13
	// Bit mask of ITAMP4E field.
	TAMP_CR1_ITAMP4E_Msk = 0x80000
	// Bit ITAMP4E.
	TAMP_CR1_ITAMP4E = 0x80000
	// Position of ITAMP5E field.
	TAMP_CR1_ITAMP5E_Pos = 0x14
	// Bit mask of ITAMP5E field.
	TAMP_CR1_ITAMP5E_Msk = 0x100000
	// Bit ITAMP5E.
	TAMP_CR1_ITAMP5E = 0x100000
	// Position of ITAMP6E field.
	TAMP_CR1_ITAMP6E_Pos = 0x15
	// Bit mask of ITAMP6E field.
	TAMP_CR1_ITAMP6E_Msk = 0x200000
	// Bit ITAMP6E.
	TAMP_CR1_ITAMP6E = 0x200000

	// CR2: control register 2
	// Position of TAMP1NOER field.
	TAMP_CR2_TAMP1NOER_Pos = 0x0
	// Bit mask of TAMP1NOER field.
	TAMP_CR2_TAMP1NOER_Msk = 0x1
	// Bit TAMP1NOER.
	TAMP_CR2_TAMP1NOER = 0x1
	// Position of TAMP2NOER field.
	TAMP_CR2_TAMP2NOER_Pos = 0x1
	// Bit mask of TAMP2NOER field.
	TAMP_CR2_TAMP2NOER_Msk = 0x2
	// Bit TAMP2NOER.
	TAMP_CR2_TAMP2NOER = 0x2
	// Position of TAMP1MSK field.
	TAMP_CR2_TAMP1MSK_Pos = 0x10
	// Bit mask of TAMP1MSK field.
	TAMP_CR2_TAMP1MSK_Msk = 0x10000
	// Bit TAMP1MSK.
	TAMP_CR2_TAMP1MSK = 0x10000
	// Position of TAMP2MSK field.
	TAMP_CR2_TAMP2MSK_Pos = 0x11
	// Bit mask of TAMP2MSK field.
	TAMP_CR2_TAMP2MSK_Msk = 0x20000
	// Bit TAMP2MSK.
	TAMP_CR2_TAMP2MSK = 0x20000
	// Position of TAMP1TRG field.
	TAMP_CR2_TAMP1TRG_Pos = 0x18
	// Bit mask of TAMP1TRG field.
	TAMP_CR2_TAMP1TRG_Msk = 0x1000000
	// Bit TAMP1TRG.
	TAMP_CR2_TAMP1TRG = 0x1000000
	// Position of TAMP2TRG field.
	TAMP_CR2_TAMP2TRG_Pos = 0x19
	// Bit mask of TAMP2TRG field.
	TAMP_CR2_TAMP2TRG_Msk = 0x2000000
	// Bit TAMP2TRG.
	TAMP_CR2_TAMP2TRG = 0x2000000

	// FLTCR: TAMP filter control register
	// Position of TAMPFREQ field.
	TAMP_FLTCR_TAMPFREQ_Pos = 0x0
	// Bit mask of TAMPFREQ field.
	TAMP_FLTCR_TAMPFREQ_Msk = 0x7
	// Position of TAMPFLT field.
	TAMP_FLTCR_TAMPFLT_Pos = 0x3
	// Bit mask of TAMPFLT field.
	TAMP_FLTCR_TAMPFLT_Msk = 0x18
	// Position of TAMPPRCH field.
	TAMP_FLTCR_TAMPPRCH_Pos = 0x5
	// Bit mask of TAMPPRCH field.
	TAMP_FLTCR_TAMPPRCH_Msk = 0x60
	// Position of TAMPPUDIS field.
	TAMP_FLTCR_TAMPPUDIS_Pos = 0x7
	// Bit mask of TAMPPUDIS field.
	TAMP_FLTCR_TAMPPUDIS_Msk = 0x80
	// Bit TAMPPUDIS.
	TAMP_FLTCR_TAMPPUDIS = 0x80

	// IER: TAMP interrupt enable register
	// Position of TAMP1IE field.
	TAMP_IER_TAMP1IE_Pos = 0x0
	// Bit mask of TAMP1IE field.
	TAMP_IER_TAMP1IE_Msk = 0x1
	// Bit TAMP1IE.
	TAMP_IER_TAMP1IE = 0x1
	// Position of TAMP2IE field.
	TAMP_IER_TAMP2IE_Pos = 0x1
	// Bit mask of TAMP2IE field.
	TAMP_IER_TAMP2IE_Msk = 0x2
	// Bit TAMP2IE.
	TAMP_IER_TAMP2IE = 0x2
	// Position of ITAMP1IE field.
	TAMP_IER_ITAMP1IE_Pos = 0x10
	// Bit mask of ITAMP1IE field.
	TAMP_IER_ITAMP1IE_Msk = 0x10000
	// Bit ITAMP1IE.
	TAMP_IER_ITAMP1IE = 0x10000
	// Position of ITAMP3IE field.
	TAMP_IER_ITAMP3IE_Pos = 0x12
	// Bit mask of ITAMP3IE field.
	TAMP_IER_ITAMP3IE_Msk = 0x40000
	// Bit ITAMP3IE.
	TAMP_IER_ITAMP3IE = 0x40000
	// Position of ITAMP4IE field.
	TAMP_IER_ITAMP4IE_Pos = 0x13
	// Bit mask of ITAMP4IE field.
	TAMP_IER_ITAMP4IE_Msk = 0x80000
	// Bit ITAMP4IE.
	TAMP_IER_ITAMP4IE = 0x80000
	// Position of ITAMP5IE field.
	TAMP_IER_ITAMP5IE_Pos = 0x14
	// Bit mask of ITAMP5IE field.
	TAMP_IER_ITAMP5IE_Msk = 0x100000
	// Bit ITAMP5IE.
	TAMP_IER_ITAMP5IE = 0x100000
	// Position of ITAMP6IE field.
	TAMP_IER_ITAMP6IE_Pos = 0x15
	// Bit mask of ITAMP6IE field.
	TAMP_IER_ITAMP6IE_Msk = 0x200000
	// Bit ITAMP6IE.
	TAMP_IER_ITAMP6IE = 0x200000

	// SR: TAMP status register
	// Position of TAMP1F field.
	TAMP_SR_TAMP1F_Pos = 0x0
	// Bit mask of TAMP1F field.
	TAMP_SR_TAMP1F_Msk = 0x1
	// Bit TAMP1F.
	TAMP_SR_TAMP1F = 0x1
	// Position of TAMP2F field.
	TAMP_SR_TAMP2F_Pos = 0x1
	// Bit mask of TAMP2F field.
	TAMP_SR_TAMP2F_Msk = 0x2
	// Bit TAMP2F.
	TAMP_SR_TAMP2F = 0x2
	// Position of ITAMP1F field.
	TAMP_SR_ITAMP1F_Pos = 0x10
	// Bit mask of ITAMP1F field.
	TAMP_SR_ITAMP1F_Msk = 0x10000
	// Bit ITAMP1F.
	TAMP_SR_ITAMP1F = 0x10000
	// Position of ITAMP3F field.
	TAMP_SR_ITAMP3F_Pos = 0x12
	// Bit mask of ITAMP3F field.
	TAMP_SR_ITAMP3F_Msk = 0x40000
	// Bit ITAMP3F.
	TAMP_SR_ITAMP3F = 0x40000
	// Position of ITAMP4F field.
	TAMP_SR_ITAMP4F_Pos = 0x13
	// Bit mask of ITAMP4F field.
	TAMP_SR_ITAMP4F_Msk = 0x80000
	// Bit ITAMP4F.
	TAMP_SR_ITAMP4F = 0x80000
	// Position of ITAMP5F field.
	TAMP_SR_ITAMP5F_Pos = 0x14
	// Bit mask of ITAMP5F field.
	TAMP_SR_ITAMP5F_Msk = 0x100000
	// Bit ITAMP5F.
	TAMP_SR_ITAMP5F = 0x100000
	// Position of ITAMP6F field.
	TAMP_SR_ITAMP6F_Pos = 0x15
	// Bit mask of ITAMP6F field.
	TAMP_SR_ITAMP6F_Msk = 0x200000
	// Bit ITAMP6F.
	TAMP_SR_ITAMP6F = 0x200000
	// Position of ITAMP7F field.
	TAMP_SR_ITAMP7F_Pos = 0x16
	// Bit mask of ITAMP7F field.
	TAMP_SR_ITAMP7F_Msk = 0x400000
	// Bit ITAMP7F.
	TAMP_SR_ITAMP7F = 0x400000

	// MISR: TAMP masked interrupt status register
	// Position of TAMP1MF field.
	TAMP_MISR_TAMP1MF_Pos = 0x0
	// Bit mask of TAMP1MF field.
	TAMP_MISR_TAMP1MF_Msk = 0x1
	// Bit TAMP1MF.
	TAMP_MISR_TAMP1MF = 0x1
	// Position of TAMP2MF field.
	TAMP_MISR_TAMP2MF_Pos = 0x1
	// Bit mask of TAMP2MF field.
	TAMP_MISR_TAMP2MF_Msk = 0x2
	// Bit TAMP2MF.
	TAMP_MISR_TAMP2MF = 0x2
	// Position of ITAMP1MF field.
	TAMP_MISR_ITAMP1MF_Pos = 0x10
	// Bit mask of ITAMP1MF field.
	TAMP_MISR_ITAMP1MF_Msk = 0x10000
	// Bit ITAMP1MF.
	TAMP_MISR_ITAMP1MF = 0x10000
	// Position of ITAMP3MF field.
	TAMP_MISR_ITAMP3MF_Pos = 0x12
	// Bit mask of ITAMP3MF field.
	TAMP_MISR_ITAMP3MF_Msk = 0x40000
	// Bit ITAMP3MF.
	TAMP_MISR_ITAMP3MF = 0x40000
	// Position of ITAMP4MF field.
	TAMP_MISR_ITAMP4MF_Pos = 0x13
	// Bit mask of ITAMP4MF field.
	TAMP_MISR_ITAMP4MF_Msk = 0x80000
	// Bit ITAMP4MF.
	TAMP_MISR_ITAMP4MF = 0x80000
	// Position of ITAMP5MF field.
	TAMP_MISR_ITAMP5MF_Pos = 0x14
	// Bit mask of ITAMP5MF field.
	TAMP_MISR_ITAMP5MF_Msk = 0x100000
	// Bit ITAMP5MF.
	TAMP_MISR_ITAMP5MF = 0x100000
	// Position of ITAMP6MF field.
	TAMP_MISR_ITAMP6MF_Pos = 0x15
	// Bit mask of ITAMP6MF field.
	TAMP_MISR_ITAMP6MF_Msk = 0x200000
	// Bit ITAMP6MF.
	TAMP_MISR_ITAMP6MF = 0x200000

	// SCR: TAMP status clear register
	// Position of CTAMP1F field.
	TAMP_SCR_CTAMP1F_Pos = 0x0
	// Bit mask of CTAMP1F field.
	TAMP_SCR_CTAMP1F_Msk = 0x1
	// Bit CTAMP1F.
	TAMP_SCR_CTAMP1F = 0x1
	// Position of CTAMP2F field.
	TAMP_SCR_CTAMP2F_Pos = 0x1
	// Bit mask of CTAMP2F field.
	TAMP_SCR_CTAMP2F_Msk = 0x2
	// Bit CTAMP2F.
	TAMP_SCR_CTAMP2F = 0x2
	// Position of CITAMP1F field.
	TAMP_SCR_CITAMP1F_Pos = 0x10
	// Bit mask of CITAMP1F field.
	TAMP_SCR_CITAMP1F_Msk = 0x10000
	// Bit CITAMP1F.
	TAMP_SCR_CITAMP1F = 0x10000
	// Position of CITAMP3F field.
	TAMP_SCR_CITAMP3F_Pos = 0x12
	// Bit mask of CITAMP3F field.
	TAMP_SCR_CITAMP3F_Msk = 0x40000
	// Bit CITAMP3F.
	TAMP_SCR_CITAMP3F = 0x40000
	// Position of CITAMP4F field.
	TAMP_SCR_CITAMP4F_Pos = 0x13
	// Bit mask of CITAMP4F field.
	TAMP_SCR_CITAMP4F_Msk = 0x80000
	// Bit CITAMP4F.
	TAMP_SCR_CITAMP4F = 0x80000
	// Position of CITAMP5F field.
	TAMP_SCR_CITAMP5F_Pos = 0x14
	// Bit mask of CITAMP5F field.
	TAMP_SCR_CITAMP5F_Msk = 0x100000
	// Bit CITAMP5F.
	TAMP_SCR_CITAMP5F = 0x100000
	// Position of CITAMP6F field.
	TAMP_SCR_CITAMP6F_Pos = 0x15
	// Bit mask of CITAMP6F field.
	TAMP_SCR_CITAMP6F_Msk = 0x200000
	// Bit CITAMP6F.
	TAMP_SCR_CITAMP6F = 0x200000
	// Position of CITAMP7F field.
	TAMP_SCR_CITAMP7F_Pos = 0x16
	// Bit mask of CITAMP7F field.
	TAMP_SCR_CITAMP7F_Msk = 0x400000
	// Bit CITAMP7F.
	TAMP_SCR_CITAMP7F = 0x400000

	// BKP0R: TAMP backup register
	// Position of BKP field.
	TAMP_BKP0R_BKP_Pos = 0x0
	// Bit mask of BKP field.
	TAMP_BKP0R_BKP_Msk = 0xffffffff

	// BKP1R: TAMP backup register
	// Position of BKP field.
	TAMP_BKP1R_BKP_Pos = 0x0
	// Bit mask of BKP field.
	TAMP_BKP1R_BKP_Msk = 0xffffffff

	// BKP2R: TAMP backup register
	// Position of BKP field.
	TAMP_BKP2R_BKP_Pos = 0x0
	// Bit mask of BKP field.
	TAMP_BKP2R_BKP_Msk = 0xffffffff

	// BKP3R: TAMP backup register
	// Position of BKP field.
	TAMP_BKP3R_BKP_Pos = 0x0
	// Bit mask of BKP field.
	TAMP_BKP3R_BKP_Msk = 0xffffffff

	// BKP4R: TAMP backup register
	// Position of BKP field.
	TAMP_BKP4R_BKP_Pos = 0x0
	// Bit mask of BKP field.
	TAMP_BKP4R_BKP_Msk = 0xffffffff
)

// Bitfields for LPTIM1: Low power timer
const (
	// ISR: Interrupt and Status Register
	// Position of DOWN field.
	LPTIM_ISR_DOWN_Pos = 0x6
	// Bit mask of DOWN field.
	LPTIM_ISR_DOWN_Msk = 0x40
	// Bit DOWN.
	LPTIM_ISR_DOWN = 0x40
	// Position of UP field.
	LPTIM_ISR_UP_Pos = 0x5
	// Bit mask of UP field.
	LPTIM_ISR_UP_Msk = 0x20
	// Bit UP.
	LPTIM_ISR_UP = 0x20
	// Position of ARROK field.
	LPTIM_ISR_ARROK_Pos = 0x4
	// Bit mask of ARROK field.
	LPTIM_ISR_ARROK_Msk = 0x10
	// Bit ARROK.
	LPTIM_ISR_ARROK = 0x10
	// Position of CMPOK field.
	LPTIM_ISR_CMPOK_Pos = 0x3
	// Bit mask of CMPOK field.
	LPTIM_ISR_CMPOK_Msk = 0x8
	// Bit CMPOK.
	LPTIM_ISR_CMPOK = 0x8
	// Position of EXTTRIG field.
	LPTIM_ISR_EXTTRIG_Pos = 0x2
	// Bit mask of EXTTRIG field.
	LPTIM_ISR_EXTTRIG_Msk = 0x4
	// Bit EXTTRIG.
	LPTIM_ISR_EXTTRIG = 0x4
	// Position of ARRM field.
	LPTIM_ISR_ARRM_Pos = 0x1
	// Bit mask of ARRM field.
	LPTIM_ISR_ARRM_Msk = 0x2
	// Bit ARRM.
	LPTIM_ISR_ARRM = 0x2
	// Position of CMPM field.
	LPTIM_ISR_CMPM_Pos = 0x0
	// Bit mask of CMPM field.
	LPTIM_ISR_CMPM_Msk = 0x1
	// Bit CMPM.
	LPTIM_ISR_CMPM = 0x1

	// ICR: Interrupt Clear Register
	// Position of DOWNCF field.
	LPTIM_ICR_DOWNCF_Pos = 0x6
	// Bit mask of DOWNCF field.
	LPTIM_ICR_DOWNCF_Msk = 0x40
	// Bit DOWNCF.
	LPTIM_ICR_DOWNCF = 0x40
	// Position of UPCF field.
	LPTIM_ICR_UPCF_Pos = 0x5
	// Bit mask of UPCF field.
	LPTIM_ICR_UPCF_Msk = 0x20
	// Bit UPCF.
	LPTIM_ICR_UPCF = 0x20
	// Position of ARROKCF field.
	LPTIM_ICR_ARROKCF_Pos = 0x4
	// Bit mask of ARROKCF field.
	LPTIM_ICR_ARROKCF_Msk = 0x10
	// Bit ARROKCF.
	LPTIM_ICR_ARROKCF = 0x10
	// Position of CMPOKCF field.
	LPTIM_ICR_CMPOKCF_Pos = 0x3
	// Bit mask of CMPOKCF field.
	LPTIM_ICR_CMPOKCF_Msk = 0x8
	// Bit CMPOKCF.
	LPTIM_ICR_CMPOKCF = 0x8
	// Position of EXTTRIGCF field.
	LPTIM_ICR_EXTTRIGCF_Pos = 0x2
	// Bit mask of EXTTRIGCF field.
	LPTIM_ICR_EXTTRIGCF_Msk = 0x4
	// Bit EXTTRIGCF.
	LPTIM_ICR_EXTTRIGCF = 0x4
	// Position of ARRMCF field.
	LPTIM_ICR_ARRMCF_Pos = 0x1
	// Bit mask of ARRMCF field.
	LPTIM_ICR_ARRMCF_Msk = 0x2
	// Bit ARRMCF.
	LPTIM_ICR_ARRMCF = 0x2
	// Position of CMPMCF field.
	LPTIM_ICR_CMPMCF_Pos = 0x0
	// Bit mask of CMPMCF field.
	LPTIM_ICR_CMPMCF_Msk = 0x1
	// Bit CMPMCF.
	LPTIM_ICR_CMPMCF = 0x1

	// IER: Interrupt Enable Register
	// Position of DOWNIE field.
	LPTIM_IER_DOWNIE_Pos = 0x6
	// Bit mask of DOWNIE field.
	LPTIM_IER_DOWNIE_Msk = 0x40
	// Bit DOWNIE.
	LPTIM_IER_DOWNIE = 0x40
	// Position of UPIE field.
	LPTIM_IER_UPIE_Pos = 0x5
	// Bit mask of UPIE field.
	LPTIM_IER_UPIE_Msk = 0x20
	// Bit UPIE.
	LPTIM_IER_UPIE = 0x20
	// Position of ARROKIE field.
	LPTIM_IER_ARROKIE_Pos = 0x4
	// Bit mask of ARROKIE field.
	LPTIM_IER_ARROKIE_Msk = 0x10
	// Bit ARROKIE.
	LPTIM_IER_ARROKIE = 0x10
	// Position of CMPOKIE field.
	LPTIM_IER_CMPOKIE_Pos = 0x3
	// Bit mask of CMPOKIE field.
	LPTIM_IER_CMPOKIE_Msk = 0x8
	// Bit CMPOKIE.
	LPTIM_IER_CMPOKIE = 0x8
	// Position of EXTTRIGIE field.
	LPTIM_IER_EXTTRIGIE_Pos = 0x2
	// Bit mask of EXTTRIGIE field.
	LPTIM_IER_EXTTRIGIE_Msk = 0x4
	// Bit EXTTRIGIE.
	LPTIM_IER_EXTTRIGIE = 0x4
	// Position of ARRMIE field.
	LPTIM_IER_ARRMIE_Pos = 0x1
	// Bit mask of ARRMIE field.
	LPTIM_IER_ARRMIE_Msk = 0x2
	// Bit ARRMIE.
	LPTIM_IER_ARRMIE = 0x2
	// Position of CMPMIE field.
	LPTIM_IER_CMPMIE_Pos = 0x0
	// Bit mask of CMPMIE field.
	LPTIM_IER_CMPMIE_Msk = 0x1
	// Bit CMPMIE.
	LPTIM_IER_CMPMIE = 0x1

	// CFGR: Configuration Register
	// Position of ENC field.
	LPTIM_CFGR_ENC_Pos = 0x18
	// Bit mask of ENC field.
	LPTIM_CFGR_ENC_Msk = 0x1000000
	// Bit ENC.
	LPTIM_CFGR_ENC = 0x1000000
	// Position of COUNTMODE field.
	LPTIM_CFGR_COUNTMODE_Pos = 0x17
	// Bit mask of COUNTMODE field.
	LPTIM_CFGR_COUNTMODE_Msk = 0x800000
	// Bit COUNTMODE.
	LPTIM_CFGR_COUNTMODE = 0x800000
	// Position of PRELOAD field.
	LPTIM_CFGR_PRELOAD_Pos = 0x16
	// Bit mask of PRELOAD field.
	LPTIM_CFGR_PRELOAD_Msk = 0x400000
	// Bit PRELOAD.
	LPTIM_CFGR_PRELOAD = 0x400000
	// Position of WAVPOL field.
	LPTIM_CFGR_WAVPOL_Pos = 0x15
	// Bit mask of WAVPOL field.
	LPTIM_CFGR_WAVPOL_Msk = 0x200000
	// Bit WAVPOL.
	LPTIM_CFGR_WAVPOL = 0x200000
	// Position of WAVE field.
	LPTIM_CFGR_WAVE_Pos = 0x14
	// Bit mask of WAVE field.
	LPTIM_CFGR_WAVE_Msk = 0x100000
	// Bit WAVE.
	LPTIM_CFGR_WAVE = 0x100000
	// Position of TIMOUT field.
	LPTIM_CFGR_TIMOUT_Pos = 0x13
	// Bit mask of TIMOUT field.
	LPTIM_CFGR_TIMOUT_Msk = 0x80000
	// Bit TIMOUT.
	LPTIM_CFGR_TIMOUT = 0x80000
	// Position of TRIGEN field.
	LPTIM_CFGR_TRIGEN_Pos = 0x11
	// Bit mask of TRIGEN field.
	LPTIM_CFGR_TRIGEN_Msk = 0x60000
	// Position of TRIGSEL field.
	LPTIM_CFGR_TRIGSEL_Pos = 0xd
	// Bit mask of TRIGSEL field.
	LPTIM_CFGR_TRIGSEL_Msk = 0xe000
	// Position of PRESC field.
	LPTIM_CFGR_PRESC_Pos = 0x9
	// Bit mask of PRESC field.
	LPTIM_CFGR_PRESC_Msk = 0xe00
	// Position of TRGFLT field.
	LPTIM_CFGR_TRGFLT_Pos = 0x6
	// Bit mask of TRGFLT field.
	LPTIM_CFGR_TRGFLT_Msk = 0xc0
	// Position of CKFLT field.
	LPTIM_CFGR_CKFLT_Pos = 0x3
	// Bit mask of CKFLT field.
	LPTIM_CFGR_CKFLT_Msk = 0x18
	// Position of CKPOL field.
	LPTIM_CFGR_CKPOL_Pos = 0x1
	// Bit mask of CKPOL field.
	LPTIM_CFGR_CKPOL_Msk = 0x6
	// Position of CKSEL field.
	LPTIM_CFGR_CKSEL_Pos = 0x0
	// Bit mask of CKSEL field.
	LPTIM_CFGR_CKSEL_Msk = 0x1
	// Bit CKSEL.
	LPTIM_CFGR_CKSEL = 0x1

	// CR: Control Register
	// Position of RSTARE field.
	LPTIM_CR_RSTARE_Pos = 0x4
	// Bit mask of RSTARE field.
	LPTIM_CR_RSTARE_Msk = 0x10
	// Bit RSTARE.
	LPTIM_CR_RSTARE = 0x10
	// Position of COUNTRST field.
	LPTIM_CR_COUNTRST_Pos = 0x3
	// Bit mask of COUNTRST field.
	LPTIM_CR_COUNTRST_Msk = 0x8
	// Bit COUNTRST.
	LPTIM_CR_COUNTRST = 0x8
	// Position of CNTSTRT field.
	LPTIM_CR_CNTSTRT_Pos = 0x2
	// Bit mask of CNTSTRT field.
	LPTIM_CR_CNTSTRT_Msk = 0x4
	// Bit CNTSTRT.
	LPTIM_CR_CNTSTRT = 0x4
	// Position of SNGSTRT field.
	LPTIM_CR_SNGSTRT_Pos = 0x1
	// Bit mask of SNGSTRT field.
	LPTIM_CR_SNGSTRT_Msk = 0x2
	// Bit SNGSTRT.
	LPTIM_CR_SNGSTRT = 0x2
	// Position of ENABLE field.
	LPTIM_CR_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	LPTIM_CR_ENABLE_Msk = 0x1
	// Bit ENABLE.
	LPTIM_CR_ENABLE = 0x1

	// CMP: Compare Register
	// Position of CMP field.
	LPTIM_CMP_CMP_Pos = 0x0
	// Bit mask of CMP field.
	LPTIM_CMP_CMP_Msk = 0xffff

	// ARR: Autoreload Register
	// Position of ARR field.
	LPTIM_ARR_ARR_Pos = 0x0
	// Bit mask of ARR field.
	LPTIM_ARR_ARR_Msk = 0xffff

	// CNT: Counter Register
	// Position of CNT field.
	LPTIM_CNT_CNT_Pos = 0x0
	// Bit mask of CNT field.
	LPTIM_CNT_CNT_Msk = 0xffff

	// CFGR2: LPTIM configuration register 2
	// Position of IN2SEL field.
	LPTIM_CFGR2_IN2SEL_Pos = 0x4
	// Bit mask of IN2SEL field.
	LPTIM_CFGR2_IN2SEL_Msk = 0x30
	// Position of IN1SEL field.
	LPTIM_CFGR2_IN1SEL_Pos = 0x0
	// Bit mask of IN1SEL field.
	LPTIM_CFGR2_IN1SEL_Msk = 0x3
)

// Bitfields for I2C1: Inter-integrated circuit
const (
	// CR1: Control register 1
	// Position of PE field.
	I2C_CR1_PE_Pos = 0x0
	// Bit mask of PE field.
	I2C_CR1_PE_Msk = 0x1
	// Bit PE.
	I2C_CR1_PE = 0x1
	// Position of TXIE field.
	I2C_CR1_TXIE_Pos = 0x1
	// Bit mask of TXIE field.
	I2C_CR1_TXIE_Msk = 0x2
	// Bit TXIE.
	I2C_CR1_TXIE = 0x2
	// Position of RXIE field.
	I2C_CR1_RXIE_Pos = 0x2
	// Bit mask of RXIE field.
	I2C_CR1_RXIE_Msk = 0x4
	// Bit RXIE.
	I2C_CR1_RXIE = 0x4
	// Position of ADDRIE field.
	I2C_CR1_ADDRIE_Pos = 0x3
	// Bit mask of ADDRIE field.
	I2C_CR1_ADDRIE_Msk = 0x8
	// Bit ADDRIE.
	I2C_CR1_ADDRIE = 0x8
	// Position of NACKIE field.
	I2C_CR1_NACKIE_Pos = 0x4
	// Bit mask of NACKIE field.
	I2C_CR1_NACKIE_Msk = 0x10
	// Bit NACKIE.
	I2C_CR1_NACKIE = 0x10
	// Position of STOPIE field.
	I2C_CR1_STOPIE_Pos = 0x5
	// Bit mask of STOPIE field.
	I2C_CR1_STOPIE_Msk = 0x20
	// Bit STOPIE.
	I2C_CR1_STOPIE = 0x20
	// Position of TCIE field.
	I2C_CR1_TCIE_Pos = 0x6
	// Bit mask of TCIE field.
	I2C_CR1_TCIE_Msk = 0x40
	// Bit TCIE.
	I2C_CR1_TCIE = 0x40
	// Position of ERRIE field.
	I2C_CR1_ERRIE_Pos = 0x7
	// Bit mask of ERRIE field.
	I2C_CR1_ERRIE_Msk = 0x80
	// Bit ERRIE.
	I2C_CR1_ERRIE = 0x80
	// Position of DNF field.
	I2C_CR1_DNF_Pos = 0x8
	// Bit mask of DNF field.
	I2C_CR1_DNF_Msk = 0xf00
	// Position of ANFOFF field.
	I2C_CR1_ANFOFF_Pos = 0xc
	// Bit mask of ANFOFF field.
	I2C_CR1_ANFOFF_Msk = 0x1000
	// Bit ANFOFF.
	I2C_CR1_ANFOFF = 0x1000
	// Position of TXDMAEN field.
	I2C_CR1_TXDMAEN_Pos = 0xe
	// Bit mask of TXDMAEN field.
	I2C_CR1_TXDMAEN_Msk = 0x4000
	// Bit TXDMAEN.
	I2C_CR1_TXDMAEN = 0x4000
	// Position of RXDMAEN field.
	I2C_CR1_RXDMAEN_Pos = 0xf
	// Bit mask of RXDMAEN field.
	I2C_CR1_RXDMAEN_Msk = 0x8000
	// Bit RXDMAEN.
	I2C_CR1_RXDMAEN = 0x8000
	// Position of SBC field.
	I2C_CR1_SBC_Pos = 0x10
	// Bit mask of SBC field.
	I2C_CR1_SBC_Msk = 0x10000
	// Bit SBC.
	I2C_CR1_SBC = 0x10000
	// Position of NOSTRETCH field.
	I2C_CR1_NOSTRETCH_Pos = 0x11
	// Bit mask of NOSTRETCH field.
	I2C_CR1_NOSTRETCH_Msk = 0x20000
	// Bit NOSTRETCH.
	I2C_CR1_NOSTRETCH = 0x20000
	// Position of WUPEN field.
	I2C_CR1_WUPEN_Pos = 0x12
	// Bit mask of WUPEN field.
	I2C_CR1_WUPEN_Msk = 0x40000
	// Bit WUPEN.
	I2C_CR1_WUPEN = 0x40000
	// Position of GCEN field.
	I2C_CR1_GCEN_Pos = 0x13
	// Bit mask of GCEN field.
	I2C_CR1_GCEN_Msk = 0x80000
	// Bit GCEN.
	I2C_CR1_GCEN = 0x80000
	// Position of SMBHEN field.
	I2C_CR1_SMBHEN_Pos = 0x14
	// Bit mask of SMBHEN field.
	I2C_CR1_SMBHEN_Msk = 0x100000
	// Bit SMBHEN.
	I2C_CR1_SMBHEN = 0x100000
	// Position of SMBDEN field.
	I2C_CR1_SMBDEN_Pos = 0x15
	// Bit mask of SMBDEN field.
	I2C_CR1_SMBDEN_Msk = 0x200000
	// Bit SMBDEN.
	I2C_CR1_SMBDEN = 0x200000
	// Position of ALERTEN field.
	I2C_CR1_ALERTEN_Pos = 0x16
	// Bit mask of ALERTEN field.
	I2C_CR1_ALERTEN_Msk = 0x400000
	// Bit ALERTEN.
	I2C_CR1_ALERTEN = 0x400000
	// Position of PECEN field.
	I2C_CR1_PECEN_Pos = 0x17
	// Bit mask of PECEN field.
	I2C_CR1_PECEN_Msk = 0x800000
	// Bit PECEN.
	I2C_CR1_PECEN = 0x800000

	// CR2: Control register 2
	// Position of PECBYTE field.
	I2C_CR2_PECBYTE_Pos = 0x1a
	// Bit mask of PECBYTE field.
	I2C_CR2_PECBYTE_Msk = 0x4000000
	// Bit PECBYTE.
	I2C_CR2_PECBYTE = 0x4000000
	// Position of AUTOEND field.
	I2C_CR2_AUTOEND_Pos = 0x19
	// Bit mask of AUTOEND field.
	I2C_CR2_AUTOEND_Msk = 0x2000000
	// Bit AUTOEND.
	I2C_CR2_AUTOEND = 0x2000000
	// Position of RELOAD field.
	I2C_CR2_RELOAD_Pos = 0x18
	// Bit mask of RELOAD field.
	I2C_CR2_RELOAD_Msk = 0x1000000
	// Bit RELOAD.
	I2C_CR2_RELOAD = 0x1000000
	// Position of NBYTES field.
	I2C_CR2_NBYTES_Pos = 0x10
	// Bit mask of NBYTES field.
	I2C_CR2_NBYTES_Msk = 0xff0000
	// Position of NACK field.
	I2C_CR2_NACK_Pos = 0xf
	// Bit mask of NACK field.
	I2C_CR2_NACK_Msk = 0x8000
	// Bit NACK.
	I2C_CR2_NACK = 0x8000
	// Position of STOP field.
	I2C_CR2_STOP_Pos = 0xe
	// Bit mask of STOP field.
	I2C_CR2_STOP_Msk = 0x4000
	// Bit STOP.
	I2C_CR2_STOP = 0x4000
	// Position of START field.
	I2C_CR2_START_Pos = 0xd
	// Bit mask of START field.
	I2C_CR2_START_Msk = 0x2000
	// Bit START.
	I2C_CR2_START = 0x2000
	// Position of HEAD10R field.
	I2C_CR2_HEAD10R_Pos = 0xc
	// Bit mask of HEAD10R field.
	I2C_CR2_HEAD10R_Msk = 0x1000
	// Bit HEAD10R.
	I2C_CR2_HEAD10R = 0x1000
	// Position of ADD10 field.
	I2C_CR2_ADD10_Pos = 0xb
	// Bit mask of ADD10 field.
	I2C_CR2_ADD10_Msk = 0x800
	// Bit ADD10.
	I2C_CR2_ADD10 = 0x800
	// Position of RD_WRN field.
	I2C_CR2_RD_WRN_Pos = 0xa
	// Bit mask of RD_WRN field.
	I2C_CR2_RD_WRN_Msk = 0x400
	// Bit RD_WRN.
	I2C_CR2_RD_WRN = 0x400
	// Position of SADD field.
	I2C_CR2_SADD_Pos = 0x0
	// Bit mask of SADD field.
	I2C_CR2_SADD_Msk = 0x3ff

	// OAR1: Own address register 1
	// Position of OA1_0 field.
	I2C_OAR1_OA1_0_Pos = 0x0
	// Bit mask of OA1_0 field.
	I2C_OAR1_OA1_0_Msk = 0x1
	// Bit OA1_0.
	I2C_OAR1_OA1_0 = 0x1
	// Position of OA1_7_1 field.
	I2C_OAR1_OA1_7_1_Pos = 0x1
	// Bit mask of OA1_7_1 field.
	I2C_OAR1_OA1_7_1_Msk = 0xfe
	// Position of OA1_8_9 field.
	I2C_OAR1_OA1_8_9_Pos = 0x8
	// Bit mask of OA1_8_9 field.
	I2C_OAR1_OA1_8_9_Msk = 0x300
	// Position of OA1MODE field.
	I2C_OAR1_OA1MODE_Pos = 0xa
	// Bit mask of OA1MODE field.
	I2C_OAR1_OA1MODE_Msk = 0x400
	// Bit OA1MODE.
	I2C_OAR1_OA1MODE = 0x400
	// Position of OA1EN field.
	I2C_OAR1_OA1EN_Pos = 0xf
	// Bit mask of OA1EN field.
	I2C_OAR1_OA1EN_Msk = 0x8000
	// Bit OA1EN.
	I2C_OAR1_OA1EN = 0x8000

	// OAR2: Own address register 2
	// Position of OA2 field.
	I2C_OAR2_OA2_Pos = 0x1
	// Bit mask of OA2 field.
	I2C_OAR2_OA2_Msk = 0xfe
	// Position of OA2MSK field.
	I2C_OAR2_OA2MSK_Pos = 0x8
	// Bit mask of OA2MSK field.
	I2C_OAR2_OA2MSK_Msk = 0x700
	// Position of OA2EN field.
	I2C_OAR2_OA2EN_Pos = 0xf
	// Bit mask of OA2EN field.
	I2C_OAR2_OA2EN_Msk = 0x8000
	// Bit OA2EN.
	I2C_OAR2_OA2EN = 0x8000

	// TIMINGR: Timing register
	// Position of SCLL field.
	I2C_TIMINGR_SCLL_Pos = 0x0
	// Bit mask of SCLL field.
	I2C_TIMINGR_SCLL_Msk = 0xff
	// Position of SCLH field.
	I2C_TIMINGR_SCLH_Pos = 0x8
	// Bit mask of SCLH field.
	I2C_TIMINGR_SCLH_Msk = 0xff00
	// Position of SDADEL field.
	I2C_TIMINGR_SDADEL_Pos = 0x10
	// Bit mask of SDADEL field.
	I2C_TIMINGR_SDADEL_Msk = 0xf0000
	// Position of SCLDEL field.
	I2C_TIMINGR_SCLDEL_Pos = 0x14
	// Bit mask of SCLDEL field.
	I2C_TIMINGR_SCLDEL_Msk = 0xf00000
	// Position of PRESC field.
	I2C_TIMINGR_PRESC_Pos = 0x1c
	// Bit mask of PRESC field.
	I2C_TIMINGR_PRESC_Msk = 0xf0000000

	// TIMEOUTR: Status register 1
	// Position of TIMEOUTA field.
	I2C_TIMEOUTR_TIMEOUTA_Pos = 0x0
	// Bit mask of TIMEOUTA field.
	I2C_TIMEOUTR_TIMEOUTA_Msk = 0xfff
	// Position of TIDLE field.
	I2C_TIMEOUTR_TIDLE_Pos = 0xc
	// Bit mask of TIDLE field.
	I2C_TIMEOUTR_TIDLE_Msk = 0x1000
	// Bit TIDLE.
	I2C_TIMEOUTR_TIDLE = 0x1000
	// Position of TIMOUTEN field.
	I2C_TIMEOUTR_TIMOUTEN_Pos = 0xf
	// Bit mask of TIMOUTEN field.
	I2C_TIMEOUTR_TIMOUTEN_Msk = 0x8000
	// Bit TIMOUTEN.
	I2C_TIMEOUTR_TIMOUTEN = 0x8000
	// Position of TIMEOUTB field.
	I2C_TIMEOUTR_TIMEOUTB_Pos = 0x10
	// Bit mask of TIMEOUTB field.
	I2C_TIMEOUTR_TIMEOUTB_Msk = 0xfff0000
	// Position of TEXTEN field.
	I2C_TIMEOUTR_TEXTEN_Pos = 0x1f
	// Bit mask of TEXTEN field.
	I2C_TIMEOUTR_TEXTEN_Msk = 0x80000000
	// Bit TEXTEN.
	I2C_TIMEOUTR_TEXTEN = 0x80000000

	// ISR: Interrupt and Status register
	// Position of ADDCODE field.
	I2C_ISR_ADDCODE_Pos = 0x11
	// Bit mask of ADDCODE field.
	I2C_ISR_ADDCODE_Msk = 0xfe0000
	// Position of DIR field.
	I2C_ISR_DIR_Pos = 0x10
	// Bit mask of DIR field.
	I2C_ISR_DIR_Msk = 0x10000
	// Bit DIR.
	I2C_ISR_DIR = 0x10000
	// Position of BUSY field.
	I2C_ISR_BUSY_Pos = 0xf
	// Bit mask of BUSY field.
	I2C_ISR_BUSY_Msk = 0x8000
	// Bit BUSY.
	I2C_ISR_BUSY = 0x8000
	// Position of ALERT field.
	I2C_ISR_ALERT_Pos = 0xd
	// Bit mask of ALERT field.
	I2C_ISR_ALERT_Msk = 0x2000
	// Bit ALERT.
	I2C_ISR_ALERT = 0x2000
	// Position of TIMEOUT field.
	I2C_ISR_TIMEOUT_Pos = 0xc
	// Bit mask of TIMEOUT field.
	I2C_ISR_TIMEOUT_Msk = 0x1000
	// Bit TIMEOUT.
	I2C_ISR_TIMEOUT = 0x1000
	// Position of PECERR field.
	I2C_ISR_PECERR_Pos = 0xb
	// Bit mask of PECERR field.
	I2C_ISR_PECERR_Msk = 0x800
	// Bit PECERR.
	I2C_ISR_PECERR = 0x800
	// Position of OVR field.
	I2C_ISR_OVR_Pos = 0xa
	// Bit mask of OVR field.
	I2C_ISR_OVR_Msk = 0x400
	// Bit OVR.
	I2C_ISR_OVR = 0x400
	// Position of ARLO field.
	I2C_ISR_ARLO_Pos = 0x9
	// Bit mask of ARLO field.
	I2C_ISR_ARLO_Msk = 0x200
	// Bit ARLO.
	I2C_ISR_ARLO = 0x200
	// Position of BERR field.
	I2C_ISR_BERR_Pos = 0x8
	// Bit mask of BERR field.
	I2C_ISR_BERR_Msk = 0x100
	// Bit BERR.
	I2C_ISR_BERR = 0x100
	// Position of TCR field.
	I2C_ISR_TCR_Pos = 0x7
	// Bit mask of TCR field.
	I2C_ISR_TCR_Msk = 0x80
	// Bit TCR.
	I2C_ISR_TCR = 0x80
	// Position of TC field.
	I2C_ISR_TC_Pos = 0x6
	// Bit mask of TC field.
	I2C_ISR_TC_Msk = 0x40
	// Bit TC.
	I2C_ISR_TC = 0x40
	// Position of STOPF field.
	I2C_ISR_STOPF_Pos = 0x5
	// Bit mask of STOPF field.
	I2C_ISR_STOPF_Msk = 0x20
	// Bit STOPF.
	I2C_ISR_STOPF = 0x20
	// Position of NACKF field.
	I2C_ISR_NACKF_Pos = 0x4
	// Bit mask of NACKF field.
	I2C_ISR_NACKF_Msk = 0x10
	// Bit NACKF.
	I2C_ISR_NACKF = 0x10
	// Position of ADDR field.
	I2C_ISR_ADDR_Pos = 0x3
	// Bit mask of ADDR field.
	I2C_ISR_ADDR_Msk = 0x8
	// Bit ADDR.
	I2C_ISR_ADDR = 0x8
	// Position of RXNE field.
	I2C_ISR_RXNE_Pos = 0x2
	// Bit mask of RXNE field.
	I2C_ISR_RXNE_Msk = 0x4
	// Bit RXNE.
	I2C_ISR_RXNE = 0x4
	// Position of TXIS field.
	I2C_ISR_TXIS_Pos = 0x1
	// Bit mask of TXIS field.
	I2C_ISR_TXIS_Msk = 0x2
	// Bit TXIS.
	I2C_ISR_TXIS = 0x2
	// Position of TXE field.
	I2C_ISR_TXE_Pos = 0x0
	// Bit mask of TXE field.
	I2C_ISR_TXE_Msk = 0x1
	// Bit TXE.
	I2C_ISR_TXE = 0x1

	// ICR: Interrupt clear register
	// Position of ALERTCF field.
	I2C_ICR_ALERTCF_Pos = 0xd
	// Bit mask of ALERTCF field.
	I2C_ICR_ALERTCF_Msk = 0x2000
	// Bit ALERTCF.
	I2C_ICR_ALERTCF = 0x2000
	// Position of TIMOUTCF field.
	I2C_ICR_TIMOUTCF_Pos = 0xc
	// Bit mask of TIMOUTCF field.
	I2C_ICR_TIMOUTCF_Msk = 0x1000
	// Bit TIMOUTCF.
	I2C_ICR_TIMOUTCF = 0x1000
	// Position of PECCF field.
	I2C_ICR_PECCF_Pos = 0xb
	// Bit mask of PECCF field.
	I2C_ICR_PECCF_Msk = 0x800
	// Bit PECCF.
	I2C_ICR_PECCF = 0x800
	// Position of OVRCF field.
	I2C_ICR_OVRCF_Pos = 0xa
	// Bit mask of OVRCF field.
	I2C_ICR_OVRCF_Msk = 0x400
	// Bit OVRCF.
	I2C_ICR_OVRCF = 0x400
	// Position of ARLOCF field.
	I2C_ICR_ARLOCF_Pos = 0x9
	// Bit mask of ARLOCF field.
	I2C_ICR_ARLOCF_Msk = 0x200
	// Bit ARLOCF.
	I2C_ICR_ARLOCF = 0x200
	// Position of BERRCF field.
	I2C_ICR_BERRCF_Pos = 0x8
	// Bit mask of BERRCF field.
	I2C_ICR_BERRCF_Msk = 0x100
	// Bit BERRCF.
	I2C_ICR_BERRCF = 0x100
	// Position of STOPCF field.
	I2C_ICR_STOPCF_Pos = 0x5
	// Bit mask of STOPCF field.
	I2C_ICR_STOPCF_Msk = 0x20
	// Bit STOPCF.
	I2C_ICR_STOPCF = 0x20
	// Position of NACKCF field.
	I2C_ICR_NACKCF_Pos = 0x4
	// Bit mask of NACKCF field.
	I2C_ICR_NACKCF_Msk = 0x10
	// Bit NACKCF.
	I2C_ICR_NACKCF = 0x10
	// Position of ADDRCF field.
	I2C_ICR_ADDRCF_Pos = 0x3
	// Bit mask of ADDRCF field.
	I2C_ICR_ADDRCF_Msk = 0x8
	// Bit ADDRCF.
	I2C_ICR_ADDRCF = 0x8

	// PECR: PEC register
	// Position of PEC field.
	I2C_PECR_PEC_Pos = 0x0
	// Bit mask of PEC field.
	I2C_PECR_PEC_Msk = 0xff

	// RXDR: Receive data register
	// Position of RXDATA field.
	I2C_RXDR_RXDATA_Pos = 0x0
	// Bit mask of RXDATA field.
	I2C_RXDR_RXDATA_Msk = 0xff

	// TXDR: Transmit data register
	// Position of TXDATA field.
	I2C_TXDR_TXDATA_Pos = 0x0
	// Bit mask of TXDATA field.
	I2C_TXDR_TXDATA_Msk = 0xff
)

// Bitfields for RTC: Real-time clock
const (
	// TR: time register
	// Position of PM field.
	RTC_TR_PM_Pos = 0x16
	// Bit mask of PM field.
	RTC_TR_PM_Msk = 0x400000
	// Bit PM.
	RTC_TR_PM = 0x400000
	// Position of HT field.
	RTC_TR_HT_Pos = 0x14
	// Bit mask of HT field.
	RTC_TR_HT_Msk = 0x300000
	// Position of HU field.
	RTC_TR_HU_Pos = 0x10
	// Bit mask of HU field.
	RTC_TR_HU_Msk = 0xf0000
	// Position of MNT field.
	RTC_TR_MNT_Pos = 0xc
	// Bit mask of MNT field.
	RTC_TR_MNT_Msk = 0x7000
	// Position of MNU field.
	RTC_TR_MNU_Pos = 0x8
	// Bit mask of MNU field.
	RTC_TR_MNU_Msk = 0xf00
	// Position of ST field.
	RTC_TR_ST_Pos = 0x4
	// Bit mask of ST field.
	RTC_TR_ST_Msk = 0x70
	// Position of SU field.
	RTC_TR_SU_Pos = 0x0
	// Bit mask of SU field.
	RTC_TR_SU_Msk = 0xf

	// DR: date register
	// Position of YT field.
	RTC_DR_YT_Pos = 0x14
	// Bit mask of YT field.
	RTC_DR_YT_Msk = 0xf00000
	// Position of YU field.
	RTC_DR_YU_Pos = 0x10
	// Bit mask of YU field.
	RTC_DR_YU_Msk = 0xf0000
	// Position of WDU field.
	RTC_DR_WDU_Pos = 0xd
	// Bit mask of WDU field.
	RTC_DR_WDU_Msk = 0xe000
	// Position of MT field.
	RTC_DR_MT_Pos = 0xc
	// Bit mask of MT field.
	RTC_DR_MT_Msk = 0x1000
	// Bit MT.
	RTC_DR_MT = 0x1000
	// Position of MU field.
	RTC_DR_MU_Pos = 0x8
	// Bit mask of MU field.
	RTC_DR_MU_Msk = 0xf00
	// Position of DT field.
	RTC_DR_DT_Pos = 0x4
	// Bit mask of DT field.
	RTC_DR_DT_Msk = 0x30
	// Position of DU field.
	RTC_DR_DU_Pos = 0x0
	// Bit mask of DU field.
	RTC_DR_DU_Msk = 0xf

	// SSR: sub second register
	// Position of SS field.
	RTC_SSR_SS_Pos = 0x0
	// Bit mask of SS field.
	RTC_SSR_SS_Msk = 0xffff

	// ICSR: initialization and status register
	// Position of ALRAWF field.
	RTC_ICSR_ALRAWF_Pos = 0x0
	// Bit mask of ALRAWF field.
	RTC_ICSR_ALRAWF_Msk = 0x1
	// Bit ALRAWF.
	RTC_ICSR_ALRAWF = 0x1
	// Position of ALRBWF field.
	RTC_ICSR_ALRBWF_Pos = 0x1
	// Bit mask of ALRBWF field.
	RTC_ICSR_ALRBWF_Msk = 0x2
	// Bit ALRBWF.
	RTC_ICSR_ALRBWF = 0x2
	// Position of WUTWF field.
	RTC_ICSR_WUTWF_Pos = 0x2
	// Bit mask of WUTWF field.
	RTC_ICSR_WUTWF_Msk = 0x4
	// Bit WUTWF.
	RTC_ICSR_WUTWF = 0x4
	// Position of SHPF field.
	RTC_ICSR_SHPF_Pos = 0x3
	// Bit mask of SHPF field.
	RTC_ICSR_SHPF_Msk = 0x8
	// Bit SHPF.
	RTC_ICSR_SHPF = 0x8
	// Position of INITS field.
	RTC_ICSR_INITS_Pos = 0x4
	// Bit mask of INITS field.
	RTC_ICSR_INITS_Msk = 0x10
	// Bit INITS.
	RTC_ICSR_INITS = 0x10
	// Position of RSF field.
	RTC_ICSR_RSF_Pos = 0x5
	// Bit mask of RSF field.
	RTC_ICSR_RSF_Msk = 0x20
	// Bit RSF.
	RTC_ICSR_RSF = 0x20
	// Position of INITF field.
	RTC_ICSR_INITF_Pos = 0x6
	// Bit mask of INITF field.
	RTC_ICSR_INITF_Msk = 0x40
	// Bit INITF.
	RTC_ICSR_INITF = 0x40
	// Position of INIT field.
	RTC_ICSR_INIT_Pos = 0x7
	// Bit mask of INIT field.
	RTC_ICSR_INIT_Msk = 0x80
	// Bit INIT.
	RTC_ICSR_INIT = 0x80
	// Position of RECALPF field.
	RTC_ICSR_RECALPF_Pos = 0x10
	// Bit mask of RECALPF field.
	RTC_ICSR_RECALPF_Msk = 0x10000
	// Bit RECALPF.
	RTC_ICSR_RECALPF = 0x10000

	// PRER: prescaler register
	// Position of PREDIV_A field.
	RTC_PRER_PREDIV_A_Pos = 0x10
	// Bit mask of PREDIV_A field.
	RTC_PRER_PREDIV_A_Msk = 0x7f0000
	// Position of PREDIV_S field.
	RTC_PRER_PREDIV_S_Pos = 0x0
	// Bit mask of PREDIV_S field.
	RTC_PRER_PREDIV_S_Msk = 0x7fff

	// WUTR: wakeup timer register
	// Position of WUT field.
	RTC_WUTR_WUT_Pos = 0x0
	// Bit mask of WUT field.
	RTC_WUTR_WUT_Msk = 0xffff

	// CR: control register
	// Position of WUCKSEL field.
	RTC_CR_WUCKSEL_Pos = 0x0
	// Bit mask of WUCKSEL field.
	RTC_CR_WUCKSEL_Msk = 0x7
	// Position of TSEDGE field.
	RTC_CR_TSEDGE_Pos = 0x3
	// Bit mask of TSEDGE field.
	RTC_CR_TSEDGE_Msk = 0x8
	// Bit TSEDGE.
	RTC_CR_TSEDGE = 0x8
	// Position of REFCKON field.
	RTC_CR_REFCKON_Pos = 0x4
	// Bit mask of REFCKON field.
	RTC_CR_REFCKON_Msk = 0x10
	// Bit REFCKON.
	RTC_CR_REFCKON = 0x10
	// Position of BYPSHAD field.
	RTC_CR_BYPSHAD_Pos = 0x5
	// Bit mask of BYPSHAD field.
	RTC_CR_BYPSHAD_Msk = 0x20
	// Bit BYPSHAD.
	RTC_CR_BYPSHAD = 0x20
	// Position of FMT field.
	RTC_CR_FMT_Pos = 0x6
	// Bit mask of FMT field.
	RTC_CR_FMT_Msk = 0x40
	// Bit FMT.
	RTC_CR_FMT = 0x40
	// Position of ALRAE field.
	RTC_CR_ALRAE_Pos = 0x8
	// Bit mask of ALRAE field.
	RTC_CR_ALRAE_Msk = 0x100
	// Bit ALRAE.
	RTC_CR_ALRAE = 0x100
	// Position of ALRBE field.
	RTC_CR_ALRBE_Pos = 0x9
	// Bit mask of ALRBE field.
	RTC_CR_ALRBE_Msk = 0x200
	// Bit ALRBE.
	RTC_CR_ALRBE = 0x200
	// Position of WUTE field.
	RTC_CR_WUTE_Pos = 0xa
	// Bit mask of WUTE field.
	RTC_CR_WUTE_Msk = 0x400
	// Bit WUTE.
	RTC_CR_WUTE = 0x400
	// Position of TSE field.
	RTC_CR_TSE_Pos = 0xb
	// Bit mask of TSE field.
	RTC_CR_TSE_Msk = 0x800
	// Bit TSE.
	RTC_CR_TSE = 0x800
	// Position of ALRAIE field.
	RTC_CR_ALRAIE_Pos = 0xc
	// Bit mask of ALRAIE field.
	RTC_CR_ALRAIE_Msk = 0x1000
	// Bit ALRAIE.
	RTC_CR_ALRAIE = 0x1000
	// Position of ALRBIE field.
	RTC_CR_ALRBIE_Pos = 0xd
	// Bit mask of ALRBIE field.
	RTC_CR_ALRBIE_Msk = 0x2000
	// Bit ALRBIE.
	RTC_CR_ALRBIE = 0x2000
	// Position of WUTIE field.
	RTC_CR_WUTIE_Pos = 0xe
	// Bit mask of WUTIE field.
	RTC_CR_WUTIE_Msk = 0x4000
	// Bit WUTIE.
	RTC_CR_WUTIE = 0x4000
	// Position of TSIE field.
	RTC_CR_TSIE_Pos = 0xf
	// Bit mask of TSIE field.
	RTC_CR_TSIE_Msk = 0x8000
	// Bit TSIE.
	RTC_CR_TSIE = 0x8000
	// Position of ADD1H field.
	RTC_CR_ADD1H_Pos = 0x10
	// Bit mask of ADD1H field.
	RTC_CR_ADD1H_Msk = 0x10000
	// Bit ADD1H.
	RTC_CR_ADD1H = 0x10000
	// Position of SUB1H field.
	RTC_CR_SUB1H_Pos = 0x11
	// Bit mask of SUB1H field.
	RTC_CR_SUB1H_Msk = 0x20000
	// Bit SUB1H.
	RTC_CR_SUB1H = 0x20000
	// Position of BKP field.
	RTC_CR_BKP_Pos = 0x12
	// Bit mask of BKP field.
	RTC_CR_BKP_Msk = 0x40000
	// Bit BKP.
	RTC_CR_BKP = 0x40000
	// Position of COSEL field.
	RTC_CR_COSEL_Pos = 0x13
	// Bit mask of COSEL field.
	RTC_CR_COSEL_Msk = 0x80000
	// Bit COSEL.
	RTC_CR_COSEL = 0x80000
	// Position of POL field.
	RTC_CR_POL_Pos = 0x14
	// Bit mask of POL field.
	RTC_CR_POL_Msk = 0x100000
	// Bit POL.
	RTC_CR_POL = 0x100000
	// Position of OSEL field.
	RTC_CR_OSEL_Pos = 0x15
	// Bit mask of OSEL field.
	RTC_CR_OSEL_Msk = 0x600000
	// Position of COE field.
	RTC_CR_COE_Pos = 0x17
	// Bit mask of COE field.
	RTC_CR_COE_Msk = 0x800000
	// Bit COE.
	RTC_CR_COE = 0x800000
	// Position of ITSE field.
	RTC_CR_ITSE_Pos = 0x18
	// Bit mask of ITSE field.
	RTC_CR_ITSE_Msk = 0x1000000
	// Bit ITSE.
	RTC_CR_ITSE = 0x1000000
	// Position of TAMPTS field.
	RTC_CR_TAMPTS_Pos = 0x19
	// Bit mask of TAMPTS field.
	RTC_CR_TAMPTS_Msk = 0x2000000
	// Bit TAMPTS.
	RTC_CR_TAMPTS = 0x2000000
	// Position of TAMPOE field.
	RTC_CR_TAMPOE_Pos = 0x1a
	// Bit mask of TAMPOE field.
	RTC_CR_TAMPOE_Msk = 0x4000000
	// Bit TAMPOE.
	RTC_CR_TAMPOE = 0x4000000
	// Position of TAMPALRM_PU field.
	RTC_CR_TAMPALRM_PU_Pos = 0x1d
	// Bit mask of TAMPALRM_PU field.
	RTC_CR_TAMPALRM_PU_Msk = 0x20000000
	// Bit TAMPALRM_PU.
	RTC_CR_TAMPALRM_PU = 0x20000000
	// Position of TAMPALRM_TYPE field.
	RTC_CR_TAMPALRM_TYPE_Pos = 0x1e
	// Bit mask of TAMPALRM_TYPE field.
	RTC_CR_TAMPALRM_TYPE_Msk = 0x40000000
	// Bit TAMPALRM_TYPE.
	RTC_CR_TAMPALRM_TYPE = 0x40000000
	// Position of OUT2EN field.
	RTC_CR_OUT2EN_Pos = 0x1f
	// Bit mask of OUT2EN field.
	RTC_CR_OUT2EN_Msk = 0x80000000
	// Bit OUT2EN.
	RTC_CR_OUT2EN = 0x80000000

	// WPR: write protection register
	// Position of KEY field.
	RTC_WPR_KEY_Pos = 0x0
	// Bit mask of KEY field.
	RTC_WPR_KEY_Msk = 0xff

	// CALR: calibration register
	// Position of CALP field.
	RTC_CALR_CALP_Pos = 0xf
	// Bit mask of CALP field.
	RTC_CALR_CALP_Msk = 0x8000
	// Bit CALP.
	RTC_CALR_CALP = 0x8000
	// Position of CALW8 field.
	RTC_CALR_CALW8_Pos = 0xe
	// Bit mask of CALW8 field.
	RTC_CALR_CALW8_Msk = 0x4000
	// Bit CALW8.
	RTC_CALR_CALW8 = 0x4000
	// Position of CALW16 field.
	RTC_CALR_CALW16_Pos = 0xd
	// Bit mask of CALW16 field.
	RTC_CALR_CALW16_Msk = 0x2000
	// Bit CALW16.
	RTC_CALR_CALW16 = 0x2000
	// Position of CALM field.
	RTC_CALR_CALM_Pos = 0x0
	// Bit mask of CALM field.
	RTC_CALR_CALM_Msk = 0x1ff

	// SHIFTR: shift control register
	// Position of ADD1S field.
	RTC_SHIFTR_ADD1S_Pos = 0x1f
	// Bit mask of ADD1S field.
	RTC_SHIFTR_ADD1S_Msk = 0x80000000
	// Bit ADD1S.
	RTC_SHIFTR_ADD1S = 0x80000000
	// Position of SUBFS field.
	RTC_SHIFTR_SUBFS_Pos = 0x0
	// Bit mask of SUBFS field.
	RTC_SHIFTR_SUBFS_Msk = 0x7fff

	// TSTR: time stamp time register
	// Position of SU field.
	RTC_TSTR_SU_Pos = 0x0
	// Bit mask of SU field.
	RTC_TSTR_SU_Msk = 0xf
	// Position of ST field.
	RTC_TSTR_ST_Pos = 0x4
	// Bit mask of ST field.
	RTC_TSTR_ST_Msk = 0x70
	// Position of MNU field.
	RTC_TSTR_MNU_Pos = 0x8
	// Bit mask of MNU field.
	RTC_TSTR_MNU_Msk = 0xf00
	// Position of MNT field.
	RTC_TSTR_MNT_Pos = 0xc
	// Bit mask of MNT field.
	RTC_TSTR_MNT_Msk = 0x7000
	// Position of HU field.
	RTC_TSTR_HU_Pos = 0x10
	// Bit mask of HU field.
	RTC_TSTR_HU_Msk = 0xf0000
	// Position of HT field.
	RTC_TSTR_HT_Pos = 0x14
	// Bit mask of HT field.
	RTC_TSTR_HT_Msk = 0x300000
	// Position of PM field.
	RTC_TSTR_PM_Pos = 0x16
	// Bit mask of PM field.
	RTC_TSTR_PM_Msk = 0x400000
	// Bit PM.
	RTC_TSTR_PM = 0x400000

	// TSDR: time stamp date register
	// Position of WDU field.
	RTC_TSDR_WDU_Pos = 0xd
	// Bit mask of WDU field.
	RTC_TSDR_WDU_Msk = 0xe000
	// Position of MT field.
	RTC_TSDR_MT_Pos = 0xc
	// Bit mask of MT field.
	RTC_TSDR_MT_Msk = 0x1000
	// Bit MT.
	RTC_TSDR_MT = 0x1000
	// Position of MU field.
	RTC_TSDR_MU_Pos = 0x8
	// Bit mask of MU field.
	RTC_TSDR_MU_Msk = 0xf00
	// Position of DT field.
	RTC_TSDR_DT_Pos = 0x4
	// Bit mask of DT field.
	RTC_TSDR_DT_Msk = 0x30
	// Position of DU field.
	RTC_TSDR_DU_Pos = 0x0
	// Bit mask of DU field.
	RTC_TSDR_DU_Msk = 0xf

	// TSSSR: timestamp sub second register
	// Position of SS field.
	RTC_TSSSR_SS_Pos = 0x0
	// Bit mask of SS field.
	RTC_TSSSR_SS_Msk = 0xffff

	// ALRMAR: alarm A register
	// Position of MSK4 field.
	RTC_ALRMAR_MSK4_Pos = 0x1f
	// Bit mask of MSK4 field.
	RTC_ALRMAR_MSK4_Msk = 0x80000000
	// Bit MSK4.
	RTC_ALRMAR_MSK4 = 0x80000000
	// Position of WDSEL field.
	RTC_ALRMAR_WDSEL_Pos = 0x1e
	// Bit mask of WDSEL field.
	RTC_ALRMAR_WDSEL_Msk = 0x40000000
	// Bit WDSEL.
	RTC_ALRMAR_WDSEL = 0x40000000
	// Position of DT field.
	RTC_ALRMAR_DT_Pos = 0x1c
	// Bit mask of DT field.
	RTC_ALRMAR_DT_Msk = 0x30000000
	// Position of DU field.
	RTC_ALRMAR_DU_Pos = 0x18
	// Bit mask of DU field.
	RTC_ALRMAR_DU_Msk = 0xf000000
	// Position of MSK3 field.
	RTC_ALRMAR_MSK3_Pos = 0x17
	// Bit mask of MSK3 field.
	RTC_ALRMAR_MSK3_Msk = 0x800000
	// Bit MSK3.
	RTC_ALRMAR_MSK3 = 0x800000
	// Position of PM field.
	RTC_ALRMAR_PM_Pos = 0x16
	// Bit mask of PM field.
	RTC_ALRMAR_PM_Msk = 0x400000
	// Bit PM.
	RTC_ALRMAR_PM = 0x400000
	// Position of HT field.
	RTC_ALRMAR_HT_Pos = 0x14
	// Bit mask of HT field.
	RTC_ALRMAR_HT_Msk = 0x300000
	// Position of HU field.
	RTC_ALRMAR_HU_Pos = 0x10
	// Bit mask of HU field.
	RTC_ALRMAR_HU_Msk = 0xf0000
	// Position of MSK2 field.
	RTC_ALRMAR_MSK2_Pos = 0xf
	// Bit mask of MSK2 field.
	RTC_ALRMAR_MSK2_Msk = 0x8000
	// Bit MSK2.
	RTC_ALRMAR_MSK2 = 0x8000
	// Position of MNT field.
	RTC_ALRMAR_MNT_Pos = 0xc
	// Bit mask of MNT field.
	RTC_ALRMAR_MNT_Msk = 0x7000
	// Position of MNU field.
	RTC_ALRMAR_MNU_Pos = 0x8
	// Bit mask of MNU field.
	RTC_ALRMAR_MNU_Msk = 0xf00
	// Position of MSK1 field.
	RTC_ALRMAR_MSK1_Pos = 0x7
	// Bit mask of MSK1 field.
	RTC_ALRMAR_MSK1_Msk = 0x80
	// Bit MSK1.
	RTC_ALRMAR_MSK1 = 0x80
	// Position of ST field.
	RTC_ALRMAR_ST_Pos = 0x4
	// Bit mask of ST field.
	RTC_ALRMAR_ST_Msk = 0x70
	// Position of SU field.
	RTC_ALRMAR_SU_Pos = 0x0
	// Bit mask of SU field.
	RTC_ALRMAR_SU_Msk = 0xf

	// ALRMASSR: alarm A sub second register
	// Position of MASKSS field.
	RTC_ALRMASSR_MASKSS_Pos = 0x18
	// Bit mask of MASKSS field.
	RTC_ALRMASSR_MASKSS_Msk = 0xf000000
	// Position of SS field.
	RTC_ALRMASSR_SS_Pos = 0x0
	// Bit mask of SS field.
	RTC_ALRMASSR_SS_Msk = 0x7fff

	// ALRMBR: alarm B register
	// Position of MSK4 field.
	RTC_ALRMBR_MSK4_Pos = 0x1f
	// Bit mask of MSK4 field.
	RTC_ALRMBR_MSK4_Msk = 0x80000000
	// Bit MSK4.
	RTC_ALRMBR_MSK4 = 0x80000000
	// Position of WDSEL field.
	RTC_ALRMBR_WDSEL_Pos = 0x1e
	// Bit mask of WDSEL field.
	RTC_ALRMBR_WDSEL_Msk = 0x40000000
	// Bit WDSEL.
	RTC_ALRMBR_WDSEL = 0x40000000
	// Position of DT field.
	RTC_ALRMBR_DT_Pos = 0x1c
	// Bit mask of DT field.
	RTC_ALRMBR_DT_Msk = 0x30000000
	// Position of DU field.
	RTC_ALRMBR_DU_Pos = 0x18
	// Bit mask of DU field.
	RTC_ALRMBR_DU_Msk = 0xf000000
	// Position of MSK3 field.
	RTC_ALRMBR_MSK3_Pos = 0x17
	// Bit mask of MSK3 field.
	RTC_ALRMBR_MSK3_Msk = 0x800000
	// Bit MSK3.
	RTC_ALRMBR_MSK3 = 0x800000
	// Position of PM field.
	RTC_ALRMBR_PM_Pos = 0x16
	// Bit mask of PM field.
	RTC_ALRMBR_PM_Msk = 0x400000
	// Bit PM.
	RTC_ALRMBR_PM = 0x400000
	// Position of HT field.
	RTC_ALRMBR_HT_Pos = 0x14
	// Bit mask of HT field.
	RTC_ALRMBR_HT_Msk = 0x300000
	// Position of HU field.
	RTC_ALRMBR_HU_Pos = 0x10
	// Bit mask of HU field.
	RTC_ALRMBR_HU_Msk = 0xf0000
	// Position of MSK2 field.
	RTC_ALRMBR_MSK2_Pos = 0xf
	// Bit mask of MSK2 field.
	RTC_ALRMBR_MSK2_Msk = 0x8000
	// Bit MSK2.
	RTC_ALRMBR_MSK2 = 0x8000
	// Position of MNT field.
	RTC_ALRMBR_MNT_Pos = 0xc
	// Bit mask of MNT field.
	RTC_ALRMBR_MNT_Msk = 0x7000
	// Position of MNU field.
	RTC_ALRMBR_MNU_Pos = 0x8
	// Bit mask of MNU field.
	RTC_ALRMBR_MNU_Msk = 0xf00
	// Position of MSK1 field.
	RTC_ALRMBR_MSK1_Pos = 0x7
	// Bit mask of MSK1 field.
	RTC_ALRMBR_MSK1_Msk = 0x80
	// Bit MSK1.
	RTC_ALRMBR_MSK1 = 0x80
	// Position of ST field.
	RTC_ALRMBR_ST_Pos = 0x4
	// Bit mask of ST field.
	RTC_ALRMBR_ST_Msk = 0x70
	// Position of SU field.
	RTC_ALRMBR_SU_Pos = 0x0
	// Bit mask of SU field.
	RTC_ALRMBR_SU_Msk = 0xf

	// ALRMBSSR: alarm B sub second register
	// Position of MASKSS field.
	RTC_ALRMBSSR_MASKSS_Pos = 0x18
	// Bit mask of MASKSS field.
	RTC_ALRMBSSR_MASKSS_Msk = 0xf000000
	// Position of SS field.
	RTC_ALRMBSSR_SS_Pos = 0x0
	// Bit mask of SS field.
	RTC_ALRMBSSR_SS_Msk = 0x7fff

	// SR: status register
	// Position of ALRAF field.
	RTC_SR_ALRAF_Pos = 0x0
	// Bit mask of ALRAF field.
	RTC_SR_ALRAF_Msk = 0x1
	// Bit ALRAF.
	RTC_SR_ALRAF = 0x1
	// Position of ALRBF field.
	RTC_SR_ALRBF_Pos = 0x1
	// Bit mask of ALRBF field.
	RTC_SR_ALRBF_Msk = 0x2
	// Bit ALRBF.
	RTC_SR_ALRBF = 0x2
	// Position of WUTF field.
	RTC_SR_WUTF_Pos = 0x2
	// Bit mask of WUTF field.
	RTC_SR_WUTF_Msk = 0x4
	// Bit WUTF.
	RTC_SR_WUTF = 0x4
	// Position of TSF field.
	RTC_SR_TSF_Pos = 0x3
	// Bit mask of TSF field.
	RTC_SR_TSF_Msk = 0x8
	// Bit TSF.
	RTC_SR_TSF = 0x8
	// Position of TSOVF field.
	RTC_SR_TSOVF_Pos = 0x4
	// Bit mask of TSOVF field.
	RTC_SR_TSOVF_Msk = 0x10
	// Bit TSOVF.
	RTC_SR_TSOVF = 0x10
	// Position of ITSF field.
	RTC_SR_ITSF_Pos = 0x5
	// Bit mask of ITSF field.
	RTC_SR_ITSF_Msk = 0x20
	// Bit ITSF.
	RTC_SR_ITSF = 0x20

	// MISR: masked interrupt status register
	// Position of ALRAMF field.
	RTC_MISR_ALRAMF_Pos = 0x0
	// Bit mask of ALRAMF field.
	RTC_MISR_ALRAMF_Msk = 0x1
	// Bit ALRAMF.
	RTC_MISR_ALRAMF = 0x1
	// Position of ALRBMF field.
	RTC_MISR_ALRBMF_Pos = 0x1
	// Bit mask of ALRBMF field.
	RTC_MISR_ALRBMF_Msk = 0x2
	// Bit ALRBMF.
	RTC_MISR_ALRBMF = 0x2
	// Position of WUTMF field.
	RTC_MISR_WUTMF_Pos = 0x2
	// Bit mask of WUTMF field.
	RTC_MISR_WUTMF_Msk = 0x4
	// Bit WUTMF.
	RTC_MISR_WUTMF = 0x4
	// Position of TSMF field.
	RTC_MISR_TSMF_Pos = 0x3
	// Bit mask of TSMF field.
	RTC_MISR_TSMF_Msk = 0x8
	// Bit TSMF.
	RTC_MISR_TSMF = 0x8
	// Position of TSOVMF field.
	RTC_MISR_TSOVMF_Pos = 0x4
	// Bit mask of TSOVMF field.
	RTC_MISR_TSOVMF_Msk = 0x10
	// Bit TSOVMF.
	RTC_MISR_TSOVMF = 0x10
	// Position of ITSMF field.
	RTC_MISR_ITSMF_Pos = 0x5
	// Bit mask of ITSMF field.
	RTC_MISR_ITSMF_Msk = 0x20
	// Bit ITSMF.
	RTC_MISR_ITSMF = 0x20

	// SCR: status clear register
	// Position of CALRAF field.
	RTC_SCR_CALRAF_Pos = 0x0
	// Bit mask of CALRAF field.
	RTC_SCR_CALRAF_Msk = 0x1
	// Bit CALRAF.
	RTC_SCR_CALRAF = 0x1
	// Position of CALRBF field.
	RTC_SCR_CALRBF_Pos = 0x1
	// Bit mask of CALRBF field.
	RTC_SCR_CALRBF_Msk = 0x2
	// Bit CALRBF.
	RTC_SCR_CALRBF = 0x2
	// Position of CWUTF field.
	RTC_SCR_CWUTF_Pos = 0x2
	// Bit mask of CWUTF field.
	RTC_SCR_CWUTF_Msk = 0x4
	// Bit CWUTF.
	RTC_SCR_CWUTF = 0x4
	// Position of CTSF field.
	RTC_SCR_CTSF_Pos = 0x3
	// Bit mask of CTSF field.
	RTC_SCR_CTSF_Msk = 0x8
	// Bit CTSF.
	RTC_SCR_CTSF = 0x8
	// Position of CTSOVF field.
	RTC_SCR_CTSOVF_Pos = 0x4
	// Bit mask of CTSOVF field.
	RTC_SCR_CTSOVF_Msk = 0x10
	// Bit CTSOVF.
	RTC_SCR_CTSOVF = 0x10
	// Position of CITSF field.
	RTC_SCR_CITSF_Pos = 0x5
	// Bit mask of CITSF field.
	RTC_SCR_CITSF_Msk = 0x20
	// Bit CITSF.
	RTC_SCR_CITSF = 0x20
)

// Bitfields for NVIC: Nested Vectored Interrupt Controller
const (
	// ISER: Interrupt Set Enable Register
	// Position of SETENA field.
	NVIC_ISER_SETENA_Pos = 0x0
	// Bit mask of SETENA field.
	NVIC_ISER_SETENA_Msk = 0xffffffff

	// ICER: Interrupt Clear Enable Register
	// Position of CLRENA field.
	NVIC_ICER_CLRENA_Pos = 0x0
	// Bit mask of CLRENA field.
	NVIC_ICER_CLRENA_Msk = 0xffffffff

	// ISPR: Interrupt Set-Pending Register
	// Position of SETPEND field.
	NVIC_ISPR_SETPEND_Pos = 0x0
	// Bit mask of SETPEND field.
	NVIC_ISPR_SETPEND_Msk = 0xffffffff

	// ICPR: Interrupt Clear-Pending Register
	// Position of CLRPEND field.
	NVIC_ICPR_CLRPEND_Pos = 0x0
	// Bit mask of CLRPEND field.
	NVIC_ICPR_CLRPEND_Msk = 0xffffffff

	// IPR0: Interrupt Priority Register 0
	// Position of PRI_0 field.
	NVIC_IPR0_PRI_0_Pos = 0x0
	// Bit mask of PRI_0 field.
	NVIC_IPR0_PRI_0_Msk = 0xff
	// Position of PRI_1 field.
	NVIC_IPR0_PRI_1_Pos = 0x8
	// Bit mask of PRI_1 field.
	NVIC_IPR0_PRI_1_Msk = 0xff00
	// Position of PRI_2 field.
	NVIC_IPR0_PRI_2_Pos = 0x10
	// Bit mask of PRI_2 field.
	NVIC_IPR0_PRI_2_Msk = 0xff0000
	// Position of PRI_3 field.
	NVIC_IPR0_PRI_3_Pos = 0x18
	// Bit mask of PRI_3 field.
	NVIC_IPR0_PRI_3_Msk = 0xff000000

	// IPR1: Interrupt Priority Register 1
	// Position of PRI_4 field.
	NVIC_IPR1_PRI_4_Pos = 0x0
	// Bit mask of PRI_4 field.
	NVIC_IPR1_PRI_4_Msk = 0xff
	// Position of PRI_5 field.
	NVIC_IPR1_PRI_5_Pos = 0x8
	// Bit mask of PRI_5 field.
	NVIC_IPR1_PRI_5_Msk = 0xff00
	// Position of PRI_6 field.
	NVIC_IPR1_PRI_6_Pos = 0x10
	// Bit mask of PRI_6 field.
	NVIC_IPR1_PRI_6_Msk = 0xff0000
	// Position of PRI_7 field.
	NVIC_IPR1_PRI_7_Pos = 0x18
	// Bit mask of PRI_7 field.
	NVIC_IPR1_PRI_7_Msk = 0xff000000

	// IPR2: Interrupt Priority Register 2
	// Position of PRI_8 field.
	NVIC_IPR2_PRI_8_Pos = 0x0
	// Bit mask of PRI_8 field.
	NVIC_IPR2_PRI_8_Msk = 0xff
	// Position of PRI_9 field.
	NVIC_IPR2_PRI_9_Pos = 0x8
	// Bit mask of PRI_9 field.
	NVIC_IPR2_PRI_9_Msk = 0xff00
	// Position of PRI_10 field.
	NVIC_IPR2_PRI_10_Pos = 0x10
	// Bit mask of PRI_10 field.
	NVIC_IPR2_PRI_10_Msk = 0xff0000
	// Position of PRI_11 field.
	NVIC_IPR2_PRI_11_Pos = 0x18
	// Bit mask of PRI_11 field.
	NVIC_IPR2_PRI_11_Msk = 0xff000000

	// IPR3: Interrupt Priority Register 3
	// Position of PRI_12 field.
	NVIC_IPR3_PRI_12_Pos = 0x0
	// Bit mask of PRI_12 field.
	NVIC_IPR3_PRI_12_Msk = 0xff
	// Position of PRI_13 field.
	NVIC_IPR3_PRI_13_Pos = 0x8
	// Bit mask of PRI_13 field.
	NVIC_IPR3_PRI_13_Msk = 0xff00
	// Position of PRI_14 field.
	NVIC_IPR3_PRI_14_Pos = 0x10
	// Bit mask of PRI_14 field.
	NVIC_IPR3_PRI_14_Msk = 0xff0000
	// Position of PRI_15 field.
	NVIC_IPR3_PRI_15_Pos = 0x18
	// Bit mask of PRI_15 field.
	NVIC_IPR3_PRI_15_Msk = 0xff000000

	// IPR4: Interrupt Priority Register 4
	// Position of PRI_16 field.
	NVIC_IPR4_PRI_16_Pos = 0x0
	// Bit mask of PRI_16 field.
	NVIC_IPR4_PRI_16_Msk = 0xff
	// Position of PRI_17 field.
	NVIC_IPR4_PRI_17_Pos = 0x8
	// Bit mask of PRI_17 field.
	NVIC_IPR4_PRI_17_Msk = 0xff00
	// Position of PRI_18 field.
	NVIC_IPR4_PRI_18_Pos = 0x10
	// Bit mask of PRI_18 field.
	NVIC_IPR4_PRI_18_Msk = 0xff0000
	// Position of PRI_19 field.
	NVIC_IPR4_PRI_19_Pos = 0x18
	// Bit mask of PRI_19 field.
	NVIC_IPR4_PRI_19_Msk = 0xff000000

	// IPR5: Interrupt Priority Register 5
	// Position of PRI_20 field.
	NVIC_IPR5_PRI_20_Pos = 0x0
	// Bit mask of PRI_20 field.
	NVIC_IPR5_PRI_20_Msk = 0xff
	// Position of PRI_21 field.
	NVIC_IPR5_PRI_21_Pos = 0x8
	// Bit mask of PRI_21 field.
	NVIC_IPR5_PRI_21_Msk = 0xff00
	// Position of PRI_22 field.
	NVIC_IPR5_PRI_22_Pos = 0x10
	// Bit mask of PRI_22 field.
	NVIC_IPR5_PRI_22_Msk = 0xff0000
	// Position of PRI_23 field.
	NVIC_IPR5_PRI_23_Pos = 0x18
	// Bit mask of PRI_23 field.
	NVIC_IPR5_PRI_23_Msk = 0xff000000

	// IPR6: Interrupt Priority Register 6
	// Position of PRI_24 field.
	NVIC_IPR6_PRI_24_Pos = 0x0
	// Bit mask of PRI_24 field.
	NVIC_IPR6_PRI_24_Msk = 0xff
	// Position of PRI_25 field.
	NVIC_IPR6_PRI_25_Pos = 0x8
	// Bit mask of PRI_25 field.
	NVIC_IPR6_PRI_25_Msk = 0xff00
	// Position of PRI_26 field.
	NVIC_IPR6_PRI_26_Pos = 0x10
	// Bit mask of PRI_26 field.
	NVIC_IPR6_PRI_26_Msk = 0xff0000
	// Position of PRI_27 field.
	NVIC_IPR6_PRI_27_Pos = 0x18
	// Bit mask of PRI_27 field.
	NVIC_IPR6_PRI_27_Msk = 0xff000000

	// IPR7: Interrupt Priority Register 7
	// Position of PRI_28 field.
	NVIC_IPR7_PRI_28_Pos = 0x0
	// Bit mask of PRI_28 field.
	NVIC_IPR7_PRI_28_Msk = 0xff
	// Position of PRI_29 field.
	NVIC_IPR7_PRI_29_Pos = 0x8
	// Bit mask of PRI_29 field.
	NVIC_IPR7_PRI_29_Msk = 0xff00
	// Position of PRI_30 field.
	NVIC_IPR7_PRI_30_Pos = 0x10
	// Bit mask of PRI_30 field.
	NVIC_IPR7_PRI_30_Msk = 0xff0000
	// Position of PRI_31 field.
	NVIC_IPR7_PRI_31_Pos = 0x18
	// Bit mask of PRI_31 field.
	NVIC_IPR7_PRI_31_Msk = 0xff000000
)

// Bitfields for MPU: Memory protection unit
const (
	// MPU_TYPER: MPU type register
	// Position of SEPARATE field.
	MPU_MPU_TYPER_SEPARATE_Pos = 0x0
	// Bit mask of SEPARATE field.
	MPU_MPU_TYPER_SEPARATE_Msk = 0x1
	// Bit SEPARATE.
	MPU_MPU_TYPER_SEPARATE = 0x1
	// Position of DREGION field.
	MPU_MPU_TYPER_DREGION_Pos = 0x8
	// Bit mask of DREGION field.
	MPU_MPU_TYPER_DREGION_Msk = 0xff00
	// Position of IREGION field.
	MPU_MPU_TYPER_IREGION_Pos = 0x10
	// Bit mask of IREGION field.
	MPU_MPU_TYPER_IREGION_Msk = 0xff0000

	// MPU_CTRL: MPU control register
	// Position of ENABLE field.
	MPU_MPU_CTRL_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	MPU_MPU_CTRL_ENABLE_Msk = 0x1
	// Bit ENABLE.
	MPU_MPU_CTRL_ENABLE = 0x1
	// Position of HFNMIENA field.
	MPU_MPU_CTRL_HFNMIENA_Pos = 0x1
	// Bit mask of HFNMIENA field.
	MPU_MPU_CTRL_HFNMIENA_Msk = 0x2
	// Bit HFNMIENA.
	MPU_MPU_CTRL_HFNMIENA = 0x2
	// Position of PRIVDEFENA field.
	MPU_MPU_CTRL_PRIVDEFENA_Pos = 0x2
	// Bit mask of PRIVDEFENA field.
	MPU_MPU_CTRL_PRIVDEFENA_Msk = 0x4
	// Bit PRIVDEFENA.
	MPU_MPU_CTRL_PRIVDEFENA = 0x4

	// MPU_RNR: MPU region number register
	// Position of REGION field.
	MPU_MPU_RNR_REGION_Pos = 0x0
	// Bit mask of REGION field.
	MPU_MPU_RNR_REGION_Msk = 0xff

	// MPU_RBAR: MPU region base address register
	// Position of REGION field.
	MPU_MPU_RBAR_REGION_Pos = 0x0
	// Bit mask of REGION field.
	MPU_MPU_RBAR_REGION_Msk = 0xf
	// Position of VALID field.
	MPU_MPU_RBAR_VALID_Pos = 0x4
	// Bit mask of VALID field.
	MPU_MPU_RBAR_VALID_Msk = 0x10
	// Bit VALID.
	MPU_MPU_RBAR_VALID = 0x10
	// Position of ADDR field.
	MPU_MPU_RBAR_ADDR_Pos = 0x5
	// Bit mask of ADDR field.
	MPU_MPU_RBAR_ADDR_Msk = 0xffffffe0

	// MPU_RASR: MPU region attribute and size register
	// Position of ENABLE field.
	MPU_MPU_RASR_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	MPU_MPU_RASR_ENABLE_Msk = 0x1
	// Bit ENABLE.
	MPU_MPU_RASR_ENABLE = 0x1
	// Position of SIZE field.
	MPU_MPU_RASR_SIZE_Pos = 0x1
	// Bit mask of SIZE field.
	MPU_MPU_RASR_SIZE_Msk = 0x3e
	// Position of SRD field.
	MPU_MPU_RASR_SRD_Pos = 0x8
	// Bit mask of SRD field.
	MPU_MPU_RASR_SRD_Msk = 0xff00
	// Position of B field.
	MPU_MPU_RASR_B_Pos = 0x10
	// Bit mask of B field.
	MPU_MPU_RASR_B_Msk = 0x10000
	// Bit B.
	MPU_MPU_RASR_B = 0x10000
	// Position of C field.
	MPU_MPU_RASR_C_Pos = 0x11
	// Bit mask of C field.
	MPU_MPU_RASR_C_Msk = 0x20000
	// Bit C.
	MPU_MPU_RASR_C = 0x20000
	// Position of S field.
	MPU_MPU_RASR_S_Pos = 0x12
	// Bit mask of S field.
	MPU_MPU_RASR_S_Msk = 0x40000
	// Bit S.
	MPU_MPU_RASR_S = 0x40000
	// Position of TEX field.
	MPU_MPU_RASR_TEX_Pos = 0x13
	// Bit mask of TEX field.
	MPU_MPU_RASR_TEX_Msk = 0x380000
	// Position of AP field.
	MPU_MPU_RASR_AP_Pos = 0x18
	// Bit mask of AP field.
	MPU_MPU_RASR_AP_Msk = 0x7000000
	// Position of XN field.
	MPU_MPU_RASR_XN_Pos = 0x1c
	// Bit mask of XN field.
	MPU_MPU_RASR_XN_Msk = 0x10000000
	// Bit XN.
	MPU_MPU_RASR_XN = 0x10000000
)

// Bitfields for STK: SysTick timer
const (
	// CSR: SysTick control and status register
	// Position of ENABLE field.
	STK_CSR_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	STK_CSR_ENABLE_Msk = 0x1
	// Bit ENABLE.
	STK_CSR_ENABLE = 0x1
	// Position of TICKINT field.
	STK_CSR_TICKINT_Pos = 0x1
	// Bit mask of TICKINT field.
	STK_CSR_TICKINT_Msk = 0x2
	// Bit TICKINT.
	STK_CSR_TICKINT = 0x2
	// Position of CLKSOURCE field.
	STK_CSR_CLKSOURCE_Pos = 0x2
	// Bit mask of CLKSOURCE field.
	STK_CSR_CLKSOURCE_Msk = 0x4
	// Bit CLKSOURCE.
	STK_CSR_CLKSOURCE = 0x4
	// Position of COUNTFLAG field.
	STK_CSR_COUNTFLAG_Pos = 0x10
	// Bit mask of COUNTFLAG field.
	STK_CSR_COUNTFLAG_Msk = 0x10000
	// Bit COUNTFLAG.
	STK_CSR_COUNTFLAG = 0x10000

	// RVR: SysTick reload value register
	// Position of RELOAD field.
	STK_RVR_RELOAD_Pos = 0x0
	// Bit mask of RELOAD field.
	STK_RVR_RELOAD_Msk = 0xffffff

	// CVR: SysTick current value register
	// Position of CURRENT field.
	STK_CVR_CURRENT_Pos = 0x0
	// Bit mask of CURRENT field.
	STK_CVR_CURRENT_Msk = 0xffffff

	// CALIB: SysTick calibration value register
	// Position of TENMS field.
	STK_CALIB_TENMS_Pos = 0x0
	// Bit mask of TENMS field.
	STK_CALIB_TENMS_Msk = 0xffffff
	// Position of SKEW field.
	STK_CALIB_SKEW_Pos = 0x1e
	// Bit mask of SKEW field.
	STK_CALIB_SKEW_Msk = 0x40000000
	// Bit SKEW.
	STK_CALIB_SKEW = 0x40000000
	// Position of NOREF field.
	STK_CALIB_NOREF_Pos = 0x1f
	// Bit mask of NOREF field.
	STK_CALIB_NOREF_Msk = 0x80000000
	// Bit NOREF.
	STK_CALIB_NOREF = 0x80000000
)

// Bitfields for SCB: System control block
const (
	// CPUID: CPUID base register
	// Position of Revision field.
	SCB_CPUID_Revision_Pos = 0x0
	// Bit mask of Revision field.
	SCB_CPUID_Revision_Msk = 0xf
	// Position of PartNo field.
	SCB_CPUID_PartNo_Pos = 0x4
	// Bit mask of PartNo field.
	SCB_CPUID_PartNo_Msk = 0xfff0
	// Position of Architecture field.
	SCB_CPUID_Architecture_Pos = 0x10
	// Bit mask of Architecture field.
	SCB_CPUID_Architecture_Msk = 0xf0000
	// Position of Variant field.
	SCB_CPUID_Variant_Pos = 0x14
	// Bit mask of Variant field.
	SCB_CPUID_Variant_Msk = 0xf00000
	// Position of Implementer field.
	SCB_CPUID_Implementer_Pos = 0x18
	// Bit mask of Implementer field.
	SCB_CPUID_Implementer_Msk = 0xff000000

	// ICSR: Interrupt control and state register
	// Position of VECTACTIVE field.
	SCB_ICSR_VECTACTIVE_Pos = 0x0
	// Bit mask of VECTACTIVE field.
	SCB_ICSR_VECTACTIVE_Msk = 0x1ff
	// Position of RETTOBASE field.
	SCB_ICSR_RETTOBASE_Pos = 0xb
	// Bit mask of RETTOBASE field.
	SCB_ICSR_RETTOBASE_Msk = 0x800
	// Bit RETTOBASE.
	SCB_ICSR_RETTOBASE = 0x800
	// Position of VECTPENDING field.
	SCB_ICSR_VECTPENDING_Pos = 0xc
	// Bit mask of VECTPENDING field.
	SCB_ICSR_VECTPENDING_Msk = 0x7f000
	// Position of ISRPENDING field.
	SCB_ICSR_ISRPENDING_Pos = 0x16
	// Bit mask of ISRPENDING field.
	SCB_ICSR_ISRPENDING_Msk = 0x400000
	// Bit ISRPENDING.
	SCB_ICSR_ISRPENDING = 0x400000
	// Position of PENDSTCLR field.
	SCB_ICSR_PENDSTCLR_Pos = 0x19
	// Bit mask of PENDSTCLR field.
	SCB_ICSR_PENDSTCLR_Msk = 0x2000000
	// Bit PENDSTCLR.
	SCB_ICSR_PENDSTCLR = 0x2000000
	// Position of PENDSTSET field.
	SCB_ICSR_PENDSTSET_Pos = 0x1a
	// Bit mask of PENDSTSET field.
	SCB_ICSR_PENDSTSET_Msk = 0x4000000
	// Bit PENDSTSET.
	SCB_ICSR_PENDSTSET = 0x4000000
	// Position of PENDSVCLR field.
	SCB_ICSR_PENDSVCLR_Pos = 0x1b
	// Bit mask of PENDSVCLR field.
	SCB_ICSR_PENDSVCLR_Msk = 0x8000000
	// Bit PENDSVCLR.
	SCB_ICSR_PENDSVCLR = 0x8000000
	// Position of PENDSVSET field.
	SCB_ICSR_PENDSVSET_Pos = 0x1c
	// Bit mask of PENDSVSET field.
	SCB_ICSR_PENDSVSET_Msk = 0x10000000
	// Bit PENDSVSET.
	SCB_ICSR_PENDSVSET = 0x10000000
	// Position of NMIPENDSET field.
	SCB_ICSR_NMIPENDSET_Pos = 0x1f
	// Bit mask of NMIPENDSET field.
	SCB_ICSR_NMIPENDSET_Msk = 0x80000000
	// Bit NMIPENDSET.
	SCB_ICSR_NMIPENDSET = 0x80000000

	// VTOR: Vector table offset register
	// Position of TBLOFF field.
	SCB_VTOR_TBLOFF_Pos = 0x7
	// Bit mask of TBLOFF field.
	SCB_VTOR_TBLOFF_Msk = 0xffffff80

	// AIRCR: Application interrupt and reset control register
	// Position of VECTCLRACTIVE field.
	SCB_AIRCR_VECTCLRACTIVE_Pos = 0x1
	// Bit mask of VECTCLRACTIVE field.
	SCB_AIRCR_VECTCLRACTIVE_Msk = 0x2
	// Bit VECTCLRACTIVE.
	SCB_AIRCR_VECTCLRACTIVE = 0x2
	// Position of SYSRESETREQ field.
	SCB_AIRCR_SYSRESETREQ_Pos = 0x2
	// Bit mask of SYSRESETREQ field.
	SCB_AIRCR_SYSRESETREQ_Msk = 0x4
	// Bit SYSRESETREQ.
	SCB_AIRCR_SYSRESETREQ = 0x4
	// Position of ENDIANESS field.
	SCB_AIRCR_ENDIANESS_Pos = 0xf
	// Bit mask of ENDIANESS field.
	SCB_AIRCR_ENDIANESS_Msk = 0x8000
	// Bit ENDIANESS.
	SCB_AIRCR_ENDIANESS = 0x8000
	// Position of VECTKEYSTAT field.
	SCB_AIRCR_VECTKEYSTAT_Pos = 0x10
	// Bit mask of VECTKEYSTAT field.
	SCB_AIRCR_VECTKEYSTAT_Msk = 0xffff0000

	// SCR: System control register
	// Position of SLEEPONEXIT field.
	SCB_SCR_SLEEPONEXIT_Pos = 0x1
	// Bit mask of SLEEPONEXIT field.
	SCB_SCR_SLEEPONEXIT_Msk = 0x2
	// Bit SLEEPONEXIT.
	SCB_SCR_SLEEPONEXIT = 0x2
	// Position of SLEEPDEEP field.
	SCB_SCR_SLEEPDEEP_Pos = 0x2
	// Bit mask of SLEEPDEEP field.
	SCB_SCR_SLEEPDEEP_Msk = 0x4
	// Bit SLEEPDEEP.
	SCB_SCR_SLEEPDEEP = 0x4
	// Position of SEVEONPEND field.
	SCB_SCR_SEVEONPEND_Pos = 0x4
	// Bit mask of SEVEONPEND field.
	SCB_SCR_SEVEONPEND_Msk = 0x10
	// Bit SEVEONPEND.
	SCB_SCR_SEVEONPEND = 0x10

	// CCR: Configuration and control register
	// Position of NONBASETHRDENA field.
	SCB_CCR_NONBASETHRDENA_Pos = 0x0
	// Bit mask of NONBASETHRDENA field.
	SCB_CCR_NONBASETHRDENA_Msk = 0x1
	// Bit NONBASETHRDENA.
	SCB_CCR_NONBASETHRDENA = 0x1
	// Position of USERSETMPEND field.
	SCB_CCR_USERSETMPEND_Pos = 0x1
	// Bit mask of USERSETMPEND field.
	SCB_CCR_USERSETMPEND_Msk = 0x2
	// Bit USERSETMPEND.
	SCB_CCR_USERSETMPEND = 0x2
	// Position of UNALIGN__TRP field.
	SCB_CCR_UNALIGN__TRP_Pos = 0x3
	// Bit mask of UNALIGN__TRP field.
	SCB_CCR_UNALIGN__TRP_Msk = 0x8
	// Bit UNALIGN__TRP.
	SCB_CCR_UNALIGN__TRP = 0x8
	// Position of DIV_0_TRP field.
	SCB_CCR_DIV_0_TRP_Pos = 0x4
	// Bit mask of DIV_0_TRP field.
	SCB_CCR_DIV_0_TRP_Msk = 0x10
	// Bit DIV_0_TRP.
	SCB_CCR_DIV_0_TRP = 0x10
	// Position of BFHFNMIGN field.
	SCB_CCR_BFHFNMIGN_Pos = 0x8
	// Bit mask of BFHFNMIGN field.
	SCB_CCR_BFHFNMIGN_Msk = 0x100
	// Bit BFHFNMIGN.
	SCB_CCR_BFHFNMIGN = 0x100
	// Position of STKALIGN field.
	SCB_CCR_STKALIGN_Pos = 0x9
	// Bit mask of STKALIGN field.
	SCB_CCR_STKALIGN_Msk = 0x200
	// Bit STKALIGN.
	SCB_CCR_STKALIGN = 0x200

	// SHPR2: System handler priority registers
	// Position of PRI_11 field.
	SCB_SHPR2_PRI_11_Pos = 0x18
	// Bit mask of PRI_11 field.
	SCB_SHPR2_PRI_11_Msk = 0xff000000

	// SHPR3: System handler priority registers
	// Position of PRI_14 field.
	SCB_SHPR3_PRI_14_Pos = 0x10
	// Bit mask of PRI_14 field.
	SCB_SHPR3_PRI_14_Msk = 0xff0000
	// Position of PRI_15 field.
	SCB_SHPR3_PRI_15_Pos = 0x18
	// Bit mask of PRI_15 field.
	SCB_SHPR3_PRI_15_Msk = 0xff000000
)

// Bitfields for VREFBUF: System configuration controller
const (
	// CSR: VREFBUF control and status register
	// Position of ENVR field.
	VREFBUF_CSR_ENVR_Pos = 0x0
	// Bit mask of ENVR field.
	VREFBUF_CSR_ENVR_Msk = 0x1
	// Bit ENVR.
	VREFBUF_CSR_ENVR = 0x1
	// Position of HIZ field.
	VREFBUF_CSR_HIZ_Pos = 0x1
	// Bit mask of HIZ field.
	VREFBUF_CSR_HIZ_Msk = 0x2
	// Bit HIZ.
	VREFBUF_CSR_HIZ = 0x2
	// Position of VRR field.
	VREFBUF_CSR_VRR_Pos = 0x3
	// Bit mask of VRR field.
	VREFBUF_CSR_VRR_Msk = 0x8
	// Bit VRR.
	VREFBUF_CSR_VRR = 0x8
	// Position of VRS field.
	VREFBUF_CSR_VRS_Pos = 0x4
	// Bit mask of VRS field.
	VREFBUF_CSR_VRS_Msk = 0x70

	// CCR: VREFBUF calibration control register
	// Position of TRIM field.
	VREFBUF_CCR_TRIM_Pos = 0x0
	// Bit mask of TRIM field.
	VREFBUF_CCR_TRIM_Msk = 0x3f
)

// Bitfields for DBG: MCU debug component
const (
	// IDCODE: DBGMCU_IDCODE
	// Position of DEV_ID field.
	DBG_IDCODE_DEV_ID_Pos = 0x0
	// Bit mask of DEV_ID field.
	DBG_IDCODE_DEV_ID_Msk = 0xfff
	// Position of REV_ID field.
	DBG_IDCODE_REV_ID_Pos = 0x10
	// Bit mask of REV_ID field.
	DBG_IDCODE_REV_ID_Msk = 0xffff0000

	// CR: Debug MCU configuration register
	// Position of DBG_STOP field.
	DBG_CR_DBG_STOP_Pos = 0x1
	// Bit mask of DBG_STOP field.
	DBG_CR_DBG_STOP_Msk = 0x2
	// Bit DBG_STOP.
	DBG_CR_DBG_STOP = 0x2
	// Position of DBG_STANDBY field.
	DBG_CR_DBG_STANDBY_Pos = 0x2
	// Bit mask of DBG_STANDBY field.
	DBG_CR_DBG_STANDBY_Msk = 0x4
	// Bit DBG_STANDBY.
	DBG_CR_DBG_STANDBY = 0x4

	// APB_FZ1: Debug MCU APB1 freeze register1
	// Position of DBG_TIM2_STOP field.
	DBG_APB_FZ1_DBG_TIM2_STOP_Pos = 0x0
	// Bit mask of DBG_TIM2_STOP field.
	DBG_APB_FZ1_DBG_TIM2_STOP_Msk = 0x1
	// Bit DBG_TIM2_STOP.
	DBG_APB_FZ1_DBG_TIM2_STOP = 0x1
	// Position of DBG_TIM3_STOP field.
	DBG_APB_FZ1_DBG_TIM3_STOP_Pos = 0x1
	// Bit mask of DBG_TIM3_STOP field.
	DBG_APB_FZ1_DBG_TIM3_STOP_Msk = 0x2
	// Bit DBG_TIM3_STOP.
	DBG_APB_FZ1_DBG_TIM3_STOP = 0x2
	// Position of DBG_RTC_STOP field.
	DBG_APB_FZ1_DBG_RTC_STOP_Pos = 0xa
	// Bit mask of DBG_RTC_STOP field.
	DBG_APB_FZ1_DBG_RTC_STOP_Msk = 0x400
	// Bit DBG_RTC_STOP.
	DBG_APB_FZ1_DBG_RTC_STOP = 0x400
	// Position of DBG_WWDG_STOP field.
	DBG_APB_FZ1_DBG_WWDG_STOP_Pos = 0xb
	// Bit mask of DBG_WWDG_STOP field.
	DBG_APB_FZ1_DBG_WWDG_STOP_Msk = 0x800
	// Bit DBG_WWDG_STOP.
	DBG_APB_FZ1_DBG_WWDG_STOP = 0x800
	// Position of DBG_IWDG_STOP field.
	DBG_APB_FZ1_DBG_IWDG_STOP_Pos = 0xc
	// Bit mask of DBG_IWDG_STOP field.
	DBG_APB_FZ1_DBG_IWDG_STOP_Msk = 0x1000
	// Bit DBG_IWDG_STOP.
	DBG_APB_FZ1_DBG_IWDG_STOP = 0x1000
	// Position of DBG_I2C1_STOP field.
	DBG_APB_FZ1_DBG_I2C1_STOP_Pos = 0x15
	// Bit mask of DBG_I2C1_STOP field.
	DBG_APB_FZ1_DBG_I2C1_STOP_Msk = 0x200000
	// Bit DBG_I2C1_STOP.
	DBG_APB_FZ1_DBG_I2C1_STOP = 0x200000
	// Position of DBG_LPTIM2_STOP field.
	DBG_APB_FZ1_DBG_LPTIM2_STOP_Pos = 0x1e
	// Bit mask of DBG_LPTIM2_STOP field.
	DBG_APB_FZ1_DBG_LPTIM2_STOP_Msk = 0x40000000
	// Bit DBG_LPTIM2_STOP.
	DBG_APB_FZ1_DBG_LPTIM2_STOP = 0x40000000
	// Position of DBG_LPTIM1_STOP field.
	DBG_APB_FZ1_DBG_LPTIM1_STOP_Pos = 0x1f
	// Bit mask of DBG_LPTIM1_STOP field.
	DBG_APB_FZ1_DBG_LPTIM1_STOP_Msk = 0x80000000
	// Bit DBG_LPTIM1_STOP.
	DBG_APB_FZ1_DBG_LPTIM1_STOP = 0x80000000

	// APB_FZ2: Debug MCU APB1 freeze register 2
	// Position of DBG_TIM1_STOP field.
	DBG_APB_FZ2_DBG_TIM1_STOP_Pos = 0xb
	// Bit mask of DBG_TIM1_STOP field.
	DBG_APB_FZ2_DBG_TIM1_STOP_Msk = 0x800
	// Bit DBG_TIM1_STOP.
	DBG_APB_FZ2_DBG_TIM1_STOP = 0x800
	// Position of DBG_TIM14_STOP field.
	DBG_APB_FZ2_DBG_TIM14_STOP_Pos = 0xf
	// Bit mask of DBG_TIM14_STOP field.
	DBG_APB_FZ2_DBG_TIM14_STOP_Msk = 0x8000
	// Bit DBG_TIM14_STOP.
	DBG_APB_FZ2_DBG_TIM14_STOP = 0x8000
	// Position of DBG_TIM16_STOP field.
	DBG_APB_FZ2_DBG_TIM16_STOP_Pos = 0x11
	// Bit mask of DBG_TIM16_STOP field.
	DBG_APB_FZ2_DBG_TIM16_STOP_Msk = 0x20000
	// Bit DBG_TIM16_STOP.
	DBG_APB_FZ2_DBG_TIM16_STOP = 0x20000
	// Position of DBG_TIM17_STOP field.
	DBG_APB_FZ2_DBG_TIM17_STOP_Pos = 0x12
	// Bit mask of DBG_TIM17_STOP field.
	DBG_APB_FZ2_DBG_TIM17_STOP_Msk = 0x40000
	// Bit DBG_TIM17_STOP.
	DBG_APB_FZ2_DBG_TIM17_STOP = 0x40000
)

// Bitfields for FPU_CPACR: Floating point unit CPACR
const (
	// CPACR: Coprocessor access control register
	// Position of CP field.
	FPU_CPACR_CP_Pos = 0x14
	// Bit mask of CP field.
	FPU_CPACR_CP_Msk = 0xf00000
)
