/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.theme.DrawData;
import org.eclipse.swt.internal.theme.RangeDrawData;

public class Theme {
    Device device;
    long shellHandle;
    long fixedHandle;
    long buttonHandle;
    long arrowHandle;
    long frameHandle;
    long entryHandle;
    long checkButtonHandle;
    long radioButtonHandle;
    long notebookHandle;
    long treeHandle;
    long progressHandle;
    long toolbarHandle;
    long labelHandle;
    long separatorHandle;

    public Theme(Device device) {
        this.device = device;
        this.shellHandle = OS.gtk_window_new(0);
        this.fixedHandle = OS.gtk_fixed_new();
        this.buttonHandle = OS.gtk_button_new();
        this.arrowHandle = OS.GTK3 ? OS.gtk_image_new_from_icon_name(OS.GTK_NAMED_ICON_GO_DOWN, 1) : OS.gtk_arrow_new(1, 0);
        this.checkButtonHandle = OS.gtk_check_button_new();
        this.frameHandle = OS.gtk_check_button_new();
        this.entryHandle = OS.gtk_entry_new();
        this.radioButtonHandle = OS.gtk_radio_button_new(0L);
        this.notebookHandle = OS.gtk_notebook_new();
        this.progressHandle = OS.gtk_progress_bar_new();
        this.toolbarHandle = OS.gtk_toolbar_new();
        this.treeHandle = OS.gtk_tree_view_new_with_model(0L);
        this.separatorHandle = OS.GTK3 ? OS.gtk_separator_new(1) : OS.gtk_vseparator_new();
        this.labelHandle = OS.gtk_label_new(null);
        OS.gtk_container_add(this.fixedHandle, this.labelHandle);
        OS.gtk_container_add(this.fixedHandle, this.frameHandle);
        OS.gtk_container_add(this.fixedHandle, this.entryHandle);
        OS.gtk_container_add(this.fixedHandle, this.separatorHandle);
        OS.gtk_container_add(this.fixedHandle, this.arrowHandle);
        OS.gtk_container_add(this.fixedHandle, this.toolbarHandle);
        OS.gtk_container_add(this.fixedHandle, this.progressHandle);
        OS.gtk_container_add(this.fixedHandle, this.checkButtonHandle);
        OS.gtk_container_add(this.fixedHandle, this.radioButtonHandle);
        OS.gtk_container_add(this.fixedHandle, this.buttonHandle);
        OS.gtk_container_add(this.fixedHandle, this.treeHandle);
        OS.gtk_container_add(this.fixedHandle, this.notebookHandle);
        OS.gtk_container_add(this.shellHandle, this.fixedHandle);
        OS.gtk_widget_realize(this.separatorHandle);
        OS.gtk_widget_realize(this.labelHandle);
        OS.gtk_widget_realize(this.frameHandle);
        OS.gtk_widget_realize(this.entryHandle);
        OS.gtk_widget_realize(this.arrowHandle);
        OS.gtk_widget_realize(this.buttonHandle);
        OS.gtk_widget_realize(this.treeHandle);
        OS.gtk_widget_realize(this.notebookHandle);
        OS.gtk_widget_realize(this.checkButtonHandle);
        OS.gtk_widget_realize(this.radioButtonHandle);
        OS.gtk_widget_realize(this.progressHandle);
        OS.gtk_widget_realize(this.toolbarHandle);
        OS.gtk_widget_realize(this.shellHandle);
    }

    void checkTheme() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    public Rectangle computeTrim(GC gC, DrawData drawData) {
        if (gC == null) {
            SWT.error(4);
        }
        if (drawData == null) {
            SWT.error(4);
        }
        if (gC.isDisposed()) {
            SWT.error(5);
        }
        return drawData.computeTrim(this, gC);
    }

    public void dispose() {
        if (this.shellHandle == 0L) {
            return;
        }
        OS.gtk_widget_destroy(this.shellHandle);
        this.separatorHandle = 0L;
        this.labelHandle = 0L;
        this.toolbarHandle = 0L;
        this.progressHandle = 0L;
        this.treeHandle = 0L;
        this.notebookHandle = 0L;
        this.radioButtonHandle = 0L;
        this.checkButtonHandle = 0L;
        this.entryHandle = 0L;
        this.frameHandle = 0L;
        this.arrowHandle = 0L;
        this.buttonHandle = 0L;
        this.fixedHandle = 0L;
        this.shellHandle = 0L;
    }

    public void drawBackground(GC gC, Rectangle rectangle, DrawData drawData) {
        this.checkTheme();
        if (gC == null) {
            SWT.error(4);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        if (drawData == null) {
            SWT.error(4);
        }
        if (gC.isDisposed()) {
            SWT.error(5);
        }
        drawData.draw(this, gC, rectangle);
    }

    public void drawFocus(GC gC, Rectangle rectangle, DrawData drawData) {
        this.checkTheme();
        if (gC == null) {
            SWT.error(4);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        if (drawData == null) {
            SWT.error(4);
        }
        if (gC.isDisposed()) {
            SWT.error(5);
        }
        gC.drawFocus(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void drawImage(GC gC, Rectangle rectangle, DrawData drawData, Image image, int n) {
        this.checkTheme();
        if (gC == null) {
            SWT.error(4);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        if (drawData == null) {
            SWT.error(4);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (gC.isDisposed()) {
            SWT.error(5);
        }
        drawData.drawImage(this, image, gC, rectangle);
    }

    public void drawText(GC gC, Rectangle rectangle, DrawData drawData, String string, int n) {
        this.checkTheme();
        if (gC == null) {
            SWT.error(4);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        if (drawData == null) {
            SWT.error(4);
        }
        if (string == null) {
            SWT.error(4);
        }
        if (gC.isDisposed()) {
            SWT.error(5);
        }
        drawData.drawText(this, string, n, gC, rectangle);
    }

    public Rectangle getBounds(int n, Rectangle rectangle, DrawData drawData) {
        this.checkTheme();
        if (rectangle == null) {
            SWT.error(4);
        }
        if (drawData == null) {
            SWT.error(4);
        }
        return drawData.getBounds(n, rectangle);
    }

    public int getSelection(Point point, Rectangle rectangle, RangeDrawData rangeDrawData) {
        this.checkTheme();
        if (point == null) {
            SWT.error(4);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        if (rangeDrawData == null) {
            SWT.error(4);
        }
        return rangeDrawData.getSelection(point, rectangle);
    }

    public int hitBackground(Point point, Rectangle rectangle, DrawData drawData) {
        this.checkTheme();
        if (point == null) {
            SWT.error(4);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        if (drawData == null) {
            SWT.error(4);
        }
        return drawData.hit(this, point, rectangle);
    }

    public boolean isDisposed() {
        return this.device == null;
    }

    public Rectangle measureText(GC gC, Rectangle rectangle, DrawData drawData, String string, int n) {
        this.checkTheme();
        if (gC == null) {
            SWT.error(4);
        }
        if (drawData == null) {
            SWT.error(4);
        }
        if (string == null) {
            SWT.error(4);
        }
        if (gC.isDisposed()) {
            SWT.error(5);
        }
        return drawData.measureText(this, string, n, gC, rectangle);
    }

    int getWidgetProperty(long l, String string) {
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        int[] nArray = new int[1];
        OS.gtk_widget_style_get(l, byArray, nArray, 0L);
        return nArray[0];
    }

    long getBorderProperty(long l, String string) {
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        long[] lArray = new long[1];
        OS.gtk_widget_style_get(l, byArray, lArray, 0L);
        return lArray[0];
    }

    void transferClipping(GC gC, long l) {
        GCData gCData = gC.getGCData();
        long l2 = gCData.clipRgn;
        long l3 = gCData.damageRgn;
        long l4 = l2;
        if (l3 != 0L) {
            if (l4 != 0L) {
                l4 = OS.gdk_region_new();
                OS.gdk_region_union(l4, l2);
                OS.gdk_region_intersect(l4, l3);
            } else {
                l4 = l3;
            }
        }
        if (!OS.GTK3) {
            long[] lArray = new long[1];
            for (int i = 0; i < 5; ++i) {
                OS.gtk_style_get_fg_gc(l, i, lArray);
                if (lArray[0] != 0L) {
                    OS.gdk_gc_set_clip_region(lArray[0], l4);
                }
                OS.gtk_style_get_bg_gc(l, i, lArray);
                if (lArray[0] != 0L) {
                    OS.gdk_gc_set_clip_region(lArray[0], l4);
                }
                OS.gtk_style_get_light_gc(l, i, lArray);
                if (lArray[0] != 0L) {
                    OS.gdk_gc_set_clip_region(lArray[0], l4);
                }
                OS.gtk_style_get_dark_gc(l, i, lArray);
                if (lArray[0] != 0L) {
                    OS.gdk_gc_set_clip_region(lArray[0], l4);
                }
                OS.gtk_style_get_mid_gc(l, i, lArray);
                if (lArray[0] != 0L) {
                    OS.gdk_gc_set_clip_region(lArray[0], l4);
                }
                OS.gtk_style_get_text_gc(l, i, lArray);
                if (lArray[0] != 0L) {
                    OS.gdk_gc_set_clip_region(lArray[0], l4);
                }
                OS.gtk_style_get_text_aa_gc(l, i, lArray);
                if (lArray[0] == 0L) continue;
                OS.gdk_gc_set_clip_region(lArray[0], l4);
            }
            OS.gtk_style_get_black_gc(l, lArray);
            if (lArray[0] != 0L) {
                OS.gdk_gc_set_clip_region(lArray[0], l4);
            }
            OS.gtk_style_get_white_gc(l, lArray);
            if (lArray[0] != 0L) {
                OS.gdk_gc_set_clip_region(lArray[0], l4);
            }
        }
        if (l4 != l2 && l4 != l3) {
            OS.gdk_region_destroy(l4);
        }
    }
}

