/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import jakarta.servlet.SessionCookieConfig;
import org.apache.catalina.Context;

public class SessionConfig {
    private static final String DEFAULT_SESSION_COOKIE_NAME = "JSESSIONID";
    private static final String DEFAULT_SESSION_PARAMETER_NAME = "jsessionid";

    public static String getSessionCookieName(Context context) {
        String string = SessionConfig.getConfiguredSessionCookieName(context);
        if (string == null) {
            string = DEFAULT_SESSION_COOKIE_NAME;
        }
        return string;
    }

    public static String getSessionUriParamName(Context context) {
        String string = SessionConfig.getConfiguredSessionCookieName(context);
        if (string == null) {
            string = DEFAULT_SESSION_PARAMETER_NAME;
        }
        return string;
    }

    private static String getConfiguredSessionCookieName(Context context) {
        if (context != null) {
            String string = context.getSessionCookieName();
            if (string != null && string.length() > 0) {
                return string;
            }
            SessionCookieConfig sessionCookieConfig = context.getServletContext().getSessionCookieConfig();
            string = sessionCookieConfig.getName();
            if (string != null && string.length() > 0) {
                return string;
            }
        }
        return null;
    }

    public static String getSessionCookiePath(Context context) {
        SessionCookieConfig sessionCookieConfig = context.getServletContext().getSessionCookieConfig();
        String string = context.getSessionCookiePath();
        if (string == null || string.length() == 0) {
            string = sessionCookieConfig.getPath();
        }
        if (string == null || string.length() == 0) {
            string = context.getEncodedPath();
        }
        if (context.getSessionCookiePathUsesTrailingSlash()) {
            if (!string.endsWith("/")) {
                string = string + "/";
            }
        } else if (string.length() == 0) {
            string = "/";
        }
        return string;
    }

    private SessionConfig() {
    }
}

