/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.sampler;

import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasupport.DataRemovedListener;
import com.sun.tools.visualvm.core.ui.DataSourceView;
import com.sun.tools.visualvm.core.ui.components.DataViewComponent;
import com.sun.tools.visualvm.sampler.SamplerImpl;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

final class ApplicationSamplerView
extends DataSourceView {
    private static final String IMAGE_PATH = "com/sun/tools/visualvm/sampler/resources/sampler.png";
    private SamplerImpl sampler;
    private ApplicationListener applicationListener;

    ApplicationSamplerView(Application application) {
        super((DataSource)application, NbBundle.getMessage(ApplicationSamplerView.class, (String)"LBL_Sampler"), new ImageIcon(ImageUtilities.loadImage((String)IMAGE_PATH, (boolean)true)).getImage(), 35, false);
    }

    protected void willBeAdded() {
        Application application = (Application)this.getDataSource();
        this.sampler = new SamplerImpl(application);
        this.applicationListener = new ApplicationListener(){

            @Override
            public void dataRemoved(Application application) {
                ApplicationSamplerView.this.applicationFinished();
            }
        };
        application.notifyWhenRemoved((DataRemovedListener)this.applicationListener);
        application.addPropertyChangeListener("prop_state", (PropertyChangeListener)this.applicationListener);
    }

    protected void removed() {
        this.sampler.removed();
        this.cleanup();
    }

    private void applicationFinished() {
        this.sampler.applicationFinished();
        this.cleanup();
    }

    private synchronized void cleanup() {
        Application application = (Application)this.getDataSource();
        if (this.applicationListener != null) {
            application.removePropertyChangeListener("prop_state", (PropertyChangeListener)this.applicationListener);
        }
        this.applicationListener = null;
    }

    protected DataViewComponent createComponent() {
        DataViewComponent dvc = new DataViewComponent(this.sampler.getMasterView(), new DataViewComponent.MasterViewConfiguration(false));
        this.sampler.setDataViewComponent(dvc);
        return dvc;
    }

    private static abstract class ApplicationListener
    implements DataRemovedListener<Application>,
    PropertyChangeListener {
        private ApplicationListener() {
        }

        public abstract void dataRemoved(Application var1);

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.dataRemoved(null);
        }
    }
}

