/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.appearance.plugin;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import javax.swing.AbstractCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import net.java.dev.colorchooser.ColorChooser;
import org.gephi.appearance.api.Partition;
import org.gephi.appearance.api.PartitionFunction;
import org.gephi.appearance.plugin.palette.Palette;
import org.gephi.appearance.plugin.palette.PaletteGenerator;
import org.gephi.appearance.plugin.palette.PaletteManager;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.ui.appearance.plugin.palette.PaletteGeneratorPanel;
import org.gephi.ui.components.PaletteIcon;
import org.gephi.ui.utils.UIUtils;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.JXTitledSeparator;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class PartitionColorTransformerPanel
extends JPanel {
    private static final int PALETTE_DISPLAY_LIMIT = 15;
    private final PalettePopupButton palettePopupButton;
    private PartitionFunction function;
    private Collection<Object> values;
    private JPanel backPanel;
    private JScrollPane centerScrollPane;
    private JTable table;

    public PartitionColorTransformerPanel() {
        this.initComponents();
        this.palettePopupButton = new PalettePopupButton();
        if (UIUtils.isAquaLookAndFeel()) {
            this.backPanel.setBackground(UIManager.getColor("NbExplorerView.background"));
        }
    }

    public JButton getPaletteButton() {
        return this.palettePopupButton;
    }

    public void setup(PartitionFunction function) {
        this.function = function;
        NumberFormat formatter = NumberFormat.getPercentInstance();
        formatter.setMaximumFractionDigits(2);
        Partition partition = function.getPartition();
        this.values = partition.getSortedValues();
        ArrayList<Object> nullColors = new ArrayList<Object>();
        Color defaultColor = Color.LIGHT_GRAY;
        for (Object val : this.values) {
            Color c = partition.getColor(val);
            if (c != null) continue;
            nullColors.add(val);
            partition.setColor(val, defaultColor);
        }
        int valuesWithColors = this.values.size() - nullColors.size();
        if (!nullColors.isEmpty() && valuesWithColors < 8) {
            Color[] cls = PaletteGenerator.generatePalette((int)Math.min(8, this.values.size()), (int)5, (Random)new Random(42L));
            int i = 0;
            for (Object e : nullColors) {
                int index;
                if ((index = valuesWithColors + i++) >= cls.length) continue;
                partition.setColor(e, cls[index]);
            }
        }
        Object[] columnNames = new String[]{"Color", "Partition", "Percentage"};
        DefaultTableModel model = new DefaultTableModel(columnNames, this.values.size()){

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 0;
            }
        };
        this.table.setModel(model);
        String countMsg = NbBundle.getMessage(PartitionColorTransformerPanel.class, (String)"PartitionColorTransformerPanel.tooltip.elementsCount");
        TableColumn tableColumn = this.table.getColumnModel().getColumn(1);
        tableColumn.setCellRenderer(new TextRenderer(null));
        TableColumn percCol = this.table.getColumnModel().getColumn(2);
        percCol.setCellRenderer(new TextRenderer(countMsg));
        percCol.setPreferredWidth(60);
        percCol.setMaxWidth(60);
        TableColumn colorCol = this.table.getColumnModel().getColumn(0);
        colorCol.setCellEditor(new ColorChooserEditor());
        colorCol.setCellRenderer(new ColorChooserRenderer());
        colorCol.setPreferredWidth(16);
        colorCol.setMaxWidth(16);
        int j = 0;
        for (Object value : this.values) {
            String displayName = value == null ? "null" : (value.getClass().isArray() ? AttributeUtils.printArray((Object)value) : value.toString());
            int count = function.getPartition().count(value);
            float percentage = function.getPartition().percentage(value) / 100.0f;
            model.setValueAt(value, j, 0);
            model.setValueAt(displayName, j, 1);
            String percCount = count + "_(" + formatter.format(percentage) + ")";
            model.setValueAt(percCount, j, 2);
            ++j;
        }
    }

    private void applyPalette(Palette palette) {
        PaletteManager.getInstance().addRecentPalette(palette);
        Color[] colors = palette.getColors();
        int i = 0;
        for (Object value : this.values) {
            Color col = colors[i++];
            this.function.getPartition().setColor(value, col);
        }
        this.table.revalidate();
        this.table.repaint();
    }

    private void applyColor(Color col) {
        for (Object value : this.values) {
            this.function.getPartition().setColor(value, col);
        }
        this.table.revalidate();
        this.table.repaint();
    }

    private void initComponents() {
        this.centerScrollPane = new JScrollPane();
        this.backPanel = new JPanel();
        this.table = new JTable();
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.centerScrollPane.setBorder(null);
        this.centerScrollPane.setOpaque(false);
        this.backPanel.setLayout(new GridBagLayout());
        this.table.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.table.setOpaque(false);
        this.table.setRowHeight(18);
        this.table.setRowMargin(4);
        this.table.setSelectionMode(0);
        this.table.setShowHorizontalLines(false);
        this.table.setShowVerticalLines(false);
        this.table.setTableHeader(null);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.backPanel.add((Component)this.table, gridBagConstraints);
        this.centerScrollPane.setViewportView(this.backPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 10, 0, 0);
        this.add((Component)this.centerScrollPane, gridBagConstraints);
    }

    class PaletteMenuItem
    extends JMenuItem
    implements ActionListener {
        private final Palette palette;

        public PaletteMenuItem(Palette palette, int max) {
            super((Icon)new PaletteIcon(palette.getColors(), max));
            this.palette = palette;
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PartitionColorTransformerPanel.this.applyPalette(this.palette);
        }
    }

    class PalettePopupButton
    extends JXHyperlink {
        private final PaletteManager paletteManager;

        public PalettePopupButton() {
            this.setText(NbBundle.getMessage(PartitionColorTransformerPanel.class, (String)"PartitionColorTransformerPanel.paletteButton"));
            this.setClickedColor(new Color(0, 51, 255));
            this.setFocusPainted(false);
            this.setFocusable(false);
            this.paletteManager = PaletteManager.getInstance();
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int size = PartitionColorTransformerPanel.this.function.getPartition().size();
                    JPopupMenu menu = PalettePopupButton.this.createPopup(size);
                    menu.show((Component)((Object)PalettePopupButton.this), 0, PalettePopupButton.this.getHeight());
                }
            });
        }

        private JPopupMenu createPopup(final int colorsCount) {
            JPopupMenu menu = new JPopupMenu();
            menu.add((Component)new JXTitledSeparator(NbBundle.getMessage(PartitionColorTransformerPanel.class, (String)"PalettePopup.recent")));
            Collection recentPalettes = this.paletteManager.getRecentPalettes();
            if (recentPalettes.isEmpty()) {
                menu.add("<html><i>" + NbBundle.getMessage(PartitionColorTransformerPanel.class, (String)"PalettePopup.norecent") + "</i></html>");
            } else {
                for (Object pl : recentPalettes) {
                    if (pl.size() < colorsCount) continue;
                    menu.add(new PaletteMenuItem((Palette)pl, Math.min(15, colorsCount)));
                }
            }
            menu.add((Component)new JXTitledSeparator(NbBundle.getMessage(PartitionColorTransformerPanel.class, (String)"PalettePopup.standard")));
            JMenu lightPalette = new JMenu(NbBundle.getMessage(PartitionColorTransformerPanel.class, (String)"PalettePopup.palette"));
            for (Palette pl : this.paletteManager.getDefaultPalette(colorsCount)) {
                lightPalette.add(new PaletteMenuItem(pl, Math.min(15, colorsCount)));
            }
            menu.add(lightPalette);
            JMenuItem allGrey = new JMenuItem(NbBundle.getMessage(PartitionColorTransformerPanel.class, (String)"PalettePopup.allgrey"));
            allGrey.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PartitionColorTransformerPanel.this.applyColor(Color.LIGHT_GRAY);
                }
            });
            menu.add(allGrey);
            JMenuItem allWhite = new JMenuItem(NbBundle.getMessage(PartitionColorTransformerPanel.class, (String)"PalettePopup.allwhite"));
            allWhite.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PartitionColorTransformerPanel.this.applyColor(Color.WHITE);
                }
            });
            menu.add(allWhite);
            JMenuItem generate = new JMenuItem(NbBundle.getMessage(PartitionColorTransformerPanel.class, (String)"PalettePopup.generate"));
            generate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Palette pl;
                    PaletteGeneratorPanel pgn = new PaletteGeneratorPanel();
                    pgn.setup(colorsCount);
                    NotifyDescriptor nd = new NotifyDescriptor((Object)pgn, NbBundle.getMessage(PartitionColorTransformerPanel.class, (String)"PartitionColorTransformerPanel.generatePalettePanel.title"), 2, -1, null, null);
                    if (DialogDisplayer.getDefault().notify(nd) == NotifyDescriptor.OK_OPTION && (pl = pgn.getSelectedPalette()) != null) {
                        PartitionColorTransformerPanel.this.applyPalette(pl);
                    }
                }
            });
            menu.add(generate);
            return menu;
        }
    }

    class ColorChooserEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private final ColorChooser delegate = new ColorChooser();
        Object currentValue;

        public ColorChooserEditor() {
            this.delegate.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("color")) {
                        Color color = (Color)evt.getNewValue();
                        Partition partition = PartitionColorTransformerPanel.this.function.getPartition();
                        if (partition.getColor(ColorChooserEditor.this.currentValue) == null || !partition.getColor(ColorChooserEditor.this.currentValue).equals(color)) {
                            PartitionColorTransformerPanel.this.function.getPartition().setColor(ColorChooserEditor.this.currentValue, (Color)evt.getNewValue());
                        }
                        PartitionColorTransformerPanel.this.requestFocusInWindow();
                    }
                }
            });
        }

        @Override
        public Object getCellEditorValue() {
            return this.currentValue;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.currentValue = value;
            return this.delegate;
        }
    }

    class EmptyIcon
    implements Icon {
        EmptyIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        @Override
        public int getIconWidth() {
            return 6;
        }

        @Override
        public int getIconHeight() {
            return 6;
        }
    }

    class TextRenderer
    extends JLabel
    implements TableCellRenderer {
        private final EmptyIcon emptyIcon;
        private final String elementsMessage;

        public TextRenderer(String countMessage) {
            this.setFont(PartitionColorTransformerPanel.this.table.getFont());
            this.emptyIcon = new EmptyIcon();
            this.elementsMessage = countMessage;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String valTxt = (String)value;
            if (column == 1) {
                this.setText(valTxt);
                this.setToolTipText(valTxt);
                this.setIcon(this.emptyIcon);
            } else if (column == 2) {
                String[] spl = valTxt.split("_");
                this.setText(spl[1]);
                this.setToolTipText(spl[0] + " " + this.elementsMessage);
                this.setIcon(null);
            }
            return this;
        }
    }

    class ColorChooserRenderer
    extends JLabel
    implements TableCellRenderer {
        public ColorChooserRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color color = PartitionColorTransformerPanel.this.function.getPartition().getColor(value);
            if (color == null) {
                color = Color.BLACK;
            }
            this.setBackground(color);
            return this;
        }
    }
}

