/*
 * Copyright 2014 original authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.grails.cli.profile

import groovy.transform.CompileStatic



/**
 * Represents argument to a command
 *
 * @author Graeme Rocher
 * @since
 */
@CompileStatic
class CommandArgument {
    /**
     * The name of the argument
     */
    String name
    /**
     * The description of the argument
     */
    String description

    /**
     * Whether the argument is required or not
     */
    boolean required = true

    /**
     * The string argument this argument translates into
     */
    String target

}
