/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.io.wait;

import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyIO;
import org.jruby.RubyNumeric;
import org.jruby.RubySymbol;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;
import org.jruby.util.io.OpenFile;

public class IOWaitLibrary
implements Library {
    @Override
    public void load(Ruby runtime2, boolean wrap2) {
        RubyClass ioClass = runtime2.getIO();
        ioClass.defineAnnotatedMethods(IOWaitLibrary.class);
    }

    @JRubyMethod
    public static IRubyObject nread(ThreadContext context, IRubyObject _io) {
        Ruby runtime2 = context.runtime;
        RubyIO io2 = (RubyIO)_io;
        OpenFile fptr = io2.getOpenFileChecked();
        fptr.checkReadable(context);
        int len = fptr.readPending();
        if (len > 0) {
            return runtime2.newFixnum(len);
        }
        return RubyNumeric.int2fix(runtime2, fptr.readyNow(context) ? 1L : 0L);
    }

    @JRubyMethod(name={"ready?"})
    public static IRubyObject ready(ThreadContext context, IRubyObject _io) {
        RubyIO io2 = (RubyIO)_io;
        OpenFile fptr = io2.getOpenFileChecked();
        fptr.checkReadable(context);
        if (fptr.readPending() != 0) {
            return context.tru;
        }
        return RubyBoolean.newBoolean(context, fptr.readyNow(context));
    }

    @JRubyMethod(optional=1)
    public static IRubyObject wait_readable(ThreadContext context, IRubyObject _io, IRubyObject[] argv2) {
        RubyIO io2 = (RubyIO)_io;
        OpenFile fptr = io2.getOpenFileChecked();
        fptr.checkReadable(context);
        long tv = IOWaitLibrary.prepareTimeout(context, argv2);
        if (fptr.readPending() != 0) {
            return context.tru;
        }
        return IOWaitLibrary.doWait(context, io2, fptr, tv, 17);
    }

    @JRubyMethod(optional=1)
    public static IRubyObject wait_writable(ThreadContext context, IRubyObject _io, IRubyObject[] argv2) {
        RubyIO io2 = (RubyIO)_io;
        OpenFile fptr = io2.getOpenFileChecked();
        fptr.checkWritable(context);
        long tv = IOWaitLibrary.prepareTimeout(context, argv2);
        return IOWaitLibrary.doWait(context, io2, fptr, tv, 12);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JRubyMethod(optional=2)
    public static IRubyObject wait(ThreadContext context, IRubyObject _io, IRubyObject[] argv2) {
        RubyIO io2 = (RubyIO)_io;
        OpenFile fptr = io2.getOpenFileChecked();
        int ops = 0;
        if (argv2.length == 2) {
            if (!(argv2[1] instanceof RubySymbol)) throw context.runtime.newArgumentError("unsupported mode: " + argv2[1].getType());
            RubySymbol sym = (RubySymbol)argv2[1];
            switch (sym.asJavaString()) {
                case "r": 
                case "read": 
                case "readable": {
                    ops |= 0x11;
                    break;
                }
                case "w": 
                case "write": 
                case "writable": {
                    ops |= 0xC;
                    break;
                }
                case "rw": 
                case "read_write": 
                case "readable_writable": {
                    ops |= 0x1D;
                    break;
                }
                default: {
                    throw context.runtime.newArgumentError("unsupported mode: " + sym);
                }
            }
        } else {
            ops |= 0x11;
        }
        if ((ops & 1) == 1 && fptr.readPending() != 0) {
            return context.tru;
        }
        long tv = IOWaitLibrary.prepareTimeout(context, argv2);
        return IOWaitLibrary.doWait(context, io2, fptr, tv, ops);
    }

    private static IRubyObject doWait(ThreadContext context, RubyIO io2, OpenFile fptr, long tv, int ops) {
        boolean ready2 = fptr.ready(context.runtime, context.getThread(), ops, tv);
        fptr.checkClosed();
        if (ready2) {
            return io2;
        }
        return context.nil;
    }

    private static long prepareTimeout(ThreadContext context, IRubyObject[] argv2) {
        long tv;
        IRubyObject timeout2;
        switch (argv2.length) {
            case 1: 
            case 2: {
                timeout2 = argv2[0];
                break;
            }
            default: {
                timeout2 = context.nil;
            }
        }
        if (timeout2.isNil()) {
            tv = -1L;
        } else {
            tv = (long)(RubyTime.convertTimeInterval(context, timeout2) * 1000.0);
            if (tv < 0L) {
                throw context.runtime.newArgumentError("time interval must be positive");
            }
        }
        return tv;
    }
}

