/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.offroad.ui;

import net.osmand.data.LatLon;
import net.osmand.data.RotatedTileBox;
import net.osmand.util.MapAlgorithms;

public class RotatedTileBoxCalculationOrder {
    private RotatedTileBox mTb;
    private BoxDeltaDescription[] mOrder = new BoxDeltaDescription[]{new BoxDeltaDescription(1, 0, 0), new BoxDeltaDescription(0, 1, 0), new BoxDeltaDescription(0, -1, 0), new BoxDeltaDescription(0, 0, 1), new BoxDeltaDescription(0, 0, -1), new BoxDeltaDescription(4, 0, 0), new BoxDeltaDescription(0, 1, 1), new BoxDeltaDescription(0, -1, -1), new BoxDeltaDescription(0, -1, 1), new BoxDeltaDescription(0, 1, -1), new BoxDeltaDescription(2, 0, 0), new BoxDeltaDescription(3, 0, 0)};
    private int mIndex = this.mOrder.length;

    public void init(RotatedTileBox pTb) {
        this.mTb = pTb.copy();
        this.mIndex = 0;
    }

    public boolean hasNext() {
        return this.mIndex < this.mOrder.length;
    }

    public RotatedTileBox getNext() {
        BoxDeltaDescription descNew;
        RotatedTileBox tb = this.mTb.copy();
        BoxDeltaDescription desc = this.mOrder[this.mIndex];
        LatLon centerLatLon = tb.getLatLonFromPixel(((float)desc.xDelta + 0.5f) * (float)tb.getPixWidth(), ((float)desc.yDelta + 0.5f) * (float)tb.getPixHeight());
        tb.setLatLonCenter(centerLatLon.getLatitude(), centerLatLon.getLongitude());
        tb.setZoom(tb.getZoom() - desc.zoomDelta);
        do {
            ++this.mIndex;
            if (!this.hasNext()) break;
            descNew = this.mOrder[this.mIndex];
        } while (this.mTb.getZoom() - descNew.zoomDelta < 5);
        return tb;
    }

    public int getSize() {
        return this.mOrder.length;
    }

    public static void main(String[] args) {
        System.out.println(MapAlgorithms.calculateIntersection(-3, -3, 1, 1, -1, 2, -1, 2));
        RotatedTileBox.RotatedTileBoxBuilder builder = new RotatedTileBox.RotatedTileBoxBuilder();
        RotatedTileBox tb = builder.setLocation(51.0, 13.0).setPixelDimensions(100, 200).setZoom(7).build();
        RotatedTileBoxCalculationOrder order = new RotatedTileBoxCalculationOrder();
        order.init(tb);
        while (order.hasNext()) {
            System.out.println(order.getNext());
        }
    }

    private class BoxDeltaDescription {
        int zoomDelta;
        int xDelta;
        int yDelta;

        public BoxDeltaDescription(int pZoomDelta, int pXDelta, int pYDelta) {
            this.zoomDelta = pZoomDelta;
            this.xDelta = pXDelta;
            this.yDelta = pYDelta;
        }
    }
}

