/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.util;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;

public class IriSplitter {
    private int getShortNameIndex(@Nonnull String iriString) {
        try {
            int slashIndex;
            int hashIndex;
            URI uri = new URI(iriString);
            String fragment = uri.getFragment();
            if (fragment != null && (hashIndex = ((String)Preconditions.checkNotNull((Object)iriString)).lastIndexOf("#")) != -1 && hashIndex + 1 < iriString.length()) {
                return hashIndex + 1;
            }
            String path = uri.getPath();
            if (path != null && !path.isEmpty() && (slashIndex = iriString.lastIndexOf("/")) != -1 && slashIndex + 1 < iriString.length()) {
                return slashIndex + 1;
            }
            return -1;
        }
        catch (URISyntaxException e) {
            return -1;
        }
    }

    public Optional<String> getShortName(@Nonnull IRI iri) {
        String iriString = ((IRI)Preconditions.checkNotNull((Object)iri)).toString();
        int shortNameIndex = this.getShortNameIndex(iriString);
        if (shortNameIndex == -1) {
            return Optional.empty();
        }
        return Optional.of(iriString.substring(shortNameIndex));
    }

    public Optional<String> getShortNamePrefix(@Nonnull IRI iri) {
        String iriString = ((IRI)Preconditions.checkNotNull((Object)iri)).toString();
        int shortNameIndex = this.getShortNameIndex(iriString);
        if (shortNameIndex == -1) {
            return Optional.empty();
        }
        return Optional.of(iriString.substring(0, shortNameIndex));
    }
}

