/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.expr;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;

public class ListExpression
extends Expression {
    private List expressions;

    public ListExpression() {
        this(new ArrayList());
    }

    public ListExpression(List expressions) {
        this.expressions = expressions;
        this.setType(ClassHelper.LIST_TYPE);
    }

    public void addExpression(Expression expression) {
        this.expressions.add(expression);
    }

    public List getExpressions() {
        return this.expressions;
    }

    public void visit(GroovyCodeVisitor visitor) {
        visitor.visitListExpression(this);
    }

    public Expression transformExpression(ExpressionTransformer transformer) {
        ListExpression ret = new ListExpression(this.transformExpressions(this.getExpressions(), transformer));
        ret.setSourcePosition(this);
        return ret;
    }

    public Expression getExpression(int i) {
        return (Expression)this.expressions.get(i);
    }

    public String getText() {
        StringBuffer buffer = new StringBuffer("[");
        boolean first = true;
        Iterator iter = this.expressions.iterator();
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                buffer.append(", ");
            }
            buffer.append(((Expression)iter.next()).getText());
        }
        buffer.append("]");
        return buffer.toString();
    }

    public String toString() {
        return super.toString() + this.expressions;
    }
}

