/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.map;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JPanel;

public class OverlayPanel
extends JPanel {
    private int _prevWidth = -1;
    private int _prevHeight = -1;
    private int _minX;
    private int _minY;
    private int _width;
    private int _height;

    public OverlayPanel() {
        this.setOpaque(false);
    }

    @Override
    public void paint(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (n != this._prevWidth || n2 != this._prevHeight) {
            this.calculateBorder();
            this._prevWidth = n;
            this._prevHeight = n2;
        }
        Color color = new Color(255, 255, 255, 200);
        graphics.setColor(color);
        graphics.fillRect(this._minX, this._minY, this._width, this._height);
        graphics.setColor(Color.BLACK);
        graphics.drawRect(this._minX, this._minY, this._width, this._height);
        super.paint(graphics);
    }

    private void calculateBorder() {
        int n = 2;
        Component component = this.getComponent(0);
        Component component2 = this.getComponent(this.getComponentCount() - 1);
        this._minX = Math.max(component.getX() - 2, 0);
        int n2 = Math.min(component2.getX() + component2.getWidth() + 2, this.getWidth() - 1);
        this._width = n2 - this._minX;
        this._minY = Math.max(Math.min(component.getY(), component2.getY()) - 2, 0);
        int n3 = Math.max(component.getY() + component.getHeight(), component2.getY() + component2.getHeight()) + 2;
        this._height = n3 - this._minY;
    }
}

