/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.data;

import net.osmand.data.LatLon;
import net.osmand.data.MapObject;
import net.osmand.util.Algorithms;

public class Building
extends MapObject {
    private String postcode;
    private LatLon latLon2;
    private BuildingInterpolation interpolationType;
    private int interpolationInterval;
    private String name2;

    public String getPostcode() {
        return this.postcode;
    }

    public int getInterpolationInterval() {
        return this.interpolationInterval;
    }

    public void setInterpolationInterval(int interpolationNumber) {
        this.interpolationInterval = interpolationNumber;
    }

    public BuildingInterpolation getInterpolationType() {
        return this.interpolationType;
    }

    public void setInterpolationType(BuildingInterpolation interpolationType) {
        this.interpolationType = interpolationType;
    }

    public LatLon getLatLon2() {
        return this.latLon2;
    }

    public void setLatLon2(LatLon latlon2) {
        this.latLon2 = latlon2;
    }

    public String getName2() {
        return this.name2;
    }

    public void setName2(String name2) {
        this.name2 = name2;
    }

    public void setPostcode(String postcode) {
        this.postcode = postcode;
    }

    @Override
    public String getName(String lang) {
        String fname = super.getName(lang);
        if (this.interpolationInterval != 0) {
            return fname + "-" + this.name2 + " (+" + this.interpolationInterval + ") ";
        }
        if (this.interpolationType != null) {
            return fname + "-" + this.name2 + " (" + this.interpolationType.toString().toLowerCase() + ") ";
        }
        return this.name;
    }

    public float interpolation(String hno) {
        if (this.getInterpolationType() != null || this.getInterpolationInterval() > 0) {
            int numB;
            int num = Algorithms.extractFirstIntegerNumber(hno);
            int numT = numB = Algorithms.extractFirstIntegerNumber(super.getName());
            if (num >= numB) {
                if (this.getName2() != null && (numT = Algorithms.extractFirstIntegerNumber(this.getName2())) < num) {
                    return -1.0f;
                }
                if (this.getInterpolationType() == BuildingInterpolation.EVEN && num % 2 == 1) {
                    return -1.0f;
                }
                if (this.getInterpolationType() == BuildingInterpolation.ODD && num % 2 == 0) {
                    return -1.0f;
                }
                if (this.getInterpolationInterval() != 0 && (num - numB) % this.getInterpolationInterval() != 0) {
                    return -1.0f;
                }
            } else {
                return -1.0f;
            }
            if (numT > numB) {
                return ((float)num - (float)numB) / ((float)numT - (float)numB);
            }
            return 0.0f;
        }
        return -1.0f;
    }

    public boolean belongsToInterpolation(String hno) {
        return this.interpolation(hno) >= 0.0f;
    }

    @Override
    public String toString() {
        if (this.interpolationInterval != 0) {
            return this.name + "-" + this.name2 + " (+" + this.interpolationInterval + ") ";
        }
        if (this.interpolationType != null) {
            return this.name + "-" + this.name2 + " (" + (Object)((Object)this.interpolationType) + ") ";
        }
        return this.name;
    }

    public LatLon getLocation(float interpolation) {
        LatLon loc = this.getLocation();
        LatLon latLon2 = this.getLatLon2();
        if (latLon2 != null) {
            double lat1 = loc.getLatitude();
            double lat2 = latLon2.getLatitude();
            double lon1 = loc.getLongitude();
            double lon2 = latLon2.getLongitude();
            return new LatLon((double)interpolation * (lat2 - lat1) + lat1, (double)interpolation * (lon2 - lon1) + lon1);
        }
        return loc;
    }

    public static enum BuildingInterpolation {
        ALL(-1),
        EVEN(-2),
        ODD(-3),
        ALPHABETIC(-4);

        private final int val;

        private BuildingInterpolation(int val) {
            this.val = val;
        }

        public int getValue() {
            return this.val;
        }

        public static BuildingInterpolation fromValue(int i) {
            for (BuildingInterpolation b : BuildingInterpolation.values()) {
                if (b.val != i) continue;
                return b;
            }
            return null;
        }
    }
}

