/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.SwingUtilities;
import net.osmand.Location;
import net.osmand.ResultMatcher;
import net.osmand.binary.GeocodingUtilities;
import net.osmand.binary.RouteDataObject;
import net.osmand.data.LatLon;
import net.osmand.plus.OsmandSettings;
import net.osmand.util.Algorithms;
import net.sourceforge.offroad.OsmWindow;

public class GeocodingLookupService {
    private OsmWindow app;
    private ConcurrentLinkedQueue<LatLon> lookupLocations = new ConcurrentLinkedQueue();
    private ConcurrentHashMap<LatLon, List<AddressLookupRequest>> addressLookupRequestsMap = new ConcurrentHashMap();
    private LatLon currentRequestedLocation = null;
    private boolean searchDone;
    private String lastFoundAddress;

    public GeocodingLookupService(OsmWindow app) {
        this.app = app;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lookupAddress(AddressLookupRequest request) {
        GeocodingLookupService geocodingLookupService = this;
        synchronized (geocodingLookupService) {
            LatLon requestedLocation = request.latLon;
            LatLon existingLocation = null;
            if (requestedLocation.equals(this.currentRequestedLocation)) {
                requestedLocation = existingLocation = this.currentRequestedLocation;
                request.latLon = existingLocation;
            } else if (this.lookupLocations.contains(requestedLocation)) {
                for (LatLon latLon : this.lookupLocations) {
                    if (!latLon.equals(requestedLocation)) continue;
                    existingLocation = latLon;
                    requestedLocation = latLon;
                    request.latLon = latLon;
                    break;
                }
            }
            List<AddressLookupRequest> list = this.addressLookupRequestsMap.get(requestedLocation);
            if (list == null) {
                list = new ArrayList<AddressLookupRequest>();
                this.addressLookupRequestsMap.put(requestedLocation, list);
            }
            list.add(request);
            if (existingLocation == null) {
                this.lookupLocations.add(requestedLocation);
            }
            if (this.currentRequestedLocation == null) {
                new AddressLookupRequestsAsyncTask(this.app).start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(AddressLookupRequest request) {
        GeocodingLookupService geocodingLookupService = this;
        synchronized (geocodingLookupService) {
            List<AddressLookupRequest> requests = this.addressLookupRequestsMap.get(request.latLon);
            if (requests != null && requests.size() > 0) {
                requests.remove(request);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(LatLon latLon) {
        GeocodingLookupService geocodingLookupService = this;
        synchronized (geocodingLookupService) {
            List<AddressLookupRequest> requests = this.addressLookupRequestsMap.get(latLon);
            if (requests != null && requests.size() > 0) {
                requests.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasAnyRequest(LatLon latLon) {
        GeocodingLookupService geocodingLookupService = this;
        synchronized (geocodingLookupService) {
            List<AddressLookupRequest> requests = this.addressLookupRequestsMap.get(latLon);
            return requests != null && requests.size() > 0;
        }
    }

    private boolean geocode(final LatLon latLon) {
        Location loc = new Location("");
        loc.setLatitude(latLon.getLatitude());
        loc.setLongitude(latLon.getLongitude());
        return this.app.getLocationProvider().getGeocodingResult(loc, new ResultMatcher<GeocodingUtilities.GeocodingResult>(){

            @Override
            public boolean publish(GeocodingUtilities.GeocodingResult object) {
                String result = null;
                if (object != null) {
                    OsmandSettings settings = GeocodingLookupService.this.app.getSettings();
                    String lang = settings.MAP_PREFERRED_LOCALE.get();
                    String geocodingResult = "";
                    double relevantDistance = -1.0;
                    if (object.building != null) {
                        String bldName = object.building.getName(lang);
                        if (!Algorithms.isEmpty(object.buildingInterpolation)) {
                            bldName = object.buildingInterpolation;
                        }
                        geocodingResult = object.street.getName(lang) + " " + bldName + ", " + object.city.getName(lang);
                    } else if (object.street != null) {
                        geocodingResult = object.street.getName(lang) + ", " + object.city.getName(lang);
                        relevantDistance = object.getDistanceP();
                    } else if (object.city != null) {
                        geocodingResult = object.city.getName(lang);
                    } else if (object.point != null) {
                        String ref;
                        RouteDataObject rd = object.point.getRoad();
                        String sname = rd.getName(lang);
                        if (Algorithms.isEmpty(sname)) {
                            sname = "";
                        }
                        if (!Algorithms.isEmpty(ref = rd.getRef())) {
                            if (!Algorithms.isEmpty(sname)) {
                                sname = sname + ", ";
                            }
                            sname = sname + ref;
                        }
                        geocodingResult = sname;
                        relevantDistance = object.getDistanceP();
                    }
                    result = geocodingResult;
                    if (relevantDistance == -1.0) {
                        relevantDistance = object.getDistance();
                    }
                    if (!Algorithms.isEmpty(result) && relevantDistance > 100.0) {
                        result = GeocodingLookupService.this.app.getString(54) + " " + result;
                    }
                }
                GeocodingLookupService.this.lastFoundAddress = result;
                GeocodingLookupService.this.searchDone = true;
                return true;
            }

            @Override
            public boolean isCancelled() {
                return !GeocodingLookupService.this.hasAnyRequest(latLon);
            }
        });
    }

    private class AddressLookupRequestsAsyncTask
    extends Thread {
        private OsmWindow app;

        public AddressLookupRequestsAsyncTask(OsmWindow app) {
            this.app = app;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (!GeocodingLookupService.this.lookupLocations.isEmpty()) {
                        List requests;
                        GeocodingLookupService geocodingLookupService;
                        LatLon latLon;
                        GeocodingLookupService geocodingLookupService2 = GeocodingLookupService.this;
                        synchronized (geocodingLookupService2) {
                            latLon = (LatLon)GeocodingLookupService.this.lookupLocations.poll();
                            GeocodingLookupService.this.currentRequestedLocation = latLon;
                            List requests2 = (List)GeocodingLookupService.this.addressLookupRequestsMap.get(latLon);
                            if (requests2 == null || requests2.size() == 0) {
                                GeocodingLookupService.this.addressLookupRequestsMap.remove(latLon);
                                continue;
                            }
                        }
                        GeocodingLookupService.this.searchDone = false;
                        while (!GeocodingLookupService.this.geocode(latLon)) {
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                        long counter = 0L;
                        while (!GeocodingLookupService.this.searchDone) {
                            try {
                                Thread.sleep(50L);
                                if (++counter != 10L) continue;
                                counter = 0L;
                                geocodingLookupService = GeocodingLookupService.this;
                                synchronized (geocodingLookupService) {
                                    requests = (List)GeocodingLookupService.this.addressLookupRequestsMap.get(latLon);
                                    for (final AddressLookupRequest request : requests) {
                                        if (request.uiProgressCallback == null) continue;
                                        SwingUtilities.invokeAndWait(new Runnable(){

                                            @Override
                                            public void run() {
                                                request.uiProgressCallback.geocodingInProgress();
                                            }
                                        });
                                    }
                                }
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                        geocodingLookupService = GeocodingLookupService.this;
                        synchronized (geocodingLookupService) {
                            requests = (List)GeocodingLookupService.this.addressLookupRequestsMap.get(latLon);
                            for (final AddressLookupRequest request : requests) {
                                if (request.uiResultCallback == null) continue;
                                SwingUtilities.invokeAndWait(new Runnable(){

                                    @Override
                                    public void run() {
                                        request.uiResultCallback.geocodingDone(GeocodingLookupService.this.lastFoundAddress);
                                    }
                                });
                            }
                            GeocodingLookupService.this.addressLookupRequestsMap.remove(latLon);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                GeocodingLookupService geocodingLookupService = GeocodingLookupService.this;
                synchronized (geocodingLookupService) {
                    GeocodingLookupService.this.currentRequestedLocation = null;
                    if (GeocodingLookupService.this.lookupLocations.isEmpty()) {
                        return;
                    }
                }
            }
        }
    }

    public static class AddressLookupRequest {
        private LatLon latLon;
        private OnAddressLookupResult uiResultCallback;
        private OnAddressLookupProgress uiProgressCallback;

        public AddressLookupRequest(LatLon latLon, OnAddressLookupResult uiResultCallback, OnAddressLookupProgress uiProgressCallback) {
            this.latLon = latLon;
            this.uiResultCallback = uiResultCallback;
            this.uiProgressCallback = uiProgressCallback;
        }

        public LatLon getLatLon() {
            return this.latLon;
        }
    }

    public static interface OnAddressLookupResult {
        public void geocodingDone(String var1);
    }

    public static interface OnAddressLookupProgress {
        public void geocodingInProgress();
    }
}

