/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.servlet;

import org.directwebremoting.Container;
import org.directwebremoting.extend.ContainerUtil;
import org.directwebremoting.servlet.BaseInterfaceHandler;
import org.directwebremoting.servlet.DojoDtoAllHandler;
import org.directwebremoting.servlet.DojoModule;

public class DojoInterfaceHandler
extends BaseInterfaceHandler {
    protected DojoDtoAllHandler dojoDtoAllHandler;
    protected String dojoInterfaceHandlerUrl;
    protected String dojoInterfaceBaseModulePath;
    protected String dojoDwrBaseModulePath;

    @Override
    protected String getBaseInterfacePath() {
        return this.dojoInterfaceHandlerUrl;
    }

    @Override
    public String generateInterfaceScript(String contextPath, String servletPath, String scriptName) {
        DojoModule mod = new DojoModule(contextPath, servletPath, this.dojoInterfaceBaseModulePath, scriptName);
        mod.addRequire(this.dojoDwrBaseModulePath, "engine");
        String moduleName = mod.expandModulePath(this.dojoInterfaceBaseModulePath, scriptName);
        if (this.generateDtoClasses.matches(".*\\binterface\\b.*") && this.converterManager.getNamedConverterJavaScriptNames().size() > 0) {
            mod.addContent(this.dojoDtoAllHandler.generateDtoAllScript(contextPath, servletPath));
            mod.addContent("\n");
        }
        mod.addContent("(function(dwr) {\n");
        mod.addContent("  var p;\n");
        mod.addContent("\n");
        mod.addContent(this.remoter.generateInterfaceJavaScript(scriptName, "  ", "p", contextPath + servletPath));
        mod.addContent("  \n");
        mod.addContent("  dojo.setObject(\"" + moduleName + "\", p);\n");
        mod.addContent("})(" + mod.expandModulePath(this.dojoDwrBaseModulePath) + ");\n");
        return mod.toString();
    }

    public void setContainer(Container container) {
        this.dojoDtoAllHandler = (DojoDtoAllHandler)ContainerUtil.getHandlerForUrlProperty(container, "dojoDtoAllHandlerUrl");
    }

    public void setDojoInterfaceHandlerUrl(String url) {
        this.dojoInterfaceHandlerUrl = url;
    }

    public void setDojoInterfaceBaseModulePath(String modulePath) {
        this.dojoInterfaceBaseModulePath = modulePath;
    }

    public void setDojoDwrBaseModulePath(String modulePath) {
        this.dojoDwrBaseModulePath = modulePath;
    }
}

