/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.intent;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.netbeans.api.intent.Intent;
import org.netbeans.spi.intent.Result;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class IntentHandler
implements Comparable<IntentHandler> {
    public static final RequestProcessor RP = new RequestProcessor(IntentHandler.class);
    private static final Result IGNORING_RESULT = new Result(){

        @Override
        public void setResult(Object object) {
        }

        @Override
        public void setException(Exception exception) {
        }
    };
    private final String className;
    private final String methodName;
    private final String displayName;
    private final String icon;
    private final Type type;
    private final int position;

    @Override
    public int compareTo(IntentHandler intentHandler) {
        return this.getPosition() - intentHandler.getPosition();
    }

    public static IntentHandler create(FileObject fileObject) {
        String string = fileObject.getName();
        int n = string.lastIndexOf(45);
        if (n <= 0 || n + 1 >= string.length()) {
            throw new IllegalArgumentException("Invalid handler file");
        }
        String string2 = string.substring(0, n).replace('-', '.');
        String string3 = string.substring(n + 1);
        String string4 = (String)fileObject.getAttribute("displayName");
        String string5 = (String)fileObject.getAttribute("icon");
        int n2 = (Integer)fileObject.getAttribute("position");
        Type type = Type.valueOf((String)fileObject.getAttribute("type"));
        return new IntentHandler(string2, string3, string4, string5, type, n2);
    }

    private IntentHandler(String string, String string2, String string3, String string4, Type type, int n) {
        this.className = string;
        this.methodName = string2;
        this.displayName = string3;
        this.icon = string4;
        this.type = type;
        this.position = n;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getIcon() {
        return this.icon;
    }

    public int getPosition() {
        return this.position;
    }

    public boolean isSetBack() {
        return this.type == Type.SETBACK;
    }

    public void handle(Intent intent, Result result) {
        Result result2 = result == null ? IGNORING_RESULT : result;
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (classLoader == null) {
            throw new IllegalStateException("Classloader not found");
        }
        try {
            Class<?> clazz = Class.forName(this.className, true, classLoader);
            if (this.isSetBack()) {
                Method method = clazz.getDeclaredMethod(this.methodName, Intent.class, Result.class);
                method.invoke(null, intent, result2);
            } else {
                Method method = clazz.getDeclaredMethod(this.methodName, Intent.class);
                Object object = method.invoke(null, intent);
                result2.setResult(object);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof Exception) {
                result2.setException((Exception)throwable);
            } else {
                result2.setException(new Exception(throwable));
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            result2.setException(reflectiveOperationException);
        }
    }

    private static enum Type {
        RETURN,
        SETBACK;

    }
}

