/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jnati;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;

public class FileUtils {
    private static final int BUFFER_SIZE = 4096;

    public static File getTmpDir() throws IOException {
        return FileUtils.getTmpDir((File)null);
    }

    public static File getTmpDir(String path) throws IOException {
        return FileUtils.getTmpDir(path == null ? null : new File(path));
    }

    public static File getTmpDir(File root) throws IOException {
        File tmpdir = File.createTempFile("j_tmp", "", root);
        tmpdir.delete();
        tmpdir.mkdir();
        return tmpdir;
    }

    public static boolean delTree(File dir) {
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                FileUtils.delTree(f);
                continue;
            }
            f.delete();
        }
        dir.delete();
        return !dir.exists();
    }

    public static void writeStreamToFile(InputStream in, File file) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        FileUtils.copyStreamToStream(in, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStreamToStream(InputStream in, OutputStream out) throws IOException {
        try {
            try {
                byte[] b = new byte[4096];
                int n = in.read(b);
                while (n >= 0) {
                    out.write(b, 0, n);
                    n = in.read(b);
                }
            }
            finally {
                out.close();
            }
        }
        finally {
            in.close();
        }
    }

    public static byte[] readBytes(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        FileUtils.copyStreamToStream(in, out);
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readString(Reader in) throws IOException {
        char[] buffer = new char[4096];
        StringBuilder sb = new StringBuilder();
        try {
            int n;
            while ((n = in.read(buffer)) > -1) {
                sb.append(buffer, 0, n);
            }
        }
        finally {
            in.close();
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeString(File file, String string) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        try {
            fos.write(string.getBytes());
        }
        finally {
            fos.close();
        }
    }
}

