/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.data;

import java.awt.Point;
import net.osmand.PlatformUtil;
import net.osmand.data.LatLon;
import net.osmand.data.QuadPoint;
import net.osmand.data.QuadPointDouble;
import net.osmand.data.QuadRect;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;

public class RotatedTileBox {
    private static final Log log = PlatformUtil.getLog(RotatedTileBox.class);
    private double lat;
    private double lon;
    private float rotate;
    private float density;
    private int zoom;
    private double mapDensity = 1.0;
    private double zoomAnimation;
    private double zoomFloatPart;
    private int cx;
    private int cy;
    private int pixWidth;
    private int pixHeight;
    private double zoomFactor;
    private double rotateCos;
    private double rotateSin;
    private double oxTile;
    private double oyTile;
    private QuadRect tileBounds;
    private QuadRect latLonBounds;
    private QuadPointDouble tileLT;
    private QuadPointDouble tileRT;
    private QuadPointDouble tileRB;
    private QuadPointDouble tileLB;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.cx;
        result = 31 * result + this.cy;
        result = 31 * result + Float.floatToIntBits(this.density);
        long temp = Double.doubleToLongBits(this.lat);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.lon);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.mapDensity);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.pixHeight;
        result = 31 * result + this.pixWidth;
        result = 31 * result + Float.floatToIntBits(this.rotate);
        result = 31 * result + this.zoom;
        temp = Double.doubleToLongBits(this.zoomAnimation);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.zoomFloatPart);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RotatedTileBox other = (RotatedTileBox)obj;
        if (this.cx != other.cx) {
            return false;
        }
        if (this.cy != other.cy) {
            return false;
        }
        if (Float.floatToIntBits(this.density) != Float.floatToIntBits(other.density)) {
            return false;
        }
        if (Double.doubleToLongBits(this.lat) != Double.doubleToLongBits(other.lat)) {
            return false;
        }
        if (Double.doubleToLongBits(this.lon) != Double.doubleToLongBits(other.lon)) {
            return false;
        }
        if (Double.doubleToLongBits(this.mapDensity) != Double.doubleToLongBits(other.mapDensity)) {
            return false;
        }
        if (this.pixHeight != other.pixHeight) {
            return false;
        }
        if (this.pixWidth != other.pixWidth) {
            return false;
        }
        if (Float.floatToIntBits(this.rotate) != Float.floatToIntBits(other.rotate)) {
            return false;
        }
        if (this.zoom != other.zoom) {
            return false;
        }
        if (Double.doubleToLongBits(this.zoomAnimation) != Double.doubleToLongBits(other.zoomAnimation)) {
            return false;
        }
        return Double.doubleToLongBits(this.zoomFloatPart) == Double.doubleToLongBits(other.zoomFloatPart);
    }

    private RotatedTileBox() {
    }

    public RotatedTileBox(RotatedTileBox r) {
        this.pixWidth = r.pixWidth;
        this.pixHeight = r.pixHeight;
        this.lat = r.lat;
        this.lon = r.lon;
        this.zoom = r.zoom;
        this.mapDensity = r.mapDensity;
        this.zoomFloatPart = r.zoomFloatPart;
        this.zoomAnimation = r.zoomAnimation;
        this.rotate = r.rotate;
        this.density = r.density;
        this.cx = r.cx;
        this.cy = r.cy;
        this.copyDerivedFields(r);
    }

    private void copyDerivedFields(RotatedTileBox r) {
        this.zoomFactor = r.zoomFactor;
        this.rotateCos = r.rotateCos;
        this.rotateSin = r.rotateSin;
        this.oxTile = r.oxTile;
        this.oyTile = r.oyTile;
        if (r.tileBounds != null && r.latLonBounds != null) {
            this.tileBounds = new QuadRect(r.tileBounds);
            this.latLonBounds = new QuadRect(r.latLonBounds);
            this.tileLT = new QuadPointDouble(r.tileLT);
            this.tileRT = new QuadPointDouble(r.tileRT);
            this.tileRB = new QuadPointDouble(r.tileRB);
            this.tileLB = new QuadPointDouble(r.tileLB);
        }
    }

    public void calculateDerivedFields() {
        this.zoomFactor = Math.pow(2.0, this.zoomAnimation + this.zoomFloatPart) * 256.0 * this.mapDensity;
        double rad = Math.toRadians(this.rotate);
        this.rotateCos = Math.cos(rad);
        this.rotateSin = Math.sin(rad);
        this.oxTile = MapUtils.getTileNumberX(this.zoom, this.lon);
        this.oyTile = MapUtils.getTileNumberY(this.zoom, this.lat);
        while (this.rotate < 0.0f) {
            this.rotate += 360.0f;
        }
        while (this.rotate > 360.0f) {
            this.rotate -= 360.0f;
        }
        this.tileBounds = null;
    }

    public double getLatFromPixel(float x, float y) {
        return MapUtils.getLatitudeFromTile(this.zoom, this.getTileYFromPixel(x, y));
    }

    public double getLonFromPixel(float x, float y) {
        return MapUtils.getLongitudeFromTile(this.zoom, this.getTileXFromPixel(x, y));
    }

    public LatLon getLatLonFromPixel(float x, float y) {
        return new LatLon(this.getLatFromPixel(x, y), this.getLonFromPixel(x, y));
    }

    public LatLon getLatLonFromPixel(double x, double y) {
        return this.getLatLonFromPixel((float)x, (float)y);
    }

    public LatLon getCenterLatLon() {
        return new LatLon(this.lat, this.lon);
    }

    public QuadPoint getCenterPixelPoint() {
        return new QuadPoint(this.cx, this.cy);
    }

    public int getCenterPixelX() {
        return this.cx;
    }

    public int getCenterPixelY() {
        return this.cy;
    }

    public void setDensity(float density) {
        this.density = density;
    }

    public double getCenterTileX() {
        return this.oxTile;
    }

    public int getCenter31X() {
        return MapUtils.get31TileNumberX(this.lon);
    }

    public int getCenter31Y() {
        return MapUtils.get31TileNumberY(this.lat);
    }

    public double getCenterTileY() {
        return this.oyTile;
    }

    protected double getTileXFromPixel(float x, float y) {
        float dx = x - (float)this.cx;
        float dy = y - (float)this.cy;
        double dtilex = this.isMapRotateEnabled() ? this.rotateCos * (double)dx + this.rotateSin * (double)dy : (double)dx;
        return dtilex / this.zoomFactor + this.oxTile;
    }

    protected double getTileYFromPixel(float x, float y) {
        float dx = x - (float)this.cx;
        float dy = y - (float)this.cy;
        double dtiley = this.isMapRotateEnabled() ? -this.rotateSin * (double)dx + this.rotateCos * (double)dy : (double)dy;
        return dtiley / this.zoomFactor + this.oyTile;
    }

    public QuadRect getTileBounds() {
        this.checkTileRectangleCalculated();
        return this.tileBounds;
    }

    public void calculateTileRectangle() {
        double x1 = this.getTileXFromPixel(0.0f, 0.0f);
        double x2 = this.getTileXFromPixel(this.pixWidth, 0.0f);
        double x3 = this.getTileXFromPixel(this.pixWidth, this.pixHeight);
        double x4 = this.getTileXFromPixel(0.0f, this.pixHeight);
        double y1 = this.getTileYFromPixel(0.0f, 0.0f);
        double y2 = this.getTileYFromPixel(this.pixWidth, 0.0f);
        double y3 = this.getTileYFromPixel(this.pixWidth, this.pixHeight);
        double y4 = this.getTileYFromPixel(0.0f, this.pixHeight);
        this.tileLT = new QuadPointDouble(x1, y1);
        this.tileRT = new QuadPointDouble(x2, y2);
        this.tileRB = new QuadPointDouble(x3, y3);
        this.tileLB = new QuadPointDouble(x4, y4);
        double l = Math.min(Math.min(x1, x2), Math.min(x3, x4));
        double r = Math.max(Math.max(x1, x2), Math.max(x3, x4));
        double t = Math.min(Math.min(y1, y2), Math.min(y3, y4));
        double b = Math.max(Math.max(y1, y2), Math.max(y3, y4));
        this.tileBounds = new QuadRect((float)l, (float)t, (float)r, (float)b);
        float top = (float)MapUtils.getLatitudeFromTile(this.zoom, this.alignTile(this.tileBounds.top));
        float left = (float)MapUtils.getLongitudeFromTile(this.zoom, this.alignTile(this.tileBounds.left));
        float bottom = (float)MapUtils.getLatitudeFromTile(this.zoom, this.alignTile(this.tileBounds.bottom));
        float right = (float)MapUtils.getLongitudeFromTile(this.zoom, this.alignTile(this.tileBounds.right));
        this.latLonBounds = new QuadRect(left, top, right, bottom);
    }

    private double alignTile(double tile) {
        if (tile < 0.0) {
            return 0.0;
        }
        if (tile >= MapUtils.getPowZoom(this.zoom)) {
            return MapUtils.getPowZoom(this.zoom) - 1.0E-6;
        }
        return tile;
    }

    public int getPixWidth() {
        return this.pixWidth;
    }

    public int getPixHeight() {
        return this.pixHeight;
    }

    public float getPixXFromLatLon(double latitude, double longitude) {
        double xTile = MapUtils.getTileNumberX(this.zoom, longitude);
        double yTile = MapUtils.getTileNumberY(this.zoom, latitude);
        return this.getPixXFromTile(xTile, yTile);
    }

    public float getPixXFromTile(double tileX, double tileY, float zoom) {
        double pw = MapUtils.getPowZoom(zoom - (float)this.zoom);
        double xTile = tileX / pw;
        double yTile = tileY / pw;
        return this.getPixXFromTile(xTile, yTile);
    }

    protected float getPixXFromTile(double xTile, double yTile) {
        double dTileX = xTile - this.oxTile;
        double dTileY = yTile - this.oyTile;
        double rotX = this.isMapRotateEnabled() ? this.rotateCos * dTileX - this.rotateSin * dTileY : dTileX;
        double dx = rotX * this.zoomFactor;
        return (float)(dx + (double)this.cx);
    }

    public float getPixYFromLatLon(double latitude, double longitude) {
        double xTile = MapUtils.getTileNumberX(this.zoom, longitude);
        double yTile = MapUtils.getTileNumberY(this.zoom, latitude);
        return this.getPixYFromTile(xTile, yTile);
    }

    public float getPixYFromTile(double tileX, double tileY, float zoom) {
        double pw = MapUtils.getPowZoom(zoom - (float)this.zoom);
        double xTile = tileX / pw;
        double yTile = tileY / pw;
        return this.getPixYFromTile(xTile, yTile);
    }

    protected float getPixYFromTile(double xTile, double yTile) {
        double dTileX = xTile - this.oxTile;
        double dTileY = yTile - this.oyTile;
        double rotY = this.isMapRotateEnabled() ? this.rotateSin * dTileX + this.rotateCos * dTileY : dTileY;
        double dy = rotY * this.zoomFactor;
        return (float)(dy + (double)this.cy);
    }

    public int getPixXFromLonNoRot(double longitude) {
        double dTilex = (double)((float)MapUtils.getTileNumberX(this.zoom, longitude)) - this.oxTile;
        return (int)(dTilex * this.zoomFactor + (double)this.cx);
    }

    public int getPixXFromTileXNoRot(double tileX) {
        double dTilex = tileX - this.oxTile;
        return (int)(dTilex * this.zoomFactor + (double)this.cx);
    }

    public int getPixYFromLatNoRot(double latitude) {
        double dTileY = MapUtils.getTileNumberY(this.zoom, latitude) - this.oyTile;
        return (int)(dTileY * this.zoomFactor + (double)this.cy);
    }

    public int getPixYFromTileYNoRot(double tileY) {
        double dTileY = tileY - this.oyTile;
        return (int)(dTileY * this.zoomFactor + (double)this.cy);
    }

    private boolean isMapRotateEnabled() {
        return this.rotate != 0.0f;
    }

    public QuadRect getLatLonBounds() {
        this.checkTileRectangleCalculated();
        return this.latLonBounds;
    }

    public double getRotateCos() {
        return this.rotateCos;
    }

    public double getRotateSin() {
        return this.rotateSin;
    }

    public int getZoom() {
        return this.zoom;
    }

    public void setLatLonCenter(double lat, double lon) {
        this.lat = lat;
        this.lon = lon;
        this.calculateDerivedFields();
    }

    public void setRotate(float rotate) {
        this.rotate = rotate;
        this.calculateDerivedFields();
    }

    public void increasePixelDimensions(int dwidth, int dheight) {
        this.pixWidth += 2 * dwidth;
        this.pixHeight += 2 * dheight;
        this.cx += dwidth;
        this.cy += dheight;
        this.calculateDerivedFields();
    }

    public void setPixelDimensions(int width, int height) {
        this.setPixelDimensions(width, height, 0.5f, 0.5f);
    }

    public void setPixelDimensions(int width, int height, float ratiocx, float ratiocy) {
        this.pixHeight = height;
        this.pixWidth = width;
        this.cx = (int)((float)this.pixWidth * ratiocx);
        this.cy = (int)((float)this.pixHeight * ratiocy);
        this.calculateDerivedFields();
    }

    public boolean isZoomAnimated() {
        return this.zoomAnimation != 0.0;
    }

    public double getZoomAnimation() {
        return this.zoomAnimation;
    }

    public double getZoomFloatPart() {
        return this.zoomFloatPart;
    }

    public void setZoomAndAnimation(int zoom, double zoomAnimation, double zoomFloatPart) {
        this.zoomAnimation = zoomAnimation;
        this.zoomFloatPart = zoomFloatPart;
        this.zoom = zoom;
        this.calculateDerivedFields();
    }

    public void setZoomAndAnimation(int zoom, double zoomAnimation) {
        this.zoomAnimation = zoomAnimation;
        this.zoom = zoom;
        this.calculateDerivedFields();
    }

    public void setCenterLocation(float ratiocx, float ratiocy) {
        this.cx = (int)((float)this.pixWidth * ratiocx);
        this.cy = (int)((float)this.pixHeight * ratiocy);
        this.calculateDerivedFields();
    }

    public LatLon getLeftTopLatLon() {
        this.checkTileRectangleCalculated();
        return new LatLon(MapUtils.getLatitudeFromTile(this.zoom, this.alignTile(this.tileLT.y)), MapUtils.getLongitudeFromTile(this.zoom, this.alignTile(this.tileLT.x)));
    }

    public QuadPointDouble getLeftTopTile(double zoom) {
        this.checkTileRectangleCalculated();
        return new QuadPointDouble(this.tileLT.x * MapUtils.getPowZoom(zoom - (double)this.zoom), this.tileLT.y * MapUtils.getPowZoom(zoom - (double)this.zoom));
    }

    public QuadPointDouble getRightBottomTile(float zoom) {
        this.checkTileRectangleCalculated();
        return new QuadPointDouble(this.tileRB.x * MapUtils.getPowZoom(zoom - (float)this.zoom), this.tileRB.y * MapUtils.getPowZoom(zoom - (float)this.zoom));
    }

    private void checkTileRectangleCalculated() {
        if (this.tileBounds == null) {
            this.calculateTileRectangle();
        }
    }

    public LatLon getRightBottomLatLon() {
        this.checkTileRectangleCalculated();
        return new LatLon(MapUtils.getLatitudeFromTile(this.zoom, this.alignTile(this.tileRB.y)), MapUtils.getLongitudeFromTile(this.zoom, this.alignTile(this.tileRB.x)));
    }

    public void setMapDensity(double mapDensity) {
        this.mapDensity = mapDensity;
        this.calculateDerivedFields();
    }

    public double getMapDensity() {
        return this.mapDensity;
    }

    public void setZoom(int zoom) {
        this.zoom = zoom;
        this.calculateDerivedFields();
    }

    public float getRotate() {
        return this.rotate;
    }

    public float getDensity() {
        return this.density;
    }

    public RotatedTileBox copy() {
        return new RotatedTileBox(this);
    }

    public boolean containsTileBox(RotatedTileBox box) {
        this.checkTileRectangleCalculated();
        box = box.copy();
        box.checkTileRectangleCalculated();
        if (!this.containsTilePoint(box.tileLB)) {
            return false;
        }
        if (!this.containsTilePoint(box.tileLT)) {
            return false;
        }
        if (!this.containsTilePoint(box.tileRB)) {
            return false;
        }
        return this.containsTilePoint(box.tileRT);
    }

    public boolean containsTilePoint(QuadPoint qp) {
        double tx = this.getPixXFromTile(qp.x, qp.y);
        double ty = this.getPixYFromTile(qp.x, qp.y);
        return tx >= 0.0 && tx <= (double)this.pixWidth && ty >= 0.0 && ty <= (double)this.pixHeight;
    }

    public boolean containsTilePoint(QuadPointDouble qp) {
        double tx = this.getPixXFromTile(qp.x, qp.y);
        double ty = this.getPixYFromTile(qp.x, qp.y);
        return tx >= 0.0 && tx <= (double)this.pixWidth && ty >= 0.0 && ty <= (double)this.pixHeight;
    }

    public boolean containsLatLon(double lat, double lon) {
        double tx = this.getPixXFromLatLon(lat, lon);
        double ty = this.getPixYFromLatLon(lat, lon);
        return tx >= 0.0 && tx <= (double)this.pixWidth && ty >= 0.0 && ty <= (double)this.pixHeight;
    }

    public boolean containsLatLon(LatLon latLon) {
        double tx = this.getPixXFromLatLon(latLon.getLatitude(), latLon.getLongitude());
        double ty = this.getPixYFromLatLon(latLon.getLatitude(), latLon.getLongitude());
        return tx >= 0.0 && tx <= (double)this.pixWidth && ty >= 0.0 && ty <= (double)this.pixHeight;
    }

    public double getDistance(int pixX, int pixY, int pixX2, int pixY2) {
        double lat1 = this.getLatFromPixel(pixX, pixY);
        double lon1 = this.getLonFromPixel(pixX, pixY);
        double lat2 = this.getLatFromPixel(pixX2, pixY2);
        double lon2 = this.getLonFromPixel(pixX2, pixY2);
        return MapUtils.getDistance(lat1, lon1, lat2, lon2);
    }

    public double getLongitude() {
        return this.lon;
    }

    public double getLatitude() {
        return this.lat;
    }

    public String toString() {
        return "RotatedTileBox [lat=" + this.lat + ", lon=" + this.lon + ", rotate=" + this.rotate + ", density=" + this.density + ", zoom=" + this.zoom + ", mapDensity=" + this.mapDensity + ", zoomAnimation=" + this.zoomAnimation + ", zoomFloatPart=" + this.zoomFloatPart + ", cx=" + this.cx + ", cy=" + this.cy + ", pixWidth=" + this.pixWidth + ", pixHeight=" + this.pixHeight + "]";
    }

    public boolean intersects(LatLon pScreenLT, LatLon pScreenRB) {
        LatLon lt = this.getLeftTopLatLon();
        LatLon rb = this.getRightBottomLatLon();
        double minLat = Math.min(pScreenLT.getLatitude(), pScreenRB.getLatitude());
        double maxLat = Math.max(pScreenLT.getLatitude(), pScreenRB.getLatitude());
        double minLon = Math.min(pScreenLT.getLongitude(), pScreenRB.getLongitude());
        double maxLon = Math.max(pScreenLT.getLongitude(), pScreenRB.getLongitude());
        if (lt.getLatitude() <= minLat && rb.getLatitude() <= minLat) {
            return false;
        }
        if (lt.getLatitude() >= maxLat && rb.getLatitude() >= maxLat) {
            return false;
        }
        if (lt.getLongitude() <= minLon && rb.getLongitude() <= minLon) {
            return false;
        }
        return !(lt.getLongitude() >= maxLon) || !(rb.getLongitude() >= maxLon);
    }

    public float getPixXFromLatLon(LatLon pLatLon) {
        return this.getPixXFromLatLon(pLatLon.getLatitude(), pLatLon.getLongitude());
    }

    public float getPixYFromLatLon(LatLon pLatLon) {
        return this.getPixYFromLatLon(pLatLon.getLatitude(), pLatLon.getLongitude());
    }

    public Point getPoint(LatLon pLocation) {
        return new Point((int)this.getPixXFromLatLon(pLocation), (int)this.getPixYFromLatLon(pLocation));
    }

    public void setLatLonCenter(LatLon pDestination) {
        this.setLatLonCenter(pDestination.getLatitude(), pDestination.getLongitude());
    }

    public double getPixelDistanceInMeters() {
        double dx = MapUtils.getDistance(this.getCenterLatLon(), this.getLatFromPixel(this.getCenterPixelX() + 1, this.getCenterPixelY()), this.getLonFromPixel(this.getCenterPixelX() + 1, this.getCenterPixelY()));
        double dy = MapUtils.getDistance(this.getCenterLatLon(), this.getLatFromPixel(this.getCenterPixelX(), this.getCenterPixelY() + 1), this.getLonFromPixel(this.getCenterPixelX(), this.getCenterPixelY() + 1));
        return Math.min(Math.abs(dx), Math.abs(dy));
    }

    public static class RotatedTileBoxBuilder {
        private RotatedTileBox tb = new RotatedTileBox();
        private boolean pixelDimensionsSet = false;
        private boolean locationSet = false;
        private boolean zoomSet = false;

        public RotatedTileBoxBuilder() {
            this.tb.density = 1.0f;
            this.tb.rotate = 0.0f;
        }

        public RotatedTileBoxBuilder density(float d) {
            this.tb.density = d;
            return this;
        }

        public RotatedTileBoxBuilder setMapDensity(double mapDensity) {
            this.tb.mapDensity = mapDensity;
            return this;
        }

        public RotatedTileBoxBuilder setZoom(int zoom) {
            this.tb.zoom = zoom;
            this.zoomSet = true;
            return this;
        }

        public RotatedTileBoxBuilder setLocation(double lat, double lon) {
            this.tb.lat = lat;
            this.tb.lon = lon;
            this.locationSet = true;
            return this;
        }

        public RotatedTileBoxBuilder setRotate(float degrees) {
            this.tb.rotate = degrees;
            return this;
        }

        public RotatedTileBoxBuilder setPixelDimensions(int pixWidth, int pixHeight, float centerX, float centerY) {
            this.tb.pixWidth = pixWidth;
            this.tb.pixHeight = pixHeight;
            this.tb.cx = (int)((float)pixWidth * centerX);
            this.tb.cy = (int)((float)pixHeight * centerY);
            this.pixelDimensionsSet = true;
            return this;
        }

        public RotatedTileBoxBuilder setPixelDimensions(int pixWidth, int pixHeight) {
            return this.setPixelDimensions(pixWidth, pixHeight, 0.5f, 0.5f);
        }

        public RotatedTileBox build() {
            if (!this.pixelDimensionsSet) {
                throw new IllegalArgumentException("Please specify pixel dimensions");
            }
            if (!this.zoomSet) {
                throw new IllegalArgumentException("Please specify zoom");
            }
            if (!this.locationSet) {
                throw new IllegalArgumentException("Please specify location");
            }
            RotatedTileBox local = this.tb;
            local.calculateDerivedFields();
            this.tb = null;
            return local;
        }
    }
}

