/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import org.hsqldb.Constraint;
import org.hsqldb.Expression;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Session;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.rights.Grantee;
import org.hsqldb.types.Collation;
import org.hsqldb.types.Type;

public class UserTypeModifier {
    final HsqlNameManager.HsqlName name;
    final int schemaObjectType;
    final Type dataType;
    Constraint[] constraints = Constraint.emptyArray;
    Expression defaultExpression;
    boolean isNullable = true;

    public UserTypeModifier(HsqlNameManager.HsqlName hsqlName, int n, Type type) {
        this.name = hsqlName;
        this.schemaObjectType = n;
        this.dataType = type;
    }

    public int schemaObjectType() {
        return this.schemaObjectType;
    }

    public void addConstraint(Constraint constraint) {
        int n = this.constraints.length;
        this.constraints = (Constraint[])ArrayUtil.resizeArray(this.constraints, n + 1);
        this.constraints[n] = constraint;
        this.setNotNull();
    }

    public void removeConstraint(String string) {
        for (int i = 0; i < this.constraints.length; ++i) {
            if (!this.constraints[i].getName().name.equals(string)) continue;
            this.constraints = (Constraint[])ArrayUtil.toAdjustedArray(this.constraints, null, i, -1);
            break;
        }
        this.setNotNull();
    }

    public Constraint getConstraint(String string) {
        for (int i = 0; i < this.constraints.length; ++i) {
            if (!this.constraints[i].getName().name.equals(string)) continue;
            return this.constraints[i];
        }
        return null;
    }

    public Constraint[] getConstraints() {
        return this.constraints;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public Expression getDefaultClause() {
        return this.defaultExpression;
    }

    public void setDefaultClause(Expression expression) {
        this.defaultExpression = expression;
    }

    public void removeDefaultClause() {
        this.defaultExpression = null;
    }

    private void setNotNull() {
        this.isNullable = true;
        for (int i = 0; i < this.constraints.length; ++i) {
            if (!this.constraints[i].isNotNull()) continue;
            this.isNullable = false;
        }
    }

    public int getType() {
        return this.schemaObjectType;
    }

    public HsqlNameManager.HsqlName getName() {
        return this.name;
    }

    public HsqlNameManager.HsqlName getSchemaName() {
        return this.name.schema;
    }

    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    public OrderedHashSet getReferences() {
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        for (int i = 0; i < this.constraints.length; ++i) {
            OrderedHashSet orderedHashSet2 = this.constraints[i].getReferences();
            if (orderedHashSet2 == null) continue;
            orderedHashSet.addAll(orderedHashSet2);
        }
        return orderedHashSet;
    }

    public final OrderedHashSet getComponents() {
        if (this.constraints == null) {
            return null;
        }
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        orderedHashSet.addAll(this.constraints);
        return orderedHashSet;
    }

    public void compile(Session session) {
        for (int i = 0; i < this.constraints.length; ++i) {
            this.constraints[i].compile(session, null);
        }
    }

    public String getSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.schemaObjectType == 12) {
            Collation collation;
            stringBuffer.append("CREATE").append(' ').append("TYPE").append(' ');
            stringBuffer.append(this.name.getSchemaQualifiedStatementName());
            stringBuffer.append(' ').append("AS").append(' ');
            stringBuffer.append(this.dataType.getDefinition());
            if (this.dataType.isCharacterType() && (collation = this.dataType.getCollation()).isObjectCollation()) {
                stringBuffer.append(' ').append(collation.getCollateSQL());
            }
        } else {
            stringBuffer.append("CREATE").append(' ').append("DOMAIN").append(' ');
            stringBuffer.append(this.name.getSchemaQualifiedStatementName());
            stringBuffer.append(' ').append("AS").append(' ');
            stringBuffer.append(this.dataType.getDefinition());
            if (this.defaultExpression != null) {
                stringBuffer.append(' ').append("DEFAULT").append(' ');
                stringBuffer.append(this.defaultExpression.getSQL());
            }
            for (int i = 0; i < this.constraints.length; ++i) {
                stringBuffer.append(' ').append("CONSTRAINT").append(' ');
                stringBuffer.append(this.constraints[i].getName().statementName).append(' ');
                stringBuffer.append("CHECK").append('(').append(this.constraints[i].getCheckSQL()).append(')');
            }
        }
        return stringBuffer.toString();
    }
}

