/* pantheon-files-core.vapi generated by valac 0.48.9, do not modify. */

namespace Marlin {
	namespace ConnectServer {
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public class Operation : Gtk.MountOperation {
			public Operation (PF.ConnectServerDialog dialog);
			public override void ask_password (string message, string default_user, string default_domain, GLib.AskPasswordFlags flags);
		}
	}
	namespace FileChanges {
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static void consume_changes (bool consume_all);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static void queue_file_added (GLib.File location);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static void queue_file_changed (GLib.File location);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static void queue_file_moved (GLib.File from, GLib.File to);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static void queue_file_removed (GLib.File location);
	}
	[CCode (lower_case_cprefix = "marlin_file_operations_")]
	namespace FileOperations {
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public class CommonJob {
			protected weak GLib.Cancellable? cancellable;
			protected uint inhibit_cookie;
			protected weak Gtk.Window? parent_window;
			protected PF.Progress.Info progress;
			protected Marlin.UndoActionData? undo_redo_data;
			protected CommonJob (Gtk.Window? parent_window = null);
			protected bool aborted ();
			protected void inhibit_power_manager (string message);
		}
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public class EmptyTrashJob : Marlin.FileOperations.CommonJob {
			public EmptyTrashJob (Gtk.Window? parent_window = null, owned GLib.List<GLib.File>? trash_dirs = null);
			public async void empty_trash ();
		}
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static void empty_trash_for_mount (Gtk.Widget? parent_view, GLib.Mount mount);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static GLib.List<GLib.File> get_trash_dirs_for_mount (GLib.Mount mount);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static bool has_trash_files (GLib.Mount? mount);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static void mount_volume (GLib.Volume volume, Gtk.Window? parent_window = null);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static async bool mount_volume_full (GLib.Volume volume, Gtk.Window? parent_window = null) throws GLib.Error;
	}
	namespace Plugins {
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public abstract class Base {
			public Gtk.Widget window;
			protected Base ();
			public virtual void context_menu (Gtk.Widget widget, GLib.List<GOF.File> files);
			public virtual void directory_loaded (Gtk.ApplicationWindow window, GOF.AbstractSlot view, GOF.File directory);
			public void interface_loaded (Gtk.Widget widget);
			public virtual void sidebar_loaded (Gtk.Widget widget);
			public virtual void update_file_info (GOF.File file);
			public virtual void update_sidebar (Gtk.Widget widget);
		}
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public abstract class AbstractSidebar : Gtk.ScrolledWindow {
		public enum Column {
			NAME,
			URI,
			DRIVE,
			VOLUME,
			MOUNT,
			ROW_TYPE,
			ICON,
			INDEX,
			CAN_EJECT,
			NO_EJECT,
			BOOKMARK,
			IS_CATEGORY,
			NOT_CATEGORY,
			TOOLTIP,
			ACTION_ICON,
			SHOW_SPINNER,
			SHOW_EJECT,
			SPINNER_PULSE,
			FREE_SPACE,
			DISK_SIZE,
			PLUGIN_CALLBACK,
			MENU_MODEL,
			ACTION_GROUP_NAMESPACE,
			ACTION_GROUP,
			COUNT
		}
		protected Gtk.Box content_box;
		protected Gtk.TreeRowReference network_category_reference;
		protected Gtk.TreeStore store;
		protected AbstractSidebar ();
		public void add_extra_item (Gtk.TreeRowReference category, string text, string tooltip, GLib.Icon? icon, Marlin.PluginCallbackFunc? cb, GLib.Icon? action_icon = null);
		public void add_extra_network_item (string text, string tooltip, GLib.Icon? icon, Marlin.PluginCallbackFunc? cb);
		protected abstract Gtk.TreeIter add_place (Marlin.PlaceType place_type, Gtk.TreeIter? parent, string name, GLib.Icon? icon, string? uri, GLib.Drive? drive, GLib.Volume? volume, GLib.Mount? mount, uint index, string? tooltip = null, GLib.Icon? action_icon = null);
		public abstract Gtk.TreeRowReference? add_plugin_item (Marlin.SidebarPluginItem item, Marlin.PlaceType category);
		protected void init ();
		public abstract bool update_plugin_item (Marlin.SidebarPluginItem item, Gtk.TreeRowReference rowref);
		public signal void request_update ();
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public class Bookmark {
		public static GLib.CompareFunc<Marlin.Bookmark> compare_uris;
		public static GLib.CompareFunc<Marlin.Bookmark> compare_with;
		public Bookmark (GOF.File gof_file, string? label = null);
		public Marlin.Bookmark copy ();
		public Bookmark.from_uri (string uri, string? label = null);
		public GLib.Icon get_icon ();
		public unowned GLib.File get_location ();
		public string get_parse_name ();
		public string get_uri ();
		public bool uri_known_not_to_exist ();
		public GOF.File gof_file { get; private set; }
		public string label { get; set; }
		public signal void contents_changed ();
		public signal void deleted ();
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public class BookmarkList : GLib.Object {
		public bool contains (Marlin.Bookmark bm);
		public void delete_item_at (uint index);
		public void delete_items_with_uri (string uri);
		public static Marlin.BookmarkList get_instance ();
		public void insert_uri (string uri, uint index, string? label = null);
		public void insert_uri_at_end (string uri, string? label = null);
		public void insert_uris (GLib.List<string> uris, uint index);
		public unowned Marlin.Bookmark? item_at (uint index);
		public uint length ();
		public void move_item (uint index, uint destination);
		public weak GLib.List<Marlin.Bookmark> list { get; private set; }
		public signal void contents_changed ();
		public signal void deleted ();
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public class DndHandler : GLib.Object {
		public DndHandler ();
		public static string data_to_string (uchar[] cdata);
		public bool dnd_perform (Gtk.Widget widget, GOF.File drop_target, GLib.List<GLib.File> drop_file_list, Gdk.DragAction action);
		public Gdk.DragAction? drag_drop_action_ask (Gtk.Widget dest_widget, Gtk.ApplicationWindow win, Gdk.DragAction possible_actions);
		public string? get_source_filename (Gdk.DragContext context);
		public bool handle_file_drag_actions (Gtk.Widget dest_widget, Gtk.ApplicationWindow win, Gdk.DragContext context, GOF.File drop_target, GLib.List<GLib.File> drop_file_list, Gdk.DragAction possible_actions, Gdk.DragAction suggested_action, uint32 timestamp);
		public bool handle_netscape_url (Gdk.DragContext context, GOF.File drop_target, Gtk.SelectionData selection);
		public bool handle_xdnddirectsave (Gdk.DragContext context, GOF.File drop_target, Gtk.SelectionData selection);
		public void on_choice (GLib.Variant? param);
		public static bool selection_data_is_uri_list (Gtk.SelectionData selection_data, uint info, out string? text);
		public static void set_selection_data_from_file_list (Gtk.SelectionData selection_data, GLib.List<GOF.File> file_list, string prefix = "");
		public static void set_selection_text_from_file_list (Gtk.SelectionData selection_data, GLib.List<GOF.File> file_list, string prefix = "");
		public void set_source_uri (Gdk.DragContext context, string uri);
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public class FileConflictDialog : Gtk.Dialog {
		public enum ResponseType {
			SKIP,
			RENAME,
			REPLACE,
			NEWEST
		}
		public FileConflictDialog (Gtk.Window parent, GLib.File _source, GLib.File _destination, GLib.File _dest_dir);
		public bool apply_to_all { get; }
		public string new_name { owned get; }
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public class IconInfo : GLib.Object {
		public IconInfo ();
		public static void clear_caches ();
		public IconInfo.for_icon_info (Gtk.IconInfo icon_info);
		public IconInfo.for_pixbuf (Gdk.Pixbuf? pixbuf);
		public static Marlin.IconInfo? get_generic_icon (int size, int scale);
		public static Gtk.IconTheme get_icon_theme ();
		public Gdk.Pixbuf? get_pixbuf_nodefault ();
		public bool is_fallback ();
		public static uint loadable_icon_cache_info ();
		public static Marlin.IconInfo? lookup (GLib.Icon icon, int size, int scale);
		public static Marlin.IconInfo? lookup_from_name (string icon_name, int size, int scale);
		public static Marlin.IconInfo? lookup_from_path (string path, int size, int scale);
		public static void remove_cache (string path, int size, int scale);
		public static void set_reap_time (uint milliseconds);
		public static uint themed_icon_cache_info ();
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public class PluginManager : GLib.Object {
		[Version (deprecated = true, deprecated_since = "0.2", replacement = "Marlin.PluginManager.menuitem_references")]
		public GLib.List<Gtk.Widget>? menus;
		public PluginManager (string plugin_dir, uint user_id);
		public void directory_loaded (Gtk.ApplicationWindow window, GOF.AbstractSlot view, GOF.File directory);
		public Gee.List<string> get_available_plugins ();
		public void hook_context_menu (Gtk.Widget menu, GLib.List<GOF.File> files);
		public void interface_loaded (Gtk.Widget win);
		public void sidebar_loaded (Gtk.Widget widget);
		public void update_file_info (GOF.File file);
		public void update_sidebar (Gtk.Widget widget);
		public Gee.List<Gtk.Widget> menuitem_references { get; private set; }
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public class SidebarPluginItem : GLib.Object {
		public const Marlin.PlaceType PLACE_TYPE;
		public SidebarPluginItem ();
		public GLib.ActionGroup? action_group { get; set; }
		public string? action_group_namespace { get; set; }
		public GLib.Icon? action_icon { get; set; }
		public bool can_eject { get; set; }
		public Marlin.PluginCallbackFunc? cb { get; set; }
		public uint64 disk_size { get; set; }
		public GLib.Drive? drive { get; set; }
		public uint64 free_space { get; set; }
		public GLib.Icon? icon { get; set; }
		public uint index { get; set; }
		public GLib.MenuModel? menu_model { get; set; }
		public GLib.Mount? mount { get; set; }
		public string name { get; set; }
		public bool show_spinner { get; set; }
		public string? tooltip { get; set; }
		public string? uri { get; set; }
		public GLib.Volume? volume { get; set; }
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public class Thumbnailer : GLib.Object {
		public void dequeue (int request);
		public new static Marlin.Thumbnailer? @get ();
		public bool queue_file (GOF.File file, out int request, bool large);
		public bool queue_files (GLib.List<GOF.File> files, out int request, bool large);
		public signal void finished (uint request);
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public class TrashMonitor : GLib.Object {
		public const string URI;
		public TrashMonitor ();
		public static unowned Marlin.TrashMonitor get_default ();
		public GLib.Icon get_icon ();
		public bool is_empty { get; private set; }
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public class UndoActionData {
		public Marlin.UndoActionType action_type;
		public uint count;
		public uint32 current_permissions;
		public GLib.File dest_dir;
		public GLib.List<string> destinations;
		public uint32 dir_mask;
		public uint32 dir_permissions;
		public uint32 file_mask;
		public uint32 file_permissions;
		public bool freed;
		public bool is_valid;
		public bool locked;
		public string new_group_name_or_id;
		public uint32 new_permissions;
		public string new_uri;
		public string new_user_name_or_id;
		public string old_uri;
		public string original_group_name_or_id;
		public GLib.HashTable<string,uint32?> original_permissions;
		public string original_user_name_or_id;
		public string redo_description;
		public string redo_label;
		public GLib.List<string> sources;
		public GLib.File src_dir;
		public string target_uri;
		public string? template;
		public GLib.HashTable<string,uint64?> trashed;
		public string undo_description;
		public string undo_label;
		public UndoActionData (Marlin.UndoActionType action_type, int items_count);
		public void add_file_permissions (GLib.File file, uint32 permission);
		public void add_origin_target_pair (GLib.File origin, GLib.File target);
		public void add_trashed_file (GLib.File file, uint64 mtime);
		public void set_create_data (string target_uri, string? template);
		public void set_dest_dir (GLib.File dest);
		public void set_file_permissions (string uri, uint32 current_permissions, uint32 new_permissions);
		public void set_group_change_information (string uri, string current_group, string new_group);
		public void set_owner_change_information (string uri, string current_user, string new_user);
		public void set_recursive_permissions (uint32 file_permissions, uint32 file_mask, uint32 dir_permissions, uint32 dir_mask);
		public void set_rename_information (GLib.File old_file, GLib.File new_file);
		public void set_src_dir (GLib.File src);
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public class UndoManager : GLib.Object {
		public UndoManager ();
		public void add_action (owned Marlin.UndoActionData? action);
		public void add_rename_action (GLib.File renamed_file, string original_name);
		public bool can_redo ();
		public bool can_undo ();
		public static unowned Marlin.UndoManager instance ();
		public async bool redo (Gtk.Widget widget, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public void trash_has_emptied ();
		public async bool undo (Gtk.Widget widget, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public bool confirm_delete { get; set construct; }
		public uint undo_levels { get; set construct; }
		public bool undo_redo_flag { get; private set; }
		public signal void request_menu_update ();
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	[DBus (name = "org.freedesktop.thumbnails.Thumbnailer1")]
	public interface ThumbnailerDaemon : GLib.DBusProxy {
		public abstract async void dequeue (uint handle) throws GLib.DBusError, GLib.IOError;
		public abstract void get_supported (out string[] uri_schemes, out string[] mime_types) throws GLib.DBusError, GLib.IOError;
		public abstract async uint queue (string[] uris, string[] mime_types, string flavor, string scheduler, uint handle_to_unqueue) throws GLib.DBusError, GLib.IOError;
		public signal void error (uint handle, string[] failed_uris, int error_code, string message);
		public signal void finished (uint handle);
		public signal void ready (uint handle, string[] uris);
		public signal void started (uint handle);
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public struct RunSimpleDialogData {
		public weak Gtk.Window parent_window;
		public bool ignore_close_box;
		public Gtk.MessageType message_type;
		public string primary_text;
		public string secondary_text;
		public weak string? details_text;
		public string[] button_titles;
		public bool show_all;
		public int result;
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public enum IconSize {
		EMBLEM,
		SMALLEST,
		LARGE_EMBLEM,
		SMALLER,
		SMALL,
		NORMAL,
		LARGE,
		LARGER,
		HUGE,
		HUGER,
		LARGEST
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public enum OpenFlag {
		DEFAULT,
		NEW_ROOT,
		NEW_TAB,
		NEW_WINDOW,
		APP
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public enum PlaceType {
		BUILT_IN,
		MOUNTED_VOLUME,
		BOOKMARK,
		BOOKMARKS_CATEGORY,
		PERSONAL_CATEGORY,
		STORAGE_CATEGORY,
		NETWORK_CATEGORY,
		PLUGIN_ITEM
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public enum TargetType {
		STRING,
		TEXT_URI_LIST,
		XDND_DIRECT_SAVE0,
		NETSCAPE_URL
	}
	[CCode (cheader_filename = "pantheon-files-core.h", cprefix = "MARLIN_UNDO_")]
	public enum UndoActionType {
		COPY,
		DUPLICATE,
		MOVE,
		RENAME,
		CREATEEMPTYFILE,
		CREATEFILEFROMTEMPLATE,
		CREATEFOLDER,
		MOVETOTRASH,
		CREATELINK,
		RESTOREFROMTRASH,
		SETPERMISSIONS,
		RECURSIVESETPERMISSIONS,
		CHANGEOWNER,
		CHANGEGROUP
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public enum ViewMode {
		ICON,
		LIST,
		MILLER_COLUMNS,
		CURRENT,
		PREFERRED,
		INVALID
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public enum WindowState {
		NORMAL,
		TILED_START,
		TILED_END,
		MAXIMIZED,
		INVALID;
		public string to_string ();
		public static Marlin.WindowState from_gdk_window_state (Gdk.WindowState state, bool start = true);
		public bool is_tiled ();
		public bool is_maximized ();
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public enum ZoomLevel {
		SMALLEST,
		SMALLER,
		SMALL,
		NORMAL,
		LARGE,
		LARGER,
		HUGE,
		HUGER,
		LARGEST,
		N_LEVELS
	}
	[CCode (cheader_filename = "pantheon-files-core.h", has_target = false)]
	public delegate void PluginCallbackFunc (Gtk.Widget widget);
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string AFP_URI;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string DAVS_URI;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string DAV_URI;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string FTP_URI;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string MTP_URI;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string NETWORK_URI;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string PTP_URI;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string RECENT_URI;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string ROOT_FS_URI;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string SFTP_URI;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string SMB_URI;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string TRASH_URI;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public static Marlin.ZoomLevel zoom_level_get_nearest_from_value (int size);
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public static Marlin.IconSize zoom_level_to_icon_size (Marlin.ZoomLevel zoom_level);
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public static Gtk.IconSize zoom_level_to_stock_icon_size (Marlin.ZoomLevel zoom_level);
}
namespace GOF {
	namespace Directory {
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public class Async : GLib.Object {
			public enum State {
				NOT_LOADED,
				LOADING,
				LOADED,
				TIMED_OUT
			}
			public delegate void GOFFileLoadedFunc (GOF.File file);
			public int icon_size;
			public bool network_available;
			public bool permission_denied;
			public void block_monitor ();
			public static GOF.Directory.Async? cache_lookup (GLib.File? file);
			public static GOF.Directory.Async? cache_lookup_parent (GLib.File file);
			public void cancel ();
			public async bool check_network ();
			public GOF.File file_cache_find_or_insert (GLib.File file, bool update_hash = false);
			public void file_hash_add_file (GOF.File gof);
			public GOF.File? file_hash_lookup_location (GLib.File? location);
			public static GOF.Directory.Async from_file (GOF.File gof);
			public static GOF.Directory.Async from_gfile (GLib.File file);
			public GLib.File get_parent ();
			public unowned GLib.List<weak GOF.File>? get_sorted_dirs ();
			public bool has_parent ();
			public bool has_timed_out ();
			public void init (GOF.Directory.Async.GOFFileLoadedFunc? file_loaded_func = null);
			public bool is_empty ();
			public bool is_loaded ();
			public bool is_loading ();
			public void load_hiddens ();
			public static void notify_files_added (GLib.List<GLib.File> files);
			public static void notify_files_changed (GLib.List<GLib.File> files);
			public static void notify_files_moved (GLib.List<GLib.Array<GLib.File>> files);
			public static void notify_files_removed (GLib.List<GLib.File> files);
			public static bool purge_dir_from_cache (GOF.Directory.Async dir);
			public void reload ();
			public static bool remove_dir_from_cache (GOF.Directory.Async dir);
			public void unblock_monitor ();
			public void update_desktop_files ();
			public void update_files ();
			public bool allow_user_interaction { get; set; }
			public bool can_load { get; private set; }
			public bool can_open_files { get; private set; }
			public bool can_stream_files { get; private set; }
			public GLib.File creation_key { get; construct; }
			public uint displayed_files_count { get; private set; }
			public GOF.File file { get; private set; }
			public bool freeze_update { get; set; }
			public bool has_mounts { get; private set; }
			public bool has_trash_dirs { get; private set; }
			public bool is_cancelled { get; }
			public bool is_local { get; private set; }
			public bool is_network { get; private set; }
			public bool is_no_info { get; private set; }
			public bool is_recent { get; private set; }
			public bool is_trash { get; private set; }
			public string last_error_message { get; private set; }
			public bool loaded_from_cache { get; private set; }
			public GLib.File location { get; private set; }
			public string scheme { get; private set; }
			public GLib.File? selected_file { get; private set; }
			public GOF.Directory.Async.State state { get; private set; }
			public signal void done_loading ();
			public signal void file_added (GOF.File? file);
			public signal void file_changed (GOF.File file);
			public signal void file_deleted (GOF.File file);
			public signal void file_loaded (GOF.File file);
			public signal void icon_changed (GOF.File file);
			public signal void need_reload (bool original_request);
			public signal void thumbs_loaded ();
		}
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public abstract class AbstractSlot : GLib.Object {
		protected Gtk.Box content_box;
		protected Gtk.Box extra_action_widgets;
		protected Gtk.Box extra_location_widgets;
		protected int slot_number;
		protected int width;
		protected AbstractSlot ();
		public void add_extra_action_widget (Gtk.Widget widget);
		public void add_extra_widget (Gtk.Widget widget);
		public void add_overlay (Gtk.Widget widget);
		public abstract void close ();
		public abstract void focus_first_for_empty_selection (bool select);
		public virtual Gtk.Widget get_content_box ();
		public abstract unowned GOF.AbstractSlot? get_current_slot ();
		public virtual bool get_realized ();
		public virtual string? get_root_uri ();
		public abstract unowned GLib.List<GOF.File>? get_selected_files ();
		public virtual string? get_tip_uri ();
		public abstract void grab_focus ();
		public abstract void initialize_directory ();
		public abstract GLib.FileInfo? lookup_file_info (GLib.File loc);
		protected abstract void make_view ();
		public abstract void reload (bool non_local_only = false);
		public abstract void select_glib_files (GLib.List<GLib.File> locations, GLib.File? focus_location);
		public abstract void set_active_state (bool set_active, bool animate = true);
		public virtual bool set_all_selected (bool all_selected);
		public abstract void user_path_change_request (GLib.File loc, bool make_root);
		public virtual void zoom_in ();
		public virtual void zoom_normal ();
		public virtual void zoom_out ();
		public GOF.Directory.Async? directory { get; protected set; }
		public GOF.File file { get; }
		public virtual bool is_frozen { get; set; }
		public GLib.File location { get; }
		public virtual bool locked_focus { get; }
		public Gtk.Overlay overlay { get; protected set; }
		public string uri { get; }
		public signal void active (bool scroll = true, bool animate = true);
		public signal void directory_loaded (GOF.Directory.Async dir);
		public signal void inactive ();
		public signal void item_hovered (GOF.File? file);
		public signal void new_container_request (GLib.File loc, Marlin.OpenFlag flag);
		public signal void path_changed ();
		public signal void selection_changed (GLib.List<GOF.File> files);
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public class CallWhenReady : GLib.Object {
		public delegate void call_when_ready_func (GLib.List<GOF.File> files);
		public GLib.List<GOF.File> files;
		public CallWhenReady (GLib.List<GOF.File> _files, GOF.CallWhenReady.call_when_ready_func? _f = null);
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public class File : GLib.Object {
		public enum IconFlags {
			NONE,
			USE_THUMBNAILS
		}
		public enum ThumbState {
			UNKNOWN,
			NONE,
			READY,
			LOADING
		}
		[CCode (cname = "can_unmount")]
		public bool _can_unmount;
		public string basename;
		public int color;
		public string? custom_display_name;
		public string? custom_icon_name;
		public GLib.File directory;
		public GLib.List<string>? emblems_list;
		public bool exists;
		public GLib.FileType file_type;
		public string format_size;
		public string formated_modified;
		public string formated_type;
		public uint32 gid;
		public string group;
		public bool has_permissions;
		public int height;
		public GLib.Icon? icon;
		public GLib.FileInfo? info;
		public bool is_connected;
		public bool is_desktop;
		public bool is_directory;
		public bool is_expanded;
		public bool is_gone;
		public bool is_hidden;
		public bool is_mounted;
		public bool link_known_target;
		public GLib.File location;
		public uint64 modified;
		public GLib.Mount? mount;
		public string owner;
		public uint32 permissions;
		public Gdk.Pixbuf? pix;
		public int pix_scale;
		public int pix_size;
		public uint64 size;
		public int sort_column_id;
		public Gtk.SortType sort_order;
		public string tagstype;
		public GOF.File target_gof;
		public GLib.File target_location;
		public string thumbnail_path;
		public uint thumbstate;
		public time_t trash_time;
		public uint32 uid;
		public string uri;
		public string? utf8_collation_key;
		public int width;
		public const string GIO_DEFAULT_ATTRIBUTES;
		public File (GLib.File location, GLib.File? dir = null);
		public void add_emblem (string emblem);
		public static GOF.File cache_lookup (GLib.File file);
		public bool can_set_group ();
		public bool can_set_owner ();
		public bool can_set_permissions ();
		public bool can_unmount ();
		public int compare_by_display_name (GOF.File other);
		public int compare_for_sort (GOF.File other, int sort_type, bool directories_first, bool reversed);
		public bool ensure_query_info ();
		public bool execute (GLib.List<GLib.File>? files) throws GLib.Error;
		public new static GOF.File @get (GLib.File location);
		public static GOF.File? get_by_commandline_arg (string arg);
		public static GOF.File? get_by_uri (string uri);
		public GLib.AppInfo? get_default_handler ();
		public unowned string get_display_name ();
		public string get_display_target_uri ();
		public void get_folder_icon_from_uri_or_path ();
		public string? get_formated_time (string attr);
		public unowned string? get_ftype ();
		public Marlin.IconInfo? get_icon (int size, int scale, GOF.File.IconFlags flags);
		public Gdk.Pixbuf? get_icon_pixbuf (int size, int scale, GOF.File.IconFlags flags);
		public static GLib.Mount? get_mount_at (GLib.File location);
		public string get_permissions_as_string ();
		public GLib.List<string>? get_settable_group_names ();
		public unowned string? get_symlink_target ();
		public unowned GLib.File get_target_location ();
		public unowned string? get_thumbnail_path ();
		public bool is_desktop_file ();
		public bool is_executable ();
		public bool is_folder ();
		public bool is_image ();
		public bool is_mountable ();
		public bool is_network_uri_scheme ();
		public bool is_other_uri_scheme ();
		public bool is_readable ();
		public bool is_recent_uri_scheme ();
		public bool is_remote_uri_scheme ();
		public bool is_root_network_folder ();
		public bool is_smb_server ();
		public bool is_smb_share ();
		public bool is_smb_uri_scheme ();
		public bool is_symlink ();
		public bool is_trashed ();
		public bool is_writable ();
		public void query_thumbnail_update ();
		public void query_update ();
		public void remove_from_caches ();
		public void set_expanded (bool expanded);
		public void update ();
		public void update_desktop_file ();
		public void update_emblem ();
		public void update_icon (int size, int scale);
		public void update_trash_info ();
		public void update_type ();
		public signal void changed ();
		public signal void destroy ();
		public signal void icon_changed ();
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public class Preferences : GLib.Object {
		public const string?[] TAGS_COLORS;
		public Preferences ();
		public static GOF.Preferences get_default ();
		public string clock_format { get; set; }
		public bool confirm_trash { get; set; }
		public string date_format { get; set; }
		public bool force_icon_size { get; set; }
		public bool hide_local_thumbnails { get; set; }
		public bool remember_history { get; set; }
		public bool show_hidden_files { get; set; }
		public bool show_remote_thumbnails { get; set; }
		public bool sort_directories_first { get; set; }
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public static GOF.Preferences? preferences;
}
namespace PF {
	namespace Dialogs {
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static int run_simple_file_operation_dialog (Marlin.RunSimpleDialogData data);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static Granite.MessageDialog show_error_dialog (string primary_text, string secondary_text, Gtk.Window? parent);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static Granite.MessageDialog show_warning_dialog (string primary_text, string secondary_text, Gtk.Window? parent);
	}
	namespace FileUtils {
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static int compare_modification_dates (GLib.File a, GLib.File b);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static string? escape_uri (string uri, bool allow_utf8 = true, bool allow_single_quote = true);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static Gdk.DragAction file_accepts_drop (GOF.File dest, GLib.List<GLib.File> drop_file_list, Gdk.DragContext context, out Gdk.DragAction suggested_action_return);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static GLib.List<GLib.File> files_from_uris (string uris);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static uint16 get_default_port_for_protocol (string protocol);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static GLib.File? get_file_for_path (string? path);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static uint64 get_file_modification_time (GLib.File file);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static string get_formatted_date_time (GLib.DateTime? dt);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static string get_formatted_time_attribute_from_info (GLib.FileInfo info, string attr);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static bool get_is_tls_for_protocol (string protocol);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static string get_parent_path_from_path (string path, bool include_file_protocol = true);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static void get_rename_region (string filename, out int start_offset, out int end_offset, bool select_all);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static string get_smb_share_from_uri (string uri);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static GLib.KeyFile key_file_from_file (GLib.File file, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static bool location_is_in_trash (GLib.File location);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static bool path_has_parent (string new_path);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static void remove_thumbnail_paths_for_uri (string uri);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static void restore_files_from_trash (GLib.List<GOF.File> files, Gtk.Widget? widget);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static bool same_location (string uri_a, string uri_b);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static string sanitize_path (string? input_uri, string? input_current_uri = null, bool include_file_protocol = true);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static async GLib.File? set_file_display_name (GLib.File old_location, string new_name, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static void split_protocol_from_path (string path, out string protocol, out string new_path);
	}
	namespace PixbufUtils {
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static Gdk.Pixbuf colorize (Gdk.Pixbuf src, Gdk.RGBA color);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static Gdk.Pixbuf darken (Gdk.Pixbuf src, uint8 saturation, uint8 darken);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static Gdk.Pixbuf lighten (Gdk.Pixbuf src);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static Gdk.Pixbuf lucent (Gdk.Pixbuf src, uint percent);
	}
	namespace Progress {
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public class Info : GLib.Object {
			public Info ();
			public void cancel ();
			public void finish ();
			public void pause ();
			public void pulse_progress ();
			public void resume ();
			public void start ();
			public void take_details (owned string _details);
			public void take_status (owned string _status);
			public void update_progress (double current, double total);
			public bool activity_mode { get; private set; }
			public GLib.Cancellable cancellable { get; construct; }
			public double current { get; private set; }
			public string details { get; set; }
			public bool is_cancelled { get; }
			public bool is_finished { get; private set; }
			public bool is_paused { get; private set; }
			public bool is_started { get; private set; }
			public double progress { get; private set; }
			public string status { get; private set; }
			public string title { get; set; }
			public double total { get; private set; }
			public signal void changed ();
			public signal void finished ();
			public signal void progress_changed ();
			public signal void started ();
		}
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public class InfoManager : GLib.Object {
			public InfoManager ();
			public void add_new_info (PF.Progress.Info info);
			public Gee.LinkedList<PF.Progress.Info> get_all_infos ();
			public static PF.Progress.InfoManager get_instance ();
			public signal void new_progress_info (PF.Progress.Info info);
		}
	}
	namespace Sound {
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public const string DELETE;
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public const string EMPTY_TRASH;
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public const string THEME;
	}
	namespace UserUtils {
		[CCode (cheader_filename = "pantheon-files-core.h", cname = "NGROUPS_MAX")]
		public const int NGROUPS_MAX;
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static GLib.List<string> get_all_group_names ();
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static Posix.uid_t? get_group_id_from_group_name (string group_name);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static GLib.List<string> get_group_names_for_user ();
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static Posix.uid_t? get_id_from_digit_string (string digit_string);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static string get_real_user_home ();
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static unowned string? get_user_home_from_user_uid (Posix.uid_t uid);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static Posix.uid_t? get_user_id_from_user_name (string user_name);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static GLib.List<string> get_user_names ();
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static bool user_in_group (string group_name);
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public class ConnectServerDialog : Gtk.Dialog {
		public ConnectServerDialog (Gtk.Window window);
		public async bool fill_details_async (GLib.MountOperation mount_operation, string default_user, string default_domain, GLib.AskPasswordFlags askpassword_flags);
		public string server_uri { get; private set; }
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public class SoundManager : GLib.Object {
		public static unowned PF.SoundManager get_instance ();
		public void play_delete_sound ();
		public void play_empty_trash_sound ();
		public void play_sound (string pf_sound_id);
	}
}
[CCode (cheader_filename = "pantheon-files-core.h")]
public const string CANCEL;
[CCode (cheader_filename = "pantheon-files-core.h")]
public const string DELETE;
[CCode (cheader_filename = "pantheon-files-core.h")]
public const string SKIP;
[CCode (cheader_filename = "pantheon-files-core.h")]
public const string SKIP_ALL;
[CCode (cheader_filename = "pantheon-files-core.h")]
public const string RETRY;
[CCode (cheader_filename = "pantheon-files-core.h")]
public const string DELETE_ALL;
[CCode (cheader_filename = "pantheon-files-core.h")]
public const string REPLACE;
[CCode (cheader_filename = "pantheon-files-core.h")]
public const string REPLACE_ALL;
[CCode (cheader_filename = "pantheon-files-core.h")]
public const string MERGE;
[CCode (cheader_filename = "pantheon-files-core.h")]
public const string MERGE_ALL;
[CCode (cheader_filename = "pantheon-files-core.h")]
public const string COPY_FORCE;
[CCode (cheader_filename = "pantheon-files-core.h")]
public const string EMPTY_TRASH;
[CCode (cheader_filename = "pantheon-files-core.h")]
public static Marlin.PluginManager plugins;
